{"vars":[{"name":"base","kind":2,"containerName":"","line":84},{"detail":"($self,@args)","definition":"sub","name":"sub_Location","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"sub_Location","line":98},{"line":98,"name":"@args","kind":13,"containerName":"sub_Location"},{"name":"$self","containerName":"sub_Location","kind":13,"line":99},{"containerName":"sub_Location","kind":12,"name":"throw_not_implemented","line":99}],"signature":{"label":"sub_Location($self,@args)","documentation":"1;\n# $Id: SplitLocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::SplitLocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::SplitLocationI - Abstract interface of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n  # get a SplitLocationI somehow\n    print $splitlocation->start, \"..\", $splitlocation->end, \"\\n\";\n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start }  @sublocs ) {\n\t\tprintf \"sub feature %d [%d..%d]\\n\", $location->start,$location->end;\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis interface encapsulates the necessary methods for representing the\nlocation of a sequence feature that has more that just a single\nstart/end pair.  Some examples of this are the annotated exons in a\ngene or the annotated CDS in a sequence file.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::SplitLocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::LocationI);\n\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @locations = $feat->sub_Location();\n Function: Returns an array of LocationI objects\n Returns : An array\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"range":{"start":{"character":0,"line":97},"end":{"character":9999,"line":100}},"kind":12,"line":97},{"detail":"($self)","definition":"sub","name":"splittype","containerName":"main::","children":[{"definition":"my","line":113,"name":"$self","kind":13,"localvar":"my","containerName":"splittype"},{"line":114,"name":"$self","containerName":"splittype","kind":13},{"line":114,"name":"throw_not_implemented","kind":12,"containerName":"splittype"}],"signature":{"label":"splittype($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SplitLocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::SplitLocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::SplitLocationI - Abstract interface of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n  # get a SplitLocationI somehow\n    print $splitlocation->start, \"..\", $splitlocation->end, \"\\n\";\n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start }  @sublocs ) {\n\t\tprintf \"sub feature %d [%d..%d]\\n\", $location->start,$location->end;\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis interface encapsulates the necessary methods for representing the\nlocation of a sequence feature that has more that just a single\nstart/end pair.  Some examples of this are the annotated exons in a\ngene or the annotated CDS in a sequence file.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::SplitLocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::LocationI);\n\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @locations = $feat->sub_Location();\n Function: Returns an array of LocationI objects\n Returns : An array\n Args    : none\n\n\nsub sub_Location {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $fuzzy->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set"},"range":{"start":{"character":0,"line":112},"end":{"line":115,"character":9999}},"kind":12,"line":112},{"line":133,"kind":12,"range":{"end":{"character":9999,"line":136},"start":{"character":0,"line":133}},"signature":{"label":"is_single_sequence($self)","documentation":"1;\n# $Id: SplitLocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::SplitLocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::SplitLocationI - Abstract interface of a Location on a Sequence\nwhich has multiple locations (start/end points)\n\n=head1 SYNOPSIS\n\n  # get a SplitLocationI somehow\n    print $splitlocation->start, \"..\", $splitlocation->end, \"\\n\";\n    my @sublocs = $splitlocation->sub_Location();\n\n    my $count = 1;\n    # print the start/end points of the sub locations\n    foreach my $location ( sort { $a->start <=> $b->start }  @sublocs ) {\n\t\tprintf \"sub feature %d [%d..%d]\\n\", $location->start,$location->end;\n        $count++;\n    }\n\n=head1 DESCRIPTION\n\nThis interface encapsulates the necessary methods for representing the\nlocation of a sequence feature that has more that just a single\nstart/end pair.  Some examples of this are the annotated exons in a\ngene or the annotated CDS in a sequence file.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::SplitLocationI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::LocationI);\n\n\n=head2 sub_Location\n\n Title   : sub_Location\n Usage   : @locations = $feat->sub_Location();\n Function: Returns an array of LocationI objects\n Returns : An array\n Args    : none\n\n\nsub sub_Location {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 splittype\n\n  Title   : splittype\n  Usage   : $splittype = $fuzzy->splittype();\n  Function: get/set the split splittype\n  Returns : the splittype of split feature (join, order)\n  Args    : splittype to set\n\n\nsub splittype {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 is_single_sequence\n\n  Title   : is_single_sequence\n  Usage   : if($splitloc->is_single_sequence()) {\n                print \"Location object $splitloc is split \".\n                      \"but only across a single sequence\\n\";\n\t    }\n  Function: Determine whether this location is split across a single or\n            multiple sequences.\n  Returns : TRUE if all sublocations lie on the same sequence as the root\n            location (feature), and FALSE otherwise.\n  Args    : none","parameters":[{"label":"$self"}]},"children":[{"definition":"my","line":134,"name":"$self","containerName":"is_single_sequence","localvar":"my","kind":13},{"line":135,"kind":13,"containerName":"is_single_sequence","name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"is_single_sequence","line":135}],"containerName":"main::","name":"is_single_sequence","definition":"sub","detail":"($self)"}],"version":5}