{"vars":[{"signature":{"documentation":"1;\n# $Id: Gene.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::Gene - Range abstract class for LiveSeq\n\n=head1 SYNOPSIS\n\n  # documentation needed\n\n=head1 DESCRIPTION\n\nThis is used as storage for all object references concerning a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::Gene;\nuse strict;\nuse Carp;\nuse Bio::LiveSeq::Prim_Transcript; # needed to create maxtranscript obj\n\n=head2 new\n\n  Title   : new\n  Usage   : $gene = Bio::LiveSeq::Gene->new(-name => \"name\",\n                                            -features => $hashref\n                                            -upbound => $min\n                                            -downbound => $max);\n\n  Function: generates a new Bio::LiveSeq::Gene\n  Returns : reference to a new object of class Gene\n  Errorcode -1\n  Args    : one string and one hashreference containing all features defined\n            for the Gene and the references to the LiveSeq objects for those\n            features.\n            Two labels for defining boundaries of the gene. Usually the\n            boundaries will reflect max span of transcript, exon... features,\n            while the DNA sequence will be created with some flanking regions\n            (e.g. with the EMBL_SRS::gene2liveseq routine).\n            If these two labels are not given, they will default to the start\n            and end of the DNA object.\n  Note    : the format of the hash has to be like\n               DNA => reference to LiveSeq::DNA object\n               Transcripts => reference to array of transcripts objrefs\n               Transclations => reference to array of transcripts objrefs\n               Exons => ....\n               Introns => ....\n               Prim_Transcripts => ....\n               Repeat_Units => ....\n               Repeat_Regions => ....\n            Only DNA and Transcripts are mandatory","parameters":[{"label":"$thing"},{"label":"%args"}],"label":"new($thing,%args)"},"range":{"end":{"character":9999,"line":89},"start":{"character":0,"line":77}},"kind":12,"line":77,"detail":"($thing,%args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","name":"$thing","localvar":"my","kind":13,"containerName":"new","line":78},{"line":78,"containerName":"new","kind":13,"name":"%args"},{"line":79,"containerName":"new","localvar":"my","kind":13,"name":"$class","definition":"my"},{"name":"$thing","containerName":"new","kind":13,"line":79},{"line":79,"name":"$thing","kind":13,"containerName":"new"},{"kind":13,"localvar":"my","containerName":"new","name":"$i","line":80,"definition":"my"},{"name":"$self","kind":13,"containerName":"new","line":80},{"line":80,"name":"%gene","kind":13,"containerName":"new"},{"name":"$name","localvar":"my","containerName":"new","kind":13,"line":82,"definition":"my"},{"containerName":"new","kind":13,"name":"$inputfeatures","line":82},{"line":82,"containerName":"new","kind":13,"name":"$upbound"},{"containerName":"new","kind":13,"name":"$downbound","line":82},{"line":82,"kind":13,"containerName":"new","name":"$args"},{"line":82,"containerName":"new","kind":13,"name":"$args"},{"line":82,"containerName":"new","kind":13,"name":"$args"},{"name":"$args","containerName":"new","kind":13,"line":82},{"name":"$inputfeatures","kind":13,"containerName":"new","line":84},{"line":89,"name":"%features","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"$inputfeatures","line":89}]},{"kind":2,"containerName":"Carp::Bio::LiveSeq","name":"Prim_Transcript","line":78},{"name":"carp","kind":12,"line":85},{"name":"$features","kind":13,"localvar":"my","containerName":null,"line":90,"definition":"my"},{"line":90,"containerName":null,"kind":13,"name":"%features"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$DNA","line":92},{"line":92,"kind":13,"containerName":null,"name":"%features"},{"line":93,"name":"%DNA","kind":13,"containerName":null},{"line":94,"kind":12,"name":"carp"},{"name":"$minstart","localvar":"my","kind":13,"containerName":null,"line":98,"definition":"my"},{"containerName":null,"kind":13,"name":"$maxend","line":98},{"definition":"my","name":"$start","localvar":"my","kind":13,"containerName":null,"line":100},{"line":100,"containerName":null,"kind":13,"name":"$end"},{"name":"@Transcripts","kind":13,"localvar":"my","containerName":null,"line":102,"definition":"my"},{"line":102,"containerName":null,"kind":13,"name":"%features"},{"definition":"my","line":104,"name":"$strand","kind":13,"localvar":"my","containerName":null},{"name":"@Transcripts","kind":13,"containerName":null,"line":105},{"name":"$self","containerName":null,"kind":13,"line":106},{"name":"warn","containerName":"main::","kind":12,"line":106},{"name":"$strand","containerName":null,"kind":13,"line":109},{"kind":13,"containerName":null,"name":"@Transcripts","line":109},{"line":109,"name":"strand","kind":12,"containerName":"main::"},{"line":112,"name":"$i","kind":13,"containerName":null},{"line":112,"name":"@Transcripts","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$start","line":113},{"line":113,"kind":13,"containerName":null,"name":"$end"},{"line":113,"containerName":null,"kind":13,"name":"$i"},{"line":113,"kind":12,"containerName":"main::","name":"start"},{"containerName":null,"kind":13,"name":"$i","line":113},{"line":113,"kind":12,"containerName":"main::","name":"end"},{"line":114,"name":"$i","containerName":null,"kind":13},{"line":114,"containerName":null,"kind":13,"name":"$DNA"},{"containerName":"main::","kind":12,"name":"valid","line":114},{"line":114,"kind":13,"containerName":null,"name":"$start"},{"kind":13,"containerName":null,"name":"$DNA","line":114},{"name":"valid","containerName":"main::","kind":12,"line":114},{"name":"%end","containerName":null,"kind":13,"line":114},{"line":115,"name":"$self","kind":13,"containerName":null},{"line":115,"containerName":"main::","kind":12,"name":"warn"},{"containerName":null,"kind":13,"name":"%minstart","line":119},{"line":119,"kind":13,"containerName":null,"name":"$minstart"},{"line":119,"containerName":null,"kind":13,"name":"$start"},{"kind":13,"containerName":null,"name":"%maxend","line":120},{"line":120,"name":"$maxend","containerName":null,"kind":13},{"line":120,"name":"$end","kind":13,"containerName":null},{"name":"$i","kind":13,"containerName":null,"line":121},{"line":121,"kind":12,"containerName":"main::","name":"strand"},{"kind":13,"containerName":null,"name":"%strand","line":121},{"line":122,"kind":13,"containerName":null,"name":"$self"},{"line":122,"name":"warn","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$strand","line":125},{"line":125,"containerName":null,"kind":13,"name":"$start"},{"line":125,"name":"$minstart","containerName":null,"kind":13},{"line":125,"containerName":null,"kind":13,"name":"$strand"},{"kind":13,"containerName":null,"name":"$start","line":125},{"line":125,"containerName":null,"kind":13,"name":"%minstart"},{"line":125,"containerName":null,"kind":13,"name":"$minstart"},{"name":"$start","containerName":null,"kind":13,"line":125},{"kind":13,"containerName":null,"name":"$strand","line":126},{"containerName":null,"kind":13,"name":"$end","line":126},{"line":126,"kind":13,"containerName":null,"name":"$maxend"},{"line":126,"name":"$strand","containerName":null,"kind":13},{"line":126,"kind":13,"containerName":null,"name":"$end"},{"line":126,"name":"%maxend","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$maxend","line":126},{"line":126,"name":"$end","containerName":null,"kind":13},{"line":128,"name":"@Translations","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"kind":13,"localvar":"my","containerName":null,"name":"@Introns","line":128,"definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@Repeat_Units","line":128},{"name":"@Repeat_Regions","localvar":"my","kind":13,"containerName":null,"line":128,"definition":"my"},{"definition":"my","line":129,"containerName":null,"localvar":"my","kind":13,"name":"@Prim_Transcripts"},{"definition":"my","line":129,"name":"@Exons","localvar":"my","kind":13,"containerName":null},{"line":130,"name":"%features","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@Translations","line":131},{"line":131,"kind":13,"containerName":null,"name":"%features"},{"line":132,"name":"%features","containerName":null,"kind":13},{"name":"@Exons","containerName":null,"kind":13,"line":133},{"line":133,"containerName":null,"kind":13,"name":"%features"},{"kind":13,"containerName":null,"name":"%features","line":134},{"line":135,"kind":13,"containerName":null,"name":"@Introns"},{"line":135,"kind":13,"containerName":null,"name":"%features"},{"name":"%features","containerName":null,"kind":13,"line":136},{"kind":13,"containerName":null,"name":"@Repeat_Units","line":137},{"name":"%features","kind":13,"containerName":null,"line":137},{"line":138,"containerName":null,"kind":13,"name":"%features"},{"line":139,"name":"@Repeat_Regions","kind":13,"containerName":null},{"line":139,"containerName":null,"kind":13,"name":"%features"},{"name":"%features","kind":13,"containerName":null,"line":140},{"name":"@Prim_Transcripts","containerName":null,"kind":13,"line":141},{"name":"%features","containerName":null,"kind":13,"line":141},{"line":144,"containerName":null,"kind":13,"name":"@Translations"},{"line":145,"kind":13,"containerName":null,"name":"$i"},{"line":145,"kind":13,"containerName":null,"name":"@Translations"},{"containerName":null,"kind":13,"name":"$start","line":146},{"name":"$end","containerName":null,"kind":13,"line":146},{"kind":13,"containerName":null,"name":"$i","line":146},{"line":146,"name":"start","containerName":"main::","kind":12},{"name":"$i","containerName":null,"kind":13,"line":146},{"kind":12,"containerName":"main::","name":"end","line":146},{"name":"$i","containerName":null,"kind":13,"line":147},{"line":147,"kind":13,"containerName":null,"name":"$DNA"},{"line":147,"name":"valid","containerName":"main::","kind":12},{"name":"$start","kind":13,"containerName":null,"line":147},{"kind":13,"containerName":null,"name":"$DNA","line":147},{"line":147,"name":"valid","kind":12,"containerName":"main::"},{"name":"%end","kind":13,"containerName":null,"line":147},{"kind":13,"containerName":null,"name":"$self","line":148},{"containerName":"main::","kind":12,"name":"warn","line":148},{"containerName":null,"kind":13,"name":"@Exons","line":153},{"containerName":null,"kind":13,"name":"$i","line":154},{"name":"@Exons","containerName":null,"kind":13,"line":154},{"line":155,"name":"$start","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$end","line":155},{"line":155,"name":"$i","containerName":null,"kind":13},{"line":155,"name":"start","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$i","line":155},{"name":"end","kind":12,"containerName":"main::","line":155},{"line":156,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"$DNA","line":156},{"line":156,"name":"valid","containerName":"main::","kind":12},{"line":156,"name":"$start","kind":13,"containerName":null},{"line":156,"name":"$DNA","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"valid","line":156},{"line":156,"containerName":null,"kind":13,"name":"%end"},{"name":"$self","containerName":null,"kind":13,"line":157},{"kind":12,"containerName":"main::","name":"warn","line":157},{"kind":13,"containerName":null,"name":"$i","line":160},{"kind":12,"containerName":"main::","name":"strand","line":160},{"line":160,"containerName":null,"kind":13,"name":"%strand"},{"name":"$self","containerName":null,"kind":13,"line":161},{"kind":12,"containerName":"main::","name":"warn","line":161},{"line":164,"containerName":null,"kind":13,"name":"$strand"},{"name":"$start","containerName":null,"kind":13,"line":164},{"line":164,"kind":13,"containerName":null,"name":"$minstart"},{"name":"$strand","kind":13,"containerName":null,"line":164},{"name":"$start","containerName":null,"kind":13,"line":164},{"name":"%minstart","kind":13,"containerName":null,"line":164},{"kind":13,"containerName":null,"name":"$minstart","line":164},{"line":164,"name":"$start","kind":13,"containerName":null},{"line":165,"containerName":null,"kind":13,"name":"$strand"},{"line":165,"name":"$end","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$maxend","line":165},{"line":165,"name":"$strand","kind":13,"containerName":null},{"name":"$end","kind":13,"containerName":null,"line":165},{"name":"%maxend","kind":13,"containerName":null,"line":165},{"name":"$maxend","containerName":null,"kind":13,"line":165},{"kind":13,"containerName":null,"name":"$end","line":165},{"line":168,"kind":13,"containerName":null,"name":"@Introns"},{"line":169,"name":"$i","containerName":null,"kind":13},{"name":"@Introns","kind":13,"containerName":null,"line":169},{"line":170,"name":"$start","containerName":null,"kind":13},{"line":170,"name":"$end","kind":13,"containerName":null},{"line":170,"containerName":null,"kind":13,"name":"$i"},{"line":170,"name":"start","containerName":"main::","kind":12},{"name":"$i","containerName":null,"kind":13,"line":170},{"name":"end","kind":12,"containerName":"main::","line":170},{"kind":13,"containerName":null,"name":"$i","line":171},{"line":171,"name":"$DNA","containerName":null,"kind":13},{"name":"valid","containerName":"main::","kind":12,"line":171},{"kind":13,"containerName":null,"name":"$start","line":171},{"line":171,"name":"$DNA","containerName":null,"kind":13},{"name":"valid","containerName":"main::","kind":12,"line":171},{"kind":13,"containerName":null,"name":"%end","line":171},{"name":"$self","containerName":null,"kind":13,"line":172},{"kind":12,"containerName":"main::","name":"warn","line":172},{"line":177,"containerName":null,"kind":13,"name":"@Repeat_Units"},{"line":178,"name":"$i","kind":13,"containerName":null},{"line":178,"kind":13,"containerName":null,"name":"@Repeat_Units"},{"name":"$start","kind":13,"containerName":null,"line":179},{"name":"$end","kind":13,"containerName":null,"line":179},{"line":179,"kind":13,"containerName":null,"name":"$i"},{"line":179,"name":"start","containerName":"main::","kind":12},{"line":179,"containerName":null,"kind":13,"name":"$i"},{"line":179,"containerName":"main::","kind":12,"name":"end"},{"line":180,"name":"$i","containerName":null,"kind":13},{"name":"$DNA","containerName":null,"kind":13,"line":180},{"name":"valid","kind":12,"containerName":"main::","line":180},{"name":"$start","containerName":null,"kind":13,"line":180},{"containerName":null,"kind":13,"name":"$DNA","line":180},{"containerName":"main::","kind":12,"name":"valid","line":180},{"line":180,"kind":13,"containerName":null,"name":"%end"},{"name":"$self","containerName":null,"kind":13,"line":181},{"name":"warn","kind":12,"containerName":"main::","line":181},{"name":"@Repeat_Regions","containerName":null,"kind":13,"line":186},{"line":187,"name":"$i","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@Repeat_Regions","line":187},{"line":188,"name":"$start","containerName":null,"kind":13},{"line":188,"containerName":null,"kind":13,"name":"$end"},{"line":188,"name":"$i","containerName":null,"kind":13},{"name":"start","kind":12,"containerName":"main::","line":188},{"line":188,"kind":13,"containerName":null,"name":"$i"},{"line":188,"kind":12,"containerName":"main::","name":"end"},{"containerName":null,"kind":13,"name":"$i","line":189},{"line":189,"name":"$DNA","containerName":null,"kind":13},{"line":189,"kind":12,"containerName":"main::","name":"valid"},{"line":189,"containerName":null,"kind":13,"name":"$start"},{"line":189,"name":"$DNA","containerName":null,"kind":13},{"line":189,"name":"valid","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"%end","line":189},{"name":"$self","containerName":null,"kind":13,"line":190},{"name":"warn","kind":12,"containerName":"main::","line":190},{"line":195,"kind":13,"containerName":null,"name":"@Prim_Transcripts"},{"kind":13,"containerName":null,"name":"$i","line":196},{"line":196,"containerName":null,"kind":13,"name":"@Prim_Transcripts"},{"line":197,"name":"$start","containerName":null,"kind":13},{"line":197,"containerName":null,"kind":13,"name":"$end"},{"line":197,"kind":13,"containerName":null,"name":"$i"},{"line":197,"kind":12,"containerName":"main::","name":"start"},{"line":197,"name":"$i","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"end","line":197},{"line":198,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"containerName":null,"name":"$DNA","line":198},{"line":198,"name":"valid","containerName":"main::","kind":12},{"line":198,"name":"$start","kind":13,"containerName":null},{"line":198,"containerName":null,"kind":13,"name":"$DNA"},{"line":198,"name":"valid","kind":12,"containerName":"main::"},{"line":198,"containerName":null,"kind":13,"name":"%end"},{"name":"$self","containerName":null,"kind":13,"line":199},{"line":199,"containerName":"main::","kind":12,"name":"warn"},{"kind":13,"containerName":null,"name":"$i","line":202},{"line":202,"name":"strand","kind":12,"containerName":"main::"},{"line":202,"containerName":null,"kind":13,"name":"%strand"},{"line":203,"containerName":null,"kind":13,"name":"$self"},{"line":203,"kind":12,"containerName":"main::","name":"warn"},{"containerName":null,"kind":13,"name":"$strand","line":206},{"name":"$start","containerName":null,"kind":13,"line":206},{"line":206,"kind":13,"containerName":null,"name":"$minstart"},{"containerName":null,"kind":13,"name":"$strand","line":206},{"line":206,"kind":13,"containerName":null,"name":"$start"},{"containerName":null,"kind":13,"name":"%minstart","line":206},{"name":"$minstart","kind":13,"containerName":null,"line":206},{"kind":13,"containerName":null,"name":"$start","line":206},{"name":"$strand","kind":13,"containerName":null,"line":207},{"line":207,"kind":13,"containerName":null,"name":"$end"},{"line":207,"name":"$maxend","kind":13,"containerName":null},{"name":"$strand","containerName":null,"kind":13,"line":207},{"line":207,"containerName":null,"kind":13,"name":"$end"},{"name":"%maxend","containerName":null,"kind":13,"line":207},{"line":207,"name":"$maxend","containerName":null,"kind":13},{"name":"$end","containerName":null,"kind":13,"line":207},{"name":"@allfeatures","localvar":"my","kind":13,"containerName":null,"line":213,"definition":"my"},{"line":214,"name":"@allfeatures","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$DNA","line":214},{"line":214,"kind":13,"containerName":null,"name":"@Transcripts"},{"line":214,"name":"@Translations","containerName":null,"kind":13},{"name":"@Exons","kind":13,"containerName":null,"line":214},{"line":214,"name":"@Introns","containerName":null,"kind":13},{"line":214,"name":"@Repeat_Units","kind":13,"containerName":null},{"line":214,"kind":13,"containerName":null,"name":"@Repeat_Regions"},{"containerName":null,"kind":13,"name":"@Prim_Transcripts","line":214},{"name":"%multiplicity","localvar":"my","containerName":null,"kind":13,"line":217,"definition":"my"},{"name":"$key","kind":13,"localvar":"my","containerName":null,"line":218,"definition":"my"},{"definition":"my","line":218,"name":"@array","localvar":"my","kind":13,"containerName":null},{"line":219,"containerName":null,"kind":13,"name":"$key"},{"kind":13,"containerName":null,"name":"%features","line":219},{"containerName":null,"kind":13,"name":"%key","line":220},{"line":221,"containerName":null,"kind":13,"name":"@array"},{"line":221,"kind":13,"containerName":null,"name":"%features"},{"name":"$key","kind":13,"containerName":null,"line":221},{"line":222,"name":"%multiplicity","containerName":null,"kind":13},{"line":222,"name":"$key","kind":13,"containerName":null},{"line":222,"kind":13,"containerName":null,"name":"@array"},{"kind":13,"containerName":null,"name":"%multiplicity","line":225},{"line":225,"kind":12,"name":"DNA"},{"line":234,"localvar":"my","containerName":null,"kind":13,"name":"$maxtranscript","definition":"my"},{"line":234,"name":"Bio","containerName":"LiveSeq::Prim_Transcript","kind":12},{"name":"new","kind":12,"containerName":"main::","line":234},{"kind":13,"containerName":null,"name":"$minstart","line":234},{"kind":13,"containerName":null,"name":"$maxend","line":234},{"containerName":null,"kind":13,"name":"$strand","line":234},{"line":234,"kind":13,"containerName":null,"name":"$DNA"},{"line":238,"kind":13,"containerName":null,"name":"%upbound"},{"name":"$DNA","containerName":null,"kind":13,"line":239},{"line":239,"name":"valid","kind":12,"containerName":"main::"},{"name":"%upbound","containerName":null,"kind":13,"line":239},{"kind":13,"containerName":null,"name":"$self","line":240},{"containerName":"main::","kind":12,"name":"warn","line":240},{"line":244,"containerName":null,"kind":13,"name":"$upbound"},{"line":244,"name":"$DNA","containerName":null,"kind":13},{"line":244,"name":"start","kind":12,"containerName":"main::"},{"line":246,"name":"%downbound","kind":13,"containerName":null},{"name":"$DNA","containerName":null,"kind":13,"line":247},{"line":247,"name":"valid","containerName":"main::","kind":12},{"name":"%downbound","kind":13,"containerName":null,"line":247},{"name":"$self","containerName":null,"kind":13,"line":248},{"line":248,"containerName":"main::","kind":12,"name":"warn"},{"kind":13,"containerName":null,"name":"$downbound","line":252},{"line":252,"name":"$DNA","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"end","line":252},{"line":255,"containerName":null,"kind":13,"name":"%gene"},{"line":255,"kind":12,"name":"name"},{"line":255,"name":"$name","kind":13,"containerName":null},{"line":255,"kind":12,"name":"features"},{"kind":13,"containerName":null,"name":"$features","line":255},{"name":"multiplicity","kind":12,"line":255},{"line":255,"name":"%multiplicity","kind":13,"containerName":null},{"line":256,"name":"upbound","kind":12},{"kind":13,"containerName":null,"name":"$upbound","line":256},{"line":256,"name":"downbound","kind":12},{"line":256,"kind":13,"containerName":null,"name":"$downbound"},{"kind":12,"name":"allfeatures","line":256},{"containerName":null,"kind":13,"name":"@allfeatures","line":256},{"name":"maxtranscript","kind":12,"line":256},{"name":"$maxtranscript","containerName":null,"kind":13,"line":256},{"containerName":null,"kind":13,"name":"$self","line":257},{"line":257,"name":"%gene","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":258},{"name":"$self","kind":13,"containerName":null,"line":258},{"name":"$class","containerName":null,"kind":13,"line":258},{"name":"_set_Gene_in_all","kind":12,"line":259},{"name":"$self","containerName":null,"kind":13,"line":259},{"line":259,"name":"@allfeatures","containerName":null,"kind":13},{"line":260,"kind":13,"containerName":null,"name":"$self"},{"line":265,"kind":12,"range":{"end":{"character":9999,"line":271},"start":{"character":0,"line":265}},"children":[{"definition":"my","line":266,"name":"$Gene","containerName":"_set_Gene_in_all","localvar":"my","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"_set_Gene_in_all","name":"$self","line":267},{"line":268,"containerName":"_set_Gene_in_all","kind":13,"name":"$self"},{"containerName":"_set_Gene_in_all","kind":13,"name":"$self","line":269},{"kind":12,"containerName":"_set_Gene_in_all","name":"gene","line":269},{"name":"$Gene","kind":13,"containerName":"_set_Gene_in_all","line":269}],"name":"_set_Gene_in_all","containerName":"main::","definition":"sub"},{"containerName":"main::","name":"name","children":[{"name":"$self","containerName":"name","localvar":"my","kind":13,"line":275,"definition":"my"},{"name":"$value","kind":13,"containerName":"name","line":275},{"line":276,"name":"$value","containerName":"name","kind":13},{"containerName":"name","kind":13,"name":"$self","line":277},{"name":"$value","containerName":"name","kind":13,"line":277},{"name":"$self","kind":13,"containerName":"name","line":279},{"line":282,"name":"$self","kind":13,"containerName":"name"}],"detail":"($self,$value)","definition":"sub","range":{"end":{"character":9999,"line":284},"start":{"line":274,"character":0}},"kind":12,"line":274,"signature":{"label":"name($self,$value)","documentation":" you can get or set the name of the gene","parameters":[{"label":"$self"},{"label":"$value"}]}},{"kind":12,"range":{"start":{"character":0,"line":287},"end":{"line":290,"character":9999}},"line":287,"definition":"sub","name":"features","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"features","line":288},{"containerName":"features","kind":13,"name":"$self","line":289}]},{"definition":"sub","children":[{"line":292,"containerName":"get_DNA","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"get_DNA","line":293}],"containerName":"main::","name":"get_DNA","line":291,"range":{"end":{"line":294,"character":9999},"start":{"line":291,"character":0}},"kind":12},{"definition":"sub","name":"get_Transcripts","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"get_Transcripts","kind":13,"line":296},{"line":297,"kind":13,"containerName":"get_Transcripts","name":"$self"}],"range":{"end":{"character":9999,"line":298},"start":{"character":0,"line":295}},"kind":12,"line":295},{"range":{"end":{"character":9999,"line":302},"start":{"line":299,"character":0}},"kind":12,"line":299,"definition":"sub","containerName":"main::","name":"get_Translations","children":[{"line":300,"localvar":"my","containerName":"get_Translations","kind":13,"name":"$self","definition":"my"},{"containerName":"get_Translations","kind":13,"name":"$self","line":301}]},{"children":[{"name":"$self","containerName":"get_Prim_Transcripts","localvar":"my","kind":13,"line":304,"definition":"my"},{"name":"$self","containerName":"get_Prim_Transcripts","kind":13,"line":305}],"name":"get_Prim_Transcripts","containerName":"main::","definition":"sub","line":303,"kind":12,"range":{"end":{"line":306,"character":9999},"start":{"character":0,"line":303}}},{"line":307,"range":{"end":{"line":310,"character":9999},"start":{"line":307,"character":0}},"kind":12,"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"get_Repeat_Units","name":"$self","line":308},{"line":309,"containerName":"get_Repeat_Units","kind":13,"name":"$self"}],"containerName":"main::","name":"get_Repeat_Units","definition":"sub"},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"get_Repeat_Regions","line":312},{"name":"$self","kind":13,"containerName":"get_Repeat_Regions","line":313}],"containerName":"main::","name":"get_Repeat_Regions","definition":"sub","line":311,"range":{"end":{"character":9999,"line":314},"start":{"line":311,"character":0}},"kind":12},{"definition":"sub","containerName":"main::","name":"get_Introns","children":[{"containerName":"get_Introns","localvar":"my","kind":13,"name":"$self","line":316,"definition":"my"},{"kind":13,"containerName":"get_Introns","name":"$self","line":317}],"range":{"start":{"character":0,"line":315},"end":{"line":318,"character":9999}},"kind":12,"line":315},{"definition":"sub","children":[{"line":320,"kind":13,"localvar":"my","containerName":"get_Exons","name":"$self","definition":"my"},{"kind":13,"containerName":"get_Exons","name":"$self","line":321}],"name":"get_Exons","containerName":"main::","line":319,"range":{"end":{"line":322,"character":9999},"start":{"line":319,"character":0}},"kind":12},{"children":[{"line":324,"name":"$self","kind":13,"localvar":"my","containerName":"featuresnum","definition":"my"},{"line":325,"name":"$self","kind":13,"containerName":"featuresnum"}],"name":"featuresnum","containerName":"main::","definition":"sub","line":323,"kind":12,"range":{"end":{"character":9999,"line":326},"start":{"line":323,"character":0}}},{"line":327,"kind":12,"range":{"end":{"character":9999,"line":330},"start":{"character":0,"line":327}},"children":[{"line":328,"name":"$self","containerName":"upbound","localvar":"my","kind":13,"definition":"my"},{"line":329,"kind":13,"containerName":"upbound","name":"$self"}],"containerName":"main::","name":"upbound","definition":"sub"},{"range":{"start":{"line":331,"character":0},"end":{"character":9999,"line":334}},"kind":12,"line":331,"containerName":"main::","name":"downbound","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"downbound","line":332},{"line":333,"containerName":"downbound","kind":13,"name":"$self"}],"definition":"sub"},{"definition":"sub","children":[{"containerName":"printfeaturesnum","localvar":"my","kind":13,"name":"$self","line":336,"definition":"my"},{"line":337,"name":"$key","localvar":"my","containerName":"printfeaturesnum","kind":13,"definition":"my"},{"name":"$value","containerName":"printfeaturesnum","kind":13,"line":337},{"definition":"my","localvar":"my","kind":13,"containerName":"printfeaturesnum","name":"%hash","line":338},{"kind":13,"containerName":"printfeaturesnum","name":"$self","line":338},{"line":338,"name":"featuresnum","containerName":"printfeaturesnum","kind":12}],"containerName":"main::","name":"printfeaturesnum","line":335,"kind":12,"range":{"start":{"line":335,"character":0},"end":{"character":9999,"line":338}}},{"line":339,"containerName":null,"kind":13,"name":"$key"},{"line":339,"name":"%hash","kind":13,"containerName":null},{"line":340,"name":"$value","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%hash","line":340},{"line":340,"containerName":null,"kind":13,"name":"$key"},{"line":344,"range":{"end":{"character":9999,"line":347},"start":{"line":344,"character":0}},"kind":12,"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"maxtranscript","name":"$self","line":345},{"name":"$self","kind":13,"containerName":"maxtranscript","line":346}],"name":"maxtranscript","containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","name":"delete_Obj","children":[{"definition":"my","localvar":"my","containerName":"delete_Obj","kind":13,"name":"$self","line":350},{"definition":"my","line":351,"name":"@values","localvar":"my","kind":13,"containerName":"delete_Obj"},{"line":351,"kind":13,"containerName":"delete_Obj","name":"$self"}],"kind":12,"range":{"start":{"line":349,"character":0},"end":{"line":351,"character":9999}},"line":349},{"line":352,"name":"@keys","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":352,"name":"$self","containerName":null,"kind":13},{"containerName":null,"localvar":"my","kind":13,"name":"$key","line":354,"definition":"my"},{"name":"@keys","kind":13,"containerName":null,"line":354},{"name":"%self","containerName":null,"kind":13,"line":355},{"containerName":null,"kind":13,"name":"$key","line":355},{"definition":"my","line":357,"name":"$value","localvar":"my","kind":13,"containerName":null},{"line":357,"name":"@values","containerName":null,"kind":13},{"line":358,"name":"%value","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$value","line":361},{"line":361,"name":"delete_Obj","containerName":"main::","kind":12},{"line":363,"kind":13,"containerName":null,"name":"%value"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@array","line":364},{"line":364,"name":"$value","containerName":null,"kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$element","line":365},{"kind":13,"containerName":null,"name":"$element","line":366},{"line":366,"kind":13,"containerName":null,"name":"@array"},{"line":368,"containerName":null,"kind":13,"name":"$element"},{"containerName":"main::","kind":12,"name":"delete_Obj","line":368},{"line":371,"name":"%value","containerName":null,"kind":13},{"line":372,"containerName":null,"localvar":"my","kind":13,"name":"%hash","definition":"my"},{"line":372,"kind":13,"containerName":null,"name":"$value"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$element","line":373},{"kind":13,"containerName":null,"name":"$element","line":374},{"containerName":null,"kind":13,"name":"%hash","line":374},{"line":376,"name":"$element","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"delete_Obj","line":376},{"line":412,"kind":12,"range":{"start":{"line":412,"character":0},"end":{"line":416,"character":9999}},"children":[{"definition":"my","line":413,"name":"$self","localvar":"my","kind":13,"containerName":"verbose"},{"kind":13,"localvar":"my","containerName":"verbose","name":"$value","line":414,"definition":"my"},{"containerName":"verbose","kind":13,"name":"$self","line":415},{"kind":12,"containerName":"verbose","name":"verbose","line":415},{"line":415,"kind":13,"containerName":"verbose","name":"$value"}],"name":"verbose","containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":422},"start":{"character":0,"line":418}},"kind":12,"line":418,"name":"warn","containerName":"main::","children":[{"definition":"my","line":419,"kind":13,"localvar":"my","containerName":"warn","name":"$self"},{"definition":"my","line":420,"kind":13,"localvar":"my","containerName":"warn","name":"$value"},{"line":421,"kind":13,"containerName":"warn","name":"$self"},{"name":"warn","containerName":"warn","kind":12,"line":421},{"line":421,"kind":13,"containerName":"warn","name":"$value"}],"definition":"sub"}],"version":5}