{"version":5,"vars":[{"line":113,"name":"base","kind":2,"containerName":""},{"definition":"sub","containerName":"main::","name":"_version","children":[],"kind":12,"range":{"end":{"character":9999,"line":116},"start":{"character":0,"line":115}},"line":115},{"kind":12,"range":{"start":{"line":142,"character":0},"end":{"character":9999,"line":148}},"line":142,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.","label":"new($class,@args)"},"name":"new","containerName":"main::","children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":144,"definition":"my"},{"line":144,"containerName":"new","kind":13,"name":"@args"},{"line":146,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":146,"containerName":"new","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":146}],"detail":"($class,@args)","definition":"sub"},{"line":144,"containerName":"Root::Version::VERSION","kind":12,"name":"Bio"},{"kind":12,"containerName":"new","name":"SUPER","line":146},{"range":{"end":{"character":9999,"line":172},"start":{"character":0,"line":165}},"kind":12,"line":165,"signature":{"documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Stockholm implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $align = $idx->fetch_report($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id","parameters":[{"label":"$self"},{"label":"$id"}],"label":"fetch_report($self,$id)"},"containerName":"main::","name":"fetch_report","children":[{"definition":"my","localvar":"my","containerName":"fetch_report","kind":13,"name":"$self","line":166},{"line":166,"kind":13,"containerName":"fetch_report","name":"$id"},{"definition":"my","name":"$fh","localvar":"my","containerName":"fetch_report","kind":13,"line":167},{"kind":13,"containerName":"fetch_report","name":"$self","line":167},{"line":167,"kind":12,"containerName":"fetch_report","name":"get_stream"},{"name":"$id","containerName":"fetch_report","kind":13,"line":167},{"line":168,"name":"$report","localvar":"my","kind":13,"containerName":"fetch_report","definition":"my"},{"containerName":"fetch_report","kind":12,"name":"new","line":168},{"containerName":"fetch_report","kind":13,"name":"$fh","line":170},{"line":171,"name":"$report","kind":13,"containerName":"fetch_report"},{"line":171,"kind":12,"containerName":"fetch_report","name":"next_aln"}],"detail":"($self,$id)","definition":"sub"},{"kind":12,"containerName":"AlignIO","name":"Bio","line":168},{"definition":"sub","detail":"($self,$file,$i)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_index_file","line":206},{"name":"$file","containerName":"_index_file","kind":13,"line":207},{"kind":13,"containerName":"_index_file","name":"$i","line":208},{"line":211,"name":"$begin","containerName":"_index_file","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$BLAST","localvar":"my","kind":13,"containerName":"_index_file","line":215},{"line":215,"containerName":"_index_file","kind":13,"name":"$file"},{"line":215,"containerName":"_index_file","kind":13,"name":"$self"},{"line":215,"name":"throw","kind":12,"containerName":"_index_file"},{"line":216,"localvar":"my","containerName":"_index_file","kind":13,"name":"$indexpoint","definition":"my"},{"definition":"my","name":"$lastline","containerName":"_index_file","localvar":"my","kind":13,"line":217},{"line":218,"name":"$BLAST","containerName":"_index_file","kind":13},{"line":220,"containerName":"_index_file","kind":13,"name":"$indexpoint"},{"line":220,"kind":13,"containerName":"_index_file","name":"$BLAST"},{"line":221,"kind":13,"containerName":"_index_file","name":"$self"},{"name":"debug","containerName":"_index_file","kind":12,"line":221},{"definition":"my","localvar":"my","containerName":"_index_file","kind":13,"name":"$id","line":224},{"line":224,"name":"$self","kind":13,"containerName":"_index_file"},{"name":"id_parser","containerName":"_index_file","kind":12,"line":224},{"line":225,"name":"$self","containerName":"_index_file","kind":13},{"line":225,"kind":12,"containerName":"_index_file","name":"debug"}],"containerName":"main::","name":"_index_file","signature":{"label":"_index_file($self,$file,$i)","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Stockholm implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $align = $idx->fetch_report($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::AlignIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t-format => 'stockholm',\n\t\t\t\t\t\t            -fh => $fh);\n\treturn $report->next_aln;\n}\n\n=head2 fetch_aln\n\n Title   : fetch_aln\n Usage   : my $align = $idx->fetch_aln($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n Note    : alias for fetch_report\n\n\n*fetch_aln = \\&fetch_report;\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : "},"line":205,"range":{"start":{"character":0,"line":205},"end":{"line":230,"character":9999}},"kind":12},{"line":254,"kind":12,"range":{"end":{"character":9999,"line":261},"start":{"line":254,"character":0}},"signature":{"label":"id_parser($self,$code)","documentation":"1;\n# $Id: Stockholm.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# BioPerl module for Bio::Index::Stockholm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Stockholm - Indexes Stockholm format alignments (such as those from\nPfam and Rfam.  Retrieves raw stream data using the ID or a Bio::SimpleAlign\n(via Bio::AlignIO)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::Stockholm;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Stockholm->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    # get raw data stream starting at alignment position\n    my $fh = $index->get_stream($query);\n\n    # fetch individual alignment\n    my $align = $index->fetch_aln($query); # alias for fetch_report\n    my $align = $index->fetch_report($query); # same as above\n    print \"query is \", $align->display_id, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index for any file (or files)\ncontaining Stockholm alignment format (such as Rfam and Pfam) and provides\nquick access to the alignment based on the alignment ID.\n\nThis also allows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.  The default is to use\nthe alignment ID provided for Rfam/Pfam output.\n\nNote: for best results 'use strict'.\n\n=head1 TODO\n\n- allow using an alternative regex for indexing (for instance, the ID instead of AC)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Stockholm;\nuse strict;\nuse Bio::AlignIO;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Stockholm implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $align = $idx->fetch_report($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::AlignIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t-format => 'stockholm',\n\t\t\t\t\t\t            -fh => $fh);\n\treturn $report->next_aln;\n}\n\n=head2 fetch_aln\n\n Title   : fetch_aln\n Usage   : my $align = $idx->fetch_aln($id);\n Function: Returns a Bio::SimpleAlign object \n           for a specific alignment\n Returns : Bio::SimpleAlign\n Args    : valid id\n Note    : alias for fetch_report\n\n\n*fetch_aln = \\&fetch_report;\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy( $self,\n\t\t $file, # File name\n\t\t $i,    # Index-number of file being indexed\n\t  ) = @_;\n\n\tmy( $begin,  # Offset from start of file of the start\n\t\t          # of the last found record.\n\t  );\n    local $/ =\"\\n\";\n\topen(my $BLAST, '<', $file) or $self->throw(\"cannot open file $file\\n\");\n\tmy $indexpoint = 0;\n\tmy $lastline = 0;\n\twhile( <$BLAST> ) {\n\t\tif(m{^#\\sSTOCKHOLM} ) {\n            $indexpoint = tell($BLAST)-length $_;\n            $self->debug(\"Index:$indexpoint\\n\")\n\t\t}\n        if(m{^#=GF\\s+AC\\s+(\\S[^\\n]+)}) {\n            foreach my $id ($self->id_parser()->($1)) {\n\t\t\t\t$self->debug(\"id is $id, begin is $indexpoint\\n\");\n\t\t\t\t#$self->add_record($id, $i, $indexpoint);\n\t\t\t}\n        }\n\t}\n}\n\n# shamelessly stolen from Bio::Index::Fasta\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of IDs (for instance,\n            custom stockholm-formated files). \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fasta\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}]},"children":[{"localvar":"my","kind":13,"containerName":"id_parser","name":"$self","line":255,"definition":"my"},{"line":255,"containerName":"id_parser","kind":13,"name":"$code"},{"line":257,"name":"$code","containerName":"id_parser","kind":13},{"line":258,"containerName":"id_parser","kind":13,"name":"$self"},{"line":258,"name":"$code","kind":13,"containerName":"id_parser"},{"line":260,"name":"$self","kind":13,"containerName":"id_parser"}],"name":"id_parser","containerName":"main::","definition":"sub","detail":"($self,$code)"},{"line":260,"name":"default_id_parser","kind":12},{"definition":"sub","containerName":"main::","name":"default_id_parser","children":[],"range":{"end":{"character":9999,"line":282},"start":{"line":275,"character":0}},"kind":12,"line":275}]}