{"vars":[{"name":"base","containerName":"","kind":2,"line":125},{"children":[],"name":"_version","containerName":"main::","definition":"sub","line":127,"range":{"end":{"character":9999,"line":129},"start":{"character":0,"line":127}},"kind":12},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"line":155,"localvar":"my","containerName":"new","kind":13,"name":"$class","definition":"my"},{"line":155,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":156},{"name":"$class","kind":13,"containerName":"new","line":156},{"name":"@args","containerName":"new","kind":13,"line":156}],"signature":{"documentation":"1;\n#\n# BioPerl module for Bio::Index::Hmmer\n# \n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Josh Lauricha <laurichj@bioinfo.ucr.edu>\n#\n# Copyright Josh Lauricha\n# Unless otherwise noted, this was shamelessly ripped from \n# Bio::Index::Blast\n#\n# You may distribute this module under the terms of perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Hmmer - indexes HMMER reports and supports retreival based on query\n\n=head1 SYNOPSIS\n\n\t# Complete Code for indexing a set of report files\n\t#!/usr/bin/perl -w\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 1\n\t);\n\t$index->make_index(@ARGV);\n\n\n\t# Complete code for fetching a report\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 0\n\t);\n\n\tforeach my $id (@ARGV) {\n\t\tmy $report = $index->fetch_report($id);\n\t\tprint \"Query: \", $report->query_name(), \"\\n\";\n\t\twhile( my $hit = $report->next_hit() ) {\n\t\t\tprint \"\\tHit Name: \", $hit->name(), \"\\n\";\n\t\t\twhile( my $hsp = $hit->next_domain() ) {\n\t\t\t\tprint \"\\t\\tE-Value: \", $hsp->evalue(), \"\\n\";\n\t\t\t}\n\t\t}\n\t}\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a HMMER file (or files)\nand provide quick access to the HMMER report for that accession.\nFor best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Josh Lauricha\n\nEmail laurichj@bioinfo.ucr.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Hmmer;\nuse strict;\n\nuse Bio::SearchIO;\nuse IO::String;\nuse Bio::Root::Version;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version\n{\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n Usage   : $index = Bio::Index::Hmmer->new(\n               -filename    => $dbm_file,\n               -write_flag  => 0,\n               -dbm_package => 'DB_File',\n               -verbose     => 0\n           );\n Function: Returns a new index object.  If filename is\n specified, then open_dbm() is immediately called.\n Returns : A new index object\n Args    : -filename    The name of the dbm index file.\n           -write_flag  TRUE if write access to the dbm file is\n                        needed.\n           -dbm_package The Perl dbm module to use for the\n                        index.\n           -verbose     Print debugging output to STDERR if\n                        TRUE.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"range":{"end":{"character":9999,"line":157},"start":{"line":153,"character":0}},"kind":12,"line":153},{"containerName":"Root::Version::VERSION","kind":12,"name":"Bio","line":155},{"line":156,"kind":12,"containerName":"new","name":"SUPER"},{"children":[{"line":176,"kind":13,"localvar":"my","containerName":"fetch_report","name":"$self","definition":"my"},{"line":176,"kind":13,"containerName":"fetch_report","name":"$id"},{"definition":"my","line":177,"name":"@header","localvar":"my","containerName":"fetch_report","kind":13},{"line":177,"kind":13,"containerName":"fetch_report","name":"@data"},{"line":177,"kind":13,"containerName":"fetch_report","name":"$line"},{"definition":"my","line":178,"containerName":"fetch_report","localvar":"my","kind":13,"name":"$fh"},{"line":178,"name":"$self","kind":13,"containerName":"fetch_report"},{"line":178,"name":"get_stream","containerName":"fetch_report","kind":12},{"line":178,"kind":13,"containerName":"fetch_report","name":"$id"},{"definition":"my","line":179,"localvar":"my","kind":13,"containerName":"fetch_report","name":"$pos"},{"line":179,"containerName":"fetch_report","kind":13,"name":"$fh"},{"name":"$fh","containerName":"fetch_report","kind":13,"line":181},{"name":"$line","kind":13,"containerName":"fetch_report","line":182},{"name":"$fh","kind":13,"containerName":"fetch_report","line":182},{"line":183,"kind":13,"containerName":"fetch_report","name":"@header"},{"line":183,"kind":13,"containerName":"fetch_report","name":"$line"},{"line":184,"kind":13,"containerName":"fetch_report","name":"$line"},{"line":186,"name":"$fh","containerName":"fetch_report","kind":13},{"kind":13,"containerName":"fetch_report","name":"$pos","line":186},{"line":189,"containerName":"fetch_report","kind":13,"name":"$fh"},{"line":190,"name":"@data","kind":13,"containerName":"fetch_report"},{"name":"$rfh","localvar":"my","kind":13,"containerName":"fetch_report","line":195,"definition":"my"},{"containerName":"fetch_report","kind":13,"name":"@header","line":195},{"kind":13,"containerName":"fetch_report","name":"@data","line":195},{"containerName":"fetch_report","localvar":"my","kind":13,"name":"$report","line":196,"definition":"my"},{"line":196,"kind":12,"containerName":"fetch_report","name":"new"},{"kind":13,"containerName":"fetch_report","name":"$rfh","line":200},{"line":201,"name":"$report","kind":13,"containerName":"fetch_report"},{"containerName":"fetch_report","kind":12,"name":"next_result","line":201}],"name":"fetch_report","containerName":"main::","definition":"sub","detail":"($self,$id)","line":174,"range":{"end":{"character":9999,"line":202},"start":{"line":174,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n#\n# BioPerl module for Bio::Index::Hmmer\n# \n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Josh Lauricha <laurichj@bioinfo.ucr.edu>\n#\n# Copyright Josh Lauricha\n# Unless otherwise noted, this was shamelessly ripped from \n# Bio::Index::Blast\n#\n# You may distribute this module under the terms of perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Hmmer - indexes HMMER reports and supports retreival based on query\n\n=head1 SYNOPSIS\n\n\t# Complete Code for indexing a set of report files\n\t#!/usr/bin/perl -w\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 1\n\t);\n\t$index->make_index(@ARGV);\n\n\n\t# Complete code for fetching a report\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 0\n\t);\n\n\tforeach my $id (@ARGV) {\n\t\tmy $report = $index->fetch_report($id);\n\t\tprint \"Query: \", $report->query_name(), \"\\n\";\n\t\twhile( my $hit = $report->next_hit() ) {\n\t\t\tprint \"\\tHit Name: \", $hit->name(), \"\\n\";\n\t\t\twhile( my $hsp = $hit->next_domain() ) {\n\t\t\t\tprint \"\\t\\tE-Value: \", $hsp->evalue(), \"\\n\";\n\t\t\t}\n\t\t}\n\t}\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a HMMER file (or files)\nand provide quick access to the HMMER report for that accession.\nFor best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Josh Lauricha\n\nEmail laurichj@bioinfo.ucr.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Hmmer;\nuse strict;\n\nuse Bio::SearchIO;\nuse IO::String;\nuse Bio::Root::Version;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version\n{\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n Usage   : $index = Bio::Index::Hmmer->new(\n               -filename    => $dbm_file,\n               -write_flag  => 0,\n               -dbm_package => 'DB_File',\n               -verbose     => 0\n           );\n Function: Returns a new index object.  If filename is\n specified, then open_dbm() is immediately called.\n Returns : A new index object\n Args    : -filename    The name of the dbm index file.\n           -write_flag  TRUE if write access to the dbm file is\n                        needed.\n           -dbm_package The Perl dbm module to use for the\n                        index.\n           -verbose     Print debugging output to STDERR if\n                        TRUE.\n\n\nsub new\n{\n\tmy($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n}\n\n=head2 Bio::Index::Hmmer implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $report = $idx->fetch_report($id);\n Function: Returns a Bio::Search::Result::HMMERResult report object\n           for a specific HMMER report\n Returns : Bio::Search::Result::HMMERResult\n Args    : valid id","label":"fetch_report($self,$id)"}},{"containerName":"String","kind":12,"name":"IO","line":195},{"kind":12,"containerName":"SearchIO","name":"Bio","line":196},{"signature":{"documentation":"1;\n#\n# BioPerl module for Bio::Index::Hmmer\n# \n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Josh Lauricha <laurichj@bioinfo.ucr.edu>\n#\n# Copyright Josh Lauricha\n# Unless otherwise noted, this was shamelessly ripped from \n# Bio::Index::Blast\n#\n# You may distribute this module under the terms of perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Hmmer - indexes HMMER reports and supports retreival based on query\n\n=head1 SYNOPSIS\n\n\t# Complete Code for indexing a set of report files\n\t#!/usr/bin/perl -w\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 1\n\t);\n\t$index->make_index(@ARGV);\n\n\n\t# Complete code for fetching a report\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 0\n\t);\n\n\tforeach my $id (@ARGV) {\n\t\tmy $report = $index->fetch_report($id);\n\t\tprint \"Query: \", $report->query_name(), \"\\n\";\n\t\twhile( my $hit = $report->next_hit() ) {\n\t\t\tprint \"\\tHit Name: \", $hit->name(), \"\\n\";\n\t\t\twhile( my $hsp = $hit->next_domain() ) {\n\t\t\t\tprint \"\\t\\tE-Value: \", $hsp->evalue(), \"\\n\";\n\t\t\t}\n\t\t}\n\t}\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a HMMER file (or files)\nand provide quick access to the HMMER report for that accession.\nFor best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Josh Lauricha\n\nEmail laurichj@bioinfo.ucr.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Hmmer;\nuse strict;\n\nuse Bio::SearchIO;\nuse IO::String;\nuse Bio::Root::Version;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version\n{\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n Usage   : $index = Bio::Index::Hmmer->new(\n               -filename    => $dbm_file,\n               -write_flag  => 0,\n               -dbm_package => 'DB_File',\n               -verbose     => 0\n           );\n Function: Returns a new index object.  If filename is\n specified, then open_dbm() is immediately called.\n Returns : A new index object\n Args    : -filename    The name of the dbm index file.\n           -write_flag  TRUE if write access to the dbm file is\n                        needed.\n           -dbm_package The Perl dbm module to use for the\n                        index.\n           -verbose     Print debugging output to STDERR if\n                        TRUE.\n\n\nsub new\n{\n\tmy($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n}\n\n=head2 Bio::Index::Hmmer implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $report = $idx->fetch_report($id);\n Function: Returns a Bio::Search::Result::HMMERResult report object\n           for a specific HMMER report\n Returns : Bio::Search::Result::HMMERResult\n Args    : valid id\n\n\nsub fetch_report\n{\n\tmy ($self, $id) = @_;\n\tmy (@header, @data, $line);\n\tmy  $fh = $self->get_stream($id);\n\tmy  $pos = tell($fh);\n\n\tseek($fh, 0, 0); # The HMMER SearchIO wants the header, so we fetch it\n\twhile($line = <$fh>) {\n\t\tpush @header, $line; \n\t\tlast if $line =~ /Query sequence:/o;\n\t}\n\tseek($fh, $pos, 0);\n\n\t# Then the data\n\twhile(<$fh>) {\n\t\tpush @data, $_ if defined;\n\t\tlast if m{//}o;\n\t}\n\n\t# Then join them and send\n\tmy $rfh = new IO::String(join('', @header, @data));\n\tmy $report = Bio::SearchIO->new(\n\t\t-noclose => 1,\n\t\t-format  => 'hmmer',\n\t\t-fh      => $rfh\n\t);\n\treturn $report->next_result();\n}\n\n# shamelessly stolen from Bio::Index::Fasta\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of blast dbs. \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fasta\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE","parameters":[{"label":"$self"},{"label":"$code"}],"label":"id_parser($self,$code)"},"kind":12,"range":{"end":{"line":233,"character":9999},"start":{"character":0,"line":225}},"line":225,"detail":"($self,$code)","definition":"sub","containerName":"main::","name":"id_parser","children":[{"line":227,"name":"$self","localvar":"my","kind":13,"containerName":"id_parser","definition":"my"},{"line":227,"name":"$code","containerName":"id_parser","kind":13},{"kind":13,"containerName":"id_parser","name":"$code","line":229},{"containerName":"id_parser","kind":13,"name":"$self","line":230},{"containerName":"id_parser","kind":13,"name":"$code","line":230},{"kind":13,"containerName":"id_parser","name":"$self","line":232}]},{"kind":12,"name":"default_id_parser","line":232},{"range":{"end":{"character":9999,"line":254},"start":{"line":247,"character":0}},"kind":12,"line":247,"containerName":"main::","name":"default_id_parser","children":[],"definition":"sub"},{"signature":{"documentation":"1;\n#\n# BioPerl module for Bio::Index::Hmmer\n# \n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Josh Lauricha <laurichj@bioinfo.ucr.edu>\n#\n# Copyright Josh Lauricha\n# Unless otherwise noted, this was shamelessly ripped from \n# Bio::Index::Blast\n#\n# You may distribute this module under the terms of perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Hmmer - indexes HMMER reports and supports retreival based on query\n\n=head1 SYNOPSIS\n\n\t# Complete Code for indexing a set of report files\n\t#!/usr/bin/perl -w\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 1\n\t);\n\t$index->make_index(@ARGV);\n\n\n\t# Complete code for fetching a report\n\tuse strict;\n\tuse Bio::Index::Hmmer;\n\tmy $indexfile = shift;\n\tmy $index = Bio::Index::Hmmer->new(\n\t\t-filename => $indexfile,\n\t\t-write_flag => 0\n\t);\n\n\tforeach my $id (@ARGV) {\n\t\tmy $report = $index->fetch_report($id);\n\t\tprint \"Query: \", $report->query_name(), \"\\n\";\n\t\twhile( my $hit = $report->next_hit() ) {\n\t\t\tprint \"\\tHit Name: \", $hit->name(), \"\\n\";\n\t\t\twhile( my $hsp = $hit->next_domain() ) {\n\t\t\t\tprint \"\\t\\tE-Value: \", $hsp->evalue(), \"\\n\";\n\t\t\t}\n\t\t}\n\t}\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a HMMER file (or files)\nand provide quick access to the HMMER report for that accession.\nFor best results 'use strict'.\n\nYou can also set or customize the unique key used to retrieve by \nwriting your own function and calling the id_parser() method.\nFor example:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^KW\\s+([A-Z]+)/i;\n      $1;\n   }\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Josh Lauricha\n\nEmail laurichj@bioinfo.ucr.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::Hmmer;\nuse strict;\n\nuse Bio::SearchIO;\nuse IO::String;\nuse Bio::Root::Version;\n\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version\n{\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n Usage   : $index = Bio::Index::Hmmer->new(\n               -filename    => $dbm_file,\n               -write_flag  => 0,\n               -dbm_package => 'DB_File',\n               -verbose     => 0\n           );\n Function: Returns a new index object.  If filename is\n specified, then open_dbm() is immediately called.\n Returns : A new index object\n Args    : -filename    The name of the dbm index file.\n           -write_flag  TRUE if write access to the dbm file is\n                        needed.\n           -dbm_package The Perl dbm module to use for the\n                        index.\n           -verbose     Print debugging output to STDERR if\n                        TRUE.\n\n\nsub new\n{\n\tmy($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n}\n\n=head2 Bio::Index::Hmmer implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $report = $idx->fetch_report($id);\n Function: Returns a Bio::Search::Result::HMMERResult report object\n           for a specific HMMER report\n Returns : Bio::Search::Result::HMMERResult\n Args    : valid id\n\n\nsub fetch_report\n{\n\tmy ($self, $id) = @_;\n\tmy (@header, @data, $line);\n\tmy  $fh = $self->get_stream($id);\n\tmy  $pos = tell($fh);\n\n\tseek($fh, 0, 0); # The HMMER SearchIO wants the header, so we fetch it\n\twhile($line = <$fh>) {\n\t\tpush @header, $line; \n\t\tlast if $line =~ /Query sequence:/o;\n\t}\n\tseek($fh, $pos, 0);\n\n\t# Then the data\n\twhile(<$fh>) {\n\t\tpush @data, $_ if defined;\n\t\tlast if m{//}o;\n\t}\n\n\t# Then join them and send\n\tmy $rfh = new IO::String(join('', @header, @data));\n\tmy $report = Bio::SearchIO->new(\n\t\t-noclose => 1,\n\t\t-format  => 'hmmer',\n\t\t-fh      => $rfh\n\t);\n\treturn $report->next_result();\n}\n\n# shamelessly stolen from Bio::Index::Fasta\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of blast dbs. \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fasta\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE\n\n\nsub id_parser\n{\n\tmy( $self, $code ) =@_;\n\n\tif ($code) {\n\t\t$self->{'_id_parser'} = $code;\n\t}\n\treturn $self->{'_id_parser'} || \\&default_id_parser;\n}\n\n=head2 default_id_parser\n\n  Title   : default_id_parser\n  Usage   : $id = default_id_parser( $header )\n  Function: The default Blast Query ID parser for Bio::Index::Blast.pm\n            Returns $1 from applying the regexp /^>\\s*(\\S+)/\n            to $header.\n  Returns : ID string\n  Args    : a header line string\n\n\nsub default_id_parser\n{\n\tif ($_[0] =~ /^\\s*(\\S+)/) {\n\t\treturn $1;\n\t} else {\n\t\treturn;\n\t}\n}\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index HMMER report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"label":"_index_file($self,$file,$i)"},"kind":12,"range":{"start":{"line":274,"character":0},"end":{"character":9999,"line":294}},"line":274,"detail":"($self,$file,$i)","definition":"sub","name":"_index_file","containerName":"main::","children":[{"definition":"my","line":275,"name":"$self","localvar":"my","kind":13,"containerName":"_index_file"},{"kind":13,"containerName":"_index_file","name":"$file","line":275},{"line":275,"kind":13,"containerName":"_index_file","name":"$i"},{"definition":"my","line":276,"name":"$begin","localvar":"my","kind":13,"containerName":"_index_file"},{"line":278,"name":"$HMMER","localvar":"my","containerName":"_index_file","kind":13,"definition":"my"},{"line":278,"name":"$file","kind":13,"containerName":"_index_file"},{"kind":13,"containerName":"_index_file","name":"$self","line":278},{"containerName":"_index_file","kind":12,"name":"throw","line":278},{"definition":"my","line":280,"kind":13,"localvar":"my","containerName":"_index_file","name":"$id"},{"line":281,"kind":13,"localvar":"my","containerName":"_index_file","name":"$indexpoint","definition":"my"},{"name":"$HMMER","containerName":"_index_file","kind":13,"line":283},{"line":285,"name":"$indexpoint","kind":13,"containerName":"_index_file"},{"line":285,"name":"$HMMER","kind":13,"containerName":"_index_file"},{"name":"$id","containerName":"_index_file","localvar":"my","kind":13,"line":286,"definition":"my"},{"name":"$self","kind":13,"containerName":"_index_file","line":286},{"line":286,"name":"id_parser","kind":12,"containerName":"_index_file"},{"name":"$self","containerName":"_index_file","kind":13,"line":287},{"name":"verbose","kind":12,"containerName":"_index_file","line":287},{"line":288,"name":"$self","containerName":"_index_file","kind":13},{"containerName":"_index_file","kind":12,"name":"add_record","line":288},{"line":288,"name":"$id","containerName":"_index_file","kind":13},{"line":288,"name":"$i","kind":13,"containerName":"_index_file"},{"name":"$indexpoint","containerName":"_index_file","kind":13,"line":288},{"containerName":"_index_file","kind":13,"name":"$HMMER","line":292}]}],"version":5}