{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":96},{"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"object_id","line":116},{"line":117,"kind":13,"containerName":"object_id","name":"$self"},{"kind":12,"containerName":"object_id","name":"throw_not_implemented","line":117}],"containerName":"main::","name":"object_id","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IdentifiableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::IdentifiableI - interface for objects with identifiers\n\n=head1 SYNOPSIS\n\n    # to test this is an identifiable object\n\n    $obj->isa(\"Bio::IdentifiableI\") ||\n      $obj->throw(\"$obj does not implement the Bio::IdentifiableI interface\");\n\n    # Accessors\n\n    $object_id = $obj->object_id();\n    $namespace = $obj->namespace();\n    $authority = $obj->authority();\n    $version   = $obj->version();\n    # Gets authority:namespace:object_id\n    $lsid = $obj->lsid_string();\n    # Gets namespace:object_id.version\n    $ns_string = $obj->namespace_string();\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on identifiable objects, i.e.\nones which have identifiers expected to make sense across a number of\ninstances and/or domains. This interface is modeled after pretty much\nubiquitous ideas for names in bioinformatics being\n\n databasename:object_id.version\n\nExample:\n\n swissprot:P012334.2\n\nor:\n\n GO:0007048\n\nThe object will also work with LSID proposals which adds the concept of an\nauthority, being the DNS name of the organisation assigning the namespace.\nSee L<http://lsid.sourceforge.net/>.\n\nHelper functions are provided to make useful strings:\n\n  lsid_string - string complying to the LSID standard\n\n  namespace_string - string complying to the usual convention of\n                     namespace:object_id.version\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\npackage Bio::IdentifiableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n Returns : A scalar\n Status  : Virtual","label":"object_id($self)"},"line":115,"range":{"end":{"line":118,"character":9999},"start":{"line":115,"character":0}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":136},"start":{"character":0,"line":133}},"line":133,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IdentifiableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::IdentifiableI - interface for objects with identifiers\n\n=head1 SYNOPSIS\n\n    # to test this is an identifiable object\n\n    $obj->isa(\"Bio::IdentifiableI\") ||\n      $obj->throw(\"$obj does not implement the Bio::IdentifiableI interface\");\n\n    # Accessors\n\n    $object_id = $obj->object_id();\n    $namespace = $obj->namespace();\n    $authority = $obj->authority();\n    $version   = $obj->version();\n    # Gets authority:namespace:object_id\n    $lsid = $obj->lsid_string();\n    # Gets namespace:object_id.version\n    $ns_string = $obj->namespace_string();\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on identifiable objects, i.e.\nones which have identifiers expected to make sense across a number of\ninstances and/or domains. This interface is modeled after pretty much\nubiquitous ideas for names in bioinformatics being\n\n databasename:object_id.version\n\nExample:\n\n swissprot:P012334.2\n\nor:\n\n GO:0007048\n\nThe object will also work with LSID proposals which adds the concept of an\nauthority, being the DNS name of the organisation assigning the namespace.\nSee L<http://lsid.sourceforge.net/>.\n\nHelper functions are provided to make useful strings:\n\n  lsid_string - string complying to the LSID standard\n\n  namespace_string - string complying to the usual convention of\n                     namespace:object_id.version\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\npackage Bio::IdentifiableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n Returns : A scalar\n Status  : Virtual\n\n\nsub object_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n Returns : A number\n Status  : Virtual","label":"version($self)"},"containerName":"main::","name":"version","children":[{"definition":"my","line":134,"name":"$self","localvar":"my","kind":13,"containerName":"version"},{"line":135,"containerName":"version","kind":13,"name":"$self"},{"name":"throw_not_implemented","containerName":"version","kind":12,"line":135}],"detail":"($self)","definition":"sub"},{"signature":{"documentation":"1;\n# $Id: IdentifiableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::IdentifiableI - interface for objects with identifiers\n\n=head1 SYNOPSIS\n\n    # to test this is an identifiable object\n\n    $obj->isa(\"Bio::IdentifiableI\") ||\n      $obj->throw(\"$obj does not implement the Bio::IdentifiableI interface\");\n\n    # Accessors\n\n    $object_id = $obj->object_id();\n    $namespace = $obj->namespace();\n    $authority = $obj->authority();\n    $version   = $obj->version();\n    # Gets authority:namespace:object_id\n    $lsid = $obj->lsid_string();\n    # Gets namespace:object_id.version\n    $ns_string = $obj->namespace_string();\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on identifiable objects, i.e.\nones which have identifiers expected to make sense across a number of\ninstances and/or domains. This interface is modeled after pretty much\nubiquitous ideas for names in bioinformatics being\n\n databasename:object_id.version\n\nExample:\n\n swissprot:P012334.2\n\nor:\n\n GO:0007048\n\nThe object will also work with LSID proposals which adds the concept of an\nauthority, being the DNS name of the organisation assigning the namespace.\nSee L<http://lsid.sourceforge.net/>.\n\nHelper functions are provided to make useful strings:\n\n  lsid_string - string complying to the LSID standard\n\n  namespace_string - string complying to the usual convention of\n                     namespace:object_id.version\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\npackage Bio::IdentifiableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n Returns : A scalar\n Status  : Virtual\n\n\nsub object_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n Returns : A number\n Status  : Virtual\n\n\nsub version {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n Returns : A scalar\n Status  : Virtual","parameters":[{"label":"$self"}],"label":"authority($self)"},"line":151,"range":{"end":{"line":154,"character":9999},"start":{"character":0,"line":151}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","containerName":"authority","localvar":"my","kind":13,"line":152,"definition":"my"},{"name":"$self","kind":13,"containerName":"authority","line":153},{"name":"throw_not_implemented","kind":12,"containerName":"authority","line":153}],"name":"authority","containerName":"main::"},{"children":[{"definition":"my","localvar":"my","containerName":"namespace","kind":13,"name":"$self","line":170},{"name":"$self","kind":13,"containerName":"namespace","line":171},{"line":171,"kind":12,"containerName":"namespace","name":"throw_not_implemented"}],"name":"namespace","containerName":"main::","definition":"sub","detail":"($self)","line":169,"kind":12,"range":{"start":{"line":169,"character":0},"end":{"line":172,"character":9999}},"signature":{"label":"namespace($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IdentifiableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::IdentifiableI - interface for objects with identifiers\n\n=head1 SYNOPSIS\n\n    # to test this is an identifiable object\n\n    $obj->isa(\"Bio::IdentifiableI\") ||\n      $obj->throw(\"$obj does not implement the Bio::IdentifiableI interface\");\n\n    # Accessors\n\n    $object_id = $obj->object_id();\n    $namespace = $obj->namespace();\n    $authority = $obj->authority();\n    $version   = $obj->version();\n    # Gets authority:namespace:object_id\n    $lsid = $obj->lsid_string();\n    # Gets namespace:object_id.version\n    $ns_string = $obj->namespace_string();\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on identifiable objects, i.e.\nones which have identifiers expected to make sense across a number of\ninstances and/or domains. This interface is modeled after pretty much\nubiquitous ideas for names in bioinformatics being\n\n databasename:object_id.version\n\nExample:\n\n swissprot:P012334.2\n\nor:\n\n GO:0007048\n\nThe object will also work with LSID proposals which adds the concept of an\nauthority, being the DNS name of the organisation assigning the namespace.\nSee L<http://lsid.sourceforge.net/>.\n\nHelper functions are provided to make useful strings:\n\n  lsid_string - string complying to the LSID standard\n\n  namespace_string - string complying to the usual convention of\n                     namespace:object_id.version\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\npackage Bio::IdentifiableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n Returns : A scalar\n Status  : Virtual\n\n\nsub object_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n Returns : A number\n Status  : Virtual\n\n\nsub version {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n Returns : A scalar\n Status  : Virtual\n\n\nsub authority {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n Returns : A scalar\n Status  : Virtual"}},{"children":[{"definition":"my","line":193,"containerName":"lsid_string","localvar":"my","kind":13,"name":"$self"},{"line":195,"containerName":"lsid_string","kind":13,"name":"$self"},{"line":195,"kind":12,"containerName":"lsid_string","name":"authority"},{"line":195,"name":"$self","kind":13,"containerName":"lsid_string"},{"name":"namespace","containerName":"lsid_string","kind":12,"line":195},{"kind":13,"containerName":"lsid_string","name":"$self","line":195},{"line":195,"containerName":"lsid_string","kind":12,"name":"object_id"}],"containerName":"main::","name":"lsid_string","definition":"sub","detail":"($self)","line":192,"kind":12,"range":{"end":{"line":196,"character":9999},"start":{"character":0,"line":192}},"signature":{"label":"lsid_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IdentifiableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::IdentifiableI - interface for objects with identifiers\n\n=head1 SYNOPSIS\n\n    # to test this is an identifiable object\n\n    $obj->isa(\"Bio::IdentifiableI\") ||\n      $obj->throw(\"$obj does not implement the Bio::IdentifiableI interface\");\n\n    # Accessors\n\n    $object_id = $obj->object_id();\n    $namespace = $obj->namespace();\n    $authority = $obj->authority();\n    $version   = $obj->version();\n    # Gets authority:namespace:object_id\n    $lsid = $obj->lsid_string();\n    # Gets namespace:object_id.version\n    $ns_string = $obj->namespace_string();\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on identifiable objects, i.e.\nones which have identifiers expected to make sense across a number of\ninstances and/or domains. This interface is modeled after pretty much\nubiquitous ideas for names in bioinformatics being\n\n databasename:object_id.version\n\nExample:\n\n swissprot:P012334.2\n\nor:\n\n GO:0007048\n\nThe object will also work with LSID proposals which adds the concept of an\nauthority, being the DNS name of the organisation assigning the namespace.\nSee L<http://lsid.sourceforge.net/>.\n\nHelper functions are provided to make useful strings:\n\n  lsid_string - string complying to the LSID standard\n\n  namespace_string - string complying to the usual convention of\n                     namespace:object_id.version\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\npackage Bio::IdentifiableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n Returns : A scalar\n Status  : Virtual\n\n\nsub object_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n Returns : A number\n Status  : Virtual\n\n\nsub version {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n Returns : A scalar\n Status  : Virtual\n\n\nsub authority {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n Returns : A scalar\n Status  : Virtual\n\n\nsub namespace {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head1 Implementation optional functions\n\nThese functions are helper functions that are provided by\nthe interface but can be overridden if so wished\n\n=head2 lsid_string\n\n Title   : lsid_string\n Usage   : $string   = $obj->lsid_string()\n Function: a string which gives the LSID standard\n           notation for the identifier of interest\n\n\n Returns : A scalar"}},{"definition":"sub","detail":"($self)","children":[{"name":"$self","containerName":"namespace_string","localvar":"my","kind":13,"line":211,"definition":"my"},{"line":213,"name":"$self","containerName":"namespace_string","kind":13},{"line":213,"name":"namespace","kind":12,"containerName":"namespace_string"},{"line":213,"name":"$self","kind":13,"containerName":"namespace_string"},{"line":213,"kind":12,"containerName":"namespace_string","name":"object_id"},{"kind":13,"containerName":"namespace_string","name":"$self","line":214},{"name":"version","containerName":"namespace_string","kind":12,"line":214},{"containerName":"namespace_string","kind":13,"name":"$self","line":214},{"line":214,"containerName":"namespace_string","kind":12,"name":"version"}],"name":"namespace_string","containerName":"main::","signature":{"label":"namespace_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IdentifiableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::IdentifiableI - interface for objects with identifiers\n\n=head1 SYNOPSIS\n\n    # to test this is an identifiable object\n\n    $obj->isa(\"Bio::IdentifiableI\") ||\n      $obj->throw(\"$obj does not implement the Bio::IdentifiableI interface\");\n\n    # Accessors\n\n    $object_id = $obj->object_id();\n    $namespace = $obj->namespace();\n    $authority = $obj->authority();\n    $version   = $obj->version();\n    # Gets authority:namespace:object_id\n    $lsid = $obj->lsid_string();\n    # Gets namespace:object_id.version\n    $ns_string = $obj->namespace_string();\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on identifiable objects, i.e.\nones which have identifiers expected to make sense across a number of\ninstances and/or domains. This interface is modeled after pretty much\nubiquitous ideas for names in bioinformatics being\n\n databasename:object_id.version\n\nExample:\n\n swissprot:P012334.2\n\nor:\n\n GO:0007048\n\nThe object will also work with LSID proposals which adds the concept of an\nauthority, being the DNS name of the organisation assigning the namespace.\nSee L<http://lsid.sourceforge.net/>.\n\nHelper functions are provided to make useful strings:\n\n  lsid_string - string complying to the LSID standard\n\n  namespace_string - string complying to the usual convention of\n                     namespace:object_id.version\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n\npackage Bio::IdentifiableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n Returns : A scalar\n Status  : Virtual\n\n\nsub object_id {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n Returns : A number\n Status  : Virtual\n\n\nsub version {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org)\n Returns : A scalar\n Status  : Virtual\n\n\nsub authority {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection\n Returns : A scalar\n Status  : Virtual\n\n\nsub namespace {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head1 Implementation optional functions\n\nThese functions are helper functions that are provided by\nthe interface but can be overridden if so wished\n\n=head2 lsid_string\n\n Title   : lsid_string\n Usage   : $string   = $obj->lsid_string()\n Function: a string which gives the LSID standard\n           notation for the identifier of interest\n\n\n Returns : A scalar\n\n\nsub lsid_string {\n  my ($self) = @_;\n\n  return $self->authority.\":\".$self->namespace.\":\".$self->object_id;\n}\n\n\n\n=head2 namespace_string\n\n Title   : namespace_string\n Usage   : $string   = $obj->namespace_string()\n Function: a string which gives the common notation of\n           namespace:object_id.version\n Returns : A scalar"},"line":210,"range":{"start":{"line":210,"character":0},"end":{"line":215,"character":9999}},"kind":12}]}