{"version":5,"vars":[{"kind":12,"name":"pod","line":1},{"line":118,"kind":2,"containerName":"","name":"base"},{"kind":13,"containerName":"main::","name":"%NAME_OF","line":122,"definition":"our"},{"line":122,"containerName":"Bio::SeqFeature","kind":2,"name":"Generic"},{"definition":"our","containerName":"main::","kind":13,"name":"$NUM_COL","line":133},{"signature":{"label":"_initialize($self,%arg)","documentation":"=head1 NAME\n\nBio::FeatureIO::ptt - read/write features in PTT format\n\n=head1 SYNOPSIS\n\n # read features \n my $fin = Bio::FeatureIO->new(-file=>'genes.ptt', -format=>'ptt');\n my @cds;\n while (my $f = $fin->next_feature) {\n   push @cds, $f if $f->strand > 0;\n }\n\n # write features (NOT IMPLEMENTED)\n my $fout = Bio::FeatureIO->new(-fh=>\\*STDOUT, -format=>'ptt');\n for my $f (@cds) {\n   $fout->write_feature($f);\n }\n\n=head1 DESCRIPTION\n\nThe PTT file format is a table of protein features. \nIt is used mainly by NCBI who produce PTT files for \nall their published genomes found in L<ftp://ftp.ncbi.nih.gov/genomes/>.\nIt has the following format:\n\n=over 4\n\n* Line 1\n\nDescription of sequence to which the features belong\n eg. \"Leptospira interrogans chromosome II, complete sequence - 0..358943\"\n\nIt is usually equivalent to the DEFINITION line of a Genbank file,\nwith the length of the sequence appended. It is unclear why \"0\" is \nused as a starting range, it should be \"1\".\n\n* Line 2\n\nNumber of feature lines in the table\n eg. \"367 proteins\"\n\n* Line 3\n\nColumn headers, tab separated\n eg. \"Location  Strand  Length  PID Gene  Synonym Code  COG Product\"\n\n Location : \"begin..end\" span of feature\n Strand   : \"+\" or \"-\"\n Length   : number of amino acids excluding the stop codon\n PID      : analogous to Genbank /db_xref=\"GI:xxxxxxxxx\"\n Gene     : analogous to Genbank /gene=\"xxxx\"\n Synonym  : analogous to Genbank /locus_tag=\"xxxx\"\n Synonym  : analogous to Genbank /locus_tag=\"xxxx\"\n COG      : CDD COG code with COG letter categories appended\n Product  : analogous to Genbank /product=\"xxxx\"\n\n* Line 4 onwards\n\nFeature lines, nine columns, tab separated, \"-\" used for empty fields\n eg. \"2491..3423  + 310 24217063  metF  LB002 - COG0685E  5,10-methylenetetrahydrofolate reductase\"\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Torsten Seemann\n\nEmail torsten.seemann AT infotech.monash.edu.au\n\n=head1 CONTRIBUTORS\n\nBased on bed.pm and gff.pm by Allen Day.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::ptt;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Generic;\n\n# map tab-separated column number to field name\nour %NAME_OF = (\n  0 => 'Location',\n  1 => 'Strand',\n  2 => 'Length', \n  3 => 'PID', \n  4 => 'Gene',  \n  5 => 'Synonym',\n  6 => 'Code',  \n  7 => 'COG', \n  8 => 'Product',\n);\nour $NUM_COL = 9;\n\n=head2 _initialize\n\n Title   : _initialize\n Function: Reading? parses the header of the input\n           Writing? ","parameters":[{"label":"$self"},{"label":"%arg"}]},"range":{"start":{"line":143,"character":0},"end":{"character":9999,"line":160}},"kind":12,"line":143,"detail":"($self,%arg)","definition":"sub","name":"_initialize","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_initialize","name":"$self","line":144},{"line":144,"containerName":"_initialize","kind":13,"name":"%arg"},{"line":146,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"%arg","containerName":"_initialize","kind":13,"line":146},{"line":148,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":12,"name":"mode","line":148},{"name":"$desc","localvar":"my","containerName":"_initialize","kind":13,"line":150,"definition":"my"},{"line":150,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"_readline","line":150},{"line":151,"kind":13,"containerName":"_initialize","name":"$desc"},{"name":"$self","kind":13,"containerName":"_initialize","line":152},{"containerName":"_initialize","kind":12,"name":"description","line":152},{"name":"$desc","kind":13,"containerName":"_initialize","line":152},{"definition":"my","line":154,"name":"$line","localvar":"my","containerName":"_initialize","kind":13},{"line":154,"kind":13,"containerName":"_initialize","name":"$self"},{"line":154,"kind":12,"containerName":"_initialize","name":"_readline"},{"line":155,"name":"$line","kind":13,"containerName":"_initialize"},{"name":"$self","kind":13,"containerName":"_initialize","line":155},{"line":155,"name":"throw","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$self","line":156},{"line":156,"kind":12,"containerName":"_initialize","name":"protein_count"},{"name":"$self","containerName":"_initialize","kind":13,"line":158},{"name":"_readline","kind":12,"containerName":"_initialize","line":158}]},{"containerName":"_initialize","kind":12,"name":"SUPER","line":146},{"children":[{"localvar":"my","kind":13,"containerName":"next_feature","name":"$self","line":174,"definition":"my"},{"line":175,"containerName":"next_feature","kind":13,"name":"$self"},{"line":175,"kind":12,"containerName":"next_feature","name":"mode"},{"name":"$line","kind":13,"localvar":"my","containerName":"next_feature","line":177,"definition":"my"},{"kind":13,"containerName":"next_feature","name":"$self","line":177},{"kind":12,"containerName":"next_feature","name":"_readline","line":177},{"containerName":"next_feature","kind":13,"name":"$line","line":178},{"name":"@col","localvar":"my","kind":13,"containerName":"next_feature","line":179,"definition":"my"},{"line":179,"name":"$line","kind":13,"containerName":"next_feature"},{"line":180,"containerName":"next_feature","kind":13,"name":"@col"},{"line":180,"name":"$NUM_COL","containerName":"next_feature","kind":13},{"line":180,"containerName":"next_feature","kind":13,"name":"$self"},{"line":180,"kind":12,"containerName":"next_feature","name":"throw"},{"name":"$col","containerName":"next_feature","kind":13,"line":182},{"line":182,"name":"$self","containerName":"next_feature","kind":13},{"line":182,"name":"throw","kind":12,"containerName":"next_feature"},{"definition":"my","name":"$feat","containerName":"next_feature","localvar":"my","kind":13,"line":183},{"line":183,"kind":12,"containerName":"next_feature","name":"new"},{"name":"$col","containerName":"next_feature","kind":13,"line":184},{"kind":13,"containerName":"next_feature","name":"$self","line":184},{"name":"throw","kind":12,"containerName":"next_feature","line":184},{"line":185,"kind":13,"containerName":"next_feature","name":"$feat"},{"name":"strand","kind":12,"containerName":"next_feature","line":185},{"localvar":"my","containerName":"next_feature","kind":13,"name":"$i","line":186,"definition":"my"},{"line":186,"name":"$NUM_COL","kind":13,"containerName":"next_feature"},{"line":187,"kind":13,"containerName":"next_feature","name":"$feat"},{"line":187,"name":"add_tag_value","containerName":"next_feature","kind":12},{"name":"$NAME_OF","kind":13,"containerName":"next_feature","line":187},{"kind":13,"containerName":"next_feature","name":"$i","line":187},{"line":187,"containerName":"next_feature","kind":13,"name":"$col"},{"line":187,"kind":13,"containerName":"next_feature","name":"$i"},{"line":187,"kind":13,"containerName":"next_feature","name":"$col"},{"line":187,"kind":13,"containerName":"next_feature","name":"$i"},{"line":189,"containerName":"next_feature","kind":13,"name":"$feat"}],"containerName":"main::","name":"next_feature","definition":"sub","line":173,"kind":12,"range":{"end":{"line":190,"character":9999},"start":{"line":173,"character":0}}},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":183},{"children":[{"line":204,"name":"throw_not_implemented","containerName":"write_feature","kind":12}],"name":"write_feature","containerName":"main::","definition":"sub","line":203,"range":{"end":{"character":9999,"line":205},"start":{"line":203,"character":0}},"kind":12},{"name":"description","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"description","kind":13,"line":219},{"line":220,"kind":13,"containerName":"description","name":"$self"},{"line":221,"name":"$self","kind":13,"containerName":"description"}],"definition":"sub","range":{"end":{"line":222,"character":9999},"start":{"line":218,"character":0}},"kind":12,"line":218},{"children":[{"definition":"my","line":236,"containerName":"protein_count","localvar":"my","kind":13,"name":"$self"},{"line":237,"kind":13,"containerName":"protein_count","name":"$self"},{"line":238,"name":"$self","kind":13,"containerName":"protein_count"}],"name":"protein_count","containerName":"main::","definition":"sub","line":235,"kind":12,"range":{"start":{"character":0,"line":235},"end":{"character":9999,"line":239}}}]}