{"vars":[{"name":"base","containerName":"","kind":2,"line":70},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: DescribableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::DescribableI - interface for objects with human readable names and descriptions\n\n=head1 SYNOPSIS\n\n\n    # to test this is a describable object\n\n    $obj->isa(\"Bio::DescribableI\") || \n      $obj->throw(\"$obj does not implement the Bio::DescribableI interface\");\n\n    # accessors\n\n    $name = $obj->display_name();\n    $desc = $obj->description();\n\n\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on describable objects, ie\nones which have human displayable names and descriptions\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n\npackage Bio::DescribableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n Returns : A scalar\n Status  : Virtual","label":"display_name($self)"},"line":91,"range":{"start":{"character":0,"line":91},"end":{"character":9999,"line":94}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","containerName":"display_name","localvar":"my","kind":13,"line":92,"definition":"my"},{"containerName":"display_name","kind":13,"name":"$self","line":93},{"kind":12,"containerName":"display_name","name":"throw_not_implemented","line":93}],"containerName":"main::","name":"display_name"},{"detail":"($self)","definition":"sub","name":"description","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"description","name":"$self","line":113,"definition":"my"},{"line":114,"containerName":"description","kind":13,"name":"$self"},{"name":"throw_not_implemented","containerName":"description","kind":12,"line":114}],"signature":{"label":"description($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: DescribableI.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#\n# This module is licensed under the same terms as Perl itself. You use,\n# modify, and redistribute it under the terms of the Perl Artistic License.\n#\n\n=head1 NAME\n\nBio::DescribableI - interface for objects with human readable names and descriptions\n\n=head1 SYNOPSIS\n\n\n    # to test this is a describable object\n\n    $obj->isa(\"Bio::DescribableI\") || \n      $obj->throw(\"$obj does not implement the Bio::DescribableI interface\");\n\n    # accessors\n\n    $name = $obj->display_name();\n    $desc = $obj->description();\n\n\n\n=head1 DESCRIPTION\n\nThis interface describes methods expected on describable objects, ie\nones which have human displayable names and descriptions\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\n\npackage Bio::DescribableI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Implementation Specific Functions\n\nThese functions are the ones that a specific implementation must\ndefine.\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n Returns : A scalar\n Status  : Virtual"},"kind":12,"range":{"end":{"line":115,"character":9999},"start":{"line":112,"character":0}},"line":112}],"version":5}