{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":111},{"definition":"sub","detail":"($class,@args)","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":115,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":115},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":116},{"containerName":"new","kind":13,"name":"$class","line":116},{"line":116,"kind":13,"containerName":"new","name":"@args"},{"line":118,"name":"$in","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"kind":13,"containerName":"new","name":"$out","line":118},{"line":119,"name":"$self","containerName":"new","kind":13},{"line":119,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":122},{"name":"$in","containerName":"new","kind":13,"line":124},{"kind":13,"containerName":"new","name":"$self","line":124},{"line":124,"name":"in","kind":12,"containerName":"new"},{"line":124,"containerName":"new","kind":13,"name":"$in"},{"line":125,"name":"$out","kind":13,"containerName":"new"},{"line":125,"name":"$self","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"out","line":125},{"line":125,"name":"$out","containerName":"new","kind":13},{"line":126,"containerName":"new","kind":13,"name":"$self"}],"containerName":"main::","name":"new","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"line":114,"range":{"end":{"line":127,"character":9999},"start":{"character":0,"line":114}},"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":116},{"detail":"($self,$value)","definition":"sub","name":"in","containerName":"main::","children":[{"definition":"my","line":141,"localvar":"my","containerName":"in","kind":13,"name":"$self"},{"line":141,"name":"$value","kind":13,"containerName":"in"},{"name":"$value","containerName":"in","kind":13,"line":142},{"line":143,"kind":13,"containerName":"in","name":"$self"},{"name":"throw","kind":12,"containerName":"in","line":143},{"line":144,"name":"$value","containerName":"in","kind":13},{"name":"isa","kind":12,"containerName":"in","line":144},{"name":"$self","kind":13,"containerName":"in","line":145},{"containerName":"in","kind":13,"name":"$value","line":145},{"name":"$self","containerName":"in","kind":13,"line":147}],"signature":{"label":"in($self,$value)","documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"start":{"line":140,"character":0},"end":{"line":148,"character":9999}},"line":140},{"line":162,"kind":12,"range":{"end":{"character":9999,"line":170},"start":{"line":162,"character":0}},"signature":{"label":"out($self,$value)","documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"localvar":"my","containerName":"out","kind":13,"name":"$self","line":163,"definition":"my"},{"line":163,"name":"$value","kind":13,"containerName":"out"},{"line":164,"kind":13,"containerName":"out","name":"$value"},{"name":"$self","containerName":"out","kind":13,"line":165},{"line":165,"containerName":"out","kind":12,"name":"throw"},{"kind":13,"containerName":"out","name":"$value","line":166},{"line":166,"kind":12,"containerName":"out","name":"isa"},{"name":"$self","containerName":"out","kind":13,"line":167},{"kind":13,"containerName":"out","name":"$value","line":167},{"containerName":"out","kind":13,"name":"$self","line":169}],"name":"out","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : ","label":"swap($self)"},"line":184,"range":{"end":{"line":188,"character":9999},"start":{"character":0,"line":184}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","containerName":"swap","localvar":"my","kind":13,"name":"$self","line":185},{"name":"$self","containerName":"swap","kind":13,"line":186},{"kind":13,"containerName":"swap","name":"$self","line":186},{"name":"$self","containerName":"swap","kind":13,"line":186},{"kind":13,"containerName":"swap","name":"$self","line":186}],"name":"swap","containerName":"main::"},{"range":{"end":{"line":209,"character":9999},"start":{"line":201,"character":0}},"kind":12,"line":201,"signature":{"label":"strand($self)","documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :","parameters":[{"label":"$self"}]},"name":"strand","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"strand","name":"$self","line":202,"definition":"my"},{"line":203,"containerName":"strand","kind":13,"name":"$self"},{"line":203,"name":"warn","kind":12,"containerName":"strand"},{"line":204,"name":"$self","kind":13,"containerName":"strand"},{"name":"out","kind":12,"containerName":"strand","line":204},{"containerName":"strand","kind":13,"name":"$self","line":205},{"line":205,"kind":12,"containerName":"strand","name":"warn"},{"name":"$self","kind":13,"containerName":"strand","line":206},{"name":"in","containerName":"strand","kind":12,"line":206},{"line":208,"containerName":"strand","kind":13,"name":"$self"},{"line":208,"name":"in","kind":12,"containerName":"strand"},{"kind":12,"containerName":"strand","name":"strand","line":208},{"name":"$self","containerName":"strand","kind":13,"line":208},{"containerName":"strand","kind":12,"name":"out","line":208},{"line":208,"kind":12,"containerName":"strand","name":"strand"}],"detail":"($self)","definition":"sub"},{"signature":{"label":"test($self)","documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :\n\n\nsub strand {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n\n   return ($self->in->strand || 0) * ($self->out->strand || 0);\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components are of the same length\n Example :\n Returns : ( 1 | undef )\n Args    :","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":229,"character":9999},"start":{"line":222,"character":0}},"line":222,"detail":"($self)","definition":"sub","name":"test","containerName":"main::","children":[{"definition":"my","line":223,"name":"$self","localvar":"my","containerName":"test","kind":13},{"name":"$self","kind":13,"containerName":"test","line":224},{"kind":12,"containerName":"test","name":"warn","line":224},{"line":225,"containerName":"test","kind":13,"name":"$self"},{"name":"out","kind":12,"containerName":"test","line":225},{"line":226,"kind":13,"containerName":"test","name":"$self"},{"line":226,"containerName":"test","kind":12,"name":"warn"},{"containerName":"test","kind":13,"name":"$self","line":227},{"kind":12,"containerName":"test","name":"in","line":227},{"line":228,"name":"$self","kind":13,"containerName":"test"},{"line":228,"containerName":"test","kind":12,"name":"in"},{"line":228,"kind":12,"containerName":"test","name":"end"},{"name":"$self","containerName":"test","kind":13,"line":228},{"containerName":"test","kind":12,"name":"in","line":228},{"name":"start","containerName":"test","kind":12,"line":228},{"name":"$self","kind":13,"containerName":"test","line":228},{"name":"out","kind":12,"containerName":"test","line":228},{"name":"end","kind":12,"containerName":"test","line":228},{"name":"$self","containerName":"test","kind":13,"line":228},{"line":228,"kind":12,"containerName":"test","name":"out"},{"name":"start","containerName":"test","kind":12,"line":228}]},{"detail":"($self,$value)","definition":"sub","name":"map","containerName":"main::","children":[{"name":"$self","containerName":"map","localvar":"my","kind":13,"line":245,"definition":"my"},{"line":245,"kind":13,"containerName":"map","name":"$value"},{"line":247,"name":"$self","kind":13,"containerName":"map"},{"name":"throw","kind":12,"containerName":"map","line":247},{"name":"$value","kind":13,"containerName":"map","line":248},{"line":249,"kind":13,"containerName":"map","name":"$self"},{"line":249,"name":"throw","kind":12,"containerName":"map"},{"name":"$value","kind":13,"containerName":"map","line":250},{"line":250,"name":"isa","containerName":"map","kind":12},{"line":251,"name":"$self","kind":13,"containerName":"map"},{"kind":12,"containerName":"map","name":"throw","line":251},{"name":"$self","kind":13,"containerName":"map","line":252},{"line":252,"kind":12,"containerName":"map","name":"in"},{"name":"$self","kind":13,"containerName":"map","line":253},{"name":"throw","containerName":"map","kind":12,"line":253},{"kind":13,"containerName":"map","name":"$self","line":254},{"line":254,"containerName":"map","kind":12,"name":"out"},{"kind":13,"containerName":"map","name":"$value","line":257},{"line":257,"containerName":"map","kind":12,"name":"isa"},{"line":259,"name":"$result","localvar":"my","containerName":"map","kind":13,"definition":"my"},{"line":259,"containerName":"map","kind":12,"name":"new"},{"definition":"my","name":"$loc","localvar":"my","containerName":"map","kind":13,"line":260},{"name":"$value","containerName":"map","kind":13,"line":260},{"name":"sub_Location","kind":12,"containerName":"map","line":260},{"definition":"my","name":"$res","containerName":"map","localvar":"my","kind":13,"line":261},{"line":261,"containerName":"map","kind":13,"name":"$self"},{"line":261,"name":"_map","kind":12,"containerName":"map"},{"line":261,"name":"$loc","containerName":"map","kind":13},{"line":262,"name":"$result","containerName":"map","kind":13},{"name":"add_sub_Location","kind":12,"containerName":"map","line":262},{"line":262,"name":"$res","kind":13,"containerName":"map"},{"containerName":"map","kind":12,"name":"each_Location","line":262},{"line":264,"name":"$result","kind":13,"containerName":"map"},{"line":266,"kind":13,"containerName":"map","name":"$self"},{"name":"_map","kind":12,"containerName":"map","line":266},{"name":"$value","kind":13,"containerName":"map","line":266}],"signature":{"label":"map($self,$value)","documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :\n\n\nsub strand {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n\n   return ($self->in->strand || 0) * ($self->out->strand || 0);\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components are of the same length\n Example :\n Returns : ( 1 | undef )\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n   return ($self->in->end - $self->in->start) == ($self->out->end - $self->out->start);\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new Bio::LocationI in the output coordinate system or undef\n Args    : Bio::LocationI object","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"end":{"character":9999,"line":268},"start":{"line":244,"character":0}},"kind":12,"line":244},{"name":"Bio","kind":12,"containerName":"Coordinate::Result","line":259},{"signature":{"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Pair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::Pair;\n\n  my $match1 = Bio::Location::Simple->new \n      (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  my $match2 = Bio::Location::Simple->new\n      (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n  my $pair = Bio::Coordinate::Pair->new(-in => $match1,\n  \t\t\t\t\t-out => $match2\n                                        );\n  # location to match\n  $pos = Bio::Location::Simple->new \n      (-start => 25, -end => 25, -strand=> -1 );\n\n  # results are in a Bio::Coordinate::Result\n  # they can be Matches and Gaps; are  Bio::LocationIs\n  $res = $pair->map($pos);\n  $res->isa('Bio::Coordinate::Result');\n  $res->each_match == 1;\n  $res->each_gap == 0;\n  $res->each_Location == 1;\n  $res->match->start == 5;\n  $res->match->end == 5;\n  $res->match->strand == -1;\n  $res->match->seq_id eq 'peptide';\n\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThe map() method returns Bio::Coordinate::Results with\nBio::Coordinate::Result::Gaps. The calling code have to deal (process\nor ignore) them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Pair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Coordinate::Result;\nuse Bio::Coordinate::Result::Match;\nuse Bio::Coordinate::Result::Gap;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($in, $out) =\n\t$self->_rearrange([qw(IN\n                              OUT\n\t\t\t     )],\n\t\t\t @args);\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional), Bio::LocationI\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_in'} = $value;\n   }\n   return $self->{'_in'};\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional), Bio::LocationI\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid output coordinate Bio::Location [$value] \")\n\t   unless $value->isa('Bio::LocationI');\n       $self->{'_out'} = $value;\n   }\n   return $self->{'_out'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping; input <-> output\n Example :\n Returns : 1\n Args    : \n\n\nsub swap {\n   my ($self) = @_;\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   return 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $obj->strand;\n Function: Get strand value for the pair\n Example :\n Returns : ( 1 | 0 | -1 )\n Args    :\n\n\nsub strand {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n\n   return ($self->in->strand || 0) * ($self->out->strand || 0);\n}\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components are of the same length\n Example :\n Returns : ( 1 | undef )\n Args    :\n\n\nsub test {\n   my ($self) = @_;\n   $self->warn(\"Outgoing coordinates are not defined\")\n       unless $self->out;\n   $self->warn(\"Incoming coordinates are not defined\")\n       unless $self->in;\n   return ($self->in->end - $self->in->start) == ($self->out->end - $self->out->start);\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new Bio::LocationI in the output coordinate system or undef\n Args    : Bio::LocationI object\n\n\nsub map {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a value.\")\n       unless defined $value;\n   $self->throw(\"I need a Bio::Location, not [$value]\")\n       unless $value->isa('Bio::LocationI');\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->in;\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->out;\n\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n\n       my $result = Bio::Coordinate::Result->new();\n       foreach my $loc ( $value->sub_Location(1) ) {\n           my $res = $self->_map($loc);\n           map { $result->add_sub_Location($_) } $res->each_Location;\n       }\n       return $result;\n   } else {\n       return $self->_map($value);\n   }\n}\n\n\n=head2 _map\n\n Title   : _map\n Usage   : $newpos = $obj->_map($simpleloc);\n Function: Internal method that does the actual mapping. Called\n           multiple times by map() if the location to be mapped is a\n           split location\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_map($self,$value)"},"kind":12,"range":{"end":{"character":9999,"line":438},"start":{"line":284,"character":0}},"line":284,"detail":"($self,$value)","definition":"sub","name":"_map","containerName":"main::","children":[{"localvar":"my","containerName":"_map","kind":13,"name":"$self","line":285,"definition":"my"},{"line":285,"containerName":"_map","kind":13,"name":"$value"},{"definition":"my","name":"$result","localvar":"my","kind":13,"containerName":"_map","line":287},{"kind":12,"containerName":"_map","name":"new","line":287},{"definition":"my","kind":13,"localvar":"my","containerName":"_map","name":"$offset","line":289},{"kind":13,"containerName":"_map","name":"$self","line":289},{"containerName":"_map","kind":12,"name":"in","line":289},{"name":"start","kind":12,"containerName":"_map","line":289},{"line":289,"name":"$self","containerName":"_map","kind":13},{"line":289,"name":"out","kind":12,"containerName":"_map"},{"line":289,"containerName":"_map","kind":12,"name":"start"},{"definition":"my","localvar":"my","kind":13,"containerName":"_map","name":"$start","line":290},{"line":290,"name":"$value","kind":13,"containerName":"_map"},{"line":290,"kind":12,"containerName":"_map","name":"start"},{"line":290,"kind":13,"containerName":"_map","name":"$offset"},{"name":"$end","kind":13,"localvar":"my","containerName":"_map","line":291,"definition":"my"},{"kind":13,"containerName":"_map","name":"$value","line":291},{"name":"end","kind":12,"containerName":"_map","line":291},{"kind":13,"containerName":"_map","name":"$offset","line":291},{"definition":"my","localvar":"my","kind":13,"containerName":"_map","name":"$match","line":293},{"kind":12,"containerName":"_map","name":"new","line":293},{"kind":13,"containerName":"_map","name":"$match","line":294},{"name":"location_type","kind":12,"containerName":"_map","line":294},{"kind":13,"containerName":"_map","name":"$value","line":294},{"line":294,"name":"location_type","kind":12,"containerName":"_map"},{"line":295,"name":"$match","containerName":"_map","kind":13},{"line":295,"kind":12,"containerName":"_map","name":"strand"},{"name":"$self","containerName":"_map","kind":13,"line":295},{"line":295,"kind":12,"containerName":"_map","name":"strand"},{"containerName":"_map","kind":13,"name":"$start","line":300},{"name":"$self","containerName":"_map","kind":13,"line":300},{"kind":12,"containerName":"_map","name":"out","line":300},{"line":300,"containerName":"_map","kind":12,"name":"start"},{"line":300,"kind":13,"containerName":"_map","name":"$end"},{"containerName":"_map","kind":13,"name":"$self","line":300},{"line":300,"containerName":"_map","kind":12,"name":"out"},{"name":"end","kind":12,"containerName":"_map","line":300},{"name":"$match","containerName":"_map","kind":13,"line":302},{"name":"seq_id","kind":12,"containerName":"_map","line":302},{"name":"$self","kind":13,"containerName":"_map","line":302},{"kind":12,"containerName":"_map","name":"out","line":302},{"name":"seq_id","kind":12,"containerName":"_map","line":302},{"line":303,"name":"$result","kind":13,"containerName":"_map"},{"line":303,"containerName":"_map","kind":12,"name":"seq_id"},{"containerName":"_map","kind":13,"name":"$self","line":303},{"containerName":"_map","kind":12,"name":"out","line":303},{"line":303,"containerName":"_map","kind":12,"name":"seq_id"},{"containerName":"_map","kind":13,"name":"$self","line":305},{"line":305,"kind":12,"containerName":"_map","name":"strand"},{"line":306,"name":"$match","containerName":"_map","kind":13},{"line":306,"containerName":"_map","kind":12,"name":"start"},{"line":306,"containerName":"_map","kind":13,"name":"$start"},{"line":307,"name":"$match","containerName":"_map","kind":13},{"kind":12,"containerName":"_map","name":"end","line":307},{"name":"$end","kind":13,"containerName":"_map","line":307},{"line":309,"name":"$match","containerName":"_map","kind":13},{"kind":12,"containerName":"_map","name":"start","line":309},{"line":309,"name":"$self","containerName":"_map","kind":13},{"line":309,"name":"out","kind":12,"containerName":"_map"},{"kind":12,"containerName":"_map","name":"end","line":309},{"line":309,"containerName":"_map","kind":13,"name":"$end"},{"containerName":"_map","kind":13,"name":"$self","line":309},{"kind":12,"containerName":"_map","name":"out","line":309},{"line":309,"name":"start","kind":12,"containerName":"_map"},{"line":310,"kind":13,"containerName":"_map","name":"$match"},{"kind":12,"containerName":"_map","name":"end","line":310},{"line":310,"name":"$self","containerName":"_map","kind":13},{"line":310,"name":"out","kind":12,"containerName":"_map"},{"line":310,"name":"end","containerName":"_map","kind":12},{"name":"$start","kind":13,"containerName":"_map","line":310},{"line":310,"containerName":"_map","kind":13,"name":"$self"},{"name":"out","kind":12,"containerName":"_map","line":310},{"line":310,"name":"start","containerName":"_map","kind":12},{"name":"$value","kind":13,"containerName":"_map","line":312},{"line":312,"kind":12,"containerName":"_map","name":"strand"},{"name":"$match","kind":13,"containerName":"_map","line":313},{"line":313,"kind":12,"containerName":"_map","name":"strand"},{"line":313,"name":"$match","kind":13,"containerName":"_map"},{"line":313,"kind":12,"containerName":"_map","name":"strand"},{"line":313,"kind":13,"containerName":"_map","name":"$value"},{"name":"strand","kind":12,"containerName":"_map","line":313},{"name":"$result","kind":13,"containerName":"_map","line":314},{"line":314,"name":"strand","containerName":"_map","kind":12},{"line":314,"name":"$match","kind":13,"containerName":"_map"},{"name":"strand","kind":12,"containerName":"_map","line":314},{"line":316,"kind":13,"containerName":"_map","name":"$match"},{"line":317,"kind":13,"containerName":"_map","name":"$result"},{"line":317,"kind":12,"containerName":"_map","name":"add_sub_Location"},{"line":317,"kind":13,"containerName":"_map","name":"$match"},{"line":322,"name":"$end","containerName":"_map","kind":13},{"kind":13,"containerName":"_map","name":"$self","line":322},{"containerName":"_map","kind":12,"name":"out","line":322},{"line":322,"name":"start","kind":12,"containerName":"_map"},{"name":"$start","containerName":"_map","kind":13,"line":322},{"containerName":"_map","kind":13,"name":"$self","line":322},{"line":322,"name":"out","kind":12,"containerName":"_map"},{"line":322,"containerName":"_map","kind":12,"name":"end"},{"name":"$value","kind":13,"containerName":"_map","line":324},{"containerName":"_map","kind":12,"name":"location_type","line":324},{"name":"$end","containerName":"_map","kind":13,"line":325},{"kind":13,"containerName":"_map","name":"$self","line":325},{"line":325,"name":"out","containerName":"_map","kind":12},{"kind":12,"containerName":"_map","name":"start","line":325},{"kind":13,"containerName":"_map","name":"$start","line":325},{"line":325,"kind":13,"containerName":"_map","name":"$self"},{"line":325,"kind":12,"containerName":"_map","name":"out"},{"line":325,"kind":12,"containerName":"_map","name":"end"},{"line":327,"name":"$match","containerName":"_map","kind":13},{"line":327,"name":"seq_id","containerName":"_map","kind":12},{"line":327,"name":"$self","containerName":"_map","kind":13},{"containerName":"_map","kind":12,"name":"in","line":327},{"name":"seq_id","containerName":"_map","kind":12,"line":327},{"line":328,"name":"$result","kind":13,"containerName":"_map"},{"name":"seq_id","containerName":"_map","kind":12,"line":328},{"line":328,"containerName":"_map","kind":13,"name":"$self"},{"line":328,"name":"in","containerName":"_map","kind":12},{"line":328,"containerName":"_map","kind":12,"name":"seq_id"},{"line":329,"name":"$match","kind":13,"containerName":"_map"},{"name":"start","kind":12,"containerName":"_map","line":329},{"line":329,"name":"$value","containerName":"_map","kind":13},{"line":329,"kind":12,"containerName":"_map","name":"start"},{"line":330,"containerName":"_map","kind":13,"name":"$match"},{"name":"end","kind":12,"containerName":"_map","line":330},{"line":330,"name":"$value","kind":13,"containerName":"_map"},{"name":"end","containerName":"_map","kind":12,"line":330},{"line":331,"name":"$match","containerName":"_map","kind":13},{"line":331,"kind":12,"containerName":"_map","name":"strand"},{"line":331,"name":"$value","kind":13,"containerName":"_map"},{"line":331,"name":"strand","kind":12,"containerName":"_map"},{"kind":13,"containerName":"_map","name":"$match","line":333},{"line":334,"name":"$result","containerName":"_map","kind":13},{"name":"add_sub_Location","kind":12,"containerName":"_map","line":334},{"line":334,"containerName":"_map","kind":13,"name":"$match"},{"kind":13,"containerName":"_map","name":"$start","line":339},{"line":339,"name":"$self","containerName":"_map","kind":13},{"line":339,"kind":12,"containerName":"_map","name":"out"},{"line":339,"containerName":"_map","kind":12,"name":"start"},{"kind":13,"containerName":"_map","name":"$end","line":339},{"line":339,"kind":13,"containerName":"_map","name":"$self"},{"line":339,"kind":12,"containerName":"_map","name":"out"},{"kind":12,"containerName":"_map","name":"end","line":339},{"kind":13,"containerName":"_map","name":"$result","line":341},{"name":"seq_id","kind":12,"containerName":"_map","line":341},{"kind":13,"containerName":"_map","name":"$self","line":341},{"kind":12,"containerName":"_map","name":"out","line":341},{"name":"seq_id","kind":12,"containerName":"_map","line":341},{"line":342,"containerName":"_map","kind":13,"name":"$value"},{"name":"strand","kind":12,"containerName":"_map","line":342},{"name":"$match","kind":13,"containerName":"_map","line":343},{"line":343,"kind":12,"containerName":"_map","name":"strand"},{"line":343,"name":"$match","kind":13,"containerName":"_map"},{"kind":12,"containerName":"_map","name":"strand","line":343},{"kind":13,"containerName":"_map","name":"$value","line":343},{"line":343,"name":"strand","containerName":"_map","kind":12},{"line":344,"kind":13,"containerName":"_map","name":"$result"},{"name":"strand","containerName":"_map","kind":12,"line":344},{"line":344,"name":"$match","kind":13,"containerName":"_map"},{"line":344,"name":"strand","containerName":"_map","kind":12},{"definition":"my","line":346,"containerName":"_map","localvar":"my","kind":13,"name":"$gap"},{"line":346,"name":"new","kind":12,"containerName":"_map"},{"line":347,"name":"$gap","containerName":"_map","kind":13},{"line":347,"containerName":"_map","kind":12,"name":"start"},{"name":"$value","kind":13,"containerName":"_map","line":347},{"line":347,"name":"start","containerName":"_map","kind":12},{"line":348,"name":"$gap","kind":13,"containerName":"_map"},{"name":"end","kind":12,"containerName":"_map","line":348},{"line":348,"name":"$self","kind":13,"containerName":"_map"},{"line":348,"name":"in","kind":12,"containerName":"_map"},{"line":348,"name":"start","kind":12,"containerName":"_map"},{"line":349,"containerName":"_map","kind":13,"name":"$gap"},{"name":"strand","containerName":"_map","kind":12,"line":349},{"line":349,"containerName":"_map","kind":13,"name":"$value"},{"name":"strand","containerName":"_map","kind":12,"line":349},{"line":350,"name":"$gap","containerName":"_map","kind":13},{"kind":12,"containerName":"_map","name":"seq_id","line":350},{"line":350,"name":"$self","containerName":"_map","kind":13},{"line":350,"containerName":"_map","kind":12,"name":"in"},{"containerName":"_map","kind":12,"name":"seq_id","line":350},{"name":"$gap","containerName":"_map","kind":13,"line":352},{"kind":13,"containerName":"_map","name":"$result","line":353},{"line":353,"name":"add_sub_Location","kind":12,"containerName":"_map"},{"name":"$gap","containerName":"_map","kind":13,"line":353},{"kind":13,"containerName":"_map","name":"$match","line":356},{"name":"seq_id","containerName":"_map","kind":12,"line":356},{"name":"$self","kind":13,"containerName":"_map","line":356},{"line":356,"name":"out","kind":12,"containerName":"_map"},{"line":356,"name":"seq_id","containerName":"_map","kind":12},{"line":358,"containerName":"_map","kind":13,"name":"$self"},{"name":"strand","kind":12,"containerName":"_map","line":358},{"line":359,"kind":13,"containerName":"_map","name":"$match"},{"line":359,"name":"start","kind":12,"containerName":"_map"},{"name":"$self","kind":13,"containerName":"_map","line":359},{"line":359,"name":"out","containerName":"_map","kind":12},{"line":359,"name":"start","kind":12,"containerName":"_map"},{"line":360,"containerName":"_map","kind":13,"name":"$match"},{"kind":12,"containerName":"_map","name":"end","line":360},{"line":360,"name":"$end","containerName":"_map","kind":13},{"line":362,"kind":13,"containerName":"_map","name":"$match"},{"line":362,"name":"start","containerName":"_map","kind":12},{"line":362,"name":"$self","kind":13,"containerName":"_map"},{"kind":12,"containerName":"_map","name":"out","line":362},{"line":362,"name":"end","kind":12,"containerName":"_map"},{"kind":13,"containerName":"_map","name":"$end","line":362},{"kind":13,"containerName":"_map","name":"$self","line":362},{"line":362,"kind":12,"containerName":"_map","name":"out"},{"line":362,"name":"start","kind":12,"containerName":"_map"},{"line":363,"kind":13,"containerName":"_map","name":"$match"},{"line":363,"name":"end","kind":12,"containerName":"_map"},{"line":363,"name":"$self","containerName":"_map","kind":13},{"name":"out","kind":12,"containerName":"_map","line":363},{"kind":12,"containerName":"_map","name":"end","line":363},{"name":"$match","kind":13,"containerName":"_map","line":365},{"line":366,"kind":13,"containerName":"_map","name":"$result"},{"line":366,"name":"add_sub_Location","kind":12,"containerName":"_map"},{"kind":13,"containerName":"_map","name":"$match","line":366},{"containerName":"_map","kind":13,"name":"$start","line":371},{"name":"$self","kind":13,"containerName":"_map","line":371},{"name":"out","containerName":"_map","kind":12,"line":371},{"line":371,"kind":12,"containerName":"_map","name":"start"},{"name":"$end","containerName":"_map","kind":13,"line":371},{"containerName":"_map","kind":13,"name":"$self","line":371},{"line":371,"name":"out","kind":12,"containerName":"_map"},{"name":"end","containerName":"_map","kind":12,"line":371},{"name":"$match","kind":13,"containerName":"_map","line":373},{"line":373,"containerName":"_map","kind":12,"name":"seq_id"},{"containerName":"_map","kind":13,"name":"$self","line":373},{"line":373,"kind":12,"containerName":"_map","name":"out"},{"line":373,"name":"seq_id","containerName":"_map","kind":12},{"kind":13,"containerName":"_map","name":"$result","line":374},{"kind":12,"containerName":"_map","name":"seq_id","line":374},{"line":374,"kind":13,"containerName":"_map","name":"$self"},{"line":374,"kind":12,"containerName":"_map","name":"out"},{"kind":12,"containerName":"_map","name":"seq_id","line":374},{"line":375,"name":"$value","containerName":"_map","kind":13},{"containerName":"_map","kind":12,"name":"strand","line":375},{"line":376,"name":"$match","containerName":"_map","kind":13},{"containerName":"_map","kind":12,"name":"strand","line":376},{"line":376,"name":"$match","containerName":"_map","kind":13},{"name":"strand","kind":12,"containerName":"_map","line":376},{"line":376,"name":"$value","containerName":"_map","kind":13},{"line":376,"containerName":"_map","kind":12,"name":"strand"},{"containerName":"_map","kind":13,"name":"$result","line":377},{"containerName":"_map","kind":12,"name":"strand","line":377},{"name":"$match","kind":13,"containerName":"_map","line":377},{"kind":12,"containerName":"_map","name":"strand","line":377},{"name":"$self","containerName":"_map","kind":13,"line":379},{"line":379,"name":"strand","kind":12,"containerName":"_map"},{"containerName":"_map","kind":13,"name":"$match","line":380},{"name":"start","kind":12,"containerName":"_map","line":380},{"line":380,"name":"$start","kind":13,"containerName":"_map"},{"containerName":"_map","kind":13,"name":"$match","line":381},{"name":"end","containerName":"_map","kind":12,"line":381},{"line":381,"kind":13,"containerName":"_map","name":"$self"},{"kind":12,"containerName":"_map","name":"out","line":381},{"line":381,"name":"end","kind":12,"containerName":"_map"},{"line":383,"name":"$match","kind":13,"containerName":"_map"},{"name":"start","containerName":"_map","kind":12,"line":383},{"line":383,"kind":13,"containerName":"_map","name":"$self"},{"name":"out","containerName":"_map","kind":12,"line":383},{"name":"start","kind":12,"containerName":"_map","line":383},{"containerName":"_map","kind":13,"name":"$match","line":384},{"name":"end","kind":12,"containerName":"_map","line":384},{"name":"$self","containerName":"_map","kind":13,"line":384},{"kind":12,"containerName":"_map","name":"out","line":384},{"line":384,"name":"end","kind":12,"containerName":"_map"},{"name":"$start","kind":13,"containerName":"_map","line":384},{"line":384,"name":"$self","kind":13,"containerName":"_map"},{"name":"out","kind":12,"containerName":"_map","line":384},{"line":384,"name":"start","kind":12,"containerName":"_map"},{"line":386,"name":"$match","kind":13,"containerName":"_map"},{"line":387,"kind":13,"containerName":"_map","name":"$result"},{"kind":12,"containerName":"_map","name":"add_sub_Location","line":387},{"containerName":"_map","kind":13,"name":"$match","line":387},{"line":389,"name":"$gap","kind":13,"localvar":"my","containerName":"_map","definition":"my"},{"name":"new","kind":12,"containerName":"_map","line":389},{"name":"$gap","kind":13,"containerName":"_map","line":390},{"kind":12,"containerName":"_map","name":"start","line":390},{"containerName":"_map","kind":13,"name":"$self","line":390},{"name":"in","kind":12,"containerName":"_map","line":390},{"line":390,"name":"end","containerName":"_map","kind":12},{"kind":13,"containerName":"_map","name":"$gap","line":391},{"containerName":"_map","kind":12,"name":"end","line":391},{"containerName":"_map","kind":13,"name":"$value","line":391},{"kind":12,"containerName":"_map","name":"end","line":391},{"containerName":"_map","kind":13,"name":"$gap","line":392},{"kind":12,"containerName":"_map","name":"strand","line":392},{"name":"$value","containerName":"_map","kind":13,"line":392},{"containerName":"_map","kind":12,"name":"strand","line":392},{"line":393,"kind":13,"containerName":"_map","name":"$gap"},{"line":393,"name":"seq_id","containerName":"_map","kind":12},{"line":393,"name":"$self","kind":13,"containerName":"_map"},{"kind":12,"containerName":"_map","name":"in","line":393},{"line":393,"name":"seq_id","kind":12,"containerName":"_map"},{"line":394,"name":"$gap","kind":13,"containerName":"_map"},{"line":395,"kind":13,"containerName":"_map","name":"$result"},{"line":395,"containerName":"_map","kind":12,"name":"add_sub_Location"},{"line":395,"name":"$gap","containerName":"_map","kind":13},{"line":401,"name":"$start","containerName":"_map","kind":13},{"containerName":"_map","kind":13,"name":"$self","line":401},{"line":401,"name":"out","containerName":"_map","kind":12},{"name":"start","kind":12,"containerName":"_map","line":401},{"line":401,"containerName":"_map","kind":13,"name":"$end"},{"containerName":"_map","kind":13,"name":"$self","line":401},{"line":401,"name":"out","containerName":"_map","kind":12},{"line":401,"name":"end","containerName":"_map","kind":12},{"line":403,"name":"$result","kind":13,"containerName":"_map"},{"name":"seq_id","kind":12,"containerName":"_map","line":403},{"line":403,"containerName":"_map","kind":13,"name":"$self"},{"kind":12,"containerName":"_map","name":"out","line":403},{"line":403,"name":"seq_id","containerName":"_map","kind":12},{"kind":13,"containerName":"_map","name":"$value","line":404},{"line":404,"kind":12,"containerName":"_map","name":"strand"},{"name":"$match","containerName":"_map","kind":13,"line":405},{"containerName":"_map","kind":12,"name":"strand","line":405},{"kind":13,"containerName":"_map","name":"$match","line":405},{"name":"strand","kind":12,"containerName":"_map","line":405},{"line":405,"name":"$value","kind":13,"containerName":"_map"},{"line":405,"name":"strand","kind":12,"containerName":"_map"},{"containerName":"_map","kind":13,"name":"$result","line":406},{"line":406,"name":"strand","kind":12,"containerName":"_map"},{"line":406,"containerName":"_map","kind":13,"name":"$match"},{"kind":12,"containerName":"_map","name":"strand","line":406},{"definition":"my","line":409,"containerName":"_map","localvar":"my","kind":13,"name":"$gap1"},{"line":409,"kind":12,"containerName":"_map","name":"new"},{"line":410,"name":"$gap1","kind":13,"containerName":"_map"},{"kind":12,"containerName":"_map","name":"start","line":410},{"name":"$value","kind":13,"containerName":"_map","line":410},{"line":410,"kind":12,"containerName":"_map","name":"start"},{"line":411,"kind":13,"containerName":"_map","name":"$gap1"},{"kind":12,"containerName":"_map","name":"end","line":411},{"kind":13,"containerName":"_map","name":"$self","line":411},{"name":"in","kind":12,"containerName":"_map","line":411},{"name":"start","containerName":"_map","kind":12,"line":411},{"line":412,"name":"$gap1","kind":13,"containerName":"_map"},{"name":"strand","kind":12,"containerName":"_map","line":412},{"kind":13,"containerName":"_map","name":"$value","line":412},{"line":412,"kind":12,"containerName":"_map","name":"strand"},{"kind":13,"containerName":"_map","name":"$gap1","line":413},{"name":"seq_id","kind":12,"containerName":"_map","line":413},{"containerName":"_map","kind":13,"name":"$self","line":413},{"line":413,"name":"in","kind":12,"containerName":"_map"},{"line":413,"name":"seq_id","containerName":"_map","kind":12},{"line":414,"kind":13,"containerName":"_map","name":"$gap1"},{"line":415,"name":"$result","containerName":"_map","kind":13},{"line":415,"name":"add_sub_Location","containerName":"_map","kind":12},{"name":"$gap1","kind":13,"containerName":"_map","line":415},{"containerName":"_map","kind":13,"name":"$match","line":418},{"name":"seq_id","kind":12,"containerName":"_map","line":418},{"line":418,"name":"$self","containerName":"_map","kind":13},{"name":"out","containerName":"_map","kind":12,"line":418},{"line":418,"kind":12,"containerName":"_map","name":"seq_id"},{"name":"$match","containerName":"_map","kind":13,"line":420},{"line":420,"kind":12,"containerName":"_map","name":"start"},{"kind":13,"containerName":"_map","name":"$self","line":420},{"line":420,"name":"out","kind":12,"containerName":"_map"},{"line":420,"name":"start","kind":12,"containerName":"_map"},{"line":421,"kind":13,"containerName":"_map","name":"$match"},{"line":421,"name":"end","containerName":"_map","kind":12},{"name":"$self","containerName":"_map","kind":13,"line":421},{"name":"out","containerName":"_map","kind":12,"line":421},{"line":421,"name":"end","containerName":"_map","kind":12},{"line":422,"containerName":"_map","kind":13,"name":"$match"},{"line":423,"kind":13,"containerName":"_map","name":"$result"},{"name":"add_sub_Location","containerName":"_map","kind":12,"line":423},{"line":423,"containerName":"_map","kind":13,"name":"$match"},{"definition":"my","localvar":"my","containerName":"_map","kind":13,"name":"$gap2","line":426},{"line":426,"kind":12,"containerName":"_map","name":"new"},{"line":427,"containerName":"_map","kind":13,"name":"$gap2"},{"name":"start","kind":12,"containerName":"_map","line":427},{"line":427,"containerName":"_map","kind":13,"name":"$self"},{"line":427,"kind":12,"containerName":"_map","name":"in"},{"name":"end","kind":12,"containerName":"_map","line":427},{"line":428,"name":"$gap2","containerName":"_map","kind":13},{"line":428,"name":"end","containerName":"_map","kind":12},{"line":428,"name":"$value","kind":13,"containerName":"_map"},{"line":428,"kind":12,"containerName":"_map","name":"end"},{"kind":13,"containerName":"_map","name":"$gap2","line":429},{"line":429,"name":"strand","kind":12,"containerName":"_map"},{"line":429,"containerName":"_map","kind":13,"name":"$value"},{"name":"strand","kind":12,"containerName":"_map","line":429},{"line":430,"containerName":"_map","kind":13,"name":"$gap2"},{"name":"seq_id","kind":12,"containerName":"_map","line":430},{"containerName":"_map","kind":13,"name":"$self","line":430},{"line":430,"name":"in","kind":12,"containerName":"_map"},{"name":"seq_id","containerName":"_map","kind":12,"line":430},{"line":431,"kind":13,"containerName":"_map","name":"$gap2"},{"line":432,"name":"$result","kind":13,"containerName":"_map"},{"kind":12,"containerName":"_map","name":"add_sub_Location","line":432},{"line":432,"name":"$gap2","kind":13,"containerName":"_map"},{"line":435,"name":"$self","kind":13,"containerName":"_map"},{"kind":12,"containerName":"_map","name":"throw","line":435},{"kind":13,"containerName":"_map","name":"$result","line":437}]},{"containerName":"Coordinate::Result","kind":12,"name":"Bio","line":287},{"name":"Bio","kind":12,"containerName":"Location::Simple","line":293},{"line":346,"containerName":"Location::Simple","kind":12,"name":"Bio"},{"line":389,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":409},{"kind":12,"containerName":"Location::Simple","name":"Bio","line":426}]}