{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":110},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"new","line":114},{"line":114,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$self","line":115},{"line":115,"containerName":"new","kind":13,"name":"$class"},{"name":"@args","kind":13,"containerName":"new","line":115},{"definition":"my","name":"$strict","containerName":"new","localvar":"my","kind":13,"line":117},{"line":118,"containerName":"new","kind":13,"name":"$self"},{"line":118,"kind":12,"containerName":"new","name":"_rearrange"},{"containerName":"new","kind":13,"name":"@args","line":120},{"line":122,"name":"$strict","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":122},{"line":122,"name":"strict","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$strict","line":122},{"line":123,"containerName":"new","kind":13,"name":"$self"}],"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"kind":12,"range":{"start":{"character":0,"line":113},"end":{"line":124,"character":9999}},"line":113},{"containerName":"new","kind":12,"name":"SUPER","line":115},{"children":[{"line":139,"kind":13,"localvar":"my","containerName":"strict","name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"strict","line":139},{"line":140,"name":"$value","kind":13,"containerName":"strict"},{"line":141,"containerName":"strict","kind":13,"name":"$self"},{"line":141,"name":"$value","kind":13,"containerName":"strict"},{"name":"$self","containerName":"strict","kind":13,"line":143}],"name":"strict","containerName":"main::","definition":"sub","detail":"($self,$value)","line":138,"kind":12,"range":{"end":{"character":9999,"line":144},"start":{"line":138,"character":0}},"signature":{"label":"strict($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ExtrapolatingPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::ExtrapolatingPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::ExtrapolatingPair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::ExtrapolatingPair;\n\n\n  $match1 = Bio::Location::Simple->new \n    (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  $match2 = Bio::Location::Simple->new\n    (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n\n  $pair = Bio::Coordinate::ExtrapolatingPair->\n    new(-in => $match1,\n    \t-out => $match2,\n    \t-strict => 1\n       );\n\n  $pos = Bio::Location::Simple->new \n      (-start => 40, -end => 60, -strand=> 1 );\n  $res = $pair->map($pos);\n  $res->start eq 20;\n  $res->end eq 20;\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThis class is an elaboration of Bio::Coordinate::Pair. The map\nfunction returns only matches which is the mode needed most of\ntehtime. By default the matching regions between coordinate systems\nare boundless, so that you can say e.g. that gene starts from here in\nthe chromosomal coordinate system and extends indefinetely in both\ndirections. If you want to define the matching regions exactly, you\ncan do that and set strict() to true.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::ExtrapolatingPair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::LocationI;\n\nuse base qw(Bio::Coordinate::Pair);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($strict) =\n\t$self->_rearrange([qw(STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    $strict  && $self->strict($strict);\n    return $self;\n}\n\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict(1);\n Function: Set and read the strictness of the coordinate system.\n Example :\n Returns : value of input system\n Args    : boolean"}},{"range":{"end":{"character":9999,"line":191},"start":{"line":162,"character":0}},"kind":12,"line":162,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ExtrapolatingPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::ExtrapolatingPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::ExtrapolatingPair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::ExtrapolatingPair;\n\n\n  $match1 = Bio::Location::Simple->new \n    (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  $match2 = Bio::Location::Simple->new\n    (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n\n  $pair = Bio::Coordinate::ExtrapolatingPair->\n    new(-in => $match1,\n    \t-out => $match2,\n    \t-strict => 1\n       );\n\n  $pos = Bio::Location::Simple->new \n      (-start => 40, -end => 60, -strand=> 1 );\n  $res = $pair->map($pos);\n  $res->start eq 20;\n  $res->end eq 20;\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThis class is an elaboration of Bio::Coordinate::Pair. The map\nfunction returns only matches which is the mode needed most of\ntehtime. By default the matching regions between coordinate systems\nare boundless, so that you can say e.g. that gene starts from here in\nthe chromosomal coordinate system and extends indefinetely in both\ndirections. If you want to define the matching regions exactly, you\ncan do that and set strict() to true.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::ExtrapolatingPair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::LocationI;\n\nuse base qw(Bio::Coordinate::Pair);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($strict) =\n\t$self->_rearrange([qw(STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    $strict  && $self->strict($strict);\n    return $self;\n}\n\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict(1);\n Function: Set and read the strictness of the coordinate system.\n Example :\n Returns : value of input system\n Args    : boolean\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->{'_strict'} = 1 if $value;\n   }\n   return $self->{'_strict'};\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($loc);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n\n           In extrapolating coodinate system there is no location zero.\n           Locations are...\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple","label":"map($self,$value)"},"containerName":"main::","name":"map","children":[{"kind":13,"localvar":"my","containerName":"map","name":"$self","line":163,"definition":"my"},{"line":163,"name":"$value","kind":13,"containerName":"map"},{"containerName":"map","kind":13,"name":"$self","line":165},{"name":"throw","containerName":"map","kind":12,"line":165},{"kind":13,"containerName":"map","name":"$value","line":166},{"line":167,"name":"$self","kind":13,"containerName":"map"},{"containerName":"map","kind":12,"name":"throw","line":167},{"line":168,"name":"$value","containerName":"map","kind":13},{"kind":12,"containerName":"map","name":"isa","line":168},{"line":169,"name":"$self","containerName":"map","kind":13},{"line":169,"kind":12,"containerName":"map","name":"throw"},{"line":170,"containerName":"map","kind":13,"name":"$self"},{"containerName":"map","kind":12,"name":"in","line":170},{"name":"$self","kind":13,"containerName":"map","line":171},{"kind":12,"containerName":"map","name":"throw","line":171},{"line":172,"name":"$self","kind":13,"containerName":"map"},{"line":172,"name":"out","containerName":"map","kind":12},{"definition":"my","containerName":"map","localvar":"my","kind":13,"name":"$match","line":174},{"line":176,"name":"$value","kind":13,"containerName":"map"},{"kind":12,"containerName":"map","name":"isa","line":176},{"containerName":"map","localvar":"my","kind":13,"name":"$split","line":178,"definition":"my"},{"name":"new","kind":12,"containerName":"map","line":178},{"line":178,"containerName":"map","kind":13,"name":"$self"},{"line":178,"kind":12,"containerName":"map","name":"out"},{"line":178,"name":"seq_id","containerName":"map","kind":12},{"localvar":"my","kind":13,"containerName":"map","name":"$loc","line":179,"definition":"my"},{"line":179,"name":"$a","containerName":"map","kind":13},{"line":179,"name":"start","containerName":"map","kind":12},{"kind":13,"containerName":"map","name":"$b","line":179},{"line":179,"containerName":"map","kind":12,"name":"start"},{"name":"$value","containerName":"map","kind":13,"line":180},{"line":180,"name":"sub_Location","containerName":"map","kind":12},{"containerName":"map","kind":13,"name":"$match","line":182},{"containerName":"map","kind":13,"name":"$self","line":182},{"line":182,"name":"_map","kind":12,"containerName":"map"},{"line":182,"kind":13,"containerName":"map","name":"$loc"},{"kind":13,"containerName":"map","name":"$split","line":183},{"line":183,"kind":12,"containerName":"map","name":"add_sub_Location"},{"containerName":"map","kind":13,"name":"$match","line":183},{"kind":13,"containerName":"map","name":"$match","line":183},{"name":"$split","kind":13,"containerName":"map","line":186},{"name":"each_Location","containerName":"map","kind":12,"line":186},{"name":"$split","kind":13,"containerName":"map","line":186},{"line":189,"kind":13,"containerName":"map","name":"$self"},{"containerName":"map","kind":12,"name":"_map","line":189},{"containerName":"map","kind":13,"name":"$value","line":189}],"detail":"($self,$value)","definition":"sub"},{"line":178,"name":"Bio","containerName":"Coordinate::Result","kind":12},{"children":[{"line":209,"name":"$self","localvar":"my","kind":13,"containerName":"_map","definition":"my"},{"name":"$value","kind":13,"containerName":"_map","line":209},{"definition":"my","line":211,"localvar":"my","containerName":"_map","kind":13,"name":"$offset"},{"line":211,"containerName":"_map","kind":13,"name":"$start"},{"line":211,"containerName":"_map","kind":13,"name":"$end"},{"name":"$self","containerName":"_map","kind":13,"line":213},{"name":"strand","containerName":"_map","kind":12,"line":213},{"name":"$offset","containerName":"_map","kind":13,"line":214},{"line":214,"name":"$self","containerName":"_map","kind":13},{"line":214,"name":"in","containerName":"_map","kind":12},{"kind":12,"containerName":"_map","name":"end","line":214},{"line":214,"name":"$self","kind":13,"containerName":"_map"},{"name":"out","containerName":"_map","kind":12,"line":214},{"name":"start","containerName":"_map","kind":12,"line":214},{"line":215,"name":"$start","kind":13,"containerName":"_map"},{"name":"$offset","containerName":"_map","kind":13,"line":215},{"name":"$value","kind":13,"containerName":"_map","line":215},{"name":"end","containerName":"_map","kind":12,"line":215},{"line":216,"name":"$end","containerName":"_map","kind":13},{"line":216,"name":"$offset","kind":13,"containerName":"_map"},{"line":216,"name":"$value","kind":13,"containerName":"_map"},{"line":216,"kind":12,"containerName":"_map","name":"start"},{"line":218,"containerName":"_map","kind":13,"name":"$offset"},{"line":218,"name":"$self","containerName":"_map","kind":13},{"name":"in","kind":12,"containerName":"_map","line":218},{"line":218,"kind":12,"containerName":"_map","name":"start"},{"line":218,"kind":13,"containerName":"_map","name":"$self"},{"name":"out","containerName":"_map","kind":12,"line":218},{"line":218,"name":"start","kind":12,"containerName":"_map"},{"name":"$start","containerName":"_map","kind":13,"line":219},{"kind":13,"containerName":"_map","name":"$value","line":219},{"line":219,"name":"start","kind":12,"containerName":"_map"},{"line":219,"name":"$offset","kind":13,"containerName":"_map"},{"kind":13,"containerName":"_map","name":"$end","line":220},{"containerName":"_map","kind":13,"name":"$value","line":220},{"containerName":"_map","kind":12,"name":"end","line":220},{"name":"$offset","kind":13,"containerName":"_map","line":220},{"containerName":"_map","kind":13,"name":"$self","line":224},{"name":"strict","kind":12,"containerName":"_map","line":224},{"containerName":"_map","kind":13,"name":"$start","line":225},{"kind":13,"containerName":"_map","name":"$end","line":225},{"line":226,"name":"$start","containerName":"_map","kind":13},{"containerName":"_map","kind":13,"name":"$self","line":226},{"line":226,"kind":12,"containerName":"_map","name":"out"},{"line":226,"name":"end","containerName":"_map","kind":12},{"name":"$start","containerName":"_map","kind":13,"line":227},{"containerName":"_map","kind":13,"name":"$start","line":227},{"line":228,"containerName":"_map","kind":13,"name":"$end"},{"line":228,"name":"$self","kind":13,"containerName":"_map"},{"name":"out","containerName":"_map","kind":12,"line":228},{"containerName":"_map","kind":12,"name":"end","line":228},{"line":228,"name":"$end","containerName":"_map","kind":13},{"line":228,"name":"$self","containerName":"_map","kind":13},{"line":228,"containerName":"_map","kind":12,"name":"out"},{"line":228,"containerName":"_map","kind":12,"name":"end"},{"definition":"my","name":"$match","localvar":"my","kind":13,"containerName":"_map","line":231},{"line":232,"name":"new","kind":12,"containerName":"_map"},{"containerName":"_map","kind":13,"name":"$start","line":232},{"name":"$end","kind":13,"containerName":"_map","line":233},{"name":"$self","containerName":"_map","kind":13,"line":234},{"kind":12,"containerName":"_map","name":"strand","line":234},{"name":"$self","containerName":"_map","kind":13,"line":235},{"line":235,"kind":12,"containerName":"_map","name":"out"},{"name":"seq_id","containerName":"_map","kind":12,"line":235},{"line":236,"name":"$value","containerName":"_map","kind":13},{"containerName":"_map","kind":12,"name":"location_type","line":237},{"containerName":"_map","kind":13,"name":"$match","line":238},{"containerName":"_map","kind":12,"name":"strand","line":238},{"name":"$match","containerName":"_map","kind":13,"line":238},{"line":238,"name":"strand","containerName":"_map","kind":12},{"line":238,"containerName":"_map","kind":13,"name":"$value"},{"containerName":"_map","kind":12,"name":"strand","line":238},{"line":238,"kind":13,"containerName":"_map","name":"$value"},{"kind":12,"containerName":"_map","name":"strand","line":238},{"containerName":"_map","kind":13,"name":"$match","line":239},{"line":241,"containerName":"_map","kind":13,"name":"$match"}],"containerName":"main::","name":"_map","definition":"sub","detail":"($self,$value)","line":208,"kind":12,"range":{"start":{"character":0,"line":208},"end":{"character":9999,"line":242}},"signature":{"label":"_map($self,$value)","documentation":"1;\n# $Id: ExtrapolatingPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::ExtrapolatingPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::ExtrapolatingPair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::ExtrapolatingPair;\n\n\n  $match1 = Bio::Location::Simple->new \n    (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  $match2 = Bio::Location::Simple->new\n    (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n\n  $pair = Bio::Coordinate::ExtrapolatingPair->\n    new(-in => $match1,\n    \t-out => $match2,\n    \t-strict => 1\n       );\n\n  $pos = Bio::Location::Simple->new \n      (-start => 40, -end => 60, -strand=> 1 );\n  $res = $pair->map($pos);\n  $res->start eq 20;\n  $res->end eq 20;\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThis class is an elaboration of Bio::Coordinate::Pair. The map\nfunction returns only matches which is the mode needed most of\ntehtime. By default the matching regions between coordinate systems\nare boundless, so that you can say e.g. that gene starts from here in\nthe chromosomal coordinate system and extends indefinetely in both\ndirections. If you want to define the matching regions exactly, you\ncan do that and set strict() to true.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::ExtrapolatingPair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::LocationI;\n\nuse base qw(Bio::Coordinate::Pair);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($strict) =\n\t$self->_rearrange([qw(STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    $strict  && $self->strict($strict);\n    return $self;\n}\n\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict(1);\n Function: Set and read the strictness of the coordinate system.\n Example :\n Returns : value of input system\n Args    : boolean\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->{'_strict'} = 1 if $value;\n   }\n   return $self->{'_strict'};\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($loc);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n\n           In extrapolating coodinate system there is no location zero.\n           Locations are...\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a value.\")\n       unless defined $value;\n   $self->throw(\"I need a Bio::Location, not [$value]\")\n       unless $value->isa('Bio::LocationI');\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->in;\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->out;\n\n   my $match;\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n\n       my $split = Bio::Coordinate::Result->new(-seq_id=>$self->out->seq_id);\n       foreach my $loc ( sort { $a->start <=> $b->start }\n                         $value->sub_Location ) {\n\n           $match = $self->_map($loc);\n           $split->add_sub_Location($match) if $match;\n\n       }\n       $split->each_Location ? (return $split) : return ;\n\n   } else {\n       return $self->_map($value);\n   }\n}\n\n\n=head2 _map\n\n Title   : _map\n Usage   : $newpos = $obj->_map($simpleloc);\n Function: Internal method that does the actual mapping. Called\n           multiple times by map() if the location to be mapped is a\n           split location\n\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple","parameters":[{"label":"$self"},{"label":"$value"}]}},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":231}]}