{"vars":[{"name":"base","kind":2,"containerName":"","line":92},{"kind":12,"range":{"end":{"character":9999,"line":110},"start":{"character":0,"line":107}},"line":107,"signature":{"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id","parameters":[{"label":"$self"}],"label":"unigene_id($self)"},"name":"unigene_id","containerName":"main::","children":[{"localvar":"my","containerName":"unigene_id","kind":13,"name":"$self","line":108,"definition":"my"},{"line":109,"name":"$self","kind":13,"containerName":"unigene_id"},{"line":109,"name":"throw_not_implemented","containerName":"unigene_id","kind":12}],"detail":"($self)","definition":"sub"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"title","children":[{"definition":"my","containerName":"title","localvar":"my","kind":13,"name":"$self","line":127},{"containerName":"title","kind":13,"name":"$self","line":128},{"line":128,"name":"throw_not_implemented","kind":12,"containerName":"title"}],"signature":{"label":"title($self)","documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":129,"character":9999},"start":{"line":126,"character":0}},"line":126},{"detail":"($self)","definition":"sub","name":"gene","containerName":"main::","children":[{"definition":"my","line":145,"localvar":"my","containerName":"gene","kind":13,"name":"$self"},{"line":146,"name":"$self","containerName":"gene","kind":13},{"name":"throw_not_implemented","containerName":"gene","kind":12,"line":146}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene","label":"gene($self)"},"kind":12,"range":{"end":{"line":147,"character":9999},"start":{"character":0,"line":144}},"line":144},{"detail":"($self)","definition":"sub","containerName":"main::","name":"cytoband","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"cytoband","line":163,"definition":"my"},{"line":164,"kind":13,"containerName":"cytoband","name":"$self"},{"line":164,"kind":12,"containerName":"cytoband","name":"throw_not_implemented"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband","label":"cytoband($self)"},"range":{"end":{"line":165,"character":9999},"start":{"character":0,"line":162}},"kind":12,"line":162},{"detail":"($self)","definition":"sub","containerName":"main::","name":"mgi","children":[{"line":181,"containerName":"mgi","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":182,"name":"$self","kind":13,"containerName":"mgi"},{"line":182,"name":"throw_not_implemented","containerName":"mgi","kind":12}],"signature":{"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi","parameters":[{"label":"$self"}],"label":"mgi($self)"},"kind":12,"range":{"end":{"character":9999,"line":183},"start":{"line":180,"character":0}},"line":180},{"detail":"($self)","definition":"sub","containerName":"main::","name":"locuslink","children":[{"name":"$self","localvar":"my","containerName":"locuslink","kind":13,"line":198,"definition":"my"},{"name":"$self","containerName":"locuslink","kind":13,"line":199},{"containerName":"locuslink","kind":12,"name":"throw_not_implemented","line":199}],"signature":{"label":"locuslink($self)","documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"character":9999,"line":200},"start":{"character":0,"line":197}},"line":197},{"range":{"end":{"character":9999,"line":217},"start":{"character":0,"line":214}},"kind":12,"line":214,"signature":{"label":"homol($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry"},"containerName":"main::","name":"homol","children":[{"name":"$self","localvar":"my","containerName":"homol","kind":13,"line":215,"definition":"my"},{"line":216,"kind":13,"containerName":"homol","name":"$self"},{"kind":12,"containerName":"homol","name":"throw_not_implemented","line":216}],"detail":"($self)","definition":"sub"},{"line":231,"range":{"end":{"character":9999,"line":234},"start":{"line":231,"character":0}},"kind":12,"signature":{"label":"restr_expr($self)","documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry","parameters":[{"label":"$self"}]},"children":[{"definition":"my","localvar":"my","containerName":"restr_expr","kind":13,"name":"$self","line":232},{"kind":13,"containerName":"restr_expr","name":"$self","line":233},{"containerName":"restr_expr","kind":12,"name":"throw_not_implemented","line":233}],"name":"restr_expr","containerName":"main::","definition":"sub","detail":"($self)"},{"containerName":"main::","name":"gnm_terminus","children":[{"line":249,"localvar":"my","containerName":"gnm_terminus","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"gnm_terminus","name":"$self","line":250},{"line":250,"containerName":"gnm_terminus","kind":12,"name":"throw_not_implemented"}],"detail":"($self)","definition":"sub","range":{"end":{"line":251,"character":9999},"start":{"line":248,"character":0}},"kind":12,"line":248,"signature":{"label":"gnm_terminus($self)","documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus","parameters":[{"label":"$self"}]}},{"kind":12,"range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":268}},"line":265,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount","label":"scount($self)"},"containerName":"main::","name":"scount","children":[{"definition":"my","line":266,"name":"$self","localvar":"my","containerName":"scount","kind":13},{"line":267,"kind":13,"containerName":"scount","name":"$self"},{"line":267,"kind":12,"containerName":"scount","name":"throw_not_implemented"}],"detail":"($self)","definition":"sub"},{"containerName":"main::","name":"express","children":[{"line":284,"name":"$self","containerName":"express","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"express","name":"$self","line":285},{"containerName":"express","kind":12,"name":"throw_not_implemented","line":285}],"detail":"($self)","definition":"sub","range":{"start":{"line":283,"character":0},"end":{"character":9999,"line":286}},"kind":12,"line":283,"signature":{"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing tissue expression data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference","parameters":[{"label":"$self"}],"label":"express($self)"}},{"detail":"($self)","definition":"sub","containerName":"main::","name":"chromosome","children":[{"line":301,"name":"$self","kind":13,"localvar":"my","containerName":"chromosome","definition":"my"},{"line":302,"name":"$self","containerName":"chromosome","kind":13},{"line":302,"name":"throw_not_implemented","containerName":"chromosome","kind":12}],"signature":{"label":"chromosome($self)","documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing tissue expression data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing chromosome lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":303,"character":9999},"start":{"line":300,"character":0}},"line":300},{"children":[{"line":318,"localvar":"my","containerName":"sts","kind":13,"name":"$self","definition":"my"},{"containerName":"sts","kind":13,"name":"$self","line":319},{"line":319,"name":"throw_not_implemented","kind":12,"containerName":"sts"}],"name":"sts","containerName":"main::","definition":"sub","detail":"($self)","line":317,"range":{"start":{"line":317,"character":0},"end":{"line":320,"character":9999}},"kind":12,"signature":{"label":"sts($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing tissue expression data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing chromosome lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference"}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing tissue expression data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing chromosome lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n Returns : An array reference\n Args    : None or an array reference","label":"txmap($self)"},"kind":12,"range":{"start":{"line":333,"character":0},"end":{"line":336,"character":9999}},"line":333,"detail":"($self)","definition":"sub","containerName":"main::","name":"txmap","children":[{"line":334,"name":"$self","localvar":"my","containerName":"txmap","kind":13,"definition":"my"},{"line":335,"name":"$self","kind":13,"containerName":"txmap"},{"line":335,"name":"throw_not_implemented","containerName":"txmap","kind":12}]},{"range":{"end":{"line":353,"character":9999},"start":{"character":0,"line":350}},"kind":12,"line":350,"signature":{"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing tissue expression data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing chromosome lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference","parameters":[{"label":"$self"}],"label":"protsim($self)"},"containerName":"main::","name":"protsim","children":[{"definition":"my","containerName":"protsim","localvar":"my","kind":13,"name":"$self","line":351},{"line":352,"name":"$self","containerName":"protsim","kind":13},{"line":352,"containerName":"protsim","kind":12,"name":"throw_not_implemented"}],"detail":"($self)","definition":"sub"},{"range":{"start":{"character":0,"line":367},"end":{"character":9999,"line":370}},"kind":12,"line":367,"signature":{"documentation":"1;\n# $Id: UniGeneI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGeneI.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://anatomy.otago.ac.nz/meg\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 31, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGeneI - abstract interface of UniGene object\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis is the general interface for a UniGene cluster representation in\nBioperl. You cannot use this module directly, use an implementation\ninstead.\n\nYou can create UniGene cluster objects yourself by instantiating\nL<Bio::Cluster::UniGene>. If you read UniGene clusters from a\nClusterIO parser, you will get objects implementing this interface,\nmost likely instances of said UniGene class.\n\nL<Bio::Cluster::UniGeneI> inherits from L<Bio::ClusterI>, so you can\nuse it wherever a cluster object is expected.\n\n=head1 FEEDBACK\n\n  #\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGeneI;\nuse strict;\n\n\nuse base qw(Bio::ClusterI);\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing tissue expression data.\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing chromosome lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 sequence\n\n Title   : sequence\n Usage   : sequence();\n Function: Returns or stores a reference to an array containing sequence data\n           This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference","parameters":[{"label":"$self"}],"label":"sequence($self)"},"containerName":"main::","name":"sequence","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"sequence","name":"$self","line":368},{"name":"$self","containerName":"sequence","kind":13,"line":369},{"name":"throw_not_implemented","kind":12,"containerName":"sequence","line":369}],"detail":"($self)","definition":"sub"},{"containerName":"main::","name":"species","children":[{"line":385,"kind":12,"containerName":"species","name":"throw_not_implemented"}],"definition":"sub","kind":12,"range":{"end":{"line":386,"character":9999},"start":{"line":384,"character":0}},"line":384}],"version":5}