{"version":5,"vars":[{"line":194,"kind":2,"containerName":"","name":"base"},{"definition":"my","line":196,"containerName":null,"localvar":"my","kind":13,"name":"%species_map"},{"containerName":"main::","name":"new","children":[{"name":"$caller","localvar":"my","containerName":"new","kind":13,"line":260,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":260},{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"new","line":261},{"name":"$caller","containerName":"new","kind":13,"line":261},{"kind":13,"containerName":"new","name":"@args","line":261},{"definition":"my","line":263,"kind":13,"localvar":"my","containerName":"new","name":"$ugid"},{"name":"$desc","kind":13,"containerName":"new","line":263},{"containerName":"new","kind":13,"name":"$mems","line":263},{"name":"$size","containerName":"new","kind":13,"line":263},{"name":"$species","kind":13,"containerName":"new","line":263},{"line":263,"name":"$dispid","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$id","line":263},{"name":"$ns","kind":13,"containerName":"new","line":263},{"name":"$auth","kind":13,"containerName":"new","line":263},{"line":263,"name":"$v","kind":13,"containerName":"new"},{"line":263,"name":"$seqfact","containerName":"new","kind":13},{"line":264,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"_rearrange","line":264},{"line":275,"name":"@args","kind":13,"containerName":"new"},{"line":277,"name":"$self","kind":13,"containerName":"new"},{"line":279,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"unigene_id","line":279},{"name":"$ugid","containerName":"new","kind":13,"line":279},{"name":"$ugid","kind":13,"containerName":"new","line":279},{"line":280,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"description","line":280},{"line":280,"name":"$desc","containerName":"new","kind":13},{"line":280,"containerName":"new","kind":13,"name":"$desc"},{"line":281,"containerName":"new","kind":13,"name":"$self"},{"line":281,"name":"sequences","containerName":"new","kind":12},{"line":281,"containerName":"new","kind":13,"name":"$mems"},{"line":281,"name":"$mems","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":282},{"name":"size","containerName":"new","kind":12,"line":282},{"containerName":"new","kind":13,"name":"$size","line":282},{"name":"$size","containerName":"new","kind":13,"line":282},{"kind":13,"containerName":"new","name":"$self","line":283},{"line":283,"name":"display_id","containerName":"new","kind":12},{"line":283,"containerName":"new","kind":13,"name":"$dispid"},{"line":283,"containerName":"new","kind":13,"name":"$dispid"},{"kind":13,"containerName":"new","name":"$self","line":284},{"name":"object_id","kind":12,"containerName":"new","line":284},{"line":284,"name":"$id","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$id","line":284},{"name":"$self","containerName":"new","kind":13,"line":285},{"line":285,"name":"namespace","containerName":"new","kind":12},{"line":285,"name":"$ns","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":286},{"line":286,"kind":12,"containerName":"new","name":"authority"},{"kind":13,"containerName":"new","name":"$auth","line":286},{"name":"$self","kind":13,"containerName":"new","line":287},{"kind":12,"containerName":"new","name":"version","line":287},{"name":"$v","kind":13,"containerName":"new","line":287},{"containerName":"new","kind":13,"name":"$v","line":287},{"name":"$seqfact","kind":13,"containerName":"new","line":288},{"containerName":"new","kind":13,"name":"$seqfact","line":289},{"name":"new","kind":12,"containerName":"new","line":290},{"line":290,"containerName":"new","kind":13,"name":"$self"},{"name":"verbose","containerName":"new","kind":12,"line":290},{"line":293,"name":"$self","containerName":"new","kind":13},{"line":293,"name":"sequence_factory","kind":12,"containerName":"new"},{"name":"$seqfact","containerName":"new","kind":13,"line":293},{"line":294,"kind":13,"containerName":"new","name":"$species"},{"name":"$self","kind":13,"containerName":"new","line":294},{"line":294,"containerName":"new","kind":12,"name":"unigene_id"},{"kind":13,"containerName":"new","name":"$self","line":295},{"name":"unigene_id","kind":12,"containerName":"new","line":295},{"line":297,"name":"$species","kind":13,"containerName":"new"},{"name":"$species_map","kind":13,"containerName":"new","line":297},{"kind":13,"containerName":"new","name":"$self","line":299},{"line":299,"name":"species","containerName":"new","kind":12},{"line":299,"name":"$species","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":300}],"detail":"($caller,@args)","definition":"sub","kind":12,"range":{"start":{"line":258,"character":0},"end":{"character":9999,"line":301}},"line":258,"signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object"}},{"kind":12,"containerName":"new","name":"SUPER","line":261},{"name":"Bio","containerName":"Seq::SeqFactory","kind":12,"line":289},{"name":"unigene_id","containerName":"main::","children":[{"definition":"my","line":321,"kind":13,"localvar":"my","containerName":"unigene_id","name":"$obj"},{"name":"$value","kind":13,"containerName":"unigene_id","line":321},{"line":322,"name":"$value","kind":13,"containerName":"unigene_id"},{"containerName":"unigene_id","kind":13,"name":"$obj","line":323},{"line":323,"containerName":"unigene_id","kind":13,"name":"$value"},{"line":325,"name":"$obj","containerName":"unigene_id","kind":13}],"detail":"($obj,$value)","definition":"sub","kind":12,"range":{"end":{"line":326,"character":9999},"start":{"line":320,"character":0}},"line":320,"signature":{"label":"unigene_id($obj,$value)","documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id","parameters":[{"label":"$obj"},{"label":"$value"}]}},{"signature":{"label":"title($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title"},"line":342,"kind":12,"range":{"start":{"character":0,"line":342},"end":{"character":9999,"line":348}},"definition":"sub","detail":"($obj,$value)","children":[{"definition":"my","line":343,"name":"$obj","localvar":"my","containerName":"title","kind":13},{"containerName":"title","kind":13,"name":"$value","line":343},{"line":344,"containerName":"title","kind":13,"name":"$value"},{"line":345,"containerName":"title","kind":13,"name":"$obj"},{"containerName":"title","kind":13,"name":"$value","line":345},{"containerName":"title","kind":13,"name":"$obj","line":347}],"containerName":"main::","name":"title"},{"kind":12,"range":{"start":{"character":0,"line":363},"end":{"line":366,"character":9999}},"line":363,"definition":"sub","name":"gene","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"gene","kind":13,"line":364},{"line":365,"kind":13,"containerName":"gene","name":"$self"},{"name":"_annotation_value","kind":12,"containerName":"gene","line":365}]},{"line":381,"range":{"start":{"character":0,"line":381},"end":{"character":9999,"line":384}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"cytoband","line":382},{"containerName":"cytoband","kind":13,"name":"$self","line":383},{"line":383,"name":"_annotation_value","kind":12,"containerName":"cytoband"}],"containerName":"main::","name":"cytoband"},{"line":398,"kind":12,"range":{"start":{"line":398,"character":0},"end":{"line":413,"character":9999}},"children":[{"localvar":"my","kind":13,"containerName":"mgi","name":"$self","line":399,"definition":"my"},{"definition":"my","line":400,"name":"$acc","localvar":"my","kind":13,"containerName":"mgi"},{"kind":13,"containerName":"mgi","name":"$self","line":404},{"kind":12,"containerName":"mgi","name":"_remove_dblink","line":404},{"line":406,"name":"$acc","kind":13,"containerName":"mgi"},{"line":407,"containerName":"mgi","kind":13,"name":"$self"},{"containerName":"mgi","kind":12,"name":"_annotation_dblink","line":407},{"line":407,"kind":13,"containerName":"mgi","name":"$acc"},{"name":"$acc","containerName":"mgi","kind":13,"line":410},{"line":410,"name":"$self","kind":13,"containerName":"mgi"},{"name":"_annotation_dblink","containerName":"mgi","kind":12,"line":410},{"name":"$acc","containerName":"mgi","kind":13,"line":412}],"name":"mgi","containerName":"main::","definition":"sub"},{"signature":{"label":"locuslink($self,$ll)","documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference","parameters":[{"label":"$self"},{"label":"$ll"}]},"range":{"start":{"character":0,"line":426},"end":{"character":9999,"line":441}},"kind":12,"line":426,"detail":"($self,$ll)","definition":"sub","name":"locuslink","containerName":"main::","children":[{"line":427,"name":"$self","localvar":"my","containerName":"locuslink","kind":13,"definition":"my"},{"line":427,"containerName":"locuslink","kind":13,"name":"$ll"},{"name":"$ll","containerName":"locuslink","kind":13,"line":429},{"containerName":"locuslink","kind":13,"name":"$self","line":431},{"containerName":"locuslink","kind":12,"name":"_remove_dblink","line":431},{"localvar":"my","kind":13,"containerName":"locuslink","name":"$acc","line":433,"definition":"my"},{"kind":13,"containerName":"locuslink","name":"$ll","line":433},{"line":434,"kind":13,"containerName":"locuslink","name":"$self"},{"line":434,"kind":12,"containerName":"locuslink","name":"_annotation_dblink"},{"line":434,"name":"$acc","containerName":"locuslink","kind":13},{"containerName":"locuslink","localvar":"my","kind":13,"name":"@accs","line":437,"definition":"my"},{"line":437,"kind":13,"containerName":"locuslink","name":"$self"},{"line":437,"kind":12,"containerName":"locuslink","name":"_annotation_dblink"},{"line":438,"kind":13,"containerName":"locuslink","name":"$ll"},{"name":"@accs","kind":13,"containerName":"locuslink","line":438},{"name":"$ll","kind":13,"containerName":"locuslink","line":440}]},{"line":455,"range":{"start":{"line":455,"character":0},"end":{"character":9999,"line":458}},"kind":12,"children":[{"definition":"my","line":456,"localvar":"my","kind":13,"containerName":"homol","name":"$self"},{"containerName":"homol","kind":13,"name":"$self","line":457},{"line":457,"kind":12,"containerName":"homol","name":"_annotation_value"}],"containerName":"main::","name":"homol","definition":"sub"},{"containerName":"main::","name":"restr_expr","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"restr_expr","line":473,"definition":"my"},{"kind":13,"containerName":"restr_expr","name":"$self","line":474},{"containerName":"restr_expr","kind":12,"name":"_annotation_value","line":474}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":475},"start":{"line":472,"character":0}},"line":472},{"kind":12,"range":{"start":{"character":0,"line":490},"end":{"character":9999,"line":493}},"line":490,"definition":"sub","name":"gnm_terminus","containerName":"main::","children":[{"definition":"my","containerName":"gnm_terminus","localvar":"my","kind":13,"name":"$self","line":491},{"line":492,"name":"$self","containerName":"gnm_terminus","kind":13},{"name":"_annotation_value","containerName":"gnm_terminus","kind":12,"line":492}]},{"signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"scount($obj,$value)"},"range":{"start":{"character":0,"line":506},"end":{"line":514,"character":9999}},"kind":12,"line":506,"detail":"($obj,$value)","definition":"sub","name":"scount","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"scount","name":"$obj","line":507,"definition":"my"},{"line":507,"name":"$value","kind":13,"containerName":"scount"},{"line":508,"kind":13,"containerName":"scount","name":"$value"},{"line":509,"kind":13,"containerName":"scount","name":"$obj"},{"name":"$value","containerName":"scount","kind":13,"line":509},{"name":"$obj","kind":13,"containerName":"scount","line":510},{"line":510,"kind":13,"containerName":"scount","name":"$obj"},{"containerName":"scount","kind":12,"name":"sequences","line":510},{"line":511,"containerName":"scount","kind":13,"name":"$obj"},{"line":511,"name":"$obj","kind":13,"containerName":"scount"},{"line":511,"containerName":"scount","kind":12,"name":"size"},{"name":"$obj","containerName":"scount","kind":13,"line":513}]},{"containerName":"main::","name":"express","children":[{"line":529,"containerName":"express","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"express","name":"$self","line":531},{"name":"_annotation_value_ary","kind":12,"containerName":"express","line":531}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":528},"end":{"line":532,"character":9999}},"line":528},{"containerName":"main::","name":"chromosome","children":[{"definition":"my","line":547,"localvar":"my","kind":13,"containerName":"chromosome","name":"$self"},{"kind":13,"containerName":"chromosome","name":"$self","line":549},{"containerName":"chromosome","kind":12,"name":"_annotation_value_ary","line":549}],"definition":"sub","kind":12,"range":{"end":{"line":550,"character":9999},"start":{"character":0,"line":546}},"line":546},{"containerName":"main::","name":"sts","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"sts","kind":13,"line":565},{"containerName":"sts","kind":13,"name":"$self","line":567},{"line":567,"name":"_annotation_value_ary","containerName":"sts","kind":12}],"definition":"sub","range":{"end":{"line":568,"character":9999},"start":{"line":564,"character":0}},"kind":12,"line":564},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"txmap","line":583},{"line":585,"containerName":"txmap","kind":13,"name":"$self"},{"kind":12,"containerName":"txmap","name":"_annotation_value_ary","line":585}],"containerName":"main::","name":"txmap","definition":"sub","line":582,"kind":12,"range":{"end":{"line":586,"character":9999},"start":{"character":0,"line":582}}},{"children":[{"definition":"my","line":601,"name":"$self","kind":13,"localvar":"my","containerName":"protsim"},{"kind":13,"containerName":"protsim","name":"$self","line":603},{"line":603,"name":"_annotation_value_ary","containerName":"protsim","kind":12}],"name":"protsim","containerName":"main::","definition":"sub","line":600,"range":{"end":{"character":9999,"line":604},"start":{"line":600,"character":0}},"kind":12},{"range":{"start":{"line":623,"character":0},"end":{"character":9999,"line":628}},"kind":12,"line":623,"definition":"sub","name":"sequences","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"sequences","name":"$self","line":624,"definition":"my"},{"line":626,"name":"$self","containerName":"sequences","kind":13},{"line":627,"containerName":"sequences","kind":13,"name":"$self"}]},{"line":643,"kind":12,"range":{"start":{"character":0,"line":643},"end":{"character":9999,"line":655}},"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"species","name":"$self","line":644},{"definition":"my","localvar":"my","containerName":"species","kind":13,"name":"$species","line":647},{"line":648,"name":"$species","kind":13,"containerName":"species"},{"kind":13,"containerName":"species","name":"$species","line":648},{"definition":"my","line":649,"containerName":"species","localvar":"my","kind":13,"name":"@class"},{"kind":13,"containerName":"species","name":"$species","line":649},{"containerName":"species","kind":13,"name":"$species","line":650},{"line":650,"containerName":"species","kind":12,"name":"new"},{"line":650,"containerName":"species","kind":13,"name":"@class"},{"kind":13,"containerName":"species","name":"$self","line":652},{"line":652,"name":"$species","kind":13,"containerName":"species"},{"name":"$self","containerName":"species","kind":13,"line":654}],"containerName":"main::","name":"species"},{"name":"Bio","kind":12,"containerName":"Species","line":650},{"definition":"sub","children":[{"name":"unigene_id","kind":12,"containerName":"display_id","line":676}],"containerName":"main::","name":"display_id","line":675,"kind":12,"range":{"end":{"character":9999,"line":677},"start":{"character":0,"line":675}}},{"line":692,"range":{"end":{"line":694,"character":9999},"start":{"line":692,"character":0}},"kind":12,"children":[{"line":693,"name":"title","kind":12,"containerName":"description"}],"containerName":"main::","name":"description","definition":"sub"},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"size","line":711,"definition":"my"},{"name":"$self","containerName":"size","kind":13,"line":714},{"name":"scount","kind":12,"containerName":"size","line":714},{"name":"$self","containerName":"size","kind":13,"line":714},{"containerName":"size","kind":12,"name":"sequences","line":714},{"definition":"my","name":"$n","localvar":"my","containerName":"size","kind":13,"line":716},{"line":716,"name":"$self","kind":13,"containerName":"size"},{"name":"sequences","containerName":"size","kind":12,"line":716}],"name":"size","containerName":"main::","line":710,"range":{"start":{"character":0,"line":710},"end":{"line":716,"character":9999}},"kind":12},{"name":"@n","kind":13,"containerName":null,"line":717},{"name":"$self","containerName":null,"kind":13,"line":718},{"line":718,"name":"throw","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$n","line":721},{"kind":12,"range":{"end":{"character":9999,"line":747},"start":{"character":0,"line":742}},"line":742,"name":"cluster_score","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"cluster_score","name":"$self","line":743},{"kind":13,"containerName":"cluster_score","name":"$self","line":745},{"name":"$self","containerName":"cluster_score","kind":13,"line":746}],"definition":"sub"},{"line":765,"range":{"start":{"character":0,"line":765},"end":{"line":782,"character":9999}},"kind":12,"definition":"sub","children":[{"line":766,"name":"$self","kind":13,"localvar":"my","containerName":"get_members","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"get_members","name":"$mems","line":768},{"containerName":"get_members","kind":13,"name":"$self","line":768},{"kind":12,"containerName":"get_members","name":"sequences","line":768},{"line":770,"kind":13,"containerName":"get_members","name":"$mems"},{"kind":13,"containerName":"get_members","name":"$mems","line":770},{"definition":"my","name":"@memlist","localvar":"my","kind":13,"containerName":"get_members","line":772},{"definition":"my","line":773,"localvar":"my","kind":13,"containerName":"get_members","name":"$seq"},{"line":773,"kind":13,"containerName":"get_members","name":"$self"},{"containerName":"get_members","kind":12,"name":"next_seq","line":773},{"line":774,"name":"@memlist","containerName":"get_members","kind":13},{"line":774,"name":"$seq","kind":13,"containerName":"get_members"},{"line":777,"name":"$mems","containerName":"get_members","kind":13},{"line":777,"name":"@memlist","containerName":"get_members","kind":13},{"name":"$self","containerName":"get_members","kind":13,"line":778},{"line":778,"kind":12,"containerName":"get_members","name":"sequences"},{"kind":13,"containerName":"get_members","name":"$mems","line":778},{"line":781,"name":"$mems","kind":13,"containerName":"get_members"}],"name":"get_members","containerName":"main::"},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"annotation","line":815,"definition":"my"},{"name":"$self","kind":13,"containerName":"annotation","line":818},{"name":"$self","kind":13,"containerName":"annotation","line":819},{"containerName":"annotation","kind":13,"name":"$self","line":820},{"kind":12,"containerName":"annotation","name":"new","line":820},{"line":822,"name":"$self","containerName":"annotation","kind":13}],"containerName":"main::","name":"annotation","line":814,"range":{"end":{"character":9999,"line":823},"start":{"line":814,"character":0}},"kind":12},{"name":"Bio","kind":12,"containerName":"Annotation::Collection","line":820},{"signature":{"label":"add_member($self,@mems)","parameters":[{"label":"$self"},{"label":"@mems"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add."},"line":846,"range":{"start":{"character":0,"line":846},"end":{"character":9999,"line":861}},"kind":12,"definition":"sub","detail":"($self,@mems)","children":[{"definition":"my","line":847,"name":"$self","containerName":"add_member","localvar":"my","kind":13},{"name":"@mems","containerName":"add_member","kind":13,"line":847},{"definition":"my","line":849,"name":"$memlist","containerName":"add_member","localvar":"my","kind":13},{"name":"$self","containerName":"add_member","kind":13,"line":849},{"containerName":"add_member","kind":13,"name":"$memlist","line":851},{"line":851,"kind":13,"containerName":"add_member","name":"$memlist"},{"line":853,"kind":13,"containerName":"add_member","name":"$memlist"},{"line":853,"name":"$self","containerName":"add_member","kind":13},{"name":"get_members","kind":12,"containerName":"add_member","line":853},{"line":856,"kind":13,"containerName":"add_member","name":"$memlist"},{"containerName":"add_member","kind":13,"name":"@mems","line":856},{"name":"$self","kind":13,"containerName":"add_member","line":858},{"line":858,"name":"sequences","containerName":"add_member","kind":12},{"kind":13,"containerName":"add_member","name":"$memlist","line":858}],"name":"add_member","containerName":"main::"},{"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"remove_members","name":"$self","line":877,"definition":"my"},{"name":"@mems","localvar":"my","containerName":"remove_members","kind":13,"line":879,"definition":"my"},{"line":879,"kind":13,"containerName":"remove_members","name":"$self"},{"line":879,"name":"get_members","kind":12,"containerName":"remove_members"},{"line":880,"containerName":"remove_members","kind":13,"name":"$self"},{"line":880,"name":"sequences","kind":12,"containerName":"remove_members"},{"name":"@mems","kind":13,"containerName":"remove_members","line":881}],"name":"remove_members","containerName":"main::","line":876,"range":{"start":{"line":876,"character":0},"end":{"character":9999,"line":882}},"kind":12},{"line":905,"range":{"end":{"character":9999,"line":909},"start":{"character":0,"line":905}},"kind":12,"signature":{"label":"next_locuslink($obj)","parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None"},"children":[{"name":"$obj","localvar":"my","kind":13,"containerName":"next_locuslink","line":906,"definition":"my"},{"kind":13,"containerName":"next_locuslink","name":"$obj","line":908},{"line":908,"name":"_next_element","kind":12,"containerName":"next_locuslink"}],"name":"next_locuslink","containerName":"main::","definition":"sub","detail":"($obj)"},{"kind":12,"range":{"start":{"character":0,"line":931},"end":{"line":935,"character":9999}},"line":931,"signature":{"parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None","label":"next_express($obj)"},"containerName":"main::","name":"next_express","children":[{"line":932,"name":"$obj","localvar":"my","kind":13,"containerName":"next_express","definition":"my"},{"line":934,"name":"$obj","containerName":"next_express","kind":13},{"line":934,"kind":12,"containerName":"next_express","name":"_next_element"}],"detail":"($obj)","definition":"sub"},{"signature":{"label":"next_chromosome($obj)","parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None"},"line":958,"kind":12,"range":{"start":{"character":0,"line":958},"end":{"line":962,"character":9999}},"definition":"sub","detail":"($obj)","children":[{"definition":"my","name":"$obj","kind":13,"localvar":"my","containerName":"next_chromosome","line":959},{"line":961,"name":"$obj","kind":13,"containerName":"next_chromosome"},{"line":961,"containerName":"next_chromosome","kind":12,"name":"_next_element"}],"containerName":"main::","name":"next_chromosome"},{"signature":{"label":"next_protsim($obj)","parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None"},"line":985,"kind":12,"range":{"end":{"line":989,"character":9999},"start":{"line":985,"character":0}},"definition":"sub","detail":"($obj)","children":[{"definition":"my","line":986,"containerName":"next_protsim","localvar":"my","kind":13,"name":"$obj"},{"line":988,"name":"$obj","containerName":"next_protsim","kind":13},{"name":"_next_element","kind":12,"containerName":"next_protsim","line":988}],"name":"next_protsim","containerName":"main::"},{"line":1012,"range":{"start":{"character":0,"line":1012},"end":{"line":1016,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None","parameters":[{"label":"$obj"}],"label":"next_sts($obj)"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_sts","name":"$obj","line":1013},{"line":1015,"containerName":"next_sts","kind":13,"name":"$obj"},{"line":1015,"containerName":"next_sts","kind":12,"name":"_next_element"}],"name":"next_sts","containerName":"main::","definition":"sub","detail":"($obj)"},{"children":[{"line":1040,"kind":13,"localvar":"my","containerName":"next_txmap","name":"$obj","definition":"my"},{"kind":13,"containerName":"next_txmap","name":"$obj","line":1042},{"name":"_next_element","kind":12,"containerName":"next_txmap","line":1042}],"name":"next_txmap","containerName":"main::","definition":"sub","detail":"($obj)","line":1039,"kind":12,"range":{"start":{"character":0,"line":1039},"end":{"line":1043,"character":9999}},"signature":{"parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None","label":"next_txmap($obj)"}},{"definition":"sub","detail":"($self,$queuename,$meth)","children":[{"definition":"my","line":1053,"kind":13,"localvar":"my","containerName":"_next_element","name":"$self"},{"line":1053,"name":"$queuename","kind":13,"containerName":"_next_element"},{"line":1053,"name":"$meth","kind":13,"containerName":"_next_element"},{"line":1055,"name":"$queuename","kind":13,"containerName":"_next_element"},{"line":1055,"containerName":"_next_element","kind":13,"name":"$queuename"},{"line":1056,"name":"$self","containerName":"_next_element","kind":13},{"line":1056,"containerName":"_next_element","kind":13,"name":"$queuename"},{"containerName":"_next_element","kind":13,"name":"$self","line":1058},{"name":"$queuename","kind":13,"containerName":"_next_element","line":1058},{"kind":13,"containerName":"_next_element","name":"$self","line":1058},{"name":"$meth","containerName":"_next_element","kind":13,"line":1058}],"name":"_next_element","containerName":"main::","signature":{"label":"_next_element($self,$queuename,$meth)","documentation":" private method\n\n args: prefix name for the queue\n       name of the method from which to re-fill\n returns: the next element from that queue, or undef if the queue is empty","parameters":[{"label":"$self"},{"label":"$queuename"},{"label":"$meth"}]},"line":1052,"kind":12,"range":{"start":{"character":0,"line":1052},"end":{"character":9999,"line":1059}}},{"line":1060,"name":"$queue","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":1060,"name":"%self","containerName":null,"kind":13},{"line":1060,"name":"$queuename","containerName":null,"kind":13},{"line":1062,"name":"%queue","containerName":null,"kind":13},{"line":1064,"containerName":null,"kind":13,"name":"%self"},{"line":1064,"kind":13,"containerName":null,"name":"$queuename"},{"line":1067,"name":"$queue","containerName":null,"kind":13},{"range":{"end":{"line":1091,"character":9999},"start":{"character":0,"line":1089}},"kind":12,"line":1089,"definition":"sub","name":"object_id","containerName":"main::","children":[{"line":1090,"name":"unigene_id","containerName":"object_id","kind":12}]},{"children":[{"line":1112,"containerName":"version","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"version","name":"$self","line":1114},{"line":1115,"name":"$self","containerName":"version","kind":13}],"containerName":"main::","name":"version","definition":"sub","line":1111,"kind":12,"range":{"end":{"character":9999,"line":1116},"start":{"line":1111,"character":0}}},{"name":"authority","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"authority","line":1134,"definition":"my"},{"kind":13,"containerName":"authority","name":"$self","line":1136},{"line":1137,"name":"$self","containerName":"authority","kind":13}],"definition":"sub","range":{"end":{"line":1138,"character":9999},"start":{"character":0,"line":1133}},"kind":12,"line":1133},{"definition":"sub","name":"namespace","containerName":"main::","children":[{"line":1156,"kind":13,"localvar":"my","containerName":"namespace","name":"$self","definition":"my"},{"line":1158,"kind":13,"containerName":"namespace","name":"$self"},{"name":"$self","kind":13,"containerName":"namespace","line":1159}],"range":{"end":{"line":1160,"character":9999},"start":{"line":1155,"character":0}},"kind":12,"line":1155},{"definition":"sub","children":[{"line":1184,"kind":12,"containerName":"display_name","name":"unigene_id"}],"name":"display_name","containerName":"main::","line":1183,"kind":12,"range":{"start":{"character":0,"line":1183},"end":{"character":9999,"line":1185}}},{"definition":"sub","detail":"($obj)","children":[{"line":1235,"name":"$obj","containerName":"next_seq","localvar":"my","kind":13,"definition":"my"},{"name":"$obj","containerName":"next_seq","kind":13,"line":1237},{"kind":13,"containerName":"next_seq","name":"$obj","line":1239},{"line":1239,"kind":13,"containerName":"next_seq","name":"$obj"},{"containerName":"next_seq","kind":12,"name":"sequences","line":1239}],"containerName":"main::","name":"next_seq","signature":{"parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None","label":"next_seq($obj)"},"line":1234,"kind":12,"range":{"end":{"character":9999,"line":1240},"start":{"line":1234,"character":0}}},{"line":1241,"localvar":"my","kind":13,"containerName":null,"name":"$queue","definition":"my"},{"line":1241,"name":"%obj","kind":13,"containerName":null},{"line":1243,"kind":13,"containerName":null,"name":"%queue"},{"containerName":null,"kind":13,"name":"%obj","line":1245},{"localvar":"my","containerName":null,"kind":13,"name":"$seq_h","line":1249,"definition":"my"},{"line":1249,"containerName":null,"kind":13,"name":"$queue"},{"line":1252,"kind":13,"containerName":null,"name":"$seq_h"},{"containerName":null,"kind":13,"name":"$seq_h","line":1252},{"line":1256,"name":"$ac","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":1256,"containerName":"Annotation::Collection","kind":12,"name":"Bio"},{"line":1256,"name":"new","kind":12,"containerName":"main::"},{"line":1257,"name":"$k","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"%seq_h","line":1257},{"containerName":null,"kind":13,"name":"$k","line":1258},{"definition":"my","line":1259,"kind":13,"localvar":"my","containerName":null,"name":"$ann"},{"line":1259,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"line":1259,"containerName":"main::","kind":12,"name":"new"},{"line":1259,"containerName":null,"kind":13,"name":"$k"},{"containerName":null,"kind":13,"name":"%seq_h","line":1260},{"name":"$k","containerName":null,"kind":13,"line":1260},{"kind":13,"containerName":null,"name":"$ac","line":1261},{"containerName":"main::","kind":12,"name":"add_Annotation","line":1261},{"containerName":null,"kind":13,"name":"$ann","line":1261},{"name":"$seqobj","kind":13,"localvar":"my","containerName":null,"line":1264,"definition":"my"},{"line":1264,"name":"$obj","kind":13,"containerName":null},{"name":"sequence_factory","containerName":"main::","kind":12,"line":1264},{"name":"create","containerName":"main::","kind":12,"line":1264},{"line":1265,"containerName":null,"kind":13,"name":"%seq_h"},{"kind":12,"name":"acc","line":1265},{"line":1266,"name":"%seq_h","containerName":null,"kind":13},{"name":"pid","kind":12,"line":1266},{"containerName":null,"kind":13,"name":"%seq_h","line":1268},{"line":1268,"name":"nid","kind":12},{"line":1268,"kind":13,"containerName":null,"name":"%seq_h"},{"line":1268,"name":"nid","kind":12},{"line":1269,"name":"%seq_h","containerName":null,"kind":13},{"line":1269,"name":"nid","kind":12},{"name":"%seq_h","containerName":null,"kind":13,"line":1269},{"name":"nid","kind":12,"line":1269},{"name":"%seq_h","containerName":null,"kind":13,"line":1270},{"line":1270,"name":"acc","kind":12},{"line":1271,"name":"%seq_h","kind":13,"containerName":null},{"line":1271,"kind":12,"name":"version"},{"containerName":null,"kind":13,"name":"%obj","line":1272},{"line":1273,"containerName":null,"kind":13,"name":"%seq_h"},{"line":1273,"name":"acc","kind":12},{"line":1274,"kind":13,"containerName":null,"name":"$obj"},{"line":1274,"kind":12,"containerName":"main::","name":"authority"},{"name":"$obj","containerName":null,"kind":13,"line":1275},{"name":"species","containerName":"main::","kind":12,"line":1275},{"line":1277,"name":"$ac","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$seqobj","line":1278},{"range":{"start":{"line":1292,"character":0},"end":{"character":9999,"line":1301}},"kind":12,"line":1292,"signature":{"parameters":[{"label":"$self"},{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI","label":"sequence_factory($self,$obj)"},"name":"sequence_factory","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"sequence_factory","kind":13,"line":1293,"definition":"my"},{"line":1293,"name":"$obj","containerName":"sequence_factory","kind":13},{"kind":13,"containerName":"sequence_factory","name":"$obj","line":1294},{"name":"$obj","containerName":"sequence_factory","kind":13,"line":1295},{"name":"$obj","containerName":"sequence_factory","kind":13,"line":1295},{"name":"isa","kind":12,"containerName":"sequence_factory","line":1295},{"line":1296,"kind":13,"containerName":"sequence_factory","name":"$self"},{"line":1296,"containerName":"sequence_factory","kind":12,"name":"throw"},{"name":"$self","kind":13,"containerName":"sequence_factory","line":1296},{"name":"$self","containerName":"sequence_factory","kind":13,"line":1298},{"line":1298,"kind":13,"containerName":"sequence_factory","name":"$obj"},{"name":"$self","kind":13,"containerName":"sequence_factory","line":1300}],"detail":"($self,$obj)","definition":"sub"},{"line":1320,"range":{"start":{"line":1320,"character":0},"end":{"character":9999,"line":1345}},"kind":12,"children":[{"name":"$self","localvar":"my","containerName":"_annotation_value","kind":13,"line":1321,"definition":"my"},{"definition":"my","line":1322,"name":"$key","localvar":"my","kind":13,"containerName":"_annotation_value"},{"definition":"my","name":"$ann","localvar":"my","kind":13,"containerName":"_annotation_value","line":1324},{"containerName":"_annotation_value","kind":13,"name":"$val","line":1324},{"kind":13,"containerName":"_annotation_value","name":"$val","line":1326},{"kind":13,"containerName":"_annotation_value","name":"$val","line":1327},{"kind":13,"containerName":"_annotation_value","name":"$ann","line":1328},{"name":"$self","containerName":"_annotation_value","kind":13,"line":1328},{"line":1328,"containerName":"_annotation_value","kind":12,"name":"annotation"},{"line":1328,"kind":12,"containerName":"_annotation_value","name":"remove_Annotations"},{"name":"$key","kind":13,"containerName":"_annotation_value","line":1328},{"kind":13,"containerName":"_annotation_value","name":"$ann","line":1329},{"line":1329,"name":"$ann","containerName":"_annotation_value","kind":13},{"containerName":"_annotation_value","kind":12,"name":"value","line":1329},{"containerName":"_annotation_value","kind":13,"name":"$ann","line":1332},{"name":"$self","kind":13,"containerName":"_annotation_value","line":1332},{"name":"annotation","containerName":"_annotation_value","kind":12,"line":1332},{"name":"get_Annotations","kind":12,"containerName":"_annotation_value","line":1332},{"name":"$key","kind":13,"containerName":"_annotation_value","line":1332},{"name":"$ann","containerName":"_annotation_value","kind":13,"line":1333},{"kind":13,"containerName":"_annotation_value","name":"$val","line":1333},{"kind":13,"containerName":"_annotation_value","name":"$val","line":1335},{"name":"$ann","kind":13,"containerName":"_annotation_value","line":1335},{"name":"value","containerName":"_annotation_value","kind":12,"line":1335},{"line":1336,"name":"$val","kind":13,"containerName":"_annotation_value"},{"line":1338,"name":"$ann","kind":13,"containerName":"_annotation_value"},{"name":"$ann","containerName":"_annotation_value","kind":13,"line":1339},{"line":1339,"containerName":"_annotation_value","kind":12,"name":"new"},{"containerName":"_annotation_value","kind":13,"name":"$key","line":1339},{"name":"$self","containerName":"_annotation_value","kind":13,"line":1340},{"line":1340,"name":"annotation","kind":12,"containerName":"_annotation_value"},{"line":1340,"containerName":"_annotation_value","kind":12,"name":"add_Annotation"},{"line":1340,"containerName":"_annotation_value","kind":13,"name":"$ann"},{"line":1342,"name":"$ann","kind":13,"containerName":"_annotation_value"},{"line":1342,"name":"value","kind":12,"containerName":"_annotation_value"},{"line":1342,"name":"$val","containerName":"_annotation_value","kind":13},{"line":1344,"containerName":"_annotation_value","kind":13,"name":"$val"}],"containerName":"main::","name":"_annotation_value","definition":"sub"},{"line":1339,"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio"},{"line":1361,"range":{"end":{"line":1380,"character":9999},"start":{"character":0,"line":1361}},"kind":12,"signature":{"label":"_annotation_value_ary($self,$key,$arr)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$arr"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI\n\n\n\nsub sequence_factory {\n    my ($self,$obj) = @_;   \n    if( defined $obj ) {\n\tif( ! ref($obj) || ! $obj->isa('Bio::Factory::SequenceFactoryI') ) {\n\t    $self->throw(\"Must provide a valid Bio::Factory::SequenceFactoryI object to \".ref($self).\" sequence_factory()\");\n\t}\n\t$self->{'_seqfactory'} = $obj;\n    }\n    $self->{'_seqfactory'};\n}\n\n=head1 Private methods\n\n\n=head2 _annotation_value\n\n Title   : _annotation_value\n Usage   :\n Function: Private method.\n Example :\n Returns : the value (a string)\n Args    : annotation key (a string)\n           on set, annotation value (a string)\n\n\n\nsub _annotation_value{\n    my $self = shift;\n    my $key = shift;\n\n    my ($ann, $val);\n    if(@_) {\n\t$val = shift;\n\tif(! defined($val)) {\n\t    ($ann) = $self->annotation->remove_Annotations($key);\n\t    return $ann ? $ann->value() : undef;\n\t}\n    }\n    ($ann) = $self->annotation->get_Annotations($key);\n    if(defined $ann && (! $val)) {\n\t# get mode and exists\n\t$val = $ann->value();\n    } elsif($val) {\n\t# set mode\n\tif(!defined $ann) {\n\t    $ann = Bio::Annotation::SimpleValue->new(-tagname => $key);\n\t    $self->annotation->add_Annotation($ann);\n\t}\n\t$ann->value($val);\n    }\n    return $val;\n}\n\n\n=head2 _annotation_value_ary\n\n Title   : _annotation_value_ary\n Usage   :\n Function: Private method.\n Example :\n Returns : reference to the array of values\n Args    : annotation key (a string)\n           on set, reference to an array holding the values"},"children":[{"containerName":"_annotation_value_ary","localvar":"my","kind":13,"name":"$self","line":1362,"definition":"my"},{"line":1362,"containerName":"_annotation_value_ary","kind":13,"name":"$key"},{"kind":13,"containerName":"_annotation_value_ary","name":"$arr","line":1362},{"line":1364,"containerName":"_annotation_value_ary","localvar":"my","kind":13,"name":"$ac","definition":"my"},{"kind":13,"containerName":"_annotation_value_ary","name":"$self","line":1364},{"line":1364,"containerName":"_annotation_value_ary","kind":12,"name":"annotation"},{"name":"$arr","kind":13,"containerName":"_annotation_value_ary","line":1365},{"line":1367,"containerName":"_annotation_value_ary","kind":13,"name":"$ac"},{"line":1367,"name":"remove_Annotations","kind":12,"containerName":"_annotation_value_ary"},{"name":"$key","kind":13,"containerName":"_annotation_value_ary","line":1367},{"name":"$val","localvar":"my","containerName":"_annotation_value_ary","kind":13,"line":1369,"definition":"my"},{"line":1369,"containerName":"_annotation_value_ary","kind":13,"name":"$arr"},{"containerName":"_annotation_value_ary","localvar":"my","kind":13,"name":"$ann","line":1370,"definition":"my"},{"kind":12,"containerName":"_annotation_value_ary","name":"new","line":1370},{"line":1370,"containerName":"_annotation_value_ary","kind":13,"name":"$val"},{"containerName":"_annotation_value_ary","kind":13,"name":"$key","line":1372},{"kind":13,"containerName":"_annotation_value_ary","name":"$ac","line":1373},{"kind":12,"containerName":"_annotation_value_ary","name":"add_Annotation","line":1373},{"kind":13,"containerName":"_annotation_value_ary","name":"$ann","line":1373},{"localvar":"my","kind":13,"containerName":"_annotation_value_ary","name":"@vals","line":1376,"definition":"my"},{"name":"value","kind":12,"containerName":"_annotation_value_ary","line":1376},{"name":"$ac","containerName":"_annotation_value_ary","kind":13,"line":1376},{"kind":12,"containerName":"_annotation_value_ary","name":"get_Annotations","line":1376},{"line":1376,"name":"$key","containerName":"_annotation_value_ary","kind":13},{"containerName":"_annotation_value_ary","kind":13,"name":"$arr","line":1377},{"line":1377,"name":"@vals","kind":13,"containerName":"_annotation_value_ary"},{"name":"$arr","kind":13,"containerName":"_annotation_value_ary","line":1379}],"containerName":"main::","name":"_annotation_value_ary","definition":"sub","detail":"($self,$key,$arr)"},{"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio","line":1370},{"definition":"sub","detail":"($self,$key,$dbname,$acc,$version)","children":[{"definition":"my","name":"$self","containerName":"_annotation_dblink","localvar":"my","kind":13,"line":1398},{"containerName":"_annotation_dblink","kind":13,"name":"$key","line":1398},{"line":1398,"kind":13,"containerName":"_annotation_dblink","name":"$dbname"},{"line":1398,"name":"$acc","containerName":"_annotation_dblink","kind":13},{"line":1398,"containerName":"_annotation_dblink","kind":13,"name":"$version"},{"line":1400,"name":"$acc","containerName":"_annotation_dblink","kind":13},{"definition":"my","line":1402,"name":"$ann","localvar":"my","kind":13,"containerName":"_annotation_dblink"},{"containerName":"_annotation_dblink","kind":12,"name":"new","line":1402},{"line":1402,"containerName":"_annotation_dblink","kind":13,"name":"$key"},{"containerName":"_annotation_dblink","kind":13,"name":"$acc","line":1403},{"kind":13,"containerName":"_annotation_dblink","name":"$dbname","line":1404},{"containerName":"_annotation_dblink","kind":13,"name":"$version","line":1405},{"line":1406,"name":"$self","containerName":"_annotation_dblink","kind":13},{"line":1406,"kind":12,"containerName":"_annotation_dblink","name":"annotation"},{"kind":12,"containerName":"_annotation_dblink","name":"add_Annotation","line":1406},{"line":1406,"containerName":"_annotation_dblink","kind":13,"name":"$ann"},{"definition":"my","line":1410,"containerName":"_annotation_dblink","localvar":"my","kind":13,"name":"@anns"},{"containerName":"_annotation_dblink","kind":13,"name":"$self","line":1410},{"kind":12,"containerName":"_annotation_dblink","name":"annotation","line":1410},{"containerName":"_annotation_dblink","kind":12,"name":"get_Annotations","line":1410},{"containerName":"_annotation_dblink","kind":13,"name":"$key","line":1410},{"kind":13,"containerName":"_annotation_dblink","name":"$dbname","line":1412},{"kind":13,"containerName":"_annotation_dblink","name":"@anns","line":1413},{"kind":12,"containerName":"_annotation_dblink","name":"database","line":1413},{"line":1413,"name":"$dbname","containerName":"_annotation_dblink","kind":13},{"containerName":"_annotation_dblink","kind":13,"name":"@anns","line":1413},{"kind":12,"containerName":"_annotation_dblink","name":"primary_id","line":1415},{"kind":13,"containerName":"_annotation_dblink","name":"@anns","line":1415}],"name":"_annotation_dblink","containerName":"main::","signature":{"label":"_annotation_dblink($self,$key,$dbname,$acc,$version)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$dbname"},{"label":"$acc"},{"label":"$version"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI\n\n\n\nsub sequence_factory {\n    my ($self,$obj) = @_;   \n    if( defined $obj ) {\n\tif( ! ref($obj) || ! $obj->isa('Bio::Factory::SequenceFactoryI') ) {\n\t    $self->throw(\"Must provide a valid Bio::Factory::SequenceFactoryI object to \".ref($self).\" sequence_factory()\");\n\t}\n\t$self->{'_seqfactory'} = $obj;\n    }\n    $self->{'_seqfactory'};\n}\n\n=head1 Private methods\n\n\n=head2 _annotation_value\n\n Title   : _annotation_value\n Usage   :\n Function: Private method.\n Example :\n Returns : the value (a string)\n Args    : annotation key (a string)\n           on set, annotation value (a string)\n\n\n\nsub _annotation_value{\n    my $self = shift;\n    my $key = shift;\n\n    my ($ann, $val);\n    if(@_) {\n\t$val = shift;\n\tif(! defined($val)) {\n\t    ($ann) = $self->annotation->remove_Annotations($key);\n\t    return $ann ? $ann->value() : undef;\n\t}\n    }\n    ($ann) = $self->annotation->get_Annotations($key);\n    if(defined $ann && (! $val)) {\n\t# get mode and exists\n\t$val = $ann->value();\n    } elsif($val) {\n\t# set mode\n\tif(!defined $ann) {\n\t    $ann = Bio::Annotation::SimpleValue->new(-tagname => $key);\n\t    $self->annotation->add_Annotation($ann);\n\t}\n\t$ann->value($val);\n    }\n    return $val;\n}\n\n\n=head2 _annotation_value_ary\n\n Title   : _annotation_value_ary\n Usage   :\n Function: Private method.\n Example :\n Returns : reference to the array of values\n Args    : annotation key (a string)\n           on set, reference to an array holding the values\n\n\n\nsub _annotation_value_ary{\n    my ($self,$key,$arr) = @_;\n\n    my $ac = $self->annotation;\n    if($arr) {\n\t# purge first\n\t$ac->remove_Annotations($key);\n\t# then add as many values as are present\n\tforeach my $val (@$arr) {\n\t    my $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n\t\t\t\t\t\t\t-tagname => $key\n\t\t\t\t\t\t\t);\n\t    $ac->add_Annotation($ann);\n\t}\n    } else {\n\tmy @vals = map { $_->value(); } $ac->get_Annotations($key);\n\t$arr = [@vals];\n    }\n    return $arr;\n}\n\n\n=head2 _annotation_dblink\n\n Title   : _annotation_dblink\n Usage   :\n Function: Private method.\n Example :\n Returns : array of accessions for the given database (namespace)\n Args    : annotation key (a string)\n           dbname (a string) (optional on get, mandatory on set)\n           on set, accession or ID (a string), and version"},"line":1397,"range":{"end":{"character":9999,"line":1417},"start":{"character":0,"line":1397}},"kind":12},{"line":1402,"name":"Bio","kind":12,"containerName":"Annotation::DBLink"},{"containerName":"main::","name":"_remove_dblink","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_remove_dblink","name":"$self","line":1433},{"name":"$key","kind":13,"containerName":"_remove_dblink","line":1433},{"name":"$dbname","containerName":"_remove_dblink","kind":13,"line":1433},{"line":1435,"name":"$ac","containerName":"_remove_dblink","localvar":"my","kind":13,"definition":"my"},{"containerName":"_remove_dblink","kind":13,"name":"$self","line":1435},{"name":"annotation","containerName":"_remove_dblink","kind":12,"line":1435},{"line":1436,"name":"@anns","kind":13,"localvar":"my","containerName":"_remove_dblink","definition":"my"},{"containerName":"_remove_dblink","kind":13,"name":"$dbname","line":1437},{"definition":"my","line":1438,"name":"$ann","localvar":"my","containerName":"_remove_dblink","kind":13},{"line":1438,"containerName":"_remove_dblink","kind":13,"name":"$ac"},{"line":1438,"name":"remove_Annotations","containerName":"_remove_dblink","kind":12},{"containerName":"_remove_dblink","kind":13,"name":"$key","line":1438},{"line":1439,"name":"$ann","kind":13,"containerName":"_remove_dblink"},{"line":1439,"kind":12,"containerName":"_remove_dblink","name":"database"},{"line":1439,"kind":13,"containerName":"_remove_dblink","name":"$dbname"},{"line":1440,"name":"@anns","containerName":"_remove_dblink","kind":13},{"name":"$ann","containerName":"_remove_dblink","kind":13,"line":1440},{"containerName":"_remove_dblink","kind":13,"name":"$ac","line":1442},{"line":1442,"containerName":"_remove_dblink","kind":12,"name":"add_Annotation"},{"line":1442,"name":"$ann","kind":13,"containerName":"_remove_dblink"},{"kind":13,"containerName":"_remove_dblink","name":"@anns","line":1446},{"line":1446,"containerName":"_remove_dblink","kind":13,"name":"$ac"},{"name":"remove_Annotations","kind":12,"containerName":"_remove_dblink","line":1446},{"kind":13,"containerName":"_remove_dblink","name":"$key","line":1446},{"kind":12,"containerName":"_remove_dblink","name":"primary_id","line":1448},{"line":1448,"name":"@anns","kind":13,"containerName":"_remove_dblink"}],"detail":"($self,$key,$dbname)","definition":"sub","kind":12,"range":{"end":{"line":1449,"character":9999},"start":{"character":0,"line":1432}},"line":1432,"signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI\n\n\n\nsub sequence_factory {\n    my ($self,$obj) = @_;   \n    if( defined $obj ) {\n\tif( ! ref($obj) || ! $obj->isa('Bio::Factory::SequenceFactoryI') ) {\n\t    $self->throw(\"Must provide a valid Bio::Factory::SequenceFactoryI object to \".ref($self).\" sequence_factory()\");\n\t}\n\t$self->{'_seqfactory'} = $obj;\n    }\n    $self->{'_seqfactory'};\n}\n\n=head1 Private methods\n\n\n=head2 _annotation_value\n\n Title   : _annotation_value\n Usage   :\n Function: Private method.\n Example :\n Returns : the value (a string)\n Args    : annotation key (a string)\n           on set, annotation value (a string)\n\n\n\nsub _annotation_value{\n    my $self = shift;\n    my $key = shift;\n\n    my ($ann, $val);\n    if(@_) {\n\t$val = shift;\n\tif(! defined($val)) {\n\t    ($ann) = $self->annotation->remove_Annotations($key);\n\t    return $ann ? $ann->value() : undef;\n\t}\n    }\n    ($ann) = $self->annotation->get_Annotations($key);\n    if(defined $ann && (! $val)) {\n\t# get mode and exists\n\t$val = $ann->value();\n    } elsif($val) {\n\t# set mode\n\tif(!defined $ann) {\n\t    $ann = Bio::Annotation::SimpleValue->new(-tagname => $key);\n\t    $self->annotation->add_Annotation($ann);\n\t}\n\t$ann->value($val);\n    }\n    return $val;\n}\n\n\n=head2 _annotation_value_ary\n\n Title   : _annotation_value_ary\n Usage   :\n Function: Private method.\n Example :\n Returns : reference to the array of values\n Args    : annotation key (a string)\n           on set, reference to an array holding the values\n\n\n\nsub _annotation_value_ary{\n    my ($self,$key,$arr) = @_;\n\n    my $ac = $self->annotation;\n    if($arr) {\n\t# purge first\n\t$ac->remove_Annotations($key);\n\t# then add as many values as are present\n\tforeach my $val (@$arr) {\n\t    my $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n\t\t\t\t\t\t\t-tagname => $key\n\t\t\t\t\t\t\t);\n\t    $ac->add_Annotation($ann);\n\t}\n    } else {\n\tmy @vals = map { $_->value(); } $ac->get_Annotations($key);\n\t$arr = [@vals];\n    }\n    return $arr;\n}\n\n\n=head2 _annotation_dblink\n\n Title   : _annotation_dblink\n Usage   :\n Function: Private method.\n Example :\n Returns : array of accessions for the given database (namespace)\n Args    : annotation key (a string)\n           dbname (a string) (optional on get, mandatory on set)\n           on set, accession or ID (a string), and version\n\n\n\nsub _annotation_dblink{\n    my ($self,$key,$dbname,$acc,$version) = @_;\n\n    if($acc) {\n\t# set mode -- this is adding here\n\tmy $ann = Bio::Annotation::DBLink->new(-tagname    => $key,\n\t\t\t\t\t       -primary_id => $acc,\n\t\t\t\t\t       -database   => $dbname,\n\t\t\t\t\t       -version    => $version);\n\t$self->annotation->add_Annotation($ann);\n\treturn 1;\n    } else {\n\t# get mode\n\tmy @anns = $self->annotation->get_Annotations($key);\n\t# filter out those that don't match the requested database\n\tif($dbname) {\n\t    @anns = grep { $_->database() eq $dbname; } @anns;\n\t}\n\treturn map { $_->primary_id(); } @anns;\n    }\n}\n\n=head2 _remove_dblink\n\n Title   : _remove_dblink\n Usage   :\n Function: Private method.\n Example :\n Returns : array of accessions for the given database (namespace)\n Args    : annotation key (a string)\n           dbname (a string) (optional)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$dbname"}],"label":"_remove_dblink($self,$key,$dbname)"}}]}