{"vars":[{"containerName":"","kind":2,"name":"base","line":97},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":113,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"line":113,"kind":13,"containerName":"new","name":"@args"},{"line":115,"name":"$self","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":115,"containerName":"new","kind":13,"name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":115},{"line":117,"name":"$self","kind":13,"containerName":"new"},{"line":117,"kind":12,"containerName":"new","name":"interface"},{"name":"$self","containerName":"new","kind":13,"line":118},{"name":"type","containerName":"new","kind":12,"line":118},{"name":"$self","containerName":"new","kind":13,"line":118},{"line":118,"name":"type","containerName":"new","kind":12},{"line":118,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"type","line":118},{"line":120,"containerName":"new","kind":13,"name":"$self"}],"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: ClusterFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::ClusterFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::ClusterFactory - Instantiates a new Bio::ClusterI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Cluster::ClusterFactory;\n    # if you don't provide a default type, the factory will try\n    # some guesswork based on display_id and namespace\n    my $factory = Bio::Cluster::ClusterFactory->new(-type => 'Bio::Cluster::UniGene');\n    my $clu = $factory->create_object(-description => 'NAT',\n                                      -display_id  => 'Hs.2');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::ClusterI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::ClusterFactory;\nuse strict;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Factory::ObjectFactory);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Cluster::ClusterFactory->new();\n Function: Builds a new Bio::Cluster::ClusterFactory object \n Returns : Bio::Cluster::ClusterFactory\n Args    : -type => string, name of a ClusterI derived class.\n                    If not provided, the factory will have to guess\n                    from ID and namespace, which may or may not be\n                    successful.","label":"new($class,@args)"},"kind":12,"range":{"start":{"line":112,"character":0},"end":{"line":121,"character":9999}},"line":112},{"line":115,"kind":12,"containerName":"new","name":"SUPER"},{"containerName":"main::","name":"create_object","children":[{"line":144,"localvar":"my","kind":13,"containerName":"create_object","name":"$self","definition":"my"},{"containerName":"create_object","kind":13,"name":"@args","line":144},{"definition":"my","line":146,"name":"$type","kind":13,"localvar":"my","containerName":"create_object"},{"kind":13,"containerName":"create_object","name":"$self","line":146},{"kind":12,"containerName":"create_object","name":"type","line":146},{"name":"$type","containerName":"create_object","kind":13,"line":147},{"containerName":"create_object","kind":13,"name":"$type","line":149},{"kind":13,"containerName":"create_object","name":"$self","line":149},{"name":"_guess_type","containerName":"create_object","kind":12,"line":149},{"name":"@args","kind":13,"containerName":"create_object","line":149},{"line":150,"name":"$self","containerName":"create_object","kind":13},{"kind":12,"containerName":"create_object","name":"throw","line":150},{"line":150,"name":"$type","containerName":"create_object","kind":13},{"line":151,"kind":13,"containerName":"create_object","name":"$self"},{"line":151,"containerName":"create_object","kind":12,"name":"type"},{"line":151,"name":"$type","kind":13,"containerName":"create_object"},{"containerName":"create_object","kind":13,"name":"$type","line":153},{"name":"new","containerName":"create_object","kind":12,"line":153},{"kind":13,"containerName":"create_object","name":"$self","line":153},{"kind":12,"containerName":"create_object","name":"verbose","line":153},{"name":"@args","containerName":"create_object","kind":13,"line":153}],"detail":"($self,@args)","definition":"sub","range":{"end":{"character":9999,"line":154},"start":{"line":143,"character":0}},"kind":12,"line":143,"signature":{"label":"create_object($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ClusterFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::ClusterFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::ClusterFactory - Instantiates a new Bio::ClusterI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Cluster::ClusterFactory;\n    # if you don't provide a default type, the factory will try\n    # some guesswork based on display_id and namespace\n    my $factory = Bio::Cluster::ClusterFactory->new(-type => 'Bio::Cluster::UniGene');\n    my $clu = $factory->create_object(-description => 'NAT',\n                                      -display_id  => 'Hs.2');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::ClusterI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::ClusterFactory;\nuse strict;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Factory::ObjectFactory);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Cluster::ClusterFactory->new();\n Function: Builds a new Bio::Cluster::ClusterFactory object \n Returns : Bio::Cluster::ClusterFactory\n Args    : -type => string, name of a ClusterI derived class.\n                    If not provided, the factory will have to guess\n                    from ID and namespace, which may or may not be\n                    successful.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->interface(\"Bio::ClusterI\");\n    $self->type($self->type) if $self->type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::ClusterI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::ClusterI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of cluster\n           object we want.  Typically \n           -display_id  => $name\n           -description => description of the cluster\n           -members     => arrayref, members of the cluster"}},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ClusterFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::ClusterFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::ClusterFactory - Instantiates a new Bio::ClusterI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Cluster::ClusterFactory;\n    # if you don't provide a default type, the factory will try\n    # some guesswork based on display_id and namespace\n    my $factory = Bio::Cluster::ClusterFactory->new(-type => 'Bio::Cluster::UniGene');\n    my $clu = $factory->create_object(-description => 'NAT',\n                                      -display_id  => 'Hs.2');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::ClusterI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::ClusterFactory;\nuse strict;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Factory::ObjectFactory);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Cluster::ClusterFactory->new();\n Function: Builds a new Bio::Cluster::ClusterFactory object \n Returns : Bio::Cluster::ClusterFactory\n Args    : -type => string, name of a ClusterI derived class.\n                    If not provided, the factory will have to guess\n                    from ID and namespace, which may or may not be\n                    successful.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->interface(\"Bio::ClusterI\");\n    $self->type($self->type) if $self->type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::ClusterI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::ClusterI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of cluster\n           object we want.  Typically \n           -display_id  => $name\n           -description => description of the cluster\n           -members     => arrayref, members of the cluster\n\n\nsub create_object {\n   my ($self,@args) = @_;\n\n   my $type = $self->type();\n   if(! $type) {\n       # we need to guess this\n       $type = $self->_guess_type(@args);\n       $self->throw(\"No cluster type set and unable to guess.\") unless $type;\n       $self->type($type);\n   }\n   return $type->new(-verbose => $self->verbose, @args);\n}\n\n=head2 _guess_type\n\n Title   : _guess_type\n Usage   :\n Function: Guesses the right type of L<Bio::ClusterI> implementation\n           based on initialization parameters for the prospective\n           object.\n Example :\n Returns : the type (a string, the module name)\n Args    : initialization parameters to be passed to the prospective\n           cluster object","label":"_guess_type($self,@args)"},"line":171,"range":{"start":{"character":0,"line":171},"end":{"line":189,"character":9999}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":172,"name":"$self","localvar":"my","containerName":"_guess_type","kind":13},{"name":"@args","containerName":"_guess_type","kind":13,"line":172},{"definition":"my","line":173,"containerName":"_guess_type","localvar":"my","kind":13,"name":"$type"},{"definition":"my","line":176,"name":"$dispid","kind":13,"localvar":"my","containerName":"_guess_type"},{"name":"$ns","containerName":"_guess_type","kind":13,"line":176},{"kind":13,"containerName":"_guess_type","name":"$members","line":176},{"name":"$self","kind":13,"containerName":"_guess_type","line":177},{"name":"_rearrange","containerName":"_guess_type","kind":12,"line":177},{"name":"@args","containerName":"_guess_type","kind":13,"line":180},{"containerName":"_guess_type","kind":13,"name":"$ns","line":182},{"line":182,"name":"$ns","containerName":"_guess_type","kind":13},{"name":"$type","kind":13,"containerName":"_guess_type","line":183},{"kind":13,"containerName":"_guess_type","name":"$dispid","line":184},{"line":184,"containerName":"_guess_type","kind":13,"name":"$dispid"},{"name":"$type","kind":13,"containerName":"_guess_type","line":185},{"name":"$type","containerName":"_guess_type","kind":13,"line":188}],"name":"_guess_type","containerName":"main::"}],"version":5}