{"vars":[{"line":86,"containerName":"","kind":2,"name":"base"},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"kind":12,"range":{"end":{"line":113,"character":9999},"start":{"line":101,"character":0}},"line":101,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":102,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":102},{"definition":"my","name":"$self","localvar":"my","containerName":"new","kind":13,"line":104},{"line":104,"name":"$class","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":104},{"name":"$self","containerName":"new","kind":13,"line":106},{"line":108,"kind":13,"containerName":"new","name":"$self"},{"line":108,"containerName":"new","kind":12,"name":"_add_type_map"},{"containerName":"new","kind":13,"name":"$self","line":109},{"name":"_add_type_map","containerName":"new","kind":12,"line":109},{"line":110,"name":"$self","containerName":"new","kind":13},{"line":110,"name":"_add_type_map","kind":12,"containerName":"new"},{"line":112,"name":"$self","containerName":"new","kind":13}]},{"name":"SUPER","kind":12,"containerName":"new","line":104},{"containerName":"main::","name":"type_for_key","children":[{"name":"$self","containerName":"type_for_key","localvar":"my","kind":13,"line":129,"definition":"my"},{"line":129,"containerName":"type_for_key","kind":13,"name":"$key"},{"line":131,"kind":13,"containerName":"type_for_key","name":"$key"},{"line":131,"kind":13,"containerName":"type_for_key","name":"$key"},{"line":131,"kind":12,"containerName":"type_for_key","name":"name"},{"line":131,"containerName":"type_for_key","kind":13,"name":"$key"},{"kind":13,"containerName":"type_for_key","name":"$key","line":131},{"line":131,"name":"isa","kind":12,"containerName":"type_for_key"},{"kind":13,"containerName":"type_for_key","name":"$self","line":132},{"name":"$key","kind":13,"containerName":"type_for_key","line":132}],"detail":"($self,$key)","definition":"sub","range":{"end":{"character":9999,"line":133},"start":{"line":128,"character":0}},"kind":12,"line":128,"signature":{"parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_type'} = {};\n\n   $self->_add_type_map('reference',\"Bio::Annotation::Reference\");\n   $self->_add_type_map('comment',\"Bio::Annotation::Comment\");\n   $self->_add_type_map('dblink',\"Bio::Annotation::DBLink\");\n\n   return $self;\n}\n\n\n=head2 type_for_key\n\n Title   : type_for_key\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"type_for_key($self,$key)"}},{"definition":"sub","detail":"($self,$key,$object)","children":[{"name":"$self","localvar":"my","containerName":"is_valid","kind":13,"line":149,"definition":"my"},{"containerName":"is_valid","kind":13,"name":"$key","line":149},{"line":149,"containerName":"is_valid","kind":13,"name":"$object"},{"name":"$object","containerName":"is_valid","kind":13,"line":151},{"line":151,"kind":13,"containerName":"is_valid","name":"$object"},{"line":152,"name":"$self","kind":13,"containerName":"is_valid"},{"line":152,"containerName":"is_valid","kind":12,"name":"throw"},{"name":"$object","kind":13,"containerName":"is_valid","line":155},{"name":"isa","containerName":"is_valid","kind":12,"line":155},{"line":155,"containerName":"is_valid","kind":13,"name":"$self"},{"name":"type_for_key","kind":12,"containerName":"is_valid","line":155},{"line":155,"kind":13,"containerName":"is_valid","name":"$key"}],"containerName":"main::","name":"is_valid","signature":{"documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_type'} = {};\n\n   $self->_add_type_map('reference',\"Bio::Annotation::Reference\");\n   $self->_add_type_map('comment',\"Bio::Annotation::Comment\");\n   $self->_add_type_map('dblink',\"Bio::Annotation::DBLink\");\n\n   return $self;\n}\n\n\n=head2 type_for_key\n\n Title   : type_for_key\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub type_for_key{\n   my ($self,$key) = @_;\n\n   $key = $key->name() if ref($key) && $key->isa(\"Bio::Ontology::TermI\");\n   return $self->{'_type'}->{$key};\n}\n\n\n=head2 is_valid\n\n Title   : is_valid\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$object"}],"label":"is_valid($self,$key,$object)"},"line":148,"kind":12,"range":{"end":{"character":9999,"line":160},"start":{"line":148,"character":0}}},{"signature":{"documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_type'} = {};\n\n   $self->_add_type_map('reference',\"Bio::Annotation::Reference\");\n   $self->_add_type_map('comment',\"Bio::Annotation::Comment\");\n   $self->_add_type_map('dblink',\"Bio::Annotation::DBLink\");\n\n   return $self;\n}\n\n\n=head2 type_for_key\n\n Title   : type_for_key\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub type_for_key{\n   my ($self,$key) = @_;\n\n   $key = $key->name() if ref($key) && $key->isa(\"Bio::Ontology::TermI\");\n   return $self->{'_type'}->{$key};\n}\n\n\n=head2 is_valid\n\n Title   : is_valid\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub is_valid{\n   my ($self,$key,$object) = @_;\n\n   if( !defined $object || !ref $object ) {\n       $self->throw(\"Cannot type an object [$object]!\");\n   }\n\n   if( !$object->isa($self->type_for_key($key)) ) {\n       return 0;\n   } else {\n       return 1;\n   }\n}\n\n\n=head2 _add_type_map\n\n Title   : _add_type_map\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$type"}],"label":"_add_type_map($self,$key,$type)"},"line":175,"kind":12,"range":{"start":{"line":175,"character":0},"end":{"line":180,"character":9999}},"definition":"sub","detail":"($self,$key,$type)","children":[{"name":"$self","containerName":"_add_type_map","localvar":"my","kind":13,"line":176,"definition":"my"},{"containerName":"_add_type_map","kind":13,"name":"$key","line":176},{"name":"$type","kind":13,"containerName":"_add_type_map","line":176},{"name":"$key","containerName":"_add_type_map","kind":13,"line":178},{"line":178,"containerName":"_add_type_map","kind":13,"name":"$key"},{"name":"name","containerName":"_add_type_map","kind":12,"line":178},{"kind":13,"containerName":"_add_type_map","name":"$key","line":178},{"name":"$key","kind":13,"containerName":"_add_type_map","line":178},{"name":"isa","containerName":"_add_type_map","kind":12,"line":178},{"line":179,"kind":13,"containerName":"_add_type_map","name":"$self"},{"containerName":"_add_type_map","kind":13,"name":"$key","line":179},{"line":179,"containerName":"_add_type_map","kind":13,"name":"$type"}],"name":"_add_type_map","containerName":"main::"}],"version":5}