{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":121},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: TagTree.pm 11693 2007-09-17 20:54:04Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TagTree\n#\n# Cared for Chris Fields\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TagTree - AnnotationI with tree-like hierarchal key-value\nrelationships ('structured tags') that can be represented as simple text.\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::TagTree;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n\n   # data structure can be an array reference with a data structure\n   # corresponding to that defined by Data::Stag:\n\n   my $sv = Bio::Annotation::TagTree->new(-tagname => 'mytag1',\n                                          -value => $data_structure);\n   $col->add_Annotation($sv);\n\n   # regular text passed is parsed based on the tagformat().\n   my $sv2 = Bio::Annotation::TagTree->new(-tagname => 'mytag2',\n                                          -tagformat => 'xml',\n                                          -value => $xmltext);\n   $col->add_Annotation($sv2);\n\n=head1 DESCRIPTION\n\nThis takes tagged data values and stores them in a hierarchal structured\nelement-value hierarchy (complements of Chris Mungall's Data::Stag module). Data\ncan then be represented as text using a variety of output formats (indention,\nitext, xml, spxr). Furthermore, the data structure can be queried using various\nmeans. See L<Data::Stag> for details.\n\nData passed in using value() or the '-value' parameter upon instantiation\ncan either be:\n\n1) an array reference corresponding to the data structure for Data::Stag;\n\n2) a text string in 'xml', 'itext', 'spxr', or 'indent' format. The default\nformat is 'xml'; this can be changed using tagformat() prior to using value() or\nby passing in the proper format using '-tagformat' upon instantiation;\n\n3) another Bio::Annotation::TagTree or Data::Stag node instance.  In both cases\na deep copy (duplicate) of the instance is generated.\n\nBeyond checking for an array reference no format guessing occurs (so, for\nroundtrip tests ensure that the IO formats correspond). For now, we recommend\nwhen using text input to set tagformat() to one of these formats prior to data\nloading to ensure the proper Data::Stag parser is selected. After data loading,\nthe tagformat() can be changed to change the text string format returned by\nvalue(). (this may be rectified in the future)\n\nThis Annotation type is fully BioSQL compatible and could be considered a\ntemporary replacement for nested Bio::Annotation::Collections, at least until\nBioSQL and bioperl-db can support nested annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nChris Fields\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Annotation::TagTree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\nuse Data::Stag;\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::TagTree->new();\n Function: Instantiate a new TagTree object\n Returns : Bio::Annotation::TagTree object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n           -tagformat => format for output [optional]\n                      (types 'xml', 'itext', 'sxpr', 'indent', default = 'itext')\n           -node => Data::Stag node or Bio::Annotation::TagTree instance","parameters":[{"label":"$class"},{"label":"@args"}]},"line":138,"range":{"end":{"line":162,"character":9999},"start":{"character":0,"line":138}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":139},{"name":"@args","kind":13,"containerName":"new","line":139},{"line":140,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":140},{"definition":"my","line":141,"name":"$node","localvar":"my","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$value","line":141},{"name":"$tag","containerName":"new","kind":13,"line":141},{"line":141,"containerName":"new","kind":13,"name":"$format"},{"containerName":"new","kind":13,"name":"$verbose","line":141},{"line":141,"kind":13,"containerName":"new","name":"$self"},{"line":141,"kind":12,"containerName":"new","name":"_rearrange"},{"line":152,"kind":13,"containerName":"new","name":"@args"},{"line":153,"name":"$self","kind":13,"containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":153},{"kind":13,"containerName":"new","name":"$node","line":154},{"line":154,"name":"$value","kind":13,"containerName":"new"},{"line":155,"name":"$tag","kind":13,"containerName":"new"},{"line":155,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"tagname","line":155},{"name":"$tag","kind":13,"containerName":"new","line":155},{"name":"$format","kind":13,"containerName":"new","line":156},{"containerName":"new","kind":13,"name":"$self","line":157},{"name":"tagformat","kind":12,"containerName":"new","line":157},{"line":157,"name":"$format","kind":13,"containerName":"new"},{"line":158,"containerName":"new","kind":13,"name":"$value"},{"name":"$self","containerName":"new","kind":13,"line":158},{"name":"value","containerName":"new","kind":12,"line":158},{"line":158,"name":"$value","containerName":"new","kind":13},{"line":159,"name":"$node","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":159},{"line":159,"containerName":"new","kind":12,"name":"node"},{"containerName":"new","kind":13,"name":"$node","line":159},{"line":160,"containerName":"new","kind":13,"name":"$verbose"},{"line":160,"containerName":"new","kind":13,"name":"$self"},{"line":160,"name":"verbose","kind":12,"containerName":"new"},{"line":160,"kind":13,"containerName":"new","name":"$verbose"},{"line":161,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::"},{"name":"Stag","containerName":"Data","kind":2,"line":139},{"containerName":"new","kind":12,"name":"SUPER","line":140},{"name":"as_text","containerName":"main::","children":[{"line":179,"name":"$self","containerName":"as_text","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"as_text","line":180},{"name":"value","kind":12,"containerName":"as_text","line":180}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":181},"start":{"line":178,"character":0}},"line":178,"signature":{"label":"as_text($self)","documentation":"","parameters":[{"label":"$self"}]}},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%DEFAULT_CB","line":200},{"line":200,"name":"value","kind":12,"containerName":"main::"},{"range":{"start":{"line":202,"character":0},"end":{"line":207,"character":9999}},"kind":12,"line":202,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}],"label":"display_text($self,$cb)"},"name":"display_text","containerName":"main::","children":[{"containerName":"display_text","localvar":"my","kind":13,"name":"$self","line":203,"definition":"my"},{"name":"$cb","kind":13,"containerName":"display_text","line":203},{"kind":13,"containerName":"display_text","name":"$cb","line":204},{"name":"$DEFAULT_CB","containerName":"display_text","kind":13,"line":204},{"line":205,"kind":13,"containerName":"display_text","name":"$self"},{"line":205,"name":"throw","kind":12,"containerName":"display_text"},{"containerName":"display_text","kind":13,"name":"$cb","line":205},{"line":206,"name":"$cb","containerName":"display_text","kind":13},{"name":"$self","containerName":"display_text","kind":13,"line":206}],"detail":"($self,$cb)","definition":"sub"},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"hash_tree","kind":13,"line":224},{"definition":"my","line":225,"name":"$h","containerName":"hash_tree","localvar":"my","kind":13},{"line":226,"kind":13,"containerName":"hash_tree","name":"$h"},{"line":226,"name":"$self","kind":13,"containerName":"hash_tree"},{"line":226,"name":"value","containerName":"hash_tree","kind":12}],"name":"hash_tree","containerName":"main::","definition":"sub","detail":"($self)","line":223,"range":{"end":{"line":227,"character":9999},"start":{"line":223,"character":0}},"kind":12,"signature":{"label":"hash_tree($self)","parameters":[{"label":"$self"}],"documentation":""}},{"line":243,"range":{"end":{"character":9999,"line":249},"start":{"character":0,"line":243}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"tagname($self,$value)"},"children":[{"line":244,"localvar":"my","containerName":"tagname","kind":13,"name":"$self","definition":"my"},{"line":244,"containerName":"tagname","kind":13,"name":"$value"},{"line":245,"containerName":"tagname","kind":13,"name":"$value"},{"kind":13,"containerName":"tagname","name":"$self","line":246},{"name":"$value","containerName":"tagname","kind":13,"line":246},{"kind":13,"containerName":"tagname","name":"$self","line":248}],"containerName":"main::","name":"tagname","definition":"sub","detail":"($self,$value)"},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"value($self,$value)"},"kind":12,"range":{"end":{"line":298,"character":9999},"start":{"character":0,"line":265}},"line":265,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"value","children":[{"containerName":"value","localvar":"my","kind":13,"name":"$self","line":266,"definition":"my"},{"line":266,"name":"$value","containerName":"value","kind":13},{"name":"$format","localvar":"my","containerName":"value","kind":13,"line":269,"definition":"my"},{"containerName":"value","kind":13,"name":"$self","line":269},{"name":"tagformat","containerName":"value","kind":12,"line":269},{"line":270,"containerName":"value","kind":13,"name":"$value"},{"name":"$value","containerName":"value","kind":13,"line":271},{"containerName":"value","kind":13,"name":"$value","line":272},{"name":"$self","kind":13,"containerName":"value","line":276},{"containerName":"value","kind":12,"name":"nodify","line":276},{"kind":13,"containerName":"value","name":"$value","line":276},{"name":"$self","kind":13,"containerName":"value","line":281},{"line":281,"kind":12,"containerName":"value","name":"node"},{"containerName":"value","kind":13,"name":"$value","line":281},{"definition":"my","line":287,"name":"$h","localvar":"my","containerName":"value","kind":13},{"line":287,"containerName":"value","kind":12,"name":"getformathandler"},{"line":287,"name":"$format","kind":13,"containerName":"value"},{"containerName":"value","kind":13,"name":"$self","line":288},{"name":"from","kind":12,"containerName":"value","line":288},{"line":288,"name":"$format","containerName":"value","kind":13},{"kind":13,"containerName":"value","name":"$value","line":288},{"kind":13,"containerName":"value","name":"$self","line":290},{"line":290,"name":"throw","containerName":"value","kind":12},{"name":"$self","kind":13,"containerName":"value","line":297},{"line":297,"kind":12,"containerName":"value","name":"node"},{"line":297,"containerName":"value","kind":13,"name":"$format"}]},{"line":276,"kind":12,"name":"db"},{"line":276,"name":"Data","containerName":"Stag","kind":12},{"line":287,"kind":12,"containerName":"Stag","name":"Data"},{"kind":12,"name":"db","line":288},{"line":288,"name":"Data","kind":12,"containerName":"Stag"},{"line":311,"name":"%IS_VALID_FORMAT","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":"main::","name":"tagformat","children":[{"localvar":"my","containerName":"tagformat","kind":13,"name":"$self","line":314,"definition":"my"},{"line":314,"kind":13,"containerName":"tagformat","name":"$value"},{"name":"$value","containerName":"tagformat","kind":13,"line":315},{"containerName":"tagformat","kind":13,"name":"$self","line":316},{"line":316,"name":"throw","kind":12,"containerName":"tagformat"},{"name":"%IS_VALID_FORMAT","containerName":"tagformat","kind":13,"line":317},{"line":318,"name":"$IS_VALID_FORMAT","containerName":"tagformat","kind":13},{"name":"$value","kind":13,"containerName":"tagformat","line":318},{"kind":13,"containerName":"tagformat","name":"$self","line":319},{"containerName":"tagformat","kind":13,"name":"$value","line":319},{"kind":13,"containerName":"tagformat","name":"$self","line":321}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":322},"start":{"line":313,"character":0}},"line":313,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"tagformat($self,$value)"}},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"node","line":337,"definition":"my"},{"line":337,"containerName":"node","kind":13,"name":"$value"},{"line":337,"kind":13,"containerName":"node","name":"$copy"},{"name":"$value","containerName":"node","kind":13,"line":338},{"kind":13,"containerName":"node","name":"$value","line":338},{"line":339,"containerName":"node","kind":13,"name":"$self"},{"line":340,"name":"$value","containerName":"node","kind":13},{"line":340,"containerName":"node","kind":12,"name":"isa"},{"line":341,"name":"$copy","containerName":"node","kind":13},{"containerName":"node","kind":13,"name":"$copy","line":341},{"name":"$value","containerName":"node","kind":13,"line":341},{"line":341,"name":"duplicate","containerName":"node","kind":12},{"containerName":"node","kind":13,"name":"$value","line":341},{"line":342,"name":"$value","containerName":"node","kind":13},{"kind":12,"containerName":"node","name":"isa","line":342},{"kind":13,"containerName":"node","name":"$copy","line":343},{"name":"$copy","containerName":"node","kind":13,"line":343},{"line":343,"containerName":"node","kind":13,"name":"$value"},{"name":"node","containerName":"node","kind":12,"line":343},{"line":343,"kind":12,"containerName":"node","name":"duplicate"},{"line":343,"kind":13,"containerName":"node","name":"$value"},{"name":"node","containerName":"node","kind":12,"line":343},{"name":"$self","kind":13,"containerName":"node","line":344},{"name":"throw","containerName":"node","kind":12,"line":344},{"line":349,"containerName":"node","kind":13,"name":"$self"},{"line":350,"kind":13,"containerName":"node","name":"$self"},{"containerName":"node","kind":12,"name":"new","line":350},{"line":352,"kind":13,"containerName":"node","name":"$self"}],"containerName":"main::","name":"node","definition":"sub","detail":"($self,$value,$copy)","line":336,"kind":12,"range":{"start":{"line":336,"character":0},"end":{"line":353,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"},{"label":"$copy"}],"documentation":"","label":"node($self,$value,$copy)"}},{"line":350,"containerName":"Stag","kind":12,"name":"Data"},{"definition":"sub","containerName":"main::","name":"element","children":[{"definition":"my","line":379,"containerName":"element","localvar":"my","kind":13,"name":"$self"},{"line":380,"name":"$self","containerName":"element","kind":13},{"kind":12,"containerName":"element","name":"node","line":380},{"kind":12,"containerName":"element","name":"element","line":380}],"kind":12,"range":{"start":{"line":378,"character":0},"end":{"line":381,"character":9999}},"line":378},{"line":394,"kind":12,"range":{"start":{"line":394,"character":0},"end":{"character":9999,"line":397}},"definition":"sub","children":[{"name":"$self","containerName":"data","localvar":"my","kind":13,"line":395,"definition":"my"},{"line":396,"name":"$self","kind":13,"containerName":"data"},{"name":"node","containerName":"data","kind":12,"line":396},{"line":396,"name":"data","containerName":"data","kind":12}],"name":"data","containerName":"main::"},{"definition":"sub","children":[{"line":419,"name":"$self","kind":13,"localvar":"my","containerName":"children","definition":"my"},{"line":420,"name":"$self","containerName":"children","kind":13},{"name":"node","kind":12,"containerName":"children","line":420},{"line":420,"kind":12,"containerName":"children","name":"children"}],"name":"children","containerName":"main::","line":418,"range":{"start":{"line":418,"character":0},"end":{"character":9999,"line":421}},"kind":12},{"line":436,"kind":12,"range":{"start":{"line":436,"character":0},"end":{"line":439,"character":9999}},"children":[{"name":"$self","localvar":"my","containerName":"subnodes","kind":13,"line":437,"definition":"my"},{"line":438,"containerName":"subnodes","kind":13,"name":"$self"},{"line":438,"name":"node","containerName":"subnodes","kind":12},{"line":438,"name":"subnodes","containerName":"subnodes","kind":12}],"name":"subnodes","containerName":"main::","definition":"sub"},{"line":453,"kind":12,"range":{"end":{"character":9999,"line":456},"start":{"line":453,"character":0}},"signature":{"label":"get($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]},"children":[{"containerName":"get","localvar":"my","kind":13,"name":"$self","line":454,"definition":"my"},{"containerName":"get","kind":13,"name":"@vals","line":454},{"kind":13,"containerName":"get","name":"$self","line":455},{"line":455,"name":"node","kind":12,"containerName":"get"},{"line":455,"name":"get","kind":12,"containerName":"get"},{"line":455,"name":"@vals","containerName":"get","kind":13}],"containerName":"main::","name":"get","definition":"sub","detail":"($self,@vals)"},{"line":470,"range":{"end":{"line":473,"character":9999},"start":{"line":470,"character":0}},"kind":12,"signature":{"label":"find($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"find","kind":13,"line":471},{"line":471,"name":"@vals","kind":13,"containerName":"find"},{"line":472,"containerName":"find","kind":13,"name":"$self"},{"line":472,"name":"node","containerName":"find","kind":12},{"line":472,"name":"find","containerName":"find","kind":12},{"name":"@vals","kind":13,"containerName":"find","line":472}],"containerName":"main::","name":"find","definition":"sub","detail":"($self,@vals)"},{"signature":{"parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":"","label":"findnode($self,@vals)"},"line":487,"range":{"end":{"character":9999,"line":490},"start":{"character":0,"line":487}},"kind":12,"definition":"sub","detail":"($self,@vals)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"findnode","line":488},{"kind":13,"containerName":"findnode","name":"@vals","line":488},{"containerName":"findnode","kind":13,"name":"$self","line":489},{"kind":12,"containerName":"findnode","name":"node","line":489},{"line":489,"kind":12,"containerName":"findnode","name":"findnode"},{"name":"@vals","kind":13,"containerName":"findnode","line":489}],"containerName":"main::","name":"findnode"},{"containerName":"main::","name":"findval","children":[{"definition":"my","line":504,"name":"$self","containerName":"findval","localvar":"my","kind":13},{"kind":13,"containerName":"findval","name":"@vals","line":504},{"containerName":"findval","kind":13,"name":"$self","line":505},{"line":505,"name":"node","containerName":"findval","kind":12},{"kind":12,"containerName":"findval","name":"findval","line":505},{"line":505,"kind":13,"containerName":"findval","name":"@vals"}],"detail":"($self,@vals)","definition":"sub","range":{"end":{"line":506,"character":9999},"start":{"line":503,"character":0}},"kind":12,"line":503,"signature":{"label":"findval($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]}},{"kind":12,"range":{"end":{"character":9999,"line":544},"start":{"line":526,"character":0}},"line":526,"signature":{"label":"addchild($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]},"containerName":"main::","name":"addchild","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"addchild","name":"$self","line":527},{"name":"@vals","containerName":"addchild","kind":13,"line":527},{"name":"$self","containerName":"addchild","kind":13,"line":530},{"kind":12,"containerName":"addchild","name":"element","line":530},{"line":533,"containerName":"addchild","kind":13,"name":"@vals"},{"name":"$self","kind":13,"containerName":"addchild","line":533},{"name":"value","kind":12,"containerName":"addchild","line":533},{"kind":13,"containerName":"addchild","name":"@vals","line":533},{"line":533,"containerName":"addchild","kind":13,"name":"$self"},{"containerName":"addchild","kind":12,"name":"value","line":533},{"containerName":"addchild","kind":13,"name":"$vals","line":533},{"kind":13,"containerName":"addchild","name":"$self","line":534},{"kind":13,"containerName":"addchild","name":"$self","line":536},{"name":"node","containerName":"addchild","kind":12,"line":536},{"name":"ntnodes","containerName":"addchild","kind":12,"line":536},{"line":539,"name":"$self","containerName":"addchild","kind":13},{"kind":12,"containerName":"addchild","name":"throw","line":539},{"name":"$self","containerName":"addchild","kind":13,"line":542},{"line":542,"name":"node","kind":12,"containerName":"addchild"},{"containerName":"addchild","kind":12,"name":"addchild","line":542},{"name":"@vals","kind":13,"containerName":"addchild","line":542}],"detail":"($self,@vals)","definition":"sub"},{"name":"db","kind":12,"line":534},{"containerName":"main::","name":"add","children":[{"definition":"my","line":562,"name":"$self","localvar":"my","containerName":"add","kind":13},{"containerName":"add","kind":13,"name":"@vals","line":562},{"line":565,"containerName":"add","kind":13,"name":"$self"},{"name":"node","containerName":"add","kind":12,"line":565},{"line":565,"containerName":"add","kind":12,"name":"element"},{"line":566,"kind":13,"containerName":"add","name":"$self"},{"name":"throw","kind":12,"containerName":"add","line":566},{"name":"$self","kind":13,"containerName":"add","line":568},{"kind":12,"containerName":"add","name":"node","line":568},{"line":568,"containerName":"add","kind":12,"name":"add"},{"line":568,"name":"@vals","kind":13,"containerName":"add"}],"detail":"($self,@vals)","definition":"sub","range":{"end":{"line":569,"character":9999},"start":{"line":561,"character":0}},"kind":12,"line":561,"signature":{"label":"add($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]}},{"range":{"end":{"line":591,"character":9999},"start":{"character":0,"line":583}},"kind":12,"line":583,"signature":{"label":"set($self,@vals)","parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":""},"name":"set","containerName":"main::","children":[{"definition":"my","line":584,"name":"$self","containerName":"set","localvar":"my","kind":13},{"name":"@vals","containerName":"set","kind":13,"line":584},{"name":"$self","containerName":"set","kind":13,"line":587},{"line":587,"containerName":"set","kind":12,"name":"node"},{"line":587,"name":"element","containerName":"set","kind":12},{"containerName":"set","kind":13,"name":"$self","line":588},{"name":"throw","containerName":"set","kind":12,"line":588},{"name":"$self","kind":13,"containerName":"set","line":590},{"line":590,"name":"node","containerName":"set","kind":12},{"line":590,"name":"set","containerName":"set","kind":12},{"name":"@vals","kind":13,"containerName":"set","line":590}],"detail":"($self,@vals)","definition":"sub"},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}],"label":"unset($self,@vals)"},"line":604,"range":{"end":{"line":607,"character":9999},"start":{"character":0,"line":604}},"kind":12,"definition":"sub","detail":"($self,@vals)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"unset","line":605},{"line":605,"containerName":"unset","kind":13,"name":"@vals"},{"containerName":"unset","kind":13,"name":"$self","line":606},{"line":606,"containerName":"unset","kind":12,"name":"node"},{"line":606,"containerName":"unset","kind":12,"name":"unset"},{"name":"@vals","kind":13,"containerName":"unset","line":606}],"containerName":"main::","name":"unset"},{"line":619,"range":{"start":{"line":619,"character":0},"end":{"line":622,"character":9999}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"free($self)"},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"free","line":620},{"containerName":"free","kind":13,"name":"$self","line":621},{"line":621,"name":"node","kind":12,"containerName":"free"},{"line":621,"containerName":"free","kind":12,"name":"free"}],"containerName":"main::","name":"free","definition":"sub","detail":"($self)"},{"detail":"($self)","definition":"sub","name":"hash","containerName":"main::","children":[{"definition":"my","line":636,"name":"$self","containerName":"hash","localvar":"my","kind":13},{"kind":13,"containerName":"hash","name":"$self","line":637},{"line":637,"containerName":"hash","kind":12,"name":"node"},{"line":637,"name":"hash","kind":12,"containerName":"hash"}],"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"hash($self)"},"range":{"end":{"line":638,"character":9999},"start":{"line":635,"character":0}},"kind":12,"line":635},{"name":"pairs","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"pairs","kind":13,"line":653},{"name":"$self","containerName":"pairs","kind":13,"line":654},{"line":654,"kind":12,"containerName":"pairs","name":"node"},{"name":"pairs","containerName":"pairs","kind":12,"line":654}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":655},"start":{"character":0,"line":652}},"line":652,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"pairs($self)"}},{"line":668,"kind":12,"range":{"start":{"line":668,"character":0},"end":{"line":671,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":"","label":"qmatch($self,@vals)"},"children":[{"line":669,"name":"$self","localvar":"my","containerName":"qmatch","kind":13,"definition":"my"},{"line":669,"name":"@vals","kind":13,"containerName":"qmatch"},{"kind":13,"containerName":"qmatch","name":"$self","line":670},{"containerName":"qmatch","kind":12,"name":"node","line":670},{"containerName":"qmatch","kind":12,"name":"qmatch","line":670},{"containerName":"qmatch","kind":13,"name":"@vals","line":670}],"containerName":"main::","name":"qmatch","definition":"sub","detail":"($self,@vals)"},{"range":{"start":{"character":0,"line":683},"end":{"line":686,"character":9999}},"kind":12,"line":683,"signature":{"label":"tnodes($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","name":"tnodes","children":[{"definition":"my","line":684,"kind":13,"localvar":"my","containerName":"tnodes","name":"$self"},{"name":"$self","containerName":"tnodes","kind":13,"line":685},{"containerName":"tnodes","kind":12,"name":"node","line":685},{"name":"tnodes","containerName":"tnodes","kind":12,"line":685}],"detail":"($self)","definition":"sub"},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"ntnodes","name":"$self","line":699,"definition":"my"},{"containerName":"ntnodes","kind":13,"name":"$self","line":700},{"line":700,"kind":12,"containerName":"ntnodes","name":"node"},{"line":700,"containerName":"ntnodes","kind":12,"name":"ntnodes"}],"name":"ntnodes","containerName":"main::","signature":{"label":"ntnodes($self)","parameters":[{"label":"$self"}],"documentation":""},"line":698,"kind":12,"range":{"end":{"line":701,"character":9999},"start":{"line":698,"character":0}}},{"children":[{"definition":"my","line":722,"containerName":"get_all_values","localvar":"my","kind":13,"name":"$self"},{"kind":13,"localvar":"my","containerName":"get_all_values","name":"@kids","line":723,"definition":"my"},{"line":723,"containerName":"get_all_values","kind":13,"name":"$self"},{"name":"children","kind":12,"containerName":"get_all_values","line":723},{"localvar":"my","kind":13,"containerName":"get_all_values","name":"@vals","line":724,"definition":"my"},{"name":"$val","kind":13,"localvar":"my","containerName":"get_all_values","line":725,"definition":"my"},{"line":725,"kind":13,"containerName":"get_all_values","name":"@kids"},{"line":726,"name":"$val","containerName":"get_all_values","kind":13},{"line":726,"kind":13,"containerName":"get_all_values","name":"@kids"},{"line":726,"containerName":"get_all_values","kind":13,"name":"$val"},{"name":"children","kind":12,"containerName":"get_all_values","line":726},{"line":726,"name":"@vals","kind":13,"containerName":"get_all_values"},{"line":726,"name":"$val","containerName":"get_all_values","kind":13},{"line":728,"containerName":"get_all_values","kind":13,"name":"@vals"}],"containerName":"main::","name":"get_all_values","definition":"sub","line":721,"kind":12,"range":{"start":{"character":0,"line":721},"end":{"character":9999,"line":729}}}]}