{"vars":[{"kind":2,"containerName":"","name":"base","line":80},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Relation.pm 14708 2008-06-10 00:08:17Z heikki $\n#\n# BioPerl module for Bio::Annotation::Relation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Relation - Relationship (pairwise) with other objects SeqI and NodeI;\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::Relation;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::Relation->new(-type => \"paralogy\" -to => \"someSeqI\");\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Relation;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::Relation->new();\n Function: Instantiate a new Relation object\n Returns : Bio::Annotation::Relation object\n Args    : -type    => $type of relation [optional]\n           -to     => $obj which $self is in relation to [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]"},"line":95,"range":{"start":{"character":0,"line":95},"end":{"character":9999,"line":110}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":96,"kind":13,"localvar":"my","containerName":"new","name":"$class"},{"line":96,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":98},{"line":98,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":98},{"definition":"my","line":100,"name":"$type","containerName":"new","localvar":"my","kind":13},{"line":100,"containerName":"new","kind":13,"name":"$to"},{"line":100,"kind":13,"containerName":"new","name":"$tag"},{"kind":13,"containerName":"new","name":"$term","line":100},{"name":"$self","kind":13,"containerName":"new","line":101},{"name":"_rearrange","kind":12,"containerName":"new","line":101},{"containerName":"new","kind":13,"name":"@args","line":101},{"name":"$term","kind":13,"containerName":"new","line":104},{"kind":13,"containerName":"new","name":"$self","line":104},{"kind":12,"containerName":"new","name":"tag_term","line":104},{"name":"$term","containerName":"new","kind":13,"line":104},{"name":"$type","containerName":"new","kind":13,"line":105},{"line":105,"name":"$self","kind":13,"containerName":"new"},{"name":"type","containerName":"new","kind":12,"line":105},{"containerName":"new","kind":13,"name":"$type","line":105},{"name":"$to","kind":13,"containerName":"new","line":106},{"containerName":"new","kind":13,"name":"$self","line":106},{"containerName":"new","kind":12,"name":"to","line":106},{"line":106,"name":"$to","kind":13,"containerName":"new"},{"line":107,"name":"$tag","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":107},{"line":107,"kind":12,"containerName":"new","name":"tagname"},{"containerName":"new","kind":13,"name":"$tag","line":107},{"line":109,"containerName":"new","kind":13,"name":"$self"}],"containerName":"main::","name":"new"},{"line":98,"containerName":"new","kind":12,"name":"SUPER"},{"definition":"sub","detail":"($self)","children":[{"line":129,"name":"$self","containerName":"as_text","localvar":"my","kind":13,"definition":"my"},{"containerName":"as_text","kind":13,"name":"$self","line":131},{"kind":12,"containerName":"as_text","name":"type","line":131},{"kind":13,"containerName":"as_text","name":"$self","line":131},{"line":131,"containerName":"as_text","kind":12,"name":"to"},{"line":131,"name":"id","kind":12,"containerName":"as_text"}],"name":"as_text","containerName":"main::","signature":{"label":"as_text($self)","documentation":"1;\n# $Id: Relation.pm 14708 2008-06-10 00:08:17Z heikki $\n#\n# BioPerl module for Bio::Annotation::Relation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Relation - Relationship (pairwise) with other objects SeqI and NodeI;\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::Relation;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::Relation->new(-type => \"paralogy\" -to => \"someSeqI\");\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Relation;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::Relation->new();\n Function: Instantiate a new Relation object\n Returns : Bio::Annotation::Relation object\n Args    : -type    => $type of relation [optional]\n           -to     => $obj which $self is in relation to [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($type, $to, $tag, $term) =\n       $self->_rearrange([qw(TYPE TO TAGNAME TAG_TERM)], @args);\n\n   # set the term first\n   defined $term   && $self->tag_term($term);\n   defined $type && $self->type($type);\n   defined $to  && $self->to($to);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none","parameters":[{"label":"$self"}]},"line":128,"range":{"end":{"character":9999,"line":132},"start":{"line":128,"character":0}},"kind":12},{"line":151,"localvar":"my","kind":13,"containerName":null,"name":"%DEFAULT_CB","definition":"my"},{"line":151,"name":"type","containerName":"main::","kind":12},{"line":151,"kind":12,"containerName":"main::","name":"to"},{"name":"id","kind":12,"containerName":"main::","line":151},{"line":154,"range":{"start":{"line":154,"character":0},"end":{"character":9999,"line":159}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$cb"}],"documentation":"my $DEFAULT_CB = sub { $_[0]->value};","label":"display_text($self,$cb)"},"children":[{"definition":"my","line":155,"name":"$self","localvar":"my","kind":13,"containerName":"display_text"},{"containerName":"display_text","kind":13,"name":"$cb","line":155},{"name":"$cb","containerName":"display_text","kind":13,"line":156},{"line":156,"kind":13,"containerName":"display_text","name":"$DEFAULT_CB"},{"name":"$self","kind":13,"containerName":"display_text","line":157},{"line":157,"kind":12,"containerName":"display_text","name":"throw"},{"line":157,"containerName":"display_text","kind":13,"name":"$cb"},{"kind":13,"containerName":"display_text","name":"$cb","line":158},{"line":158,"name":"$self","containerName":"display_text","kind":13}],"containerName":"main::","name":"display_text","definition":"sub","detail":"($self,$cb)"},{"name":"hash_tree","containerName":"main::","children":[{"line":176,"kind":13,"localvar":"my","containerName":"hash_tree","name":"$self","definition":"my"},{"line":178,"name":"$h","kind":13,"localvar":"my","containerName":"hash_tree","definition":"my"},{"kind":13,"containerName":"hash_tree","name":"$h","line":179},{"containerName":"hash_tree","kind":13,"name":"$self","line":179},{"line":179,"name":"type","kind":12,"containerName":"hash_tree"},{"line":180,"kind":13,"containerName":"hash_tree","name":"$h"},{"kind":13,"containerName":"hash_tree","name":"$self","line":180},{"line":180,"kind":12,"containerName":"hash_tree","name":"to"},{"line":181,"name":"$h","containerName":"hash_tree","kind":13}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":175},"end":{"character":9999,"line":182}},"line":175},{"name":"tagname","containerName":"main::","children":[{"line":202,"localvar":"my","containerName":"tagname","kind":13,"name":"$self","definition":"my"},{"line":205,"kind":13,"containerName":"tagname","name":"$self"},{"containerName":"tagname","kind":13,"name":"$self","line":207},{"name":"$self","kind":13,"containerName":"tagname","line":209},{"line":209,"name":"tag_term","containerName":"tagname","kind":12},{"kind":12,"containerName":"tagname","name":"name","line":209},{"name":"$self","kind":13,"containerName":"tagname","line":211},{"name":"$self","kind":13,"containerName":"tagname","line":212}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":201},"end":{"character":9999,"line":213}},"line":201},{"children":[{"definition":"my","name":"$self","containerName":"type","localvar":"my","kind":13,"line":232},{"name":"$type","containerName":"type","kind":13,"line":232},{"name":"$type","kind":13,"containerName":"type","line":234},{"name":"$self","kind":13,"containerName":"type","line":235},{"kind":13,"containerName":"type","name":"$type","line":235},{"line":237,"kind":13,"containerName":"type","name":"$self"}],"containerName":"main::","name":"type","definition":"sub","detail":"($self,$type)","line":231,"range":{"end":{"line":238,"character":9999},"start":{"character":0,"line":231}},"kind":12,"signature":{"label":"type($self,$type)","documentation":"1;\n# $Id: Relation.pm 14708 2008-06-10 00:08:17Z heikki $\n#\n# BioPerl module for Bio::Annotation::Relation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Relation - Relationship (pairwise) with other objects SeqI and NodeI;\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::Relation;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::Relation->new(-type => \"paralogy\" -to => \"someSeqI\");\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Relation;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::Relation->new();\n Function: Instantiate a new Relation object\n Returns : Bio::Annotation::Relation object\n Args    : -type    => $type of relation [optional]\n           -to     => $obj which $self is in relation to [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($type, $to, $tag, $term) =\n       $self->_rearrange([qw(TYPE TO TAGNAME TAG_TERM)], @args);\n\n   # set the term first\n   defined $term   && $self->tag_term($term);\n   defined $type && $self->type($type);\n   defined $to  && $self->to($to);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return $self->type.\" to  \".$self->to->id;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { return $_[0]->type.\" to  \".$_[0]->to->id };\n  #my $DEFAULT_CB = sub { $_[0]->value};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n\n    my $h = {};\n    $h->{'type'} = $self->type;\n    $h->{'to'} = $self->to;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to AnnotationCollection when adding this\n           object.\n\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    # check for presence of an ontology term\n    if($self->{'_tag_term'}) {\n\t# keep a copy in case the term is removed later\n\t$self->{'tagname'} = $_[0] if @_;\n\t# delegate to the ontology term object\n\treturn $self->tag_term->name(@_);\n    }\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Specific accessors for Relation\n\n\n=head2 type \n\n Title   : type \n Usage   : $obj->type($newval)\n Function: Get/Set the type\n Returns : type of relation\n Args    : newtype (optional)","parameters":[{"label":"$self"},{"label":"$type"}]}},{"range":{"start":{"character":0,"line":251},"end":{"line":258,"character":9999}},"kind":12,"line":251,"signature":{"documentation":"1;\n# $Id: Relation.pm 14708 2008-06-10 00:08:17Z heikki $\n#\n# BioPerl module for Bio::Annotation::Relation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Relation - Relationship (pairwise) with other objects SeqI and NodeI;\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::Relation;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::Relation->new(-type => \"paralogy\" -to => \"someSeqI\");\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Relation;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::Relation->new();\n Function: Instantiate a new Relation object\n Returns : Bio::Annotation::Relation object\n Args    : -type    => $type of relation [optional]\n           -to     => $obj which $self is in relation to [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($type, $to, $tag, $term) =\n       $self->_rearrange([qw(TYPE TO TAGNAME TAG_TERM)], @args);\n\n   # set the term first\n   defined $term   && $self->tag_term($term);\n   defined $type && $self->type($type);\n   defined $to  && $self->to($to);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return $self->type.\" to  \".$self->to->id;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { return $_[0]->type.\" to  \".$_[0]->to->id };\n  #my $DEFAULT_CB = sub { $_[0]->value};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n\n    my $h = {};\n    $h->{'type'} = $self->type;\n    $h->{'to'} = $self->to;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to AnnotationCollection when adding this\n           object.\n\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    # check for presence of an ontology term\n    if($self->{'_tag_term'}) {\n\t# keep a copy in case the term is removed later\n\t$self->{'tagname'} = $_[0] if @_;\n\t# delegate to the ontology term object\n\treturn $self->tag_term->name(@_);\n    }\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Specific accessors for Relation\n\n\n=head2 type \n\n Title   : type \n Usage   : $obj->type($newval)\n Function: Get/Set the type\n Returns : type of relation\n Args    : newtype (optional)\n\n\n\nsub type{\n   my ($self,$type) = @_;\n\n   if( defined $type) {\n      $self->{'type'} = $type;\n    }\n    return $self->{'type'};\n}\n\n=head2 to\n\n Title   : to\n Usage   : $obj->to($newval)\n Function: Get/Set the object which $self is in relation to\n Returns : the object which the relation applies to\n Args    : new target object (optional)","parameters":[{"label":"$self"},{"label":"$to"}],"label":"to($self,$to)"},"name":"to","containerName":"main::","children":[{"definition":"my","line":252,"kind":13,"localvar":"my","containerName":"to","name":"$self"},{"kind":13,"containerName":"to","name":"$to","line":252},{"name":"$to","kind":13,"containerName":"to","line":254},{"line":255,"name":"$self","containerName":"to","kind":13},{"name":"$to","containerName":"to","kind":13,"line":255},{"name":"$self","kind":13,"containerName":"to","line":257}],"detail":"($self,$to)","definition":"sub"},{"definition":"sub","children":[{"line":288,"containerName":"tag_term","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","containerName":"tag_term","kind":13,"line":290},{"line":291,"containerName":"tag_term","kind":13,"name":"$self"}],"containerName":"main::","name":"tag_term","line":287,"kind":12,"range":{"end":{"character":9999,"line":292},"start":{"line":287,"character":0}}}],"version":5}