{"version":5,"vars":[{"line":60,"kind":2,"containerName":"","name":"base"},{"signature":{"documentation":"1;\n# $Id: DBLink.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::DBLink\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::DBLink - untyped links between databases\n\n=head1 SYNOPSIS\n\n   $link1 = Bio::Annotation::DBLink->new(-database => 'TSC',\n                                        -primary_id => 'TSC0000030'\n\t\t\t\t\t);\n\n   #or \n\n   $link2 = Bio::Annotation::DBLink->new();\n   $link2->database('dbSNP');\n   $link2->primary_id('2367');\n\n   # DBLink is-a Bio::AnnotationI object, can be added to annotation\n   # collections, e.g. the one on features or seqs\n   $feat->annotation->add_Annotation('dblink', $link2);\n\n\n=head1 DESCRIPTION\n\nProvides an object which represents a link from one object to something\nin another database without prescribing what is in the other database.\n\nAside from L<Bio::AnnotationI>, this class also implements\nL<Bio::IdentifiableI>.\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::IdentifiableI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $dblink = Bio::Annotation::DBLink->new(-database =>\"GenBank\",\n                                                  -primary_id => \"M123456\");\n Function: Creates a new instance of this class.\n Example :\n Returns : A new instance of Bio::Annotation::DBLink.\n Args    : Named parameters. At present, the following parameters are\n           recognized.\n\n             -database    the name of the database referenced by the xref\n             -primary_id  the primary (main) id of the referenced entry\n                          (usually this will be an accession number)\n             -optional_id a secondary ID under which the referenced entry\n                          is known in the same database\n             -comment     comment text for the dbxref\n             -tagname     the name of the tag under which to add this\n                          instance to an annotation bundle (usually 'dblink')\n             -namespace   synonymous with -database (also overrides)\n             -version     version of the referenced entry\n             -authority   attribute of the Bio::IdentifiableI interface\n             -url         attribute of the Bio::IdentifiableI interface","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"start":{"character":0,"line":89},"end":{"line":118,"character":9999}},"line":89,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":90,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":90},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":92,"definition":"my"},{"line":92,"name":"$class","kind":13,"containerName":"new"},{"line":92,"name":"@args","containerName":"new","kind":13},{"definition":"my","name":"$database","kind":13,"localvar":"my","containerName":"new","line":94},{"kind":13,"containerName":"new","name":"$primary_id","line":94},{"line":94,"name":"$optional_id","kind":13,"containerName":"new"},{"name":"$comment","containerName":"new","kind":13,"line":94},{"name":"$tag","kind":13,"containerName":"new","line":94},{"name":"$ns","containerName":"new","kind":13,"line":94},{"line":94,"containerName":"new","kind":13,"name":"$auth"},{"line":94,"kind":13,"containerName":"new","name":"$v"},{"line":94,"name":"$url","containerName":"new","kind":13},{"line":95,"name":"$self","containerName":"new","kind":13},{"line":95,"name":"_rearrange","kind":12,"containerName":"new"},{"line":104,"name":"@args","containerName":"new","kind":13},{"name":"$database","kind":13,"containerName":"new","line":106},{"name":"$self","containerName":"new","kind":13,"line":106},{"name":"database","containerName":"new","kind":12,"line":106},{"line":106,"containerName":"new","kind":13,"name":"$database"},{"line":107,"containerName":"new","kind":13,"name":"$primary_id"},{"line":107,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"primary_id","line":107},{"line":107,"name":"$primary_id","containerName":"new","kind":13},{"line":108,"containerName":"new","kind":13,"name":"$optional_id"},{"line":108,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"optional_id","line":108},{"name":"$optional_id","kind":13,"containerName":"new","line":108},{"containerName":"new","kind":13,"name":"$comment","line":109},{"line":109,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"comment","line":109},{"line":109,"containerName":"new","kind":13,"name":"$comment"},{"name":"$tag","containerName":"new","kind":13,"line":110},{"name":"$self","kind":13,"containerName":"new","line":110},{"name":"tagname","containerName":"new","kind":12,"line":110},{"line":110,"containerName":"new","kind":13,"name":"$tag"},{"name":"$ns","containerName":"new","kind":13,"line":112},{"name":"$self","kind":13,"containerName":"new","line":112},{"line":112,"name":"namespace","containerName":"new","kind":12},{"name":"$ns","kind":13,"containerName":"new","line":112},{"containerName":"new","kind":13,"name":"$auth","line":113},{"containerName":"new","kind":13,"name":"$self","line":113},{"kind":12,"containerName":"new","name":"authority","line":113},{"line":113,"containerName":"new","kind":13,"name":"$auth"},{"containerName":"new","kind":13,"name":"$v","line":114},{"line":114,"containerName":"new","kind":13,"name":"$self"},{"line":114,"name":"version","kind":12,"containerName":"new"},{"name":"$v","kind":13,"containerName":"new","line":114},{"line":115,"name":"$url","kind":13,"containerName":"new"},{"line":115,"kind":13,"containerName":"new","name":"$self"},{"line":115,"name":"url","containerName":"new","kind":12},{"line":115,"containerName":"new","kind":13,"name":"$url"},{"name":"$self","containerName":"new","kind":13,"line":117}]},{"kind":12,"containerName":"new","name":"SUPER","line":92},{"children":[{"line":138,"kind":13,"localvar":"my","containerName":"as_text","name":"$self","definition":"my"},{"line":140,"name":"$self","kind":13,"containerName":"as_text"},{"name":"primary_id","kind":12,"containerName":"as_text","line":141},{"line":141,"kind":13,"containerName":"as_text","name":"$self"},{"name":"version","kind":12,"containerName":"as_text","line":141},{"line":141,"name":"$self","kind":13,"containerName":"as_text"},{"name":"version","containerName":"as_text","kind":12,"line":141},{"kind":13,"containerName":"as_text","name":"$self","line":142},{"line":142,"name":"optional_id","kind":12,"containerName":"as_text"},{"line":142,"name":"$self","kind":13,"containerName":"as_text"},{"name":"optional_id","kind":12,"containerName":"as_text","line":142},{"containerName":"as_text","kind":13,"name":"$self","line":143},{"kind":12,"containerName":"as_text","name":"database","line":143}],"containerName":"main::","name":"as_text","definition":"sub","detail":"($self)","line":137,"kind":12,"range":{"end":{"character":9999,"line":144},"start":{"character":0,"line":137}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: DBLink.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::DBLink\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::DBLink - untyped links between databases\n\n=head1 SYNOPSIS\n\n   $link1 = Bio::Annotation::DBLink->new(-database => 'TSC',\n                                        -primary_id => 'TSC0000030'\n\t\t\t\t\t);\n\n   #or \n\n   $link2 = Bio::Annotation::DBLink->new();\n   $link2->database('dbSNP');\n   $link2->primary_id('2367');\n\n   # DBLink is-a Bio::AnnotationI object, can be added to annotation\n   # collections, e.g. the one on features or seqs\n   $feat->annotation->add_Annotation('dblink', $link2);\n\n\n=head1 DESCRIPTION\n\nProvides an object which represents a link from one object to something\nin another database without prescribing what is in the other database.\n\nAside from L<Bio::AnnotationI>, this class also implements\nL<Bio::IdentifiableI>.\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::IdentifiableI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $dblink = Bio::Annotation::DBLink->new(-database =>\"GenBank\",\n                                                  -primary_id => \"M123456\");\n Function: Creates a new instance of this class.\n Example :\n Returns : A new instance of Bio::Annotation::DBLink.\n Args    : Named parameters. At present, the following parameters are\n           recognized.\n\n             -database    the name of the database referenced by the xref\n             -primary_id  the primary (main) id of the referenced entry\n                          (usually this will be an accession number)\n             -optional_id a secondary ID under which the referenced entry\n                          is known in the same database\n             -comment     comment text for the dbxref\n             -tagname     the name of the tag under which to add this\n                          instance to an annotation bundle (usually 'dblink')\n             -namespace   synonymous with -database (also overrides)\n             -version     version of the referenced entry\n             -authority   attribute of the Bio::IdentifiableI interface\n             -url         attribute of the Bio::IdentifiableI interface\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($database,$primary_id,$optional_id,$comment,$tag,$ns,$auth,$v,$url) =\n      $self->_rearrange([qw(DATABASE\n\t\t\t    PRIMARY_ID\n\t\t\t    OPTIONAL_ID\n\t\t\t    COMMENT\n\t\t\t    TAGNAME\n\t\t\t    NAMESPACE\n\t\t\t    AUTHORITY\n\t\t\t    VERSION\n\t\t\t    URL\n\t\t\t    )], @args);\n  \n  $database    && $self->database($database);\n  $primary_id  && $self->primary_id($primary_id);\n  $optional_id && $self->optional_id($optional_id);\n  $comment     && $self->comment($comment);\n  $tag         && $self->tagname($tag);\n  # Bio::IdentifiableI parameters:\n  $ns          && $self->namespace($ns); # this will override $database\n  $auth        && $self->authority($auth);\n  defined($v)  && $self->version($v);\n  defined($url)  && $self->url($url);\n\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"as_text($self)"}},{"line":163,"name":"%DEFAULT_CB","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":163,"kind":12,"containerName":"main::","name":"database"},{"line":163,"name":"database","containerName":"main::","kind":12},{"line":164,"containerName":"main::","kind":12,"name":"primary_id"},{"kind":12,"containerName":"main::","name":"primary_id","line":164},{"line":165,"containerName":"main::","kind":12,"name":"version"},{"line":165,"name":"version","kind":12,"containerName":"main::"},{"line":167,"kind":12,"range":{"start":{"line":167,"character":0},"end":{"character":9999,"line":172}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}],"label":"display_text($self,$cb)"},"children":[{"line":168,"name":"$self","localvar":"my","containerName":"display_text","kind":13,"definition":"my"},{"line":168,"name":"$cb","kind":13,"containerName":"display_text"},{"kind":13,"containerName":"display_text","name":"$cb","line":169},{"line":169,"containerName":"display_text","kind":13,"name":"$DEFAULT_CB"},{"name":"$self","kind":13,"containerName":"display_text","line":170},{"containerName":"display_text","kind":12,"name":"throw","line":170},{"name":"$cb","containerName":"display_text","kind":13,"line":170},{"line":171,"name":"$cb","containerName":"display_text","kind":13},{"line":171,"kind":13,"containerName":"display_text","name":"$self"}],"containerName":"main::","name":"display_text","definition":"sub","detail":"($self,$cb)"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: DBLink.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::DBLink\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::DBLink - untyped links between databases\n\n=head1 SYNOPSIS\n\n   $link1 = Bio::Annotation::DBLink->new(-database => 'TSC',\n                                        -primary_id => 'TSC0000030'\n\t\t\t\t\t);\n\n   #or \n\n   $link2 = Bio::Annotation::DBLink->new();\n   $link2->database('dbSNP');\n   $link2->primary_id('2367');\n\n   # DBLink is-a Bio::AnnotationI object, can be added to annotation\n   # collections, e.g. the one on features or seqs\n   $feat->annotation->add_Annotation('dblink', $link2);\n\n\n=head1 DESCRIPTION\n\nProvides an object which represents a link from one object to something\nin another database without prescribing what is in the other database.\n\nAside from L<Bio::AnnotationI>, this class also implements\nL<Bio::IdentifiableI>.\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::IdentifiableI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $dblink = Bio::Annotation::DBLink->new(-database =>\"GenBank\",\n                                                  -primary_id => \"M123456\");\n Function: Creates a new instance of this class.\n Example :\n Returns : A new instance of Bio::Annotation::DBLink.\n Args    : Named parameters. At present, the following parameters are\n           recognized.\n\n             -database    the name of the database referenced by the xref\n             -primary_id  the primary (main) id of the referenced entry\n                          (usually this will be an accession number)\n             -optional_id a secondary ID under which the referenced entry\n                          is known in the same database\n             -comment     comment text for the dbxref\n             -tagname     the name of the tag under which to add this\n                          instance to an annotation bundle (usually 'dblink')\n             -namespace   synonymous with -database (also overrides)\n             -version     version of the referenced entry\n             -authority   attribute of the Bio::IdentifiableI interface\n             -url         attribute of the Bio::IdentifiableI interface\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($database,$primary_id,$optional_id,$comment,$tag,$ns,$auth,$v,$url) =\n      $self->_rearrange([qw(DATABASE\n\t\t\t    PRIMARY_ID\n\t\t\t    OPTIONAL_ID\n\t\t\t    COMMENT\n\t\t\t    TAGNAME\n\t\t\t    NAMESPACE\n\t\t\t    AUTHORITY\n\t\t\t    VERSION\n\t\t\t    URL\n\t\t\t    )], @args);\n  \n  $database    && $self->database($database);\n  $primary_id  && $self->primary_id($primary_id);\n  $optional_id && $self->optional_id($optional_id);\n  $comment     && $self->comment($comment);\n  $tag         && $self->tagname($tag);\n  # Bio::IdentifiableI parameters:\n  $ns          && $self->namespace($ns); # this will override $database\n  $auth        && $self->authority($auth);\n  defined($v)  && $self->version($v);\n  defined($url)  && $self->url($url);\n\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Direct database link to \".$self->primary_id\n       .($self->version ? \".\".$self->version : \"\")\n       .($self->optional_id ? \" (\".$self->optional_id.\")\" : \"\")\n       .\" in database \".$self->database;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { (($_[0]->database ? $_[0]->database . ':' : '' ) .\n                          ($_[0]->primary_id ? $_[0]->primary_id : '') .\n                          ($_[0]->version ? '.' . $_[0]->version : '')) || '' };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"hash_tree($self)"},"range":{"start":{"character":0,"line":188},"end":{"character":9999,"line":203}},"kind":12,"line":188,"detail":"($self)","definition":"sub","containerName":"main::","name":"hash_tree","children":[{"kind":13,"localvar":"my","containerName":"hash_tree","name":"$self","line":189,"definition":"my"},{"line":191,"containerName":"hash_tree","localvar":"my","kind":13,"name":"$h","definition":"my"},{"line":192,"containerName":"hash_tree","kind":13,"name":"$h"},{"kind":13,"containerName":"hash_tree","name":"$self","line":192},{"name":"database","containerName":"hash_tree","kind":12,"line":192},{"line":193,"name":"$h","kind":13,"containerName":"hash_tree"},{"line":193,"kind":13,"containerName":"hash_tree","name":"$self"},{"line":193,"kind":12,"containerName":"hash_tree","name":"primary_id"},{"name":"$self","kind":13,"containerName":"hash_tree","line":194},{"line":194,"name":"optional_id","kind":12,"containerName":"hash_tree"},{"name":"$h","containerName":"hash_tree","kind":13,"line":195},{"line":195,"kind":13,"containerName":"hash_tree","name":"$self"},{"line":195,"name":"optional_id","containerName":"hash_tree","kind":12},{"line":197,"kind":13,"containerName":"hash_tree","name":"$self"},{"name":"comment","kind":12,"containerName":"hash_tree","line":197},{"containerName":"hash_tree","kind":13,"name":"$h","line":199},{"containerName":"hash_tree","kind":13,"name":"$self","line":199},{"name":"comment","containerName":"hash_tree","kind":12,"line":199},{"name":"$h","kind":13,"containerName":"hash_tree","line":202}]},{"range":{"end":{"line":230,"character":9999},"start":{"line":225,"character":0}},"kind":12,"line":225,"definition":"sub","containerName":"main::","name":"tagname","children":[{"line":226,"localvar":"my","containerName":"tagname","kind":13,"name":"$self","definition":"my"},{"name":"$self","containerName":"tagname","kind":13,"line":228},{"containerName":"tagname","kind":13,"name":"$self","line":229}]},{"name":"database","containerName":"main::","children":[{"line":249,"kind":13,"localvar":"my","containerName":"database","name":"$self","definition":"my"},{"line":251,"name":"$self","containerName":"database","kind":13},{"line":252,"name":"$self","containerName":"database","kind":13}],"definition":"sub","range":{"start":{"character":0,"line":248},"end":{"line":253,"character":9999}},"kind":12,"line":248},{"line":269,"kind":12,"range":{"start":{"character":0,"line":269},"end":{"character":9999,"line":274}},"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"primary_id","line":270,"definition":"my"},{"kind":13,"containerName":"primary_id","name":"$self","line":272},{"name":"$self","kind":13,"containerName":"primary_id","line":273}],"containerName":"main::","name":"primary_id"},{"containerName":"main::","name":"optional_id","children":[{"localvar":"my","kind":13,"containerName":"optional_id","name":"$self","line":298,"definition":"my"},{"line":300,"name":"$self","containerName":"optional_id","kind":13},{"containerName":"optional_id","kind":13,"name":"$self","line":301}],"definition":"sub","range":{"end":{"character":9999,"line":302},"start":{"character":0,"line":297}},"kind":12,"line":297},{"kind":12,"range":{"start":{"character":0,"line":316},"end":{"character":9999,"line":321}},"line":316,"containerName":"main::","name":"comment","children":[{"definition":"my","name":"$self","containerName":"comment","localvar":"my","kind":13,"line":317},{"line":319,"kind":13,"containerName":"comment","name":"$self"},{"line":320,"containerName":"comment","kind":13,"name":"$self"}],"definition":"sub"},{"name":"object_id","containerName":"main::","children":[{"containerName":"object_id","kind":12,"name":"primary_id","line":340}],"definition":"sub","kind":12,"range":{"start":{"line":339,"character":0},"end":{"line":341,"character":9999}},"line":339},{"line":356,"range":{"start":{"character":0,"line":356},"end":{"line":361,"character":9999}},"kind":12,"definition":"sub","children":[{"line":357,"containerName":"version","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":359,"name":"$self","kind":13,"containerName":"version"},{"name":"$self","containerName":"version","kind":13,"line":360}],"containerName":"main::","name":"version"},{"line":373,"range":{"end":{"character":9999,"line":377},"start":{"line":373,"character":0}},"kind":12,"children":[{"containerName":"url","localvar":"my","kind":13,"name":"$self","line":374,"definition":"my"},{"name":"$self","kind":13,"containerName":"url","line":375},{"line":376,"kind":13,"containerName":"url","name":"$self"}],"name":"url","containerName":"main::","definition":"sub"},{"children":[{"definition":"my","line":393,"kind":13,"localvar":"my","containerName":"authority","name":"$self"},{"name":"$self","containerName":"authority","kind":13,"line":395},{"name":"$self","containerName":"authority","kind":13,"line":396}],"containerName":"main::","name":"authority","definition":"sub","line":392,"range":{"end":{"line":397,"character":9999},"start":{"character":0,"line":392}},"kind":12},{"range":{"start":{"character":0,"line":413},"end":{"character":9999,"line":415}},"kind":12,"line":413,"definition":"sub","containerName":"main::","name":"namespace","children":[{"containerName":"namespace","kind":12,"name":"database","line":414}]}]}