{"vars":[{"line":48,"kind":2,"containerName":"","name":"base"},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set","parameters":[{"label":"$class"},{"label":"@args"}]},"line":64,"kind":12,"range":{"end":{"line":74,"character":9999},"start":{"line":64,"character":0}},"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":65,"kind":13,"localvar":"my","containerName":"new","name":"$class"},{"line":65,"kind":13,"containerName":"new","name":"@args"},{"line":67,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"line":67,"containerName":"new","kind":13,"name":"$class"},{"line":67,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":68,"name":"$text","localvar":"my","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$tag","line":68},{"kind":13,"containerName":"new","name":"$type","line":68},{"name":"$self","containerName":"new","kind":13,"line":68},{"name":"_rearrange","kind":12,"containerName":"new","line":68},{"containerName":"new","kind":13,"name":"@args","line":68},{"line":70,"kind":13,"containerName":"new","name":"$text"},{"name":"$self","containerName":"new","kind":13,"line":70},{"line":70,"name":"text","containerName":"new","kind":12},{"line":70,"containerName":"new","kind":13,"name":"$text"},{"line":71,"containerName":"new","kind":13,"name":"$tag"},{"line":71,"containerName":"new","kind":13,"name":"$self"},{"name":"tagname","kind":12,"containerName":"new","line":71},{"line":71,"name":"$tag","kind":13,"containerName":"new"},{"name":"$type","kind":13,"containerName":"new","line":72},{"containerName":"new","kind":13,"name":"$self","line":72},{"kind":12,"containerName":"new","name":"type","line":72},{"kind":13,"containerName":"new","name":"$type","line":72},{"name":"$self","containerName":"new","kind":13,"line":73}],"name":"new","containerName":"main::"},{"name":"SUPER","containerName":"new","kind":12,"line":67},{"name":"as_text","containerName":"main::","children":[{"line":93,"kind":13,"localvar":"my","containerName":"as_text","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"as_text","line":95},{"containerName":"as_text","kind":12,"name":"text","line":95}],"detail":"($self)","definition":"sub","range":{"start":{"character":0,"line":92},"end":{"line":96,"character":9999}},"kind":12,"line":92,"signature":{"label":"as_text($self)","documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}]}},{"name":"%DEFAULT_CB","localvar":"my","containerName":null,"kind":13,"line":115,"definition":"my"},{"line":115,"name":"text","containerName":"main::","kind":12},{"signature":{"label":"display_text($self,$cb)","parameters":[{"label":"$self"},{"label":"$cb"}],"documentation":""},"range":{"end":{"character":9999,"line":122},"start":{"line":117,"character":0}},"kind":12,"line":117,"detail":"($self,$cb)","definition":"sub","containerName":"main::","name":"display_text","children":[{"definition":"my","line":118,"localvar":"my","kind":13,"containerName":"display_text","name":"$self"},{"name":"$cb","containerName":"display_text","kind":13,"line":118},{"line":119,"name":"$cb","kind":13,"containerName":"display_text"},{"containerName":"display_text","kind":13,"name":"$DEFAULT_CB","line":119},{"line":120,"containerName":"display_text","kind":13,"name":"$self"},{"kind":12,"containerName":"display_text","name":"throw","line":120},{"line":120,"name":"$cb","kind":13,"containerName":"display_text"},{"containerName":"display_text","kind":13,"name":"$cb","line":121},{"line":121,"kind":13,"containerName":"display_text","name":"$self"}]},{"range":{"start":{"character":0,"line":138},"end":{"character":9999,"line":144}},"kind":12,"line":138,"definition":"sub","containerName":"main::","name":"hash_tree","children":[{"definition":"my","line":139,"name":"$self","localvar":"my","containerName":"hash_tree","kind":13},{"definition":"my","line":141,"kind":13,"localvar":"my","containerName":"hash_tree","name":"$h"},{"containerName":"hash_tree","kind":13,"name":"$h","line":142},{"name":"$self","kind":13,"containerName":"hash_tree","line":142},{"line":142,"kind":12,"containerName":"hash_tree","name":"text"},{"line":143,"containerName":"hash_tree","kind":13,"name":"$h"}]},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":167,"containerName":"tagname","localvar":"my","kind":13,"name":"$self"},{"name":"$value","containerName":"tagname","kind":13,"line":167},{"line":168,"kind":13,"containerName":"tagname","name":"$value"},{"line":169,"name":"$self","containerName":"tagname","kind":13},{"line":169,"name":"$value","kind":13,"containerName":"tagname"},{"line":171,"kind":13,"containerName":"tagname","name":"$self"}],"name":"tagname","containerName":"main::","signature":{"label":"tagname($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Comment: \".$self->text;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub {$_[0]->text || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub hash_tree{\n    my $self = shift;\n   \n    my $h = {};\n    $h->{'text'} = $self->text;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)"},"line":166,"kind":12,"range":{"end":{"line":172,"character":9999},"start":{"character":0,"line":166}}},{"kind":12,"range":{"start":{"character":0,"line":193},"end":{"line":200,"character":9999}},"line":193,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Comment: \".$self->text;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub {$_[0]->text || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub hash_tree{\n    my $self = shift;\n   \n    my $h = {};\n    $h->{'text'} = $self->text;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'tagname'} = $value;\n    }\n    return $self->{'tagname'};\n}\n\n=head1 Specific accessors for Comments\n\n\n\n=head2 text\n\n Title   : text\n Usage   : $value = $self->text($newval)\n Function: get/set for the text field. A comment object\n           just holds a single string which is accessible through\n           this method\n Example : \n Returns : value of text\n Args    : newvalue (optional)","label":"text($self,$value)"},"containerName":"main::","name":"text","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"text","line":194,"definition":"my"},{"line":194,"name":"$value","containerName":"text","kind":13},{"name":"$value","containerName":"text","kind":13,"line":195},{"line":196,"name":"$self","kind":13,"containerName":"text"},{"line":196,"name":"$value","containerName":"text","kind":13},{"kind":13,"containerName":"text","name":"$self","line":198}],"detail":"($self,$value)","definition":"sub"},{"signature":{"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Comment: \".$self->text;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub {$_[0]->text || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub hash_tree{\n    my $self = shift;\n   \n    my $h = {};\n    $h->{'text'} = $self->text;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'tagname'} = $value;\n    }\n    return $self->{'tagname'};\n}\n\n=head1 Specific accessors for Comments\n\n\n\n=head2 text\n\n Title   : text\n Usage   : $value = $self->text($newval)\n Function: get/set for the text field. A comment object\n           just holds a single string which is accessible through\n           this method\n Example : \n Returns : value of text\n Args    : newvalue (optional)\n\n\n\nsub text{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'text'} = $value;\n    }\n    return $self->{'text'};\n\n}\n\n=head2 value\n\n Title   : value\n Usage   : $value = $self->value($newval)\n Function: Alias of the 'text' method\n Example :\n Returns : value of text\n Args    : newvalue (optional)\n\n\n\n\n*value = \\&text;\n\n=head2 type\n\n Title   : type\n Usage   : $value = $self->type($newval)\n Function: get/set for the comment type field.  The comment type\n           is normally found as a subfield within comment sections\n           in some files, such as SwissProt\n Example : \n Returns : value of text\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$type"}],"label":"type($self,$type)"},"line":231,"range":{"start":{"line":231,"character":0},"end":{"line":238,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$type)","children":[{"definition":"my","line":232,"name":"$self","containerName":"type","localvar":"my","kind":13},{"line":232,"name":"$type","containerName":"type","kind":13},{"name":"$type","kind":13,"containerName":"type","line":233},{"name":"$self","kind":13,"containerName":"type","line":234},{"containerName":"type","kind":13,"name":"$type","line":234},{"line":236,"containerName":"type","kind":13,"name":"$self"}],"containerName":"main::","name":"type"}],"version":5}