{"version":5,"vars":[{"line":72,"containerName":"","kind":2,"name":"vars"},{"line":75,"containerName":null,"kind":13,"name":"$BlockLen"},{"name":"strict","kind":2,"containerName":"","line":75},{"line":76,"kind":13,"containerName":null,"name":"$IdLength"},{"kind":2,"containerName":"","name":"base","line":83},{"signature":{"label":"next_aln($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: psi.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::psi\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::psi - Read/Write PSI-BLAST profile alignment files\n\n=head1 SYNOPSIS\n\nThis module will parse PSI-BLAST output of the format seqid XXXX  \n\n=head1 DESCRIPTION\n\nThis is a parser for psi-blast blocks.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::psi;\nuse vars qw($BlockLen $IdLength);\nuse strict;\n\n$BlockLen = 100; \n$IdLength = 13;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::AlignIO::psi->new();\n Function: Builds a new Bio::AlignIO::psi object \n Returns : Bio::AlignIO::psi\n Args    :\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI>"},"line":107,"kind":12,"range":{"start":{"character":0,"line":107},"end":{"line":132,"character":9999}},"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"next_aln","name":"$self","line":108,"definition":"my"},{"line":109,"name":"$aln","localvar":"my","containerName":"next_aln","kind":13,"definition":"my"},{"definition":"my","line":110,"name":"%seqs","containerName":"next_aln","localvar":"my","kind":13},{"localvar":"my","kind":13,"containerName":"next_aln","name":"@order","line":111,"definition":"my"},{"line":112,"name":"$self","containerName":"next_aln","kind":13},{"line":112,"name":"_readline","kind":12,"containerName":"next_aln"},{"name":"$aln","containerName":"next_aln","kind":13,"line":114},{"name":"$aln","containerName":"next_aln","kind":13,"line":115},{"name":"new","containerName":"next_aln","kind":12,"line":115},{"definition":"my","name":"$id","localvar":"my","containerName":"next_aln","kind":13,"line":117},{"name":"$s","containerName":"next_aln","kind":13,"line":117},{"name":"@order","containerName":"next_aln","kind":13,"line":118},{"line":118,"kind":13,"containerName":"next_aln","name":"$id"},{"name":"$seqs","containerName":"next_aln","kind":13,"line":118},{"line":118,"containerName":"next_aln","kind":13,"name":"$id"},{"line":119,"name":"$seqs","kind":13,"containerName":"next_aln"},{"name":"$id","kind":13,"containerName":"next_aln","line":119},{"name":"$s","kind":13,"containerName":"next_aln","line":119},{"line":121,"name":"$id","containerName":"next_aln","localvar":"my","kind":13,"definition":"my"},{"line":121,"containerName":"next_aln","kind":13,"name":"@order"},{"definition":"my","name":"$gaps","kind":13,"localvar":"my","containerName":"next_aln","line":122},{"line":122,"kind":13,"containerName":"next_aln","name":"$seqs"},{"line":122,"kind":13,"containerName":"next_aln","name":"$id"},{"name":"$seq","containerName":"next_aln","localvar":"my","kind":13,"line":123,"definition":"my"},{"line":123,"kind":12,"containerName":"next_aln","name":"new"},{"containerName":"next_aln","kind":13,"name":"$seqs","line":123},{"line":123,"name":"$id","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$id","line":124},{"kind":13,"containerName":"next_aln","name":"$seqs","line":126},{"name":"$id","kind":13,"containerName":"next_aln","line":126},{"line":127,"kind":13,"containerName":"next_aln","name":"$gaps"},{"line":128,"containerName":"next_aln","kind":13,"name":"$aln"},{"line":128,"name":"add_seq","kind":12,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$seq","line":128},{"name":"$aln","kind":13,"containerName":"next_aln","line":130},{"name":"$aln","containerName":"next_aln","kind":13,"line":130},{"line":130,"name":"$aln","containerName":"next_aln","kind":13},{"line":130,"containerName":"next_aln","kind":12,"name":"num_sequences"},{"kind":13,"containerName":"next_aln","name":"$aln","line":131}],"name":"next_aln","containerName":"main::"},{"line":115,"name":"Bio","containerName":"SimpleAlign","kind":12},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":123},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"write_aln","line":147,"definition":"my"},{"name":"$aln","kind":13,"containerName":"write_aln","line":147},{"line":148,"name":"$aln","kind":13,"containerName":"write_aln"},{"line":148,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"$aln","kind":13,"containerName":"write_aln","line":149},{"line":149,"containerName":"write_aln","kind":12,"name":"isa"},{"line":150,"name":"$self","kind":13,"containerName":"write_aln"},{"line":150,"name":"warn","kind":12,"containerName":"write_aln"},{"definition":"my","name":"$ct","localvar":"my","containerName":"write_aln","kind":13,"line":153},{"line":154,"name":"@seqs","localvar":"my","containerName":"write_aln","kind":13,"definition":"my"},{"containerName":"write_aln","kind":13,"name":"$aln","line":154},{"line":154,"kind":12,"containerName":"write_aln","name":"each_seq"},{"name":"$len","localvar":"my","kind":13,"containerName":"write_aln","line":155,"definition":"my"},{"definition":"my","containerName":"write_aln","localvar":"my","kind":13,"name":"$alnlen","line":156},{"line":156,"name":"$aln","containerName":"write_aln","kind":13},{"line":156,"name":"length","containerName":"write_aln","kind":12},{"line":157,"localvar":"my","containerName":"write_aln","kind":13,"name":"$idlen","definition":"my"},{"containerName":"write_aln","kind":13,"name":"$IdLength","line":157},{"definition":"my","line":158,"localvar":"my","containerName":"write_aln","kind":13,"name":"@ids"},{"name":"display_id","containerName":"write_aln","kind":12,"line":158},{"line":158,"kind":13,"containerName":"write_aln","name":"$idlen"},{"line":158,"containerName":"write_aln","kind":13,"name":"@seqs"},{"line":159,"containerName":"write_aln","kind":13,"name":"$len"},{"line":159,"kind":13,"containerName":"write_aln","name":"$alnlen"},{"definition":"my","name":"$start","kind":13,"localvar":"my","containerName":"write_aln","line":160},{"line":160,"kind":13,"containerName":"write_aln","name":"$len"},{"name":"$end","kind":13,"localvar":"my","containerName":"write_aln","line":161,"definition":"my"},{"name":"$len","kind":13,"containerName":"write_aln","line":161},{"line":161,"kind":13,"containerName":"write_aln","name":"$BlockLen"},{"line":162,"name":"$end","containerName":"write_aln","kind":13},{"line":162,"name":"$alnlen","containerName":"write_aln","kind":13},{"name":"$end","kind":13,"containerName":"write_aln","line":162},{"line":162,"name":"$alnlen","containerName":"write_aln","kind":13},{"definition":"my","containerName":"write_aln","localvar":"my","kind":13,"name":"$c","line":163},{"line":164,"localvar":"my","kind":13,"containerName":"write_aln","name":"$seq","definition":"my"},{"line":164,"kind":13,"containerName":"write_aln","name":"@seqs"},{"name":"$self","kind":13,"containerName":"write_aln","line":165},{"line":165,"name":"_print","kind":12,"containerName":"write_aln"},{"line":165,"kind":13,"containerName":"write_aln","name":"$idlen"},{"line":166,"containerName":"write_aln","kind":13,"name":"$ids"},{"line":166,"kind":13,"containerName":"write_aln","name":"$c"},{"name":"$seq","containerName":"write_aln","kind":13,"line":167},{"containerName":"write_aln","kind":12,"name":"subseq","line":167},{"name":"$start","containerName":"write_aln","kind":13,"line":167},{"line":167,"name":"$end","kind":13,"containerName":"write_aln"},{"name":"$self","kind":13,"containerName":"write_aln","line":169},{"name":"_print","kind":12,"containerName":"write_aln","line":169},{"line":170,"name":"$len","containerName":"write_aln","kind":13},{"line":170,"name":"$BlockLen","containerName":"write_aln","kind":13},{"line":172,"kind":13,"containerName":"write_aln","name":"$self"},{"line":172,"containerName":"write_aln","kind":12,"name":"flush"},{"name":"$self","containerName":"write_aln","kind":13,"line":172},{"line":172,"name":"_flush_on_write","containerName":"write_aln","kind":12},{"name":"$self","containerName":"write_aln","kind":13,"line":172},{"line":172,"name":"_fh","kind":12,"containerName":"write_aln"}],"name":"write_aln","containerName":"main::","definition":"sub","detail":"($self,$aln)","line":146,"kind":12,"range":{"end":{"line":174,"character":9999},"start":{"character":0,"line":146}},"signature":{"label":"write_aln($self,$aln)","documentation":"1;\n# $Id: psi.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::psi\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::psi - Read/Write PSI-BLAST profile alignment files\n\n=head1 SYNOPSIS\n\nThis module will parse PSI-BLAST output of the format seqid XXXX  \n\n=head1 DESCRIPTION\n\nThis is a parser for psi-blast blocks.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::psi;\nuse vars qw($BlockLen $IdLength);\nuse strict;\n\n$BlockLen = 100; \n$IdLength = 13;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::AlignIO::psi->new();\n Function: Builds a new Bio::AlignIO::psi object \n Returns : Bio::AlignIO::psi\n Args    :\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI>\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $aln;\n    my %seqs;\n    my @order;\n    while( defined ($_ = $self->_readline ) ) {\n\tnext if( /^\\s+$/);\n\tif( !defined $aln ) {\n\t    $aln = Bio::SimpleAlign->new();\n\t}\n\tmy ($id,$s) = split;\n\tpush @order, $id if( ! defined $seqs{$id});\n\t$seqs{$id} .= $s;\n    }\n    foreach my $id ( @order) {\n    my $gaps = $seqs{$id} =~ tr/-/-/;\n\tmy $seq = Bio::LocatableSeq->new(-seq => $seqs{$id},\n\t\t\t\t\t-id  => $id,\n\t\t\t\t\t-start => 1,\n\t\t\t\t\t-end   => length($seqs{$id}) - $gaps\n                    );\n\t$aln->add_seq($seq);\n    }\n    return $aln if defined $aln && $aln->num_sequences;\n\treturn $aln;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the NCBI psi-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\nL<Bio::Align::AlignI>","parameters":[{"label":"$self"},{"label":"$aln"}]}}]}