{"vars":[{"line":77,"kind":2,"containerName":"","name":"vars"},{"name":"base","kind":2,"containerName":"","line":85},{"name":"$WIDTH","kind":13,"containerName":null,"line":87},{"signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"range":{"start":{"character":0,"line":89},"end":{"line":94,"character":9999}},"line":89,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"line":90,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":90},{"name":"$self","containerName":"_initialize","kind":13,"line":91},{"line":91,"containerName":"_initialize","kind":13,"name":"@args"},{"localvar":"my","containerName":"_initialize","kind":13,"name":"$width","line":92,"definition":"my"},{"line":92,"kind":13,"containerName":"_initialize","name":"$self"},{"line":92,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"kind":13,"containerName":"_initialize","name":"@args","line":92},{"containerName":"_initialize","kind":13,"name":"$width","line":93},{"line":93,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":12,"name":"width","line":93},{"name":"$width","containerName":"_initialize","kind":13,"line":93}]},{"containerName":"_initialize","kind":12,"name":"SUPER","line":91},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_aln","name":"$self","line":108},{"line":109,"containerName":"next_aln","localvar":"my","kind":13,"name":"$seq","definition":"my"},{"name":"$alphabet","kind":13,"localvar":"my","containerName":"next_aln","line":110,"definition":"my"},{"name":"$aln","containerName":"next_aln","localvar":"my","kind":13,"line":113,"definition":"my"},{"line":113,"name":"new","containerName":"next_aln","kind":12},{"line":115,"name":"$entry","kind":13,"localvar":"my","containerName":"next_aln","definition":"my"},{"line":115,"name":"$self","containerName":"next_aln","kind":13},{"line":115,"name":"_readline","containerName":"next_aln","kind":12},{"name":"$entry","containerName":"next_aln","kind":13,"line":116},{"name":"$entry","containerName":"next_aln","kind":13,"line":117},{"name":"$entry","kind":13,"containerName":"next_aln","line":118},{"name":"$self","containerName":"next_aln","kind":13,"line":118},{"name":"_readline","containerName":"next_aln","kind":12,"line":118},{"name":"$entry","containerName":"next_aln","kind":13,"line":119},{"line":121,"name":"$entry","containerName":"next_aln","kind":13},{"definition":"my","name":"$top","kind":13,"localvar":"my","containerName":"next_aln","line":123},{"line":123,"containerName":"next_aln","kind":13,"name":"$sequence"},{"line":123,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":124,"kind":13,"containerName":"next_aln","name":"$sequence"},{"line":124,"name":"$sequence","containerName":"next_aln","kind":13},{"definition":"my","name":"@metas","kind":13,"localvar":"my","containerName":"next_aln","line":126},{"kind":13,"containerName":"next_aln","name":"$sequence","line":127},{"line":127,"kind":13,"containerName":"next_aln","name":"@metas"},{"line":127,"name":"$sequence","containerName":"next_aln","kind":13},{"line":129,"name":"$id","localvar":"my","containerName":"next_aln","kind":13,"definition":"my"},{"line":129,"name":"$start","kind":13,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$end","line":129},{"kind":13,"containerName":"next_aln","name":"$top","line":130},{"containerName":"next_aln","kind":13,"name":"$id","line":131},{"containerName":"next_aln","kind":13,"name":"$start","line":132},{"name":"$end","kind":13,"containerName":"next_aln","line":133},{"containerName":"next_aln","kind":13,"name":"$top","line":135},{"containerName":"next_aln","kind":13,"name":"$id","line":136},{"name":"$start","containerName":"next_aln","kind":13,"line":137},{"name":"$end","containerName":"next_aln","kind":13,"line":138},{"line":138,"kind":13,"containerName":"next_aln","name":"$sequence"},{"kind":13,"containerName":"next_aln","name":"$sequence","line":141},{"line":141,"name":"$sequence","containerName":"next_aln","kind":13},{"line":143,"containerName":"next_aln","kind":13,"name":"$seq"},{"line":143,"kind":12,"containerName":"next_aln","name":"new"},{"name":"$sequence","kind":13,"containerName":"next_aln","line":143},{"containerName":"next_aln","kind":13,"name":"$id","line":144},{"name":"$start","containerName":"next_aln","kind":13,"line":145},{"name":"$end","containerName":"next_aln","kind":13,"line":147},{"line":149,"localvar":"my","containerName":"next_aln","kind":13,"name":"$meta","definition":"my"},{"name":"@metas","kind":13,"containerName":"next_aln","line":149},{"definition":"my","line":150,"name":"$name","containerName":"next_aln","localvar":"my","kind":13},{"line":150,"name":"$string","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$meta","line":150},{"kind":13,"containerName":"next_aln","name":"$string","line":151},{"kind":13,"containerName":"next_aln","name":"$seq","line":152},{"kind":12,"containerName":"next_aln","name":"named_meta","line":152},{"name":"$name","kind":13,"containerName":"next_aln","line":152},{"line":152,"containerName":"next_aln","kind":13,"name":"$string"},{"line":155,"containerName":"next_aln","kind":13,"name":"$aln"},{"line":155,"kind":12,"containerName":"next_aln","name":"add_seq"},{"line":155,"name":"$seq","kind":13,"containerName":"next_aln"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_aln","name":"$alnlen","line":158},{"name":"$aln","kind":13,"containerName":"next_aln","line":158},{"kind":12,"containerName":"next_aln","name":"length","line":158},{"definition":"my","line":159,"name":"$seq","containerName":"next_aln","localvar":"my","kind":13},{"line":159,"name":"$aln","kind":13,"containerName":"next_aln"},{"name":"each_seq","containerName":"next_aln","kind":12,"line":159},{"line":160,"name":"$seq","containerName":"next_aln","kind":13},{"line":160,"containerName":"next_aln","kind":12,"name":"length"},{"line":160,"name":"$alnlen","containerName":"next_aln","kind":13},{"line":161,"name":"$diff","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"line":161,"containerName":"next_aln","kind":13,"name":"$alnlen"},{"line":161,"containerName":"next_aln","kind":13,"name":"$seq"},{"name":"length","containerName":"next_aln","kind":12,"line":161},{"line":162,"name":"$seq","kind":13,"containerName":"next_aln"},{"name":"seq","kind":12,"containerName":"next_aln","line":162},{"name":"$seq","containerName":"next_aln","kind":13,"line":162},{"line":162,"name":"seq","kind":12,"containerName":"next_aln"},{"line":162,"name":"$diff","kind":13,"containerName":"next_aln"},{"line":166,"containerName":"next_aln","kind":13,"name":"$aln"},{"line":166,"name":"$aln","kind":13,"containerName":"next_aln"},{"kind":12,"containerName":"next_aln","name":"num_sequences","line":166}],"containerName":"main::","name":"next_aln","definition":"sub","detail":"($self)","line":107,"range":{"end":{"line":168,"character":9999},"start":{"line":107,"character":0}},"kind":12,"signature":{"label":"next_aln($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: metafasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::metafasta\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::metafasta - Metafasta MSA Sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects to and from\nmetafasta flat file databases.\n\nThe format of a metafasta file is\n\n  >test/1-25\n  ABCDEFHIJKLMNOPQRSTUVWXYZ\n  &charge\n  NBNAANCNJCNNNONNCNNUNNXNZ\n  &chemical\n  LBSAARCLJCLSMOIMCHHULRXRZ\n\nwhere the sequence block is followed by one or several meta blocks.\nEach meta block starts with the ampersand character '&' in the first\ncolumn and is immediately followed by the name of the meta data which\ncontinues until the new line. The meta data follows it. All\ncharacters, except new line, are important in meta data.\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO::metafasta>\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::metafasta;\nuse vars qw($WIDTH);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse Bio::Seq::Meta;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::AlignIO);\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE"}},{"name":"Bio","kind":12,"containerName":"SimpleAlign","line":113},{"line":143,"kind":12,"containerName":"Seq::Meta","name":"Bio"},{"signature":{"parameters":[{"label":"$self"},{"label":"@aln"}],"documentation":"1;\n# $Id: metafasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::metafasta\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::metafasta - Metafasta MSA Sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects to and from\nmetafasta flat file databases.\n\nThe format of a metafasta file is\n\n  >test/1-25\n  ABCDEFHIJKLMNOPQRSTUVWXYZ\n  &charge\n  NBNAANCNJCNNNONNCNNUNNXNZ\n  &chemical\n  LBSAARCLJCLSMOIMCHHULRXRZ\n\nwhere the sequence block is followed by one or several meta blocks.\nEach meta block starts with the ampersand character '&' in the first\ncolumn and is immediately followed by the name of the meta data which\ncontinues until the new line. The meta data follows it. All\ncharacters, except new line, are important in meta data.\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO::metafasta>\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::metafasta;\nuse vars qw($WIDTH);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse Bio::Seq::Meta;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::AlignIO);\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE\n\n\nsub next_aln {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n\n    my $aln =  Bio::SimpleAlign->new();\n\n    while(defined (my $entry = $self->_readline)) {\n        chomp($entry);\n        if ($entry =~ m/\\A\\s*\\Z/s) { # very first one\n            return unless $entry = $self->_readline;\n            chomp($entry);\n        }\n        $entry =~ s/^>//;\n\n        my ($top,$sequence) = split(/\\n/,$entry,2);\n        defined $sequence && $sequence =~ s/>//g;\n\n        my @metas;\n        ($sequence, @metas) = split /\\n&/, $sequence;\n\n        my ($id, $start, $end);\n        if ( $top =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n            $id = $1;\n            $start = $2;\n            $end = $3;\n        }\n        elsif ($top =~ /(\\S+)/) {\n            $id = $1;\n            $start = 1;\n            $end = length($sequence);\n        }\n\n        defined $sequence && $sequence =~ s/\\s//g; # Remove whitespace\n\n        $seq = Bio::Seq::Meta->new('-seq'=>$sequence,\n\t\t\t\t   '-id'=>$id,\n\t\t\t\t   '-start'=>$start,\n\t\t\t\t   '-end'=>$end\n\t\t\t\t  );\n\n        foreach my $meta (@metas) {\n            my ($name,$string) = split /\\n/, $meta;\n            $string =~ s/\\n//g;\t# Remove newlines, spaces are important\n            $seq->named_meta($name, $string);\n        }\n\n\t$aln->add_seq($seq);\n\t\n\t# alignment needs seqs all the same length, pad with gaps\n\tmy $alnlen = $aln->length;\n\tforeach my $seq ( $aln->each_seq ) {\n\t\tif ( $seq->length < $alnlen ) {\n\t\t\tmy ($diff) = ($alnlen - $seq->length);\n\t\t\t$seq->seq( $seq->seq() . \"-\" x $diff);\n\t\t}\n\t}\n    }\n    return $aln if $aln->num_sequences;\n\treturn;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in fasta format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","label":"write_aln($self,@aln)"},"kind":12,"range":{"end":{"character":9999,"line":210},"start":{"line":180,"character":0}},"line":180,"detail":"($self,@aln)","definition":"sub","containerName":"main::","name":"write_aln","children":[{"name":"$self","localvar":"my","containerName":"write_aln","kind":13,"line":181,"definition":"my"},{"line":181,"name":"@aln","containerName":"write_aln","kind":13},{"definition":"my","containerName":"write_aln","localvar":"my","kind":13,"name":"$width","line":182},{"name":"$self","containerName":"write_aln","kind":13,"line":182},{"line":182,"containerName":"write_aln","kind":12,"name":"width"},{"definition":"my","localvar":"my","containerName":"write_aln","kind":13,"name":"$aln","line":184},{"line":184,"kind":13,"containerName":"write_aln","name":"@aln"},{"name":"$aln","kind":13,"containerName":"write_aln","line":185},{"line":185,"containerName":"write_aln","kind":13,"name":"$aln"},{"containerName":"write_aln","kind":12,"name":"isa","line":185},{"line":186,"kind":13,"containerName":"write_aln","name":"$self"},{"kind":12,"containerName":"write_aln","name":"warn","line":186},{"definition":"my","line":189,"name":"$seq","localvar":"my","kind":13,"containerName":"write_aln"},{"containerName":"write_aln","kind":13,"name":"$aln","line":189},{"line":189,"containerName":"write_aln","kind":12,"name":"each_seq"},{"definition":"my","localvar":"my","containerName":"write_aln","kind":13,"name":"$name","line":190},{"line":190,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":190,"name":"displayname","containerName":"write_aln","kind":12},{"name":"$seq","kind":13,"containerName":"write_aln","line":190},{"line":190,"name":"get_nse","kind":12,"containerName":"write_aln"},{"definition":"my","line":192,"kind":13,"localvar":"my","containerName":"write_aln","name":"$str"},{"line":192,"kind":13,"containerName":"write_aln","name":"$seq"},{"line":192,"kind":12,"containerName":"write_aln","name":"seq"},{"kind":13,"containerName":"write_aln","name":"$str","line":193},{"kind":13,"containerName":"write_aln","name":"$str","line":194},{"line":196,"name":"$str","containerName":"write_aln","kind":13},{"line":198,"name":"$self","containerName":"write_aln","kind":13},{"containerName":"write_aln","kind":12,"name":"_print","line":198},{"containerName":"write_aln","kind":13,"name":"$name","line":198},{"line":198,"name":"$str","kind":13,"containerName":"write_aln"},{"line":199,"name":"$seq","kind":13,"containerName":"write_aln"},{"line":199,"containerName":"write_aln","kind":12,"name":"isa"},{"name":"$meta","localvar":"my","containerName":"write_aln","kind":13,"line":200,"definition":"my"},{"line":200,"name":"$seq","kind":13,"containerName":"write_aln"},{"line":200,"kind":12,"containerName":"write_aln","name":"meta_names"},{"definition":"my","line":201,"name":"$str","localvar":"my","kind":13,"containerName":"write_aln"},{"kind":13,"containerName":"write_aln","name":"$seq","line":201},{"name":"named_meta","kind":12,"containerName":"write_aln","line":201},{"name":"$meta","kind":13,"containerName":"write_aln","line":201},{"containerName":"write_aln","kind":13,"name":"$str","line":202},{"containerName":"write_aln","kind":13,"name":"$self","line":203},{"line":203,"name":"_print","containerName":"write_aln","kind":12},{"containerName":"write_aln","kind":13,"name":"$meta","line":203},{"line":203,"containerName":"write_aln","kind":13,"name":"$str"},{"name":"$self","kind":13,"containerName":"write_aln","line":208},{"name":"flush","containerName":"write_aln","kind":12,"line":208},{"name":"$self","kind":13,"containerName":"write_aln","line":208},{"line":208,"name":"_flush_on_write","kind":12,"containerName":"write_aln"},{"line":208,"name":"$self","containerName":"write_aln","kind":13},{"name":"_fh","containerName":"write_aln","kind":12,"line":208}]},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: metafasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::metafasta\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::metafasta - Metafasta MSA Sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects to and from\nmetafasta flat file databases.\n\nThe format of a metafasta file is\n\n  >test/1-25\n  ABCDEFHIJKLMNOPQRSTUVWXYZ\n  &charge\n  NBNAANCNJCNNNONNCNNUNNXNZ\n  &chemical\n  LBSAARCLJCLSMOIMCHHULRXRZ\n\nwhere the sequence block is followed by one or several meta blocks.\nEach meta block starts with the ampersand character '&' in the first\ncolumn and is immediately followed by the name of the meta data which\ncontinues until the new line. The meta data follows it. All\ncharacters, except new line, are important in meta data.\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO::metafasta>\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::metafasta;\nuse vars qw($WIDTH);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse Bio::Seq::Meta;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::AlignIO);\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE\n\n\nsub next_aln {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n\n    my $aln =  Bio::SimpleAlign->new();\n\n    while(defined (my $entry = $self->_readline)) {\n        chomp($entry);\n        if ($entry =~ m/\\A\\s*\\Z/s) { # very first one\n            return unless $entry = $self->_readline;\n            chomp($entry);\n        }\n        $entry =~ s/^>//;\n\n        my ($top,$sequence) = split(/\\n/,$entry,2);\n        defined $sequence && $sequence =~ s/>//g;\n\n        my @metas;\n        ($sequence, @metas) = split /\\n&/, $sequence;\n\n        my ($id, $start, $end);\n        if ( $top =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n            $id = $1;\n            $start = $2;\n            $end = $3;\n        }\n        elsif ($top =~ /(\\S+)/) {\n            $id = $1;\n            $start = 1;\n            $end = length($sequence);\n        }\n\n        defined $sequence && $sequence =~ s/\\s//g; # Remove whitespace\n\n        $seq = Bio::Seq::Meta->new('-seq'=>$sequence,\n\t\t\t\t   '-id'=>$id,\n\t\t\t\t   '-start'=>$start,\n\t\t\t\t   '-end'=>$end\n\t\t\t\t  );\n\n        foreach my $meta (@metas) {\n            my ($name,$string) = split /\\n/, $meta;\n            $string =~ s/\\n//g;\t# Remove newlines, spaces are important\n            $seq->named_meta($name, $string);\n        }\n\n\t$aln->add_seq($seq);\n\t\n\t# alignment needs seqs all the same length, pad with gaps\n\tmy $alnlen = $aln->length;\n\tforeach my $seq ( $aln->each_seq ) {\n\t\tif ( $seq->length < $alnlen ) {\n\t\t\tmy ($diff) = ($alnlen - $seq->length);\n\t\t\t$seq->seq( $seq->seq() . \"-\" x $diff);\n\t\t}\n\t}\n    }\n    return $aln if $aln->num_sequences;\n\treturn;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in fasta format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $width = $self->width;\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\tforeach my $seq ( $aln->each_seq() ) {\n\t    my $name = $aln->displayname($seq->get_nse);\n\n\t    my $str  = $seq->seq();\n            if(length($str) > 0) {\n                $str =~ s/(.{1,$width})/$1\\n/g;\n            } else {\n                $str = \"\\n\";\n            }\n            $self->_print (\">\",$name,\"\\n\",$str) or return;\n            if ($seq->isa('Bio::Seq::MetaI')) {\n                foreach my $meta ($seq->meta_names) {\n                    my $str = $seq->named_meta($meta);\n                    $str =~ s/(.{1,$width})/$1\\n/g;\n                    $self->_print (\"&\",$meta,\"\\n\",$str);\n                }\n            }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n\n=head2 width\n\n Title   : width\n Usage   : $obj->width($newval)\n Function: Get/Set the line width for METAFASTA output\n Returns : value of width\n Args    : newvalue (optional)","label":"width($self,$value)"},"line":224,"range":{"start":{"line":224,"character":0},"end":{"character":9999,"line":230}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":225,"containerName":"width","localvar":"my","kind":13,"name":"$self"},{"name":"$value","kind":13,"containerName":"width","line":225},{"name":"$value","containerName":"width","kind":13,"line":226},{"kind":13,"containerName":"width","name":"$self","line":227},{"name":"$value","containerName":"width","kind":13,"line":227},{"line":229,"containerName":"width","kind":13,"name":"$self"},{"line":229,"name":"$WIDTH","containerName":"width","kind":13}],"name":"width","containerName":"main::"}],"version":5}