{"version":5,"vars":[{"line":87,"name":"base","containerName":"","kind":2},{"range":{"start":{"character":0,"line":102},"end":{"character":9999,"line":107}},"kind":12,"line":102,"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: maf.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::maf\n#\n# Copyright Allen Day\n#\n\n=head1 NAME\n\nBio::AlignIO::maf - Multiple Alignment Format sequence input stream\n\n=head1 SYNOPSIS\n\n Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n use Bio::AlignIO;\n\n my $alignio = Bio::AlignIO->new(-fh => \\*STDIN, -format => 'maf');\n\n while(my $aln = $alignio->next_aln()){\n   my $match_line = $aln->match_line;\n\n   print $aln, \"\\n\";\n\n   print $aln->length, \"\\n\";\n   print $aln->num_residues, \"\\n\";\n   print $aln->is_flush, \"\\n\";\n   print $aln->num_sequences, \"\\n\";\n\n   $aln->splice_by_seq_pos(1);\n\n   print $aln->consensus_string(60), \"\\n\";\n   print $aln->get_seq_by_pos(1)->seq, \"\\n\";\n   print $aln->match_line(), \"\\n\";\n\n   print \"\\n\";\n }\n\n=head1 DESCRIPTION\n\nThis class constructs Bio::SimpleAlign objects from an MAF-format\nmultiple alignment file.\n\nWriting in MAF format is currently unimplemented.\n\nSpec of MAF format is here:\n  http://genome.ucsc.edu/FAQ/FAQformat\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Allen Day\n\nEmail: allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::maf;\nuse strict;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'maf'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::maf> reader\n Returns : L<Bio::AlignIO> object\n Args    :"},"containerName":"main::","name":"_initialize","children":[{"line":103,"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","definition":"my"},{"name":"@args","containerName":"_initialize","kind":13,"line":103},{"kind":13,"containerName":"_initialize","name":"$self","line":104},{"name":"@args","containerName":"_initialize","kind":13,"line":104}],"detail":"($self,@args)","definition":"sub"},{"kind":12,"containerName":"_initialize","name":"SUPER","line":104},{"line":121,"range":{"end":{"character":9999,"line":183},"start":{"character":0,"line":121}},"kind":12,"definition":"sub","children":[{"definition":"my","line":122,"name":"$self","containerName":"next_aln","localvar":"my","kind":13},{"line":125,"containerName":"next_aln","kind":13,"name":"$self"},{"definition":"my","line":126,"localvar":"my","kind":13,"containerName":"next_aln","name":"$line"},{"name":"$self","containerName":"next_aln","kind":13,"line":126},{"line":126,"containerName":"next_aln","kind":12,"name":"_readline"},{"line":127,"containerName":"next_aln","kind":13,"name":"$self"},{"line":127,"kind":12,"containerName":"next_aln","name":"throw"},{"name":"$line","kind":13,"containerName":"next_aln","line":127},{"line":128,"name":"$line","kind":13,"containerName":"next_aln"},{"line":129,"name":"$self","containerName":"next_aln","kind":13},{"line":131,"containerName":"next_aln","kind":13,"name":"$self"},{"line":131,"name":"_pushback","kind":12,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$line","line":131},{"definition":"my","line":134,"localvar":"my","kind":13,"containerName":"next_aln","name":"$aln"},{"name":"new","containerName":"next_aln","kind":12,"line":134},{"definition":"my","name":"$aline","localvar":"my","containerName":"next_aln","kind":13,"line":136},{"containerName":"next_aln","kind":13,"name":"@slines","line":136},{"containerName":"next_aln","kind":13,"name":"$seen_aline","line":136},{"definition":"my","line":137,"name":"$line","kind":13,"localvar":"my","containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$self","line":137},{"line":137,"name":"_readline","kind":12,"containerName":"next_aln"},{"name":"$line","kind":13,"containerName":"next_aln","line":138},{"line":140,"name":"$seen_aline","containerName":"next_aln","kind":13},{"line":141,"containerName":"next_aln","kind":13,"name":"$self"},{"line":141,"name":"_pushback","kind":12,"containerName":"next_aln"},{"name":"$line","containerName":"next_aln","kind":13,"line":141},{"line":144,"kind":13,"containerName":"next_aln","name":"$aline"},{"kind":13,"containerName":"next_aln","name":"$line","line":144},{"name":"$seen_aline","kind":13,"containerName":"next_aln","line":145},{"line":146,"name":"$line","kind":13,"containerName":"next_aln"},{"line":147,"kind":13,"containerName":"next_aln","name":"@slines"},{"line":147,"kind":13,"containerName":"next_aln","name":"$line"},{"containerName":"next_aln","kind":13,"name":"$self","line":150},{"name":"debug","kind":12,"containerName":"next_aln","line":150},{"name":"$line","containerName":"next_aln","kind":13,"line":150},{"line":155,"containerName":"next_aln","kind":13,"name":"$aline"},{"definition":"my","name":"$kvs","localvar":"my","kind":13,"containerName":"next_aln","line":157},{"containerName":"next_aln","kind":13,"name":"$aline","line":157},{"definition":"my","name":"@kvs","localvar":"my","kind":13,"containerName":"next_aln","line":158},{"kind":13,"containerName":"next_aln","name":"$kvs","line":158},{"kind":13,"containerName":"next_aln","name":"$kvs","line":158},{"definition":"my","line":159,"localvar":"my","kind":13,"containerName":"next_aln","name":"%kv"},{"line":160,"name":"$kv","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"line":160,"name":"@kvs","kind":13,"containerName":"next_aln"},{"definition":"my","line":161,"containerName":"next_aln","localvar":"my","kind":13,"name":"$k"},{"containerName":"next_aln","kind":13,"name":"$v","line":161},{"name":"$kv","kind":13,"containerName":"next_aln","line":161},{"line":162,"name":"$kv","containerName":"next_aln","kind":13},{"line":162,"name":"$k","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$v","line":162},{"line":165,"containerName":"next_aln","kind":13,"name":"$aln"},{"line":165,"name":"score","containerName":"next_aln","kind":12},{"kind":13,"containerName":"next_aln","name":"$kv","line":165},{"containerName":"next_aln","localvar":"my","kind":13,"name":"$sline","line":167,"definition":"my"},{"line":167,"containerName":"next_aln","kind":13,"name":"@slines"},{"line":168,"localvar":"my","kind":13,"containerName":"next_aln","name":"$s","definition":"my"},{"line":168,"name":"$src","containerName":"next_aln","kind":13},{"name":"$start","containerName":"next_aln","kind":13,"line":168},{"containerName":"next_aln","kind":13,"name":"$size","line":168},{"name":"$strand","kind":13,"containerName":"next_aln","line":168},{"line":168,"name":"$srcsize","kind":13,"containerName":"next_aln"},{"line":168,"kind":13,"containerName":"next_aln","name":"$text"},{"line":169,"name":"$sline","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$start","line":171},{"line":171,"name":"$start","kind":13,"containerName":"next_aln"},{"line":172,"name":"$seq","containerName":"next_aln","localvar":"my","kind":13,"definition":"my"},{"line":172,"name":"new","kind":12,"containerName":"next_aln"},{"line":172,"name":"$text","containerName":"next_aln","kind":13},{"line":173,"name":"$src","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$start","line":174},{"line":175,"containerName":"next_aln","kind":13,"name":"$start"},{"name":"$size","containerName":"next_aln","kind":13,"line":175},{"name":"$strand","kind":13,"containerName":"next_aln","line":176},{"kind":13,"containerName":"next_aln","name":"$aln","line":178},{"line":178,"name":"add_seq","containerName":"next_aln","kind":12},{"name":"$seq","kind":13,"containerName":"next_aln","line":178},{"line":181,"name":"$aln","kind":13,"containerName":"next_aln"},{"name":"$aln","containerName":"next_aln","kind":13,"line":181},{"line":181,"containerName":"next_aln","kind":12,"name":"num_sequences"}],"name":"next_aln","containerName":"main::"},{"line":125,"name":"seen_header","kind":12},{"name":"seen_header","kind":12,"line":129},{"line":134,"name":"Bio","kind":12,"containerName":"SimpleAlign"},{"line":165,"name":"score","kind":12},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":172},{"line":185,"range":{"end":{"line":187,"character":9999},"start":{"character":0,"line":185}},"kind":12,"children":[{"kind":12,"containerName":"write_aln","name":"throw_not_implemented","line":187}],"name":"write_aln","containerName":"main::","definition":"sub"}]}