{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":74},{"line":78,"containerName":null,"kind":13,"name":"$LINELENGTH"},{"containerName":"","kind":2,"name":"strict","line":78},{"line":79,"containerName":null,"kind":13,"name":"$CLUSTALPRINTVERSION"},{"name":"base","kind":2,"containerName":"","line":80},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"definition":"my","line":101,"name":"$self","localvar":"my","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"@args","line":101},{"line":102,"name":"$self","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"@args","line":102},{"definition":"my","line":103,"localvar":"my","kind":13,"containerName":"_initialize","name":"$percentages"},{"name":"$ll","kind":13,"containerName":"_initialize","line":103},{"line":104,"containerName":"_initialize","kind":13,"name":"$self"},{"containerName":"_initialize","kind":12,"name":"_rearrange","line":104},{"line":104,"name":"@args","kind":13,"containerName":"_initialize"},{"line":105,"kind":13,"containerName":"_initialize","name":"$percentages"},{"line":105,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"percentages","kind":12,"containerName":"_initialize","line":105},{"line":105,"name":"$percentages","containerName":"_initialize","kind":13},{"line":106,"containerName":"_initialize","kind":13,"name":"$self"},{"line":106,"containerName":"_initialize","kind":12,"name":"line_length"},{"line":106,"containerName":"_initialize","kind":13,"name":"$ll"},{"containerName":"_initialize","kind":13,"name":"$LINELENGTH","line":106}],"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)","parameters":[{"label":"$self"},{"label":"@args"}]},"range":{"start":{"line":100,"character":0},"end":{"character":9999,"line":107}},"kind":12,"line":100},{"containerName":"_initialize","kind":12,"name":"SUPER","line":102},{"line":121,"kind":12,"range":{"end":{"line":219,"character":9999},"start":{"line":121,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details","label":"next_aln($self)"},"children":[{"name":"$self","localvar":"my","containerName":"next_aln","kind":13,"line":122,"definition":"my"},{"line":123,"localvar":"my","kind":13,"containerName":"next_aln","name":"$first_line","definition":"my"},{"name":"$first_line","kind":13,"containerName":"next_aln","line":125},{"line":125,"kind":13,"containerName":"next_aln","name":"$self"},{"kind":12,"containerName":"next_aln","name":"_readline","line":125},{"line":126,"containerName":"next_aln","kind":13,"name":"$first_line"},{"line":128,"name":"$self","kind":13,"containerName":"next_aln"},{"kind":12,"containerName":"next_aln","name":"_pushback","line":128},{"line":128,"containerName":"next_aln","kind":13,"name":"$first_line"},{"line":129,"name":"$first_line","kind":13,"containerName":"next_aln"},{"line":129,"containerName":"next_aln","kind":13,"name":"$self"},{"containerName":"next_aln","kind":12,"name":"_readline","line":129},{"containerName":"next_aln","kind":13,"name":"$first_line","line":130},{"line":132,"name":"$self","containerName":"next_aln","kind":13},{"line":132,"name":"throw","containerName":"next_aln","kind":12},{"line":136,"kind":13,"localvar":"my","containerName":"next_aln","name":"%alignments","definition":"my"},{"line":137,"localvar":"my","kind":13,"containerName":"next_aln","name":"$aln","definition":"my"},{"name":"new","kind":12,"containerName":"next_aln","line":137},{"name":"$self","containerName":"next_aln","kind":13,"line":139},{"name":"verbose","kind":12,"containerName":"next_aln","line":140},{"line":141,"name":"$order","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"line":142,"name":"%order","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"containerName":"next_aln","kind":13,"name":"$self","line":143},{"line":144,"localvar":"my","containerName":"next_aln","kind":13,"name":"$first_block","definition":"my"},{"line":144,"name":"$seen_block","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$self","line":145},{"line":145,"name":"_readline","containerName":"next_aln","kind":12},{"line":146,"name":"$first_block","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$seen_block","line":148},{"kind":13,"containerName":"next_aln","name":"$first_block","line":151},{"containerName":"next_aln","kind":13,"name":"$self","line":155},{"line":155,"name":"_pushback","containerName":"next_aln","kind":12},{"definition":"my","line":159,"localvar":"my","kind":13,"containerName":"next_aln","name":"$seqname"},{"name":"$aln_line","containerName":"next_aln","kind":13,"line":159},{"line":163,"name":"$seqname","containerName":"next_aln","kind":13},{"name":"$aln_line","containerName":"next_aln","kind":13,"line":163},{"kind":13,"containerName":"next_aln","name":"$seqname","line":168},{"kind":13,"containerName":"next_aln","name":"$aln_line","line":168},{"kind":13,"containerName":"next_aln","name":"$seqname","line":169},{"line":170,"containerName":"next_aln","kind":13,"name":"$self"},{"kind":13,"containerName":"next_aln","name":"$self","line":175},{"name":"$seen_block","kind":13,"containerName":"next_aln","line":179},{"line":180,"name":"$order","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$seqname","line":180},{"name":"$self","kind":13,"containerName":"next_aln","line":181},{"line":181,"containerName":"next_aln","kind":12,"name":"warn"},{"name":"$order","containerName":"next_aln","kind":13,"line":185},{"name":"$seqname","kind":13,"containerName":"next_aln","line":185},{"line":185,"containerName":"next_aln","kind":13,"name":"$order"},{"kind":13,"containerName":"next_aln","name":"$alignments","line":189},{"kind":13,"containerName":"next_aln","name":"$seqname","line":189},{"name":"$aln_line","containerName":"next_aln","kind":13,"line":189},{"definition":"my","line":192,"containerName":"next_aln","localvar":"my","kind":13,"name":"$sname"},{"line":192,"name":"$start","kind":13,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$end","line":192},{"definition":"my","name":"$name","containerName":"next_aln","localvar":"my","kind":13,"line":193},{"line":193,"containerName":"next_aln","kind":13,"name":"$order"},{"kind":13,"containerName":"next_aln","name":"$a","line":193},{"line":193,"kind":13,"containerName":"next_aln","name":"$order"},{"line":193,"name":"$b","kind":13,"containerName":"next_aln"},{"name":"%alignments","containerName":"next_aln","kind":13,"line":193},{"kind":13,"containerName":"next_aln","name":"$name","line":194},{"name":"$sname","kind":13,"containerName":"next_aln","line":195},{"line":195,"containerName":"next_aln","kind":13,"name":"$start"},{"line":195,"kind":13,"containerName":"next_aln","name":"$end"},{"containerName":"next_aln","kind":13,"name":"$sname","line":198},{"containerName":"next_aln","kind":13,"name":"$start","line":198},{"containerName":"next_aln","kind":13,"name":"$name","line":198},{"definition":"my","line":199,"name":"$str","localvar":"my","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"$alignments","line":199},{"line":199,"name":"$name","kind":13,"containerName":"next_aln"},{"line":200,"kind":13,"containerName":"next_aln","name":"$str"},{"line":201,"name":"$end","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$str","line":201},{"line":203,"name":"$seq","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"line":203,"kind":12,"containerName":"next_aln","name":"new"},{"name":"$alignments","containerName":"next_aln","kind":13,"line":204},{"line":204,"name":"$name","kind":13,"containerName":"next_aln"},{"name":"$sname","containerName":"next_aln","kind":13,"line":205},{"line":206,"name":"$start","containerName":"next_aln","kind":13},{"line":208,"name":"$end","containerName":"next_aln","kind":13},{"line":209,"name":"$aln","containerName":"next_aln","kind":13},{"line":209,"name":"add_seq","kind":12,"containerName":"next_aln"},{"name":"$seq","kind":13,"containerName":"next_aln","line":209},{"containerName":"next_aln","kind":13,"name":"$aln","line":217},{"containerName":"next_aln","kind":13,"name":"$aln","line":217},{"name":"num_sequences","containerName":"next_aln","kind":12,"line":217}],"name":"next_aln","containerName":"main::","definition":"sub","detail":"($self)"},{"line":137,"name":"Bio","containerName":"SimpleAlign","kind":12},{"kind":12,"name":"_lastline","line":143},{"line":170,"kind":12,"name":"_lastline"},{"line":175,"name":"_lastline","kind":12},{"line":203,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"signature":{"documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /CLUSTAL/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with a CLUSTAL header\"\n        );\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'clustalw',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block) = (0,0);\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n        # break the loop if we come to the end of the current alignment\n        # and push back the CLUSTAL header\n        if (/CLUSTAL/) {\n            $self->_pushback($_);\n            last;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname} = $order++;\n            }\n        }\n\n        $alignments{$seqname} .= $aln_line;\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n\n    # not sure if this should be a default option - or we can pass in\n    # an option to do this in the future? --jason stajich\n    # $aln->map_chars('\\.','-');\n    \n    # no sequences added, so just return\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the clustalw-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"},"kind":12,"range":{"end":{"line":316,"character":9999},"start":{"line":231,"character":0}},"line":231,"detail":"($self,@aln)","definition":"sub","containerName":"main::","name":"write_aln","children":[{"definition":"my","name":"$self","containerName":"write_aln","localvar":"my","kind":13,"line":232},{"name":"@aln","containerName":"write_aln","kind":13,"line":232},{"definition":"my","kind":13,"localvar":"my","containerName":"write_aln","name":"$count","line":233},{"name":"$length","containerName":"write_aln","kind":13,"line":233},{"line":233,"kind":13,"containerName":"write_aln","name":"$seq"},{"line":233,"kind":13,"containerName":"write_aln","name":"@seq"},{"line":233,"kind":13,"containerName":"write_aln","name":"$tempcount"},{"kind":13,"containerName":"write_aln","name":"$line_len","line":233},{"name":"$line_len","kind":13,"containerName":"write_aln","line":234},{"containerName":"write_aln","kind":13,"name":"$self","line":234},{"line":234,"containerName":"write_aln","kind":12,"name":"line_length"},{"line":234,"name":"$LINELENGTH","kind":13,"containerName":"write_aln"},{"definition":"my","line":235,"containerName":"write_aln","localvar":"my","kind":13,"name":"$aln"},{"line":235,"name":"@aln","kind":13,"containerName":"write_aln"},{"line":236,"name":"$aln","containerName":"write_aln","kind":13},{"line":236,"containerName":"write_aln","kind":13,"name":"$aln"},{"kind":12,"containerName":"write_aln","name":"isa","line":236},{"line":237,"name":"$self","kind":13,"containerName":"write_aln"},{"line":237,"name":"warn","containerName":"write_aln","kind":12},{"line":242,"containerName":"write_aln","localvar":"my","kind":13,"name":"$matchline","definition":"my"},{"containerName":"write_aln","kind":13,"name":"$aln","line":242},{"kind":12,"containerName":"write_aln","name":"match_line","line":242},{"kind":13,"containerName":"write_aln","name":"$self","line":243},{"kind":12,"containerName":"write_aln","name":"force_displayname_flat","line":243},{"name":"$aln","containerName":"write_aln","kind":13,"line":244},{"name":"set_displayname_flat","kind":12,"containerName":"write_aln","line":244},{"line":246,"kind":13,"containerName":"write_aln","name":"$self"},{"line":246,"kind":12,"containerName":"write_aln","name":"_print"},{"containerName":"write_aln","kind":13,"name":"$CLUSTALPRINTVERSION","line":248},{"line":250,"kind":13,"containerName":"write_aln","name":"$length"},{"line":250,"containerName":"write_aln","kind":13,"name":"$aln"},{"name":"length","kind":12,"containerName":"write_aln","line":250},{"name":"$count","containerName":"write_aln","kind":13,"line":251},{"line":251,"containerName":"write_aln","kind":13,"name":"$tempcount"},{"line":252,"kind":13,"containerName":"write_aln","name":"@seq"},{"line":252,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"each_seq","containerName":"write_aln","kind":12,"line":252},{"line":253,"name":"$max","kind":13,"localvar":"my","containerName":"write_aln","definition":"my"},{"line":254,"kind":13,"containerName":"write_aln","name":"$seq"},{"line":254,"name":"@seq","kind":13,"containerName":"write_aln"},{"containerName":"write_aln","kind":13,"name":"$max","line":255},{"line":255,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":255,"containerName":"write_aln","kind":12,"name":"displayname"},{"line":255,"kind":13,"containerName":"write_aln","name":"$seq"},{"line":255,"name":"get_nse","containerName":"write_aln","kind":12},{"containerName":"write_aln","kind":13,"name":"$aln","line":256},{"name":"displayname","kind":12,"containerName":"write_aln","line":256},{"containerName":"write_aln","kind":13,"name":"$seq","line":256},{"line":256,"containerName":"write_aln","kind":12,"name":"get_nse"},{"line":256,"name":"$max","containerName":"write_aln","kind":13},{"kind":13,"containerName":"write_aln","name":"$count","line":259},{"kind":13,"containerName":"write_aln","name":"$length","line":259},{"line":260,"localvar":"my","kind":13,"containerName":"write_aln","name":"$linesubstr","definition":"my"},{"line":260,"containerName":"write_aln","kind":13,"name":"$first"},{"line":261,"name":"$seq","containerName":"write_aln","kind":13},{"containerName":"write_aln","kind":13,"name":"@seq","line":261},{"kind":13,"localvar":"my","containerName":"write_aln","name":"$substring","line":267,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"write_aln","name":"$seqchars","line":268},{"name":"$seq","kind":13,"containerName":"write_aln","line":268},{"line":268,"kind":12,"containerName":"write_aln","name":"seq"},{"kind":13,"containerName":"write_aln","name":"$seqchars","line":270},{"line":270,"name":"$count","containerName":"write_aln","kind":13},{"name":"$line_len","kind":13,"containerName":"write_aln","line":270},{"line":271,"kind":13,"containerName":"write_aln","name":"$substring"},{"kind":13,"containerName":"write_aln","name":"$seqchars","line":271},{"kind":13,"containerName":"write_aln","name":"$count","line":271},{"name":"$line_len","kind":13,"containerName":"write_aln","line":271},{"line":272,"name":"$first","containerName":"write_aln","kind":13},{"line":273,"containerName":"write_aln","kind":13,"name":"$linesubstr"},{"line":274,"name":"$matchline","kind":13,"containerName":"write_aln"},{"containerName":"write_aln","kind":13,"name":"$count","line":274},{"line":274,"name":"$line_len","kind":13,"containerName":"write_aln"},{"name":"$first","kind":13,"containerName":"write_aln","line":275},{"containerName":"write_aln","kind":13,"name":"$seqchars","line":279},{"containerName":"write_aln","kind":13,"name":"$count","line":279},{"name":"$substring","kind":13,"containerName":"write_aln","line":280},{"name":"$seqchars","kind":13,"containerName":"write_aln","line":280},{"containerName":"write_aln","kind":13,"name":"$count","line":280},{"line":281,"containerName":"write_aln","kind":13,"name":"$first"},{"kind":13,"containerName":"write_aln","name":"$linesubstr","line":282},{"containerName":"write_aln","kind":13,"name":"$matchline","line":282},{"name":"$count","kind":13,"containerName":"write_aln","line":282},{"name":"$first","kind":13,"containerName":"write_aln","line":283},{"kind":13,"containerName":"write_aln","name":"$substring","line":287},{"name":"$self","containerName":"write_aln","kind":13,"line":289},{"kind":12,"containerName":"write_aln","name":"_print","line":289},{"line":291,"kind":13,"containerName":"write_aln","name":"$max"},{"kind":13,"containerName":"write_aln","name":"$aln","line":292},{"containerName":"write_aln","kind":12,"name":"displayname","line":292},{"kind":13,"containerName":"write_aln","name":"$seq","line":292},{"line":292,"name":"get_nse","containerName":"write_aln","kind":12},{"name":"$substring","kind":13,"containerName":"write_aln","line":293},{"line":297,"name":"$percentages","localvar":"my","containerName":"write_aln","kind":13,"definition":"my"},{"line":298,"kind":13,"containerName":"write_aln","name":"$self"},{"kind":12,"containerName":"write_aln","name":"percentages","line":298},{"containerName":"write_aln","localvar":"my","kind":13,"name":"$strcpy","line":299,"definition":"my"},{"name":"$linesubstr","kind":13,"containerName":"write_aln","line":299},{"line":300,"name":"$count","kind":13,"localvar":"my","containerName":"write_aln","definition":"my"},{"name":"$strcpy","containerName":"write_aln","kind":13,"line":300},{"name":"$percentages","kind":13,"containerName":"write_aln","line":301},{"name":"$count","containerName":"write_aln","kind":13,"line":302},{"kind":13,"containerName":"write_aln","name":"$linesubstr","line":302},{"containerName":"write_aln","kind":13,"name":"$self","line":304},{"name":"_print","containerName":"write_aln","kind":12,"line":304},{"kind":13,"containerName":"write_aln","name":"$max","line":306},{"containerName":"write_aln","kind":13,"name":"$linesubstr","line":307},{"line":308,"containerName":"write_aln","kind":13,"name":"$percentages"},{"containerName":"write_aln","kind":13,"name":"$self","line":310},{"kind":12,"containerName":"write_aln","name":"_print","line":310},{"kind":13,"containerName":"write_aln","name":"$count","line":311},{"kind":13,"containerName":"write_aln","name":"$line_len","line":311},{"name":"$self","containerName":"write_aln","kind":13,"line":314},{"line":314,"name":"flush","containerName":"write_aln","kind":12},{"name":"$self","containerName":"write_aln","kind":13,"line":314},{"line":314,"containerName":"write_aln","kind":12,"name":"_flush_on_write"},{"name":"$self","kind":13,"containerName":"write_aln","line":314},{"line":314,"name":"_fh","kind":12,"containerName":"write_aln"}]},{"kind":12,"name":"SWITCH","line":269},{"name":"SWITCH","kind":12,"line":277},{"line":285,"kind":12,"name":"SWITCH"},{"signature":{"label":"percentages($self,$value)","documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /CLUSTAL/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with a CLUSTAL header\"\n        );\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'clustalw',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block) = (0,0);\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n        # break the loop if we come to the end of the current alignment\n        # and push back the CLUSTAL header\n        if (/CLUSTAL/) {\n            $self->_pushback($_);\n            last;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname} = $order++;\n            }\n        }\n\n        $alignments{$seqname} .= $aln_line;\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n\n    # not sure if this should be a default option - or we can pass in\n    # an option to do this in the future? --jason stajich\n    # $aln->map_chars('\\.','-');\n    \n    # no sequences added, so just return\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the clustalw-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\n\nsub write_aln {\n    my ( $self, @aln ) = @_;\n    my ( $count, $length, $seq, @seq, $tempcount, $line_len );\n    $line_len = $self->line_length || $LINELENGTH;\n    foreach my $aln (@aln) {\n        if ( !$aln || !$aln->isa('Bio::Align::AlignI') ) {\n            $self->warn(\n\"Must provide a Bio::Align::AlignI object when calling write_aln\"\n            );\n            next;\n        }\n        my $matchline = $aln->match_line;\n        if ( $self->force_displayname_flat ) {\n            $aln->set_displayname_flat(1);\n        }\n        $self->_print(\n            sprintf( \"CLUSTAL W(%s) multiple sequence alignment\\n\\n\\n\",\n                $CLUSTALPRINTVERSION )\n        ) or return;\n        $length = $aln->length();\n        $count  = $tempcount = 0;\n        @seq    = $aln->each_seq();\n        my $max = 22;\n        foreach $seq (@seq) {\n            $max = length( $aln->displayname( $seq->get_nse() ) )\n              if ( length( $aln->displayname( $seq->get_nse() ) ) > $max );\n        }\n\n        while ( $count < $length ) {\n            my ( $linesubstr, $first ) = ( '', 1 );\n            foreach $seq (@seq) {\n\n              #\n              #  Following lines are to suppress warnings\n              #  if some sequences in the alignment are much longer than others.\n\n                my ($substring);\n                my $seqchars = $seq->seq();\n              SWITCH: {\n                    if ( length($seqchars) >= ( $count + $line_len ) ) {\n                        $substring = substr( $seqchars, $count, $line_len );\n                        if ($first) {\n                            $linesubstr =\n                              substr( $matchline, $count, $line_len );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    elsif ( length($seqchars) >= $count ) {\n                        $substring = substr( $seqchars, $count );\n                        if ($first) {\n                            $linesubstr = substr( $matchline, $count );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    $substring = \"\";\n                }\n                $self->_print(\n                    sprintf(\n                        \"%-\" . $max . \"s %s\\n\",\n                        $aln->displayname( $seq->get_nse() ), $substring\n                    )\n                ) or return;\n            }\n\n            my $percentages = '';\n            if ( $self->percentages ) {\n                my ($strcpy) = ($linesubstr);\n                my $count = ( $strcpy =~ tr/\\*// );\n                $percentages =\n                  sprintf( \"\\t%d%%\", 100 * ( $count / length($linesubstr) ) );\n            }\n            $self->_print(\n                sprintf(\n                    \"%-\" . $max . \"s %s%s\\n\",\n                    '', $linesubstr, $percentages\n                )\n            );\n            $self->_print( sprintf(\"\\n\\n\") ) or return;\n            $count += $line_len;\n        }\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 percentages\n\n Title   : percentages\n Usage   : $obj->percentages($newval)\n Function: Set the percentages flag - whether or not to show percentages in\n           each output line\n Returns : value of percentages\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"line":330,"character":0},"end":{"character":9999,"line":336}},"kind":12,"line":330,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"percentages","children":[{"definition":"my","line":331,"kind":13,"localvar":"my","containerName":"percentages","name":"$self"},{"kind":13,"containerName":"percentages","name":"$value","line":331},{"line":332,"kind":13,"containerName":"percentages","name":"$value"},{"kind":13,"containerName":"percentages","name":"$self","line":333},{"name":"$value","containerName":"percentages","kind":13,"line":333},{"line":335,"containerName":"percentages","kind":13,"name":"$self"}]},{"name":"line_length","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"line_length","name":"$self","line":350},{"line":350,"containerName":"line_length","kind":13,"name":"$value"},{"name":"$value","containerName":"line_length","kind":13,"line":351},{"name":"$self","kind":13,"containerName":"line_length","line":352},{"line":352,"containerName":"line_length","kind":13,"name":"$value"},{"line":354,"name":"$self","kind":13,"containerName":"line_length"}],"detail":"($self,$value)","definition":"sub","range":{"end":{"line":355,"character":9999},"start":{"line":349,"character":0}},"kind":12,"line":349,"signature":{"label":"line_length($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /CLUSTAL/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with a CLUSTAL header\"\n        );\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'clustalw',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block) = (0,0);\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n        # break the loop if we come to the end of the current alignment\n        # and push back the CLUSTAL header\n        if (/CLUSTAL/) {\n            $self->_pushback($_);\n            last;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname} = $order++;\n            }\n        }\n\n        $alignments{$seqname} .= $aln_line;\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n\n    # not sure if this should be a default option - or we can pass in\n    # an option to do this in the future? --jason stajich\n    # $aln->map_chars('\\.','-');\n    \n    # no sequences added, so just return\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the clustalw-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\n\nsub write_aln {\n    my ( $self, @aln ) = @_;\n    my ( $count, $length, $seq, @seq, $tempcount, $line_len );\n    $line_len = $self->line_length || $LINELENGTH;\n    foreach my $aln (@aln) {\n        if ( !$aln || !$aln->isa('Bio::Align::AlignI') ) {\n            $self->warn(\n\"Must provide a Bio::Align::AlignI object when calling write_aln\"\n            );\n            next;\n        }\n        my $matchline = $aln->match_line;\n        if ( $self->force_displayname_flat ) {\n            $aln->set_displayname_flat(1);\n        }\n        $self->_print(\n            sprintf( \"CLUSTAL W(%s) multiple sequence alignment\\n\\n\\n\",\n                $CLUSTALPRINTVERSION )\n        ) or return;\n        $length = $aln->length();\n        $count  = $tempcount = 0;\n        @seq    = $aln->each_seq();\n        my $max = 22;\n        foreach $seq (@seq) {\n            $max = length( $aln->displayname( $seq->get_nse() ) )\n              if ( length( $aln->displayname( $seq->get_nse() ) ) > $max );\n        }\n\n        while ( $count < $length ) {\n            my ( $linesubstr, $first ) = ( '', 1 );\n            foreach $seq (@seq) {\n\n              #\n              #  Following lines are to suppress warnings\n              #  if some sequences in the alignment are much longer than others.\n\n                my ($substring);\n                my $seqchars = $seq->seq();\n              SWITCH: {\n                    if ( length($seqchars) >= ( $count + $line_len ) ) {\n                        $substring = substr( $seqchars, $count, $line_len );\n                        if ($first) {\n                            $linesubstr =\n                              substr( $matchline, $count, $line_len );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    elsif ( length($seqchars) >= $count ) {\n                        $substring = substr( $seqchars, $count );\n                        if ($first) {\n                            $linesubstr = substr( $matchline, $count );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    $substring = \"\";\n                }\n                $self->_print(\n                    sprintf(\n                        \"%-\" . $max . \"s %s\\n\",\n                        $aln->displayname( $seq->get_nse() ), $substring\n                    )\n                ) or return;\n            }\n\n            my $percentages = '';\n            if ( $self->percentages ) {\n                my ($strcpy) = ($linesubstr);\n                my $count = ( $strcpy =~ tr/\\*// );\n                $percentages =\n                  sprintf( \"\\t%d%%\", 100 * ( $count / length($linesubstr) ) );\n            }\n            $self->_print(\n                sprintf(\n                    \"%-\" . $max . \"s %s%s\\n\",\n                    '', $linesubstr, $percentages\n                )\n            );\n            $self->_print( sprintf(\"\\n\\n\") ) or return;\n            $count += $line_len;\n        }\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 percentages\n\n Title   : percentages\n Usage   : $obj->percentages($newval)\n Function: Set the percentages flag - whether or not to show percentages in\n           each output line\n Returns : value of percentages\n Args    : newvalue (optional)\n\n\n\nsub percentages {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_percentages'} = $value;\n    }\n    return $self->{'_percentages'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function: Set the alignment output line length\n Returns : value of line_length\n Args    : newvalue (optional)"}}]}