{"vars":[{"line":89,"name":"vars","containerName":"","kind":2},{"line":95,"containerName":null,"kind":13,"name":"%DistanceMethods"},{"line":95,"kind":2,"containerName":"strict::Bio::Align::PairwiseStatistics::Bio::Matrix","name":"PhylipDist"},{"name":"$Precision","containerName":null,"kind":13,"line":97},{"line":98,"name":"$DefaultGapPenalty","containerName":null,"kind":13},{"name":"base","containerName":"","kind":2,"line":100},{"line":113,"range":{"end":{"character":9999,"line":120},"start":{"line":113,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]},"children":[{"name":"$class","containerName":"new","localvar":"my","kind":13,"line":114,"definition":"my"},{"line":114,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$self","line":116},{"name":"$class","kind":13,"containerName":"new","line":116},{"line":116,"containerName":"new","kind":13,"name":"@args"},{"line":117,"kind":13,"containerName":"new","name":"$self"},{"line":117,"containerName":"new","kind":12,"name":"pairwise_stats"},{"line":117,"containerName":"new","kind":12,"name":"new"},{"containerName":"new","kind":13,"name":"$self","line":119}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"kind":12,"containerName":"new","name":"SUPER","line":116},{"line":117,"name":"Bio","containerName":"Align::PairwiseStatistics","kind":12},{"line":136,"kind":12,"range":{"end":{"character":9999,"line":152},"start":{"character":0,"line":136}},"signature":{"documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"distance($self,@args)"},"children":[{"line":137,"name":"$self","localvar":"my","kind":13,"containerName":"distance","definition":"my"},{"line":137,"kind":13,"containerName":"distance","name":"@args"},{"kind":13,"localvar":"my","containerName":"distance","name":"$aln","line":138,"definition":"my"},{"line":138,"name":"$method","containerName":"distance","kind":13},{"line":138,"name":"$self","kind":13,"containerName":"distance"},{"line":138,"name":"_rearrange","kind":12,"containerName":"distance"},{"line":138,"name":"@args","kind":13,"containerName":"distance"},{"line":139,"name":"$aln","containerName":"distance","kind":13},{"line":139,"name":"$aln","containerName":"distance","kind":13},{"line":139,"name":"$aln","kind":13,"containerName":"distance"},{"line":139,"name":"isa","kind":12,"containerName":"distance"},{"kind":13,"containerName":"distance","name":"$self","line":140},{"line":140,"kind":12,"containerName":"distance","name":"throw"},{"name":"$method","kind":13,"containerName":"distance","line":142},{"line":143,"name":"$m","containerName":"distance","localvar":"my","kind":13,"definition":"my"},{"line":143,"kind":13,"containerName":"distance","name":"%DistanceMethods"},{"line":144,"name":"$m","kind":13,"containerName":"distance"},{"line":144,"name":"$method","kind":13,"containerName":"distance"},{"definition":"my","line":145,"name":"$mtd","localvar":"my","containerName":"distance","kind":13},{"line":146,"name":"$self","containerName":"distance","kind":13},{"line":146,"name":"$mtd","kind":13,"containerName":"distance"},{"name":"$aln","kind":13,"containerName":"distance","line":146},{"line":149,"name":"$self","containerName":"distance","kind":13},{"name":"warn","kind":12,"containerName":"distance","line":149},{"name":"$self","kind":13,"containerName":"distance","line":150},{"kind":12,"containerName":"distance","name":"available_distance_methods","line":150}],"containerName":"main::","name":"distance","definition":"sub","detail":"($self,@args)"},{"name":"available_distance_methods","containerName":"main::","children":[{"line":166,"name":"$self","localvar":"my","kind":13,"containerName":"available_distance_methods","definition":"my"},{"line":166,"name":"@args","containerName":"available_distance_methods","kind":13},{"line":167,"containerName":"available_distance_methods","kind":13,"name":"%DistanceMethods"}],"detail":"($self,@args)","definition":"sub","range":{"start":{"character":0,"line":165},"end":{"line":168,"character":9999}},"kind":12,"line":165,"signature":{"documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'Kimura';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"available_distance_methods($self,@args)"}},{"detail":"($self,$aln)","definition":"sub","name":"D_Kimura","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"D_Kimura","kind":13,"line":192,"definition":"my"},{"line":192,"containerName":"D_Kimura","kind":13,"name":"$aln"},{"kind":13,"containerName":"D_Kimura","name":"$self","line":193},{"kind":12,"containerName":"D_Kimura","name":"_check_arg","line":193},{"name":"$aln","containerName":"D_Kimura","kind":13,"line":193},{"name":"@seqs","localvar":"my","kind":13,"containerName":"D_Kimura","line":195,"definition":"my"},{"line":195,"containerName":"D_Kimura","kind":13,"name":"@names"},{"containerName":"D_Kimura","kind":13,"name":"@values","line":195},{"kind":13,"containerName":"D_Kimura","name":"%dist","line":195},{"line":196,"name":"$seqct","containerName":"D_Kimura","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":197,"localvar":"my","containerName":"D_Kimura","kind":13,"name":"$seq"},{"containerName":"D_Kimura","kind":13,"name":"$aln","line":197},{"containerName":"D_Kimura","kind":12,"name":"each_seq","line":197},{"name":"@names","kind":13,"containerName":"D_Kimura","line":198},{"line":198,"containerName":"D_Kimura","kind":13,"name":"$seq"},{"kind":12,"containerName":"D_Kimura","name":"display_id","line":198},{"line":199,"name":"@seqs","containerName":"D_Kimura","kind":13},{"containerName":"D_Kimura","kind":13,"name":"$seq","line":199},{"line":199,"name":"seq","containerName":"D_Kimura","kind":12},{"kind":13,"containerName":"D_Kimura","name":"$seqct","line":200},{"definition":"my","line":202,"localvar":"my","containerName":"D_Kimura","kind":13,"name":"$len"},{"line":202,"kind":13,"containerName":"D_Kimura","name":"$aln"},{"line":202,"containerName":"D_Kimura","kind":12,"name":"length"},{"definition":"my","line":203,"name":"$precisionstr","localvar":"my","containerName":"D_Kimura","kind":13},{"name":"$i","kind":13,"localvar":"my","containerName":"D_Kimura","line":205,"definition":"my"},{"line":205,"name":"$i","containerName":"D_Kimura","kind":13},{"line":205,"name":"$seqct","containerName":"D_Kimura","kind":13},{"containerName":"D_Kimura","kind":13,"name":"$i","line":205},{"name":"$dist","kind":13,"containerName":"D_Kimura","line":207},{"name":"$names","containerName":"D_Kimura","kind":13,"line":207},{"name":"$i","containerName":"D_Kimura","kind":13,"line":207},{"name":"$names","containerName":"D_Kimura","kind":13,"line":207},{"line":207,"containerName":"D_Kimura","kind":13,"name":"$i"},{"kind":13,"containerName":"D_Kimura","name":"$i","line":207},{"line":207,"containerName":"D_Kimura","kind":13,"name":"$i"},{"line":208,"name":"$values","containerName":"D_Kimura","kind":13},{"line":208,"containerName":"D_Kimura","kind":13,"name":"$i"},{"kind":13,"containerName":"D_Kimura","name":"$i","line":208},{"line":208,"name":"$precisionstr","kind":13,"containerName":"D_Kimura"},{"kind":13,"localvar":"my","containerName":"D_Kimura","name":"$j","line":209,"definition":"my"},{"name":"$i","containerName":"D_Kimura","kind":13,"line":209},{"containerName":"D_Kimura","kind":13,"name":"$j","line":209},{"line":209,"containerName":"D_Kimura","kind":13,"name":"$seqct"},{"line":209,"kind":13,"containerName":"D_Kimura","name":"$j"},{"definition":"my","name":"$scored","containerName":"D_Kimura","localvar":"my","kind":13,"line":210},{"name":"$match","containerName":"D_Kimura","kind":13,"line":210},{"definition":"my","line":211,"name":"$k","kind":13,"localvar":"my","containerName":"D_Kimura"},{"kind":13,"containerName":"D_Kimura","name":"$k","line":211},{"line":211,"name":"$len","kind":13,"containerName":"D_Kimura"},{"line":211,"name":"$k","kind":13,"containerName":"D_Kimura"},{"definition":"my","name":"$m1","localvar":"my","kind":13,"containerName":"D_Kimura","line":212},{"line":212,"kind":13,"containerName":"D_Kimura","name":"$seqs"},{"containerName":"D_Kimura","kind":13,"name":"$i","line":212},{"kind":13,"containerName":"D_Kimura","name":"$k","line":212},{"name":"$m2","localvar":"my","kind":13,"containerName":"D_Kimura","line":213,"definition":"my"},{"name":"$seqs","kind":13,"containerName":"D_Kimura","line":213},{"line":213,"kind":13,"containerName":"D_Kimura","name":"$j"},{"name":"$k","containerName":"D_Kimura","kind":13,"line":213},{"line":214,"kind":13,"containerName":"D_Kimura","name":"$m1"},{"containerName":"D_Kimura","kind":13,"name":"$m2","line":214},{"name":"$match","containerName":"D_Kimura","kind":13,"line":220},{"name":"$m1","containerName":"D_Kimura","kind":13,"line":220},{"line":220,"name":"$m2","kind":13,"containerName":"D_Kimura"},{"line":221,"name":"$scored","containerName":"D_Kimura","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"D_Kimura","name":"$D","line":234},{"line":234,"name":"$match","containerName":"D_Kimura","kind":13},{"line":234,"containerName":"D_Kimura","kind":13,"name":"$scored"},{"containerName":"D_Kimura","kind":13,"name":"$D","line":235},{"kind":13,"containerName":"D_Kimura","name":"$D","line":236},{"containerName":"D_Kimura","kind":13,"name":"$D","line":236},{"line":236,"kind":13,"containerName":"D_Kimura","name":"$D"},{"containerName":"D_Kimura","kind":13,"name":"$values","line":237},{"name":"$j","containerName":"D_Kimura","kind":13,"line":237},{"line":237,"containerName":"D_Kimura","kind":13,"name":"$i"},{"line":237,"kind":13,"containerName":"D_Kimura","name":"$values"},{"line":237,"name":"$i","containerName":"D_Kimura","kind":13},{"name":"$j","containerName":"D_Kimura","kind":13,"line":237},{"name":"$precisionstr","kind":13,"containerName":"D_Kimura","line":237},{"containerName":"D_Kimura","kind":13,"name":"$D","line":237},{"name":"$values","containerName":"D_Kimura","kind":13,"line":239},{"containerName":"D_Kimura","kind":13,"name":"$j","line":239},{"line":239,"name":"$i","kind":13,"containerName":"D_Kimura"},{"line":239,"name":"$values","kind":13,"containerName":"D_Kimura"},{"line":239,"name":"$i","containerName":"D_Kimura","kind":13},{"name":"$j","containerName":"D_Kimura","kind":13,"line":239},{"line":242,"name":"$dist","containerName":"D_Kimura","kind":13},{"line":242,"kind":13,"containerName":"D_Kimura","name":"$names"},{"name":"$i","containerName":"D_Kimura","kind":13,"line":242},{"line":242,"containerName":"D_Kimura","kind":13,"name":"$names"},{"line":242,"name":"$j","containerName":"D_Kimura","kind":13},{"name":"$i","containerName":"D_Kimura","kind":13,"line":242},{"name":"$j","kind":13,"containerName":"D_Kimura","line":242},{"line":243,"name":"$dist","containerName":"D_Kimura","kind":13},{"name":"$names","containerName":"D_Kimura","kind":13,"line":243},{"line":243,"containerName":"D_Kimura","kind":13,"name":"$j"},{"kind":13,"containerName":"D_Kimura","name":"$names","line":243},{"name":"$i","kind":13,"containerName":"D_Kimura","line":243},{"kind":13,"containerName":"D_Kimura","name":"$i","line":243},{"kind":13,"containerName":"D_Kimura","name":"$j","line":243},{"containerName":"D_Kimura","kind":13,"name":"$dist","line":246},{"name":"$names","containerName":"D_Kimura","kind":13,"line":246},{"line":246,"containerName":"D_Kimura","kind":13,"name":"$j"},{"kind":13,"containerName":"D_Kimura","name":"$names","line":246},{"line":246,"name":"$j","containerName":"D_Kimura","kind":13},{"line":246,"name":"$j","kind":13,"containerName":"D_Kimura"},{"name":"$j","containerName":"D_Kimura","kind":13,"line":246},{"line":247,"name":"$values","kind":13,"containerName":"D_Kimura"},{"kind":13,"containerName":"D_Kimura","name":"$j","line":247},{"line":247,"name":"$j","kind":13,"containerName":"D_Kimura"},{"line":247,"name":"$precisionstr","kind":13,"containerName":"D_Kimura"},{"name":"new","kind":12,"containerName":"D_Kimura","line":251},{"line":252,"containerName":"D_Kimura","kind":13,"name":"%dist"},{"kind":13,"containerName":"D_Kimura","name":"@names","line":253},{"line":254,"name":"@values","containerName":"D_Kimura","kind":13}],"signature":{"label":"D_Kimura($self,$aln)","parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'Kimura';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $matrix = $pepstats->D_Kimura($aln);\n Function: Calculate Kimura protein distance (Kimura 1983) which \n           approximates PAM distance\n           D = -ln ( 1 - p - 0.2 * p^2 )\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI>\n\n\n Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, Cambridge."},"range":{"start":{"line":191,"character":0},"end":{"line":256,"character":9999}},"kind":12,"line":191},{"kind":12,"name":"_check_ambiguity_protein","line":220},{"name":"Bio","kind":12,"containerName":"Matrix::PhylipDist","line":251},{"children":[{"definition":"my","name":"$t1","containerName":"_check_ambiguity_protein","localvar":"my","kind":13,"line":261},{"name":"$t2","kind":13,"containerName":"_check_ambiguity_protein","line":261},{"name":"$n","containerName":"_check_ambiguity_protein","localvar":"my","kind":13,"line":262,"definition":"my"},{"containerName":"_check_ambiguity_protein","kind":13,"name":"$t1","line":264},{"line":264,"name":"$t1","kind":13,"containerName":"_check_ambiguity_protein"},{"line":264,"name":"$t2","containerName":"_check_ambiguity_protein","kind":13},{"containerName":"_check_ambiguity_protein","kind":13,"name":"$n","line":265},{"line":266,"name":"$t1","containerName":"_check_ambiguity_protein","kind":13},{"containerName":"_check_ambiguity_protein","kind":13,"name":"$t2","line":266},{"line":267,"kind":13,"containerName":"_check_ambiguity_protein","name":"$t2"},{"line":267,"containerName":"_check_ambiguity_protein","kind":13,"name":"$t2"},{"line":269,"kind":13,"containerName":"_check_ambiguity_protein","name":"$t1"},{"line":269,"containerName":"_check_ambiguity_protein","kind":13,"name":"$t2"},{"name":"$t2","containerName":"_check_ambiguity_protein","kind":13,"line":270},{"containerName":"_check_ambiguity_protein","kind":13,"name":"$t1","line":270},{"line":271,"kind":13,"containerName":"_check_ambiguity_protein","name":"$n"},{"line":272,"containerName":"_check_ambiguity_protein","kind":13,"name":"$t1"},{"line":272,"containerName":"_check_ambiguity_protein","kind":13,"name":"$t2"},{"name":"$n","kind":13,"containerName":"_check_ambiguity_protein","line":273},{"containerName":"_check_ambiguity_protein","kind":13,"name":"$t1","line":274},{"containerName":"_check_ambiguity_protein","kind":13,"name":"$t2","line":274},{"name":"$n","containerName":"_check_ambiguity_protein","kind":13,"line":275},{"line":277,"name":"$n","kind":13,"containerName":"_check_ambiguity_protein"}],"containerName":"main::","name":"_check_ambiguity_protein","definition":"sub","detail":"($t1,$t2)","line":259,"kind":12,"range":{"end":{"character":9999,"line":278},"start":{"line":259,"character":0}},"signature":{"label":"_check_ambiguity_protein($t1,$t2)","parameters":[{"label":"$t1"},{"label":"$t2"}],"documentation":" some methods from EMBOSS distmat"}},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"pairwise_stats","kind":13,"line":296},{"name":"$value","kind":13,"containerName":"pairwise_stats","line":296},{"line":297,"containerName":"pairwise_stats","kind":13,"name":"$value"},{"name":"$self","containerName":"pairwise_stats","kind":13,"line":298},{"kind":13,"containerName":"pairwise_stats","name":"$value","line":298},{"kind":13,"containerName":"pairwise_stats","name":"$self","line":300}],"name":"pairwise_stats","containerName":"main::","signature":{"label":"pairwise_stats($self,$value)","documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'Kimura';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $matrix = $pepstats->D_Kimura($aln);\n Function: Calculate Kimura protein distance (Kimura 1983) which \n           approximates PAM distance\n           D = -ln ( 1 - p - 0.2 * p^2 )\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI>\n\n\n\n# Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, Cambridge.\n\nsub D_Kimura{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $len = $aln->length;\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($scored,$match) = (0,0);\n\t   for( my $k=0; $k < $len; $k++ ) {\n\t       my $m1 = substr($seqs[$i],$k,1);\n\t       my $m2 = substr($seqs[$j],$k,1);\n\t       if( $m1 ne '-' && $m2 ne '-' ) {\n\t\t   # score is number of scored bases (alignable bases)\n\t\t   # it could have also come from \n\t\t   # my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t\t   # match is number of matches weighting ambiguity bases\n\t\t   # as well\n\t\t   $match += _check_ambiguity_protein($m1,$m2);\n\t\t   $scored++;\n\t       }\n\t   }\n\t   # From Felsenstein's PHYLIP documentation:\n\t   # This is very quick to do but has some obvious\n\t   # limitations. It does not take into account which amino\n\t   # acids differ or to what amino acids they change, so some\n\t   # information is lost. The units of the distance measure\n\t   # are fraction of amino acids differing, as also in the\n\t   # case of the PAM distance. If the fraction of amino acids\n\t   # differing gets larger than 0.8541 the distance becomes\n\t   # infinite.\n\n\t   my $D = 1 - ( $match / $scored );\n\t   if( $D < 0.8541 ) {\n\t       $D = - log ( 1 - $D - (0.2 * ($D ** 2)));\n\t       $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n\t   } else { \n\t       $values[$j][$i] = $values[$i][$j] = '    NaN';\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_PEPstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n   \n}\n\n# some methods from EMBOSS distmat\nsub _check_ambiguity_protein\n{\n    my ($t1,$t2) = @_;\n    my $n = 0;\n\n    if( $t1 ne 'X' && $t1 eq $t2 ) { \n        $n = 1.0;\n    } elsif(  ((($t1 eq 'B' && $t2 eq 'DN') ||\n\t       ($t2 eq 'B' && $t2 eq 'DN'))) ||\n\t      \n\t      ( ($t1 eq 'Z' && $t2 eq 'EQ') ||\n\t\t($t2 eq 'Z' && $t1 eq 'EQ'))) {\n        $n = 0.5;\n    } elsif ( $t1 eq 'X' && $t2 eq 'X' ) {\n        $n = 0.0025;\n    } elsif(  $t1 eq 'X' || $t2 eq 'X' ) {\n        $n = 0.05;\n    }\n    return $n;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"line":295,"kind":12,"range":{"start":{"character":0,"line":295},"end":{"line":302,"character":9999}}},{"line":304,"range":{"start":{"character":0,"line":304},"end":{"character":9999,"line":314}},"kind":12,"signature":{"label":"_check_arg($self,$aln)","documentation":"","parameters":[{"label":"$self"},{"label":"$aln"}]},"children":[{"line":305,"name":"$self","containerName":"_check_arg","localvar":"my","kind":13,"definition":"my"},{"line":305,"name":"$aln","containerName":"_check_arg","kind":13},{"line":306,"name":"$aln","containerName":"_check_arg","kind":13},{"name":"$aln","containerName":"_check_arg","kind":13,"line":306},{"line":306,"name":"isa","kind":12,"containerName":"_check_arg"},{"line":307,"name":"$self","kind":13,"containerName":"_check_arg"},{"line":307,"name":"warn","containerName":"_check_arg","kind":12},{"line":309,"kind":13,"containerName":"_check_arg","name":"$aln"},{"name":"get_seq_by_pos","kind":12,"containerName":"_check_arg","line":309},{"line":309,"containerName":"_check_arg","kind":12,"name":"alphabet"},{"line":310,"containerName":"_check_arg","kind":13,"name":"$self"},{"line":310,"name":"warn","containerName":"_check_arg","kind":12},{"line":310,"name":"$aln","containerName":"_check_arg","kind":13},{"kind":12,"containerName":"_check_arg","name":"get_seq_by_pos","line":310},{"line":310,"containerName":"_check_arg","kind":12,"name":"alphabet"}],"name":"_check_arg","containerName":"main::","definition":"sub","detail":"($self,$aln)"}],"version":5}