{"vars":[{"line":4,"kind":2,"containerName":"","name":"vars"},{"name":"$VERSION","containerName":null,"line":5,"kind":13},{"kind":13,"line":15,"name":"$YES","definition":"my","containerName":null,"localvar":"my"},{"line":15,"kind":2,"name":"Results","containerName":"Config::Test::Harness::Assert::Test::Harness::Iterator::Test::Harness::Point::Test::Harness"},{"line":16,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$NO"},{"line":16,"kind":13,"name":"$YES","containerName":null},{"kind":12,"line":67,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":68,"kind":13},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":69},{"name":"$class","containerName":"new","kind":13,"line":69},{"containerName":"new","name":"$self","line":71,"kind":13},{"line":71,"kind":12,"containerName":"new","name":"_init"},{"name":"$self","containerName":"new","kind":13,"line":73}],"containerName":"main::","name":"new","definition":"sub","range":{"start":{"character":0,"line":67},"end":{"line":74,"character":9999}}},{"kind":12,"line":84,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_init","line":85,"kind":13},{"kind":13,"line":87,"name":"$self","containerName":"_init"},{"name":"$self","containerName":"_init","line":88,"kind":13},{"containerName":"_init","name":"$self","kind":13,"line":89}],"containerName":"main::","definition":"sub","name":"_init","range":{"end":{"character":9999,"line":90},"start":{"character":0,"line":84}}},{"name":"_is_vms","line":87,"kind":12},{"name":"_is_win32","kind":12,"line":88},{"line":89,"kind":12,"name":"_is_macos"},{"kind":12,"children":[{"line":108,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"analyze"},{"kind":13,"line":108,"containerName":"analyze","name":"$name"},{"containerName":"analyze","name":"$test_output","line":108,"kind":13},{"kind":13,"line":110,"definition":"my","name":"$it","containerName":"analyze","localvar":"my"},{"name":"new","containerName":"analyze","kind":12,"line":110},{"containerName":"analyze","name":"$test_output","kind":13,"line":110},{"containerName":"analyze","name":"$self","line":111,"kind":13},{"kind":12,"line":111,"name":"_analyze_iterator","containerName":"analyze"},{"line":111,"kind":13,"containerName":"analyze","name":"$name"},{"containerName":"analyze","name":"$it","line":111,"kind":13}],"line":107,"definition":"sub","containerName":"main::","signature":{"label":"analyze($self,$name,$test_output)","documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$test_output"}]},"detail":"($self,$name,$test_output)","name":"analyze","range":{"start":{"line":107,"character":0},"end":{"character":9999,"line":112}}},{"kind":12,"line":110,"name":"Test","containerName":"Harness::Iterator"},{"name":"_analyze_iterator","range":{"end":{"character":9999,"line":142},"start":{"line":115,"character":0}},"kind":12,"children":[{"containerName":"_analyze_iterator","definition":"my","name":"$self","localvar":"my","kind":13,"line":116},{"containerName":"_analyze_iterator","name":"$name","line":116,"kind":13},{"containerName":"_analyze_iterator","name":"$it","kind":13,"line":116},{"containerName":"_analyze_iterator","name":"$self","kind":13,"line":118},{"containerName":"_analyze_iterator","name":"_reset_file_state","line":118,"kind":12},{"name":"$self","containerName":"_analyze_iterator","kind":13,"line":119},{"kind":13,"line":119,"containerName":"_analyze_iterator","name":"$name"},{"localvar":"my","containerName":"_analyze_iterator","name":"$results","definition":"my","line":121,"kind":13},{"line":121,"kind":12,"containerName":"_analyze_iterator","name":"new"},{"kind":13,"line":124,"containerName":"_analyze_iterator","name":"$self"},{"name":"$name","containerName":"_analyze_iterator","line":124,"kind":13},{"kind":13,"line":124,"containerName":"_analyze_iterator","name":"$results"},{"line":125,"kind":13,"localvar":"my","definition":"my","name":"$line","containerName":"_analyze_iterator"},{"containerName":"_analyze_iterator","name":"$it","line":125,"kind":13},{"containerName":"_analyze_iterator","name":"next","line":125,"kind":12},{"containerName":"_analyze_iterator","name":"$self","line":126,"kind":13},{"containerName":"_analyze_iterator","name":"_analyze_line","line":126,"kind":12},{"kind":13,"line":126,"containerName":"_analyze_iterator","name":"$line"},{"line":126,"kind":13,"name":"$results","containerName":"_analyze_iterator"},{"line":127,"kind":13,"containerName":"_analyze_iterator","name":"$self"},{"name":"$results","containerName":"_analyze_iterator","line":130,"kind":13},{"kind":12,"line":130,"containerName":"_analyze_iterator","name":"set_skip_all"},{"line":130,"kind":13,"containerName":"_analyze_iterator","name":"$self"},{"containerName":"_analyze_iterator","name":"$self","line":130,"kind":13},{"localvar":"my","containerName":"_analyze_iterator","definition":"my","name":"$passed","line":132,"kind":13},{"name":"$results","containerName":"_analyze_iterator","line":133,"kind":13},{"kind":12,"line":133,"containerName":"_analyze_iterator","name":"max"},{"kind":13,"line":133,"containerName":"_analyze_iterator","name":"$results"},{"line":133,"kind":12,"name":"skip_all","containerName":"_analyze_iterator"},{"line":134,"kind":13,"name":"$results","containerName":"_analyze_iterator"},{"kind":12,"line":134,"name":"max","containerName":"_analyze_iterator"},{"line":135,"kind":13,"containerName":"_analyze_iterator","name":"$results"},{"name":"seen","containerName":"_analyze_iterator","kind":12,"line":135},{"name":"$results","containerName":"_analyze_iterator","line":136,"kind":13},{"name":"max","containerName":"_analyze_iterator","kind":12,"line":136},{"kind":13,"line":136,"name":"$results","containerName":"_analyze_iterator"},{"kind":12,"line":136,"containerName":"_analyze_iterator","name":"seen"},{"containerName":"_analyze_iterator","name":"$results","kind":13,"line":137},{"line":137,"kind":12,"name":"max","containerName":"_analyze_iterator"},{"line":137,"kind":13,"name":"$results","containerName":"_analyze_iterator"},{"name":"ok","containerName":"_analyze_iterator","kind":12,"line":137},{"line":139,"kind":13,"name":"$results","containerName":"_analyze_iterator"},{"name":"set_passing","containerName":"_analyze_iterator","kind":12,"line":139},{"kind":13,"line":139,"containerName":"_analyze_iterator","name":"$passed"},{"line":141,"kind":13,"name":"$results","containerName":"_analyze_iterator"}],"line":115,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$it"}],"label":"_analyze_iterator($self,$name,$it)"},"detail":"($self,$name,$it)"},{"name":"file","kind":12,"line":119},{"line":121,"kind":12,"name":"Test","containerName":"Harness::Results"},{"name":"totals","kind":12,"line":124},{"kind":12,"line":127,"name":"saw_bailout"},{"kind":12,"line":130,"name":"skip_all"},{"kind":12,"line":130,"name":"skip_all"},{"containerName":"main::","definition":"sub","name":"_analyze_line","range":{"start":{"line":145,"character":0},"end":{"character":9999,"line":232}},"kind":12,"line":145,"children":[{"kind":13,"line":146,"containerName":"_analyze_line","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":147,"name":"$line","definition":"my","containerName":"_analyze_line","localvar":"my"},{"localvar":"my","containerName":"_analyze_line","definition":"my","name":"$results","line":148,"kind":13},{"line":150,"kind":13,"containerName":"_analyze_line","name":"$self"},{"line":152,"kind":13,"localvar":"my","containerName":"_analyze_line","name":"$linetype","definition":"my"},{"kind":13,"line":153,"name":"$point","definition":"my","containerName":"_analyze_line","localvar":"my"},{"name":"from_test_line","containerName":"_analyze_line","kind":12,"line":153},{"line":153,"kind":13,"name":"$line","containerName":"_analyze_line"},{"kind":13,"line":154,"name":"$point","containerName":"_analyze_line"},{"name":"$linetype","containerName":"_analyze_line","kind":13,"line":155},{"containerName":"_analyze_line","name":"$results","kind":13,"line":157},{"kind":12,"line":157,"containerName":"_analyze_line","name":"inc_seen"},{"containerName":"_analyze_line","name":"$point","kind":13,"line":158},{"name":"set_number","containerName":"_analyze_line","kind":12,"line":158},{"kind":13,"line":158,"containerName":"_analyze_line","name":"$self"},{"line":158,"kind":13,"name":"$point","containerName":"_analyze_line"},{"kind":12,"line":158,"containerName":"_analyze_line","name":"number"},{"kind":13,"line":164,"containerName":"_analyze_line","name":"$self"},{"containerName":"_analyze_line","name":"$self","line":164,"kind":13},{"name":"$self","containerName":"_analyze_line","kind":13,"line":164},{"kind":13,"line":165,"name":"$point","containerName":"_analyze_line"},{"line":165,"kind":12,"containerName":"_analyze_line","name":"set_ok"},{"kind":13,"line":168,"containerName":"_analyze_line","name":"$self"},{"line":168,"kind":13,"containerName":"_analyze_line","name":"$point"},{"containerName":"_analyze_line","name":"number","line":168,"kind":12},{"name":"$point","containerName":"_analyze_line","kind":13,"line":169},{"name":"set_directive_type","containerName":"_analyze_line","kind":12,"line":169},{"kind":13,"line":172,"containerName":"_analyze_line","name":"$point"},{"name":"is_todo","containerName":"_analyze_line","line":172,"kind":12},{"line":173,"kind":13,"containerName":"_analyze_line","name":"$results"},{"kind":12,"line":173,"containerName":"_analyze_line","name":"inc_todo"},{"containerName":"_analyze_line","name":"$results","line":174,"kind":13},{"containerName":"_analyze_line","name":"inc_bonus","kind":12,"line":174},{"containerName":"_analyze_line","name":"$point","kind":13,"line":174},{"name":"ok","containerName":"_analyze_line","kind":12,"line":174},{"containerName":"_analyze_line","name":"$point","kind":13,"line":176},{"kind":12,"line":176,"name":"is_skip","containerName":"_analyze_line"},{"name":"$results","containerName":"_analyze_line","kind":13,"line":177},{"containerName":"_analyze_line","name":"inc_skip","line":177,"kind":12},{"line":180,"kind":13,"containerName":"_analyze_line","name":"$results"},{"name":"inc_ok","containerName":"_analyze_line","kind":12,"line":180},{"containerName":"_analyze_line","name":"$point","line":180,"kind":13},{"containerName":"_analyze_line","name":"pass","line":180,"kind":12},{"line":182,"kind":13,"containerName":"_analyze_line","name":"$point"},{"kind":12,"line":182,"containerName":"_analyze_line","name":"number"},{"name":"$point","containerName":"_analyze_line","kind":13,"line":182},{"kind":12,"line":182,"name":"number","containerName":"_analyze_line"},{"name":"$self","containerName":"_analyze_line","kind":13,"line":182},{"line":183,"kind":13,"containerName":"_analyze_line","name":"$self"},{"containerName":"_analyze_line","name":"$point","kind":13,"line":184},{"line":184,"kind":12,"name":"number","containerName":"_analyze_line"},{"localvar":"my","containerName":"_analyze_line","name":"$details","definition":"my","line":189,"kind":13},{"line":190,"kind":13,"name":"$point","containerName":"_analyze_line"},{"kind":12,"line":190,"name":"pass","containerName":"_analyze_line"},{"name":"$point","containerName":"_analyze_line","line":191,"kind":13},{"name":"ok","containerName":"_analyze_line","line":191,"kind":12},{"kind":13,"line":192,"containerName":"_analyze_line","name":"$point"},{"line":192,"kind":12,"containerName":"_analyze_line","name":"description"},{"line":193,"kind":13,"name":"$point","containerName":"_analyze_line"},{"line":193,"kind":12,"name":"directive_type","containerName":"_analyze_line"},{"kind":13,"line":194,"name":"$point","containerName":"_analyze_line"},{"containerName":"_analyze_line","name":"directive_reason","kind":12,"line":194},{"containerName":"_analyze_line","name":"$details","line":197,"kind":13},{"line":197,"kind":13,"containerName":"_analyze_line","name":"$details"},{"name":"$results","containerName":"_analyze_line","line":198,"kind":13},{"containerName":"_analyze_line","name":"set_details","kind":12,"line":198},{"kind":13,"line":198,"containerName":"_analyze_line","name":"$point"},{"kind":12,"line":198,"containerName":"_analyze_line","name":"number"},{"name":"$details","containerName":"_analyze_line","line":198,"kind":13},{"line":201,"kind":13,"name":"$line","containerName":"_analyze_line"},{"name":"$linetype","containerName":"_analyze_line","kind":13,"line":202},{"line":205,"kind":13,"containerName":"_analyze_line","name":"$self"},{"name":"$self","containerName":"_analyze_line","line":205,"kind":13},{"containerName":"_analyze_line","name":"$self","line":207,"kind":13},{"name":"_is_header","containerName":"_analyze_line","line":207,"kind":12},{"kind":13,"line":207,"name":"$line","containerName":"_analyze_line"},{"kind":13,"line":208,"containerName":"_analyze_line","name":"$linetype"},{"kind":13,"line":210,"name":"$self","containerName":"_analyze_line"},{"kind":13,"line":212,"name":"$results","containerName":"_analyze_line"},{"kind":12,"line":212,"name":"inc_max","containerName":"_analyze_line"},{"name":"$self","containerName":"_analyze_line","kind":13,"line":212},{"name":"$self","containerName":"_analyze_line","line":214,"kind":13},{"line":214,"kind":12,"containerName":"_analyze_line","name":"_is_bail_out"},{"kind":13,"line":214,"name":"$line","containerName":"_analyze_line"},{"containerName":"_analyze_line","name":"$self","kind":13,"line":214},{"name":"$linetype","containerName":"_analyze_line","kind":13,"line":215},{"containerName":"_analyze_line","name":"$self","kind":13,"line":216},{"kind":13,"line":218,"definition":"my","name":"$diagnostics","containerName":"_analyze_line","localvar":"my"},{"line":218,"kind":13,"name":"$self","containerName":"_analyze_line"},{"containerName":"_analyze_line","name":"_is_diagnostic_line","line":218,"kind":12},{"containerName":"_analyze_line","name":"$line","line":218,"kind":13},{"containerName":"_analyze_line","name":"$linetype","line":219,"kind":13},{"line":221,"kind":13,"localvar":"my","containerName":"_analyze_line","name":"$test","definition":"my"},{"line":221,"kind":13,"containerName":"_analyze_line","name":"$results"},{"name":"details","containerName":"_analyze_line","kind":12,"line":221},{"containerName":"_analyze_line","name":"$test","kind":13,"line":222},{"name":"$test","containerName":"_analyze_line","line":223,"kind":13},{"containerName":"_analyze_line","name":"$diagnostics","kind":13,"line":223},{"containerName":"_analyze_line","name":"$linetype","kind":13,"line":226},{"containerName":"_analyze_line","name":"$self","kind":13,"line":229},{"kind":12,"line":229,"name":"callback","containerName":"_analyze_line"},{"line":229,"kind":13,"name":"$self","containerName":"_analyze_line"},{"kind":13,"line":229,"containerName":"_analyze_line","name":"$line"},{"kind":13,"line":229,"name":"$linetype","containerName":"_analyze_line"},{"kind":13,"line":229,"name":"$results","containerName":"_analyze_line"},{"line":229,"kind":13,"containerName":"_analyze_line","name":"$self"},{"name":"callback","containerName":"_analyze_line","line":229,"kind":12},{"line":231,"kind":13,"containerName":"_analyze_line","name":"$self"},{"kind":13,"line":231,"containerName":"_analyze_line","name":"$point"},{"containerName":"_analyze_line","name":"number","kind":12,"line":231},{"containerName":"_analyze_line","name":"$point","kind":13,"line":231}]},{"kind":12,"line":150,"name":"line"},{"kind":12,"line":153,"name":"Test","containerName":"Harness::Point"},{"name":"lone_not_line","line":164,"kind":12},{"name":"lone_not_line","kind":12,"line":164},{"kind":12,"line":164,"name":"line"},{"name":"todo","kind":12,"line":168},{"name":"max","line":182,"kind":12},{"name":"too_many_tests","kind":12,"line":183},{"kind":12,"line":190,"name":"ok"},{"name":"actual_ok","kind":12,"line":191},{"line":192,"kind":12,"name":"name"},{"name":"_def_or_blank","kind":12,"line":192},{"name":"type","kind":12,"line":193},{"name":"_def_or_blank","line":193,"kind":12},{"line":194,"kind":12,"name":"reason"},{"name":"_def_or_blank","kind":12,"line":194},{"name":"assert","kind":12,"line":197},{"name":"ok","kind":12,"line":197},{"name":"actual_ok","kind":12,"line":197},{"name":"lone_not_line","line":205,"kind":12},{"name":"line","kind":12,"line":205},{"line":210,"kind":12,"name":"saw_header"},{"name":"max","line":212,"kind":12},{"line":214,"kind":12,"name":"bailout_reason"},{"name":"saw_bailout","line":216,"kind":12},{"name":"diagnostics","kind":12,"line":222},{"kind":12,"line":223,"name":"diagnostics"},{"range":{"end":{"line":240,"character":9999},"start":{"character":0,"line":235}},"name":"_is_diagnostic_line","detail":"($self,$line)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_is_diagnostic_line($self,$line)"},"containerName":"main::","definition":"sub","line":235,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_is_diagnostic_line","line":236,"kind":13},{"line":236,"kind":13,"containerName":"_is_diagnostic_line","name":"$line"},{"containerName":"_is_diagnostic_line","name":"$line","kind":13,"line":237},{"line":238,"kind":13,"name":"$line","containerName":"_is_diagnostic_line"},{"name":"$line","containerName":"_is_diagnostic_line","line":239,"kind":13}],"kind":12},{"detail":"($self,$name,$fh)","signature":{"parameters":[{"label":"$self"},{"label":"$name"},{"label":"$fh"}],"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.","label":"analyze_fh($self,$name,$fh)"},"containerName":"main::","definition":"sub","line":250,"children":[{"kind":13,"line":251,"containerName":"analyze_fh","definition":"my","name":"$self","localvar":"my"},{"containerName":"analyze_fh","name":"$name","kind":13,"line":251},{"name":"$fh","containerName":"analyze_fh","kind":13,"line":251},{"kind":13,"line":253,"containerName":"analyze_fh","definition":"my","name":"$it","localvar":"my"},{"line":253,"kind":12,"containerName":"analyze_fh","name":"new"},{"name":"$fh","containerName":"analyze_fh","line":253,"kind":13},{"containerName":"analyze_fh","name":"$self","line":254,"kind":13},{"kind":12,"line":254,"containerName":"analyze_fh","name":"_analyze_iterator"},{"containerName":"analyze_fh","name":"$name","line":254,"kind":13},{"name":"$it","containerName":"analyze_fh","kind":13,"line":254}],"kind":12,"range":{"start":{"character":0,"line":250},"end":{"line":255,"character":9999}},"name":"analyze_fh"},{"name":"Test","containerName":"Harness::Iterator","kind":12,"line":253},{"range":{"end":{"character":9999,"line":308},"start":{"line":266,"character":0}},"name":"analyze_file","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"analyze_file","line":267,"kind":13},{"containerName":"analyze_file","name":"$file","line":267,"kind":13},{"kind":13,"line":269,"containerName":"analyze_file","name":"$file"},{"name":"$self","containerName":"analyze_file","kind":13,"line":270},{"kind":13,"line":274,"containerName":"analyze_file","name":"$file"},{"line":275,"kind":13,"containerName":"analyze_file","name":"$self"},{"name":"$ENV","containerName":"analyze_file","line":279,"kind":13},{"containerName":"analyze_file","name":"$self","line":279,"kind":13},{"kind":12,"line":279,"containerName":"analyze_file","name":"_INC2PERL5LIB"},{"containerName":"analyze_file","name":"$Test","kind":13,"line":280},{"localvar":"my","name":"$line","definition":"my","containerName":"analyze_file","line":286,"kind":13},{"name":"$self","containerName":"analyze_file","line":286,"kind":13},{"line":286,"kind":12,"containerName":"analyze_file","name":"_command_line"},{"containerName":"analyze_file","name":"$file","kind":13,"line":286},{"localvar":"my","definition":"my","name":"$results","containerName":"analyze_file","line":293,"kind":13},{"line":293,"kind":13,"containerName":"analyze_file","name":"$self"},{"line":293,"kind":12,"containerName":"analyze_file","name":"analyze_fh"},{"line":293,"kind":13,"name":"$file","containerName":"analyze_file"},{"definition":"my","name":"$exit","containerName":"analyze_file","localvar":"my","kind":13,"line":294},{"kind":13,"line":296,"containerName":"analyze_file","name":"$results"},{"kind":12,"line":296,"containerName":"analyze_file","name":"set_wait"},{"kind":13,"line":297,"name":"$self","containerName":"analyze_file"},{"kind":13,"line":301,"containerName":"analyze_file","name":"$results"},{"line":301,"kind":12,"containerName":"analyze_file","name":"set_exit"},{"kind":13,"line":303,"name":"$results","containerName":"analyze_file"},{"line":303,"kind":12,"containerName":"analyze_file","name":"set_passing"},{"line":305,"kind":13,"containerName":"analyze_file","name":"$self"},{"kind":12,"line":305,"containerName":"analyze_file","name":"_restore_PERL5LIB"},{"line":307,"kind":13,"containerName":"analyze_file","name":"$results"}],"line":266,"kind":12,"signature":{"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.","parameters":[{"label":"$self"},{"label":"$file"}],"label":"analyze_file($self,$file)"},"detail":"($self,$file)","definition":"sub","containerName":"main::"},{"kind":12,"line":270,"name":"error"},{"kind":12,"line":275,"name":"error"},{"kind":12,"line":279,"name":"PERL5LIB"},{"containerName":"Debug","name":"Harness","kind":12,"line":280},{"name":"FILE","kind":12,"line":288},{"name":"FILE","line":294,"kind":12},{"kind":12,"line":297,"name":"_is_vms"},{"kind":12,"line":301,"name":"_wait2exit"},{"containerName":"WEXITSTATUS","name":"POSIX","kind":12,"line":311},{"line":316,"kind":12,"containerName":"WEXITSTATUS","name":"POSIX"},{"kind":12,"line":325,"children":[{"line":326,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_command_line"},{"line":327,"kind":13,"localvar":"my","containerName":"_command_line","definition":"my","name":"$file"},{"line":329,"kind":13,"localvar":"my","definition":"my","name":"$command","containerName":"_command_line"},{"kind":13,"line":329,"containerName":"_command_line","name":"$self"},{"line":329,"kind":12,"name":"_command","containerName":"_command_line"},{"line":330,"kind":13,"localvar":"my","name":"$switches","definition":"my","containerName":"_command_line"},{"containerName":"_command_line","name":"$self","kind":13,"line":330},{"containerName":"_command_line","name":"_switches","line":330,"kind":12},{"containerName":"_command_line","name":"$file","line":330,"kind":13},{"name":"$file","containerName":"_command_line","kind":13,"line":332},{"containerName":"_command_line","name":"$file","kind":13,"line":332},{"line":332,"kind":13,"name":"$file","containerName":"_command_line"},{"localvar":"my","definition":"my","name":"$line","containerName":"_command_line","line":333,"kind":13},{"kind":13,"line":335,"containerName":"_command_line","name":"$line"}],"containerName":"main::","definition":"sub","name":"_command_line","range":{"end":{"line":336,"character":9999},"start":{"character":0,"line":325}}},{"containerName":"main::","definition":"sub","name":"_command","range":{"end":{"character":9999,"line":359},"start":{"character":0,"line":353}},"kind":12,"line":353,"children":[{"localvar":"my","containerName":"_command","name":"$self","definition":"my","line":354,"kind":13},{"name":"$ENV","containerName":"_command","kind":13,"line":356},{"line":356,"kind":13,"name":"$ENV","containerName":"_command"},{"kind":13,"line":357,"containerName":"_command","name":"$self"}]},{"kind":12,"line":356,"name":"HARNESS_PERL"},{"kind":12,"line":356,"name":"HARNESS_PERL"},{"kind":12,"line":357,"name":"_is_win32"},{"range":{"end":{"line":397,"character":9999},"start":{"character":0,"line":368}},"name":"_switches","children":[{"kind":13,"line":369,"name":"$self","definition":"my","containerName":"_switches","localvar":"my"},{"containerName":"_switches","name":"$file","line":369,"kind":13},{"kind":13,"line":371,"name":"@existing_switches","definition":"my","containerName":"_switches","localvar":"my"},{"line":371,"kind":13,"name":"$self","containerName":"_switches"},{"kind":12,"line":371,"name":"_cleaned_switches","containerName":"_switches"},{"line":371,"kind":13,"name":"$Test","containerName":"_switches"},{"containerName":"_switches","name":"$ENV","line":371,"kind":13},{"localvar":"my","definition":"my","name":"@derived_switches","containerName":"_switches","line":372,"kind":13},{"line":375,"kind":13,"name":"$file","containerName":"_switches"},{"kind":13,"line":376,"name":"$shebang","definition":"my","containerName":"_switches","localvar":"my"},{"localvar":"my","containerName":"_switches","name":"$taint","definition":"my","line":379,"kind":13},{"containerName":"_switches","name":"$shebang","line":379,"kind":13},{"line":380,"kind":13,"name":"@derived_switches","containerName":"_switches"},{"line":380,"kind":13,"name":"$taint","containerName":"_switches"},{"line":385,"kind":13,"containerName":"_switches","name":"$taint"},{"kind":13,"line":385,"containerName":"_switches","name":"$self"},{"line":386,"kind":13,"localvar":"my","containerName":"_switches","name":"@inc","definition":"my"},{"kind":13,"line":386,"name":"$self","containerName":"_switches"},{"line":386,"kind":12,"name":"_filtered_INC","containerName":"_switches"},{"line":387,"kind":13,"name":"@derived_switches","containerName":"_switches"},{"line":387,"kind":13,"name":"@inc","containerName":"_switches"},{"line":393,"kind":13,"containerName":"_switches","name":"@derived_switches"},{"line":394,"kind":13,"containerName":"_switches","name":"$self"},{"line":396,"kind":13,"name":"@existing_switches","containerName":"_switches"},{"containerName":"_switches","name":"@derived_switches","line":396,"kind":13}],"line":368,"kind":12,"signature":{"label":"_switches($self,$file)","documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.","parameters":[{"label":"$self"},{"label":"$file"}]},"detail":"($self,$file)","definition":"sub","containerName":"main::"},{"kind":12,"line":371,"name":"Harness","containerName":"Switches"},{"line":371,"kind":12,"name":"HARNESS_PERL_SWITCHES"},{"name":"TEST","kind":12,"line":375},{"line":376,"kind":12,"name":"TEST"},{"name":"TEST","line":377,"kind":12},{"name":"_is_macos","kind":12,"line":385},{"name":"_is_vms","kind":12,"line":394},{"kind":12,"line":405,"children":[{"containerName":"_cleaned_switches","definition":"my","name":"$self","localvar":"my","kind":13,"line":406},{"definition":"my","name":"@switches","containerName":"_cleaned_switches","localvar":"my","kind":13,"line":410},{"name":"$switch","definition":"my","containerName":"_cleaned_switches","localvar":"my","kind":13,"line":412},{"kind":13,"line":413,"name":"$switch","containerName":"_cleaned_switches"},{"containerName":"_cleaned_switches","name":"$switch","line":414,"kind":13},{"containerName":"_cleaned_switches","name":"$switch","kind":13,"line":415},{"line":416,"kind":13,"containerName":"_cleaned_switches","name":"@switches"},{"line":416,"kind":13,"containerName":"_cleaned_switches","name":"$switch"},{"line":416,"kind":13,"name":"$switch","containerName":"_cleaned_switches"},{"name":"@switches","containerName":"_cleaned_switches","kind":13,"line":419}],"containerName":"main::","name":"_cleaned_switches","definition":"sub","range":{"end":{"line":420,"character":9999},"start":{"character":0,"line":405}}},{"containerName":"main::","name":"_INC2PERL5LIB","definition":"sub","range":{"start":{"line":431,"character":0},"end":{"character":9999,"line":437}},"kind":12,"line":431,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_INC2PERL5LIB","line":432,"kind":13},{"kind":13,"line":434,"containerName":"_INC2PERL5LIB","name":"$self"},{"name":"$ENV","containerName":"_INC2PERL5LIB","kind":13,"line":434},{"line":436,"kind":13,"containerName":"_INC2PERL5LIB","name":"$Config"},{"containerName":"_INC2PERL5LIB","name":"$self","kind":13,"line":436},{"containerName":"_INC2PERL5LIB","name":"_filtered_INC","kind":12,"line":436}]},{"kind":12,"line":434,"name":"_old5lib"},{"name":"PERL5LIB","kind":12,"line":434},{"name":"path_sep","line":436,"kind":12},{"range":{"start":{"line":448,"character":0},"end":{"character":9999,"line":468}},"name":"_filtered_INC","children":[{"localvar":"my","containerName":"_filtered_INC","definition":"my","name":"$self","line":449,"kind":13},{"containerName":"_filtered_INC","name":"@inc","line":449,"kind":13},{"name":"@inc","containerName":"_filtered_INC","kind":13,"line":450},{"line":450,"kind":13,"name":"@inc","containerName":"_filtered_INC"},{"line":452,"kind":13,"containerName":"_filtered_INC","name":"$self"},{"containerName":"_filtered_INC","name":"@inc","kind":13,"line":455},{"line":455,"kind":13,"containerName":"_filtered_INC","name":"@inc"},{"kind":13,"line":458,"containerName":"_filtered_INC","name":"$self"},{"containerName":"_filtered_INC","name":"@inc","kind":13,"line":460},{"line":463,"kind":13,"localvar":"my","definition":"my","name":"%seen","containerName":"_filtered_INC"},{"kind":13,"line":464,"containerName":"_filtered_INC","name":"$seen"},{"kind":13,"line":464,"containerName":"_filtered_INC","name":"$self"},{"name":"_default_inc","containerName":"_filtered_INC","kind":12,"line":464},{"line":465,"kind":13,"name":"@inc","containerName":"_filtered_INC"},{"containerName":"_filtered_INC","name":"$seen","kind":13,"line":465},{"line":465,"kind":13,"name":"@inc","containerName":"_filtered_INC"},{"name":"@inc","containerName":"_filtered_INC","kind":13,"line":467}],"line":448,"kind":12,"signature":{"label":"_filtered_INC($self,@inc)","documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.\n\n\nsub _switches {\n    my($self, $file) = @_;\n\n    my @existing_switches = $self->_cleaned_switches( $Test::Harness::Switches, $ENV{HARNESS_PERL_SWITCHES} );\n    my @derived_switches;\n\n    local *TEST;\n    open(TEST, $file) or print \"can't open $file. $!\\n\";\n    my $shebang = <TEST>;\n    close(TEST) or print \"can't close $file. $!\\n\";\n\n    my $taint = ( $shebang =~ /^#!.*\\bperl.*\\s-\\w*([Tt]+)/ );\n    push( @derived_switches, \"-$1\" ) if $taint;\n\n    # When taint mode is on, PERL5LIB is ignored.  So we need to put\n    # all that on the command line as -Is.\n    # MacPerl's putenv is broken, so it will not see PERL5LIB, tainted or not.\n    if ( $taint || $self->{_is_macos} ) {\n\tmy @inc = $self->_filtered_INC;\n\tpush @derived_switches, map { \"-I$_\" } @inc;\n    }\n\n    # Quote the argument if there's any whitespace in it, or if\n    # we're VMS, since VMS requires all parms quoted.  Also, don't quote\n    # it if it's already quoted.\n    for ( @derived_switches ) {\n\t$_ = qq[\"$_\"] if ((/\\s/ || $self->{_is_vms}) && !/^\".*\"$/ );\n    }\n    return join( \" \", @existing_switches, @derived_switches );\n}\n\n=for private $strap->_cleaned_switches( @switches_from_user )\n\nReturns only defined, non-blank, trimmed switches from the parms passed.\n\n\nsub _cleaned_switches {\n    my $self = shift;\n\n    local $_;\n\n    my @switches;\n    for ( @_ ) {\n\tmy $switch = $_;\n\tnext unless defined $switch;\n\t$switch =~ s/^\\s+//;\n\t$switch =~ s/\\s+$//;\n\tpush( @switches, $switch ) if $switch ne \"\";\n    }\n\n    return @switches;\n}\n\n=for private $strap->_INC2PERL5LIB\n\n  local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n\nTakes the current value of C<@INC> and turns it into something suitable\nfor putting onto C<PERL5LIB>.\n\n\nsub _INC2PERL5LIB {\n    my($self) = shift;\n\n    $self->{_old5lib} = $ENV{PERL5LIB};\n\n    return join $Config{path_sep}, $self->_filtered_INC;\n}\n\n=for private $strap->_filtered_INC()\n\n  my @filtered_inc = $self->_filtered_INC;\n\nShortens C<@INC> by removing redundant and unnecessary entries.\nNecessary for OSes with limited command line lengths, like VMS.","parameters":[{"label":"$self"},{"label":"@inc"}]},"detail":"($self,@inc)","definition":"sub","containerName":"main::"},{"line":452,"kind":12,"name":"_is_vms"},{"kind":12,"line":458,"name":"_is_win32"},{"containerName":null,"name":"%cache","definition":"my","localvar":"my","kind":13,"line":472},{"kind":12,"children":[{"localvar":"my","containerName":"_default_inc","name":"$self","definition":"my","line":474,"kind":13},{"containerName":"_default_inc","definition":"my","name":"$perl","localvar":"my","kind":13,"line":475},{"name":"$self","containerName":"_default_inc","line":475,"kind":13},{"kind":12,"line":475,"containerName":"_default_inc","name":"_command"},{"containerName":"_default_inc","name":"$cache","line":476,"kind":13},{"kind":13,"line":476,"name":"$perl","containerName":"_default_inc"},{"kind":13,"line":477,"containerName":"_default_inc","name":"$ENV"},{"line":478,"kind":13,"localvar":"my","name":"@inc","definition":"my","containerName":"_default_inc"},{"kind":13,"line":479,"name":"@inc","containerName":"_default_inc"},{"line":481,"kind":13,"name":"$cache","containerName":"_default_inc"},{"name":"$perl","containerName":"_default_inc","kind":13,"line":481}],"line":473,"definition":"sub","name":"_default_inc","containerName":"main::","range":{"start":{"line":473,"character":0},"end":{"line":481,"character":9999}}},{"name":"PERL5LIB","kind":12,"line":477},{"range":{"end":{"line":503,"character":9999},"start":{"character":0,"line":495}},"containerName":"main::","name":"_restore_PERL5LIB","definition":"sub","line":495,"children":[{"kind":13,"line":496,"containerName":"_restore_PERL5LIB","name":"$self","definition":"my","localvar":"my"},{"containerName":"_restore_PERL5LIB","name":"$self","kind":13,"line":498},{"kind":13,"line":500,"containerName":"_restore_PERL5LIB","name":"$self"},{"containerName":"_restore_PERL5LIB","name":"$ENV","line":501,"kind":13},{"line":501,"kind":13,"name":"$self","containerName":"_restore_PERL5LIB"}],"kind":12},{"name":"_is_vms","line":498,"kind":12},{"kind":12,"line":500,"name":"_old5lib"},{"kind":12,"line":501,"name":"PERL5LIB"},{"kind":12,"line":501,"name":"_old5lib"},{"range":{"start":{"character":0,"line":518},"end":{"line":528,"character":9999}},"name":"_is_diagnostic","detail":"($self,$line,$comment)","signature":{"label":"_is_diagnostic($self,$line,$comment)","documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.\n\n\nsub _switches {\n    my($self, $file) = @_;\n\n    my @existing_switches = $self->_cleaned_switches( $Test::Harness::Switches, $ENV{HARNESS_PERL_SWITCHES} );\n    my @derived_switches;\n\n    local *TEST;\n    open(TEST, $file) or print \"can't open $file. $!\\n\";\n    my $shebang = <TEST>;\n    close(TEST) or print \"can't close $file. $!\\n\";\n\n    my $taint = ( $shebang =~ /^#!.*\\bperl.*\\s-\\w*([Tt]+)/ );\n    push( @derived_switches, \"-$1\" ) if $taint;\n\n    # When taint mode is on, PERL5LIB is ignored.  So we need to put\n    # all that on the command line as -Is.\n    # MacPerl's putenv is broken, so it will not see PERL5LIB, tainted or not.\n    if ( $taint || $self->{_is_macos} ) {\n\tmy @inc = $self->_filtered_INC;\n\tpush @derived_switches, map { \"-I$_\" } @inc;\n    }\n\n    # Quote the argument if there's any whitespace in it, or if\n    # we're VMS, since VMS requires all parms quoted.  Also, don't quote\n    # it if it's already quoted.\n    for ( @derived_switches ) {\n\t$_ = qq[\"$_\"] if ((/\\s/ || $self->{_is_vms}) && !/^\".*\"$/ );\n    }\n    return join( \" \", @existing_switches, @derived_switches );\n}\n\n=for private $strap->_cleaned_switches( @switches_from_user )\n\nReturns only defined, non-blank, trimmed switches from the parms passed.\n\n\nsub _cleaned_switches {\n    my $self = shift;\n\n    local $_;\n\n    my @switches;\n    for ( @_ ) {\n\tmy $switch = $_;\n\tnext unless defined $switch;\n\t$switch =~ s/^\\s+//;\n\t$switch =~ s/\\s+$//;\n\tpush( @switches, $switch ) if $switch ne \"\";\n    }\n\n    return @switches;\n}\n\n=for private $strap->_INC2PERL5LIB\n\n  local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n\nTakes the current value of C<@INC> and turns it into something suitable\nfor putting onto C<PERL5LIB>.\n\n\nsub _INC2PERL5LIB {\n    my($self) = shift;\n\n    $self->{_old5lib} = $ENV{PERL5LIB};\n\n    return join $Config{path_sep}, $self->_filtered_INC;\n}\n\n=for private $strap->_filtered_INC()\n\n  my @filtered_inc = $self->_filtered_INC;\n\nShortens C<@INC> by removing redundant and unnecessary entries.\nNecessary for OSes with limited command line lengths, like VMS.\n\n\nsub _filtered_INC {\n    my($self, @inc) = @_;\n    @inc = @INC unless @inc;\n\n    if( $self->{_is_vms} ) {\n\t# VMS has a 255-byte limit on the length of %ENV entries, so\n\t# toss the ones that involve perl_root, the install location\n        @inc = grep !/perl_root/i, @inc;\n\n    }\n    elsif ( $self->{_is_win32} ) {\n\t# Lose any trailing backslashes in the Win32 paths\n\ts/[\\\\\\/+]$// foreach @inc;\n    }\n\n    my %seen;\n    $seen{$_}++ foreach $self->_default_inc();\n    @inc = grep !$seen{$_}++, @inc;\n\n    return @inc;\n}\n\n\n{ # Without caching, _default_inc() takes a huge amount of time\n    my %cache;\n    sub _default_inc {\n        my $self = shift;\n        my $perl = $self->_command;\n        $cache{$perl} ||= [do {\n            local $ENV{PERL5LIB};\n            my @inc =`$perl -le \"print join qq[\\\\n], \\@INC\"`;\n            chomp @inc;\n        }];\n        return @{$cache{$perl}};\n    }\n}\n\n\n=for private $strap->_restore_PERL5LIB()\n\n  $self->_restore_PERL5LIB;\n\nThis restores the original value of the C<PERL5LIB> environment variable.\nNecessary on VMS, otherwise a no-op.\n\n\nsub _restore_PERL5LIB {\n    my($self) = shift;\n\n    return unless $self->{_is_vms};\n\n    if (defined $self->{_old5lib}) {\n        $ENV{PERL5LIB} = $self->{_old5lib};\n    }\n}\n\n=head1 Parsing\n\nMethods for identifying what sort of line you're looking at.\n\n=for private _is_diagnostic\n\n    my $is_diagnostic = $strap->_is_diagnostic($line, \\$comment);\n\nChecks if the given line is a comment.  If so, it will place it into\nC<$comment> (sans #).","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$comment"}]},"containerName":"main::","definition":"sub","line":518,"children":[{"localvar":"my","containerName":"_is_diagnostic","definition":"my","name":"$self","line":519,"kind":13},{"name":"$line","containerName":"_is_diagnostic","kind":13,"line":519},{"line":519,"kind":13,"containerName":"_is_diagnostic","name":"$comment"},{"containerName":"_is_diagnostic","name":"$line","line":521,"kind":13},{"line":523,"kind":13,"name":"$YES","containerName":"_is_diagnostic"},{"name":"$NO","containerName":"_is_diagnostic","kind":13,"line":526}],"kind":12},{"line":522,"kind":12,"name":"comment"},{"kind":13,"line":542,"containerName":null,"definition":"my","name":"$Extra_Header_Re","localvar":"my"},{"range":{"start":{"line":548,"character":0},"end":{"character":9999,"line":572}},"name":"_is_header","detail":"($self,$line)","signature":{"parameters":[{"label":"$self"},{"label":"$line"}],"documentation":"","label":"_is_header($self,$line)"},"containerName":"main::","definition":"sub","line":548,"children":[{"containerName":"_is_header","name":"$self","definition":"my","localvar":"my","kind":13,"line":549},{"name":"$line","containerName":"_is_header","line":549,"kind":13},{"line":551,"kind":13,"localvar":"my","definition":"my","name":"$max","containerName":"_is_header"},{"name":"$extra","containerName":"_is_header","line":551,"kind":13},{"kind":13,"line":551,"name":"$line","containerName":"_is_header"},{"containerName":"_is_header","name":"$self","line":552,"kind":13},{"name":"$max","containerName":"_is_header","line":552,"kind":13},{"containerName":"_is_header","name":"$self","line":553,"kind":13},{"kind":13,"line":555,"name":"$extra","containerName":"_is_header"},{"localvar":"my","definition":"my","name":"$todo","containerName":"_is_header","line":556,"kind":13},{"containerName":"_is_header","name":"$skip","line":556,"kind":13},{"line":556,"kind":13,"name":"$reason","containerName":"_is_header"},{"containerName":"_is_header","name":"$extra","line":556,"kind":13},{"line":558,"kind":13,"name":"$self","containerName":"_is_header"},{"line":558,"kind":13,"name":"$todo","containerName":"_is_header"},{"containerName":"_is_header","name":"$todo","line":558,"kind":13},{"containerName":"_is_header","name":"$self","kind":13,"line":560},{"name":"$reason","containerName":"_is_header","kind":13,"line":561},{"name":"$skip","containerName":"_is_header","line":561,"kind":13},{"name":"$skip","containerName":"_is_header","line":561,"kind":13},{"name":"$self","containerName":"_is_header","kind":13,"line":564},{"line":564,"kind":13,"name":"$reason","containerName":"_is_header"},{"kind":13,"line":567,"name":"$YES","containerName":"_is_header"},{"containerName":"_is_header","name":"$NO","line":570,"kind":13}],"kind":12},{"line":552,"kind":12,"name":"max"},{"name":"assert","line":553,"kind":12},{"name":"max","line":553,"kind":12},{"kind":12,"line":558,"name":"todo"},{"name":"max","line":560,"kind":12},{"name":"skip_all","kind":12,"line":564},{"detail":"($self,$line,$reason)","signature":{"parameters":[{"label":"$self"},{"label":"$line"},{"label":"$reason"}],"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.\n\n\nsub _switches {\n    my($self, $file) = @_;\n\n    my @existing_switches = $self->_cleaned_switches( $Test::Harness::Switches, $ENV{HARNESS_PERL_SWITCHES} );\n    my @derived_switches;\n\n    local *TEST;\n    open(TEST, $file) or print \"can't open $file. $!\\n\";\n    my $shebang = <TEST>;\n    close(TEST) or print \"can't close $file. $!\\n\";\n\n    my $taint = ( $shebang =~ /^#!.*\\bperl.*\\s-\\w*([Tt]+)/ );\n    push( @derived_switches, \"-$1\" ) if $taint;\n\n    # When taint mode is on, PERL5LIB is ignored.  So we need to put\n    # all that on the command line as -Is.\n    # MacPerl's putenv is broken, so it will not see PERL5LIB, tainted or not.\n    if ( $taint || $self->{_is_macos} ) {\n\tmy @inc = $self->_filtered_INC;\n\tpush @derived_switches, map { \"-I$_\" } @inc;\n    }\n\n    # Quote the argument if there's any whitespace in it, or if\n    # we're VMS, since VMS requires all parms quoted.  Also, don't quote\n    # it if it's already quoted.\n    for ( @derived_switches ) {\n\t$_ = qq[\"$_\"] if ((/\\s/ || $self->{_is_vms}) && !/^\".*\"$/ );\n    }\n    return join( \" \", @existing_switches, @derived_switches );\n}\n\n=for private $strap->_cleaned_switches( @switches_from_user )\n\nReturns only defined, non-blank, trimmed switches from the parms passed.\n\n\nsub _cleaned_switches {\n    my $self = shift;\n\n    local $_;\n\n    my @switches;\n    for ( @_ ) {\n\tmy $switch = $_;\n\tnext unless defined $switch;\n\t$switch =~ s/^\\s+//;\n\t$switch =~ s/\\s+$//;\n\tpush( @switches, $switch ) if $switch ne \"\";\n    }\n\n    return @switches;\n}\n\n=for private $strap->_INC2PERL5LIB\n\n  local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n\nTakes the current value of C<@INC> and turns it into something suitable\nfor putting onto C<PERL5LIB>.\n\n\nsub _INC2PERL5LIB {\n    my($self) = shift;\n\n    $self->{_old5lib} = $ENV{PERL5LIB};\n\n    return join $Config{path_sep}, $self->_filtered_INC;\n}\n\n=for private $strap->_filtered_INC()\n\n  my @filtered_inc = $self->_filtered_INC;\n\nShortens C<@INC> by removing redundant and unnecessary entries.\nNecessary for OSes with limited command line lengths, like VMS.\n\n\nsub _filtered_INC {\n    my($self, @inc) = @_;\n    @inc = @INC unless @inc;\n\n    if( $self->{_is_vms} ) {\n\t# VMS has a 255-byte limit on the length of %ENV entries, so\n\t# toss the ones that involve perl_root, the install location\n        @inc = grep !/perl_root/i, @inc;\n\n    }\n    elsif ( $self->{_is_win32} ) {\n\t# Lose any trailing backslashes in the Win32 paths\n\ts/[\\\\\\/+]$// foreach @inc;\n    }\n\n    my %seen;\n    $seen{$_}++ foreach $self->_default_inc();\n    @inc = grep !$seen{$_}++, @inc;\n\n    return @inc;\n}\n\n\n{ # Without caching, _default_inc() takes a huge amount of time\n    my %cache;\n    sub _default_inc {\n        my $self = shift;\n        my $perl = $self->_command;\n        $cache{$perl} ||= [do {\n            local $ENV{PERL5LIB};\n            my @inc =`$perl -le \"print join qq[\\\\n], \\@INC\"`;\n            chomp @inc;\n        }];\n        return @{$cache{$perl}};\n    }\n}\n\n\n=for private $strap->_restore_PERL5LIB()\n\n  $self->_restore_PERL5LIB;\n\nThis restores the original value of the C<PERL5LIB> environment variable.\nNecessary on VMS, otherwise a no-op.\n\n\nsub _restore_PERL5LIB {\n    my($self) = shift;\n\n    return unless $self->{_is_vms};\n\n    if (defined $self->{_old5lib}) {\n        $ENV{PERL5LIB} = $self->{_old5lib};\n    }\n}\n\n=head1 Parsing\n\nMethods for identifying what sort of line you're looking at.\n\n=for private _is_diagnostic\n\n    my $is_diagnostic = $strap->_is_diagnostic($line, \\$comment);\n\nChecks if the given line is a comment.  If so, it will place it into\nC<$comment> (sans #).\n\n\nsub _is_diagnostic {\n    my($self, $line, $comment) = @_;\n\n    if( $line =~ /^\\s*\\#(.*)/ ) {\n        $$comment = $1;\n        return $YES;\n    }\n    else {\n        return $NO;\n    }\n}\n\n=for private _is_header\n\n  my $is_header = $strap->_is_header($line);\n\nChecks if the given line is a header (1..M) line.  If so, it places how\nmany tests there will be in C<< $strap->{max} >>, a list of which tests\nare todo in C<< $strap->{todo} >> and if the whole test was skipped\nC<< $strap->{skip_all} >> contains the reason.\n\n\n# Regex for parsing a header.  Will be run with /x\nmy $Extra_Header_Re = <<'REGEX';\n                       ^\n                        (?: \\s+ todo \\s+ ([\\d \\t]+) )?      # optional todo set\n                        (?: \\s* \\# \\s* ([\\w:]+\\s?) (.*) )?     # optional skip with optional reason\nREGEX\n\nsub _is_header {\n    my($self, $line) = @_;\n\n    if( my($max, $extra) = $line =~ /^1\\.\\.(\\d+)(.*)/ ) {\n        $self->{max}  = $max;\n        assert( $self->{max} >= 0,  'Max # of tests looks right' );\n\n        if( defined $extra ) {\n            my($todo, $skip, $reason) = $extra =~ /$Extra_Header_Re/xo;\n\n            $self->{todo} = { map { $_ => 1 } split /\\s+/, $todo } if $todo;\n\n            if( $self->{max} == 0 ) {\n                $reason = '' unless defined $skip and $skip =~ /^Skip/i;\n            }\n\n            $self->{skip_all} = $reason;\n        }\n\n        return $YES;\n    }\n    else {\n        return $NO;\n    }\n}\n\n=for private _is_bail_out\n\n  my $is_bail_out = $strap->_is_bail_out($line, \\$reason);\n\nChecks if the line is a \"Bail out!\".  Places the reason for bailing\n(if any) in $reason.","label":"_is_bail_out($self,$line,$reason)"},"containerName":"main::","definition":"sub","line":583,"children":[{"line":584,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_is_bail_out"},{"kind":13,"line":584,"containerName":"_is_bail_out","name":"$line"},{"kind":13,"line":584,"name":"$reason","containerName":"_is_bail_out"},{"containerName":"_is_bail_out","name":"$line","line":586,"kind":13},{"name":"$YES","containerName":"_is_bail_out","line":588,"kind":13},{"line":591,"kind":13,"containerName":"_is_bail_out","name":"$NO"}],"kind":12,"range":{"start":{"line":583,"character":0},"end":{"character":9999,"line":593}},"name":"_is_bail_out"},{"name":"reason","kind":12,"line":587},{"line":604,"children":[{"name":"$self","definition":"my","containerName":"_reset_file_state","localvar":"my","kind":13,"line":605},{"kind":13,"line":607,"name":"$self","containerName":"_reset_file_state"}],"kind":12,"range":{"end":{"character":9999,"line":607},"start":{"character":0,"line":604}},"containerName":"main::","name":"_reset_file_state","definition":"sub"},{"line":608,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":608,"name":"line"},{"name":"%self","containerName":null,"line":609,"kind":13},{"kind":12,"line":609,"name":"saw_header"},{"containerName":null,"name":"%self","kind":13,"line":610},{"name":"saw_bailout","line":610,"kind":12},{"name":"%self","containerName":null,"line":611,"kind":13},{"line":611,"kind":12,"name":"lone_not_line"},{"name":"%self","containerName":null,"line":612,"kind":13},{"name":"bailout_reason","line":612,"kind":12},{"line":613,"kind":13,"name":"%self","containerName":null},{"range":{"end":{"character":9999,"line":634},"start":{"character":0,"line":631}},"containerName":"main::","definition":"sub","name":"_def_or_blank","line":631,"children":[],"kind":12},{"containerName":"main::","definition":"sub","name":"set_callback","range":{"start":{"character":0,"line":636},"end":{"line":639,"character":9999}},"kind":12,"line":636,"children":[{"line":637,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"set_callback"},{"containerName":"set_callback","name":"$self","kind":13,"line":638}]},{"kind":12,"line":638,"name":"callback"},{"kind":12,"children":[{"kind":13,"line":642,"containerName":"callback","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"callback","line":643,"kind":13}],"line":641,"name":"callback","definition":"sub","containerName":"main::","range":{"end":{"line":644,"character":9999},"start":{"line":641,"character":0}}},{"name":"callback","line":643,"kind":12}],"version":5}