{"vars":[{"kind":2,"line":129,"containerName":"","name":"base"},{"definition":"my","name":"%valid_type","containerName":null,"localvar":"my","kind":13,"line":136},{"kind":12,"line":173,"children":[{"kind":13,"line":174,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":174},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":175},{"kind":13,"line":175,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":175},{"containerName":"new","definition":"my","name":"$seq","localvar":"my","kind":13,"line":177},{"line":177,"kind":13,"name":"$id","containerName":"new"},{"line":177,"kind":13,"name":"$acc","containerName":"new"},{"line":177,"kind":13,"name":"$pid","containerName":"new"},{"kind":13,"line":177,"name":"$ns","containerName":"new"},{"name":"$auth","containerName":"new","kind":13,"line":177},{"line":177,"kind":13,"name":"$v","containerName":"new"},{"containerName":"new","name":"$oid","line":177,"kind":13},{"containerName":"new","name":"$desc","line":178,"kind":13},{"kind":13,"line":178,"containerName":"new","name":"$alphabet"},{"name":"$given_id","containerName":"new","kind":13,"line":178},{"line":178,"kind":13,"containerName":"new","name":"$is_circular"},{"name":"$direct","containerName":"new","kind":13,"line":178},{"kind":13,"line":178,"containerName":"new","name":"$ref_to_seq"},{"containerName":"new","name":"$len","line":178,"kind":13},{"kind":13,"line":179,"name":"$self","containerName":"new"},{"kind":12,"line":179,"name":"_rearrange","containerName":"new"},{"kind":13,"line":195,"containerName":"new","name":"@args"},{"line":196,"kind":13,"containerName":"new","name":"$id"},{"line":196,"kind":13,"containerName":"new","name":"$given_id"},{"name":"$id","containerName":"new","line":197,"kind":13},{"line":197,"kind":13,"name":"$given_id","containerName":"new"},{"line":198,"kind":13,"name":"$self","containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":198},{"name":"$given_id","containerName":"new","kind":13,"line":203},{"name":"$id","containerName":"new","kind":13,"line":203},{"line":203,"kind":13,"name":"$given_id","containerName":"new"},{"line":207,"kind":13,"name":"$len","containerName":"new"},{"containerName":"new","name":"$self","line":207,"kind":13},{"line":207,"kind":12,"containerName":"new","name":"length"},{"containerName":"new","name":"$len","kind":13,"line":207},{"containerName":"new","name":"$alphabet","kind":13,"line":211},{"containerName":"new","name":"$self","kind":13,"line":211},{"name":"alphabet","containerName":"new","line":211,"kind":12},{"name":"$alphabet","containerName":"new","kind":13,"line":211},{"name":"$direct","containerName":"new","line":216,"kind":13},{"kind":13,"line":216,"containerName":"new","name":"$ref_to_seq"},{"kind":13,"line":217,"name":"$self","containerName":"new"},{"kind":13,"line":218,"containerName":"new","name":"$alphabet"},{"line":219,"kind":13,"name":"$self","containerName":"new"},{"name":"_guess_alphabet","containerName":"new","line":219,"kind":12},{"line":224,"kind":13,"containerName":"new","name":"$self"},{"line":224,"kind":12,"name":"seq","containerName":"new"},{"line":224,"kind":13,"containerName":"new","name":"$seq"},{"kind":13,"line":224,"containerName":"new","name":"$seq"},{"containerName":"new","name":"$id","kind":13,"line":227},{"line":227,"kind":13,"containerName":"new","name":"$self"},{"line":227,"kind":12,"name":"display_id","containerName":"new"},{"kind":13,"line":227,"containerName":"new","name":"$id"},{"name":"$acc","containerName":"new","line":228,"kind":13},{"containerName":"new","name":"$self","line":228,"kind":13},{"name":"accession_number","containerName":"new","kind":12,"line":228},{"containerName":"new","name":"$acc","line":228,"kind":13},{"kind":13,"line":229,"containerName":"new","name":"$pid"},{"containerName":"new","name":"$self","line":229,"kind":13},{"name":"primary_id","containerName":"new","line":229,"kind":12},{"containerName":"new","name":"$pid","line":229,"kind":13},{"name":"$desc","containerName":"new","kind":13,"line":230},{"containerName":"new","name":"$self","kind":13,"line":230},{"name":"desc","containerName":"new","line":230,"kind":12},{"line":230,"kind":13,"name":"$desc","containerName":"new"},{"containerName":"new","name":"$is_circular","line":231,"kind":13},{"line":231,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"is_circular","line":231,"kind":12},{"containerName":"new","name":"$is_circular","kind":13,"line":231},{"kind":13,"line":232,"name":"$ns","containerName":"new"},{"line":232,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"namespace","line":232,"kind":12},{"line":232,"kind":13,"containerName":"new","name":"$ns"},{"containerName":"new","name":"$auth","line":233,"kind":13},{"line":233,"kind":13,"containerName":"new","name":"$self"},{"name":"authority","containerName":"new","kind":12,"line":233},{"name":"$auth","containerName":"new","line":233,"kind":13},{"line":234,"kind":13,"name":"$v","containerName":"new"},{"kind":13,"line":234,"containerName":"new","name":"$self"},{"name":"version","containerName":"new","line":234,"kind":12},{"kind":13,"line":234,"containerName":"new","name":"$v"},{"name":"$oid","containerName":"new","line":235,"kind":13},{"name":"$self","containerName":"new","line":235,"kind":13},{"kind":12,"line":235,"name":"object_id","containerName":"new"},{"kind":13,"line":235,"containerName":"new","name":"$oid"},{"line":237,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"name":"new","range":{"end":{"character":9999,"line":238},"start":{"line":173,"character":0}}},{"name":"SUPER","containerName":"new","line":175,"kind":12},{"name":"ref_to_seq","kind":12,"line":217},{"name":"direct_seq_set","definition":"sub","containerName":"main::","range":{"start":{"line":240,"character":0},"end":{"character":9999,"line":244}},"kind":12,"children":[{"name":"$obj","definition":"my","containerName":"direct_seq_set","localvar":"my","kind":13,"line":241},{"line":242,"kind":13,"containerName":"direct_seq_set","name":"$obj"}],"line":240},{"range":{"start":{"line":263,"character":0},"end":{"line":302,"character":9999}},"name":"seq","detail":"($obj,@args)","signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.","parameters":[{"label":"$obj"},{"label":"@args"}],"label":"seq($obj,@args)"},"containerName":"main::","definition":"sub","line":263,"children":[{"containerName":"seq","definition":"my","name":"$obj","localvar":"my","kind":13,"line":264},{"kind":13,"line":264,"containerName":"seq","name":"@args"},{"line":266,"kind":13,"name":"@args","containerName":"seq"},{"line":267,"kind":13,"containerName":"seq","name":"$obj"},{"localvar":"my","containerName":"seq","name":"$value","definition":"my","line":270,"kind":13},{"containerName":"seq","name":"$alphabet","kind":13,"line":270},{"name":"@args","containerName":"seq","line":270,"kind":13},{"name":"@args","containerName":"seq","line":273,"kind":13},{"kind":13,"line":274,"containerName":"seq","name":"$value"},{"containerName":"seq","name":"$obj","line":274,"kind":13},{"name":"validate_seq","containerName":"seq","line":274,"kind":12},{"kind":13,"line":274,"name":"$value","containerName":"seq"},{"line":275,"kind":13,"name":"$obj","containerName":"seq"},{"name":"throw","containerName":"seq","line":275,"kind":12},{"containerName":"seq","name":"$value","kind":13,"line":278},{"kind":13,"line":284,"definition":"my","name":"$is_changed_seq","containerName":"seq","localvar":"my"},{"containerName":"seq","name":"$obj","kind":13,"line":285},{"name":"$value","containerName":"seq","line":285,"kind":13},{"line":286,"kind":13,"name":"$obj","containerName":"seq"},{"name":"$value","containerName":"seq","line":286,"kind":13},{"kind":13,"line":288,"containerName":"seq","name":"$alphabet"},{"kind":13,"line":290,"name":"$obj","containerName":"seq"},{"name":"alphabet","containerName":"seq","line":290,"kind":12},{"line":290,"kind":13,"containerName":"seq","name":"$alphabet"},{"line":292,"kind":13,"name":"$is_changed_seq","containerName":"seq"},{"containerName":"seq","name":"$obj","kind":13,"line":294},{"name":"alphabet","containerName":"seq","line":294,"kind":12},{"kind":13,"line":296,"containerName":"seq","name":"$obj"},{"containerName":"seq","name":"_guess_alphabet","kind":12,"line":296},{"containerName":"seq","name":"$obj","kind":13,"line":299},{"containerName":"seq","name":"length","kind":12,"line":299},{"line":299,"kind":13,"name":"$is_changed_seq","containerName":"seq"},{"line":301,"kind":13,"name":"$obj","containerName":"seq"}],"kind":12},{"line":285,"kind":12,"containerName":"length","name":"CORE"},{"line":326,"children":[{"kind":13,"line":327,"definition":"my","name":"$self","containerName":"validate_seq","localvar":"my"},{"kind":13,"line":327,"name":"$seqstr","containerName":"validate_seq"},{"containerName":"validate_seq","name":"$seqstr","line":328,"kind":13},{"name":"$seqstr","containerName":"validate_seq","kind":13,"line":328},{"line":328,"kind":13,"containerName":"validate_seq","name":"$self"},{"kind":12,"line":328,"containerName":"validate_seq","name":"seq"},{"kind":13,"line":329,"name":"$seqstr","containerName":"validate_seq"},{"kind":13,"line":330,"name":"$seqstr","containerName":"validate_seq"},{"containerName":"validate_seq","name":"$seqstr","kind":13,"line":330},{"name":"$self","containerName":"validate_seq","line":331,"kind":13},{"name":"warn","containerName":"validate_seq","kind":12,"line":331},{"containerName":"validate_seq","name":"$seqstr","kind":13,"line":332}],"kind":12,"detail":"($self,$seqstr)","signature":{"parameters":[{"label":"$self"},{"label":"$seqstr"}],"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.","label":"validate_seq($self,$seqstr)"},"containerName":"main::","definition":"sub","range":{"start":{"line":326,"character":0},"end":{"line":336,"character":9999}},"name":"validate_seq"},{"line":330,"kind":12,"name":"CORE","containerName":"length"},{"definition":"sub","containerName":"main::","signature":{"label":"subseq($self,$start,$end,$replace)","documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"},{"label":"$replace"}]},"detail":"($self,$start,$end,$replace)","kind":12,"children":[{"line":354,"kind":13,"localvar":"my","containerName":"subseq","definition":"my","name":"$self"},{"kind":13,"line":354,"name":"$start","containerName":"subseq"},{"containerName":"subseq","name":"$end","line":354,"kind":13},{"containerName":"subseq","name":"$replace","line":354,"kind":13},{"name":"$start","containerName":"subseq","kind":13,"line":356},{"kind":13,"line":356,"name":"$start","containerName":"subseq"},{"kind":12,"line":356,"name":"isa","containerName":"subseq"},{"line":357,"kind":13,"localvar":"my","containerName":"subseq","name":"$loc","definition":"my"},{"kind":13,"line":357,"containerName":"subseq","name":"$start"},{"containerName":"subseq","name":"$replace","kind":13,"line":358},{"containerName":"subseq","name":"$end","kind":13,"line":358},{"localvar":"my","containerName":"subseq","definition":"my","name":"$seq","line":359,"kind":13},{"line":360,"kind":13,"localvar":"my","containerName":"subseq","name":"$subloc","definition":"my"},{"kind":13,"line":360,"name":"$loc","containerName":"subseq"},{"name":"each_Location","containerName":"subseq","line":360,"kind":12},{"kind":13,"line":361,"definition":"my","name":"$piece","containerName":"subseq","localvar":"my"},{"name":"$self","containerName":"subseq","kind":13,"line":361},{"kind":12,"line":361,"containerName":"subseq","name":"subseq"},{"kind":13,"line":361,"containerName":"subseq","name":"$subloc"},{"line":361,"kind":12,"containerName":"subseq","name":"start"},{"containerName":"subseq","name":"$subloc","line":362,"kind":13},{"line":362,"kind":12,"name":"end","containerName":"subseq"},{"line":362,"kind":13,"name":"$replace","containerName":"subseq"},{"kind":13,"line":363,"name":"$subloc","containerName":"subseq"},{"line":363,"kind":12,"containerName":"subseq","name":"strand"},{"kind":13,"line":364,"name":"$piece","containerName":"subseq"},{"kind":12,"line":364,"containerName":"subseq","name":"new"},{"containerName":"subseq","name":"$piece","line":364,"kind":13},{"kind":12,"line":364,"containerName":"subseq","name":"revcom"},{"kind":12,"line":364,"containerName":"subseq","name":"seq"},{"containerName":"subseq","name":"$seq","line":366,"kind":13},{"name":"$piece","containerName":"subseq","kind":13,"line":366},{"kind":13,"line":368,"name":"$seq","containerName":"subseq"},{"kind":13,"line":369,"containerName":"subseq","name":"$start"},{"kind":13,"line":369,"containerName":"subseq","name":"$end"},{"containerName":"subseq","name":"$start","line":370,"kind":13},{"kind":13,"line":370,"name":"$end","containerName":"subseq"},{"kind":13,"line":371,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"throw","line":371,"kind":12},{"containerName":"subseq","name":"$start","kind":13,"line":376},{"kind":13,"line":377,"name":"$self","containerName":"subseq"},{"line":377,"kind":12,"name":"throw","containerName":"subseq"},{"kind":13,"line":381,"containerName":"subseq","name":"$end"},{"line":381,"kind":13,"name":"$self","containerName":"subseq"},{"name":"length","containerName":"subseq","line":381,"kind":12},{"kind":13,"line":382,"name":"$self","containerName":"subseq"},{"name":"throw","containerName":"subseq","kind":12,"line":382},{"kind":13,"line":385,"containerName":"subseq","name":"$self"},{"kind":12,"line":385,"containerName":"subseq","name":"length"},{"line":386,"kind":13,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"length","kind":12,"line":386},{"kind":13,"line":390,"containerName":"subseq","name":"$start"},{"kind":13,"line":391,"containerName":"subseq","name":"$replace"},{"name":"$self","containerName":"subseq","line":392,"kind":13},{"line":392,"kind":12,"name":"seq","containerName":"subseq"},{"line":392,"kind":13,"name":"$start","containerName":"subseq"},{"name":"$end","containerName":"subseq","line":392,"kind":13},{"name":"$start","containerName":"subseq","kind":13,"line":392},{"line":392,"kind":13,"name":"$replace","containerName":"subseq"},{"kind":13,"line":394,"name":"$self","containerName":"subseq"},{"containerName":"subseq","name":"seq","line":394,"kind":12},{"kind":13,"line":394,"containerName":"subseq","name":"$start"},{"line":394,"kind":13,"name":"$end","containerName":"subseq"},{"kind":13,"line":394,"name":"$start","containerName":"subseq"},{"name":"$self","containerName":"subseq","line":397,"kind":13},{"containerName":"subseq","name":"warn","kind":12,"line":397}],"line":353,"name":"subseq","range":{"end":{"line":400,"character":9999},"start":{"line":353,"character":0}}},{"containerName":"PrimarySeq","name":"Bio","line":364,"kind":12},{"kind":12,"line":429,"children":[{"line":430,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"length"},{"kind":13,"line":431,"name":"$len","definition":"my","containerName":"length","localvar":"my"},{"line":431,"kind":13,"name":"$self","containerName":"length"},{"line":431,"kind":12,"containerName":"length","name":"seq"},{"localvar":"my","containerName":"length","definition":"my","name":"$val","line":434,"kind":13},{"line":435,"kind":13,"name":"$val","containerName":"length"},{"line":435,"kind":13,"name":"$len","containerName":"length"},{"kind":13,"line":435,"name":"$len","containerName":"length"},{"containerName":"length","name":"$val","kind":13,"line":435},{"kind":13,"line":436,"name":"$self","containerName":"length"},{"name":"throw","containerName":"length","kind":12,"line":436},{"line":438,"kind":13,"containerName":"length","name":"$val"},{"name":"$val","containerName":"length","line":439,"kind":13},{"kind":13,"line":441,"containerName":"length","name":"$self"},{"kind":13,"line":441,"name":"$val","containerName":"length"},{"line":442,"kind":13,"name":"$self","containerName":"length"},{"containerName":"length","name":"$self","line":443,"kind":13},{"kind":13,"line":445,"name":"$len","containerName":"length"}],"containerName":"main::","name":"length","definition":"sub","range":{"end":{"character":9999,"line":446},"start":{"character":0,"line":429}}},{"containerName":"length","name":"CORE","line":431,"kind":12},{"name":"display_id","range":{"start":{"line":474,"character":0},"end":{"line":481,"character":9999}},"kind":12,"line":474,"children":[{"kind":13,"line":475,"containerName":"display_id","name":"$obj","definition":"my","localvar":"my"},{"kind":13,"line":475,"containerName":"display_id","name":"$value"},{"name":"$value","containerName":"display_id","line":476,"kind":13},{"kind":13,"line":477,"containerName":"display_id","name":"$obj"},{"containerName":"display_id","name":"$value","kind":13,"line":477},{"line":479,"kind":13,"name":"$obj","containerName":"display_id"}],"containerName":"main::","definition":"sub","detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None","label":"display_id($obj,$value)"}},{"children":[{"localvar":"my","name":"$obj","definition":"my","containerName":"accession_number","line":508,"kind":13},{"line":508,"kind":13,"containerName":"accession_number","name":"$acc"},{"line":510,"kind":13,"name":"$acc","containerName":"accession_number"},{"line":511,"kind":13,"containerName":"accession_number","name":"$obj"},{"kind":13,"line":511,"name":"$acc","containerName":"accession_number"},{"line":513,"kind":13,"containerName":"accession_number","name":"$acc"},{"containerName":"accession_number","name":"$obj","line":513,"kind":13},{"containerName":"accession_number","name":"$acc","kind":13,"line":514},{"line":514,"kind":13,"containerName":"accession_number","name":"$acc"},{"line":516,"kind":13,"name":"$acc","containerName":"accession_number"}],"line":507,"kind":12,"signature":{"parameters":[{"label":"$obj"},{"label":"$acc"}],"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting","label":"accession_number($obj,$acc)"},"detail":"($obj,$acc)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":507},"end":{"line":517,"character":9999}},"name":"accession_number"},{"definition":"sub","containerName":"main::","signature":{"label":"primary_id($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)"},"detail":"($obj,$value)","kind":12,"children":[{"kind":13,"line":537,"containerName":"primary_id","name":"$obj","definition":"my","localvar":"my"},{"kind":13,"line":537,"containerName":"primary_id","name":"$value"},{"line":538,"kind":13,"name":"$value","containerName":"primary_id"},{"name":"$obj","containerName":"primary_id","line":539,"kind":13},{"line":539,"kind":13,"containerName":"primary_id","name":"$value"},{"name":"$obj","containerName":"primary_id","kind":13,"line":541},{"line":544,"kind":13,"containerName":"primary_id","name":"$obj"}],"line":536,"name":"primary_id","range":{"start":{"line":536,"character":0},"end":{"character":9999,"line":546}}},{"children":[{"kind":13,"line":570,"name":"$obj","definition":"my","containerName":"alphabet","localvar":"my"},{"kind":13,"line":570,"containerName":"alphabet","name":"$value"},{"line":571,"kind":13,"name":"$value","containerName":"alphabet"},{"line":572,"kind":13,"name":"$value","containerName":"alphabet"},{"line":572,"kind":13,"name":"$value","containerName":"alphabet"},{"kind":13,"line":573,"containerName":"alphabet","name":"$valid_type"},{"containerName":"alphabet","name":"$value","line":573,"kind":13},{"containerName":"alphabet","name":"$obj","line":574,"kind":13},{"kind":12,"line":574,"name":"throw","containerName":"alphabet"},{"containerName":"alphabet","name":"%valid_type","line":576,"kind":13},{"line":577,"kind":13,"containerName":"alphabet","name":"$value"},{"containerName":"alphabet","name":"$obj","line":579,"kind":13},{"kind":13,"line":579,"containerName":"alphabet","name":"$value"},{"name":"$obj","containerName":"alphabet","line":581,"kind":13}],"line":569,"kind":12,"signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   if( ! exists $obj->{'primary_id'} ) {\n       return \"$obj\";\n   }\n   return $obj->{'primary_id'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : (for setting) string of 'dna','rna', or 'protein'\n Throws  : Bio::Root::BadParameter if the supplied value\n           is not a valid type. The offending value is placed within\n           the -value field of the Error object.","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"alphabet($obj,$value)"},"detail":"($obj,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":582,"character":9999},"start":{"line":569,"character":0}},"name":"alphabet"},{"kind":12,"children":[{"kind":13,"line":601,"name":"$self","definition":"my","containerName":"desc","localvar":"my"},{"line":603,"kind":13,"containerName":"desc","name":"$self"},{"containerName":"desc","name":"$self","kind":13,"line":604}],"line":600,"name":"desc","definition":"sub","containerName":"main::","range":{"start":{"line":600,"character":0},"end":{"line":605,"character":9999}}},{"signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   if( ! exists $obj->{'primary_id'} ) {\n       return \"$obj\";\n   }\n   return $obj->{'primary_id'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : (for setting) string of 'dna','rna', or 'protein'\n Throws  : Bio::Root::BadParameter if the supplied value\n           is not a valid type. The offending value is placed within\n           the -value field of the Error object.\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t$value = lc $value;\n\tunless ( $valid_type{$value} ) {\n\t    $obj->throw(-class => 'Bio::Root::BadParameter',\n                        -text => \"Alphabet type '$value' is not a valid type (\".\n\t\t\tjoin(',', map \"'$_'\", sort keys %valid_type) .\") lowercase\",\n                        -value => $value);\n\t}\n\t$obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           description is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :","parameters":[{"label":"$self"}],"label":"can_call_new($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"can_call_new","definition":"my","name":"$self","localvar":"my","kind":13,"line":620}],"line":619,"kind":12,"range":{"end":{"line":624,"character":9999},"start":{"character":0,"line":619}},"name":"can_call_new"},{"kind":12,"children":[{"line":639,"kind":12,"containerName":"id","name":"display_id"}],"line":638,"definition":"sub","name":"id","containerName":"main::","range":{"end":{"character":9999,"line":640},"start":{"line":638,"character":0}}},{"line":660,"children":[{"containerName":"object_id","name":"accession_number","line":661,"kind":12}],"kind":12,"range":{"start":{"character":0,"line":660},"end":{"character":9999,"line":662}},"containerName":"main::","definition":"sub","name":"object_id"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   if( ! exists $obj->{'primary_id'} ) {\n       return \"$obj\";\n   }\n   return $obj->{'primary_id'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : (for setting) string of 'dna','rna', or 'protein'\n Throws  : Bio::Root::BadParameter if the supplied value\n           is not a valid type. The offending value is placed within\n           the -value field of the Error object.\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t$value = lc $value;\n\tunless ( $valid_type{$value} ) {\n\t    $obj->throw(-class => 'Bio::Root::BadParameter',\n                        -text => \"Alphabet type '$value' is not a valid type (\".\n\t\t\tjoin(',', map \"'$_'\", sort keys %valid_type) .\") lowercase\",\n                        -value => $value);\n\t}\n\t$obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           description is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number","parameters":[{"label":"$self"},{"label":"$value"}],"label":"version($self,$value)"},"kind":12,"line":677,"children":[{"containerName":"version","definition":"my","name":"$self","localvar":"my","kind":13,"line":678},{"containerName":"version","name":"$value","kind":13,"line":678},{"containerName":"version","name":"$value","kind":13,"line":679},{"containerName":"version","name":"$self","kind":13,"line":680},{"kind":13,"line":680,"containerName":"version","name":"$value"},{"kind":13,"line":682,"name":"$self","containerName":"version"}],"name":"version","range":{"start":{"character":0,"line":677},"end":{"character":9999,"line":683}}},{"range":{"start":{"character":0,"line":698},"end":{"line":704,"character":9999}},"name":"authority","line":698,"children":[{"line":699,"kind":13,"localvar":"my","containerName":"authority","definition":"my","name":"$obj"},{"name":"$value","containerName":"authority","kind":13,"line":699},{"name":"$value","containerName":"authority","line":700,"kind":13},{"line":701,"kind":13,"containerName":"authority","name":"$obj"},{"containerName":"authority","name":"$value","line":701,"kind":13},{"kind":13,"line":703,"name":"$obj","containerName":"authority"}],"kind":12,"detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   if( ! exists $obj->{'primary_id'} ) {\n       return \"$obj\";\n   }\n   return $obj->{'primary_id'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : (for setting) string of 'dna','rna', or 'protein'\n Throws  : Bio::Root::BadParameter if the supplied value\n           is not a valid type. The offending value is placed within\n           the -value field of the Error object.\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t$value = lc $value;\n\tunless ( $valid_type{$value} ) {\n\t    $obj->throw(-class => 'Bio::Root::BadParameter',\n                        -text => \"Alphabet type '$value' is not a valid type (\".\n\t\t\tjoin(',', map \"'$_'\", sort keys %valid_type) .\") lowercase\",\n                        -value => $value);\n\t}\n\t$obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           description is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar","label":"authority($obj,$value)"},"containerName":"main::","definition":"sub"},{"name":"namespace","range":{"end":{"character":9999,"line":725},"start":{"character":0,"line":719}},"kind":12,"line":719,"children":[{"kind":13,"line":720,"containerName":"namespace","definition":"my","name":"$self","localvar":"my"},{"line":720,"kind":13,"containerName":"namespace","name":"$value"},{"name":"$value","containerName":"namespace","line":721,"kind":13},{"line":722,"kind":13,"containerName":"namespace","name":"$self"},{"line":722,"kind":13,"name":"$value","containerName":"namespace"},{"containerName":"namespace","name":"$self","kind":13,"line":724}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"namespace($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   if( ! exists $obj->{'primary_id'} ) {\n       return \"$obj\";\n   }\n   return $obj->{'primary_id'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : (for setting) string of 'dna','rna', or 'protein'\n Throws  : Bio::Root::BadParameter if the supplied value\n           is not a valid type. The offending value is placed within\n           the -value field of the Error object.\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t$value = lc $value;\n\tunless ( $valid_type{$value} ) {\n\t    $obj->throw(-class => 'Bio::Root::BadParameter',\n                        -text => \"Alphabet type '$value' is not a valid type (\".\n\t\t\tjoin(',', map \"'$_'\", sort keys %valid_type) .\") lowercase\",\n                        -value => $value);\n\t}\n\t$obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           description is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n\n\nsub authority {\n    my ($obj,$value) = @_;\n    if( defined $value) {\n\t$obj->{'authority'} = $value;\n    }\n    return $obj->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar"}},{"definition":"sub","name":"display_name","containerName":"main::","range":{"end":{"line":750,"character":9999},"start":{"character":0,"line":748}},"kind":12,"children":[{"line":749,"kind":12,"name":"display_id","containerName":"display_name"}],"line":748},{"range":{"start":{"character":0,"line":768},"end":{"character":9999,"line":770}},"containerName":"main::","definition":"sub","name":"description","line":768,"children":[{"kind":12,"line":769,"name":"desc","containerName":"description"}],"kind":12},{"name":"_guess_alphabet","range":{"start":{"line":836,"character":0},"end":{"character":9999,"line":864}},"kind":12,"children":[{"line":837,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_guess_alphabet"},{"line":838,"kind":13,"localvar":"my","name":"$str","definition":"my","containerName":"_guess_alphabet"},{"containerName":"_guess_alphabet","name":"$str2","kind":13,"line":838},{"line":838,"kind":13,"name":"$total","containerName":"_guess_alphabet"},{"line":838,"kind":13,"name":"$atgc","containerName":"_guess_alphabet"},{"containerName":"_guess_alphabet","name":"$u","line":838,"kind":13},{"name":"$type","containerName":"_guess_alphabet","line":838,"kind":13},{"kind":13,"line":840,"containerName":"_guess_alphabet","name":"$str"},{"line":840,"kind":13,"containerName":"_guess_alphabet","name":"$self"},{"line":840,"kind":12,"containerName":"_guess_alphabet","name":"seq"},{"line":841,"kind":13,"name":"$str","containerName":"_guess_alphabet"},{"kind":13,"line":843,"name":"$total","containerName":"_guess_alphabet"},{"line":843,"kind":13,"name":"$str","containerName":"_guess_alphabet"},{"line":844,"kind":13,"containerName":"_guess_alphabet","name":"$total"},{"line":845,"kind":13,"containerName":"_guess_alphabet","name":"$self"},{"name":"throw","containerName":"_guess_alphabet","line":845,"kind":12},{"kind":13,"line":848,"containerName":"_guess_alphabet","name":"$str"},{"name":"$u","containerName":"_guess_alphabet","kind":13,"line":851},{"name":"$str","containerName":"_guess_alphabet","kind":13,"line":851},{"line":852,"kind":13,"name":"$atgc","containerName":"_guess_alphabet"},{"kind":13,"line":852,"containerName":"_guess_alphabet","name":"$str"},{"line":854,"kind":13,"name":"$atgc","containerName":"_guess_alphabet"},{"line":854,"kind":13,"name":"$total","containerName":"_guess_alphabet"},{"name":"$type","containerName":"_guess_alphabet","kind":13,"line":855},{"containerName":"_guess_alphabet","name":"$atgc","line":856,"kind":13},{"line":856,"kind":13,"containerName":"_guess_alphabet","name":"$u"},{"name":"$total","containerName":"_guess_alphabet","kind":13,"line":856},{"line":857,"kind":13,"name":"$type","containerName":"_guess_alphabet"},{"name":"$type","containerName":"_guess_alphabet","line":859,"kind":13},{"name":"$self","containerName":"_guess_alphabet","line":862,"kind":13},{"name":"alphabet","containerName":"_guess_alphabet","kind":12,"line":862},{"kind":13,"line":862,"name":"$type","containerName":"_guess_alphabet"},{"name":"$type","containerName":"_guess_alphabet","kind":13,"line":863}],"line":836,"definition":"sub","containerName":"main::","signature":{"label":"_guess_alphabet($self)","documentation":"1;\n# $Id: PrimarySeq.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # The Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  #make from memory\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n\t\t\t\t   -id  => 'GeneFragment-12',\n\t\t\t\t   -accession_number => 'X78121',\n\t\t\t\t   -alphabet => 'dna',\n\t\t\t\t   -is_circular => 1\n\t\t\t\t   );\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",-format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \", \n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing little more than\nthe sequence, its name, a computer useful unique name. It does not\ncontain sequence features or other information.  To have a sequence\nwith sequence features you should use the Seq object which uses this\nobject - go perldoc Bio::Seq\n\nAlthough newusers will use Bio::PrimarySeq alot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\ngo perldoc Bio::Seq. For interest you might like to known that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface (if that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish). If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documenation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n \nPlease direct usage questions or support issues to the mailing list:\n  \nL<bioperl-l@bioperl.org>\n  \nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@sanger.ac.uk\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t  Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name) \n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -desc        => description text\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n Throws  : Bio::Root::BadParameter if both -id and -display_id\n           parameters are supplied and they are not the same.\n           You only need to supply one of these parameters.\n           -display_id is preferred and is synonymous with -id.\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n\t\t\t      )],\n\t\t\t  @args);\n    if( defined $id && defined $given_id ) {\n\tif( $id ne $given_id ) {\n\t    $self->throw(-class => 'Bio::Root::BadParameter',\n                         -text => \"Provided conflicting id and display_id constructor arguments. [id=$id] [display_id=$given_id]\",\n                         -value => \"id=$id, display_id=$given_id\");\t\n\t}\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n    \n    # if there is an alphabet, and direct is passed in, assumme the alphabet\n    # and sequence is ok \n\n    if( $direct && $ref_to_seq) {\n\t$self->{'seq'} = $$ref_to_seq;\n\tif( ! $alphabet ) {\n\t    $self->_guess_alphabet();\n\t} # else it has been set already above\n    } else {\n#\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t# note: the sequence string may be empty\n\t$self->seq($seq) if defined($seq);\n    }\n\n    $id          && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n           Both parameters may also be given in named paramater style\n           with -seq and -alphabet being the names.\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(-class => 'Bio::Root::BadParameter',\n                       -text => \"Attempting to set the sequence to [$value] \".\n\t\t                \"which does not look healthy\",\n                       -value => $value);\n       }\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n       my $is_changed_seq =\n\t   exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n       $obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n       if($alphabet) {\n\t   # yes, set it no matter what\n\t   $obj->alphabet($alphabet);\n       } elsif( # if we changed a previous sequence to a new one\n\t\t$is_changed_seq ||\n\t\t# or if there is no alphabet yet at all\n\t\t(! defined($obj->alphabet()))) {\n\t   # we need to guess the (possibly new) alphabet\n\t   $obj->_guess_alphabet();\n       } # else (seq not changed and alphabet was defined) do nothing\n       # if the seq is changed, make sure we unset a possibly set length\n       $obj->length(undef) if $is_changed_seq;\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of \n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.', '*' and '?'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n    my ($self,$seqstr) = @_;\n    if( ! defined $seqstr ){ $seqstr = $self->seq(); }\n    return 0 unless( defined $seqstr); \n    if((CORE::length($seqstr) > 0) && ($seqstr !~ /^([A-Za-z\\-\\.\\*\\?]+)$/)) {\n\t$self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t   ($seqstr =~ /([^A-Za-z\\-\\.\\*\\?]+)/g));\n\treturn 0;\n    }\n    return 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n Function: returns the subseq from start to end, where the first base\n           is 1 and the number is inclusive, ie 1-2 are the first two\n           bases of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n\n\nsub subseq {\n   my ($self,$start,$end,$replace) = @_;\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       $replace = $end; # do we really use this anywhere? scary. HL\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq($subloc->start(),\n\t\t\t\t     $subloc->end(), $replace);\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text  => \"in subseq, start [$start] has to be \".\n\t\t\t          \"less than end [$end]\",\n\t\t\t-value => \"start=$start, end=$end\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"start must be positive [start=$start]\",\n\t\t\t-value => \"start=$start\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(-class => 'Bio::Root::BadParameter',\n\t\t\t-text=>\"length must be less than the total length \".\n\t\t\t       \"of sequence [start=$start, end=$end] \".\n\t\t\t       \"Total=\".$self->length.\"\",\n\t\t\t-value =>$self->length );\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       if( defined $replace ) {\n\t   return substr( $self->seq(), $start, ($end-$start), $replace);\n       } else {\n\t   return substr( $self->seq(), $start, ($end-$start));\n       }\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers \".\n\t\t   \"or a Bio::LocationI object not ($start,$end)\");\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n    \n    if(@_) {\n\tmy $val = shift;\n\tif(defined($val) && $len && ($len != $val)) {\n\t    $self->throw(-class=>'Bio::Root::BadParameter',\n\t\t\t -text=>\"You're trying to lie about the length: \".\n\t\t\t        \"is $len but you say \".$val,\n\t\t\t -value=>$val);\n\t}\n\t$self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\treturn $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n    }\n    return $obj->{'display_id'};\n\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased \n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n        $obj->{'accession_number'} = $acc;\n    } else {\n        $acc = $obj->{'accession_number'};\n        $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'primary_id'} = $value;\n    }\n   if( ! exists $obj->{'primary_id'} ) {\n       return \"$obj\";\n   }\n   return $obj->{'primary_id'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Returns the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : (for setting) string of 'dna','rna', or 'protein'\n Throws  : Bio::Root::BadParameter if the supplied value\n           is not a valid type. The offending value is placed within\n           the -value field of the Error object.\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t$value = lc $value;\n\tunless ( $valid_type{$value} ) {\n\t    $obj->throw(-class => 'Bio::Root::BadParameter',\n                        -text => \"Alphabet type '$value' is not a valid type (\".\n\t\t\tjoin(',', map \"'$_'\", sort keys %valid_type) .\") lowercase\",\n                        -value => $value);\n\t}\n\t$obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           description is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n\n\nsub authority {\n    my ($obj,$value) = @_;\n    if( defined $value) {\n\t$obj->{'authority'} = $value;\n    }\n    return $obj->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n\n\n\nsub namespace{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'namespace'} = $value;\n    }\n    return $self->{'namespace'} || \"\";\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\nThis comprises of display_name and description.\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods Inherited from Bio::PrimarySeqI\n\nThese methods are available on Bio::PrimarySeq, although they are\nactually implemented on Bio::PrimarySeqI\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::SeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of\n           \"Sequence is a protein. Cannot revcom\"\n\n           The id is the same id as the orginal sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions\n\n           To do an inplace edit of an object you can go:\n\n           $seqobj = $seqobj->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::SeqI object\n Args    : none\n\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::SeqI implementing object\n Args    :\n\n\n\n=head1 Internal methods\n\nThese are internal methods to PrimarySeq\n\n\n=head2 _guess_alphabet\n\n Title   : _guess_alphabet\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n Throws  : Bio::Root::BadParameter if the string obtained from \n           PrimarySeq::seq() is empty. ","parameters":[{"label":"$self"}]},"detail":"($self)"},{"kind":12,"line":843,"name":"CORE","containerName":"length"},{"containerName":"main::","definition":"sub","name":"accession","range":{"start":{"line":870,"character":0},"end":{"line":876,"character":9999}},"kind":12,"line":870,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"accession","line":871,"kind":13},{"name":"$self","containerName":"accession","line":873,"kind":13},{"containerName":"accession","name":"warn","line":873,"kind":12},{"containerName":"accession","name":"$self","kind":13,"line":873},{"containerName":"accession","name":"$self","kind":13,"line":875},{"line":875,"kind":12,"name":"accession_number","containerName":"accession"}]}],"version":5}