{"vars":[{"line":109,"kind":2,"containerName":"","name":"base"},{"name":"id","range":{"start":{"line":126,"character":0},"end":{"line":131,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"id($self)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":126,"children":[{"line":127,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"id"},{"localvar":"my","definition":"my","name":"@ids","containerName":"id","line":128,"kind":13},{"kind":13,"line":128,"containerName":"id","name":"$self"},{"name":"each_DBLink","containerName":"id","line":128,"kind":12},{"line":129,"kind":13,"localvar":"my","containerName":"id","name":"$id","definition":"my"},{"kind":13,"line":129,"containerName":"id","name":"$ids"},{"line":129,"kind":13,"containerName":"id","name":"@ids"},{"line":130,"kind":13,"name":"$id","containerName":"id"},{"kind":12,"line":130,"containerName":"id","name":"database"},{"containerName":"id","name":"$id","kind":13,"line":130},{"line":130,"kind":12,"name":"primary_id","containerName":"id"},{"kind":13,"line":130,"name":"$id","containerName":"id"}]},{"range":{"start":{"character":0,"line":152},"end":{"line":169,"character":9999}},"name":"add_Allele","detail":"($self,$value)","signature":{"label":"add_Allele($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object"},"containerName":"main::","definition":"sub","line":152,"children":[{"kind":13,"line":153,"definition":"my","name":"$self","containerName":"add_Allele","localvar":"my"},{"kind":13,"line":153,"name":"$value","containerName":"add_Allele"},{"containerName":"add_Allele","name":"$value","line":154,"kind":13},{"name":"$value","containerName":"add_Allele","kind":13,"line":155},{"containerName":"add_Allele","name":"isa","kind":12,"line":155},{"localvar":"my","definition":"my","name":"$com","containerName":"add_Allele","line":156,"kind":13},{"kind":13,"line":156,"name":"$value","containerName":"add_Allele"},{"kind":13,"line":157,"containerName":"add_Allele","name":"$self"},{"containerName":"add_Allele","name":"throw","line":157,"kind":12},{"name":"$self","containerName":"add_Allele","line":160,"kind":13},{"kind":12,"line":160,"name":"isa","containerName":"add_Allele"},{"containerName":"add_Allele","name":"$value","line":161,"kind":13},{"containerName":"add_Allele","name":"seq","line":161,"kind":12},{"containerName":"add_Allele","name":"$value","kind":13,"line":161},{"kind":12,"line":161,"name":"seq","containerName":"add_Allele"},{"name":"$value","containerName":"add_Allele","kind":13,"line":161},{"name":"seq","containerName":"add_Allele","line":161,"kind":12},{"containerName":"add_Allele","name":"$value","kind":13,"line":163},{"line":163,"kind":12,"containerName":"add_Allele","name":"seq"},{"line":163,"kind":13,"containerName":"add_Allele","name":"$value"},{"line":163,"kind":12,"containerName":"add_Allele","name":"seq"},{"name":"$value","containerName":"add_Allele","line":163,"kind":13},{"containerName":"add_Allele","name":"seq","kind":12,"line":163},{"line":165,"kind":13,"name":"$self","containerName":"add_Allele"},{"containerName":"add_Allele","name":"$value","line":165,"kind":13},{"line":166,"kind":13,"name":"$self","containerName":"add_Allele"},{"containerName":"add_Allele","name":"allele_mut","kind":12,"line":166},{"line":166,"kind":13,"name":"$value","containerName":"add_Allele"}],"kind":12},{"kind":12,"children":[{"line":190,"kind":13,"localvar":"my","containerName":"each_Allele","definition":"my","name":"$self"},{"name":"@args","containerName":"each_Allele","kind":13,"line":190},{"containerName":"each_Allele","name":"$self","line":191,"kind":13}],"line":189,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"each_Allele($self,@args)"},"detail":"($self,@args)","name":"each_Allele","range":{"start":{"character":0,"line":189},"end":{"line":191,"character":9999}}},{"children":[{"kind":13,"line":212,"definition":"my","name":"$self","containerName":"isMutation","localvar":"my"},{"containerName":"isMutation","name":"$value","line":212,"kind":13},{"name":"$value","containerName":"isMutation","line":213,"kind":13},{"name":"$value","containerName":"isMutation","kind":13,"line":214},{"containerName":"isMutation","name":"$self","line":215,"kind":13},{"containerName":"isMutation","name":"$self","kind":13,"line":217},{"kind":13,"line":220,"name":"$self","containerName":"isMutation"}],"line":211,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean","label":"isMutation($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":221,"character":9999},"start":{"line":211,"character":0}},"name":"isMutation"},{"range":{"end":{"character":9999,"line":260},"start":{"character":0,"line":245}},"name":"allele_ori","children":[{"definition":"my","name":"$self","containerName":"allele_ori","localvar":"my","kind":13,"line":246},{"line":246,"kind":13,"name":"$value","containerName":"allele_ori"},{"name":"$value","containerName":"allele_ori","line":247,"kind":13},{"line":248,"kind":13,"name":"$value","containerName":"allele_ori"},{"line":248,"kind":13,"containerName":"allele_ori","name":"$value"},{"kind":12,"line":248,"containerName":"allele_ori","name":"isa"},{"name":"$self","containerName":"allele_ori","line":249,"kind":13},{"containerName":"allele_ori","name":"throw","line":249,"kind":12},{"kind":13,"line":251,"containerName":"allele_ori","name":"$self"},{"kind":12,"line":251,"name":"isa","containerName":"allele_ori"},{"containerName":"allele_ori","name":"$value","kind":13,"line":252},{"line":252,"kind":12,"name":"seq","containerName":"allele_ori"},{"name":"$value","containerName":"allele_ori","line":252,"kind":13},{"kind":12,"line":252,"name":"seq","containerName":"allele_ori"},{"name":"$value","containerName":"allele_ori","line":252,"kind":13},{"containerName":"allele_ori","name":"seq","line":252,"kind":12},{"containerName":"allele_ori","name":"$value","line":254,"kind":13},{"name":"seq","containerName":"allele_ori","line":254,"kind":12},{"containerName":"allele_ori","name":"$value","line":254,"kind":13},{"line":254,"kind":12,"name":"seq","containerName":"allele_ori"},{"containerName":"allele_ori","name":"$value","kind":13,"line":254},{"line":254,"kind":12,"containerName":"allele_ori","name":"seq"},{"line":256,"kind":13,"containerName":"allele_ori","name":"$self"},{"line":256,"kind":13,"containerName":"allele_ori","name":"$value"},{"line":259,"kind":13,"containerName":"allele_ori","name":"$self"}],"line":245,"kind":12,"signature":{"label":"allele_ori($self,$value)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"line":286,"kind":13,"localvar":"my","containerName":"allele_mut","name":"$self","definition":"my"},{"containerName":"allele_mut","name":"$value","line":286,"kind":13},{"containerName":"allele_mut","name":"$value","line":287,"kind":13},{"line":288,"kind":13,"containerName":"allele_mut","name":"$value"},{"kind":13,"line":288,"containerName":"allele_mut","name":"$value"},{"containerName":"allele_mut","name":"isa","kind":12,"line":288},{"kind":13,"line":289,"containerName":"allele_mut","name":"$self"},{"line":289,"kind":12,"name":"throw","containerName":"allele_mut"},{"line":291,"kind":13,"containerName":"allele_mut","name":"$self"},{"line":291,"kind":12,"name":"isa","containerName":"allele_mut"},{"line":292,"kind":13,"name":"$value","containerName":"allele_mut"},{"name":"seq","containerName":"allele_mut","kind":12,"line":292},{"kind":13,"line":292,"containerName":"allele_mut","name":"$value"},{"name":"seq","containerName":"allele_mut","kind":12,"line":292},{"kind":13,"line":292,"name":"$value","containerName":"allele_mut"},{"line":292,"kind":12,"containerName":"allele_mut","name":"seq"},{"kind":13,"line":294,"name":"$value","containerName":"allele_mut"},{"kind":12,"line":294,"name":"seq","containerName":"allele_mut"},{"name":"$value","containerName":"allele_mut","line":294,"kind":13},{"kind":12,"line":294,"name":"seq","containerName":"allele_mut"},{"kind":13,"line":294,"containerName":"allele_mut","name":"$value"},{"line":294,"kind":12,"name":"seq","containerName":"allele_mut"},{"line":296,"kind":13,"name":"$self","containerName":"allele_mut"},{"name":"$value","containerName":"allele_mut","line":296,"kind":13},{"name":"$self","containerName":"allele_mut","kind":13,"line":299}],"line":285,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.","label":"allele_mut($self,$value)"},"detail":"($self,$value)","name":"allele_mut","range":{"end":{"line":300,"character":9999},"start":{"character":0,"line":285}}},{"range":{"end":{"line":334,"character":9999},"start":{"character":0,"line":325}},"name":"length","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string","label":"length($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"length","line":326,"kind":13},{"containerName":"length","name":"$value","kind":13,"line":326},{"line":327,"kind":13,"name":"$value","containerName":"length"},{"kind":13,"line":328,"containerName":"length","name":"$self"},{"line":328,"kind":13,"name":"$value","containerName":"length"},{"kind":13,"line":330,"containerName":"length","name":"$self"},{"line":333,"kind":13,"name":"$self","containerName":"length"}],"line":325,"kind":12},{"kind":12,"line":353,"children":[{"containerName":"upStreamSeq","definition":"my","name":"$self","localvar":"my","kind":13,"line":354},{"line":354,"kind":13,"containerName":"upStreamSeq","name":"$value"},{"name":"$value","containerName":"upStreamSeq","kind":13,"line":355},{"name":"$self","containerName":"upStreamSeq","kind":13,"line":356},{"name":"$value","containerName":"upStreamSeq","kind":13,"line":356},{"line":358,"kind":13,"name":"$self","containerName":"upStreamSeq"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"upStreamSeq($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string"},"name":"upStreamSeq","range":{"start":{"character":0,"line":353},"end":{"character":9999,"line":359}}},{"range":{"end":{"line":386,"character":9999},"start":{"line":379,"character":0}},"name":"dnStreamSeq","children":[{"name":"$self","definition":"my","containerName":"dnStreamSeq","localvar":"my","kind":13,"line":380},{"kind":13,"line":380,"containerName":"dnStreamSeq","name":"$value"},{"containerName":"dnStreamSeq","name":"$value","line":381,"kind":13},{"line":382,"kind":13,"name":"$self","containerName":"dnStreamSeq"},{"containerName":"dnStreamSeq","name":"$value","kind":13,"line":382},{"containerName":"dnStreamSeq","name":"$self","kind":13,"line":384}],"line":379,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string","label":"dnStreamSeq($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"label","range":{"start":{"line":408,"character":0},"end":{"line":411,"character":9999}},"kind":12,"children":[{"line":409,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"label"},{"kind":13,"line":409,"name":"$value","containerName":"label"},{"name":"$self","containerName":"label","kind":13,"line":410},{"containerName":"label","name":"throw_not_implemented","kind":12,"line":410}],"line":408,"definition":"sub","containerName":"main::","signature":{"label":"label($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string"},"detail":"($self,$value)"},{"name":"status","range":{"end":{"character":9999,"line":451},"start":{"character":0,"line":432}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"status","line":433,"kind":13},{"kind":13,"line":433,"containerName":"status","name":"$value"},{"containerName":"status","name":"%status","definition":"my","localvar":"my","kind":13,"line":434},{"containerName":"status","name":"$value","line":438,"kind":13},{"kind":13,"line":439,"name":"$value","containerName":"status"},{"line":439,"kind":13,"name":"$value","containerName":"status"},{"kind":13,"line":440,"name":"$status","containerName":"status"},{"name":"$value","containerName":"status","kind":13,"line":440},{"containerName":"status","name":"$self","kind":13,"line":441},{"name":"$value","containerName":"status","kind":13,"line":441},{"containerName":"status","name":"$self","line":444,"kind":13},{"containerName":"status","name":"throw","line":444,"kind":12},{"containerName":"status","name":"$self","kind":13,"line":447},{"containerName":"status","name":"$self","line":450,"kind":13}],"line":432,"definition":"sub","containerName":"main::","signature":{"label":"status($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)"},"detail":"($self,$value)"},{"name":"suspected","kind":12,"line":434},{"line":435,"kind":12,"name":"proven"},{"name":"proof","range":{"end":{"character":9999,"line":486},"start":{"character":0,"line":471}},"kind":12,"line":471,"children":[{"name":"$self","definition":"my","containerName":"proof","localvar":"my","kind":13,"line":472},{"kind":13,"line":472,"containerName":"proof","name":"$value"},{"line":473,"kind":13,"localvar":"my","definition":"my","name":"%proof","containerName":"proof"},{"containerName":"proof","name":"$value","kind":13,"line":477},{"containerName":"proof","name":"$value","line":478,"kind":13},{"containerName":"proof","name":"$value","kind":13,"line":478},{"kind":13,"line":479,"containerName":"proof","name":"$proof"},{"kind":13,"line":479,"containerName":"proof","name":"$value"},{"kind":13,"line":480,"name":"$self","containerName":"proof"},{"kind":13,"line":480,"containerName":"proof","name":"$value"},{"line":482,"kind":13,"containerName":"proof","name":"$self"},{"line":482,"kind":12,"containerName":"proof","name":"throw"},{"name":"$self","containerName":"proof","line":485,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"proof($self,$value)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)","parameters":[{"label":"$self"},{"label":"$value"}]}},{"name":"computed","kind":12,"line":473},{"kind":12,"line":474,"name":"experimental"},{"children":[{"localvar":"my","containerName":"region","name":"$self","definition":"my","line":507,"kind":13},{"line":507,"kind":13,"name":"$value","containerName":"region"},{"line":508,"kind":13,"name":"$value","containerName":"region"},{"name":"$self","containerName":"region","kind":13,"line":509},{"name":"$value","containerName":"region","kind":13,"line":509},{"kind":13,"line":511,"containerName":"region","name":"$self"}],"line":506,"kind":12,"signature":{"label":"region($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":512},"start":{"character":0,"line":506}},"name":"region"},{"children":[{"localvar":"my","containerName":"region_value","name":"$self","definition":"my","line":533,"kind":13},{"line":533,"kind":13,"name":"$value","containerName":"region_value"},{"line":534,"kind":13,"containerName":"region_value","name":"$value"},{"kind":13,"line":535,"name":"$self","containerName":"region_value"},{"name":"$value","containerName":"region_value","kind":13,"line":535},{"kind":13,"line":537,"containerName":"region_value","name":"$self"}],"line":532,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string","label":"region_value($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":538,"character":9999},"start":{"character":0,"line":532}},"name":"region_value"},{"name":"region_dist","range":{"end":{"character":9999,"line":567},"start":{"line":557,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"region_dist","name":"$self","definition":"my","line":558,"kind":13},{"containerName":"region_dist","name":"$value","kind":13,"line":558},{"name":"$value","containerName":"region_dist","kind":13,"line":559},{"line":560,"kind":13,"name":"$value","containerName":"region_dist"},{"kind":13,"line":561,"name":"$self","containerName":"region_dist"},{"name":"throw","containerName":"region_dist","line":561,"kind":12},{"kind":13,"line":563,"containerName":"region_dist","name":"$self"},{"line":563,"kind":13,"name":"$value","containerName":"region_dist"},{"kind":13,"line":566,"containerName":"region_dist","name":"$self"}],"line":557,"definition":"sub","containerName":"main::","signature":{"label":"region_dist($self,$value)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)"},{"range":{"end":{"line":606,"character":9999},"start":{"line":587,"character":0}},"name":"numbering","children":[{"definition":"my","name":"$self","containerName":"numbering","localvar":"my","kind":13,"line":588},{"containerName":"numbering","name":"$value","kind":13,"line":588},{"line":589,"kind":13,"localvar":"my","name":"%numbering","definition":"my","containerName":"numbering"},{"name":"$value","containerName":"numbering","line":593,"kind":13},{"line":594,"kind":13,"name":"$value","containerName":"numbering"},{"kind":13,"line":594,"containerName":"numbering","name":"$value"},{"kind":13,"line":595,"name":"$numbering","containerName":"numbering"},{"containerName":"numbering","name":"$value","kind":13,"line":595},{"kind":13,"line":596,"name":"$self","containerName":"numbering"},{"kind":13,"line":596,"containerName":"numbering","name":"$value"},{"name":"$self","containerName":"numbering","kind":13,"line":599},{"containerName":"numbering","name":"throw","kind":12,"line":599},{"name":"$self","containerName":"numbering","line":602,"kind":13},{"kind":13,"line":605,"name":"$self","containerName":"numbering"}],"line":587,"kind":12,"signature":{"label":"numbering($self,$value)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"kind":12,"line":589,"name":"entry"},{"kind":12,"line":590,"name":"coding"},{"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer","parameters":[{"label":"$self"},{"label":"$value"}],"label":"mut_number($self,$value)"},"containerName":"main::","definition":"sub","line":628,"children":[{"line":629,"kind":13,"localvar":"my","containerName":"mut_number","definition":"my","name":"$self"},{"line":629,"kind":13,"containerName":"mut_number","name":"$value"},{"kind":13,"line":630,"name":"$value","containerName":"mut_number"},{"line":631,"kind":13,"containerName":"mut_number","name":"$self"},{"line":631,"kind":13,"containerName":"mut_number","name":"$value"},{"name":"$self","containerName":"mut_number","line":633,"kind":13},{"containerName":"mut_number","name":"$self","kind":13,"line":636}],"kind":12,"range":{"start":{"character":0,"line":628},"end":{"line":638,"character":9999}},"name":"mut_number"},{"signature":{"label":"SeqDiff($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information."},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":662,"containerName":"SeqDiff","definition":"my","name":"$self","localvar":"my"},{"name":"$value","containerName":"SeqDiff","kind":13,"line":662},{"kind":13,"line":663,"name":"$value","containerName":"SeqDiff"},{"line":664,"kind":13,"containerName":"SeqDiff","name":"$value"},{"kind":12,"line":664,"name":"isa","containerName":"SeqDiff"},{"containerName":"SeqDiff","name":"$self","line":665,"kind":13},{"containerName":"SeqDiff","name":"throw","line":665,"kind":12},{"containerName":"SeqDiff","name":"$self","line":669,"kind":13},{"name":"$value","containerName":"SeqDiff","line":669,"kind":13},{"line":672,"kind":13,"name":"$self","containerName":"SeqDiff"},{"line":675,"kind":13,"name":"$self","containerName":"SeqDiff"}],"line":661,"kind":12,"range":{"end":{"line":677,"character":9999},"start":{"line":661,"character":0}},"name":"SeqDiff"},{"name":"add_DBLink","range":{"end":{"line":697,"character":9999},"start":{"line":692,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"add_DBLink($self,$com)","parameters":[{"label":"$self"},{"label":"$com"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information.\n\n\nsub SeqDiff {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\tif( ! $value->isa('Bio::Variation::SeqDiff') ) {\n\t    $self->throw(\"Is not a Bio::Variation::SeqDiff object but a [$value]\");\n\t    return;\n\t}\n\telse {\n\t    $self->{'seqDiff'} = $value;\n\t}\n    }\n    unless (exists $self->{'seqDiff'}) {\n\treturn;\n    } else {\n\treturn $self->{'seqDiff'};\n    }\n}\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :"},"detail":"($self,$com)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_DBLink","line":693,"kind":13},{"line":693,"kind":13,"containerName":"add_DBLink","name":"$com"},{"kind":13,"line":694,"containerName":"add_DBLink","name":"$com"},{"kind":13,"line":694,"containerName":"add_DBLink","name":"$com"},{"line":694,"kind":12,"name":"isa","containerName":"add_DBLink"},{"kind":13,"line":695,"name":"$self","containerName":"add_DBLink"},{"name":"throw","containerName":"add_DBLink","line":695,"kind":12},{"line":697,"kind":13,"containerName":"add_DBLink","name":"$com"},{"line":697,"kind":13,"name":"$self","containerName":"add_DBLink"}],"line":692},{"name":"$com","containerName":null,"kind":13,"line":697},{"name":"each_DBLink","range":{"end":{"line":715,"character":9999},"start":{"character":0,"line":712}},"kind":12,"line":712,"children":[{"kind":13,"line":713,"definition":"my","name":"$self","containerName":"each_DBLink","localvar":"my"},{"name":"$self","containerName":"each_DBLink","line":715,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information.\n\n\nsub SeqDiff {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\tif( ! $value->isa('Bio::Variation::SeqDiff') ) {\n\t    $self->throw(\"Is not a Bio::Variation::SeqDiff object but a [$value]\");\n\t    return;\n\t}\n\telse {\n\t    $self->{'seqDiff'} = $value;\n\t}\n    }\n    unless (exists $self->{'seqDiff'}) {\n\treturn;\n    } else {\n\treturn $self->{'seqDiff'};\n    }\n}\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( $com && ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   $com && push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"each_DBLink($self)"}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"restriction_changes($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information.\n\n\nsub SeqDiff {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\tif( ! $value->isa('Bio::Variation::SeqDiff') ) {\n\t    $self->throw(\"Is not a Bio::Variation::SeqDiff object but a [$value]\");\n\t    return;\n\t}\n\telse {\n\t    $self->{'seqDiff'} = $value;\n\t}\n    }\n    unless (exists $self->{'seqDiff'}) {\n\treturn;\n    } else {\n\treturn $self->{'seqDiff'};\n    }\n}\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( $com && ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   $com && push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;\n   \n   return @{$self->{'link'}}; \n}\n\n=head2 restriction_changes\n\n Title   : restriction_changes\n Usage   : $obj->restriction_changes();\n Function: \n\n            Returns a string containing a list of restriction\n            enzyme changes of form +EcoRI, separated by\n            commas. Strings need to be valid restriction enzyme names\n            as stored in REBASE. allele_ori and allele_mut need to be assigned.\n\n Example : \n Returns : string\n Args    : string"},"kind":12,"line":735,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"restriction_changes","line":736,"kind":13},{"kind":13,"line":738,"name":"$self","containerName":"restriction_changes"},{"kind":13,"line":739,"definition":"my","name":"%re","containerName":"restriction_changes","localvar":"my"},{"containerName":"restriction_changes","name":"$self","kind":13,"line":742},{"name":"isa","containerName":"restriction_changes","line":742,"kind":12},{"line":743,"kind":13,"containerName":"restriction_changes","name":"$self"},{"line":743,"kind":12,"name":"throw","containerName":"restriction_changes"},{"line":747,"kind":13,"containerName":"restriction_changes","name":"$self"},{"kind":12,"line":747,"name":"warn","containerName":"restriction_changes"},{"name":"$self","containerName":"restriction_changes","kind":13,"line":748},{"containerName":"restriction_changes","name":"upStreamSeq","kind":12,"line":748},{"containerName":"restriction_changes","name":"$self","line":749,"kind":13},{"containerName":"restriction_changes","name":"warn","line":749,"kind":12},{"line":750,"kind":13,"name":"$self","containerName":"restriction_changes"},{"kind":12,"line":750,"name":"dnStreamSeq","containerName":"restriction_changes"},{"containerName":"restriction_changes","name":"$self","kind":13,"line":758},{"line":758,"kind":12,"containerName":"restriction_changes","name":"isa"},{"kind":13,"line":758,"containerName":"restriction_changes","name":"$self"},{"containerName":"restriction_changes","name":"DNAMutation","kind":12,"line":758},{"line":759,"kind":13,"name":"$self","containerName":"restriction_changes"},{"kind":12,"line":759,"containerName":"restriction_changes","name":"upStreamSeq"},{"containerName":"restriction_changes","name":"$self","kind":13,"line":759},{"kind":12,"line":759,"containerName":"restriction_changes","name":"DNAMutation"},{"kind":12,"line":759,"name":"upStreamSeq","containerName":"restriction_changes"},{"containerName":"restriction_changes","name":"$self","line":760,"kind":13},{"kind":12,"line":760,"containerName":"restriction_changes","name":"dnStreamSeq"},{"line":760,"kind":13,"name":"$self","containerName":"restriction_changes"},{"kind":12,"line":760,"name":"DNAMutation","containerName":"restriction_changes"},{"name":"dnStreamSeq","containerName":"restriction_changes","kind":12,"line":760},{"name":"$self","containerName":"restriction_changes","kind":13,"line":761},{"name":"DNAMutation","containerName":"restriction_changes","kind":12,"line":761},{"name":"restriction_changes","containerName":"restriction_changes","line":761,"kind":12},{"line":762,"kind":13,"name":"$self","containerName":"restriction_changes"},{"kind":13,"line":762,"containerName":"restriction_changes","name":"$self"},{"containerName":"restriction_changes","name":"DNAMutation","kind":12,"line":762},{"kind":12,"line":762,"containerName":"restriction_changes","name":"restriction_changes"},{"kind":13,"line":766,"containerName":"restriction_changes","definition":"my","name":"$le_dn","localvar":"my"},{"definition":"my","name":"$le_up","containerName":"restriction_changes","localvar":"my","kind":13,"line":767},{"line":767,"kind":13,"containerName":"restriction_changes","name":"$le_dn"},{"name":"$le_dn","containerName":"restriction_changes","line":770,"kind":13},{"line":770,"kind":13,"containerName":"restriction_changes","name":"$self"},{"containerName":"restriction_changes","name":"dnStreamSeq","kind":12,"line":770},{"containerName":"restriction_changes","name":"$le_dn","kind":13,"line":770},{"line":770,"kind":13,"name":"$self","containerName":"restriction_changes"},{"line":770,"kind":12,"containerName":"restriction_changes","name":"dnStreamSeq"},{"containerName":"restriction_changes","name":"$le_up","line":771,"kind":13},{"name":"$self","containerName":"restriction_changes","line":771,"kind":13},{"name":"upStreamSeq","containerName":"restriction_changes","kind":12,"line":771},{"name":"$le_up","containerName":"restriction_changes","line":771,"kind":13},{"containerName":"restriction_changes","name":"$self","kind":13,"line":771},{"name":"upStreamSeq","containerName":"restriction_changes","line":771,"kind":12},{"definition":"my","name":"$oriseq","containerName":"restriction_changes","localvar":"my","kind":13,"line":774},{"kind":13,"line":774,"name":"$mutseq","containerName":"restriction_changes"},{"name":"$oriseq","containerName":"restriction_changes","line":775,"kind":13},{"containerName":"restriction_changes","name":"$mutseq","line":775,"kind":13},{"name":"$self","containerName":"restriction_changes","line":775,"kind":13},{"containerName":"restriction_changes","name":"upStreamSeq","line":775,"kind":12},{"name":"$le_up","containerName":"restriction_changes","kind":13,"line":775},{"line":775,"kind":13,"name":"$le_up","containerName":"restriction_changes"},{"containerName":"restriction_changes","name":"$oriseq","line":776,"kind":13},{"line":776,"kind":13,"containerName":"restriction_changes","name":"$self"},{"name":"allele_ori","containerName":"restriction_changes","line":776,"kind":12},{"kind":12,"line":776,"containerName":"restriction_changes","name":"seq"},{"containerName":"restriction_changes","name":"$self","line":776,"kind":13},{"name":"allele_ori","containerName":"restriction_changes","line":776,"kind":12},{"containerName":"restriction_changes","name":"seq","line":776,"kind":12},{"containerName":"restriction_changes","name":"$mutseq","line":777,"kind":13},{"kind":13,"line":777,"name":"$self","containerName":"restriction_changes"},{"containerName":"restriction_changes","name":"allele_mut","line":777,"kind":12},{"containerName":"restriction_changes","name":"seq","line":777,"kind":12},{"name":"$self","containerName":"restriction_changes","line":777,"kind":13},{"line":777,"kind":12,"containerName":"restriction_changes","name":"allele_mut"},{"kind":12,"line":777,"containerName":"restriction_changes","name":"seq"},{"containerName":"restriction_changes","name":"$oriseq","kind":13,"line":778},{"kind":13,"line":778,"name":"$self","containerName":"restriction_changes"},{"line":778,"kind":12,"name":"dnStreamSeq","containerName":"restriction_changes"},{"name":"$le_dn","containerName":"restriction_changes","kind":13,"line":778},{"kind":13,"line":779,"containerName":"restriction_changes","name":"$mutseq"},{"name":"$self","containerName":"restriction_changes","line":779,"kind":13},{"kind":12,"line":779,"name":"dnStreamSeq","containerName":"restriction_changes"},{"containerName":"restriction_changes","name":"$le_dn","kind":13,"line":779},{"name":"$oriseq_rev","definition":"my","containerName":"restriction_changes","localvar":"my","kind":13,"line":782},{"containerName":"restriction_changes","name":"$oriseq","line":782,"kind":13},{"kind":13,"line":783,"containerName":"restriction_changes","definition":"my","name":"$mutseq_rev","localvar":"my"},{"line":783,"kind":13,"name":"$mutseq","containerName":"restriction_changes"},{"name":"$rec","definition":"my","containerName":"restriction_changes","localvar":"my","kind":13,"line":786},{"localvar":"my","name":"$enz","definition":"my","containerName":"restriction_changes","line":787,"kind":13},{"containerName":"restriction_changes","name":"%re","line":787,"kind":13},{"containerName":"restriction_changes","definition":"my","name":"$site","localvar":"my","kind":13,"line":788},{"kind":13,"line":788,"containerName":"restriction_changes","name":"$re"},{"line":788,"kind":13,"containerName":"restriction_changes","name":"$enz"},{"definition":"my","name":"@ori","containerName":"restriction_changes","localvar":"my","kind":13,"line":789},{"line":789,"kind":13,"name":"$oriseq","containerName":"restriction_changes"},{"kind":13,"line":790,"name":"@mut","definition":"my","containerName":"restriction_changes","localvar":"my"},{"kind":13,"line":790,"containerName":"restriction_changes","name":"$mutseq"},{"containerName":"restriction_changes","definition":"my","name":"@ori_r","localvar":"my","kind":13,"line":791},{"line":791,"kind":13,"name":"$oriseq_rev","containerName":"restriction_changes"},{"localvar":"my","containerName":"restriction_changes","name":"@mut_r","definition":"my","line":792,"kind":13},{"name":"$mutseq_rev","containerName":"restriction_changes","kind":13,"line":792},{"name":"$rec","containerName":"restriction_changes","line":794,"kind":13},{"kind":13,"line":794,"containerName":"restriction_changes","name":"$enz"},{"kind":13,"line":795,"containerName":"restriction_changes","name":"@ori"},{"kind":13,"line":795,"containerName":"restriction_changes","name":"@mut"},{"name":"@ori_r","containerName":"restriction_changes","line":795,"kind":13},{"containerName":"restriction_changes","name":"@mut_r","line":795,"kind":13},{"name":"$rec","containerName":"restriction_changes","kind":13,"line":796},{"name":"$enz","containerName":"restriction_changes","kind":13,"line":796},{"kind":13,"line":797,"containerName":"restriction_changes","name":"@ori"},{"line":797,"kind":13,"containerName":"restriction_changes","name":"@mut"},{"kind":13,"line":797,"containerName":"restriction_changes","name":"@ori_r"},{"line":797,"kind":13,"containerName":"restriction_changes","name":"@mut_r"},{"name":"$rec","containerName":"restriction_changes","kind":13,"line":800},{"name":"$rec","containerName":"restriction_changes","kind":13,"line":800},{"line":800,"kind":13,"containerName":"restriction_changes","name":"$rec"},{"containerName":"restriction_changes","name":"$rec","line":800,"kind":13},{"name":"$self","containerName":"restriction_changes","kind":13,"line":801},{"line":801,"kind":13,"name":"$rec","containerName":"restriction_changes"},{"containerName":"restriction_changes","name":"$self","line":804,"kind":13}],"name":"restriction_changes","range":{"end":{"character":9999,"line":805},"start":{"character":0,"line":735}}},{"name":"_enzymes","line":739,"kind":12},{"name":"CORE","containerName":"length","kind":12,"line":770},{"kind":12,"line":770,"name":"CORE","containerName":"length"},{"kind":12,"line":771,"name":"CORE","containerName":"length"},{"containerName":"length","name":"CORE","line":771,"kind":12},{"kind":12,"line":782,"name":"_revcompl"},{"name":"_revcompl","line":783,"kind":12},{"kind":12,"line":800,"containerName":"length","name":"CORE"},{"children":[{"line":810,"kind":13,"localvar":"my","containerName":"_revcompl","name":"$seq","definition":"my"},{"containerName":"_revcompl","name":"$seq","line":812,"kind":13},{"containerName":"_revcompl","name":"$seq","line":812,"kind":13},{"containerName":"_revcompl","name":"$seq","line":813,"kind":13},{"name":"$seq","containerName":"_revcompl","kind":13,"line":814}],"line":808,"kind":12,"range":{"start":{"character":0,"line":808},"end":{"line":815,"character":9999}},"name":"_revcompl","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","name":"%enzymes","definition":"my","containerName":"_enzymes","line":820,"kind":13},{"kind":13,"line":1049,"name":"%enzymes","containerName":"_enzymes"}],"line":818,"definition":"sub","name":"_enzymes","containerName":"main::","range":{"start":{"line":818,"character":0},"end":{"character":9999,"line":1050}}},{"name":"CORE","containerName":"reverse","line":820,"kind":12}],"version":5}