{"version":5,"vars":[{"name":"base","containerName":"","line":104,"kind":2},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":106,"children":[{"kind":13,"line":107,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"line":107,"kind":13,"containerName":"new","name":"@args"},{"line":108,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":108,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"line":108,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","definition":"my","name":"$start","line":110,"kind":13},{"name":"$end","containerName":"new","kind":13,"line":110},{"line":110,"kind":13,"name":"$length","containerName":"new"},{"line":110,"kind":13,"containerName":"new","name":"$strand"},{"containerName":"new","name":"$primary","line":110,"kind":13},{"kind":13,"line":110,"containerName":"new","name":"$source"},{"line":111,"kind":13,"containerName":"new","name":"$frame"},{"line":111,"kind":13,"containerName":"new","name":"$score"},{"name":"$gff_string","containerName":"new","kind":13,"line":111},{"line":112,"kind":13,"name":"$allele_ori","containerName":"new"},{"name":"$allele_mut","containerName":"new","line":112,"kind":13},{"kind":13,"line":112,"containerName":"new","name":"$upstreamseq"},{"containerName":"new","name":"$dnstreamseq","kind":13,"line":112},{"kind":13,"line":113,"name":"$label","containerName":"new"},{"kind":13,"line":113,"containerName":"new","name":"$status"},{"line":113,"kind":13,"containerName":"new","name":"$proof"},{"kind":13,"line":113,"name":"$region","containerName":"new"},{"line":113,"kind":13,"name":"$region_value","containerName":"new"},{"containerName":"new","name":"$region_dist","kind":13,"line":113},{"name":"$numbering","containerName":"new","kind":13,"line":113},{"containerName":"new","name":"$cpg","kind":13,"line":114},{"name":"$mut_number","containerName":"new","kind":13,"line":114},{"line":114,"kind":13,"name":"$ismutation","containerName":"new"},{"kind":13,"line":115,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":115},{"name":"@args","containerName":"new","line":139,"kind":13},{"line":141,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"primary_tag","line":141,"kind":12},{"line":143,"kind":13,"name":"$self","containerName":"new"},{"line":145,"kind":13,"containerName":"new","name":"$start"},{"kind":13,"line":145,"name":"$self","containerName":"new"},{"kind":12,"line":145,"containerName":"new","name":"start"},{"name":"$start","containerName":"new","line":145,"kind":13},{"kind":13,"line":146,"name":"$end","containerName":"new"},{"line":146,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"end","line":146,"kind":12},{"kind":13,"line":146,"name":"$end","containerName":"new"},{"name":"$length","containerName":"new","line":147,"kind":13},{"containerName":"new","name":"$self","line":147,"kind":13},{"kind":12,"line":147,"containerName":"new","name":"length"},{"kind":13,"line":147,"name":"$length","containerName":"new"},{"name":"$strand","containerName":"new","kind":13,"line":148},{"line":148,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":148,"name":"strand","containerName":"new"},{"kind":13,"line":148,"containerName":"new","name":"$strand"},{"kind":13,"line":149,"name":"$primary","containerName":"new"},{"containerName":"new","name":"$self","line":149,"kind":13},{"line":149,"kind":12,"name":"primary_tag","containerName":"new"},{"kind":13,"line":149,"containerName":"new","name":"$primary"},{"name":"$source","containerName":"new","kind":13,"line":150},{"containerName":"new","name":"$self","kind":13,"line":150},{"line":150,"kind":12,"containerName":"new","name":"source_tag"},{"line":150,"kind":13,"name":"$source","containerName":"new"},{"kind":13,"line":151,"containerName":"new","name":"$frame"},{"line":151,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":151,"containerName":"new","name":"frame"},{"name":"$frame","containerName":"new","line":151,"kind":13},{"name":"$score","containerName":"new","kind":13,"line":152},{"containerName":"new","name":"$self","line":152,"kind":13},{"kind":12,"line":152,"containerName":"new","name":"score"},{"kind":13,"line":152,"containerName":"new","name":"$score"},{"kind":13,"line":153,"containerName":"new","name":"$gff_string"},{"containerName":"new","name":"$self","line":153,"kind":13},{"kind":12,"line":153,"containerName":"new","name":"_from_gff_string"},{"kind":13,"line":153,"name":"$gff_string","containerName":"new"},{"name":"$allele_ori","containerName":"new","kind":13,"line":155},{"line":155,"kind":13,"name":"$self","containerName":"new"},{"line":155,"kind":12,"name":"allele_ori","containerName":"new"},{"name":"$allele_ori","containerName":"new","line":155,"kind":13},{"containerName":"new","name":"$allele_mut","line":156,"kind":13},{"kind":13,"line":156,"containerName":"new","name":"$self"},{"name":"allele_mut","containerName":"new","kind":12,"line":156},{"name":"$allele_mut","containerName":"new","line":156,"kind":13},{"line":157,"kind":13,"containerName":"new","name":"$upstreamseq"},{"kind":13,"line":157,"containerName":"new","name":"$self"},{"containerName":"new","name":"upStreamSeq","line":157,"kind":12},{"line":157,"kind":13,"containerName":"new","name":"$upstreamseq"},{"line":158,"kind":13,"name":"$dnstreamseq","containerName":"new"},{"kind":13,"line":158,"containerName":"new","name":"$self"},{"name":"dnStreamSeq","containerName":"new","kind":12,"line":158},{"line":158,"kind":13,"name":"$dnstreamseq","containerName":"new"},{"line":160,"kind":13,"name":"$label","containerName":"new"},{"line":160,"kind":13,"name":"$self","containerName":"new"},{"line":160,"kind":12,"name":"label","containerName":"new"},{"containerName":"new","name":"$label","line":160,"kind":13},{"line":161,"kind":13,"name":"$status","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":161},{"name":"status","containerName":"new","line":161,"kind":12},{"containerName":"new","name":"$status","kind":13,"line":161},{"kind":13,"line":162,"name":"$proof","containerName":"new"},{"line":162,"kind":13,"containerName":"new","name":"$self"},{"name":"proof","containerName":"new","kind":12,"line":162},{"kind":13,"line":162,"name":"$proof","containerName":"new"},{"line":163,"kind":13,"name":"$region","containerName":"new"},{"line":163,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"region","kind":12,"line":163},{"kind":13,"line":163,"name":"$region","containerName":"new"},{"name":"$region_value","containerName":"new","line":164,"kind":13},{"containerName":"new","name":"$self","line":164,"kind":13},{"name":"region_value","containerName":"new","line":164,"kind":12},{"name":"$region_value","containerName":"new","kind":13,"line":164},{"containerName":"new","name":"$region_dist","kind":13,"line":165},{"kind":13,"line":165,"name":"$self","containerName":"new"},{"kind":12,"line":165,"containerName":"new","name":"region_dist"},{"kind":13,"line":165,"containerName":"new","name":"$region_dist"},{"line":166,"kind":13,"containerName":"new","name":"$numbering"},{"containerName":"new","name":"$self","kind":13,"line":166},{"line":166,"kind":12,"name":"numbering","containerName":"new"},{"line":166,"kind":13,"containerName":"new","name":"$numbering"},{"name":"$mut_number","containerName":"new","line":167,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":167},{"line":167,"kind":12,"containerName":"new","name":"mut_number"},{"name":"$mut_number","containerName":"new","line":167,"kind":13},{"containerName":"new","name":"$ismutation","line":168,"kind":13},{"kind":13,"line":168,"containerName":"new","name":"$self"},{"kind":12,"line":168,"name":"isMutation","containerName":"new"},{"containerName":"new","name":"$ismutation","kind":13,"line":168},{"line":170,"kind":13,"name":"$cpg","containerName":"new"},{"containerName":"new","name":"$self","line":170,"kind":13},{"line":170,"kind":12,"containerName":"new","name":"CpG"},{"containerName":"new","name":"$cpg","kind":13,"line":170},{"containerName":"new","name":"$self","kind":13,"line":172}],"name":"new","range":{"start":{"character":0,"line":106},"end":{"character":9999,"line":173}}},{"name":"SUPER","containerName":"new","kind":12,"line":108},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: DNAMutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::DNAMutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::DNAMutation - DNA level mutation class\n\n=head1 SYNOPSIS\n\n    $dnamut = Bio::Variation::DNAMutation->new\n        ('-start'         => $start,\n         '-end'           => $end,\n         '-length'        => $len,\n         '-upStreamSeq'   => $upflank,\n         '-dnStreamSeq'   => $dnflank,\n         '-proof'         => $proof,\n\t '-isMutation'    => 1,\n         '-mut_number'    => $mut_number\n        );\n    $a1 = Bio::Variation::Allele->new;\n    $a1->seq('a');\n    $dnamut->allele_ori($a1);\n    my $a2 = Bio::Variation::Allele->new;\n    $a2->seq('t');\n    $dnamut->add_Allele($a2);\n\n    print \"Restriction changes are \", $dnamut->restriction_changes, \"\\n\";\n\n    # add it to a SeqDiff container object\n    $seqdiff->add_Variant($dnamut);\n\n\n=head1 DESCRIPTION\n\nThe instantiable class Bio::Variation::DNAMutation describes basic\nsequence changes in genomic DNA level. It uses methods defined in\nsuperclass Bio::Variation::VariantI. See L<Bio::Variation::VariantI>\nfor details.\n\nIf the variation described by a DNAMutation object is transcibed, link\nthe corresponding Bio::Variation::RNAChange object to it using\nmethod RNAChange(). See L<Bio::Variation::RNAChange> for more information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::DNAMutation;\nuse strict;\n\n# Object preamble - inheritance\n\nuse base qw(Bio::Variation::VariantI);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($start, $end, $length, $strand, $primary, $source, \n\t$frame, $score, $gff_string,\n\t$allele_ori,  $allele_mut,  $upstreamseq,  $dnstreamseq,  \n\t$label,  $status,  $proof,  $region, $region_value, $region_dist, $numbering, \n\t$cpg, $mut_number, $ismutation) =\n\t    $self->_rearrange([qw(START\n\t\t\t\t  END\n\t\t\t\t  LENGTH\n\t\t\t\t  STRAND\n\t\t\t\t  PRIMARY\n\t\t\t\t  SOURCE\n\t\t\t\t  FRAME\n\t\t\t\t  SCORE\n\t\t\t\t  GFF_STRING\n\t\t\t\t  ALLELE_ORI\n\t\t\t\t  ALLELE_MUT\n\t\t\t\t  UPSTREAMSEQ\n\t\t\t\t  DNSTREAMSEQ\n\t\t\t\t  LABEL\n\t\t\t\t  STATUS\n\t\t\t\t  PROOF\n\t\t\t\t  REGION\n\t\t\t\t  REGION_VALUE\n\t\t\t\t  REGION_DIST\n\t\t\t\t  NUMBERING\n\t\t\t\t  CPG\n\t\t\t\t  MUT_NUMBER\n\t\t\t\t  ISMUTATION\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->primary_tag(\"Variation\");\n\n    $self->{ 'alleles' } = [];\n\n    $start && $self->start($start);\n    $end   && $self->end($end);\n    $length && $self->length($length);\n    $strand && $self->strand($strand);\n    $primary && $self->primary_tag($primary);\n    $source  && $self->source_tag($source);\n    $frame   && $self->frame($frame);\n    $score   && $self->score($score);\n    $gff_string && $self->_from_gff_string($gff_string);\n    \n    $allele_ori && $self->allele_ori($allele_ori);\n    $allele_mut  && $self->allele_mut($allele_mut);\n    $upstreamseq  && $self->upStreamSeq($upstreamseq);\n    $dnstreamseq  && $self->dnStreamSeq($dnstreamseq);\n    \n    $label  && $self->label($label);\n    $status  && $self->status($status);\n    $proof && $self->proof($proof);\n    $region  && $self->region($region);\n    $region_value  && $self->region_value($region_value);\n    $region_dist  && $self->region_dist($region_dist);\n    $numbering && $self->numbering($numbering);\n    $mut_number && $self->mut_number($mut_number);\n    $ismutation && $self->isMutation($ismutation);\n\n    $cpg && $self->CpG($cpg);\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 CpG\n\n Title   : CpG\n Usage   : $obj->CpG()\n Function: sets and returns boolean values for variation \n           hitting a CpG site.  Unset value return -1.\n Example : $obj->CpG()\n Returns : boolean\n Args    : optional true of false value","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"CpG($obj,$value)"},"detail":"($obj,$value)","kind":12,"children":[{"localvar":"my","containerName":"CpG","name":"$obj","definition":"my","line":191,"kind":13},{"kind":13,"line":191,"name":"$value","containerName":"CpG"},{"containerName":"CpG","name":"$value","kind":13,"line":192},{"containerName":"CpG","name":"$value","line":193,"kind":13},{"containerName":"CpG","name":"$value","kind":13,"line":193},{"name":"$value","containerName":"CpG","line":193,"kind":13},{"kind":13,"line":194,"containerName":"CpG","name":"$obj"},{"containerName":"CpG","name":"$value","kind":13,"line":194},{"containerName":"CpG","name":"$obj","line":196,"kind":13},{"name":"$obj","containerName":"CpG","kind":13,"line":197},{"name":"$obj","containerName":"CpG","kind":13,"line":197},{"kind":12,"line":197,"name":"_CpG_value","containerName":"CpG"},{"line":200,"kind":13,"name":"$obj","containerName":"CpG"}],"line":190,"name":"CpG","range":{"end":{"line":202,"character":9999},"start":{"character":0,"line":190}}},{"name":"_CpG_value","range":{"end":{"line":226,"character":9999},"start":{"character":0,"line":206}},"kind":12,"line":206,"children":[{"localvar":"my","containerName":"_CpG_value","name":"$self","definition":"my","line":207,"kind":13},{"kind":13,"line":208,"containerName":"_CpG_value","name":"$self"},{"kind":12,"line":208,"containerName":"_CpG_value","name":"allele_ori"},{"containerName":"_CpG_value","name":"$self","kind":13,"line":208},{"containerName":"_CpG_value","name":"allele_mut","kind":12,"line":208},{"kind":13,"line":208,"name":"$self","containerName":"_CpG_value"},{"name":"allele_ori","containerName":"_CpG_value","kind":12,"line":208},{"line":215,"kind":13,"name":"$self","containerName":"_CpG_value"},{"containerName":"_CpG_value","name":"allele_ori","kind":12,"line":215},{"name":"$self","containerName":"_CpG_value","line":215,"kind":13},{"line":215,"kind":12,"containerName":"_CpG_value","name":"upStreamSeq"},{"line":216,"kind":13,"containerName":"_CpG_value","name":"$self"},{"containerName":"_CpG_value","name":"allele_ori","line":216,"kind":12},{"line":216,"kind":13,"name":"$self","containerName":"_CpG_value"},{"name":"dnStreamSeq","containerName":"_CpG_value","kind":12,"line":216},{"line":223,"kind":13,"name":"$self","containerName":"_CpG_value"},{"name":"warn","containerName":"_CpG_value","kind":12,"line":223}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_CpG_value($self)"}},{"range":{"start":{"line":241,"character":0},"end":{"character":9999,"line":257}},"name":"RNAChange","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: DNAMutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::DNAMutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::DNAMutation - DNA level mutation class\n\n=head1 SYNOPSIS\n\n    $dnamut = Bio::Variation::DNAMutation->new\n        ('-start'         => $start,\n         '-end'           => $end,\n         '-length'        => $len,\n         '-upStreamSeq'   => $upflank,\n         '-dnStreamSeq'   => $dnflank,\n         '-proof'         => $proof,\n\t '-isMutation'    => 1,\n         '-mut_number'    => $mut_number\n        );\n    $a1 = Bio::Variation::Allele->new;\n    $a1->seq('a');\n    $dnamut->allele_ori($a1);\n    my $a2 = Bio::Variation::Allele->new;\n    $a2->seq('t');\n    $dnamut->add_Allele($a2);\n\n    print \"Restriction changes are \", $dnamut->restriction_changes, \"\\n\";\n\n    # add it to a SeqDiff container object\n    $seqdiff->add_Variant($dnamut);\n\n\n=head1 DESCRIPTION\n\nThe instantiable class Bio::Variation::DNAMutation describes basic\nsequence changes in genomic DNA level. It uses methods defined in\nsuperclass Bio::Variation::VariantI. See L<Bio::Variation::VariantI>\nfor details.\n\nIf the variation described by a DNAMutation object is transcibed, link\nthe corresponding Bio::Variation::RNAChange object to it using\nmethod RNAChange(). See L<Bio::Variation::RNAChange> for more information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::DNAMutation;\nuse strict;\n\n# Object preamble - inheritance\n\nuse base qw(Bio::Variation::VariantI);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($start, $end, $length, $strand, $primary, $source, \n\t$frame, $score, $gff_string,\n\t$allele_ori,  $allele_mut,  $upstreamseq,  $dnstreamseq,  \n\t$label,  $status,  $proof,  $region, $region_value, $region_dist, $numbering, \n\t$cpg, $mut_number, $ismutation) =\n\t    $self->_rearrange([qw(START\n\t\t\t\t  END\n\t\t\t\t  LENGTH\n\t\t\t\t  STRAND\n\t\t\t\t  PRIMARY\n\t\t\t\t  SOURCE\n\t\t\t\t  FRAME\n\t\t\t\t  SCORE\n\t\t\t\t  GFF_STRING\n\t\t\t\t  ALLELE_ORI\n\t\t\t\t  ALLELE_MUT\n\t\t\t\t  UPSTREAMSEQ\n\t\t\t\t  DNSTREAMSEQ\n\t\t\t\t  LABEL\n\t\t\t\t  STATUS\n\t\t\t\t  PROOF\n\t\t\t\t  REGION\n\t\t\t\t  REGION_VALUE\n\t\t\t\t  REGION_DIST\n\t\t\t\t  NUMBERING\n\t\t\t\t  CPG\n\t\t\t\t  MUT_NUMBER\n\t\t\t\t  ISMUTATION\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->primary_tag(\"Variation\");\n\n    $self->{ 'alleles' } = [];\n\n    $start && $self->start($start);\n    $end   && $self->end($end);\n    $length && $self->length($length);\n    $strand && $self->strand($strand);\n    $primary && $self->primary_tag($primary);\n    $source  && $self->source_tag($source);\n    $frame   && $self->frame($frame);\n    $score   && $self->score($score);\n    $gff_string && $self->_from_gff_string($gff_string);\n    \n    $allele_ori && $self->allele_ori($allele_ori);\n    $allele_mut  && $self->allele_mut($allele_mut);\n    $upstreamseq  && $self->upStreamSeq($upstreamseq);\n    $dnstreamseq  && $self->dnStreamSeq($dnstreamseq);\n    \n    $label  && $self->label($label);\n    $status  && $self->status($status);\n    $proof && $self->proof($proof);\n    $region  && $self->region($region);\n    $region_value  && $self->region_value($region_value);\n    $region_dist  && $self->region_dist($region_dist);\n    $numbering && $self->numbering($numbering);\n    $mut_number && $self->mut_number($mut_number);\n    $ismutation && $self->isMutation($ismutation);\n\n    $cpg && $self->CpG($cpg);\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 CpG\n\n Title   : CpG\n Usage   : $obj->CpG()\n Function: sets and returns boolean values for variation \n           hitting a CpG site.  Unset value return -1.\n Example : $obj->CpG()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub CpG {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n       $value ? ($value = 1) : ($value = 0);\n       $obj->{'cpg'} = $value;\n   }\n    elsif (not defined $obj->{'label'}) {\n\t$obj->{'cpg'} = $obj->_CpG_value;\n    }\n   else {\n       return $obj->{'cpg'};\n   }\n}\n\n\n\nsub _CpG_value {\n    my ($self) = @_;\n    if ($self->allele_ori eq $self->allele_mut and length ($self->allele_ori) == 1 ) {\n    \n\t# valid only for point mutations\n\t# CpG methylation-mediated deamination:\n\t#   CG -> TG | CG -> CA substitutions\n\t# implementation here is  less strict: if CpG dinucleotide was hit\n\t\n\tif ( ( ($self->allele_ori eq 'c') && (substr($self->upStreamSeq, 0, 1) eq 'g') ) ||\n\t     ( ($self->allele_ori eq 'g') && (substr($self->dnStreamSeq, -1, 1) eq 'c') ) ) {\n\t    return 1;\n\t}\n\telse {\n\t    return 0;\n\t}\n    } else {\n\t$self->warn('CpG makes sense only in the context of point mutation');\n\treturn;\n    }\n}\n\n\n=head2 RNAChange\n\n Title   : RNAChange\n Usage   : $mutobj = $obj->RNAChange;\n         : $mutobj = $obj->RNAChange($objref);\n Function: Returns or sets the link-reference to a mutation/change object.\n           If there is no link, it will return undef\n Returns : an obj_ref or undef","label":"RNAChange($self,$value)"},"containerName":"main::","definition":"sub","line":241,"children":[{"kind":13,"line":242,"containerName":"RNAChange","name":"$self","definition":"my","localvar":"my"},{"containerName":"RNAChange","name":"$value","kind":13,"line":242},{"name":"$value","containerName":"RNAChange","line":243,"kind":13},{"kind":13,"line":244,"containerName":"RNAChange","name":"$value"},{"name":"isa","containerName":"RNAChange","kind":12,"line":244},{"name":"$self","containerName":"RNAChange","kind":13,"line":245},{"containerName":"RNAChange","name":"throw","kind":12,"line":245},{"line":249,"kind":13,"containerName":"RNAChange","name":"$self"},{"line":249,"kind":13,"containerName":"RNAChange","name":"$value"},{"line":252,"kind":13,"name":"$self","containerName":"RNAChange"},{"name":"$self","containerName":"RNAChange","line":255,"kind":13}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: DNAMutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::DNAMutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::DNAMutation - DNA level mutation class\n\n=head1 SYNOPSIS\n\n    $dnamut = Bio::Variation::DNAMutation->new\n        ('-start'         => $start,\n         '-end'           => $end,\n         '-length'        => $len,\n         '-upStreamSeq'   => $upflank,\n         '-dnStreamSeq'   => $dnflank,\n         '-proof'         => $proof,\n\t '-isMutation'    => 1,\n         '-mut_number'    => $mut_number\n        );\n    $a1 = Bio::Variation::Allele->new;\n    $a1->seq('a');\n    $dnamut->allele_ori($a1);\n    my $a2 = Bio::Variation::Allele->new;\n    $a2->seq('t');\n    $dnamut->add_Allele($a2);\n\n    print \"Restriction changes are \", $dnamut->restriction_changes, \"\\n\";\n\n    # add it to a SeqDiff container object\n    $seqdiff->add_Variant($dnamut);\n\n\n=head1 DESCRIPTION\n\nThe instantiable class Bio::Variation::DNAMutation describes basic\nsequence changes in genomic DNA level. It uses methods defined in\nsuperclass Bio::Variation::VariantI. See L<Bio::Variation::VariantI>\nfor details.\n\nIf the variation described by a DNAMutation object is transcibed, link\nthe corresponding Bio::Variation::RNAChange object to it using\nmethod RNAChange(). See L<Bio::Variation::RNAChange> for more information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::DNAMutation;\nuse strict;\n\n# Object preamble - inheritance\n\nuse base qw(Bio::Variation::VariantI);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($start, $end, $length, $strand, $primary, $source, \n\t$frame, $score, $gff_string,\n\t$allele_ori,  $allele_mut,  $upstreamseq,  $dnstreamseq,  \n\t$label,  $status,  $proof,  $region, $region_value, $region_dist, $numbering, \n\t$cpg, $mut_number, $ismutation) =\n\t    $self->_rearrange([qw(START\n\t\t\t\t  END\n\t\t\t\t  LENGTH\n\t\t\t\t  STRAND\n\t\t\t\t  PRIMARY\n\t\t\t\t  SOURCE\n\t\t\t\t  FRAME\n\t\t\t\t  SCORE\n\t\t\t\t  GFF_STRING\n\t\t\t\t  ALLELE_ORI\n\t\t\t\t  ALLELE_MUT\n\t\t\t\t  UPSTREAMSEQ\n\t\t\t\t  DNSTREAMSEQ\n\t\t\t\t  LABEL\n\t\t\t\t  STATUS\n\t\t\t\t  PROOF\n\t\t\t\t  REGION\n\t\t\t\t  REGION_VALUE\n\t\t\t\t  REGION_DIST\n\t\t\t\t  NUMBERING\n\t\t\t\t  CPG\n\t\t\t\t  MUT_NUMBER\n\t\t\t\t  ISMUTATION\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->primary_tag(\"Variation\");\n\n    $self->{ 'alleles' } = [];\n\n    $start && $self->start($start);\n    $end   && $self->end($end);\n    $length && $self->length($length);\n    $strand && $self->strand($strand);\n    $primary && $self->primary_tag($primary);\n    $source  && $self->source_tag($source);\n    $frame   && $self->frame($frame);\n    $score   && $self->score($score);\n    $gff_string && $self->_from_gff_string($gff_string);\n    \n    $allele_ori && $self->allele_ori($allele_ori);\n    $allele_mut  && $self->allele_mut($allele_mut);\n    $upstreamseq  && $self->upStreamSeq($upstreamseq);\n    $dnstreamseq  && $self->dnStreamSeq($dnstreamseq);\n    \n    $label  && $self->label($label);\n    $status  && $self->status($status);\n    $proof && $self->proof($proof);\n    $region  && $self->region($region);\n    $region_value  && $self->region_value($region_value);\n    $region_dist  && $self->region_dist($region_dist);\n    $numbering && $self->numbering($numbering);\n    $mut_number && $self->mut_number($mut_number);\n    $ismutation && $self->isMutation($ismutation);\n\n    $cpg && $self->CpG($cpg);\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 CpG\n\n Title   : CpG\n Usage   : $obj->CpG()\n Function: sets and returns boolean values for variation \n           hitting a CpG site.  Unset value return -1.\n Example : $obj->CpG()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub CpG {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n       $value ? ($value = 1) : ($value = 0);\n       $obj->{'cpg'} = $value;\n   }\n    elsif (not defined $obj->{'label'}) {\n\t$obj->{'cpg'} = $obj->_CpG_value;\n    }\n   else {\n       return $obj->{'cpg'};\n   }\n}\n\n\n\nsub _CpG_value {\n    my ($self) = @_;\n    if ($self->allele_ori eq $self->allele_mut and length ($self->allele_ori) == 1 ) {\n    \n\t# valid only for point mutations\n\t# CpG methylation-mediated deamination:\n\t#   CG -> TG | CG -> CA substitutions\n\t# implementation here is  less strict: if CpG dinucleotide was hit\n\t\n\tif ( ( ($self->allele_ori eq 'c') && (substr($self->upStreamSeq, 0, 1) eq 'g') ) ||\n\t     ( ($self->allele_ori eq 'g') && (substr($self->dnStreamSeq, -1, 1) eq 'c') ) ) {\n\t    return 1;\n\t}\n\telse {\n\t    return 0;\n\t}\n    } else {\n\t$self->warn('CpG makes sense only in the context of point mutation');\n\treturn;\n    }\n}\n\n\n=head2 RNAChange\n\n Title   : RNAChange\n Usage   : $mutobj = $obj->RNAChange;\n         : $mutobj = $obj->RNAChange($objref);\n Function: Returns or sets the link-reference to a mutation/change object.\n           If there is no link, it will return undef\n Returns : an obj_ref or undef\n\n\n\nsub RNAChange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$self]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNAChange'} = $value;\n      }\n  }\n  unless (exists $self->{'RNAChange'}) {\n      return;\n  } else {\n      return $self->{'RNAChange'};\n  }\n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable subclass of L<Bio::Variation::VariantI> needs\n            to implement this method. Valid values are listed in\n            'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string","label":"label($self,$value)"},"kind":12,"line":280,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"label","line":281,"kind":13},{"containerName":"label","name":"$value","kind":13,"line":281},{"name":"$o","definition":"my","containerName":"label","localvar":"my","kind":13,"line":282},{"line":282,"kind":13,"containerName":"label","name":"$m"},{"kind":13,"line":282,"containerName":"label","name":"$type"},{"containerName":"label","name":"$o","kind":13,"line":283},{"kind":13,"line":283,"name":"$self","containerName":"label"},{"containerName":"label","name":"allele_ori","line":283,"kind":12},{"line":283,"kind":12,"containerName":"label","name":"seq"},{"name":"$self","containerName":"label","kind":13,"line":283},{"kind":12,"line":283,"containerName":"label","name":"allele_ori"},{"name":"$self","containerName":"label","line":283,"kind":13},{"containerName":"label","name":"allele_ori","line":283,"kind":12},{"containerName":"label","name":"seq","line":283,"kind":12},{"containerName":"label","name":"$m","kind":13,"line":284},{"kind":13,"line":284,"containerName":"label","name":"$self"},{"line":284,"kind":12,"name":"allele_mut","containerName":"label"},{"name":"seq","containerName":"label","kind":12,"line":284},{"containerName":"label","name":"$self","line":284,"kind":13},{"line":284,"kind":12,"name":"allele_mut","containerName":"label"},{"line":284,"kind":13,"name":"$self","containerName":"label"},{"containerName":"label","name":"allele_mut","kind":12,"line":284},{"containerName":"label","name":"seq","line":284,"kind":12},{"kind":13,"line":286,"containerName":"label","name":"$o"},{"kind":13,"line":286,"containerName":"label","name":"$m"},{"name":"$self","containerName":"label","kind":13,"line":287},{"containerName":"label","name":"warn","kind":12,"line":287},{"name":"$type","containerName":"label","kind":13,"line":288},{"kind":13,"line":290,"name":"$o","containerName":"label"},{"name":"$m","containerName":"label","line":290,"kind":13},{"line":290,"kind":13,"containerName":"label","name":"$o"},{"kind":13,"line":290,"containerName":"label","name":"$m"},{"name":"$o","containerName":"label","line":290,"kind":13},{"containerName":"label","name":"$type","line":291,"kind":13},{"containerName":"label","name":"$type","kind":13,"line":292},{"name":"$o","containerName":"label","kind":13,"line":292},{"containerName":"label","name":"$m","kind":13,"line":292},{"name":"$o","containerName":"label","kind":13,"line":294},{"containerName":"label","name":"$type","kind":13,"line":295},{"name":"$m","containerName":"label","kind":13,"line":297},{"name":"$type","containerName":"label","line":298,"kind":13},{"name":"$type","containerName":"label","kind":13,"line":301},{"kind":13,"line":303,"containerName":"label","name":"$self"},{"kind":13,"line":303,"name":"$type","containerName":"label"},{"containerName":"label","name":"$self","kind":13,"line":304}],"name":"label","range":{"start":{"line":280,"character":0},"end":{"line":305,"character":9999}}},{"name":"_point_type_label","kind":12,"line":292},{"range":{"start":{"line":308,"character":0},"end":{"character":9999,"line":326}},"name":"_point_type_label","line":308,"children":[{"kind":13,"line":309,"containerName":"_point_type_label","definition":"my","name":"$o","localvar":"my"},{"line":309,"kind":13,"containerName":"_point_type_label","name":"$m"},{"localvar":"my","containerName":"_point_type_label","name":"$type","definition":"my","line":310,"kind":13},{"localvar":"my","containerName":"_point_type_label","name":"%transition","definition":"my","line":311,"kind":13},{"containerName":"_point_type_label","name":"$o","line":315,"kind":13},{"name":"$o","containerName":"_point_type_label","kind":13,"line":315},{"name":"$m","containerName":"_point_type_label","line":316,"kind":13},{"name":"$m","containerName":"_point_type_label","line":316,"kind":13},{"containerName":"_point_type_label","name":"$o","line":317,"kind":13},{"kind":13,"line":317,"containerName":"_point_type_label","name":"$m"},{"kind":13,"line":318,"name":"$type","containerName":"_point_type_label"},{"line":320,"kind":13,"name":"$transition","containerName":"_point_type_label"},{"name":"$o","containerName":"_point_type_label","line":320,"kind":13},{"line":320,"kind":13,"containerName":"_point_type_label","name":"$m"},{"name":"$type","containerName":"_point_type_label","kind":13,"line":321},{"containerName":"_point_type_label","name":"$type","kind":13,"line":324}],"kind":12,"detail":"($o,$m)","signature":{"parameters":[{"label":"$o"},{"label":"$m"}],"documentation":"","label":"_point_type_label($o,$m)"},"containerName":"main::","definition":"sub"},{"range":{"start":{"character":0,"line":345},"end":{"character":9999,"line":395}},"name":"sysname","children":[{"line":346,"kind":13,"localvar":"my","containerName":"sysname","name":"$self","definition":"my"},{"kind":13,"line":346,"name":"$value","containerName":"sysname"},{"name":"$value","containerName":"sysname","line":347,"kind":13},{"name":"$self","containerName":"sysname","line":348,"kind":13},{"containerName":"sysname","name":"$value","line":348,"kind":13},{"kind":13,"line":350,"name":"$self","containerName":"sysname"},{"name":"warn","containerName":"sysname","kind":12,"line":350},{"containerName":"sysname","name":"$self","kind":13,"line":351},{"containerName":"sysname","name":"start","kind":12,"line":351},{"localvar":"my","definition":"my","name":"$sysname","containerName":"sysname","line":352,"kind":13},{"kind":13,"line":354,"containerName":"sysname","definition":"my","name":"$mol","localvar":"my"},{"line":356,"kind":13,"containerName":"sysname","name":"$self"},{"line":356,"kind":12,"containerName":"sysname","name":"SeqDiff"},{"name":"$self","containerName":"sysname","line":357,"kind":13},{"name":"SeqDiff","containerName":"sysname","line":357,"kind":12},{"name":"$self","containerName":"sysname","kind":13,"line":357},{"containerName":"sysname","name":"SeqDiff","kind":12,"line":357},{"name":"alphabet","containerName":"sysname","line":357,"kind":12},{"kind":13,"line":357,"containerName":"sysname","name":"$self"},{"containerName":"sysname","name":"SeqDiff","line":357,"kind":12},{"name":"alphabet","containerName":"sysname","line":357,"kind":12},{"containerName":"sysname","name":"$mol","line":358,"kind":13},{"name":"$self","containerName":"sysname","kind":13,"line":360},{"name":"SeqDiff","containerName":"sysname","kind":12,"line":360},{"name":"alphabet","containerName":"sysname","line":360,"kind":12},{"line":360,"kind":13,"containerName":"sysname","name":"$self"},{"name":"SeqDiff","containerName":"sysname","line":360,"kind":12},{"kind":12,"line":360,"containerName":"sysname","name":"alphabet"},{"name":"$mol","containerName":"sysname","line":361,"kind":13},{"kind":13,"line":364,"name":"$sep","definition":"my","containerName":"sysname","localvar":"my"},{"name":"$self","containerName":"sysname","kind":13,"line":365},{"kind":12,"line":365,"name":"isMutation","containerName":"sysname"},{"line":366,"kind":13,"name":"$sep","containerName":"sysname"},{"name":"$sep","containerName":"sysname","line":368,"kind":13},{"kind":13,"line":370,"definition":"my","name":"$sign","containerName":"sysname","localvar":"my"},{"line":371,"kind":13,"name":"$sign","containerName":"sysname"},{"kind":13,"line":371,"containerName":"sysname","name":"$self"},{"containerName":"sysname","name":"start","kind":12,"line":371},{"kind":13,"line":372,"containerName":"sysname","name":"$sysname"},{"name":"$mol","containerName":"sysname","line":372,"kind":13},{"name":"$sysname","containerName":"sysname","kind":13,"line":373},{"containerName":"sysname","name":"$sign","kind":13,"line":373},{"kind":13,"line":373,"containerName":"sysname","name":"$self"},{"containerName":"sysname","name":"start","kind":12,"line":373},{"localvar":"my","containerName":"sysname","definition":"my","name":"@alleles","line":375,"kind":13},{"kind":13,"line":375,"name":"$self","containerName":"sysname"},{"containerName":"sysname","name":"each_Allele","line":375,"kind":12},{"line":376,"kind":13,"containerName":"sysname","name":"$self"},{"kind":12,"line":376,"containerName":"sysname","name":"allele_mut"},{"containerName":"sysname","name":"$alleles","line":376,"kind":13},{"containerName":"sysname","name":"$sysname","kind":13,"line":378},{"name":"$self","containerName":"sysname","kind":13,"line":378},{"containerName":"sysname","name":"label","kind":12,"line":378},{"kind":13,"line":379,"name":"$sysname","containerName":"sysname"},{"line":379,"kind":13,"name":"$self","containerName":"sysname"},{"name":"label","containerName":"sysname","line":379,"kind":12},{"containerName":"sysname","name":"$sysname","kind":13,"line":380},{"containerName":"sysname","name":"$self","kind":13,"line":380},{"containerName":"sysname","name":"allele_ori","kind":12,"line":380},{"line":380,"kind":12,"name":"seq","containerName":"sysname"},{"name":"$self","containerName":"sysname","kind":13,"line":380},{"containerName":"sysname","name":"allele_ori","line":380,"kind":12},{"line":380,"kind":12,"containerName":"sysname","name":"seq"},{"line":385,"kind":13,"localvar":"my","containerName":"sysname","definition":"my","name":"$allele"},{"kind":13,"line":385,"name":"@alleles","containerName":"sysname"},{"line":386,"kind":13,"name":"$self","containerName":"sysname"},{"containerName":"sysname","name":"allele_mut","line":386,"kind":12},{"name":"$allele","containerName":"sysname","line":386,"kind":13},{"kind":13,"line":387,"name":"$sysname","containerName":"sysname"},{"containerName":"sysname","name":"$sep","line":387,"kind":13},{"line":387,"kind":13,"name":"$self","containerName":"sysname"},{"line":387,"kind":12,"containerName":"sysname","name":"label"},{"line":387,"kind":13,"containerName":"sysname","name":"$self"},{"containerName":"sysname","name":"label","kind":12,"line":387},{"line":388,"kind":13,"containerName":"sysname","name":"$sysname"},{"line":388,"kind":13,"containerName":"sysname","name":"$self"},{"kind":12,"line":388,"name":"allele_mut","containerName":"sysname"},{"containerName":"sysname","name":"seq","line":388,"kind":12},{"containerName":"sysname","name":"$self","kind":13,"line":388},{"name":"allele_mut","containerName":"sysname","line":388,"kind":12},{"line":388,"kind":12,"containerName":"sysname","name":"seq"},{"containerName":"sysname","name":"$self","kind":13,"line":390},{"kind":13,"line":390,"name":"$sysname","containerName":"sysname"},{"kind":13,"line":394,"containerName":"sysname","name":"$self"}],"line":345,"kind":12,"signature":{"documentation":"1;\n# $Id: DNAMutation.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::DNAMutation\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::DNAMutation - DNA level mutation class\n\n=head1 SYNOPSIS\n\n    $dnamut = Bio::Variation::DNAMutation->new\n        ('-start'         => $start,\n         '-end'           => $end,\n         '-length'        => $len,\n         '-upStreamSeq'   => $upflank,\n         '-dnStreamSeq'   => $dnflank,\n         '-proof'         => $proof,\n\t '-isMutation'    => 1,\n         '-mut_number'    => $mut_number\n        );\n    $a1 = Bio::Variation::Allele->new;\n    $a1->seq('a');\n    $dnamut->allele_ori($a1);\n    my $a2 = Bio::Variation::Allele->new;\n    $a2->seq('t');\n    $dnamut->add_Allele($a2);\n\n    print \"Restriction changes are \", $dnamut->restriction_changes, \"\\n\";\n\n    # add it to a SeqDiff container object\n    $seqdiff->add_Variant($dnamut);\n\n\n=head1 DESCRIPTION\n\nThe instantiable class Bio::Variation::DNAMutation describes basic\nsequence changes in genomic DNA level. It uses methods defined in\nsuperclass Bio::Variation::VariantI. See L<Bio::Variation::VariantI>\nfor details.\n\nIf the variation described by a DNAMutation object is transcibed, link\nthe corresponding Bio::Variation::RNAChange object to it using\nmethod RNAChange(). See L<Bio::Variation::RNAChange> for more information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::DNAMutation;\nuse strict;\n\n# Object preamble - inheritance\n\nuse base qw(Bio::Variation::VariantI);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($start, $end, $length, $strand, $primary, $source, \n\t$frame, $score, $gff_string,\n\t$allele_ori,  $allele_mut,  $upstreamseq,  $dnstreamseq,  \n\t$label,  $status,  $proof,  $region, $region_value, $region_dist, $numbering, \n\t$cpg, $mut_number, $ismutation) =\n\t    $self->_rearrange([qw(START\n\t\t\t\t  END\n\t\t\t\t  LENGTH\n\t\t\t\t  STRAND\n\t\t\t\t  PRIMARY\n\t\t\t\t  SOURCE\n\t\t\t\t  FRAME\n\t\t\t\t  SCORE\n\t\t\t\t  GFF_STRING\n\t\t\t\t  ALLELE_ORI\n\t\t\t\t  ALLELE_MUT\n\t\t\t\t  UPSTREAMSEQ\n\t\t\t\t  DNSTREAMSEQ\n\t\t\t\t  LABEL\n\t\t\t\t  STATUS\n\t\t\t\t  PROOF\n\t\t\t\t  REGION\n\t\t\t\t  REGION_VALUE\n\t\t\t\t  REGION_DIST\n\t\t\t\t  NUMBERING\n\t\t\t\t  CPG\n\t\t\t\t  MUT_NUMBER\n\t\t\t\t  ISMUTATION\n\t\t\t\t  )],\n\t\t\t      @args);\n\n    $self->primary_tag(\"Variation\");\n\n    $self->{ 'alleles' } = [];\n\n    $start && $self->start($start);\n    $end   && $self->end($end);\n    $length && $self->length($length);\n    $strand && $self->strand($strand);\n    $primary && $self->primary_tag($primary);\n    $source  && $self->source_tag($source);\n    $frame   && $self->frame($frame);\n    $score   && $self->score($score);\n    $gff_string && $self->_from_gff_string($gff_string);\n    \n    $allele_ori && $self->allele_ori($allele_ori);\n    $allele_mut  && $self->allele_mut($allele_mut);\n    $upstreamseq  && $self->upStreamSeq($upstreamseq);\n    $dnstreamseq  && $self->dnStreamSeq($dnstreamseq);\n    \n    $label  && $self->label($label);\n    $status  && $self->status($status);\n    $proof && $self->proof($proof);\n    $region  && $self->region($region);\n    $region_value  && $self->region_value($region_value);\n    $region_dist  && $self->region_dist($region_dist);\n    $numbering && $self->numbering($numbering);\n    $mut_number && $self->mut_number($mut_number);\n    $ismutation && $self->isMutation($ismutation);\n\n    $cpg && $self->CpG($cpg);\n    \n    return $self; # success - we hope!\n}\n\n\n=head2 CpG\n\n Title   : CpG\n Usage   : $obj->CpG()\n Function: sets and returns boolean values for variation \n           hitting a CpG site.  Unset value return -1.\n Example : $obj->CpG()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub CpG {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n       $value ? ($value = 1) : ($value = 0);\n       $obj->{'cpg'} = $value;\n   }\n    elsif (not defined $obj->{'label'}) {\n\t$obj->{'cpg'} = $obj->_CpG_value;\n    }\n   else {\n       return $obj->{'cpg'};\n   }\n}\n\n\n\nsub _CpG_value {\n    my ($self) = @_;\n    if ($self->allele_ori eq $self->allele_mut and length ($self->allele_ori) == 1 ) {\n    \n\t# valid only for point mutations\n\t# CpG methylation-mediated deamination:\n\t#   CG -> TG | CG -> CA substitutions\n\t# implementation here is  less strict: if CpG dinucleotide was hit\n\t\n\tif ( ( ($self->allele_ori eq 'c') && (substr($self->upStreamSeq, 0, 1) eq 'g') ) ||\n\t     ( ($self->allele_ori eq 'g') && (substr($self->dnStreamSeq, -1, 1) eq 'c') ) ) {\n\t    return 1;\n\t}\n\telse {\n\t    return 0;\n\t}\n    } else {\n\t$self->warn('CpG makes sense only in the context of point mutation');\n\treturn;\n    }\n}\n\n\n=head2 RNAChange\n\n Title   : RNAChange\n Usage   : $mutobj = $obj->RNAChange;\n         : $mutobj = $obj->RNAChange($objref);\n Function: Returns or sets the link-reference to a mutation/change object.\n           If there is no link, it will return undef\n Returns : an obj_ref or undef\n\n\n\nsub RNAChange {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::RNAChange') ) {\n\t  $self->throw(\"Is not a Bio::Variation::RNAChange object but a [$self]\");\n\t  return;\n      }\n      else {\n\t  $self->{'RNAChange'} = $value;\n      }\n  }\n  unless (exists $self->{'RNAChange'}) {\n      return;\n  } else {\n      return $self->{'RNAChange'};\n  }\n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable subclass of L<Bio::Variation::VariantI> needs\n            to implement this method. Valid values are listed in\n            'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self, $value) = @_;\n    my ($o, $m, $type);\n    $o = $self->allele_ori->seq if $self->allele_ori and $self->allele_ori->seq;\n    $m = $self->allele_mut->seq if $self->allele_mut and $self->allele_mut->seq;\n    \n    if (not $o and not $m ) {\n\t$self->warn(\"[DNAMutation, label] Both alleles should not be empty!\\n\");\n\t$type = 'no change'; # is this enough?\n    }\n    elsif ($o && $m && length($o) == length($m) && length($o) == 1) {\n\t$type = 'point';\n\t$type .= \", \". _point_type_label($o, $m);\n    }\n    elsif (not $o ) {\n\t$type = 'insertion';\n    }\n    elsif (not $m  ) {\n\t$type = 'deletion';\n    }\n    else {\n\t$type = 'complex';\n    }\n    $self->{'label'} = $type;\n    return $self->{'label'};\n}\n\n\nsub _point_type_label {\n    my ($o, $m) = @_;\n    my ($type);\n    my %transition = ('a' => 'g',\n\t\t   'g' => 'a',\n\t\t   'c' => 't',\n\t\t   't' => 'c');\n    $o = lc $o;\n    $m = lc $m;\n    if ($o eq $m) {\n\t$type = 'no change';\n    }\n    elsif ($transition{$o} eq $m ) {\n\t$type = 'transition';\n    }\n    else {\n\t$type = 'transversion';\n    }\n}\n\n\n=head2 sysname\n\n Title   : sysname\n Usage   : $self->sysname\n Function: \n\n           This subroutine creates a string corresponding to the\n           'systematic name' of the mutation. Systematic name is\n           specified in Antonorakis & MDI Nomenclature Working Group:\n           Human Mutation 11:1-3, 1998. \n           \n Returns : string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"sysname($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"}]}