{"version":5,"vars":[{"line":84,"kind":2,"name":"base","containerName":""},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: tabtree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::tabtree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::tabtree - A simple output format which displays a tree as an ASCII drawing\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'tabtree');\n\n  while( my $tree = $in->next_tree ) {\n      $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis is a made up format just for outputting trees as an ASCII drawing.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::tabtree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::tabtree->new();\n Function: Builds a new Bio::TreeIO::tabtree object \n Returns : Bio::TreeIO::tabtree\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":97,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":98,"kind":13},{"containerName":"new","name":"@args","line":98,"kind":13},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":100,"kind":13},{"kind":13,"line":100,"containerName":"new","name":"$class"},{"kind":13,"line":100,"containerName":"new","name":"@args"}],"kind":12,"range":{"end":{"line":102,"character":9999},"start":{"line":97,"character":0}},"name":"new"},{"line":100,"kind":12,"containerName":"new","name":"SUPER"},{"range":{"end":{"character":9999,"line":120},"start":{"character":0,"line":114}},"name":"write_tree","detail":"($self,$tree)","signature":{"documentation":"1;\n# $Id: tabtree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::tabtree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::tabtree - A simple output format which displays a tree as an ASCII drawing\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'tabtree');\n\n  while( my $tree = $in->next_tree ) {\n      $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis is a made up format just for outputting trees as an ASCII drawing.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::tabtree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::tabtree->new();\n Function: Builds a new Bio::TreeIO::tabtree object \n Returns : Bio::TreeIO::tabtree\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in newick/phylip format\n Returns : none\n Args    : Bio::Tree::TreeI object","parameters":[{"label":"$self"},{"label":"$tree"}],"label":"write_tree($self,$tree)"},"containerName":"main::","definition":"sub","line":114,"children":[{"kind":13,"line":115,"definition":"my","name":"$self","containerName":"write_tree","localvar":"my"},{"containerName":"write_tree","name":"$tree","line":115,"kind":13},{"kind":13,"line":116,"containerName":"write_tree","definition":"my","name":"$line","localvar":"my"},{"kind":13,"line":116,"containerName":"write_tree","name":"$tree"},{"containerName":"write_tree","name":"get_root_node","kind":12,"line":116},{"line":117,"kind":13,"name":"$self","containerName":"write_tree"},{"name":"_print","containerName":"write_tree","kind":12,"line":117},{"kind":13,"line":117,"containerName":"write_tree","name":"$line"},{"name":"$self","containerName":"write_tree","line":118,"kind":13},{"containerName":"write_tree","name":"flush","line":118,"kind":12},{"containerName":"write_tree","name":"$self","line":118,"kind":13},{"name":"_flush_on_write","containerName":"write_tree","kind":12,"line":118},{"kind":13,"line":118,"name":"$self","containerName":"write_tree"},{"containerName":"write_tree","name":"_fh","kind":12,"line":118}],"kind":12},{"kind":12,"line":116,"name":"_write_tree_Helper"},{"name":"_write_tree_Helper","range":{"start":{"line":122,"character":0},"end":{"character":9999,"line":144}},"kind":12,"children":[{"kind":13,"line":123,"containerName":"_write_tree_Helper","definition":"my","name":"$node","localvar":"my"},{"name":"$indent","containerName":"_write_tree_Helper","kind":13,"line":123},{"name":"$node","containerName":"_write_tree_Helper","line":124,"kind":13},{"kind":13,"line":126,"containerName":"_write_tree_Helper","name":"@d","definition":"my","localvar":"my"},{"containerName":"_write_tree_Helper","name":"$node","line":126,"kind":13},{"name":"each_Descendent","containerName":"_write_tree_Helper","line":126,"kind":12},{"kind":13,"line":127,"containerName":"_write_tree_Helper","definition":"my","name":"$line","localvar":"my"},{"kind":13,"line":128,"definition":"my","name":"$i","containerName":"_write_tree_Helper","localvar":"my"},{"containerName":"_write_tree_Helper","name":"$lastchild","kind":13,"line":128},{"line":128,"kind":13,"containerName":"_write_tree_Helper","name":"@d"},{"kind":13,"line":129,"containerName":"_write_tree_Helper","name":"$n","definition":"my","localvar":"my"},{"name":"@d","containerName":"_write_tree_Helper","kind":13,"line":129},{"name":"$n","containerName":"_write_tree_Helper","line":130,"kind":13},{"containerName":"_write_tree_Helper","name":"is_Leaf","line":130,"kind":12},{"name":"$line","containerName":"_write_tree_Helper","kind":13,"line":131},{"line":132,"kind":13,"name":"$indent","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$indent","kind":13,"line":132},{"name":"$n","containerName":"_write_tree_Helper","kind":13,"line":132},{"name":"id","containerName":"_write_tree_Helper","line":132,"kind":12},{"name":"$line","containerName":"_write_tree_Helper","kind":13,"line":134},{"kind":13,"line":134,"containerName":"_write_tree_Helper","name":"$n"},{"line":134,"kind":12,"containerName":"_write_tree_Helper","name":"id"},{"kind":13,"line":135,"containerName":"_write_tree_Helper","name":"$n"},{"name":"id","containerName":"_write_tree_Helper","kind":12,"line":135},{"kind":13,"line":137,"containerName":"_write_tree_Helper","name":"$new_indent","definition":"my","localvar":"my"},{"name":"$indent","containerName":"_write_tree_Helper","line":137,"kind":13},{"kind":13,"line":137,"name":"$i","containerName":"_write_tree_Helper"},{"line":137,"kind":13,"containerName":"_write_tree_Helper","name":"$lastchild"},{"name":"$n","containerName":"_write_tree_Helper","line":138,"kind":13},{"containerName":"_write_tree_Helper","name":"$node","kind":13,"line":138},{"line":140,"kind":13,"name":"$line","containerName":"_write_tree_Helper"},{"kind":13,"line":140,"name":"$n","containerName":"_write_tree_Helper"},{"line":140,"kind":13,"containerName":"_write_tree_Helper","name":"$new_indent"},{"name":"$line","containerName":"_write_tree_Helper","kind":13,"line":143}],"line":122,"definition":"sub","containerName":"main::","signature":{"label":"_write_tree_Helper($node,$indent)","parameters":[{"label":"$node"},{"label":"$indent"}],"documentation":""},"detail":"($node,$indent)"},{"kind":12,"line":157,"children":[{"name":"throw","containerName":"next_tree","line":158,"kind":12}],"containerName":"main::","definition":"sub","name":"next_tree","range":{"start":{"character":0,"line":157},"end":{"character":9999,"line":159}}}]}