{"vars":[{"containerName":"","name":"base","kind":2,"line":91},{"containerName":"main::","name":"INTERNAL_NODE_ID","definition":1,"kind":14,"line":93},{"name":"new","range":{"start":{"line":116,"character":0},"end":{"line":139,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"new($caller,@args)","documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'","parameters":[{"label":"$caller"},{"label":"@args"}]},"detail":"($caller,@args)","kind":12,"children":[{"name":"$caller","definition":"my","containerName":"new","localvar":"my","kind":13,"line":117},{"line":117,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":118},{"containerName":"new","name":"$caller","line":118,"kind":13},{"name":"$caller","containerName":"new","line":118,"kind":13},{"name":"$class","containerName":"new","kind":13,"line":122},{"line":123,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"kind":13,"line":123,"name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":123},{"line":124,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_initialize","kind":12,"line":124},{"kind":13,"line":124,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":125},{"name":"%param","definition":"my","containerName":"new","localvar":"my","kind":13,"line":128},{"line":128,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":129,"name":"@param","containerName":"new"},{"containerName":"new","name":"%param","kind":13,"line":129},{"line":129,"kind":13,"containerName":"new","name":"%param"},{"line":130,"kind":13,"localvar":"my","definition":"my","name":"$format","containerName":"new"},{"name":"$param","containerName":"new","line":130,"kind":13},{"kind":13,"line":131,"containerName":"new","name":"$class"},{"kind":12,"line":131,"containerName":"new","name":"_guess_format"},{"containerName":"new","name":"$param","kind":13,"line":131},{"kind":13,"line":131,"name":"$ARGV","containerName":"new"},{"name":"$format","containerName":"new","kind":13,"line":133},{"containerName":"new","name":"$class","line":136,"kind":13},{"line":136,"kind":12,"name":"_load_format_module","containerName":"new"},{"kind":13,"line":136,"containerName":"new","name":"$format"},{"line":137,"kind":12,"name":"new","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":137}],"line":116},{"kind":12,"line":123,"name":"SUPER","containerName":"new"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none","label":"next_tree($self)"},"detail":"($self)","kind":12,"children":[{"kind":13,"line":153,"definition":"my","name":"$self","containerName":"next_tree","localvar":"my"},{"containerName":"next_tree","name":"$self","kind":13,"line":154},{"name":"throw","containerName":"next_tree","line":154,"kind":12}],"line":152,"name":"next_tree","range":{"end":{"character":9999,"line":155},"start":{"line":152,"character":0}}},{"name":"write_tree","range":{"end":{"character":9999,"line":171},"start":{"line":168,"character":0}},"kind":12,"line":168,"children":[{"kind":13,"line":169,"name":"$self","definition":"my","containerName":"write_tree","localvar":"my"},{"containerName":"write_tree","name":"$tree","line":169,"kind":13},{"name":"$self","containerName":"write_tree","kind":13,"line":170},{"name":"throw","containerName":"write_tree","line":170,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,$tree)","signature":{"label":"write_tree($self,$tree)","parameters":[{"label":"$self"},{"label":"$tree"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI"}},{"detail":"($self,$handler)","signature":{"label":"attach_EventHandler($self,$handler)","parameters":[{"label":"$self"},{"label":"$handler"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI\n\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   $self->throw(\"Cannot call method write_tree on Bio::TreeIO object must use a subclass\");\n}\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::Event::EventHandlerI"},"containerName":"main::","definition":"sub","line":184,"children":[{"localvar":"my","containerName":"attach_EventHandler","name":"$self","definition":"my","line":185,"kind":13},{"name":"$handler","containerName":"attach_EventHandler","line":185,"kind":13},{"line":186,"kind":13,"containerName":"attach_EventHandler","name":"$handler"},{"line":187,"kind":13,"name":"$handler","containerName":"attach_EventHandler"},{"name":"isa","containerName":"attach_EventHandler","line":187,"kind":12},{"name":"$self","containerName":"attach_EventHandler","kind":13,"line":188},{"containerName":"attach_EventHandler","name":"warn","line":188,"kind":12},{"containerName":"attach_EventHandler","name":"$handler","kind":13,"line":188},{"containerName":"attach_EventHandler","name":"$self","line":190,"kind":13},{"containerName":"attach_EventHandler","name":"$handler","line":190,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":184},"end":{"character":9999,"line":192}},"name":"attach_EventHandler"},{"name":"_eventHandler","range":{"start":{"character":0,"line":205},"end":{"character":9999,"line":208}},"kind":12,"line":205,"children":[{"containerName":"_eventHandler","definition":"my","name":"$self","localvar":"my","kind":13,"line":206},{"kind":13,"line":207,"name":"$self","containerName":"_eventHandler"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI\n\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   $self->throw(\"Cannot call method write_tree on Bio::TreeIO object must use a subclass\");\n}\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::Event::EventHandlerI\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n    $self->warn(\"Ignoring request to attach handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::Event::EventHandlerI\n Args    : none","label":"_eventHandler($self)"}},{"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_initialize","line":211,"kind":13},{"name":"@args","containerName":"_initialize","kind":13,"line":211},{"kind":13,"line":212,"name":"$self","containerName":"_initialize"},{"localvar":"my","name":"$internal_node_id","definition":"my","containerName":"_initialize","line":213,"kind":13},{"containerName":"_initialize","name":"$self","line":214,"kind":13},{"line":215,"kind":13,"containerName":"_initialize","name":"$self"},{"line":215,"kind":13,"name":"$internal_node_id","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":215,"kind":13},{"kind":12,"line":216,"name":"_rearrange","containerName":"_initialize"},{"kind":13,"line":216,"containerName":"_initialize","name":"@args"},{"name":"$self","containerName":"_initialize","kind":13,"line":219},{"containerName":"_initialize","name":"_initialize_io","line":219,"kind":12},{"line":219,"kind":13,"name":"@args","containerName":"_initialize"},{"line":220,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":220,"containerName":"_initialize","name":"attach_EventHandler"},{"containerName":"_initialize","name":"new","kind":12,"line":221},{"name":"$self","containerName":"_initialize","kind":13,"line":221},{"containerName":"_initialize","name":"verbose","line":221,"kind":12},{"line":221,"kind":13,"name":"@args","containerName":"_initialize"},{"kind":13,"line":222,"name":"$self","containerName":"_initialize"},{"kind":12,"line":222,"name":"internal_node_id","containerName":"_initialize"},{"line":222,"kind":13,"containerName":"_initialize","name":"$internal_node_id"},{"kind":13,"line":222,"containerName":"_initialize","name":"$internal_node_id"}],"line":210,"name":"_initialize","range":{"end":{"line":223,"character":9999},"start":{"line":210,"character":0}}},{"kind":12,"line":214,"name":"INTERNAL_NODE_ID"},{"containerName":"TreeIO::TreeEventBuilder","name":"Bio","kind":12,"line":220},{"range":{"start":{"character":0,"line":236},"end":{"line":254,"character":9999}},"name":"_load_format_module","children":[{"localvar":"my","containerName":"_load_format_module","name":"$self","definition":"my","line":237,"kind":13},{"line":237,"kind":13,"name":"$format","containerName":"_load_format_module"},{"line":238,"kind":13,"localvar":"my","definition":"my","name":"$module","containerName":"_load_format_module"},{"containerName":"_load_format_module","name":"$format","line":238,"kind":13},{"localvar":"my","definition":"my","name":"$ok","containerName":"_load_format_module","line":239,"kind":13},{"containerName":"_load_format_module","name":"$ok","kind":13,"line":242},{"containerName":"_load_format_module","name":"$self","kind":13,"line":242},{"line":242,"kind":12,"name":"_load_module","containerName":"_load_format_module"},{"containerName":"_load_format_module","name":"$module","kind":13,"line":242},{"containerName":"_load_format_module","name":"$ok","kind":13,"line":253}],"line":236,"kind":12,"signature":{"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI\n\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   $self->throw(\"Cannot call method write_tree on Bio::TreeIO object must use a subclass\");\n}\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::Event::EventHandlerI\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n    $self->warn(\"Ignoring request to attach handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::Event::EventHandlerI\n Args    : none\n\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    my $internal_node_id;\n    $self->{'internal_node_id'} = INTERNAL_NODE_ID;\n    ($self->{'newline_each_node'},$internal_node_id) = $self->_rearrange\n    ([qw(NEWLINE_EACH_NODE INTERNAL_NODE_ID)],@args);\n    \n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::TreeIO::TreeEventBuilder->new\n                   (-verbose => $self->verbose(), @args));\n    $self->internal_node_id($internal_node_id) if defined $internal_node_id;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL TreeIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}],"label":"_load_format_module($self,$format)"},"detail":"($self,$format)","definition":"sub","containerName":"main::"},{"line":269,"children":[{"kind":13,"line":270,"definition":"my","name":"$self","containerName":"newline_each_node","localvar":"my"},{"kind":13,"line":271,"name":"$self","containerName":"newline_each_node"},{"containerName":"newline_each_node","name":"$self","line":272,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":273},"start":{"character":0,"line":269}},"containerName":"main::","name":"newline_each_node","definition":"sub"},{"containerName":"main::","name":"internal_node_id","definition":"sub","range":{"start":{"line":287,"character":0},"end":{"line":301,"character":9999}},"kind":12,"line":287,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"internal_node_id","line":288,"kind":13},{"line":289,"kind":13,"localvar":"my","definition":"my","name":"$val","containerName":"internal_node_id"},{"name":"$val","containerName":"internal_node_id","kind":13,"line":290},{"line":291,"kind":13,"name":"$val","containerName":"internal_node_id"},{"kind":13,"line":292,"name":"$val","containerName":"internal_node_id"},{"name":"$val","containerName":"internal_node_id","line":293,"kind":13},{"line":294,"kind":13,"containerName":"internal_node_id","name":"$val"},{"containerName":"internal_node_id","name":"$self","line":296,"kind":13},{"kind":12,"line":296,"name":"warn","containerName":"internal_node_id"},{"line":298,"kind":13,"name":"$self","containerName":"internal_node_id"},{"containerName":"internal_node_id","name":"$val","kind":13,"line":298},{"containerName":"internal_node_id","name":"$self","kind":13,"line":300}]},{"containerName":"main::","definition":"sub","name":"_guess_format","range":{"start":{"line":315,"character":0},"end":{"line":323,"character":9999}},"kind":12,"line":315,"children":[{"localvar":"my","containerName":"_guess_format","name":"$class","definition":"my","line":316,"kind":13}]},{"range":{"start":{"character":0,"line":325},"end":{"character":9999,"line":329}},"containerName":"main::","name":"DESTROY","definition":"sub","line":325,"children":[{"line":326,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"DESTROY"},{"name":"$self","containerName":"DESTROY","kind":13,"line":328},{"line":328,"kind":12,"name":"close","containerName":"DESTROY"}],"kind":12},{"children":[{"localvar":"my","containerName":"TIEHANDLE","definition":"my","name":"$class","line":332,"kind":13},{"containerName":"TIEHANDLE","name":"$class","line":333,"kind":13}],"line":331,"kind":12,"range":{"start":{"character":0,"line":331},"end":{"line":334,"character":9999}},"name":"TIEHANDLE","definition":"sub","containerName":"main::"},{"line":336,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"READLINE","line":337,"kind":13},{"name":"$self","containerName":"READLINE","kind":13,"line":338},{"containerName":"READLINE","name":"next_tree","kind":12,"line":338},{"line":339,"kind":13,"localvar":"my","name":"@list","definition":"my","containerName":"READLINE"},{"name":"$obj","containerName":"READLINE","kind":13,"line":339},{"line":340,"kind":13,"containerName":"READLINE","name":"@list"},{"line":340,"kind":13,"name":"$obj","containerName":"READLINE"},{"containerName":"READLINE","name":"$obj","kind":13,"line":340},{"name":"$self","containerName":"READLINE","line":340,"kind":13},{"containerName":"READLINE","name":"next_tree","kind":12,"line":340},{"kind":13,"line":341,"containerName":"READLINE","name":"@list"}],"kind":12,"range":{"start":{"line":336,"character":0},"end":{"line":342,"character":9999}},"containerName":"main::","definition":"sub","name":"READLINE"},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"PRINT","line":345,"kind":13},{"containerName":"PRINT","name":"$self","line":346,"kind":13},{"kind":12,"line":346,"containerName":"PRINT","name":"write_tree"}],"line":344,"name":"PRINT","definition":"sub","containerName":"main::","range":{"start":{"line":344,"character":0},"end":{"character":9999,"line":347}}}],"version":5}