{"version":5,"vars":[{"line":93,"kind":2,"name":"UNIVERSAL","containerName":""},{"line":95,"kind":2,"containerName":"","name":"base"},{"range":{"end":{"line":146,"character":9999},"start":{"line":110,"character":0}},"name":"find_node","line":110,"children":[{"line":111,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"find_node"},{"containerName":"find_node","name":"$type","kind":13,"line":111},{"kind":13,"line":111,"containerName":"find_node","name":"$field"},{"line":112,"kind":13,"containerName":"find_node","name":"$type"},{"containerName":"find_node","name":"$self","kind":13,"line":113},{"name":"warn","containerName":"find_node","line":113,"kind":12},{"containerName":"find_node","name":"$field","kind":13,"line":122},{"containerName":"find_node","name":"$field","kind":13,"line":124},{"line":124,"kind":13,"containerName":"find_node","name":"$type"},{"name":"$type","containerName":"find_node","kind":13,"line":125},{"line":127,"kind":13,"containerName":"find_node","name":"$type"},{"kind":13,"line":135,"containerName":"find_node","name":"@nodes","definition":"my","localvar":"my"},{"kind":12,"line":135,"name":"can","containerName":"find_node"},{"name":"$type","containerName":"find_node","kind":13,"line":135},{"line":135,"kind":13,"name":"$type","containerName":"find_node"},{"name":"$type","containerName":"find_node","line":136,"kind":13},{"containerName":"find_node","name":"$field","kind":13,"line":136},{"line":136,"kind":13,"containerName":"find_node","name":"$self"},{"kind":12,"line":136,"name":"get_nodes","containerName":"find_node"},{"kind":13,"line":139,"containerName":"find_node","name":"@nodes"},{"kind":13,"line":141,"name":"@nodes","containerName":"find_node"},{"kind":13,"line":142,"name":"$self","containerName":"find_node"},{"line":142,"kind":12,"name":"warn","containerName":"find_node"},{"kind":13,"line":144,"name":"@nodes","containerName":"find_node"}],"kind":12,"detail":"($self,$type,$field)","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$field"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring","label":"find_node($self,$type,$field)"},"containerName":"main::","definition":"sub"},{"children":[{"localvar":"my","containerName":"remove_Node","name":"$self","definition":"my","line":159,"kind":13},{"containerName":"remove_Node","name":"$input","line":159,"kind":13},{"kind":13,"line":160,"containerName":"remove_Node","name":"$node","definition":"my","localvar":"my"},{"name":"$input","containerName":"remove_Node","line":161,"kind":13},{"name":"$node","containerName":"remove_Node","kind":13,"line":162},{"containerName":"remove_Node","name":"$self","line":162,"kind":13},{"containerName":"remove_Node","name":"find_node","line":162,"kind":12},{"line":162,"kind":13,"name":"$input","containerName":"remove_Node"},{"name":"$input","containerName":"remove_Node","kind":13,"line":163},{"name":"isa","containerName":"remove_Node","kind":12,"line":163},{"containerName":"remove_Node","name":"$self","line":164,"kind":13},{"line":164,"kind":12,"containerName":"remove_Node","name":"warn"},{"containerName":"remove_Node","name":"$node","kind":13,"line":167},{"containerName":"remove_Node","name":"$input","kind":13,"line":167},{"line":169,"kind":13,"name":"$node","containerName":"remove_Node"},{"containerName":"remove_Node","name":"ancestor","kind":12,"line":169},{"name":"$self","containerName":"remove_Node","line":170,"kind":13},{"line":170,"kind":12,"containerName":"remove_Node","name":"get_root_node"},{"containerName":"remove_Node","name":"internal_id","kind":12,"line":170},{"containerName":"remove_Node","name":"$node","kind":13,"line":170},{"line":170,"kind":12,"containerName":"remove_Node","name":"internal_id"},{"name":"$self","containerName":"remove_Node","line":171,"kind":13},{"name":"warn","containerName":"remove_Node","line":171,"kind":12},{"containerName":"remove_Node","name":"$node","kind":13,"line":171},{"containerName":"remove_Node","name":"to_string","kind":12,"line":171},{"name":"$node","containerName":"remove_Node","line":173,"kind":13},{"line":173,"kind":12,"containerName":"remove_Node","name":"ancestor"},{"name":"remove_Descendent","containerName":"remove_Node","kind":12,"line":173},{"line":173,"kind":13,"name":"$node","containerName":"remove_Node"}],"line":158,"kind":12,"signature":{"label":"remove_Node($self,$input)","parameters":[{"label":"$self"},{"label":"$input"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id"},"detail":"($self,$input)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":175},"start":{"character":0,"line":158}},"name":"remove_Node"},{"line":188,"children":[{"containerName":"get_lineage_nodes","definition":"my","name":"$self","localvar":"my","kind":13,"line":189},{"line":189,"kind":13,"containerName":"get_lineage_nodes","name":"$input"},{"kind":13,"line":190,"containerName":"get_lineage_nodes","name":"$node","definition":"my","localvar":"my"},{"kind":13,"line":191,"containerName":"get_lineage_nodes","name":"$input"},{"line":192,"kind":13,"containerName":"get_lineage_nodes","name":"$node"},{"kind":13,"line":192,"name":"$self","containerName":"get_lineage_nodes"},{"kind":12,"line":192,"name":"find_node","containerName":"get_lineage_nodes"},{"line":192,"kind":13,"name":"$input","containerName":"get_lineage_nodes"},{"containerName":"get_lineage_nodes","name":"$input","kind":13,"line":194},{"containerName":"get_lineage_nodes","name":"isa","kind":12,"line":194},{"containerName":"get_lineage_nodes","name":"$self","line":195,"kind":13},{"containerName":"get_lineage_nodes","name":"warn","line":195,"kind":12},{"line":199,"kind":13,"name":"$node","containerName":"get_lineage_nodes"},{"containerName":"get_lineage_nodes","name":"$input","line":199,"kind":13},{"localvar":"my","containerName":"get_lineage_nodes","definition":"my","name":"$root","line":205,"kind":13},{"containerName":"get_lineage_nodes","name":"$self","kind":13,"line":205},{"containerName":"get_lineage_nodes","name":"get_root_node","kind":12,"line":205},{"line":207,"kind":13,"localvar":"my","containerName":"get_lineage_nodes","name":"@lineage","definition":"my"},{"kind":13,"line":208,"name":"$node","containerName":"get_lineage_nodes"},{"kind":13,"line":209,"name":"$node","containerName":"get_lineage_nodes"},{"name":"$node","containerName":"get_lineage_nodes","kind":13,"line":209},{"containerName":"get_lineage_nodes","name":"ancestor","line":209,"kind":12},{"containerName":"get_lineage_nodes","name":"@lineage","line":210,"kind":13},{"name":"$node","containerName":"get_lineage_nodes","kind":13,"line":210},{"line":211,"kind":13,"containerName":"get_lineage_nodes","name":"$node"},{"name":"$root","containerName":"get_lineage_nodes","line":211,"kind":13},{"containerName":"get_lineage_nodes","name":"@lineage","kind":13,"line":213}],"kind":12,"detail":"($self,$input)","signature":{"label":"get_lineage_nodes($self,$input)","parameters":[{"label":"$self"},{"label":"$input"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":214},"start":{"character":0,"line":188}},"name":"get_lineage_nodes"},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"splice","line":249,"kind":13},{"containerName":"splice","name":"@args","line":249,"kind":13},{"containerName":"splice","name":"$self","line":250,"kind":13},{"kind":12,"line":250,"containerName":"splice","name":"throw"},{"kind":13,"line":250,"containerName":"splice","name":"@args"},{"line":251,"kind":13,"localvar":"my","name":"$preserve_lengths","definition":"my","containerName":"splice"},{"kind":13,"line":252,"definition":"my","name":"@nodes_to_remove","containerName":"splice","localvar":"my"},{"kind":13,"line":253,"name":"$args","containerName":"splice"},{"name":"$self","containerName":"splice","kind":13,"line":254},{"name":"throw","containerName":"splice","line":254,"kind":12},{"kind":13,"line":254,"containerName":"splice","name":"$args"},{"name":"isa","containerName":"splice","line":254,"kind":12},{"kind":13,"line":255,"name":"@nodes_to_remove","containerName":"splice"},{"kind":13,"line":255,"name":"@args","containerName":"splice"},{"kind":13,"line":258,"name":"$self","containerName":"splice"},{"name":"throw","containerName":"splice","line":258,"kind":12},{"name":"@args","containerName":"splice","kind":13,"line":258},{"line":259,"kind":13,"localvar":"my","name":"%args","definition":"my","containerName":"splice"},{"line":259,"kind":13,"containerName":"splice","name":"@args"},{"kind":13,"line":260,"containerName":"splice","name":"@keep_nodes","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"@remove_nodes","containerName":"splice","line":261,"kind":13},{"line":262,"kind":13,"localvar":"my","definition":"my","name":"$remove_all","containerName":"splice"},{"localvar":"my","name":"$key","definition":"my","containerName":"splice","line":263,"kind":13},{"line":263,"kind":13,"name":"$value","containerName":"splice"},{"kind":13,"line":263,"containerName":"splice","name":"%args"},{"definition":"my","name":"@values","containerName":"splice","localvar":"my","kind":13,"line":264},{"containerName":"splice","name":"$value","kind":13,"line":264},{"containerName":"splice","name":"$value","line":264,"kind":13},{"name":"$value","containerName":"splice","line":264,"kind":13},{"name":"$key","containerName":"splice","kind":13,"line":266},{"name":"$remove_all","containerName":"splice","line":267,"kind":13},{"containerName":"splice","definition":"my","name":"$value","localvar":"my","kind":13,"line":268},{"containerName":"splice","name":"@values","kind":13,"line":268},{"containerName":"splice","name":"@remove_nodes","kind":13,"line":269},{"line":269,"kind":13,"containerName":"splice","name":"$self"},{"line":269,"kind":12,"containerName":"splice","name":"find_node"},{"containerName":"splice","name":"$key","kind":13,"line":269},{"kind":13,"line":269,"name":"$value","containerName":"splice"},{"kind":13,"line":272,"containerName":"splice","name":"$key"},{"definition":"my","name":"$value","containerName":"splice","localvar":"my","kind":13,"line":273},{"line":273,"kind":13,"containerName":"splice","name":"@values"},{"name":"@keep_nodes","containerName":"splice","line":274,"kind":13},{"line":274,"kind":13,"name":"$self","containerName":"splice"},{"line":274,"kind":12,"containerName":"splice","name":"find_node"},{"name":"$key","containerName":"splice","line":274,"kind":13},{"containerName":"splice","name":"$value","kind":13,"line":274},{"kind":13,"line":277,"containerName":"splice","name":"$key"},{"name":"$preserve_lengths","containerName":"splice","line":278,"kind":13},{"kind":13,"line":278,"containerName":"splice","name":"$value"},{"line":282,"kind":13,"name":"$remove_all","containerName":"splice"},{"name":"@keep_nodes","containerName":"splice","kind":13,"line":283},{"kind":13,"line":284,"name":"$self","containerName":"splice"},{"line":284,"kind":12,"name":"warn","containerName":"splice"},{"line":288,"kind":13,"name":"@remove_nodes","containerName":"splice"},{"containerName":"splice","name":"$self","kind":13,"line":288},{"line":288,"kind":12,"containerName":"splice","name":"get_nodes"},{"name":"@keep_nodes","containerName":"splice","kind":13,"line":290},{"name":"%keep_iids","definition":"my","containerName":"splice","localvar":"my","kind":13,"line":291},{"name":"internal_id","containerName":"splice","kind":12,"line":291},{"name":"@keep_nodes","containerName":"splice","kind":13,"line":291},{"containerName":"splice","definition":"my","name":"$node","localvar":"my","kind":13,"line":292},{"containerName":"splice","name":"@remove_nodes","kind":13,"line":292},{"kind":13,"line":293,"containerName":"splice","name":"@nodes_to_remove"},{"kind":13,"line":293,"name":"$node","containerName":"splice"},{"name":"$keep_iids","containerName":"splice","line":293,"kind":13},{"line":293,"kind":13,"containerName":"splice","name":"$node"},{"line":293,"kind":12,"containerName":"splice","name":"internal_id"},{"line":297,"kind":13,"name":"@nodes_to_remove","containerName":"splice"},{"line":297,"kind":13,"containerName":"splice","name":"@remove_nodes"}],"line":248,"kind":12,"signature":{"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"splice($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":248},"end":{"character":9999,"line":299}},"name":"splice"},{"definition":"my","name":"%root_descs","containerName":null,"localvar":"my","kind":13,"line":303},{"kind":13,"line":304,"containerName":null,"name":"$reroot","definition":"my","localvar":"my"},{"line":305,"kind":13,"localvar":"my","definition":"my","name":"$node","containerName":null},{"line":305,"kind":13,"containerName":null,"name":"@nodes_to_remove"},{"localvar":"my","containerName":null,"definition":"my","name":"@descs","line":306,"kind":13},{"kind":13,"line":306,"containerName":null,"name":"$node"},{"line":306,"kind":12,"name":"each_Descendent","containerName":"main::"},{"kind":13,"line":307,"containerName":null,"definition":"my","name":"$ancestor","localvar":"my"},{"kind":13,"line":307,"containerName":null,"name":"$node"},{"containerName":"main::","name":"ancestor","line":307,"kind":12},{"kind":13,"line":308,"name":"$ancestor","containerName":null},{"containerName":null,"name":"%reroot","line":308,"kind":13},{"kind":13,"line":311,"name":"$reroot","containerName":null},{"kind":13,"line":312,"containerName":null,"name":"%root_descs"},{"kind":12,"line":312,"containerName":"main::","name":"internal_id"},{"line":312,"kind":13,"name":"@descs","containerName":null},{"containerName":null,"name":"$node","line":313,"kind":13},{"name":"remove_all_Descendents","containerName":"main::","line":313,"kind":12},{"line":316,"kind":13,"containerName":null,"name":"%root_descs"},{"kind":13,"line":316,"name":"$node","containerName":null},{"containerName":"main::","name":"internal_id","kind":12,"line":316},{"containerName":null,"name":"%root_descs","line":318,"kind":13},{"name":"$node","containerName":null,"kind":13,"line":318},{"name":"internal_id","containerName":"main::","line":318,"kind":12},{"containerName":null,"definition":"my","name":"$desc","localvar":"my","kind":13,"line":320},{"line":320,"kind":13,"name":"@descs","containerName":null},{"name":"%root_descs","containerName":null,"kind":13,"line":321},{"line":321,"kind":13,"name":"$desc","containerName":null},{"kind":12,"line":321,"containerName":"main::","name":"internal_id"},{"name":"$desc","containerName":null,"line":321,"kind":13},{"kind":13,"line":326,"name":"$desc","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":326,"name":"@descs","containerName":null},{"containerName":null,"name":"$desc","kind":13,"line":327},{"name":"ancestor","containerName":"main::","kind":12,"line":327},{"name":"$ancestor","containerName":null,"kind":13,"line":327},{"containerName":null,"name":"$desc","line":328,"kind":13},{"containerName":"main::","name":"branch_length","line":328,"kind":12},{"containerName":null,"name":"$desc","line":328,"kind":13},{"line":328,"kind":12,"name":"branch_length","containerName":"main::"},{"containerName":null,"name":"$node","line":328,"kind":13},{"containerName":"main::","name":"branch_length","line":328,"kind":12},{"line":328,"kind":13,"containerName":null,"name":"$preserve_lengths"},{"containerName":null,"name":"$node","line":330,"kind":13},{"line":330,"kind":12,"name":"ancestor","containerName":"main::"},{"containerName":null,"name":"%reroot","line":332,"kind":13},{"containerName":null,"name":"@candidates","definition":"my","localvar":"my","kind":13,"line":333},{"containerName":null,"name":"%root_descs","line":333,"kind":13},{"line":334,"kind":13,"name":"$self","containerName":null},{"name":"throw","containerName":"main::","kind":12,"line":334},{"line":334,"kind":13,"name":"@candidates","containerName":null},{"kind":13,"line":335,"name":"$self","containerName":null},{"kind":12,"line":335,"name":"throw","containerName":"main::"},{"name":"@candidates","containerName":null,"kind":13,"line":335},{"containerName":null,"name":"$self","kind":13,"line":336},{"line":336,"kind":12,"containerName":"main::","name":"set_root_node"},{"containerName":null,"name":"@candidates","line":336,"kind":13},{"kind":12,"line":353,"children":[{"kind":13,"line":354,"containerName":"get_lca","name":"$self","definition":"my","localvar":"my"},{"line":354,"kind":13,"name":"@args","containerName":"get_lca"},{"containerName":"get_lca","definition":"my","name":"$nodes","localvar":"my","kind":13,"line":355},{"name":"$self","containerName":"get_lca","kind":13,"line":355},{"containerName":"get_lca","name":"_rearrange","line":355,"kind":12},{"line":355,"kind":13,"name":"@args","containerName":"get_lca"},{"kind":13,"line":356,"name":"@nodes","definition":"my","containerName":"get_lca","localvar":"my"},{"containerName":"get_lca","name":"$nodes","line":357,"kind":13},{"name":"@nodes","containerName":"get_lca","line":358,"kind":13},{"line":358,"kind":13,"containerName":"get_lca","name":"$nodes"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes","label":"get_lca($self,@args)"},"name":"get_lca","range":{"end":{"line":359,"character":9999},"start":{"line":353,"character":0}}},{"line":361,"kind":13,"containerName":null,"name":"@nodes"},{"name":"@args","containerName":null,"line":361,"kind":13},{"containerName":null,"name":"@nodes","kind":13,"line":363},{"containerName":null,"name":"$self","kind":13,"line":363},{"line":363,"kind":12,"containerName":"main::","name":"throw"},{"line":372,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@paths"},{"kind":13,"line":373,"containerName":null,"name":"$node","definition":"my","localvar":"my"},{"line":373,"kind":13,"containerName":null,"name":"@nodes"},{"line":374,"kind":13,"name":"$node","containerName":null},{"name":"$node","containerName":null,"kind":13,"line":374},{"containerName":"main::","name":"isa","line":374,"kind":12},{"name":"$self","containerName":null,"line":375,"kind":13},{"containerName":"main::","name":"throw","kind":12,"line":375},{"line":377,"kind":13,"localvar":"my","name":"@path","definition":"my","containerName":null},{"name":"$self","containerName":null,"line":377,"kind":13},{"line":377,"kind":12,"name":"get_lineage_nodes","containerName":"main::"},{"containerName":null,"name":"$node","kind":13,"line":377},{"kind":13,"line":377,"name":"$node","containerName":null},{"line":378,"kind":13,"name":"@paths","containerName":null},{"line":378,"kind":13,"name":"@path","containerName":null},{"kind":13,"line":380,"containerName":null,"name":"@paths"},{"kind":13,"line":381,"definition":"my","name":"$lca","containerName":null,"localvar":"my"},{"line":382,"kind":12,"name":"LEVEL"},{"kind":13,"line":382,"name":"@paths","containerName":null},{"name":"%node_ids","definition":"my","containerName":null,"localvar":"my","kind":13,"line":383},{"definition":"my","name":"$node","containerName":null,"localvar":"my","kind":13,"line":384},{"name":"$path","definition":"my","containerName":null,"localvar":"my","kind":13,"line":385},{"kind":13,"line":385,"name":"@paths","containerName":null},{"line":386,"kind":13,"name":"$node","containerName":null},{"kind":13,"line":386,"containerName":null,"name":"$path"},{"name":"LEVEL","line":386,"kind":12},{"name":"$node_id","definition":"my","containerName":null,"localvar":"my","kind":13,"line":387},{"kind":13,"line":387,"containerName":null,"name":"$node"},{"containerName":"main::","name":"internal_id","line":387,"kind":12},{"containerName":null,"name":"%node_id","kind":13,"line":388},{"kind":13,"line":389,"name":"$self","containerName":null},{"line":389,"kind":12,"containerName":"main::","name":"warn"},{"kind":13,"line":392,"name":"%node_ids","containerName":null},{"kind":13,"line":392,"name":"$node_id","containerName":null},{"name":"%node_ids","containerName":null,"line":394,"kind":13},{"name":"$lca","containerName":null,"kind":13,"line":395},{"kind":13,"line":395,"containerName":null,"name":"%node"},{"name":"LEVEL","line":400,"kind":12},{"containerName":null,"name":"$lca","kind":13,"line":406},{"kind":13,"line":406,"name":"$self","containerName":null},{"kind":12,"line":406,"containerName":"main::","name":"number_nodes"},{"kind":13,"line":407,"name":"$own_lca","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":407,"name":"$self","containerName":null},{"kind":12,"line":407,"name":"find_node","containerName":"main::"},{"containerName":null,"name":"$lca","line":407,"kind":13},{"containerName":"main::","name":"internal_id","kind":12,"line":407},{"name":"$lca","containerName":null,"kind":13,"line":408},{"name":"$own_lca","containerName":null,"kind":13,"line":408},{"line":408,"kind":13,"containerName":null,"name":"$own_lca"},{"name":"$lca","containerName":null,"line":410,"kind":13},{"name":"merge_lineage","range":{"start":{"line":444,"character":0},"end":{"character":9999,"line":479}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"merge_lineage","localvar":"my","kind":13,"line":445},{"name":"$thing","containerName":"merge_lineage","kind":13,"line":445},{"kind":13,"line":446,"containerName":"merge_lineage","name":"$self"},{"kind":12,"line":446,"containerName":"merge_lineage","name":"throw"},{"name":"$thing","containerName":"merge_lineage","kind":13,"line":446},{"kind":13,"line":448,"containerName":"merge_lineage","name":"$lineage_tree","definition":"my","localvar":"my"},{"containerName":"merge_lineage","name":"$lineage_leaf","kind":13,"line":448},{"line":449,"kind":13,"name":"$thing","containerName":"merge_lineage"},{"name":"isa","containerName":"merge_lineage","line":449,"kind":12},{"line":450,"kind":13,"localvar":"my","containerName":"merge_lineage","definition":"my","name":"@leaves"},{"name":"$thing","containerName":"merge_lineage","line":450,"kind":13},{"containerName":"merge_lineage","name":"get_leaf_nodes","line":450,"kind":12},{"containerName":"merge_lineage","name":"$self","kind":13,"line":451},{"containerName":"merge_lineage","name":"throw","line":451,"kind":12},{"kind":13,"line":451,"containerName":"merge_lineage","name":"@leaves"},{"kind":13,"line":452,"name":"$lineage_tree","containerName":"merge_lineage"},{"line":452,"kind":13,"containerName":"merge_lineage","name":"$thing"},{"containerName":"merge_lineage","name":"$lineage_leaf","line":453,"kind":13},{"kind":13,"line":453,"containerName":"merge_lineage","name":"@leaves"},{"containerName":"merge_lineage","name":"$thing","kind":13,"line":455},{"kind":12,"line":455,"containerName":"merge_lineage","name":"isa"},{"kind":13,"line":456,"name":"$self","containerName":"merge_lineage"},{"kind":12,"line":456,"containerName":"merge_lineage","name":"throw"},{"containerName":"merge_lineage","name":"$thing","line":456,"kind":13},{"line":456,"kind":12,"name":"ancestor","containerName":"merge_lineage"},{"name":"$lineage_tree","containerName":"merge_lineage","line":457,"kind":13},{"containerName":"merge_lineage","name":"$self","line":457,"kind":13},{"containerName":"merge_lineage","name":"new","kind":12,"line":457},{"kind":13,"line":457,"containerName":"merge_lineage","name":"$thing"},{"line":458,"kind":13,"name":"$lineage_leaf","containerName":"merge_lineage"},{"containerName":"merge_lineage","name":"$thing","kind":13,"line":458},{"kind":13,"line":463,"containerName":"merge_lineage","name":"@lineage","definition":"my","localvar":"my"},{"name":"$lineage_leaf","containerName":"merge_lineage","kind":13,"line":463},{"containerName":"merge_lineage","name":"$self","line":463,"kind":13},{"containerName":"merge_lineage","name":"get_lineage_nodes","kind":12,"line":463},{"line":463,"kind":13,"containerName":"merge_lineage","name":"$lineage_leaf"},{"kind":13,"line":464,"containerName":"merge_lineage","name":"$merged","definition":"my","localvar":"my"},{"localvar":"my","containerName":"merge_lineage","definition":"my","name":"$i","line":465,"kind":13},{"localvar":"my","definition":"my","name":"$lca","containerName":"merge_lineage","line":466,"kind":13},{"containerName":"merge_lineage","name":"$self","kind":13,"line":466},{"kind":12,"line":466,"name":"find_node","containerName":"merge_lineage"},{"name":"$lineage","containerName":"merge_lineage","kind":13,"line":466},{"line":466,"kind":13,"containerName":"merge_lineage","name":"$i"},{"containerName":"merge_lineage","name":"internal_id","line":466,"kind":12},{"name":"$i","containerName":"merge_lineage","line":468,"kind":13},{"containerName":"merge_lineage","name":"$lca","line":474,"kind":13},{"name":"add_Descendent","containerName":"merge_lineage","kind":12,"line":474},{"kind":13,"line":474,"name":"$lineage","containerName":"merge_lineage"},{"kind":13,"line":474,"containerName":"merge_lineage","name":"$i"},{"line":475,"kind":13,"containerName":"merge_lineage","name":"$merged"},{"name":"$merged","containerName":"merge_lineage","kind":13,"line":478},{"name":"$self","containerName":"merge_lineage","kind":13,"line":478},{"kind":12,"line":478,"name":"warn","containerName":"merge_lineage"},{"name":"$lineage_leaf","containerName":"merge_lineage","line":478,"kind":13},{"kind":12,"line":478,"name":"id","containerName":"merge_lineage"}],"line":444,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D","parameters":[{"label":"$self"},{"label":"$thing"}],"label":"merge_lineage($self,$thing)"},"detail":"($self,$thing)"},{"kind":12,"line":465,"name":"lineage"},{"children":[{"kind":13,"line":518,"containerName":"contract_linear_paths","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","containerName":"contract_linear_paths","definition":"my","name":"$reroot","line":519,"kind":13},{"localvar":"my","definition":"my","name":"@remove","containerName":"contract_linear_paths","line":520,"kind":13},{"localvar":"my","name":"$node","definition":"my","containerName":"contract_linear_paths","line":521,"kind":13},{"kind":13,"line":521,"name":"$self","containerName":"contract_linear_paths"},{"line":521,"kind":12,"name":"get_nodes","containerName":"contract_linear_paths"},{"containerName":"contract_linear_paths","name":"$node","kind":13,"line":522},{"line":522,"kind":12,"containerName":"contract_linear_paths","name":"ancestor"},{"kind":13,"line":522,"containerName":"contract_linear_paths","name":"$node"},{"line":522,"kind":12,"containerName":"contract_linear_paths","name":"each_Descendent"},{"name":"@remove","containerName":"contract_linear_paths","line":523,"kind":13},{"kind":13,"line":523,"name":"$node","containerName":"contract_linear_paths"},{"kind":13,"line":526,"name":"$self","containerName":"contract_linear_paths"},{"containerName":"contract_linear_paths","name":"splice","kind":12,"line":526},{"line":526,"kind":13,"containerName":"contract_linear_paths","name":"@remove"},{"line":526,"kind":13,"containerName":"contract_linear_paths","name":"@remove"},{"containerName":"contract_linear_paths","name":"$reroot","line":527,"kind":13},{"definition":"my","name":"$root","containerName":"contract_linear_paths","localvar":"my","kind":13,"line":528},{"line":528,"kind":13,"containerName":"contract_linear_paths","name":"$self"},{"line":528,"kind":12,"containerName":"contract_linear_paths","name":"get_root_node"},{"localvar":"my","definition":"my","name":"@descs","containerName":"contract_linear_paths","line":529,"kind":13},{"kind":13,"line":529,"name":"$root","containerName":"contract_linear_paths"},{"kind":12,"line":529,"name":"each_Descendent","containerName":"contract_linear_paths"},{"containerName":"contract_linear_paths","name":"@descs","line":530,"kind":13},{"localvar":"my","containerName":"contract_linear_paths","name":"$new_root","definition":"my","line":531,"kind":13},{"line":531,"kind":13,"name":"@descs","containerName":"contract_linear_paths"},{"containerName":"contract_linear_paths","name":"$self","line":532,"kind":13},{"name":"set_root_node","containerName":"contract_linear_paths","line":532,"kind":12},{"line":532,"kind":13,"name":"$new_root","containerName":"contract_linear_paths"},{"containerName":"contract_linear_paths","name":"$new_root","line":533,"kind":13},{"kind":12,"line":533,"name":"ancestor","containerName":"contract_linear_paths"}],"line":517,"kind":12,"range":{"start":{"line":517,"character":0},"end":{"character":9999,"line":536}},"definition":"sub","name":"contract_linear_paths","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"is_binary","range":{"start":{"line":551,"character":0},"end":{"character":9999,"line":551}},"kind":12,"line":551,"children":[]},{"range":{"end":{"character":9999,"line":568},"start":{"character":0,"line":553}},"containerName":"main::","name":"is_binary","definition":"sub","line":553,"children":[{"line":554,"kind":13,"localvar":"my","containerName":"is_binary","name":"$self","definition":"my"},{"kind":13,"line":555,"containerName":"is_binary","definition":"my","name":"$node","localvar":"my"},{"line":555,"kind":13,"name":"$self","containerName":"is_binary"},{"containerName":"is_binary","name":"get_root_node","kind":12,"line":555},{"line":557,"kind":13,"localvar":"my","name":"$binary","definition":"my","containerName":"is_binary"},{"line":558,"kind":13,"localvar":"my","definition":"my","name":"@descs","containerName":"is_binary"},{"containerName":"is_binary","name":"$node","kind":13,"line":558},{"containerName":"is_binary","name":"each_Descendent","kind":12,"line":558},{"name":"$binary","containerName":"is_binary","line":559,"kind":13},{"kind":13,"line":559,"name":"@descs","containerName":"is_binary"},{"containerName":"is_binary","name":"@descs","line":559,"kind":13},{"localvar":"my","definition":"my","name":"$desc","containerName":"is_binary","line":563,"kind":13},{"kind":13,"line":563,"name":"@descs","containerName":"is_binary"},{"containerName":"is_binary","name":"$binary","kind":13,"line":564},{"line":564,"kind":13,"containerName":"is_binary","name":"$self"},{"line":564,"kind":12,"containerName":"is_binary","name":"is_binary"},{"line":564,"kind":13,"containerName":"is_binary","name":"$desc"},{"containerName":"is_binary","name":"$binary","line":566,"kind":13},{"line":566,"kind":13,"name":"$binary","containerName":"is_binary"},{"containerName":"is_binary","name":"$binary","line":567,"kind":13}],"kind":12},{"name":"force_binary","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":678},"start":{"character":0,"line":634}},"kind":12,"children":[{"kind":13,"line":635,"containerName":"force_binary","name":"$self","definition":"my","localvar":"my"},{"line":636,"kind":13,"localvar":"my","containerName":"force_binary","definition":"my","name":"$node"},{"line":636,"kind":13,"containerName":"force_binary","name":"$self"},{"line":636,"kind":12,"containerName":"force_binary","name":"get_root_node"},{"line":638,"kind":13,"localvar":"my","containerName":"force_binary","name":"@descs","definition":"my"},{"kind":13,"line":638,"containerName":"force_binary","name":"$node"},{"line":638,"kind":12,"containerName":"force_binary","name":"each_Descendent"},{"name":"@descs","containerName":"force_binary","kind":13,"line":639},{"kind":13,"line":640,"name":"$self","containerName":"force_binary"},{"containerName":"force_binary","name":"warn","line":640,"kind":12},{"containerName":"force_binary","name":"$node","kind":13,"line":640},{"line":640,"kind":12,"containerName":"force_binary","name":"can"},{"containerName":"force_binary","name":"$node","kind":13,"line":640},{"line":640,"kind":12,"containerName":"force_binary","name":"node_name"},{"containerName":"force_binary","name":"$node","kind":13,"line":640},{"kind":12,"line":640,"containerName":"force_binary","name":"id"},{"kind":13,"line":640,"containerName":"force_binary","name":"$node"},{"containerName":"force_binary","name":"id","line":640,"kind":12},{"line":642,"kind":13,"name":"$node","containerName":"force_binary"},{"containerName":"force_binary","name":"can","line":642,"kind":12},{"line":642,"kind":13,"name":"$node","containerName":"force_binary"},{"kind":12,"line":642,"containerName":"force_binary","name":"node_name"},{"name":"$node","containerName":"force_binary","line":642,"kind":13},{"containerName":"force_binary","name":"id","line":642,"kind":12},{"line":642,"kind":13,"name":"$node","containerName":"force_binary"},{"line":642,"kind":12,"containerName":"force_binary","name":"id"},{"line":642,"kind":13,"name":"@descs","containerName":"force_binary"},{"containerName":"force_binary","name":"@working","definition":"my","localvar":"my","kind":13,"line":644},{"line":644,"kind":13,"containerName":"force_binary","name":"@descs"},{"containerName":"force_binary","definition":"my","name":"$half","localvar":"my","kind":13,"line":646},{"containerName":"force_binary","name":"@working","kind":13,"line":646},{"name":"$half","containerName":"force_binary","line":647,"kind":13},{"name":"$half","containerName":"force_binary","kind":13,"line":647},{"line":647,"kind":13,"name":"$half","containerName":"force_binary"},{"name":"$half","containerName":"force_binary","line":648,"kind":13},{"name":"$half","containerName":"force_binary","line":648,"kind":13},{"kind":13,"line":649,"name":"@artificials","definition":"my","containerName":"force_binary","localvar":"my"},{"name":"$half","containerName":"force_binary","line":650,"kind":13},{"line":651,"kind":13,"localvar":"my","containerName":"force_binary","definition":"my","name":"@this_level"},{"containerName":"force_binary","name":"$top_node","definition":"my","localvar":"my","kind":13,"line":652},{"name":"@artificials","containerName":"force_binary","kind":13,"line":652},{"line":652,"kind":13,"containerName":"force_binary","name":"$node"},{"line":654,"kind":13,"localvar":"my","containerName":"force_binary","name":"$art","definition":"my"},{"line":654,"kind":13,"containerName":"force_binary","name":"$top_node"},{"line":654,"kind":12,"containerName":"force_binary","name":"new"},{"name":"$self","containerName":"force_binary","line":654,"kind":13},{"kind":13,"line":655,"name":"$top_node","containerName":"force_binary"},{"kind":12,"line":655,"containerName":"force_binary","name":"add_Descendent"},{"name":"$art","containerName":"force_binary","line":655,"kind":13},{"containerName":"force_binary","name":"@this_level","line":656,"kind":13},{"kind":13,"line":656,"containerName":"force_binary","name":"$art"},{"line":659,"kind":13,"name":"@artificials","containerName":"force_binary"},{"name":"@this_level","containerName":"force_binary","line":659,"kind":13},{"line":660,"kind":13,"containerName":"force_binary","name":"$half"},{"name":"$art","definition":"my","containerName":"force_binary","localvar":"my","kind":13,"line":663},{"kind":13,"line":663,"name":"@artificials","containerName":"force_binary"},{"localvar":"my","definition":"my","name":"$desc","containerName":"force_binary","line":665,"kind":13},{"containerName":"force_binary","name":"@working","kind":13,"line":665},{"line":665,"kind":13,"containerName":"force_binary","name":"$node"},{"line":665,"kind":12,"containerName":"force_binary","name":"new"},{"name":"$self","containerName":"force_binary","line":665,"kind":13},{"containerName":"force_binary","name":"$desc","line":666,"kind":13},{"line":666,"kind":12,"containerName":"force_binary","name":"ancestor"},{"name":"$art","containerName":"force_binary","kind":13,"line":666},{"name":"@descs","containerName":"force_binary","kind":13,"line":670},{"kind":13,"line":672,"name":"$node","containerName":"force_binary"},{"line":672,"kind":12,"containerName":"force_binary","name":"add_Descendent"},{"name":"$node","containerName":"force_binary","kind":13,"line":672},{"line":672,"kind":12,"name":"new","containerName":"force_binary"},{"kind":13,"line":672,"name":"$self","containerName":"force_binary"},{"line":675,"kind":13,"localvar":"my","containerName":"force_binary","definition":"my","name":"$desc"},{"name":"@descs","containerName":"force_binary","line":675,"kind":13},{"containerName":"force_binary","name":"$self","kind":13,"line":676},{"containerName":"force_binary","name":"force_binary","kind":12,"line":676},{"kind":13,"line":676,"name":"$desc","containerName":"force_binary"}],"line":634},{"name":"_art_num","kind":12,"line":654},{"line":665,"kind":12,"name":"_art_num"},{"name":"_art_num","line":672,"kind":12},{"containerName":"main::","name":"simplify_to_leaves_string","definition":"sub","range":{"end":{"line":715,"character":9999},"start":{"line":694,"character":0}},"kind":12,"line":694,"children":[{"line":695,"kind":13,"localvar":"my","containerName":"simplify_to_leaves_string","name":"$self","definition":"my"},{"localvar":"my","containerName":"simplify_to_leaves_string","name":"$tree","definition":"my","line":701,"kind":13},{"containerName":"simplify_to_leaves_string","name":"$self","kind":13,"line":701},{"containerName":"simplify_to_leaves_string","name":"_clone","kind":12,"line":701},{"name":"$tree","containerName":"simplify_to_leaves_string","kind":13,"line":703},{"line":703,"kind":12,"containerName":"simplify_to_leaves_string","name":"contract_linear_paths"},{"kind":13,"line":704,"containerName":"simplify_to_leaves_string","name":"$tree"},{"kind":12,"line":704,"containerName":"simplify_to_leaves_string","name":"force_binary"},{"localvar":"my","containerName":"simplify_to_leaves_string","definition":"my","name":"$node","line":705,"kind":13},{"name":"$tree","containerName":"simplify_to_leaves_string","line":705,"kind":13},{"containerName":"simplify_to_leaves_string","name":"get_nodes","line":705,"kind":12},{"localvar":"my","name":"$id","definition":"my","containerName":"simplify_to_leaves_string","line":706,"kind":13},{"kind":13,"line":706,"name":"$node","containerName":"simplify_to_leaves_string"},{"name":"id","containerName":"simplify_to_leaves_string","kind":12,"line":706},{"line":707,"kind":13,"name":"$id","containerName":"simplify_to_leaves_string"},{"kind":13,"line":707,"name":"$node","containerName":"simplify_to_leaves_string"},{"containerName":"simplify_to_leaves_string","name":"is_Leaf","kind":12,"line":707},{"kind":13,"line":707,"containerName":"simplify_to_leaves_string","name":"$id"},{"name":"$id","containerName":"simplify_to_leaves_string","kind":13,"line":707},{"containerName":"simplify_to_leaves_string","name":"$node","line":708,"kind":13},{"name":"id","containerName":"simplify_to_leaves_string","kind":12,"line":708},{"kind":13,"line":708,"name":"$id","containerName":"simplify_to_leaves_string"},{"localvar":"my","name":"%paired","definition":"my","containerName":"simplify_to_leaves_string","line":711,"kind":13},{"containerName":"simplify_to_leaves_string","definition":"my","name":"@data","localvar":"my","kind":13,"line":712},{"kind":13,"line":712,"containerName":"simplify_to_leaves_string","name":"$self"},{"name":"_simplify_helper","containerName":"simplify_to_leaves_string","kind":12,"line":712},{"name":"$tree","containerName":"simplify_to_leaves_string","kind":13,"line":712},{"containerName":"simplify_to_leaves_string","name":"get_root_node","kind":12,"line":712},{"kind":13,"line":712,"containerName":"simplify_to_leaves_string","name":"%paired"},{"containerName":"simplify_to_leaves_string","name":"@data","kind":13,"line":714}]},{"name":"clone","range":{"start":{"character":0,"line":732},"end":{"line":746,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$parent,$parent_clone)","signature":{"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$parent_clone"}],"label":"clone($self,$parent,$parent_clone)"},"kind":12,"line":732,"children":[{"kind":13,"line":733,"definition":"my","name":"$self","containerName":"clone","localvar":"my"},{"kind":13,"line":733,"name":"$parent","containerName":"clone"},{"line":733,"kind":13,"containerName":"clone","name":"$parent_clone"},{"containerName":"clone","name":"$parent","line":734,"kind":13},{"line":734,"kind":13,"containerName":"clone","name":"$self"},{"name":"get_root_node","containerName":"clone","kind":12,"line":734},{"line":735,"kind":13,"name":"$parent_clone","containerName":"clone"},{"name":"$self","containerName":"clone","line":735,"kind":13},{"name":"_clone_node","containerName":"clone","line":735,"kind":12},{"kind":13,"line":735,"containerName":"clone","name":"$parent"},{"line":737,"kind":13,"localvar":"my","definition":"my","name":"$node","containerName":"clone"},{"kind":13,"line":737,"name":"$parent","containerName":"clone"},{"containerName":"clone","name":"each_Descendent","kind":12,"line":737},{"localvar":"my","definition":"my","name":"$child","containerName":"clone","line":738,"kind":13},{"name":"$self","containerName":"clone","kind":13,"line":738},{"name":"_clone_node","containerName":"clone","line":738,"kind":12},{"kind":13,"line":738,"containerName":"clone","name":"$node"},{"containerName":"clone","name":"$child","kind":13,"line":739},{"line":739,"kind":12,"containerName":"clone","name":"ancestor"},{"line":739,"kind":13,"name":"$parent_clone","containerName":"clone"},{"line":740,"kind":13,"containerName":"clone","name":"$self"},{"name":"_clone","containerName":"clone","kind":12,"line":740},{"kind":13,"line":740,"name":"$node","containerName":"clone"},{"kind":13,"line":740,"name":"$child","containerName":"clone"},{"containerName":"clone","name":"$parent","kind":13,"line":742},{"name":"ancestor","containerName":"clone","kind":12,"line":742},{"kind":13,"line":744,"definition":"my","name":"$tree","containerName":"clone","localvar":"my"},{"kind":13,"line":744,"name":"$self","containerName":"clone"},{"kind":12,"line":744,"name":"new","containerName":"clone"},{"containerName":"clone","name":"$parent_clone","kind":13,"line":744},{"line":745,"kind":13,"containerName":"clone","name":"$tree"}]},{"range":{"end":{"character":9999,"line":749},"start":{"character":0,"line":749}},"containerName":"main::","definition":"sub","name":"_clone","line":749,"children":[{"name":"clone","containerName":"_clone","kind":12,"line":749}],"kind":12},{"line":753,"children":[{"line":754,"kind":13,"localvar":"my","containerName":"_clone_node","definition":"my","name":"$self"},{"line":754,"kind":13,"name":"$node","containerName":"_clone_node"},{"containerName":"_clone_node","name":"$clone","definition":"my","localvar":"my","kind":13,"line":755},{"line":755,"kind":13,"containerName":"_clone_node","name":"$node"},{"containerName":"_clone_node","name":"new","line":755,"kind":12},{"localvar":"my","name":"$key","definition":"my","containerName":"_clone_node","line":757,"kind":13},{"kind":13,"line":757,"name":"$val","containerName":"_clone_node"},{"name":"$node","containerName":"_clone_node","kind":13,"line":757}],"kind":12,"detail":"($self,$node)","signature":{"label":"_clone_node($self,$node)","documentation":" safe node clone that doesn't seg fault, but deliberately loses ancestors and\n descendents","parameters":[{"label":"$self"},{"label":"$node"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":757},"start":{"line":753,"character":0}},"name":"_clone_node"},{"containerName":null,"name":"$key","kind":13,"line":758},{"name":"%key","containerName":null,"kind":13,"line":758},{"name":"%clone","containerName":null,"kind":13,"line":761},{"kind":13,"line":761,"name":"$key","containerName":null},{"name":"$val","containerName":null,"kind":13,"line":761},{"containerName":null,"name":"$clone","kind":13,"line":764},{"name":"_simplify_helper","range":{"end":{"line":784,"character":9999},"start":{"line":769,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"_simplify_helper($self,$node,$paired)","parameters":[{"label":"$self"},{"label":"$node"},{"label":"$paired"}],"documentation":" tree string generator for simplify_to_leaves_string, based on\n Bio::TreeIO::newick::_write_tree_Helper"},"detail":"($self,$node,$paired)","kind":12,"children":[{"kind":13,"line":770,"containerName":"_simplify_helper","definition":"my","name":"$self","localvar":"my"},{"line":770,"kind":13,"name":"$node","containerName":"_simplify_helper"},{"name":"$paired","containerName":"_simplify_helper","kind":13,"line":770},{"kind":13,"line":771,"containerName":"_simplify_helper","name":"$node"},{"line":773,"kind":13,"localvar":"my","containerName":"_simplify_helper","name":"@data","definition":"my"},{"name":"$node","definition":"my","containerName":"_simplify_helper","localvar":"my","kind":13,"line":774},{"kind":13,"line":774,"containerName":"_simplify_helper","name":"$node"},{"line":774,"kind":12,"name":"each_Descendent","containerName":"_simplify_helper"},{"containerName":"_simplify_helper","name":"@data","line":775,"kind":13},{"containerName":"_simplify_helper","name":"$self","line":775,"kind":13},{"line":775,"kind":12,"name":"_simplify_helper","containerName":"_simplify_helper"},{"name":"$node","containerName":"_simplify_helper","line":775,"kind":13},{"name":"$paired","containerName":"_simplify_helper","line":775,"kind":13},{"definition":"my","name":"$id","containerName":"_simplify_helper","localvar":"my","kind":13,"line":778},{"name":"$node","containerName":"_simplify_helper","line":778,"kind":13},{"kind":12,"line":778,"containerName":"_simplify_helper","name":"id_output"},{"name":"@data","containerName":"_simplify_helper","line":779,"kind":13},{"containerName":"_simplify_helper","name":"$paired","kind":13,"line":780},{"containerName":"_simplify_helper","name":"@data","line":780,"kind":13},{"line":781,"kind":13,"name":"$data","containerName":"_simplify_helper"},{"containerName":"_simplify_helper","name":"$data","line":781,"kind":13},{"line":782,"kind":13,"name":"$data","containerName":"_simplify_helper"},{"name":"$paired","containerName":"_simplify_helper","kind":13,"line":783}],"line":769},{"containerName":null,"name":"%id","kind":13,"line":786},{"line":787,"kind":13,"containerName":null,"name":"@data"},{"name":"$id","containerName":null,"kind":13,"line":787},{"kind":13,"line":790,"containerName":null,"name":"@data"},{"kind":12,"line":803,"children":[{"line":804,"kind":13,"localvar":"my","containerName":"distance","definition":"my","name":"$self"},{"kind":13,"line":804,"containerName":"distance","name":"@args"},{"localvar":"my","containerName":"distance","name":"$nodes","definition":"my","line":805,"kind":13},{"containerName":"distance","name":"$self","kind":13,"line":805},{"kind":12,"line":805,"containerName":"distance","name":"_rearrange"},{"name":"@args","containerName":"distance","line":805,"kind":13},{"kind":13,"line":806,"containerName":"distance","name":"$nodes"},{"line":807,"kind":13,"name":"$self","containerName":"distance"},{"containerName":"distance","name":"warn","line":807,"kind":12},{"line":810,"kind":13,"name":"$self","containerName":"distance"},{"line":810,"kind":12,"name":"throw","containerName":"distance"},{"kind":13,"line":810,"name":"$nodes","containerName":"distance"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"distance($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test"},"name":"distance","range":{"start":{"line":803,"character":0},"end":{"character":9999,"line":810}}},{"containerName":null,"definition":"my","name":"$lca","localvar":"my","kind":13,"line":812},{"kind":13,"line":812,"containerName":null,"name":"$self"},{"name":"get_lca","containerName":"main::","kind":12,"line":812},{"kind":13,"line":812,"name":"$nodes","containerName":null},{"line":813,"kind":13,"containerName":null,"name":"%lca"},{"name":"$self","containerName":null,"kind":13,"line":814},{"containerName":"main::","name":"warn","kind":12,"line":814},{"localvar":"my","containerName":null,"definition":"my","name":"$cumul_dist","line":818,"kind":13},{"containerName":null,"name":"$warned","definition":"my","localvar":"my","kind":13,"line":819},{"containerName":null,"name":"$current_node","definition":"my","localvar":"my","kind":13,"line":820},{"containerName":null,"name":"%nodes","kind":13,"line":820},{"containerName":null,"name":"$current_node","line":822,"kind":13},{"line":822,"kind":13,"name":"$lca","containerName":null},{"containerName":null,"name":"$current_node","kind":13,"line":823},{"kind":12,"line":823,"name":"branch_length","containerName":"main::"},{"name":"$cumul_dist","containerName":null,"kind":13,"line":824},{"kind":13,"line":824,"name":"$current_node","containerName":null},{"kind":12,"line":824,"containerName":"main::","name":"branch_length"},{"containerName":null,"name":"%warned","kind":13,"line":826},{"kind":13,"line":827,"containerName":null,"name":"$self"},{"kind":12,"line":827,"name":"warn","containerName":"main::"},{"kind":13,"line":828,"containerName":null,"name":"$warned"},{"containerName":null,"name":"$current_node","line":831,"kind":13},{"name":"$current_node","containerName":null,"kind":13,"line":831},{"line":831,"kind":12,"name":"ancestor","containerName":"main::"},{"line":835,"kind":13,"containerName":null,"name":"$cumul_dist"},{"signature":{"label":"is_monophyletic($self,@args)","documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test\n\n\nsub distance {\n    my ($self,@args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    if( ! defined $nodes ) {\n\t$self->warn(\"Must supply -nodes parameter to distance() method\");\n\treturn;\n    }\n    $self->throw(\"Must provide 2 nodes\") unless @{$nodes} == 2;\n\n    my $lca = $self->get_lca(@{$nodes});\n    unless($lca) { \n        $self->warn(\"could not find the lca of supplied nodes; can't find distance either\");\n        return;\n    }\n\n    my $cumul_dist = 0;\n    my $warned = 0;\n    foreach my $current_node (@{$nodes}) {\n        while (1) {\n            last if $current_node eq $lca;\n            if ($current_node->branch_length) {\n                $cumul_dist += $current_node->branch_length;\n            }\n            elsif (! $warned) {\n                $self->warn(\"At least some nodes do not have a branch length, the distance returned could be wrong\");\n                $warned = 1;\n            }\n\n            $current_node = $current_node->ancestor || last;\n        }\n    }\n\n    return $cumul_dist;\n}\n\n=head2 is_monophyletic\n\n Title   : is_monophyletic\n Usage   : if( $tree->is_monophyletic(-nodes => \\@nodes, \n\t\t\t\t      -outgroup => $outgroup)\n Function: Will do a test of monophyly for the nodes specified\n           in comparison to a chosen outgroup\n Returns : boolean\n Args    : -nodes    => arrayref of nodes to test\n           -outgroup => outgroup to serve as a reference","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":853,"kind":13,"localvar":"my","containerName":"is_monophyletic","definition":"my","name":"$self"},{"name":"@args","containerName":"is_monophyletic","line":853,"kind":13},{"kind":13,"line":854,"definition":"my","name":"$nodes","containerName":"is_monophyletic","localvar":"my"},{"line":854,"kind":13,"name":"$outgroup","containerName":"is_monophyletic"},{"line":854,"kind":13,"name":"$self","containerName":"is_monophyletic"},{"name":"_rearrange","containerName":"is_monophyletic","line":854,"kind":12},{"line":854,"kind":13,"name":"@args","containerName":"is_monophyletic"},{"kind":13,"line":856,"name":"$nodes","containerName":"is_monophyletic"},{"kind":13,"line":856,"containerName":"is_monophyletic","name":"$outgroup"},{"containerName":"is_monophyletic","name":"$self","kind":13,"line":857},{"kind":12,"line":857,"name":"warn","containerName":"is_monophyletic"},{"kind":13,"line":861,"containerName":"is_monophyletic","name":"$nodes"},{"kind":13,"line":862,"name":"$self","containerName":"is_monophyletic"},{"kind":12,"line":862,"name":"warn","containerName":"is_monophyletic"},{"localvar":"my","containerName":"is_monophyletic","definition":"my","name":"$clade_root","line":865,"kind":13},{"name":"$self","containerName":"is_monophyletic","kind":13,"line":865},{"kind":12,"line":865,"name":"get_lca","containerName":"is_monophyletic"},{"name":"$nodes","containerName":"is_monophyletic","kind":13,"line":865}],"line":852,"kind":12,"range":{"start":{"line":852,"character":0},"end":{"character":9999,"line":865}},"name":"is_monophyletic"},{"name":"%clade_root","containerName":null,"line":866,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":867},{"kind":12,"line":867,"name":"warn","containerName":"main::"},{"localvar":"my","definition":"my","name":"$og_ancestor","containerName":null,"line":871,"kind":13},{"containerName":null,"name":"$outgroup","kind":13,"line":871},{"line":871,"kind":12,"name":"ancestor","containerName":"main::"},{"containerName":null,"name":"%og_ancestor","line":872,"kind":13},{"containerName":null,"name":"$og_ancestor","kind":13,"line":873},{"kind":12,"line":873,"name":"internal_id","containerName":"main::"},{"name":"$clade_root","containerName":null,"kind":13,"line":873},{"line":873,"kind":12,"name":"internal_id","containerName":"main::"},{"containerName":null,"name":"$og_ancestor","kind":13,"line":877},{"name":"$og_ancestor","containerName":null,"kind":13,"line":877},{"containerName":"main::","name":"ancestor","line":877,"kind":12},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"is_paraphyletic","line":899,"kind":13},{"name":"@args","containerName":"is_paraphyletic","line":899,"kind":13},{"kind":13,"line":900,"definition":"my","name":"$nodes","containerName":"is_paraphyletic","localvar":"my"},{"name":"$outgroup","containerName":"is_paraphyletic","kind":13,"line":900},{"name":"$self","containerName":"is_paraphyletic","kind":13,"line":900},{"kind":12,"line":900,"name":"_rearrange","containerName":"is_paraphyletic"},{"containerName":"is_paraphyletic","name":"@args","kind":13,"line":900},{"name":"$nodes","containerName":"is_paraphyletic","line":902,"kind":13},{"line":902,"kind":13,"name":"$outgroup","containerName":"is_paraphyletic"},{"containerName":"is_paraphyletic","name":"$self","line":903,"kind":13},{"containerName":"is_paraphyletic","name":"warn","kind":12,"line":903},{"kind":13,"line":906,"name":"$nodes","containerName":"is_paraphyletic"},{"kind":13,"line":907,"containerName":"is_paraphyletic","name":"$self"},{"kind":12,"line":907,"containerName":"is_paraphyletic","name":"warn"},{"containerName":"is_paraphyletic","definition":"my","name":"%nodehash","localvar":"my","kind":13,"line":915},{"kind":13,"line":916,"containerName":"is_paraphyletic","definition":"my","name":"$n","localvar":"my"},{"line":916,"kind":13,"name":"$nodes","containerName":"is_paraphyletic"},{"kind":13,"line":917,"containerName":"is_paraphyletic","name":"$nodehash"},{"name":"$n","containerName":"is_paraphyletic","kind":13,"line":917},{"kind":12,"line":917,"containerName":"is_paraphyletic","name":"internal_id"},{"name":"$n","containerName":"is_paraphyletic","kind":13,"line":917},{"line":920,"kind":13,"localvar":"my","name":"$clade_root","definition":"my","containerName":"is_paraphyletic"},{"containerName":"is_paraphyletic","name":"$self","line":920,"kind":13},{"line":920,"kind":12,"name":"get_lca","containerName":"is_paraphyletic"},{"line":920,"kind":13,"containerName":"is_paraphyletic","name":"$nodes"},{"name":"$clade_root","containerName":"is_paraphyletic","line":921,"kind":13},{"line":922,"kind":13,"containerName":"is_paraphyletic","name":"$self"},{"line":922,"kind":12,"name":"warn","containerName":"is_paraphyletic"},{"localvar":"my","name":"$og_ancestor","definition":"my","containerName":"is_paraphyletic","line":926,"kind":13},{"kind":13,"line":926,"containerName":"is_paraphyletic","name":"$outgroup"},{"containerName":"is_paraphyletic","name":"ancestor","line":926,"kind":12},{"containerName":"is_paraphyletic","name":"$og_ancestor","line":929,"kind":13},{"name":"$og_ancestor","containerName":"is_paraphyletic","line":930,"kind":13},{"containerName":"is_paraphyletic","name":"internal_id","line":930,"kind":12},{"containerName":"is_paraphyletic","name":"$clade_root","kind":13,"line":930},{"containerName":"is_paraphyletic","name":"internal_id","line":930,"kind":12},{"kind":13,"line":934,"containerName":"is_paraphyletic","name":"$og_ancestor"},{"containerName":"is_paraphyletic","name":"$og_ancestor","line":934,"kind":13},{"containerName":"is_paraphyletic","name":"ancestor","kind":12,"line":934},{"definition":"my","name":"$tree","containerName":"is_paraphyletic","localvar":"my","kind":13,"line":936},{"containerName":"is_paraphyletic","name":"new","line":936,"kind":12},{"line":936,"kind":13,"name":"$clade_root","containerName":"is_paraphyletic"},{"containerName":"is_paraphyletic","name":"$n","definition":"my","localvar":"my","kind":13,"line":939},{"name":"$tree","containerName":"is_paraphyletic","line":939,"kind":13},{"name":"get_nodes","containerName":"is_paraphyletic","kind":12,"line":939},{"name":"$n","containerName":"is_paraphyletic","kind":13,"line":940},{"kind":12,"line":940,"containerName":"is_paraphyletic","name":"is_Leaf"},{"name":"$nodehash","containerName":"is_paraphyletic","line":944,"kind":13},{"kind":13,"line":944,"name":"$n","containerName":"is_paraphyletic"},{"line":944,"kind":12,"name":"internal_id","containerName":"is_paraphyletic"}],"line":898,"kind":12,"signature":{"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test\n\n\nsub distance {\n    my ($self,@args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    if( ! defined $nodes ) {\n\t$self->warn(\"Must supply -nodes parameter to distance() method\");\n\treturn;\n    }\n    $self->throw(\"Must provide 2 nodes\") unless @{$nodes} == 2;\n\n    my $lca = $self->get_lca(@{$nodes});\n    unless($lca) { \n        $self->warn(\"could not find the lca of supplied nodes; can't find distance either\");\n        return;\n    }\n\n    my $cumul_dist = 0;\n    my $warned = 0;\n    foreach my $current_node (@{$nodes}) {\n        while (1) {\n            last if $current_node eq $lca;\n            if ($current_node->branch_length) {\n                $cumul_dist += $current_node->branch_length;\n            }\n            elsif (! $warned) {\n                $self->warn(\"At least some nodes do not have a branch length, the distance returned could be wrong\");\n                $warned = 1;\n            }\n\n            $current_node = $current_node->ancestor || last;\n        }\n    }\n\n    return $cumul_dist;\n}\n\n=head2 is_monophyletic\n\n Title   : is_monophyletic\n Usage   : if( $tree->is_monophyletic(-nodes => \\@nodes, \n\t\t\t\t      -outgroup => $outgroup)\n Function: Will do a test of monophyly for the nodes specified\n           in comparison to a chosen outgroup\n Returns : boolean\n Args    : -nodes    => arrayref of nodes to test\n           -outgroup => outgroup to serve as a reference\n\n\n\nsub is_monophyletic{\n   my ($self,@args) = @_;\n   my ($nodes,$outgroup) = $self->_rearrange([qw(NODES OUTGROUP)],@args);\n\n   if( ! defined $nodes || ! defined $outgroup ) {\n       $self->warn(\"Must supply -nodes and -outgroup parameters to the method\nis_monophyletic\");\n       return;\n   }\n   if( ref($nodes) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid array reference for -nodes\");\n   }\n\n   my $clade_root = $self->get_lca(@{$nodes});\n   unless( defined $clade_root ) { \n       $self->warn(\"could not find clade root via lca\");\n       return;\n   }\n\n   my $og_ancestor = $outgroup->ancestor;\n   while( defined ($og_ancestor ) ) {\n       if( $og_ancestor->internal_id == $clade_root->internal_id ) {\n           # monophyly is violated\n           return 0;\n       }\n       $og_ancestor = $og_ancestor->ancestor;\n   }\n   return 1;\n}\n\n=head2 is_paraphyletic\n\n Title   : is_paraphyletic\n Usage   : if( $tree->is_paraphyletic(-nodes =>\\@nodes,\n\t\t\t\t      -outgroup => $node) ){ }\n Function: Tests whether or not a given set of nodes are paraphyletic\n           (representing the full clade) given an outgroup\n Returns : [-1,0,1] , -1 if the group is not monophyletic\n                       0 if the group is not paraphyletic\n                       1 if the group is paraphyletic\n Args    : -nodes => Array of Bio::Tree::NodeI objects which are in the tree\n           -outgroup => a Bio::Tree::NodeI to compare the nodes to","parameters":[{"label":"$self"},{"label":"@args"}],"label":"is_paraphyletic($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":947,"character":9999},"start":{"character":0,"line":898}},"name":"is_paraphyletic"},{"containerName":"Tree::Tree","name":"Bio","kind":12,"line":936},{"kind":12,"line":960,"children":[{"line":961,"kind":13,"localvar":"my","containerName":"reroot","definition":"my","name":"$self"},{"containerName":"reroot","name":"$new_root","kind":13,"line":961},{"kind":13,"line":962,"name":"$new_root","containerName":"reroot"},{"line":962,"kind":13,"name":"$new_root","containerName":"reroot"},{"containerName":"reroot","name":"isa","line":962,"kind":12},{"name":"$self","containerName":"reroot","line":963,"kind":13},{"name":"warn","containerName":"reroot","line":963,"kind":12},{"line":967,"kind":13,"localvar":"my","definition":"my","name":"$old_root","containerName":"reroot"},{"line":967,"kind":13,"containerName":"reroot","name":"$self"},{"line":967,"kind":12,"name":"get_root_node","containerName":"reroot"},{"line":968,"kind":13,"containerName":"reroot","name":"$new_root"},{"containerName":"reroot","name":"$old_root","kind":13,"line":968},{"kind":13,"line":969,"name":"$self","containerName":"reroot"},{"line":969,"kind":12,"containerName":"reroot","name":"warn"},{"line":972,"kind":13,"localvar":"my","containerName":"reroot","definition":"my","name":"$anc"},{"name":"$new_root","containerName":"reroot","kind":13,"line":972},{"containerName":"reroot","name":"ancestor","kind":12,"line":972},{"line":973,"kind":13,"name":"$anc","containerName":"reroot"},{"kind":13,"line":975,"containerName":"reroot","name":"$self"},{"containerName":"reroot","name":"warn","line":975,"kind":12},{"localvar":"my","containerName":"reroot","name":"$tmp_node","definition":"my","line":977,"kind":13},{"kind":13,"line":977,"containerName":"reroot","name":"$new_root"},{"containerName":"reroot","name":"create_node_on_branch","kind":12,"line":977},{"line":979,"kind":13,"localvar":"my","containerName":"reroot","name":"$former_anc","definition":"my"},{"kind":13,"line":979,"name":"$tmp_node","containerName":"reroot"},{"kind":12,"line":979,"containerName":"reroot","name":"ancestor"},{"containerName":"reroot","name":"@path_from_oldroot","definition":"my","localvar":"my","kind":13,"line":980},{"kind":13,"line":980,"name":"$self","containerName":"reroot"},{"name":"get_lineage_nodes","containerName":"reroot","line":980,"kind":12},{"containerName":"reroot","name":"$tmp_node","line":980,"kind":13},{"line":980,"kind":13,"containerName":"reroot","name":"$tmp_node"},{"name":"$i","definition":"my","containerName":"reroot","localvar":"my","kind":13,"line":981},{"containerName":"reroot","name":"$i","line":981,"kind":13},{"kind":13,"line":981,"containerName":"reroot","name":"$i"},{"line":982,"kind":13,"localvar":"my","name":"$current","definition":"my","containerName":"reroot"},{"containerName":"reroot","name":"$path_from_oldroot","line":982,"kind":13},{"name":"$i","containerName":"reroot","kind":13,"line":982},{"localvar":"my","containerName":"reroot","definition":"my","name":"$next","line":983,"kind":13},{"name":"$path_from_oldroot","containerName":"reroot","kind":13,"line":983},{"containerName":"reroot","name":"$i","line":983,"kind":13},{"line":984,"kind":13,"name":"$current","containerName":"reroot"},{"name":"remove_Descendent","containerName":"reroot","line":984,"kind":12},{"kind":13,"line":984,"containerName":"reroot","name":"$next"},{"kind":13,"line":985,"containerName":"reroot","name":"$current"},{"kind":12,"line":985,"containerName":"reroot","name":"branch_length"},{"kind":13,"line":985,"name":"$next","containerName":"reroot"},{"line":985,"kind":12,"name":"branch_length","containerName":"reroot"},{"kind":13,"line":986,"name":"$current","containerName":"reroot"},{"kind":12,"line":986,"name":"bootstrap","containerName":"reroot"},{"name":"$next","containerName":"reroot","line":986,"kind":13},{"containerName":"reroot","name":"bootstrap","line":986,"kind":12},{"line":986,"kind":13,"containerName":"reroot","name":"$next"},{"line":986,"kind":12,"name":"bootstrap","containerName":"reroot"},{"containerName":"reroot","name":"$next","line":987,"kind":13},{"kind":12,"line":987,"name":"remove_tag","containerName":"reroot"},{"line":988,"kind":13,"containerName":"reroot","name":"$next"},{"line":988,"kind":12,"containerName":"reroot","name":"add_Descendent"},{"name":"$current","containerName":"reroot","kind":13,"line":988},{"containerName":"reroot","name":"$new_root","line":991,"kind":13},{"kind":12,"line":991,"name":"add_Descendent","containerName":"reroot"},{"line":991,"kind":13,"name":"$former_anc","containerName":"reroot"},{"kind":13,"line":992,"name":"$tmp_node","containerName":"reroot"},{"name":"remove_Descendent","containerName":"reroot","line":992,"kind":12},{"line":992,"kind":13,"containerName":"reroot","name":"$former_anc"},{"kind":13,"line":994,"name":"$tmp_node","containerName":"reroot"},{"containerName":"reroot","name":"$new_root","line":995,"kind":13},{"name":"branch_length","containerName":"reroot","line":995,"kind":12},{"name":"$new_root","containerName":"reroot","kind":13,"line":996},{"name":"remove_tag","containerName":"reroot","line":996,"kind":12},{"name":"$old_root","containerName":"reroot","kind":13,"line":998},{"kind":13,"line":999,"name":"$self","containerName":"reroot"},{"containerName":"reroot","name":"set_root_node","kind":12,"line":999},{"containerName":"reroot","name":"$new_root","kind":13,"line":999}],"containerName":"main::","definition":"sub","detail":"($self,$new_root)","signature":{"parameters":[{"label":"$self"},{"label":"$new_root"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test\n\n\nsub distance {\n    my ($self,@args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    if( ! defined $nodes ) {\n\t$self->warn(\"Must supply -nodes parameter to distance() method\");\n\treturn;\n    }\n    $self->throw(\"Must provide 2 nodes\") unless @{$nodes} == 2;\n\n    my $lca = $self->get_lca(@{$nodes});\n    unless($lca) { \n        $self->warn(\"could not find the lca of supplied nodes; can't find distance either\");\n        return;\n    }\n\n    my $cumul_dist = 0;\n    my $warned = 0;\n    foreach my $current_node (@{$nodes}) {\n        while (1) {\n            last if $current_node eq $lca;\n            if ($current_node->branch_length) {\n                $cumul_dist += $current_node->branch_length;\n            }\n            elsif (! $warned) {\n                $self->warn(\"At least some nodes do not have a branch length, the distance returned could be wrong\");\n                $warned = 1;\n            }\n\n            $current_node = $current_node->ancestor || last;\n        }\n    }\n\n    return $cumul_dist;\n}\n\n=head2 is_monophyletic\n\n Title   : is_monophyletic\n Usage   : if( $tree->is_monophyletic(-nodes => \\@nodes, \n\t\t\t\t      -outgroup => $outgroup)\n Function: Will do a test of monophyly for the nodes specified\n           in comparison to a chosen outgroup\n Returns : boolean\n Args    : -nodes    => arrayref of nodes to test\n           -outgroup => outgroup to serve as a reference\n\n\n\nsub is_monophyletic{\n   my ($self,@args) = @_;\n   my ($nodes,$outgroup) = $self->_rearrange([qw(NODES OUTGROUP)],@args);\n\n   if( ! defined $nodes || ! defined $outgroup ) {\n       $self->warn(\"Must supply -nodes and -outgroup parameters to the method\nis_monophyletic\");\n       return;\n   }\n   if( ref($nodes) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid array reference for -nodes\");\n   }\n\n   my $clade_root = $self->get_lca(@{$nodes});\n   unless( defined $clade_root ) { \n       $self->warn(\"could not find clade root via lca\");\n       return;\n   }\n\n   my $og_ancestor = $outgroup->ancestor;\n   while( defined ($og_ancestor ) ) {\n       if( $og_ancestor->internal_id == $clade_root->internal_id ) {\n           # monophyly is violated\n           return 0;\n       }\n       $og_ancestor = $og_ancestor->ancestor;\n   }\n   return 1;\n}\n\n=head2 is_paraphyletic\n\n Title   : is_paraphyletic\n Usage   : if( $tree->is_paraphyletic(-nodes =>\\@nodes,\n\t\t\t\t      -outgroup => $node) ){ }\n Function: Tests whether or not a given set of nodes are paraphyletic\n           (representing the full clade) given an outgroup\n Returns : [-1,0,1] , -1 if the group is not monophyletic\n                       0 if the group is not paraphyletic\n                       1 if the group is paraphyletic\n Args    : -nodes => Array of Bio::Tree::NodeI objects which are in the tree\n           -outgroup => a Bio::Tree::NodeI to compare the nodes to\n\n\n\nsub is_paraphyletic{\n   my ($self,@args) = @_;\n   my ($nodes,$outgroup) = $self->_rearrange([qw(NODES OUTGROUP)],@args);\n\n   if( ! defined $nodes || ! defined $outgroup ) {\n       $self->warn(\"Must suply -nodes and -outgroup parameters to the method is_paraphyletic\");\n       return;\n   }\n   if( ref($nodes) !~ /ARRAY/i ) { \n       $self->warn(\"Must provide a valid array reference for -nodes\");\n       return;\n   }\n\n   # Algorithm\n   # Find the lca\n   # Find all the nodes beneath the lca\n   # Test to see that none are missing from the nodes list\n   my %nodehash;\n   foreach my $n ( @$nodes ) {\n       $nodehash{$n->internal_id} = $n;\n   }\n\n   my $clade_root = $self->get_lca(-nodes => $nodes );\n   unless( defined $clade_root ) { \n       $self->warn(\"could not find clade root via lca\");\n       return;\n   }\n\n   my $og_ancestor = $outgroup->ancestor;\n\n   # Is this necessary/correct for paraphyly test?\n   while( defined ($og_ancestor ) ) {\n       if( $og_ancestor->internal_id == $clade_root->internal_id ) {\n           # monophyly is violated, could be paraphyletic\n           return -1;\n       }\n       $og_ancestor = $og_ancestor->ancestor;\n   }\n   my $tree = Bio::Tree::Tree->new(-root     => $clade_root,\n\t\t\t\t  -nodelete => 1);\n\n   foreach my $n ( $tree->get_nodes() ) { \n       next unless $n->is_Leaf();\n       # if any leaf node is not in the list\n       # then it is part of the clade and so the list\n       # must be paraphyletic\n       return 1 unless (  $nodehash{$n->internal_id} );\n   }\n   return 0;\n}\n\n\n=head2 reroot\n\n Title   : reroot\n Usage   : $tree->reroot($node);\n Function: Reroots a tree making a new node the root\n Returns : 1 on success, 0 on failure\n Args    : Bio::Tree::NodeI that is in the tree, but is not the current root","label":"reroot($self,$new_root)"},"name":"reroot","range":{"start":{"line":960,"character":0},"end":{"line":1002,"character":9999}}},{"line":981,"kind":12,"name":"path_from_oldroot"},{"containerName":"main::","name":"reroot_at_midpoint","definition":"sub","range":{"start":{"line":1016,"character":0},"end":{"character":9999,"line":1033}},"kind":12,"line":1016,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"reroot_at_midpoint","line":1017,"kind":13},{"kind":13,"line":1018,"name":"$node","definition":"my","containerName":"reroot_at_midpoint","localvar":"my"},{"line":1019,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":"reroot_at_midpoint"},{"kind":13,"line":1021,"name":"$node","containerName":"reroot_at_midpoint"},{"containerName":"reroot_at_midpoint","name":"$node","kind":13,"line":1021},{"line":1021,"kind":12,"name":"isa","containerName":"reroot_at_midpoint"},{"containerName":"reroot_at_midpoint","name":"$self","line":1022,"kind":13},{"containerName":"reroot_at_midpoint","name":"warn","kind":12,"line":1022},{"line":1026,"kind":13,"localvar":"my","name":"$midpt","definition":"my","containerName":"reroot_at_midpoint"},{"name":"$node","containerName":"reroot_at_midpoint","kind":13,"line":1026},{"name":"create_node_on_branch","containerName":"reroot_at_midpoint","kind":12,"line":1026},{"kind":13,"line":1027,"containerName":"reroot_at_midpoint","name":"$id"},{"line":1028,"kind":13,"name":"$self","containerName":"reroot_at_midpoint"},{"kind":12,"line":1028,"containerName":"reroot_at_midpoint","name":"warn"},{"containerName":"reroot_at_midpoint","name":"$id","line":1028,"kind":13},{"line":1029,"kind":13,"containerName":"reroot_at_midpoint","name":"$midpt"},{"kind":12,"line":1029,"name":"id","containerName":"reroot_at_midpoint"},{"kind":13,"line":1029,"containerName":"reroot_at_midpoint","name":"$id"},{"containerName":"reroot_at_midpoint","name":"$id","line":1029,"kind":13},{"containerName":"reroot_at_midpoint","name":"$id","line":1029,"kind":13},{"containerName":"reroot_at_midpoint","name":"$self","kind":13,"line":1031},{"line":1031,"kind":12,"name":"reroot","containerName":"reroot_at_midpoint"},{"kind":13,"line":1031,"name":"$midpt","containerName":"reroot_at_midpoint"},{"containerName":"reroot_at_midpoint","name":"$midpt","kind":13,"line":1032}]},{"line":1048,"children":[{"line":1049,"kind":13,"localvar":"my","name":"$tree","definition":"my","containerName":"findnode_by_id"},{"containerName":"findnode_by_id","name":"$tree","kind":13,"line":1050},{"containerName":"findnode_by_id","name":"deprecated","line":1050,"kind":12},{"definition":"my","name":"$id","containerName":"findnode_by_id","localvar":"my","kind":13,"line":1052},{"localvar":"my","name":"$rootnode","definition":"my","containerName":"findnode_by_id","line":1053,"kind":13},{"kind":13,"line":1053,"containerName":"findnode_by_id","name":"$tree"},{"kind":12,"line":1053,"name":"get_root_node","containerName":"findnode_by_id"},{"containerName":"findnode_by_id","name":"$rootnode","line":1054,"kind":13},{"containerName":"findnode_by_id","name":"id","kind":12,"line":1054},{"kind":13,"line":1054,"containerName":"findnode_by_id","name":"$rootnode"},{"containerName":"findnode_by_id","name":"id","kind":12,"line":1054},{"containerName":"findnode_by_id","name":"$id","kind":13,"line":1054},{"name":"$rootnode","containerName":"findnode_by_id","kind":13,"line":1055},{"localvar":"my","definition":"my","name":"$node","containerName":"findnode_by_id","line":1058,"kind":13},{"line":1058,"kind":13,"containerName":"findnode_by_id","name":"$rootnode"},{"containerName":"findnode_by_id","name":"get_Descendents","line":1058,"kind":12},{"kind":13,"line":1059,"name":"$node","containerName":"findnode_by_id"},{"containerName":"findnode_by_id","name":"id","line":1059,"kind":12},{"name":"$node","containerName":"findnode_by_id","kind":13,"line":1059},{"name":"id","containerName":"findnode_by_id","kind":12,"line":1059},{"name":"$id","containerName":"findnode_by_id","line":1059,"kind":13},{"kind":13,"line":1060,"name":"$node","containerName":"findnode_by_id"}],"kind":12,"range":{"start":{"character":0,"line":1048},"end":{"character":9999,"line":1063}},"containerName":"main::","definition":"sub","name":"findnode_by_id"},{"kind":12,"line":1076,"children":[{"line":1077,"kind":13,"localvar":"my","definition":"my","name":"$tree","containerName":"move_id_to_bootstrap"},{"line":1078,"kind":13,"localvar":"my","name":"$node","definition":"my","containerName":"move_id_to_bootstrap"},{"containerName":"move_id_to_bootstrap","name":"is_Leaf","line":1078,"kind":12},{"name":"$tree","containerName":"move_id_to_bootstrap","line":1078,"kind":13},{"name":"get_nodes","containerName":"move_id_to_bootstrap","kind":12,"line":1078},{"kind":13,"line":1079,"containerName":"move_id_to_bootstrap","name":"$node"},{"name":"bootstrap","containerName":"move_id_to_bootstrap","kind":12,"line":1079},{"kind":13,"line":1079,"containerName":"move_id_to_bootstrap","name":"$node"},{"containerName":"move_id_to_bootstrap","name":"id","line":1079,"kind":12},{"kind":13,"line":1080,"containerName":"move_id_to_bootstrap","name":"$node"},{"containerName":"move_id_to_bootstrap","name":"id","kind":12,"line":1080}],"containerName":"main::","definition":"sub","name":"move_id_to_bootstrap","range":{"end":{"line":1082,"character":9999},"start":{"line":1076,"character":0}}},{"kind":12,"children":[{"localvar":"my","containerName":"_read_trait_file","name":"$self","definition":"my","line":1104,"kind":13},{"kind":13,"line":1105,"name":"$file","definition":"my","containerName":"_read_trait_file","localvar":"my"},{"localvar":"my","containerName":"_read_trait_file","name":"$column","definition":"my","line":1106,"kind":13},{"line":1108,"kind":13,"localvar":"my","definition":"my","name":"$traits","containerName":"_read_trait_file"},{"line":1109,"kind":13,"localvar":"my","definition":"my","name":"$TRAIT","containerName":"_read_trait_file"},{"line":1109,"kind":13,"containerName":"_read_trait_file","name":"$file"},{"name":"$self","containerName":"_read_trait_file","line":1109,"kind":13},{"localvar":"my","definition":"my","name":"$first_line","containerName":"_read_trait_file","line":1111,"kind":13},{"line":1112,"kind":13,"name":"$TRAIT","containerName":"_read_trait_file"},{"line":1113,"kind":13,"containerName":"_read_trait_file","name":"$first_line"},{"line":1114,"kind":13,"containerName":"_read_trait_file","name":"$first_line"},{"kind":13,"line":1116,"containerName":"_read_trait_file","definition":"my","name":"@line","localvar":"my"},{"line":1117,"kind":13,"containerName":"_read_trait_file","name":"$traits"},{"containerName":"_read_trait_file","name":"$line","line":1117,"kind":13},{"kind":13,"line":1117,"name":"$column","containerName":"_read_trait_file"},{"localvar":"my","name":"@line","definition":"my","containerName":"_read_trait_file","line":1121,"kind":13},{"containerName":"_read_trait_file","name":"$line","kind":13,"line":1122},{"name":"$traits","containerName":"_read_trait_file","kind":13,"line":1123},{"containerName":"_read_trait_file","name":"$line","kind":13,"line":1123},{"kind":13,"line":1123,"name":"$line","containerName":"_read_trait_file"},{"kind":13,"line":1123,"containerName":"_read_trait_file","name":"$column"},{"containerName":"_read_trait_file","name":"$traits","kind":13,"line":1125}],"line":1103,"definition":"sub","name":"_read_trait_file","containerName":"main::","range":{"start":{"character":0,"line":1103},"end":{"line":1126,"character":9999}}},{"line":1128,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_trait","line":1129,"kind":13},{"localvar":"my","definition":"my","name":"$file","containerName":"add_trait","line":1130,"kind":13},{"line":1131,"kind":13,"localvar":"my","definition":"my","name":"$column","containerName":"add_trait"},{"definition":"my","name":"$traits","containerName":"add_trait","localvar":"my","kind":13,"line":1133},{"containerName":"add_trait","name":"$self","line":1133,"kind":13},{"containerName":"add_trait","name":"_read_trait_file","kind":12,"line":1133},{"name":"$file","containerName":"add_trait","line":1133,"kind":13},{"kind":13,"line":1133,"name":"$column","containerName":"add_trait"},{"containerName":"add_trait","name":"$key","definition":"my","localvar":"my","kind":13,"line":1134},{"kind":13,"line":1134,"name":"$traits","containerName":"add_trait"},{"localvar":"my","definition":"my","name":"$node","containerName":"add_trait","line":1136,"kind":13},{"kind":13,"line":1136,"containerName":"add_trait","name":"$self"},{"containerName":"add_trait","name":"get_leaf_nodes","line":1136,"kind":12},{"line":1138,"kind":13,"name":"$node","containerName":"add_trait"},{"kind":12,"line":1138,"containerName":"add_trait","name":"id"},{"line":1138,"kind":13,"containerName":"add_trait","name":"$node"},{"name":"id","containerName":"add_trait","kind":12,"line":1138},{"containerName":"add_trait","name":"$node","line":1140,"kind":13},{"kind":12,"line":1140,"containerName":"add_trait","name":"verbose"},{"kind":13,"line":1141,"containerName":"add_trait","name":"$node"},{"containerName":"add_trait","name":"add_tag_value","line":1141,"kind":12},{"name":"$key","containerName":"add_trait","kind":13,"line":1141},{"line":1141,"kind":13,"name":"$traits","containerName":"add_trait"},{"name":"$node","containerName":"add_trait","line":1141,"kind":13},{"line":1141,"kind":12,"name":"id","containerName":"add_trait"},{"kind":13,"line":1143,"name":"$self","containerName":"add_trait"},{"containerName":"add_trait","name":"throw","line":1143,"kind":12},{"kind":13,"line":1144,"name":"$node","containerName":"add_trait"},{"line":1144,"kind":12,"containerName":"add_trait","name":"id"},{"containerName":"add_trait","name":"$node","line":1144,"kind":13},{"name":"internal_id","containerName":"add_trait","kind":12,"line":1144},{"kind":13,"line":1147,"containerName":"add_trait","name":"$key"}],"kind":12,"range":{"end":{"line":1148,"character":9999},"start":{"line":1128,"character":0}},"containerName":"main::","definition":"sub","name":"add_trait"}]}