{"vars":[{"name":"warnings","kind":12,"line":124},{"containerName":"","name":"base","kind":2,"line":126},{"name":"add_Descendent","range":{"start":{"character":0,"line":139},"end":{"line":143,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"add_Descendent($self,@args)","documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"containerName":"add_Descendent","name":"$self","definition":"my","localvar":"my","kind":13,"line":140},{"name":"@args","containerName":"add_Descendent","line":140,"kind":13},{"line":142,"kind":13,"containerName":"add_Descendent","name":"$self"},{"kind":12,"line":142,"containerName":"add_Descendent","name":"throw_not_implemented"}],"line":139},{"range":{"start":{"line":157,"character":0},"end":{"character":9999,"line":160}},"name":"each_Descendent","detail":"($self)","signature":{"label":"each_Descendent($self)","documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":157,"children":[{"containerName":"each_Descendent","name":"$self","definition":"my","localvar":"my","kind":13,"line":158},{"name":"$self","containerName":"each_Descendent","line":159,"kind":13},{"containerName":"each_Descendent","name":"throw_not_implemented","kind":12,"line":159}],"kind":12},{"name":"get_all_Descendents","range":{"end":{"character":9999,"line":186},"start":{"character":0,"line":178}},"kind":12,"line":178,"children":[{"kind":13,"line":179,"containerName":"get_all_Descendents","name":"$self","definition":"my","localvar":"my"},{"name":"$sortby","containerName":"get_all_Descendents","line":179,"kind":13},{"containerName":"get_all_Descendents","name":"$sortby","line":180,"kind":13},{"localvar":"my","name":"@nodes","definition":"my","containerName":"get_all_Descendents","line":181,"kind":13},{"name":"$node","definition":"my","containerName":"get_all_Descendents","localvar":"my","kind":13,"line":182},{"kind":13,"line":182,"containerName":"get_all_Descendents","name":"$self"},{"kind":12,"line":182,"name":"each_Descendent","containerName":"get_all_Descendents"},{"line":182,"kind":13,"containerName":"get_all_Descendents","name":"$sortby"},{"line":183,"kind":13,"name":"@nodes","containerName":"get_all_Descendents"},{"name":"$node","containerName":"get_all_Descendents","line":183,"kind":13},{"name":"$node","containerName":"get_all_Descendents","line":183,"kind":13},{"name":"get_all_Descendents","containerName":"get_all_Descendents","kind":12,"line":183},{"line":183,"kind":13,"name":"$sortby","containerName":"get_all_Descendents"},{"containerName":"get_all_Descendents","name":"@nodes","line":185,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$sortby)","signature":{"label":"get_all_Descendents($self,$sortby)","parameters":[{"label":"$self"},{"label":"$sortby"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes."}},{"kind":12,"line":200,"children":[{"line":201,"kind":13,"localvar":"my","containerName":"is_Leaf","definition":"my","name":"$self"},{"kind":13,"line":202,"containerName":"is_Leaf","name":"$self"},{"kind":12,"line":202,"containerName":"is_Leaf","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"is_Leaf($self)","documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none","parameters":[{"label":"$self"}]},"name":"is_Leaf","range":{"start":{"line":200,"character":0},"end":{"line":203,"character":9999}}},{"children":[{"line":217,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"descendent_count"},{"kind":13,"line":218,"definition":"my","name":"$count","containerName":"descendent_count","localvar":"my"},{"localvar":"my","containerName":"descendent_count","name":"$node","definition":"my","line":220,"kind":13},{"kind":13,"line":220,"containerName":"descendent_count","name":"$self"},{"line":220,"kind":12,"containerName":"descendent_count","name":"each_Descendent"},{"line":221,"kind":13,"name":"$count","containerName":"descendent_count"},{"kind":13,"line":222,"name":"$node","containerName":"descendent_count"},{"name":"can","containerName":"descendent_count","kind":12,"line":222},{"line":222,"kind":13,"name":"$count","containerName":"descendent_count"},{"line":222,"kind":13,"name":"$node","containerName":"descendent_count"},{"line":222,"kind":12,"containerName":"descendent_count","name":"descendent_count"},{"kind":13,"line":224,"containerName":"descendent_count","name":"$count"}],"line":216,"kind":12,"signature":{"label":"descendent_count($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":225,"character":9999},"start":{"character":0,"line":216}},"name":"descendent_count"},{"detail":"($self)","signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none"},"containerName":"main::","definition":"sub","line":238,"children":[{"definition":"my","name":"$self","containerName":"to_string","localvar":"my","kind":13,"line":239},{"line":240,"kind":13,"name":"$self","containerName":"to_string"},{"name":"id_output","containerName":"to_string","line":240,"kind":12},{"containerName":"to_string","name":"$self","line":240,"kind":13},{"kind":12,"line":240,"containerName":"to_string","name":"id_output"},{"containerName":"to_string","name":"$self","line":241,"kind":13},{"line":241,"kind":12,"containerName":"to_string","name":"branch_length"},{"line":241,"kind":13,"name":"$self","containerName":"to_string"},{"name":"branch_length","containerName":"to_string","kind":12,"line":241}],"kind":12,"range":{"end":{"line":243,"character":9999},"start":{"line":238,"character":0}},"name":"to_string"},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none","label":"height($self)"},"containerName":"main::","definition":"sub","line":256,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"height","line":257,"kind":13},{"name":"$self","containerName":"height","line":259,"kind":13},{"containerName":"height","name":"is_Leaf","line":259,"kind":12},{"containerName":"height","name":"$max","definition":"my","localvar":"my","kind":13,"line":261},{"kind":13,"line":262,"name":"$subnode","definition":"my","containerName":"height","localvar":"my"},{"line":262,"kind":13,"containerName":"height","name":"$self"},{"kind":12,"line":262,"containerName":"height","name":"each_Descendent"},{"line":263,"kind":13,"localvar":"my","name":"$s","definition":"my","containerName":"height"},{"name":"$subnode","containerName":"height","line":263,"kind":13},{"kind":12,"line":263,"name":"height","containerName":"height"},{"containerName":"height","name":"$subnode","line":263,"kind":13},{"containerName":"height","name":"branch_length","kind":12,"line":263},{"line":264,"kind":13,"name":"$s","containerName":"height"},{"line":264,"kind":13,"name":"$max","containerName":"height"},{"name":"$max","containerName":"height","kind":13,"line":264},{"containerName":"height","name":"$s","line":264,"kind":13},{"kind":13,"line":266,"containerName":"height","name":"$max"}],"kind":12,"range":{"start":{"line":256,"character":0},"end":{"character":9999,"line":267}},"name":"height"},{"name":"depth","range":{"end":{"line":290,"character":9999},"start":{"line":280,"character":0}},"kind":12,"line":280,"children":[{"kind":13,"line":281,"containerName":"depth","definition":"my","name":"$self","localvar":"my"},{"line":283,"kind":13,"localvar":"my","containerName":"depth","definition":"my","name":"$depth"},{"kind":13,"line":284,"containerName":"depth","definition":"my","name":"$node","localvar":"my"},{"name":"$self","containerName":"depth","kind":13,"line":284},{"line":285,"kind":13,"containerName":"depth","name":"$node"},{"line":285,"kind":12,"containerName":"depth","name":"ancestor"},{"name":"$depth","containerName":"depth","kind":13,"line":286},{"name":"$node","containerName":"depth","line":286,"kind":13},{"line":286,"kind":12,"name":"branch_length","containerName":"depth"},{"name":"$node","containerName":"depth","line":287,"kind":13},{"containerName":"depth","name":"$node","line":287,"kind":13},{"kind":12,"line":287,"containerName":"depth","name":"ancestor"},{"kind":13,"line":289,"name":"$depth","containerName":"depth"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none","parameters":[{"label":"$self"}],"label":"depth($self)"}},{"name":"branch_length","range":{"start":{"character":0,"line":307},"end":{"line":310,"character":9999}},"kind":12,"line":307,"children":[{"line":308,"kind":13,"localvar":"my","containerName":"branch_length","definition":"my","name":"$self"},{"containerName":"branch_length","name":"$self","kind":13,"line":309},{"name":"throw_not_implemented","containerName":"branch_length","line":309,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"branch_length($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)"}},{"range":{"start":{"line":323,"character":0},"end":{"character":9999,"line":326}},"name":"id","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)","label":"id($self)"},"containerName":"main::","definition":"sub","line":323,"children":[{"name":"$self","definition":"my","containerName":"id","localvar":"my","kind":13,"line":324},{"name":"$self","containerName":"id","kind":13,"line":325},{"containerName":"id","name":"throw_not_implemented","line":325,"kind":12}],"kind":12},{"line":338,"children":[{"localvar":"my","containerName":"internal_id","name":"$self","definition":"my","line":339,"kind":13},{"kind":13,"line":340,"containerName":"internal_id","name":"$self"},{"name":"throw_not_implemented","containerName":"internal_id","line":340,"kind":12}],"kind":12,"detail":"($self)","signature":{"label":"internal_id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":338},"end":{"line":341,"character":9999}},"name":"internal_id"},{"kind":12,"line":354,"children":[{"line":355,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"description"},{"line":356,"kind":13,"name":"$self","containerName":"description"},{"containerName":"description","name":"throw_not_implemented","kind":12,"line":356}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"description($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none\n\n\nsub internal_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function: Get/Set the description string\n Returns : value of description\n Args    : newvalue (optional)"},"name":"description","range":{"start":{"character":0,"line":354},"end":{"line":357,"character":9999}}},{"kind":12,"line":370,"children":[{"name":"$self","definition":"my","containerName":"bootstrap","localvar":"my","kind":13,"line":371},{"line":372,"kind":13,"name":"$self","containerName":"bootstrap"},{"containerName":"bootstrap","name":"throw_not_implemented","line":372,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"bootstrap($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none\n\n\nsub internal_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function: Get/Set the description string\n Returns : value of description\n Args    : newvalue (optional)\n\n\n\nsub description{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 bootstrap\n\n Title   : bootstrap\n Usage   : $obj->bootstrap($newval)\n Function: Get/Set the bootstrap value\n Returns : value of bootstrap\n Args    : newvalue (optional)"},"name":"bootstrap","range":{"end":{"line":373,"character":9999},"start":{"character":0,"line":370}}},{"name":"ancestor","range":{"start":{"character":0,"line":386},"end":{"character":9999,"line":389}},"kind":12,"line":386,"children":[{"kind":13,"line":387,"containerName":"ancestor","definition":"my","name":"$self","localvar":"my"},{"containerName":"ancestor","name":"@args","kind":13,"line":387},{"line":388,"kind":13,"containerName":"ancestor","name":"$self"},{"containerName":"ancestor","name":"throw_not_implemented","kind":12,"line":388}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: NodeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeI - Interface describing a Tree Node\n\n=head1 SYNOPSIS\n\n    # get a Tree::NodeI somehow\n    # like from a TreeIO\n    use Bio::TreeIO;\n    # read in a clustalw NJ in phylip/newick format\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'file.dnd');\n\n    my $tree = $treeio->next_tree; # we'll assume it worked for demo purposes\n                                   # you might want to test that it was defined\n\n    my $rootnode = $tree->get_root_node;\n\n    # process just the next generation\n    foreach my $node ( $rootnode->each_Descendent() ) {\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # process all the children\n    my $example_leaf_node;\n    foreach my $node ( $rootnode->get_all_Descendents() ) {\n\tif( $node->is_Leaf ) { \n\t    print \"node is a leaf ... \"; \n            # for example use below\n            $example_leaf_node = $node unless defined $example_leaf_node; \n\t}\n\tprint \"branch len is \", $node->branch_length, \"\\n\";\n    }\n\n    # The ancestor() method points to the parent of a node\n    # A node can only have one parent\n\n    my $parent = $example_leaf_node->ancestor;\n\n    # parent won't likely have an description because it is an internal node\n    # but child will because it is a leaf\n\n    print \"Parent id: \", $parent->id,\" child id: \", \n          $example_leaf_node->id, \"\\n\";\n\n\n=head1 DESCRIPTION\n\nA NodeI is capable of the basic structure of building a tree and\nstoring the branch length between nodes.  The branch length is the\nlength of the branch between the node and its ancestor, thus a root\nnode in a Tree will not typically have a valid branch length.\n\nVarious implementations of NodeI may extend the basic functions and\nallow storing of other information (like attatching a species object\nor full sequences used to build a tree or alternative sequences).  If\nyou don't know how to extend a Bioperl object please ask, happy to\nhelp, we would also greatly appreciate contributions with improvements\nor extensions of the objects back to the Bioperl code base so that\nothers don't have to reinvent your ideas.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeI;\nuse strict;\nno warnings 'recursion';\n\nuse base qw(Bio::Root::RootI);\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $node->add_Descendent($node);\n Function: Adds a descendent to a node\n Returns : number of current descendents for this node\n Args    : Bio::Node::NodeI\n\n\n\nsub add_Descendent{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @nodes = $node->each_Descendent;\n Function: all the descendents for this Node (but not their descendents \n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none\n\n\nsub each_Descendent{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 Decorated Interface methods\n\n\n=head2 get_all_Descendents\n\n Title   : get_all_Descendents($sortby)\n Usage   : my @nodes = $node->get_all_Descendents;\n Function: Recursively fetch all the nodes and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Tree::NodeI objects\n Args    : $sortby [optional] \"height\", \"creation\", \"alpha\", \"revalpha\", \n           or a coderef to be used to sort the order of children nodes.\n\n\nsub get_all_Descendents{\n   my ($self, $sortby) = @_;\n   $sortby ||= 'none';   \n   my @nodes;\n   foreach my $node ( $self->each_Descendent($sortby) ) {\n       push @nodes, ($node,$node->get_all_Descendents($sortby));\n   }\n   return @nodes;\n}\n\n*get_Descendents = \\&get_all_Descendents;\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf ) \n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 descendent_count\n\n Title   : descendent_count\n Usage   : my $count = $node->descendent_count;\n Function: Counts the number of descendents a node has \n           (and all of their subnodes)\n Returns : integer\n Args    : none\n\n\nsub descendent_count{\n   my ($self) = @_;\n   my $count = 0;\n   \n   foreach my $node ( $self->each_Descendent ) { \n       $count += 1;\n       $node->can('descendent_count') ? $count += $node->descendent_count : next;\n   }\n   return $count;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $node->to_string()\n Function: For debugging, provide a node as a string\n Returns : string\n Args    : none\n\n\n\nsub to_string{\n   my ($self) = @_;\n   return join('',defined $self->id_output ? $self->id_output : '',\n\t\t  defined $self->branch_length ? ':' . $self->branch_length \n\t\t  : ' ')\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $node->height\n Function: Returns the height of the tree starting at this\n           node.  Height is the maximum branchlength to get to the tip.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height{\n    my ($self) = @_;\n\n    return 0 if( $self->is_Leaf );\n    \n    my $max = 0;\n    foreach my $subnode ( $self->each_Descendent ) { \n\tmy $s = $subnode->height + $subnode->branch_length;;\n\tif( $s > $max ) { $max = $s; }\n    }\n    return $max;\n}\n\n=head2 depth\n\n Title   : depth\n Usage   : my $len = $node->depth\n Function: Returns the depth of the tree starting at this\n           node.  Depth is the distance from this node to the root.\n Returns : The branch length to the root.\n Args    : none\n\n\nsub depth{\n   my ($self) = @_;\n   \n   my $depth = 0;\n   my $node = $self;\n   while( defined $node->ancestor ) { \n       $depth += $node->branch_length;\n       $node = $node->ancestor;\n   }\n   return $depth;\n}\n\n=head2 Get/Set methods\n\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length()\n Function: Get/Set the branch length\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\n\nsub branch_length{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function: The human readable identifier for the node \n Returns : value of human readable id\n Args    : newvalue (optional)\n\n\n\nsub id{\n    my ($self)= @_;\n    $self->throw_not_implemented();\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $node->internal_id\n Function: Returns the internal unique id for this Node\n Returns : unique id\n Args    : none\n\n\nsub internal_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function: Get/Set the description string\n Returns : value of description\n Args    : newvalue (optional)\n\n\n\nsub description{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 bootstrap\n\n Title   : bootstrap\n Usage   : $obj->bootstrap($newval)\n Function: Get/Set the bootstrap value\n Returns : value of bootstrap\n Args    : newvalue (optional)\n\n\n\nsub bootstrap{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : my $node = $node->ancestor;\n Function: Get/Set the ancestor node pointer for a Node\n Returns : Null if this is top level node\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"ancestor($self,@args)"}},{"children":[{"name":"throw_not_implemented","containerName":"invalidate_height","kind":12,"line":402}],"line":401,"kind":12,"range":{"start":{"line":401,"character":0},"end":{"line":403,"character":9999}},"definition":"sub","name":"invalidate_height","containerName":"main::"},{"line":421,"children":[{"line":422,"kind":12,"name":"throw_not_implemented","containerName":"set_tag_value"}],"kind":12,"range":{"start":{"line":421,"character":0},"end":{"character":9999,"line":423}},"containerName":"main::","name":"set_tag_value","definition":"sub"},{"kind":12,"children":[{"kind":12,"line":438,"containerName":"add_tag_value","name":"throw_not_implemented"}],"line":437,"name":"add_tag_value","definition":"sub","containerName":"main::","range":{"start":{"line":437,"character":0},"end":{"line":439,"character":9999}}},{"line":452,"children":[{"kind":12,"line":453,"containerName":"remove_tag","name":"throw_not_implemented"}],"kind":12,"range":{"start":{"character":0,"line":452},"end":{"character":9999,"line":454}},"containerName":"main::","definition":"sub","name":"remove_tag"},{"definition":"sub","name":"remove_all_tags","containerName":"main::","range":{"end":{"character":9999,"line":469},"start":{"character":0,"line":467}},"kind":12,"children":[{"containerName":"remove_all_tags","name":"throw_not_implemented","line":468,"kind":12}],"line":467},{"range":{"start":{"character":0,"line":482},"end":{"character":9999,"line":484}},"name":"get_all_tags","definition":"sub","containerName":"main::","children":[{"name":"throw_not_implemented","containerName":"get_all_tags","line":483,"kind":12}],"line":482,"kind":12},{"children":[{"containerName":"get_tag_values","name":"throw_not_implemented","kind":12,"line":498}],"line":497,"kind":12,"range":{"end":{"character":9999,"line":499},"start":{"character":0,"line":497}},"name":"get_tag_values","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"line":513,"kind":12,"containerName":"has_tag","name":"throw_not_implemented"}],"line":512,"definition":"sub","name":"has_tag","containerName":"main::","range":{"end":{"character":9999,"line":514},"start":{"line":512,"character":0}}},{"name":"id_output","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":544},"start":{"line":534,"character":0}},"kind":12,"children":[{"kind":13,"line":535,"containerName":"id_output","name":"$node","definition":"my","localvar":"my"},{"containerName":"id_output","definition":"my","name":"$id","localvar":"my","kind":13,"line":536},{"name":"$node","containerName":"id_output","line":536,"kind":13},{"line":536,"kind":12,"name":"id","containerName":"id_output"},{"line":537,"kind":13,"containerName":"id_output","name":"$id"},{"line":537,"kind":13,"name":"$id","containerName":"id_output"},{"line":540,"kind":13,"containerName":"id_output","name":"$id"},{"line":541,"kind":13,"containerName":"id_output","name":"$id"},{"name":"$id","containerName":"id_output","kind":13,"line":541},{"kind":13,"line":543,"containerName":"id_output","name":"$id"}],"line":534}],"version":5}