{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":196},{"name":"base","containerName":"","line":202,"kind":2},{"kind":13,"line":205,"containerName":null,"name":"$RSTFILENAME"},{"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: PAML.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::PAML\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich, Aaron J Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::PAML - Parses output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00\n\n=head1 SYNOPSIS\n\n  #!/usr/bin/perl -Tw\n  use strict;\n\n  use Bio::Tools::Phylo::PAML;\n\n  # need to specify the output file name (or a fh) (defaults to\n  # -file => \"codeml.mlc\"); also, optionally, the directory in which\n  # the other result files (rst, 2ML.dS, etc) may be found (defaults\n  # to \"./\")\n  my $parser = Bio::Tools::Phylo::PAML->new\n    (-file => \"./results/mlc\", -dir => \"./results/\");\n\n  # get the first/next result; a Bio::Tools::Phylo::PAML::Result object,\n  # which isa Bio::SeqAnalysisResultI object.\n  my $result = $parser->next_result();\n\n  # get the sequences used in the analysis; returns Bio::PrimarySeq\n  # objects (OTU = Operational Taxonomic Unit).\n  my @otus = $result->get_seqs();\n\n  # codon summary: codon usage of each sequence [ arrayref of {\n  # hashref of counts for each codon } for each sequence and the\n  # overall sum ], and positional nucleotide distribution [ arrayref\n  # of { hashref of frequencies for each nucleotide } for each\n  # sequence and overall frequencies ]:\n  my ($codonusage, $ntdist) = $result->get_codon_summary();\n\n  # example manipulations of $codonusage and $ntdist:\n  printf \"There were %d %s codons in the first seq (%s)\\n\",\n    $codonusage->[0]->{AAA}, 'AAA', $otus[0]->id();\n  printf \"There were %d %s codons used in all the sequences\\n\",\n    $codonusage->[$#{$codonusage}]->{AAA}, 'AAA';\n  printf \"Nucleotide %c was present %g of the time in seq %s\\n\",\n    'A', $ntdist->[1]->{A}, $otus[1]->id();\n\n  # get Nei & Gojobori dN/dS matrix:\n  my $NGmatrix = $result->get_NGmatrix();\n\n  # get ML-estimated dN/dS matrix, if calculated; this corresponds to\n  # the runmode = -2, pairwise comparison usage of codeml\n  my $MLmatrix = $result->get_MLmatrix();\n\n  # These matrices are length(@otu) x length(@otu) \"strict lower\n  # triangle\" 2D-matrices, which means that the diagonal and\n  # everything above it is undefined.  Each of the defined cells is a\n  # hashref of estimates for \"dN\", \"dS\", \"omega\" (dN/dS ratio), \"t\",\n  # \"S\" and \"N\".  If a ML matrix, \"lnL\" and \"kappa\" will also be defined.\n  printf \"The omega ratio for sequences %s vs %s was: %g\\n\",\n    $otus[0]->id, $otus[1]->id, $MLmatrix->[0]->[1]->{omega};\n\n  # with a little work, these matrices could also be passed to\n  # Bio::Tools::Run::Phylip::Neighbor, or other similar tree-building\n  # method that accepts a matrix of \"distances\" (using the LOWTRI\n  # option):\n  my $distmat = [ map { [ map { $$_{omega} } @$_ ] } @$MLmatrix ];\n\n  # for runmode's other than -2, get tree topology with estimated\n  # branch lengths; returns a Bio::Tree::TreeI-based tree object with\n  # added PAML parameters at each node\n  my ($tree) = $result->get_trees();\n  for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n  }\n\n  # if you are using model based Codeml then trees are stored in each \n  # modelresult object\n  for my $modelresult ( $result->get_NSSite_results ) {\n    # model M0, M1, etc\n    print \"model is \", $modelresult->model_num, \"\\n\";\n    my ($tree) = $modelresult->get_trees();\n    for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n   }\n  }\n\n  # get any general model parameters: kappa (the\n  # transition/transversion ratio), NSsites model parameters (\"p0\",\n  # \"p1\", \"w0\", \"w1\", etc.), etc.\n  my $params = $result->get_model_params();\n  printf \"M1 params: p0 = %g\\tp1 = %g\\n\", $params->{p0}, $params->{p1};\n\n  # parse AAML result files\n  my $aamat = $result->get_AADistMatrix();\n  my $aaMLmat = $result->get_AAMLDistMatrix();\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00.  You can use the\nBio::Tools::Run::Phylo::PAML::* modules to actually run some of the\nPAML programs, but this module is only useful to parse the output.\n\n=head1 TO DO\n\nImplement get_posteriors(). For NSsites models, obtain arrayrefs of \nposterior probabilities for membership in each class for every \nposition; probabilities correspond to classes w0, w1, ... etc.\n\n  my @probs = $result->get_posteriors();\n\n  # find, say, positively selected sites!\n  if ($params->{w2} > 1) {\n    for (my $i = 0; $i < @probs ; $i++) {\n      if ($probs[$i]->[2] > 0.5) {\n         # assumes model M1: three w's, w0, w1 and w2 (positive selection)\n         printf \"position %d: (%g prob, %g omega, %g mean w)\\n\",\n           $i, $probs[$i]->[2], $params->{w2}, $probs[$i]->[3];\n      }\n    }\n  } else { print \"No positive selection found!\\n\"; }\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nAlbert Vilella avilella-AT-gmail-DOT-com\nSendu Bala     bix@sendu.me.uk\n\n=head1 TODO\n\nRST parsing -- done, Avilella contributions bugzilla#1506, added by jason 1.29\n            -- still need to parse in joint probability and non-syn changes \n               at site table\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::PAML;\nuse vars qw($RSTFILENAME);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::AnalysisParserI);\n\nBEGIN {\n  $RSTFILENAME = 'rst'; # where to get the RST data from\n}\n\n# other objects used:\nuse IO::String;\nuse File::Spec;\nuse Bio::TreeIO;\nuse Bio::Tools::Phylo::PAML::Result;\nuse Bio::LocatableSeq;\nuse Bio::PrimarySeq;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::Phylo::PAML::ModelResult;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::PAML->new(%args);\n Function: Builds a new Bio::Tools::Phylo::PAML object\n Returns : Bio::Tools::Phylo::PAML\n Args    : Hash of options: -file, -fh, -dir\n           -file (or -fh) should contain the contents of the PAML\n                 outfile; \n           -dir is the (optional) name of the directory in\n                which the PAML program was run (and includes other\n                PAML-generated files from which we can try to gather data)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":233,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":235,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":235},{"kind":13,"line":237,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"line":237,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","kind":13,"line":237},{"name":"$self","containerName":"new","line":238,"kind":13},{"line":238,"kind":12,"name":"_initialize_io","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":238},{"line":239,"kind":13,"localvar":"my","definition":"my","name":"$dir","containerName":"new"},{"line":239,"kind":13,"name":"$self","containerName":"new"},{"line":239,"kind":12,"containerName":"new","name":"_rearrange"},{"kind":13,"line":239,"name":"@args","containerName":"new"},{"kind":13,"line":240,"name":"$self","containerName":"new"},{"line":240,"kind":13,"name":"$dir","containerName":"new"},{"name":"$dir","containerName":"new","kind":13,"line":240},{"kind":13,"line":241,"name":"$self","containerName":"new"}],"kind":12,"range":{"start":{"character":0,"line":233},"end":{"character":9999,"line":242}},"name":"new"},{"kind":2,"line":235,"containerName":"IO::String::File::Spec::Bio::TreeIO::Bio::Tools::Phylo::PAML::Result::Bio::LocatableSeq::Bio::PrimarySeq::Bio::Matrix::PhylipDist::Bio::Tools::Phylo::PAML","name":"ModelResult"},{"name":"SUPER","containerName":"new","kind":12,"line":237},{"kind":12,"line":240,"name":"_dir"},{"kind":12,"children":[{"kind":13,"line":262,"containerName":"next_result","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","definition":"my","name":"%data","containerName":"next_result","line":263,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":266},{"name":"_parse_rst","containerName":"next_result","kind":12,"line":266},{"containerName":"next_result","name":"$idlookup","definition":"my","localvar":"my","kind":13,"line":267},{"line":269,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_parse_summary","kind":12,"line":270},{"kind":13,"line":270,"name":"$self","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":270},{"line":272,"kind":13,"localvar":"my","containerName":"next_result","name":"$seqtype","definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":272},{"kind":13,"line":273,"containerName":"next_result","name":"$seqtype"},{"line":273,"kind":13,"name":"$seqtype","containerName":"next_result"},{"line":274,"kind":13,"localvar":"my","definition":"my","name":"$has_model_line","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":275},{"containerName":"next_result","name":"_readline","kind":12,"line":275},{"kind":13,"line":276,"name":"$seqtype","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":279,"kind":13},{"name":"debug","containerName":"next_result","kind":12,"line":279},{"containerName":"next_result","name":"$self","kind":13,"line":280},{"containerName":"next_result","name":"_pushback","kind":12,"line":280},{"kind":13,"line":281,"containerName":"next_result","name":"%data"},{"line":281,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":281,"containerName":"next_result","name":"_parse_PairwiseCodon"},{"name":"$seqtype","containerName":"next_result","kind":13,"line":283},{"line":284,"kind":13,"name":"$self","containerName":"next_result"},{"line":284,"kind":12,"containerName":"next_result","name":"_pushback"},{"line":286,"kind":13,"name":"%data","containerName":"next_result"},{"line":286,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":286,"name":"_parse_aa_dists","containerName":"next_result"},{"containerName":"next_result","name":"$has_model_line","kind":13,"line":291},{"containerName":"next_result","name":"$seqtype","line":292,"kind":13},{"name":"$self","containerName":"next_result","line":293,"kind":13},{"line":293,"kind":12,"name":"_pushback","containerName":"next_result"},{"localvar":"my","definition":"my","name":"$model","containerName":"next_result","line":294,"kind":13},{"containerName":"next_result","name":"$self","line":294,"kind":13},{"name":"_parse_NSsitesBatch","containerName":"next_result","line":294,"kind":12},{"line":295,"kind":13,"name":"$data","containerName":"next_result"},{"name":"$model","containerName":"next_result","line":295,"kind":13},{"containerName":"next_result","name":"$has_model_line","line":296,"kind":13},{"line":298,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"%branch_dnds"},{"kind":13,"line":298,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"_parse_branch_dnds","line":298,"kind":12},{"name":"$data","containerName":"next_result","kind":13,"line":299},{"line":300,"kind":13,"name":"$self","containerName":"next_result"},{"line":300,"kind":12,"containerName":"next_result","name":"warn"},{"kind":13,"line":303,"containerName":"next_result","definition":"my","name":"$tree","localvar":"my"},{"kind":13,"line":303,"name":"$data","containerName":"next_result"},{"kind":13,"line":304,"containerName":"next_result","name":"$tree"},{"containerName":"next_result","name":"$tree","kind":13,"line":304},{"line":305,"kind":13,"containerName":"next_result","name":"$tree"},{"containerName":"next_result","name":"isa","line":305,"kind":12},{"line":306,"kind":13,"name":"$self","containerName":"next_result"},{"name":"warn","containerName":"next_result","line":306,"kind":12},{"definition":"my","name":"$k","containerName":"next_result","localvar":"my","kind":13,"line":310},{"name":"$v","containerName":"next_result","line":310,"kind":13},{"line":310,"kind":13,"name":"%branch_dnds","containerName":"next_result"},{"localvar":"my","name":"@nodes","definition":"my","containerName":"next_result","line":312,"kind":13},{"line":313,"kind":13,"localvar":"my","name":"$id","definition":"my","containerName":"next_result"},{"name":"$k","containerName":"next_result","kind":13,"line":313},{"kind":13,"line":314,"definition":"my","name":"@nodes_L","containerName":"next_result","localvar":"my"},{"line":314,"kind":13,"containerName":"next_result","name":"$tree"},{"name":"find_node","containerName":"next_result","line":314,"kind":12},{"containerName":"next_result","name":"$idlookup","kind":13,"line":314},{"containerName":"next_result","name":"$id","kind":13,"line":314},{"kind":13,"line":315,"containerName":"next_result","definition":"my","name":"$n","localvar":"my"},{"line":315,"kind":13,"containerName":"next_result","name":"@nodes_L"},{"containerName":"next_result","name":"@nodes_L","line":315,"kind":13},{"name":"$tree","containerName":"next_result","kind":13,"line":315},{"name":"get_lca","containerName":"next_result","kind":12,"line":315},{"containerName":"next_result","name":"@nodes_L","line":315,"kind":13},{"name":"$n","containerName":"next_result","kind":13,"line":316},{"containerName":"next_result","name":"$self","line":317,"kind":13},{"name":"warn","containerName":"next_result","kind":12,"line":317},{"line":319,"kind":13,"name":"$n","containerName":"next_result"},{"containerName":"next_result","name":"is_Leaf","kind":12,"line":319},{"name":"$n","containerName":"next_result","line":319,"kind":13},{"name":"id","containerName":"next_result","line":319,"kind":12},{"name":"$n","containerName":"next_result","line":320,"kind":13},{"containerName":"next_result","name":"id","line":320,"kind":12},{"containerName":"next_result","name":"$id","line":320,"kind":13},{"line":322,"kind":13,"name":"@nodes","containerName":"next_result"},{"kind":13,"line":322,"name":"$n","containerName":"next_result"},{"localvar":"my","name":"$parent","definition":"my","containerName":"next_result","line":324,"kind":13},{"name":"$child","containerName":"next_result","line":324,"kind":13},{"kind":13,"line":324,"containerName":"next_result","name":"@nodes"},{"line":325,"kind":13,"localvar":"my","containerName":"next_result","name":"$kk","definition":"my"},{"name":"$vv","containerName":"next_result","line":325,"kind":13},{"kind":13,"line":325,"name":"$v","containerName":"next_result"},{"kind":13,"line":326,"containerName":"next_result","name":"$child"},{"line":326,"kind":12,"name":"add_tag_value","containerName":"next_result"},{"line":326,"kind":13,"containerName":"next_result","name":"$kk"},{"containerName":"next_result","name":"$vv","kind":13,"line":326}],"line":260,"definition":"sub","containerName":"main::","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: PAML.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::PAML\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich, Aaron J Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::PAML - Parses output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00\n\n=head1 SYNOPSIS\n\n  #!/usr/bin/perl -Tw\n  use strict;\n\n  use Bio::Tools::Phylo::PAML;\n\n  # need to specify the output file name (or a fh) (defaults to\n  # -file => \"codeml.mlc\"); also, optionally, the directory in which\n  # the other result files (rst, 2ML.dS, etc) may be found (defaults\n  # to \"./\")\n  my $parser = Bio::Tools::Phylo::PAML->new\n    (-file => \"./results/mlc\", -dir => \"./results/\");\n\n  # get the first/next result; a Bio::Tools::Phylo::PAML::Result object,\n  # which isa Bio::SeqAnalysisResultI object.\n  my $result = $parser->next_result();\n\n  # get the sequences used in the analysis; returns Bio::PrimarySeq\n  # objects (OTU = Operational Taxonomic Unit).\n  my @otus = $result->get_seqs();\n\n  # codon summary: codon usage of each sequence [ arrayref of {\n  # hashref of counts for each codon } for each sequence and the\n  # overall sum ], and positional nucleotide distribution [ arrayref\n  # of { hashref of frequencies for each nucleotide } for each\n  # sequence and overall frequencies ]:\n  my ($codonusage, $ntdist) = $result->get_codon_summary();\n\n  # example manipulations of $codonusage and $ntdist:\n  printf \"There were %d %s codons in the first seq (%s)\\n\",\n    $codonusage->[0]->{AAA}, 'AAA', $otus[0]->id();\n  printf \"There were %d %s codons used in all the sequences\\n\",\n    $codonusage->[$#{$codonusage}]->{AAA}, 'AAA';\n  printf \"Nucleotide %c was present %g of the time in seq %s\\n\",\n    'A', $ntdist->[1]->{A}, $otus[1]->id();\n\n  # get Nei & Gojobori dN/dS matrix:\n  my $NGmatrix = $result->get_NGmatrix();\n\n  # get ML-estimated dN/dS matrix, if calculated; this corresponds to\n  # the runmode = -2, pairwise comparison usage of codeml\n  my $MLmatrix = $result->get_MLmatrix();\n\n  # These matrices are length(@otu) x length(@otu) \"strict lower\n  # triangle\" 2D-matrices, which means that the diagonal and\n  # everything above it is undefined.  Each of the defined cells is a\n  # hashref of estimates for \"dN\", \"dS\", \"omega\" (dN/dS ratio), \"t\",\n  # \"S\" and \"N\".  If a ML matrix, \"lnL\" and \"kappa\" will also be defined.\n  printf \"The omega ratio for sequences %s vs %s was: %g\\n\",\n    $otus[0]->id, $otus[1]->id, $MLmatrix->[0]->[1]->{omega};\n\n  # with a little work, these matrices could also be passed to\n  # Bio::Tools::Run::Phylip::Neighbor, or other similar tree-building\n  # method that accepts a matrix of \"distances\" (using the LOWTRI\n  # option):\n  my $distmat = [ map { [ map { $$_{omega} } @$_ ] } @$MLmatrix ];\n\n  # for runmode's other than -2, get tree topology with estimated\n  # branch lengths; returns a Bio::Tree::TreeI-based tree object with\n  # added PAML parameters at each node\n  my ($tree) = $result->get_trees();\n  for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n  }\n\n  # if you are using model based Codeml then trees are stored in each \n  # modelresult object\n  for my $modelresult ( $result->get_NSSite_results ) {\n    # model M0, M1, etc\n    print \"model is \", $modelresult->model_num, \"\\n\";\n    my ($tree) = $modelresult->get_trees();\n    for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n   }\n  }\n\n  # get any general model parameters: kappa (the\n  # transition/transversion ratio), NSsites model parameters (\"p0\",\n  # \"p1\", \"w0\", \"w1\", etc.), etc.\n  my $params = $result->get_model_params();\n  printf \"M1 params: p0 = %g\\tp1 = %g\\n\", $params->{p0}, $params->{p1};\n\n  # parse AAML result files\n  my $aamat = $result->get_AADistMatrix();\n  my $aaMLmat = $result->get_AAMLDistMatrix();\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00.  You can use the\nBio::Tools::Run::Phylo::PAML::* modules to actually run some of the\nPAML programs, but this module is only useful to parse the output.\n\n=head1 TO DO\n\nImplement get_posteriors(). For NSsites models, obtain arrayrefs of \nposterior probabilities for membership in each class for every \nposition; probabilities correspond to classes w0, w1, ... etc.\n\n  my @probs = $result->get_posteriors();\n\n  # find, say, positively selected sites!\n  if ($params->{w2} > 1) {\n    for (my $i = 0; $i < @probs ; $i++) {\n      if ($probs[$i]->[2] > 0.5) {\n         # assumes model M1: three w's, w0, w1 and w2 (positive selection)\n         printf \"position %d: (%g prob, %g omega, %g mean w)\\n\",\n           $i, $probs[$i]->[2], $params->{w2}, $probs[$i]->[3];\n      }\n    }\n  } else { print \"No positive selection found!\\n\"; }\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nAlbert Vilella avilella-AT-gmail-DOT-com\nSendu Bala     bix@sendu.me.uk\n\n=head1 TODO\n\nRST parsing -- done, Avilella contributions bugzilla#1506, added by jason 1.29\n            -- still need to parse in joint probability and non-syn changes \n               at site table\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::PAML;\nuse vars qw($RSTFILENAME);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::AnalysisParserI);\n\nBEGIN {\n  $RSTFILENAME = 'rst'; # where to get the RST data from\n}\n\n# other objects used:\nuse IO::String;\nuse File::Spec;\nuse Bio::TreeIO;\nuse Bio::Tools::Phylo::PAML::Result;\nuse Bio::LocatableSeq;\nuse Bio::PrimarySeq;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::Phylo::PAML::ModelResult;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::PAML->new(%args);\n Function: Builds a new Bio::Tools::Phylo::PAML object\n Returns : Bio::Tools::Phylo::PAML\n Args    : Hash of options: -file, -fh, -dir\n           -file (or -fh) should contain the contents of the PAML\n                 outfile; \n           -dir is the (optional) name of the directory in\n                which the PAML program was run (and includes other\n                PAML-generated files from which we can try to gather data)\n\n\nsub new {\n\n  my ($class, @args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  my ($dir) = $self->_rearrange([qw(DIR)], @args);\n  $self->{_dir} = $dir if defined $dir;\n  return $self;\n}\n\n=head2 Implement Bio::AnalysisParserI interface\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = $obj->next_result();\n Function: Returns the next result available from the input, or\n           undef if there are no more results.\n Example :\n Returns : a Bio::Tools::Phylo::PAML::Result object\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","name":"next_result","range":{"start":{"line":260,"character":0},"end":{"line":329,"character":9999}}},{"containerName":null,"name":"$self","line":331,"kind":13},{"kind":12,"line":331,"containerName":"main::","name":"_pushback"},{"containerName":null,"name":"%data","line":332,"kind":13},{"name":"$idlookup","containerName":null,"line":332,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":332},{"kind":12,"line":332,"containerName":"main::","name":"_parse_Forestry"},{"containerName":null,"name":"$self","line":336,"kind":13},{"line":336,"kind":12,"name":"throw","containerName":"main::"},{"line":347,"kind":13,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","line":347,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":358},{"containerName":"main::","name":"throw","line":358,"kind":12},{"containerName":null,"name":"$self","line":362,"kind":13},{"name":"_pushback","containerName":"main::","line":362,"kind":12},{"line":363,"kind":13,"name":"%data","containerName":null},{"containerName":null,"name":"$self","line":363,"kind":13},{"name":"_parse_StarDecomposition","containerName":"main::","kind":12,"line":363},{"name":"%seqtype","containerName":null,"line":367,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":368},{"line":368,"kind":12,"name":"_readline","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":370},{"name":"_pushback","containerName":"main::","line":370,"kind":12},{"localvar":"my","name":"$kappa","definition":"my","containerName":null,"line":371,"kind":13},{"line":371,"kind":13,"containerName":null,"name":"$alpha"},{"kind":13,"line":371,"containerName":null,"name":"$self"},{"name":"_parse_nt_dists","containerName":"main::","line":371,"kind":12},{"containerName":null,"name":"%data","line":372,"kind":13},{"name":"$kappa","containerName":null,"kind":13,"line":372},{"name":"%alpha","containerName":null,"line":374,"kind":13},{"kind":13,"line":376,"name":"$self","containerName":null},{"kind":12,"line":376,"name":"_pushback","containerName":"main::"},{"name":"%data","containerName":null,"kind":13,"line":377},{"kind":13,"line":377,"name":"$idlookup","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":377},{"containerName":"main::","name":"_parse_Forestry","line":377,"kind":12},{"containerName":null,"name":"%seqtype","line":380,"kind":13},{"containerName":null,"name":"$self","line":381,"kind":13},{"containerName":"main::","name":"_readline","kind":12,"line":381},{"line":383,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_pushback","line":383,"kind":12},{"line":384,"kind":13,"containerName":null,"name":"%data"},{"containerName":null,"name":"$self","line":384,"kind":13},{"name":"_parse_YN_Pairwise","containerName":"main::","line":384,"kind":12},{"line":389,"kind":13,"containerName":null,"name":"%data"},{"line":390,"kind":13,"containerName":null,"name":"%data"},{"containerName":null,"name":"%self","line":390,"kind":13},{"name":"%data","containerName":null,"kind":13,"line":391},{"containerName":null,"name":"%self","line":391,"kind":13},{"kind":13,"line":392,"containerName":null,"name":"%data"},{"kind":13,"line":392,"name":"%self","containerName":null},{"containerName":null,"name":"%data","line":393,"kind":13},{"kind":13,"line":393,"containerName":null,"name":"%self"},{"kind":13,"line":394,"containerName":null,"name":"%data"},{"containerName":null,"name":"%self","kind":13,"line":394},{"name":"%data","containerName":null,"kind":13,"line":395},{"name":"%self","containerName":null,"kind":13,"line":395},{"kind":13,"line":396,"containerName":null,"name":"%data"},{"kind":13,"line":396,"containerName":null,"name":"%self"},{"containerName":null,"name":"%data","kind":13,"line":397},{"containerName":null,"name":"%self","line":397,"kind":13},{"containerName":null,"name":"%data","line":398,"kind":13},{"containerName":null,"name":"%self","line":398,"kind":13},{"name":"%data","containerName":null,"kind":13,"line":399},{"line":399,"kind":13,"name":"%self","containerName":null},{"name":"%data","containerName":null,"kind":13,"line":400},{"kind":13,"line":400,"name":"%self","containerName":null},{"kind":13,"line":401,"name":"%data","containerName":null},{"kind":13,"line":401,"name":"%self","containerName":null},{"kind":13,"line":402,"containerName":null,"name":"%data"},{"name":"%self","containerName":null,"kind":13,"line":402},{"name":"%data","containerName":null,"kind":13,"line":403},{"name":"%self","containerName":null,"line":403,"kind":13},{"name":"%data","containerName":null,"line":404,"kind":13},{"line":404,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"%data","kind":13,"line":405},{"line":405,"kind":13,"name":"%self","containerName":null},{"line":406,"kind":12,"containerName":"Tools::Phylo::PAML::Result","name":"Bio"},{"line":406,"kind":12,"containerName":"main::","name":"new"},{"kind":13,"line":406,"containerName":null,"name":"%data"},{"name":"_parse_summary","range":{"end":{"character":9999,"line":458},"start":{"character":0,"line":413}},"kind":12,"line":413,"children":[{"line":414,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_summary"},{"name":"$SEQTYPES","definition":"my","containerName":"_parse_summary","localvar":"my","kind":13,"line":428},{"kind":13,"line":429,"containerName":"_parse_summary","definition":"my","name":"$line","localvar":"my"},{"containerName":"_parse_summary","name":"$self","kind":13,"line":430},{"name":"$self","containerName":"_parse_summary","kind":13,"line":430},{"definition":"my","name":"@lines","containerName":"_parse_summary","localvar":"my","kind":13,"line":431},{"name":"$self","containerName":"_parse_summary","kind":13,"line":432},{"kind":12,"line":432,"containerName":"_parse_summary","name":"_readline"},{"kind":13,"line":433,"name":"@lines","containerName":"_parse_summary"},{"name":"$self","containerName":"_parse_summary","kind":13,"line":441},{"name":"$self","containerName":"_parse_summary","line":443,"kind":13},{"name":"$self","containerName":"_parse_summary","line":444,"kind":13},{"kind":13,"line":445,"name":"$self","containerName":"_parse_summary"},{"kind":12,"line":445,"containerName":"_parse_summary","name":"_pushback"},{"kind":13,"line":445,"containerName":"_parse_summary","name":"$self"},{"name":"$self","containerName":"_parse_summary","line":448,"kind":13},{"name":"$self","containerName":"_parse_summary","kind":13,"line":449},{"kind":13,"line":451,"definition":"my","name":"$phylip_header","containerName":"_parse_summary","localvar":"my"},{"line":451,"kind":13,"containerName":"_parse_summary","name":"$self"},{"name":"_readline","containerName":"_parse_summary","kind":12,"line":451},{"containerName":"_parse_summary","name":"$self","line":452,"kind":13},{"line":452,"kind":12,"name":"_parse_seqs","containerName":"_parse_summary"},{"name":"@lines","containerName":"_parse_summary","kind":13,"line":453},{"kind":13,"line":453,"containerName":"_parse_summary","name":"$self"},{"line":454,"kind":13,"containerName":"_parse_summary","name":"$self"},{"kind":12,"line":454,"containerName":"_parse_summary","name":"_parse_seqs"},{"kind":13,"line":456,"containerName":"_parse_summary","name":"$self"},{"kind":12,"line":456,"containerName":"_parse_summary","name":"_parse_patterns"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_parse_summary($self)","parameters":[{"label":"$self"}],"documentation":""}},{"containerName":null,"name":"%self","kind":13,"line":460},{"kind":13,"line":461,"name":"$self","containerName":null},{"name":"throw","containerName":"main::","line":461,"kind":12},{"kind":13,"line":464,"name":"$seqtype","definition":"my","containerName":null,"localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":464},{"line":465,"kind":13,"name":"%seqtype","containerName":null},{"line":466,"kind":13,"containerName":null,"name":"$self"},{"line":466,"kind":12,"name":"_parse_inputparams","containerName":"main::"},{"line":468,"kind":13,"name":"$self","containerName":null},{"line":468,"kind":12,"containerName":"main::","name":"_parse_patterns"},{"line":469,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_parse_seqs","kind":12,"line":469},{"containerName":null,"name":"$self","kind":13,"line":470},{"kind":12,"line":470,"containerName":"main::","name":"_parse_codoncts"},{"name":"$self","containerName":null,"kind":13,"line":472},{"line":472,"kind":12,"containerName":"main::","name":"_parse_codon_freqs"},{"name":"$self","containerName":null,"line":473,"kind":13},{"containerName":"main::","name":"_parse_distmat","line":473,"kind":12},{"name":"%seqtype","containerName":null,"line":474,"kind":13},{"line":475,"kind":13,"containerName":null,"name":"$self"},{"name":"_parse_inputparams","containerName":"main::","kind":12,"line":475},{"name":"$self","containerName":null,"line":476,"kind":13},{"line":476,"kind":12,"name":"_parse_patterns","containerName":"main::"},{"line":477,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_parse_seqs","kind":12,"line":477},{"line":478,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":478,"name":"_parse_aa_freqs","containerName":"main::"},{"name":"%self","containerName":null,"kind":13,"line":480},{"containerName":null,"name":"$self","line":480,"kind":13},{"line":480,"kind":12,"name":"_parse_aa_dists","containerName":"main::"},{"kind":13,"line":482,"containerName":null,"name":"%seqtype"},{"name":"$self","containerName":null,"kind":13,"line":483},{"kind":12,"line":483,"containerName":"main::","name":"throw"},{"containerName":null,"name":"%seqtype","kind":13,"line":485},{"kind":13,"line":486,"name":"$self","containerName":null},{"line":486,"kind":12,"name":"_parse_patterns","containerName":"main::"},{"name":"$self","containerName":null,"line":487,"kind":13},{"containerName":"main::","name":"_parse_seqs","line":487,"kind":12},{"name":"$self","containerName":null,"line":488,"kind":13},{"line":488,"kind":12,"name":"_parse_nt_freqs","containerName":"main::"},{"kind":13,"line":490,"name":"%seqtype","containerName":null},{"containerName":null,"name":"$self","line":491,"kind":13},{"name":"_parse_codon_freqs","containerName":"main::","line":491,"kind":12},{"kind":13,"line":492,"name":"$self","containerName":null},{"line":492,"kind":12,"containerName":"main::","name":"_parse_codoncts"},{"name":"$self","containerName":null,"kind":13,"line":493},{"line":493,"kind":12,"containerName":"main::","name":"_parse_distmat"},{"containerName":null,"name":"$self","line":495,"kind":13},{"line":495,"kind":12,"containerName":"main::","name":"throw"},{"kind":13,"line":498,"name":"$seqtype","containerName":null},{"kind":12,"children":[{"localvar":"my","containerName":"_parse_inputparams","definition":"my","name":"$self","line":504,"kind":13},{"name":"$self","containerName":"_parse_inputparams","kind":13,"line":505},{"line":505,"kind":12,"containerName":"_parse_inputparams","name":"_readline"},{"localvar":"my","containerName":"_parse_inputparams","name":"$param","definition":"my","line":507,"kind":13},{"line":507,"kind":13,"containerName":"_parse_inputparams","name":"$val"},{"containerName":"_parse_inputparams","name":"$self","line":508,"kind":13},{"containerName":"_parse_inputparams","name":"$param","kind":13,"line":508},{"line":508,"kind":13,"name":"$val","containerName":"_parse_inputparams"},{"kind":13,"line":512,"name":"$self","containerName":"_parse_inputparams"},{"line":512,"kind":12,"containerName":"_parse_inputparams","name":"_pushback"}],"line":503,"definition":"sub","containerName":"main::","signature":{"label":"_parse_inputparams($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)","name":"_parse_inputparams","range":{"end":{"line":516,"character":9999},"start":{"character":0,"line":503}}},{"range":{"start":{"character":0,"line":518},"end":{"line":552,"character":9999}},"name":"_parse_codon_freqs","detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse_codon_freqs($self)"},"containerName":"main::","definition":"sub","line":518,"children":[{"localvar":"my","containerName":"_parse_codon_freqs","definition":"my","name":"$self","line":519,"kind":13},{"containerName":"_parse_codon_freqs","name":"$okay","definition":"my","localvar":"my","kind":13,"line":520},{"containerName":"_parse_codon_freqs","name":"$done","kind":13,"line":520},{"name":"$self","containerName":"_parse_codon_freqs","line":522,"kind":13},{"containerName":"_parse_codon_freqs","name":"_readline","kind":12,"line":522},{"kind":13,"line":523,"containerName":"_parse_codon_freqs","name":"$self"},{"name":"_pushback","containerName":"_parse_codon_freqs","line":523,"kind":12},{"kind":13,"line":524,"containerName":"_parse_codon_freqs","name":"$done"},{"line":526,"kind":13,"containerName":"_parse_codon_freqs","name":"$okay"},{"containerName":"_parse_codon_freqs","name":"$okay","line":527,"kind":13},{"localvar":"my","containerName":"_parse_codon_freqs","definition":"my","name":"$pos","line":529,"kind":13},{"line":531,"kind":13,"localvar":"my","containerName":"_parse_codon_freqs","definition":"my","name":"@bases"},{"containerName":"_parse_codon_freqs","name":"$str","definition":"my","localvar":"my","kind":13,"line":532},{"kind":13,"line":532,"containerName":"_parse_codon_freqs","name":"@bases"},{"containerName":"_parse_codon_freqs","name":"$base","definition":"my","localvar":"my","kind":13,"line":533},{"line":533,"kind":13,"containerName":"_parse_codon_freqs","name":"$freq"},{"containerName":"_parse_codon_freqs","name":"$str","kind":13,"line":533},{"kind":13,"line":534,"containerName":"_parse_codon_freqs","name":"$self"},{"name":"$pos","containerName":"_parse_codon_freqs","kind":13,"line":534},{"kind":13,"line":534,"name":"$base","containerName":"_parse_codon_freqs"},{"containerName":"_parse_codon_freqs","name":"$freq","kind":13,"line":534},{"name":"$done","containerName":"_parse_codon_freqs","line":536,"kind":13},{"name":"$pos","containerName":"_parse_codon_freqs","line":536,"kind":13},{"kind":13,"line":539,"name":"$done","containerName":"_parse_codon_freqs"},{"name":"$self","containerName":"_parse_codon_freqs","line":540,"kind":13},{"line":540,"kind":12,"name":"_readline","containerName":"_parse_codon_freqs"},{"line":541,"kind":13,"name":"$self","containerName":"_parse_codon_freqs"},{"line":541,"kind":12,"name":"_pushback","containerName":"_parse_codon_freqs"},{"line":542,"kind":13,"name":"$done","containerName":"_parse_codon_freqs"},{"kind":13,"line":544,"name":"$self","containerName":"_parse_codon_freqs"},{"line":544,"kind":12,"name":"_readline","containerName":"_parse_codon_freqs"},{"name":"$self","containerName":"_parse_codon_freqs","line":548,"kind":13},{"line":550,"kind":13,"containerName":"_parse_codon_freqs","name":"$done"}],"kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_aa_freqs($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_parse_aa_freqs","localvar":"my","kind":13,"line":556},{"containerName":"_parse_aa_freqs","definition":"my","name":"$okay","localvar":"my","kind":13,"line":557},{"containerName":"_parse_aa_freqs","name":"$done","line":557,"kind":13},{"line":557,"kind":13,"containerName":"_parse_aa_freqs","name":"$header"},{"kind":13,"line":558,"definition":"my","name":"@bases","containerName":"_parse_aa_freqs","localvar":"my"},{"kind":13,"line":559,"definition":"my","name":"$numseqs","containerName":"_parse_aa_freqs","localvar":"my"},{"name":"$self","containerName":"_parse_aa_freqs","line":559,"kind":13}],"line":555,"kind":12,"range":{"end":{"character":9999,"line":559},"start":{"line":555,"character":0}},"name":"_parse_aa_freqs"},{"line":560,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_readline","kind":12,"line":560},{"kind":13,"line":562,"containerName":null,"name":"$self"},{"line":562,"kind":12,"containerName":"main::","name":"_pushback"},{"containerName":null,"name":"%done","line":564,"kind":13},{"containerName":null,"name":"$okay","kind":13,"line":567},{"line":568,"kind":13,"name":"%okay","containerName":null},{"name":"%header","containerName":null,"kind":13,"line":570},{"kind":13,"line":572,"name":"@bases","containerName":null},{"name":"$header","containerName":null,"line":573,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":574},{"name":"%self","containerName":null,"kind":13,"line":579},{"line":580,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":582,"name":"%self","containerName":null},{"containerName":null,"name":"%done","kind":13,"line":583},{"kind":13,"line":585,"name":"$seqname","definition":"my","containerName":null,"localvar":"my"},{"name":"@freqs","containerName":null,"kind":13,"line":585},{"kind":13,"line":586,"definition":"my","name":"$basect","containerName":null,"localvar":"my"},{"definition":"my","name":"$f","containerName":null,"localvar":"my","kind":13,"line":587},{"line":587,"kind":13,"containerName":null,"name":"@freqs"},{"line":589,"kind":13,"containerName":null,"name":"%self"},{"line":589,"kind":13,"name":"%seqname","containerName":null},{"line":589,"kind":13,"containerName":null,"name":"@bases"},{"name":"$basect","containerName":null,"kind":13,"line":589},{"name":"$f","containerName":null,"line":589,"kind":13},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_parse_StarDecomposition($self)","parameters":[{"label":"$self"}],"documentation":" This is for parsing the automatic tree output"},"kind":12,"line":598,"children":[{"name":"$self","definition":"my","containerName":"_parse_StarDecomposition","localvar":"my","kind":13,"line":599},{"line":600,"kind":13,"localvar":"my","definition":"my","name":"%data","containerName":"_parse_StarDecomposition"},{"containerName":"_parse_StarDecomposition","name":"%data","kind":13,"line":602}],"name":"_parse_StarDecomposition","range":{"end":{"character":9999,"line":603},"start":{"line":598,"character":0}}},{"signature":{"label":"_parse_aa_dists($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"_parse_aa_dists","name":"$self","definition":"my","localvar":"my","kind":13,"line":606},{"line":607,"kind":13,"localvar":"my","name":"$okay","definition":"my","containerName":"_parse_aa_dists"},{"kind":13,"line":607,"name":"$seen","containerName":"_parse_aa_dists"},{"name":"$done","containerName":"_parse_aa_dists","line":607,"kind":13},{"kind":13,"line":608,"name":"%matrix","definition":"my","containerName":"_parse_aa_dists","localvar":"my"},{"kind":13,"line":608,"containerName":"_parse_aa_dists","name":"@names"},{"line":608,"kind":13,"name":"@values","containerName":"_parse_aa_dists"},{"kind":13,"line":609,"containerName":"_parse_aa_dists","definition":"my","name":"$numseqs","localvar":"my"},{"name":"$self","containerName":"_parse_aa_dists","kind":13,"line":609}],"line":605,"kind":12,"range":{"start":{"line":605,"character":0},"end":{"character":9999,"line":609}},"name":"_parse_aa_dists"},{"localvar":"my","containerName":null,"definition":"my","name":"$type","line":610,"kind":13},{"containerName":null,"name":"$self","line":611,"kind":13},{"name":"_readline","containerName":"main::","line":611,"kind":12},{"name":"%done","containerName":null,"line":612,"kind":13},{"line":613,"kind":13,"containerName":null,"name":"$self"},{"line":613,"kind":12,"name":"_pushback","containerName":"main::"},{"containerName":null,"name":"%seen","line":615,"kind":13},{"kind":13,"line":619,"containerName":null,"name":"$okay"},{"line":620,"kind":13,"name":"$type","containerName":null},{"line":624,"kind":13,"containerName":null,"name":"%okay"},{"definition":"my","name":"$seqname","containerName":null,"localvar":"my","kind":13,"line":625},{"line":625,"kind":13,"containerName":null,"name":"@vl"},{"kind":13,"line":626,"name":"$seen","containerName":null},{"localvar":"my","definition":"my","name":"$i","containerName":null,"line":627,"kind":13},{"containerName":null,"name":"$type","kind":13,"line":629},{"kind":13,"line":630,"containerName":null,"name":"@names"},{"containerName":null,"name":"@vl","line":631,"kind":13},{"name":"@names","containerName":null,"kind":13,"line":632},{"name":"%self","containerName":null,"kind":13,"line":632},{"name":"display_id","containerName":"main::","line":632,"kind":12},{"line":634,"kind":13,"localvar":"my","name":"$s","definition":"my","containerName":null},{"kind":13,"line":634,"containerName":null,"name":"@names"},{"line":635,"kind":13,"name":"@vl","containerName":null},{"kind":13,"line":636,"containerName":null,"name":"%matrix"},{"kind":13,"line":636,"name":"%seqname","containerName":null},{"name":"$s","containerName":null,"line":636,"kind":13},{"name":"%matrix","containerName":null,"line":637,"kind":13},{"line":637,"kind":13,"name":"%s","containerName":null},{"containerName":null,"name":"$seqname","kind":13,"line":637},{"containerName":null,"name":"@vl","line":637,"kind":13},{"line":639,"kind":13,"name":"@names","containerName":null},{"name":"$seqname","containerName":null,"kind":13,"line":639},{"name":"%matrix","containerName":null,"line":641,"kind":13},{"containerName":null,"name":"%seqname","line":641,"kind":13},{"containerName":null,"name":"$seqname","kind":13,"line":641},{"name":"$done","containerName":null,"line":643,"kind":13},{"line":643,"kind":13,"containerName":null,"name":"@names"},{"kind":13,"line":643,"name":"$numseqs","containerName":null},{"containerName":null,"definition":"my","name":"%dist","localvar":"my","kind":13,"line":645},{"kind":13,"line":646,"definition":"my","name":"$i","containerName":null,"localvar":"my"},{"line":647,"kind":13,"name":"@values","containerName":null},{"line":648,"kind":13,"localvar":"my","definition":"my","name":"$lname","containerName":null},{"name":"@names","containerName":null,"kind":13,"line":648},{"line":649,"kind":13,"localvar":"my","containerName":null,"name":"@row","definition":"my"},{"kind":13,"line":650,"definition":"my","name":"$j","containerName":null,"localvar":"my"},{"kind":13,"line":651,"name":"$rname","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":651,"name":"@names","containerName":null},{"kind":13,"line":652,"name":"$v","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%matrix","kind":13,"line":652},{"name":"%lname","containerName":null,"line":652,"kind":13},{"containerName":null,"name":"$rname","kind":13,"line":652},{"kind":13,"line":653,"name":"$v","containerName":null},{"containerName":null,"name":"%matrix","line":653,"kind":13},{"line":653,"kind":13,"name":"%rname","containerName":null},{"containerName":null,"name":"$lname","kind":13,"line":653},{"kind":13,"line":653,"containerName":null,"name":"$v"},{"name":"@row","containerName":null,"kind":13,"line":654},{"kind":13,"line":654,"name":"$v","containerName":null},{"name":"%dist","containerName":null,"kind":13,"line":655},{"containerName":null,"name":"%lname","line":655,"kind":13},{"name":"@rname","containerName":null,"line":655,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":655},{"name":"$j","containerName":null,"line":655,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":657},{"containerName":null,"name":"@values","kind":13,"line":658},{"containerName":null,"name":"@row","kind":13,"line":658},{"kind":12,"line":661,"containerName":"Matrix::PhylipDist","name":"Bio"},{"containerName":null,"name":"%self","line":661,"kind":13},{"containerName":null,"name":"%dist","kind":13,"line":662},{"containerName":null,"name":"@names","line":663,"kind":13},{"name":"@values","containerName":null,"line":664,"kind":13},{"kind":12,"line":667,"children":[{"kind":13,"line":668,"containerName":"_parse_patterns","name":"$self","definition":"my","localvar":"my"},{"containerName":"_parse_patterns","name":"$patternct","definition":"my","localvar":"my","kind":13,"line":669},{"kind":13,"line":669,"name":"@patterns","containerName":"_parse_patterns"},{"name":"$ns","containerName":"_parse_patterns","kind":13,"line":669},{"containerName":"_parse_patterns","name":"$ls","kind":13,"line":669},{"containerName":"_parse_patterns","name":"$self","line":670,"kind":13},{"name":"$self","containerName":"_parse_patterns","kind":13,"line":671},{"kind":12,"line":671,"name":"_readline","containerName":"_parse_patterns"},{"line":673,"kind":13,"containerName":"_parse_patterns","name":"$self"},{"name":"_pushback","containerName":"_parse_patterns","line":673,"kind":12},{"name":"$patternct","containerName":"_parse_patterns","kind":13,"line":675},{"containerName":"_parse_patterns","name":"@patterns","line":679,"kind":13},{"containerName":"_parse_patterns","name":"$ns","line":681,"kind":13},{"kind":13,"line":681,"name":"$ls","containerName":"_parse_patterns"},{"name":"$patternct","containerName":"_parse_patterns","line":683,"kind":13},{"name":"$self","containerName":"_parse_patterns","kind":13,"line":688},{"name":"@patterns","containerName":"_parse_patterns","kind":13,"line":688},{"containerName":"_parse_patterns","name":"$ns","kind":13,"line":689},{"containerName":"_parse_patterns","name":"$ls","kind":13,"line":690}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_patterns($self)"},"name":"_parse_patterns","range":{"end":{"character":9999,"line":691},"start":{"line":667,"character":0}}},{"kind":12,"line":693,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_parse_seqs","line":696,"kind":13},{"kind":13,"line":700,"containerName":"_parse_seqs","name":"$self"},{"containerName":"_parse_seqs","definition":"my","name":"@firstseq","localvar":"my","kind":13,"line":701},{"line":701,"kind":13,"containerName":"_parse_seqs","name":"@seqs"},{"containerName":"_parse_seqs","name":"$self","line":702,"kind":13},{"kind":12,"line":702,"containerName":"_parse_seqs","name":"_readline"},{"line":704,"kind":13,"containerName":"_parse_seqs","name":"$self"},{"kind":12,"line":704,"name":"_pushback","containerName":"_parse_seqs"},{"name":"@seqs","containerName":"_parse_seqs","kind":13,"line":706},{"kind":13,"line":711,"containerName":"_parse_seqs","name":"$name","definition":"my","localvar":"my"},{"containerName":"_parse_seqs","name":"$seqstr","line":711,"kind":13},{"line":712,"kind":13,"name":"$seqstr","containerName":"_parse_seqs"},{"containerName":"_parse_seqs","name":"@firstseq","kind":13,"line":713},{"containerName":"_parse_seqs","name":"@firstseq","kind":13,"line":714},{"kind":13,"line":714,"name":"$seqstr","containerName":"_parse_seqs"},{"line":715,"kind":13,"containerName":"_parse_seqs","name":"@seqs"},{"line":715,"kind":12,"name":"new","containerName":"_parse_seqs"},{"line":715,"kind":13,"containerName":"_parse_seqs","name":"$name"},{"kind":13,"line":716,"name":"$seqstr","containerName":"_parse_seqs"},{"localvar":"my","name":"$i","definition":"my","containerName":"_parse_seqs","line":719,"kind":13},{"kind":13,"line":720,"name":"$v","definition":"my","containerName":"_parse_seqs","localvar":"my"},{"line":721,"kind":13,"containerName":"_parse_seqs","name":"$v"},{"line":721,"kind":13,"containerName":"_parse_seqs","name":"$seqstr"},{"kind":13,"line":721,"name":"$i","containerName":"_parse_seqs"},{"containerName":"_parse_seqs","name":"$i","line":721,"kind":13},{"name":"$seqstr","containerName":"_parse_seqs","kind":13,"line":723},{"containerName":"_parse_seqs","name":"$v","kind":13,"line":723},{"line":723,"kind":13,"containerName":"_parse_seqs","name":"$firstseq"},{"containerName":"_parse_seqs","name":"$v","kind":13,"line":723},{"line":724,"kind":13,"name":"$i","containerName":"_parse_seqs"},{"containerName":"_parse_seqs","name":"$v","line":724,"kind":13},{"containerName":"_parse_seqs","name":"@seqs","kind":13,"line":726},{"kind":12,"line":726,"name":"new","containerName":"_parse_seqs"},{"line":726,"kind":13,"name":"$name","containerName":"_parse_seqs"},{"kind":13,"line":727,"name":"$seqstr","containerName":"_parse_seqs"},{"containerName":"_parse_seqs","name":"@seqs","line":730,"kind":13},{"name":"$self","containerName":"_parse_seqs","line":731,"kind":13},{"kind":13,"line":731,"containerName":"_parse_seqs","name":"@seqs"},{"kind":13,"line":732,"name":"$self","containerName":"_parse_seqs"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse_seqs($self)"},"name":"_parse_seqs","range":{"end":{"line":735,"character":9999},"start":{"character":0,"line":693}}},{"line":715,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"containerName":"LocatableSeq","name":"Bio","line":726,"kind":12},{"range":{"start":{"line":737,"character":0},"end":{"line":737,"character":9999}},"containerName":"main::","definition":"sub","name":"_parse_codoncts","line":737,"children":[],"kind":12},{"detail":"($self)","signature":{"label":"_parse_distmat($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","definition":"sub","line":739,"children":[{"localvar":"my","containerName":"_parse_distmat","definition":"my","name":"$self","line":740,"kind":13},{"line":741,"kind":13,"localvar":"my","name":"@results","definition":"my","containerName":"_parse_distmat"},{"kind":13,"line":742,"name":"$ver","definition":"my","containerName":"_parse_distmat","localvar":"my"},{"containerName":"_parse_distmat","name":"$self","kind":13,"line":744},{"containerName":"_parse_distmat","name":"_readline","line":744,"kind":12},{"line":748,"kind":13,"name":"$ver","containerName":"_parse_distmat"},{"containerName":"_parse_distmat","name":"$self","kind":13,"line":749},{"containerName":"_parse_distmat","name":"_readline","line":749,"kind":12},{"line":750,"kind":13,"containerName":"_parse_distmat","name":"$self"},{"line":750,"kind":12,"containerName":"_parse_distmat","name":"_readline"},{"kind":13,"line":751,"name":"$self","containerName":"_parse_distmat"},{"containerName":"_parse_distmat","name":"_readline","line":751,"kind":12},{"line":752,"kind":13,"name":"$self","containerName":"_parse_distmat"},{"containerName":"_parse_distmat","name":"_readline","kind":12,"line":752},{"name":"$self","containerName":"_parse_distmat","line":759,"kind":13},{"containerName":"_parse_distmat","name":"_readline","line":759,"kind":12},{"containerName":"_parse_distmat","name":"$ver","line":759,"kind":13},{"name":"$self","containerName":"_parse_distmat","line":762,"kind":13},{"name":"$self","containerName":"_parse_distmat","line":763,"kind":13},{"name":"_readline","containerName":"_parse_distmat","kind":12,"line":763},{"kind":13,"line":764,"name":"$self","containerName":"_parse_distmat"},{"kind":12,"line":764,"name":"_readline","containerName":"_parse_distmat"},{"kind":13,"line":765,"name":"$self","containerName":"_parse_distmat"},{"line":765,"kind":12,"name":"_readline","containerName":"_parse_distmat"},{"definition":"my","name":"$seqct","containerName":"_parse_distmat","localvar":"my","kind":13,"line":767},{"line":768,"kind":13,"localvar":"my","containerName":"_parse_distmat","name":"@seqs","definition":"my"},{"containerName":"_parse_distmat","name":"$self","line":769,"kind":13},{"name":"_readline","containerName":"_parse_distmat","kind":12,"line":769},{"kind":13,"line":770,"containerName":"_parse_distmat","name":"$self"},{"localvar":"my","containerName":"_parse_distmat","definition":"my","name":"$seq","line":773,"kind":13},{"line":773,"kind":13,"name":"$rest","containerName":"_parse_distmat"},{"line":774,"kind":13,"name":"$rest","containerName":"_parse_distmat"},{"name":"$rest","containerName":"_parse_distmat","line":774,"kind":13},{"line":775,"kind":13,"localvar":"my","containerName":"_parse_distmat","name":"$j","definition":"my"},{"kind":13,"line":776,"containerName":"_parse_distmat","name":"$self"},{"kind":13,"line":777,"name":"@seqs","containerName":"_parse_distmat"},{"name":"new","containerName":"_parse_distmat","line":777,"kind":12},{"name":"$seq","containerName":"_parse_distmat","kind":13,"line":777},{"line":779,"kind":13,"name":"$rest","containerName":"_parse_distmat"},{"line":779,"kind":13,"name":"$rest","containerName":"_parse_distmat"},{"kind":13,"line":781,"containerName":"_parse_distmat","name":"$self"},{"line":781,"kind":13,"containerName":"_parse_distmat","name":"$j"},{"line":781,"kind":13,"containerName":"_parse_distmat","name":"$seqct"},{"kind":13,"line":786,"containerName":"_parse_distmat","name":"$seqct"},{"kind":13,"line":788,"name":"$self","containerName":"_parse_distmat"},{"containerName":"_parse_distmat","name":"@seqs","line":788,"kind":13},{"kind":13,"line":789,"name":"$self","containerName":"_parse_distmat"},{"containerName":"_parse_distmat","name":"@seqs","kind":13,"line":789}],"kind":12,"range":{"start":{"line":739,"character":0},"end":{"character":9999,"line":793}},"name":"_parse_distmat"},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":777},{"kind":12,"line":796,"children":[{"localvar":"my","containerName":"_parse_PairwiseCodon","name":"$self","definition":"my","line":797,"kind":13},{"kind":13,"line":798,"containerName":"_parse_PairwiseCodon","definition":"my","name":"@result","localvar":"my"},{"kind":13,"line":799,"name":"$a","definition":"my","containerName":"_parse_PairwiseCodon","localvar":"my"},{"kind":13,"line":799,"containerName":"_parse_PairwiseCodon","name":"$b"},{"kind":13,"line":799,"name":"$log","containerName":"_parse_PairwiseCodon"},{"containerName":"_parse_PairwiseCodon","name":"$model","line":799,"kind":13},{"containerName":"_parse_PairwiseCodon","name":"$t","kind":13,"line":799},{"kind":13,"line":799,"name":"$kappa","containerName":"_parse_PairwiseCodon"},{"containerName":"_parse_PairwiseCodon","name":"$omega","line":799,"kind":13},{"line":800,"kind":13,"containerName":"_parse_PairwiseCodon","name":"$self"},{"kind":12,"line":800,"name":"_readline","containerName":"_parse_PairwiseCodon"},{"line":802,"kind":13,"containerName":"_parse_PairwiseCodon","name":"$model"},{"name":"$a","containerName":"_parse_PairwiseCodon","kind":13,"line":804},{"name":"$b","containerName":"_parse_PairwiseCodon","line":804,"kind":13},{"kind":13,"line":806,"name":"$log","containerName":"_parse_PairwiseCodon"},{"kind":13,"line":807,"containerName":"_parse_PairwiseCodon","name":"$self"},{"containerName":"_parse_PairwiseCodon","name":"_readline","line":807,"kind":12},{"line":809,"kind":13,"containerName":"_parse_PairwiseCodon","name":"$t"},{"kind":13,"line":809,"name":"$kappa","containerName":"_parse_PairwiseCodon"},{"containerName":"_parse_PairwiseCodon","name":"$omega","line":809,"kind":13},{"containerName":"_parse_PairwiseCodon","name":"$result","line":817,"kind":13},{"containerName":"_parse_PairwiseCodon","name":"$b","kind":13,"line":817},{"containerName":"_parse_PairwiseCodon","name":"$a","kind":13,"line":817},{"name":"$log","containerName":"_parse_PairwiseCodon","kind":13,"line":818},{"kind":13,"line":819,"containerName":"_parse_PairwiseCodon","name":"$t"},{"name":"$t","containerName":"_parse_PairwiseCodon","line":819,"kind":13},{"name":"$t","containerName":"_parse_PairwiseCodon","line":819,"kind":13},{"kind":13,"line":822,"name":"$kappa","containerName":"_parse_PairwiseCodon"},{"name":"$omega","containerName":"_parse_PairwiseCodon","kind":13,"line":823},{"kind":13,"line":823,"containerName":"_parse_PairwiseCodon","name":"$omega"},{"kind":13,"line":823,"name":"$omega","containerName":"_parse_PairwiseCodon"},{"containerName":"_parse_PairwiseCodon","name":"$self","line":830,"kind":13},{"name":"debug","containerName":"_parse_PairwiseCodon","line":830,"kind":12},{"kind":13,"line":833,"containerName":"_parse_PairwiseCodon","name":"@result"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_parse_PairwiseCodon($self)","documentation":"","parameters":[{"label":"$self"}]},"name":"_parse_PairwiseCodon","range":{"start":{"line":796,"character":0},"end":{"character":9999,"line":834}}},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_YN_Pairwise($self)"},"containerName":"main::","definition":"sub","line":836,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_parse_YN_Pairwise","line":837,"kind":13},{"kind":13,"line":838,"definition":"my","name":"@result","containerName":"_parse_YN_Pairwise","localvar":"my"},{"name":"$self","containerName":"_parse_YN_Pairwise","kind":13,"line":839},{"kind":12,"line":839,"name":"_readline","containerName":"_parse_YN_Pairwise"},{"kind":13,"line":842,"containerName":"_parse_YN_Pairwise","name":"$self"},{"line":842,"kind":12,"containerName":"_parse_YN_Pairwise","name":"_readline"},{"name":"$result","containerName":"_parse_YN_Pairwise","kind":13,"line":859},{"name":"$self","containerName":"_parse_YN_Pairwise","kind":13,"line":873},{"line":873,"kind":12,"containerName":"_parse_YN_Pairwise","name":"_pushback"},{"containerName":"_parse_YN_Pairwise","name":"@result","line":877,"kind":13}],"kind":12,"range":{"start":{"line":836,"character":0},"end":{"character":9999,"line":878}},"name":"_parse_YN_Pairwise"},{"name":"_parse_Forestry","range":{"start":{"character":0,"line":880},"end":{"line":952,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"_parse_Forestry","name":"$self","definition":"my","line":881,"kind":13},{"line":882,"kind":13,"localvar":"my","containerName":"_parse_Forestry","name":"$instancecount","definition":"my"},{"kind":13,"line":882,"containerName":"_parse_Forestry","name":"$num_param"},{"name":"$loglikelihood","containerName":"_parse_Forestry","kind":13,"line":883},{"kind":13,"line":883,"containerName":"_parse_Forestry","name":"$score"},{"containerName":"_parse_Forestry","name":"$done","line":883,"kind":13},{"containerName":"_parse_Forestry","name":"$treelength","kind":13,"line":883},{"line":884,"kind":13,"localvar":"my","name":"$okay","definition":"my","containerName":"_parse_Forestry"},{"line":885,"kind":13,"localvar":"my","definition":"my","name":"@ids","containerName":"_parse_Forestry"},{"kind":13,"line":885,"name":"%match","containerName":"_parse_Forestry"},{"containerName":"_parse_Forestry","name":"@branches","line":885,"kind":13},{"containerName":"_parse_Forestry","name":"@trees","line":885,"kind":13},{"name":"$self","containerName":"_parse_Forestry","kind":13,"line":886},{"line":886,"kind":12,"name":"_readline","containerName":"_parse_Forestry"},{"containerName":"_parse_Forestry","name":"$done","line":887,"kind":13},{"containerName":"_parse_Forestry","name":"$score","kind":13,"line":889},{"kind":13,"line":890,"containerName":"_parse_Forestry","name":"@ids"},{"containerName":"_parse_Forestry","name":"$self","kind":13,"line":893},{"kind":12,"line":893,"containerName":"_parse_Forestry","name":"_pushback"},{"kind":13,"line":894,"name":"$done","containerName":"_parse_Forestry"},{"containerName":"_parse_Forestry","name":"$treelength","line":897,"kind":13},{"name":"$num_param","containerName":"_parse_Forestry","kind":13,"line":902},{"kind":13,"line":902,"name":"$loglikelihood","containerName":"_parse_Forestry"},{"kind":13,"line":905,"containerName":"_parse_Forestry","name":"$treestr","definition":"my","localvar":"my"},{"name":"$treeio","definition":"my","containerName":"_parse_Forestry","localvar":"my","kind":13,"line":906},{"line":906,"kind":12,"containerName":"_parse_Forestry","name":"new"},{"kind":13,"line":906,"containerName":"_parse_Forestry","name":"$treestr"},{"kind":13,"line":908,"name":"$tree","definition":"my","containerName":"_parse_Forestry","localvar":"my"},{"line":908,"kind":13,"containerName":"_parse_Forestry","name":"$treeio"},{"kind":12,"line":908,"name":"next_tree","containerName":"_parse_Forestry"},{"name":"$tree","containerName":"_parse_Forestry","kind":13,"line":909},{"kind":13,"line":910,"name":"$tree","containerName":"_parse_Forestry"},{"containerName":"_parse_Forestry","name":"score","kind":12,"line":910},{"name":"$loglikelihood","containerName":"_parse_Forestry","kind":13,"line":910},{"containerName":"_parse_Forestry","name":"$tree","kind":13,"line":911},{"name":"id","containerName":"_parse_Forestry","kind":12,"line":911},{"name":"$okay","containerName":"_parse_Forestry","line":912,"kind":13},{"containerName":"_parse_Forestry","name":"%match","line":914,"kind":13},{"containerName":"_parse_Forestry","name":"@ids","line":914,"kind":13},{"localvar":"my","name":"$i","definition":"my","containerName":"_parse_Forestry","line":915,"kind":13},{"definition":"my","name":"$m","containerName":"_parse_Forestry","localvar":"my","kind":13,"line":916},{"line":917,"kind":13,"name":"$match","containerName":"_parse_Forestry"},{"kind":13,"line":917,"containerName":"_parse_Forestry","name":"@ids"},{"kind":13,"line":917,"containerName":"_parse_Forestry","name":"$m"},{"kind":13,"line":919,"containerName":"_parse_Forestry","definition":"my","name":"%grp","localvar":"my"},{"containerName":"_parse_Forestry","name":"$br","definition":"my","localvar":"my","kind":13,"line":920},{"name":"@branches","containerName":"_parse_Forestry","kind":13,"line":920},{"containerName":"_parse_Forestry","name":"$parent","definition":"my","localvar":"my","kind":13,"line":921},{"kind":13,"line":921,"name":"$child","containerName":"_parse_Forestry"},{"name":"$br","containerName":"_parse_Forestry","line":921,"kind":13},{"kind":13,"line":922,"name":"$match","containerName":"_parse_Forestry"},{"line":922,"kind":13,"containerName":"_parse_Forestry","name":"$child"},{"line":923,"kind":13,"containerName":"_parse_Forestry","name":"$match"},{"name":"$parent","containerName":"_parse_Forestry","line":923,"kind":13},{"containerName":"_parse_Forestry","name":"$match","kind":13,"line":923},{"kind":13,"line":923,"containerName":"_parse_Forestry","name":"$child"},{"name":"@branches","containerName":"_parse_Forestry","kind":13,"line":925},{"containerName":"_parse_Forestry","name":"$br","line":925,"kind":13},{"name":"$self","containerName":"_parse_Forestry","line":928,"kind":13},{"containerName":"_parse_Forestry","name":"verbose","kind":12,"line":928},{"name":"$k","definition":"my","containerName":"_parse_Forestry","localvar":"my","kind":13,"line":929},{"containerName":"_parse_Forestry","name":"$a","line":929,"kind":13},{"kind":13,"line":929,"containerName":"_parse_Forestry","name":"$b"},{"kind":13,"line":929,"containerName":"_parse_Forestry","name":"%match"},{"name":"$self","containerName":"_parse_Forestry","line":930,"kind":13},{"kind":12,"line":930,"name":"debug","containerName":"_parse_Forestry"},{"name":"$match","containerName":"_parse_Forestry","kind":13,"line":931},{"line":931,"kind":13,"name":"$k","containerName":"_parse_Forestry"},{"name":"$self","containerName":"_parse_Forestry","line":936,"kind":13},{"localvar":"my","containerName":"_parse_Forestry","name":"@SEs","definition":"my","line":937,"kind":13},{"kind":13,"line":937,"name":"$self","containerName":"_parse_Forestry"},{"line":938,"kind":13,"localvar":"my","containerName":"_parse_Forestry","definition":"my","name":"$i"},{"containerName":"_parse_Forestry","definition":"my","name":"$parent_id","localvar":"my","kind":13,"line":939},{"name":"$self","containerName":"_parse_Forestry","kind":13,"line":939},{"line":940,"kind":13,"localvar":"my","definition":"my","name":"@nodes","containerName":"_parse_Forestry"},{"localvar":"my","containerName":"_parse_Forestry","definition":"my","name":"@node_ids","line":941,"kind":13},{"kind":13,"line":941,"containerName":"_parse_Forestry","name":"$match"},{"name":"$parent_id","containerName":"_parse_Forestry","kind":13,"line":941},{"kind":13,"line":942,"name":"@nodes_L","definition":"my","containerName":"_parse_Forestry","localvar":"my"},{"kind":13,"line":942,"name":"$tree","containerName":"_parse_Forestry"},{"line":942,"kind":12,"name":"find_node","containerName":"_parse_Forestry"},{"line":942,"kind":13,"containerName":"_parse_Forestry","name":"@node_ids"},{"localvar":"my","containerName":"_parse_Forestry","name":"$n","definition":"my","line":943,"kind":13},{"containerName":"_parse_Forestry","name":"@nodes_L","kind":13,"line":943},{"kind":13,"line":943,"name":"@nodes_L","containerName":"_parse_Forestry"},{"line":943,"kind":13,"name":"$tree","containerName":"_parse_Forestry"},{"name":"get_lca","containerName":"_parse_Forestry","kind":12,"line":943},{"containerName":"_parse_Forestry","name":"@nodes_L","line":943,"kind":13},{"name":"$n","containerName":"_parse_Forestry","kind":13,"line":944},{"line":945,"kind":13,"name":"$self","containerName":"_parse_Forestry"},{"kind":12,"line":945,"name":"warn","containerName":"_parse_Forestry"},{"name":"$n","containerName":"_parse_Forestry","line":947,"kind":13},{"kind":12,"line":947,"name":"add_tag_value","containerName":"_parse_Forestry"},{"name":"$SEs","containerName":"_parse_Forestry","line":947,"kind":13},{"line":947,"kind":13,"containerName":"_parse_Forestry","name":"$i"},{"name":"$i","containerName":"_parse_Forestry","kind":13,"line":948},{"kind":13,"line":951,"name":"@trees","containerName":"_parse_Forestry"},{"line":951,"kind":13,"name":"$tree","containerName":"_parse_Forestry"}],"line":880,"definition":"sub","containerName":"main::","signature":{"label":"_parse_Forestry($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)"},{"containerName":"String","name":"IO","line":905,"kind":12},{"kind":12,"line":906,"name":"Bio","containerName":"TreeIO"},{"name":"_SEs","kind":12,"line":936},{"name":"_SEs","line":937,"kind":12},{"kind":12,"line":939,"name":"_branch_ids"},{"kind":13,"line":954,"containerName":null,"name":"%okay"},{"definition":"my","name":"$se_line","containerName":null,"localvar":"my","kind":13,"line":956},{"name":"$self","containerName":null,"kind":13,"line":956},{"name":"_readline","containerName":"main::","kind":12,"line":956},{"name":"$se_line","containerName":null,"line":957,"kind":13},{"name":"%self","containerName":null,"line":958,"kind":13},{"name":"_SEs","line":958,"kind":12},{"containerName":null,"name":"%se_line","kind":13,"line":958},{"name":"@branches","containerName":null,"line":960,"kind":13},{"kind":13,"line":961,"definition":"my","name":"$ids","containerName":null,"localvar":"my"},{"kind":13,"line":961,"containerName":null,"name":"$ids"},{"kind":13,"line":962,"containerName":null,"name":"%self"},{"name":"_branch_ids","kind":12,"line":962},{"kind":13,"line":962,"containerName":null,"name":"$ids"},{"name":"@trees","containerName":null,"line":965,"kind":13},{"name":"%match","containerName":null,"kind":13,"line":965},{"range":{"end":{"character":9999,"line":1082},"start":{"character":0,"line":968}},"definition":"sub","name":"_parse_NSsitesBatch","containerName":"main::","children":[{"line":969,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","name":"$self","definition":"my"},{"kind":13,"line":970,"containerName":"_parse_NSsitesBatch","name":"%data","definition":"my","localvar":"my"},{"line":970,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$idlookup"},{"containerName":"_parse_NSsitesBatch","name":"$okay","definition":"my","localvar":"my","kind":13,"line":971},{"containerName":"_parse_NSsitesBatch","name":"$done","line":971,"kind":13},{"name":"$self","containerName":"_parse_NSsitesBatch","kind":13,"line":972},{"kind":12,"line":972,"containerName":"_parse_NSsitesBatch","name":"_readline"},{"kind":13,"line":973,"containerName":"_parse_NSsitesBatch","name":"$done"},{"containerName":"_parse_NSsitesBatch","name":"$okay","line":975,"kind":13},{"kind":13,"line":978,"containerName":"_parse_NSsitesBatch","name":"$okay"},{"kind":13,"line":981,"containerName":"_parse_NSsitesBatch","name":"$self"},{"name":"_pushback","containerName":"_parse_NSsitesBatch","kind":12,"line":981},{"name":"$done","containerName":"_parse_NSsitesBatch","kind":13,"line":982},{"name":"$data","containerName":"_parse_NSsitesBatch","line":985,"kind":13},{"kind":13,"line":986,"name":"$data","containerName":"_parse_NSsitesBatch"},{"name":"$okay","containerName":"_parse_NSsitesBatch","line":987,"kind":13},{"line":990,"kind":13,"name":"$data","containerName":"_parse_NSsitesBatch"},{"name":"$done","containerName":"_parse_NSsitesBatch","kind":13,"line":991},{"containerName":"_parse_NSsitesBatch","name":"$data","kind":13,"line":993},{"line":995,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"line":995,"kind":12,"name":"_pushback","containerName":"_parse_NSsitesBatch"},{"name":"$data","containerName":"_parse_NSsitesBatch","line":996,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"$idlookup","kind":13,"line":996},{"line":996,"kind":13,"name":"$self","containerName":"_parse_NSsitesBatch"},{"name":"_parse_Forestry","containerName":"_parse_NSsitesBatch","kind":12,"line":996},{"containerName":"_parse_NSsitesBatch","name":"$data","line":997,"kind":13},{"name":"$data","containerName":"_parse_NSsitesBatch","kind":13,"line":998},{"name":"$data","containerName":"_parse_NSsitesBatch","line":999,"kind":13},{"kind":13,"line":999,"name":"$data","containerName":"_parse_NSsitesBatch"},{"line":999,"kind":12,"containerName":"_parse_NSsitesBatch","name":"score"},{"name":"$okay","containerName":"_parse_NSsitesBatch","line":1001,"kind":13},{"localvar":"my","containerName":"_parse_NSsitesBatch","definition":"my","name":"@p","line":1006,"kind":13},{"kind":13,"line":1007,"containerName":"_parse_NSsitesBatch","definition":"my","name":"@w","localvar":"my"},{"kind":13,"line":1008,"containerName":"_parse_NSsitesBatch","name":"$data"},{"line":1008,"kind":13,"containerName":"_parse_NSsitesBatch","name":"@p"},{"containerName":"_parse_NSsitesBatch","name":"@w","line":1009,"kind":13},{"line":1011,"kind":13,"name":"$data","containerName":"_parse_NSsitesBatch"},{"containerName":"_parse_NSsitesBatch","name":"$self","kind":13,"line":1013},{"line":1013,"kind":12,"name":"_pushback","containerName":"_parse_NSsitesBatch"},{"name":"$sites","definition":"my","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"line":1014},{"containerName":"_parse_NSsitesBatch","name":"$neb","line":1014,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"$beb","line":1014,"kind":13},{"line":1014,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"containerName":"_parse_NSsitesBatch","name":"_parse_Pos_selected_sites","line":1014,"kind":12},{"line":1015,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data"},{"name":"$sites","containerName":"_parse_NSsitesBatch","line":1015,"kind":13},{"kind":13,"line":1016,"containerName":"_parse_NSsitesBatch","name":"$data"},{"kind":13,"line":1016,"name":"$neb","containerName":"_parse_NSsitesBatch"},{"line":1017,"kind":13,"name":"$data","containerName":"_parse_NSsitesBatch"},{"kind":13,"line":1017,"containerName":"_parse_NSsitesBatch","name":"$beb"},{"name":"$data","containerName":"_parse_NSsitesBatch","line":1020,"kind":13},{"name":"$self","containerName":"_parse_NSsitesBatch","kind":13,"line":1021},{"containerName":"_parse_NSsitesBatch","name":"_readline","kind":12,"line":1021},{"containerName":"_parse_NSsitesBatch","name":"$self","line":1023,"kind":13},{"name":"_pushback","containerName":"_parse_NSsitesBatch","kind":12,"line":1023},{"kind":13,"line":1028,"name":"$self","containerName":"_parse_NSsitesBatch"},{"line":1028,"kind":12,"containerName":"_parse_NSsitesBatch","name":"_readline"},{"line":1029,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","definition":"my","name":"$tmp"},{"containerName":"_parse_NSsitesBatch","name":"$self","line":1029,"kind":13},{"name":"_readline","containerName":"_parse_NSsitesBatch","line":1029,"kind":12},{"name":"@p","definition":"my","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"line":1030},{"line":1030,"kind":13,"name":"$tmp","containerName":"_parse_NSsitesBatch"},{"name":"$tmp","containerName":"_parse_NSsitesBatch","line":1031,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"$self","line":1031,"kind":13},{"kind":12,"line":1031,"name":"_readline","containerName":"_parse_NSsitesBatch"},{"line":1032,"kind":13,"localvar":"my","name":"@b_w","definition":"my","containerName":"_parse_NSsitesBatch"},{"kind":13,"line":1032,"name":"$tmp","containerName":"_parse_NSsitesBatch"},{"kind":13,"line":1033,"name":"$tmp","containerName":"_parse_NSsitesBatch"},{"name":"$self","containerName":"_parse_NSsitesBatch","line":1033,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"_readline","line":1033,"kind":12},{"line":1034,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","name":"@f_w","definition":"my"},{"containerName":"_parse_NSsitesBatch","name":"$tmp","line":1034,"kind":13},{"line":1035,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","definition":"my","name":"@w"},{"localvar":"my","definition":"my","name":"$i","containerName":"_parse_NSsitesBatch","line":1036,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"@w","kind":13,"line":1037},{"line":1037,"kind":13,"name":"$b_w","containerName":"_parse_NSsitesBatch"},{"name":"$i","containerName":"_parse_NSsitesBatch","line":1037,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"$f_w","kind":13,"line":1038},{"kind":13,"line":1038,"name":"$i","containerName":"_parse_NSsitesBatch"},{"name":"$data","containerName":"_parse_NSsitesBatch","line":1040,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"@p","kind":13,"line":1040},{"line":1041,"kind":13,"name":"@w","containerName":"_parse_NSsitesBatch"},{"localvar":"my","containerName":"_parse_NSsitesBatch","name":"$tmp","definition":"my","line":1043,"kind":13},{"line":1043,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"containerName":"_parse_NSsitesBatch","name":"_readline","line":1043,"kind":12},{"localvar":"my","definition":"my","name":"@p","containerName":"_parse_NSsitesBatch","line":1044,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"$tmp","line":1044,"kind":13},{"kind":13,"line":1045,"containerName":"_parse_NSsitesBatch","name":"$tmp"},{"containerName":"_parse_NSsitesBatch","name":"$self","kind":13,"line":1045},{"name":"_readline","containerName":"_parse_NSsitesBatch","kind":12,"line":1045},{"line":1046,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","definition":"my","name":"@w"},{"name":"$tmp","containerName":"_parse_NSsitesBatch","kind":13,"line":1046},{"kind":13,"line":1047,"name":"$data","containerName":"_parse_NSsitesBatch"},{"containerName":"_parse_NSsitesBatch","name":"@p","line":1047,"kind":13},{"line":1048,"kind":13,"name":"@w","containerName":"_parse_NSsitesBatch"},{"containerName":"_parse_NSsitesBatch","definition":"my","name":"%branch_dnds","localvar":"my","kind":13,"line":1051},{"kind":13,"line":1051,"name":"$self","containerName":"_parse_NSsitesBatch"},{"kind":12,"line":1051,"name":"_parse_branch_dnds","containerName":"_parse_NSsitesBatch"},{"name":"$data","containerName":"_parse_NSsitesBatch","kind":13,"line":1052},{"kind":13,"line":1053,"name":"$self","containerName":"_parse_NSsitesBatch"},{"containerName":"_parse_NSsitesBatch","name":"warn","kind":12,"line":1053},{"line":1056,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","definition":"my","name":"$tree"},{"name":"$data","containerName":"_parse_NSsitesBatch","line":1056,"kind":13},{"kind":13,"line":1057,"name":"$tree","containerName":"_parse_NSsitesBatch"},{"name":"$tree","containerName":"_parse_NSsitesBatch","line":1057,"kind":13},{"line":1058,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$tree"},{"name":"isa","containerName":"_parse_NSsitesBatch","line":1058,"kind":12},{"line":1059,"kind":13,"name":"$self","containerName":"_parse_NSsitesBatch"},{"kind":12,"line":1059,"name":"warn","containerName":"_parse_NSsitesBatch"},{"line":1063,"kind":13,"localvar":"my","definition":"my","name":"$k","containerName":"_parse_NSsitesBatch"},{"name":"$v","containerName":"_parse_NSsitesBatch","line":1063,"kind":13},{"name":"%branch_dnds","containerName":"_parse_NSsitesBatch","line":1063,"kind":13},{"localvar":"my","containerName":"_parse_NSsitesBatch","name":"@nodes","definition":"my","line":1065,"kind":13},{"line":1066,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","definition":"my","name":"$id"},{"line":1066,"kind":13,"name":"$k","containerName":"_parse_NSsitesBatch"},{"localvar":"my","containerName":"_parse_NSsitesBatch","definition":"my","name":"@nodes_L","line":1067,"kind":13},{"name":"$tree","containerName":"_parse_NSsitesBatch","line":1067,"kind":13},{"kind":12,"line":1067,"containerName":"_parse_NSsitesBatch","name":"find_node"},{"line":1067,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$idlookup"},{"line":1067,"kind":13,"name":"$id","containerName":"_parse_NSsitesBatch"},{"localvar":"my","containerName":"_parse_NSsitesBatch","name":"$n","definition":"my","line":1068,"kind":13},{"name":"@nodes_L","containerName":"_parse_NSsitesBatch","kind":13,"line":1068},{"containerName":"_parse_NSsitesBatch","name":"@nodes_L","kind":13,"line":1068},{"containerName":"_parse_NSsitesBatch","name":"$tree","kind":13,"line":1068},{"line":1068,"kind":12,"containerName":"_parse_NSsitesBatch","name":"get_lca"},{"containerName":"_parse_NSsitesBatch","name":"@nodes_L","kind":13,"line":1068},{"line":1069,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$n"},{"line":1070,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"line":1070,"kind":12,"name":"warn","containerName":"_parse_NSsitesBatch"},{"line":1072,"kind":13,"name":"$n","containerName":"_parse_NSsitesBatch"},{"line":1072,"kind":12,"name":"is_Leaf","containerName":"_parse_NSsitesBatch"},{"containerName":"_parse_NSsitesBatch","name":"$n","kind":13,"line":1072},{"containerName":"_parse_NSsitesBatch","name":"id","line":1072,"kind":12},{"name":"$n","containerName":"_parse_NSsitesBatch","kind":13,"line":1073},{"line":1073,"kind":12,"containerName":"_parse_NSsitesBatch","name":"id"},{"containerName":"_parse_NSsitesBatch","name":"$id","line":1073,"kind":13},{"containerName":"_parse_NSsitesBatch","name":"@nodes","kind":13,"line":1075},{"containerName":"_parse_NSsitesBatch","name":"$n","kind":13,"line":1075},{"kind":13,"line":1077,"containerName":"_parse_NSsitesBatch","definition":"my","name":"$parent","localvar":"my"},{"name":"$child","containerName":"_parse_NSsitesBatch","kind":13,"line":1077},{"name":"@nodes","containerName":"_parse_NSsitesBatch","line":1077,"kind":13},{"name":"$kk","definition":"my","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"line":1078},{"containerName":"_parse_NSsitesBatch","name":"$vv","kind":13,"line":1078},{"line":1078,"kind":13,"name":"$v","containerName":"_parse_NSsitesBatch"},{"line":1079,"kind":13,"name":"$child","containerName":"_parse_NSsitesBatch"},{"name":"add_tag_value","containerName":"_parse_NSsitesBatch","line":1079,"kind":12},{"containerName":"_parse_NSsitesBatch","name":"$kk","kind":13,"line":1079},{"kind":13,"line":1079,"name":"$vv","containerName":"_parse_NSsitesBatch"}],"line":968,"kind":12},{"line":1036,"kind":12,"name":"b_w"},{"containerName":null,"name":"$self","kind":13,"line":1084},{"containerName":"main::","name":"_readline","line":1084,"kind":12},{"containerName":null,"name":"%data","line":1086,"kind":13},{"containerName":null,"name":"$self","line":1091,"kind":13},{"line":1091,"kind":12,"containerName":"main::","name":"warn"},{"kind":13,"line":1097,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_readline","line":1097,"kind":12},{"kind":13,"line":1098,"definition":"my","name":"$p0","containerName":null,"localvar":"my"},{"line":1098,"kind":13,"containerName":null,"name":"$p"},{"name":"$q","containerName":null,"line":1098,"kind":13},{"name":"$p1","containerName":null,"line":1098,"kind":13},{"kind":13,"line":1098,"name":"%w","containerName":null},{"name":"$p0","containerName":null,"kind":13,"line":1100},{"containerName":null,"name":"$p","kind":13,"line":1100},{"kind":13,"line":1100,"containerName":null,"name":"%q"},{"kind":13,"line":1102,"containerName":null,"name":"$self"},{"name":"warn","containerName":"main::","line":1102,"kind":12},{"kind":13,"line":1104,"name":"$self","containerName":null},{"line":1104,"kind":12,"containerName":"main::","name":"_readline"},{"kind":13,"line":1106,"containerName":null,"name":"$p1"},{"line":1106,"kind":13,"containerName":null,"name":"$w"},{"kind":13,"line":1107,"containerName":null,"name":"%data"},{"name":"$p0","containerName":null,"kind":13,"line":1109},{"name":"$p","containerName":null,"kind":13,"line":1110},{"kind":13,"line":1111,"containerName":null,"name":"$q"},{"containerName":null,"name":"$p1","kind":13,"line":1112},{"name":"%w","containerName":null,"kind":13,"line":1113},{"containerName":null,"name":"$self","line":1115,"kind":13},{"containerName":"main::","name":"warn","kind":12,"line":1115},{"localvar":"my","definition":"my","name":"$gamma","containerName":null,"line":1118,"kind":13},{"line":1119,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_readline","kind":12,"line":1119},{"localvar":"my","name":"@r","definition":"my","containerName":null,"line":1120,"kind":13},{"containerName":null,"name":"@f","kind":13,"line":1120},{"name":"@r","containerName":null,"kind":13,"line":1122},{"kind":13,"line":1124,"containerName":null,"name":"$self"},{"name":"_readline","containerName":"main::","line":1124,"kind":12},{"containerName":null,"name":"@f","kind":13,"line":1126},{"name":"%data","containerName":null,"kind":13,"line":1128},{"kind":13,"line":1130,"containerName":null,"name":"$gamma"},{"containerName":null,"name":"@r","kind":13,"line":1131},{"line":1132,"kind":13,"containerName":null,"name":"@f"},{"line":1135,"kind":12,"name":"Bio","containerName":"Tools::Phylo::PAML::ModelResult"},{"name":"%data","containerName":null,"kind":13,"line":1135},{"children":[{"line":1139,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_parse_Pos_selected_sites"},{"line":1140,"kind":13,"localvar":"my","definition":"my","name":"$okay","containerName":"_parse_Pos_selected_sites"},{"containerName":"_parse_Pos_selected_sites","definition":"my","name":"%sites","localvar":"my","kind":13,"line":1141},{"line":1144,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"_parse_Pos_selected_sites"},{"kind":13,"line":1145,"name":"$self","containerName":"_parse_Pos_selected_sites"},{"containerName":"_parse_Pos_selected_sites","name":"_readline","kind":12,"line":1145},{"kind":13,"line":1148,"containerName":"_parse_Pos_selected_sites","name":"$self"},{"line":1148,"kind":12,"name":"_pushback","containerName":"_parse_Pos_selected_sites"},{"line":1152,"kind":13,"containerName":"_parse_Pos_selected_sites","name":"$type"},{"kind":13,"line":1154,"containerName":"_parse_Pos_selected_sites","name":"$type"},{"name":"$okay","containerName":"_parse_Pos_selected_sites","kind":13,"line":1156},{"line":1157,"kind":13,"name":"$okay","containerName":"_parse_Pos_selected_sites"},{"line":1158,"kind":13,"localvar":"my","containerName":"_parse_Pos_selected_sites","name":"$signif","definition":"my"},{"line":1159,"kind":13,"name":"$signif","containerName":"_parse_Pos_selected_sites"},{"line":1159,"kind":13,"name":"$signif","containerName":"_parse_Pos_selected_sites"},{"line":1160,"kind":13,"containerName":"_parse_Pos_selected_sites","name":"$sites"},{"containerName":"_parse_Pos_selected_sites","name":"$type","line":1160,"kind":13},{"line":1160,"kind":13,"name":"$signif","containerName":"_parse_Pos_selected_sites"},{"line":1161,"kind":13,"containerName":"_parse_Pos_selected_sites","name":"$okay"},{"localvar":"my","name":"$signif","definition":"my","containerName":"_parse_Pos_selected_sites","line":1162,"kind":13},{"name":"$signif","containerName":"_parse_Pos_selected_sites","line":1163,"kind":13},{"containerName":"_parse_Pos_selected_sites","name":"$signif","line":1163,"kind":13},{"containerName":"_parse_Pos_selected_sites","name":"$sites","kind":13,"line":1164},{"line":1164,"kind":13,"containerName":"_parse_Pos_selected_sites","name":"$type"},{"line":1164,"kind":13,"name":"$signif","containerName":"_parse_Pos_selected_sites"}],"line":1138,"kind":12,"range":{"end":{"line":1165,"character":9999},"start":{"character":0,"line":1138}},"name":"_parse_Pos_selected_sites","definition":"sub","containerName":"main::"},{"kind":13,"line":1165,"containerName":null,"name":"%okay"},{"localvar":"my","name":"$signif","definition":"my","containerName":null,"line":1166,"kind":13},{"kind":13,"line":1167,"name":"$signif","containerName":null},{"kind":13,"line":1167,"name":"$signif","containerName":null},{"line":1168,"kind":13,"containerName":null,"name":"%sites"},{"name":"@type","containerName":null,"line":1168,"kind":13},{"kind":13,"line":1168,"name":"$signif","containerName":null},{"name":"%sites","containerName":null,"kind":13,"line":1171},{"kind":13,"line":1171,"containerName":null,"name":"%sites"},{"kind":13,"line":1171,"containerName":null,"name":"%sites"},{"name":"_parse_branch_dnds","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1201},"start":{"character":0,"line":1174}},"kind":12,"children":[{"line":1175,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_branch_dnds"},{"line":1176,"kind":13,"localvar":"my","containerName":"_parse_branch_dnds","name":"$okay","definition":"my"},{"name":"%branch_dnds","definition":"my","containerName":"_parse_branch_dnds","localvar":"my","kind":13,"line":1177},{"kind":13,"line":1178,"name":"@header","definition":"my","containerName":"_parse_branch_dnds","localvar":"my"},{"kind":13,"line":1179,"name":"$self","containerName":"_parse_branch_dnds"},{"name":"_readline","containerName":"_parse_branch_dnds","kind":12,"line":1179},{"containerName":"_parse_branch_dnds","name":"$okay","line":1181,"kind":13},{"name":"@header","containerName":"_parse_branch_dnds","kind":13,"line":1184},{"kind":13,"line":1185,"name":"$okay","containerName":"_parse_branch_dnds"},{"kind":13,"line":1187,"definition":"my","name":"$branch","containerName":"_parse_branch_dnds","localvar":"my"},{"line":1189,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"_parse_branch_dnds"},{"kind":13,"line":1194,"name":"$branch_dnds","containerName":"_parse_branch_dnds"},{"line":1194,"kind":13,"name":"$branch","containerName":"_parse_branch_dnds"},{"kind":13,"line":1194,"containerName":"_parse_branch_dnds","name":"$header"},{"kind":13,"line":1194,"name":"$i","containerName":"_parse_branch_dnds"},{"containerName":"_parse_branch_dnds","name":"$self","kind":13,"line":1196},{"containerName":"_parse_branch_dnds","name":"_pushback","kind":12,"line":1196},{"containerName":"_parse_branch_dnds","name":"%branch_dnds","kind":13,"line":1200}],"line":1174},{"signature":{"label":"_parse_nt_freqs($self)","parameters":[{"label":"$self"}],"documentation":"baseml stuff"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_parse_nt_freqs","line":1206,"kind":13},{"containerName":"_parse_nt_freqs","definition":"my","name":"$okay","localvar":"my","kind":13,"line":1207},{"line":1207,"kind":13,"name":"$done","containerName":"_parse_nt_freqs"},{"kind":13,"line":1207,"name":"$header","containerName":"_parse_nt_freqs"},{"localvar":"my","containerName":"_parse_nt_freqs","definition":"my","name":"@bases","line":1208,"kind":13},{"definition":"my","name":"$numseqs","containerName":"_parse_nt_freqs","localvar":"my","kind":13,"line":1209},{"name":"$self","containerName":"_parse_nt_freqs","kind":13,"line":1209}],"line":1205,"kind":12,"range":{"end":{"line":1209,"character":9999},"start":{"line":1205,"character":0}},"name":"_parse_nt_freqs"},{"line":1210,"kind":13,"name":"$self","containerName":null},{"name":"_readline","containerName":"main::","line":1210,"kind":12},{"line":1211,"kind":13,"name":"$self","containerName":null},{"name":"_pushback","containerName":"main::","line":1211,"kind":12},{"kind":13,"line":1212,"name":"%done","containerName":null},{"line":1215,"kind":13,"containerName":null,"name":"$okay"},{"containerName":null,"name":"%okay","kind":13,"line":1216},{"kind":13,"line":1218,"name":"%header","containerName":null},{"containerName":null,"name":"@bases","line":1220,"kind":13},{"containerName":null,"name":"$header","kind":13,"line":1221},{"line":1222,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":1227,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"line":1228,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":1230},{"containerName":null,"name":"%done","kind":13,"line":1231},{"kind":13,"line":1233,"name":"$seqname","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":1233,"name":"@freqs","containerName":null},{"line":1234,"kind":13,"localvar":"my","definition":"my","name":"$basect","containerName":null},{"kind":13,"line":1235,"containerName":null,"definition":"my","name":"$f","localvar":"my"},{"line":1235,"kind":13,"containerName":null,"name":"@freqs"},{"line":1237,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":1237,"containerName":null,"name":"%seqname"},{"line":1237,"kind":13,"name":"@bases","containerName":null},{"line":1237,"kind":13,"name":"$basect","containerName":null},{"kind":13,"line":1237,"containerName":null,"name":"$f"},{"name":"_parse_nt_dists","range":{"end":{"character":9999,"line":1247},"start":{"character":0,"line":1243}},"kind":12,"children":[{"kind":13,"line":1244,"name":"$self","definition":"my","containerName":"_parse_nt_dists","localvar":"my"},{"line":1245,"kind":13,"localvar":"my","containerName":"_parse_nt_dists","name":"$okay","definition":"my"},{"containerName":"_parse_nt_dists","name":"$seen","kind":13,"line":1245},{"containerName":"_parse_nt_dists","name":"$done","kind":13,"line":1245},{"line":1246,"kind":13,"localvar":"my","definition":"my","name":"%matrix","containerName":"_parse_nt_dists"},{"kind":13,"line":1246,"name":"@names","containerName":"_parse_nt_dists"},{"containerName":"_parse_nt_dists","definition":"my","name":"$numseqs","localvar":"my","kind":13,"line":1247},{"line":1247,"kind":13,"name":"$self","containerName":"_parse_nt_dists"}],"line":1243,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse_nt_dists($self)"},"detail":"($self)"},{"line":1248,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$type"},{"line":1249,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":1249,"name":"_readline","containerName":"main::"},{"name":"$self","containerName":null,"line":1250,"kind":13},{"line":1250,"kind":12,"name":"_pushback","containerName":"main::"},{"containerName":null,"name":"%done","line":1251,"kind":13},{"kind":13,"line":1254,"containerName":null,"name":"%seen"},{"kind":13,"line":1258,"name":"$okay","containerName":null},{"name":"$type","containerName":null,"kind":13,"line":1259},{"containerName":null,"name":"%okay","kind":13,"line":1263},{"localvar":"my","containerName":null,"name":"$seqname","definition":"my","line":1264,"kind":13},{"name":"$vl","containerName":null,"kind":13,"line":1264},{"name":"$seen","containerName":null,"line":1265,"kind":13},{"containerName":null,"definition":"my","name":"$i","localvar":"my","kind":13,"line":1266},{"containerName":null,"name":"%vl","kind":13,"line":1267},{"containerName":null,"name":"%vl","kind":13,"line":1268},{"localvar":"my","definition":"my","name":"$kappa","containerName":null,"line":1269,"kind":13},{"line":1269,"kind":13,"name":"$alpha","containerName":null},{"name":"%matrix","containerName":null,"kind":13,"line":1270},{"kind":13,"line":1270,"name":"%seqname","containerName":null},{"line":1270,"kind":13,"containerName":null,"name":"@names"},{"line":1270,"kind":13,"name":"$i","containerName":null},{"name":"%matrix","containerName":null,"kind":13,"line":1271},{"kind":13,"line":1271,"containerName":null,"name":"@names"},{"line":1271,"kind":13,"containerName":null,"name":"%i"},{"line":1271,"kind":13,"containerName":null,"name":"@seqname"},{"line":1271,"kind":13,"containerName":null,"name":"$kappa"},{"line":1271,"kind":13,"containerName":null,"name":"$alpha"},{"kind":13,"line":1273,"containerName":null,"name":"$i"},{"containerName":null,"name":"%i","line":1275,"kind":13},{"name":"$self","containerName":null,"line":1276,"kind":13},{"kind":12,"line":1276,"name":"warn","containerName":"main::"},{"name":"@names","containerName":null,"kind":13,"line":1279},{"name":"$seqname","containerName":null,"kind":13,"line":1279},{"kind":13,"line":1280,"containerName":null,"name":"%matrix"},{"line":1280,"kind":13,"name":"%seqname","containerName":null},{"line":1280,"kind":13,"name":"@seqname","containerName":null},{"line":1282,"kind":13,"name":"$done","containerName":null},{"kind":13,"line":1282,"containerName":null,"name":"@names"},{"line":1282,"kind":13,"name":"$numseqs","containerName":null},{"containerName":null,"name":"%dist","definition":"my","localvar":"my","kind":13,"line":1284},{"localvar":"my","containerName":null,"definition":"my","name":"$i","line":1285,"kind":13},{"line":1286,"kind":13,"localvar":"my","name":"@kvalues","definition":"my","containerName":null},{"name":"@avalues","containerName":null,"kind":13,"line":1286},{"containerName":null,"definition":"my","name":"$lname","localvar":"my","kind":13,"line":1287},{"name":"@names","containerName":null,"kind":13,"line":1287},{"kind":13,"line":1288,"definition":"my","name":"@arow","containerName":null,"localvar":"my"},{"kind":13,"line":1288,"containerName":null,"name":"@krow"},{"localvar":"my","definition":"my","name":"$j","containerName":null,"line":1289,"kind":13},{"containerName":null,"name":"$rname","definition":"my","localvar":"my","kind":13,"line":1290},{"name":"@names","containerName":null,"line":1290,"kind":13},{"localvar":"my","name":"$v","definition":"my","containerName":null,"line":1291,"kind":13},{"name":"%matrix","containerName":null,"kind":13,"line":1291},{"containerName":null,"name":"%lname","kind":13,"line":1291},{"kind":13,"line":1291,"name":"$rname","containerName":null},{"containerName":null,"name":"@krow","kind":13,"line":1293},{"containerName":null,"name":"@v","kind":13,"line":1293},{"kind":13,"line":1294,"containerName":null,"name":"@arow"},{"line":1294,"kind":13,"name":"@v","containerName":null},{"line":1295,"kind":13,"name":"%dist","containerName":null},{"kind":13,"line":1295,"name":"%lname","containerName":null},{"name":"@rname","containerName":null,"line":1295,"kind":13},{"containerName":null,"name":"$i","line":1295,"kind":13},{"name":"$j","containerName":null,"kind":13,"line":1295},{"kind":13,"line":1297,"containerName":null,"name":"$i"},{"containerName":null,"name":"@kvalues","line":1298,"kind":13},{"line":1298,"kind":13,"containerName":null,"name":"@krow"},{"name":"@avalues","containerName":null,"kind":13,"line":1299},{"line":1299,"kind":13,"name":"@arow","containerName":null},{"kind":12,"line":1302,"name":"Bio","containerName":"Matrix::PhylipDist"},{"name":"new","containerName":"main::","kind":12,"line":1303},{"containerName":null,"name":"%self","kind":13,"line":1303},{"containerName":null,"name":"%dist","line":1304,"kind":13},{"kind":13,"line":1305,"name":"@names","containerName":null},{"kind":13,"line":1306,"containerName":null,"name":"@kvalues"},{"kind":12,"line":1307,"name":"Bio","containerName":"Matrix::PhylipDist"},{"kind":12,"line":1308,"containerName":"main::","name":"new"},{"name":"%self","containerName":null,"line":1308,"kind":13},{"line":1309,"kind":13,"name":"%dist","containerName":null},{"name":"@names","containerName":null,"kind":13,"line":1310},{"name":"@avalues","containerName":null,"line":1311,"kind":13},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_parse_rate_parametes","localvar":"my","kind":13,"line":1317},{"kind":13,"line":1318,"containerName":"_parse_rate_parametes","name":"%rate_parameters","definition":"my","localvar":"my"},{"containerName":"_parse_rate_parametes","name":"$self","line":1319,"kind":13},{"name":"_readline","containerName":"_parse_rate_parametes","line":1319,"kind":12},{"kind":13,"line":1322,"containerName":"_parse_rate_parametes","name":"$rate_parameters"},{"containerName":"_parse_rate_parametes","name":"$rate_parameters","kind":13,"line":1325},{"kind":13,"line":1328,"name":"$rate_parameters","containerName":"_parse_rate_parametes"},{"line":1329,"kind":13,"name":"$self","containerName":"_parse_rate_parametes"},{"containerName":"_parse_rate_parametes","name":"_readline","kind":12,"line":1329},{"kind":13,"line":1333,"name":"$self","containerName":"_parse_rate_parametes"},{"line":1333,"kind":12,"containerName":"_parse_rate_parametes","name":"_pushback"},{"kind":13,"line":1338,"name":"$rate_parameters","containerName":"_parse_rate_parametes"},{"line":1341,"kind":13,"containerName":"_parse_rate_parametes","name":"$rate_parameters"},{"kind":13,"line":1342,"name":"$rate_parameters","containerName":"_parse_rate_parametes"},{"name":"$p","definition":"my","containerName":"_parse_rate_parametes","localvar":"my","kind":13,"line":1344},{"containerName":"_parse_rate_parametes","name":"$rate_parameters","line":1346,"kind":13},{"kind":13,"line":1346,"containerName":"_parse_rate_parametes","name":"$p"}],"line":1316,"name":"_parse_rate_parametes","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1348},"start":{"line":1316,"character":0}}},{"signature":{"label":"_parse_rst($self)","parameters":[{"label":"$self"}],"documentation":" RST parsing"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":1354,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_rst"},{"line":1355,"kind":13,"name":"$self","containerName":"_parse_rst"},{"name":"$self","containerName":"_parse_rst","line":1355,"kind":13},{"containerName":"_parse_rst","name":"$self","line":1355,"kind":13},{"kind":13,"line":1357,"containerName":"_parse_rst","definition":"my","name":"$rstfile","localvar":"my"},{"containerName":"_parse_rst","name":"catfile","line":1357,"kind":12},{"line":1357,"kind":13,"containerName":"_parse_rst","name":"$self"},{"line":1357,"kind":13,"containerName":"_parse_rst","name":"$RSTFILENAME"},{"name":"$rstfile","containerName":"_parse_rst","kind":13,"line":1358},{"name":"$rstfile","containerName":"_parse_rst","kind":13,"line":1358},{"kind":13,"line":1359,"containerName":"_parse_rst","definition":"my","name":"$rstio","localvar":"my"},{"name":"new","containerName":"_parse_rst","kind":12,"line":1359},{"name":"$rstfile","containerName":"_parse_rst","kind":13,"line":1359},{"kind":13,"line":1364,"definition":"my","name":"@firstseq","containerName":"_parse_rst","localvar":"my"},{"name":"@seqs","containerName":"_parse_rst","line":1364,"kind":13},{"containerName":"_parse_rst","name":"@trees","kind":13,"line":1364},{"name":"@per_site_prob","containerName":"_parse_rst","line":1364,"kind":13},{"localvar":"my","definition":"my","name":"$count","containerName":"_parse_rst","line":1365,"kind":13},{"name":"$rstio","containerName":"_parse_rst","kind":13,"line":1366},{"name":"_readline","containerName":"_parse_rst","line":1366,"kind":12},{"line":1369,"kind":13,"name":"$rstio","containerName":"_parse_rst"},{"kind":12,"line":1369,"containerName":"_parse_rst","name":"_readline"},{"containerName":"_parse_rst","name":"$tree","definition":"my","localvar":"my","kind":13,"line":1371},{"containerName":"_parse_rst","name":"new","kind":12,"line":1371},{"containerName":"_parse_rst","name":"$rstio","kind":13,"line":1372},{"kind":12,"line":1372,"containerName":"_parse_rst","name":"_fh"},{"name":"next_tree","containerName":"_parse_rst","line":1373,"kind":12},{"localvar":"my","definition":"my","name":"$n","containerName":"_parse_rst","line":1375,"kind":13},{"line":1375,"kind":13,"name":"$tree","containerName":"_parse_rst"},{"name":"get_nodes","containerName":"_parse_rst","line":1375,"kind":12},{"localvar":"my","name":"$id","definition":"my","containerName":"_parse_rst","line":1376,"kind":13},{"containerName":"_parse_rst","name":"$n","kind":13,"line":1376},{"name":"id","containerName":"_parse_rst","kind":12,"line":1376},{"containerName":"_parse_rst","name":"$id","line":1377,"kind":13},{"name":"$id","containerName":"_parse_rst","kind":13,"line":1377},{"line":1378,"kind":13,"name":"$n","containerName":"_parse_rst"},{"name":"id","containerName":"_parse_rst","kind":12,"line":1378},{"containerName":"_parse_rst","name":"$id","kind":13,"line":1378},{"localvar":"my","containerName":"_parse_rst","name":"$blen","definition":"my","line":1379,"kind":13},{"line":1379,"kind":13,"containerName":"_parse_rst","name":"$n"},{"line":1379,"kind":12,"name":"branch_length","containerName":"_parse_rst"},{"name":"$blen","containerName":"_parse_rst","kind":13,"line":1380},{"kind":13,"line":1380,"containerName":"_parse_rst","name":"$blen"},{"containerName":"_parse_rst","name":"$n","kind":13,"line":1381},{"name":"branch_length","containerName":"_parse_rst","kind":12,"line":1381},{"line":1381,"kind":13,"name":"$blen","containerName":"_parse_rst"},{"containerName":"_parse_rst","name":"@trees","line":1384,"kind":13},{"line":1384,"kind":13,"containerName":"_parse_rst","name":"$tree"},{"name":"$self","containerName":"_parse_rst","kind":13,"line":1389},{"containerName":"_parse_rst","name":"$rstio","line":1390,"kind":13},{"line":1390,"kind":12,"containerName":"_parse_rst","name":"_readline"},{"kind":13,"line":1393,"definition":"my","name":"$sitenum","containerName":"_parse_rst","localvar":"my"},{"containerName":"_parse_rst","name":"$freq","line":1393,"kind":13},{"name":"$extant","containerName":"_parse_rst","kind":13,"line":1393},{"line":1393,"kind":13,"name":"$ancestral","containerName":"_parse_rst"},{"localvar":"my","definition":"my","name":"@anc_site","containerName":"_parse_rst","line":1394,"kind":13},{"kind":13,"line":1394,"name":"@extant_site","containerName":"_parse_rst"},{"name":"@extant_site","containerName":"_parse_rst","line":1395,"kind":13},{"name":"$extant","containerName":"_parse_rst","line":1396,"kind":13},{"kind":13,"line":1397,"containerName":"_parse_rst","name":"@extant_site"},{"name":"$ancestral","containerName":"_parse_rst","kind":13,"line":1399},{"line":1403,"kind":13,"containerName":"_parse_rst","name":"@anc_site"},{"name":"$self","containerName":"_parse_rst","line":1410,"kind":13},{"name":"$sitenum","containerName":"_parse_rst","kind":13,"line":1410},{"line":1410,"kind":13,"containerName":"_parse_rst","name":"@extant_site"},{"line":1411,"kind":13,"containerName":"_parse_rst","name":"@anc_site"},{"kind":13,"line":1418,"name":"@branches","definition":"my","containerName":"_parse_rst","localvar":"my"},{"line":1418,"kind":13,"name":"@branch2node","containerName":"_parse_rst"},{"kind":13,"line":1418,"name":"$branch","containerName":"_parse_rst"},{"line":1418,"kind":13,"containerName":"_parse_rst","name":"$node"},{"kind":13,"line":1419,"definition":"my","name":"$tree","containerName":"_parse_rst","localvar":"my"},{"containerName":"_parse_rst","name":"$trees","kind":13,"line":1419},{"name":"$tree","containerName":"_parse_rst","kind":13,"line":1420},{"kind":13,"line":1421,"name":"$self","containerName":"_parse_rst"},{"name":"warn","containerName":"_parse_rst","line":1421,"kind":12},{"kind":13,"line":1424,"definition":"my","name":"@nodes","containerName":"_parse_rst","localvar":"my"},{"name":"$a","containerName":"_parse_rst","line":1425,"kind":13},{"line":1425,"kind":13,"containerName":"_parse_rst","name":"$b"},{"line":1426,"kind":12,"name":"id","containerName":"_parse_rst"},{"kind":13,"line":1426,"containerName":"_parse_rst","name":"$tree"},{"line":1426,"kind":12,"containerName":"_parse_rst","name":"get_nodes"},{"containerName":"_parse_rst","name":"@nodes","kind":13,"line":1427},{"kind":13,"line":1428,"containerName":"_parse_rst","name":"$rstio"},{"kind":12,"line":1428,"containerName":"_parse_rst","name":"_readline"},{"containerName":"_parse_rst","name":"$rstio","line":1431,"kind":13},{"kind":12,"line":1431,"containerName":"_parse_rst","name":"_pushback"},{"localvar":"my","definition":"my","name":"$left","containerName":"_parse_rst","line":1434,"kind":13},{"containerName":"_parse_rst","name":"$right","kind":13,"line":1434},{"name":"$branch","containerName":"_parse_rst","kind":13,"line":1435},{"line":1435,"kind":13,"name":"$left","containerName":"_parse_rst"},{"kind":13,"line":1435,"name":"$right","containerName":"_parse_rst"},{"name":"$node","containerName":"_parse_rst","line":1436,"kind":13},{"kind":13,"line":1436,"containerName":"_parse_rst","name":"$nodes"},{"name":"$right","containerName":"_parse_rst","line":1436,"kind":13},{"containerName":"_parse_rst","name":"$node","line":1437,"kind":13},{"kind":13,"line":1438,"name":"$self","containerName":"_parse_rst"},{"line":1438,"kind":12,"containerName":"_parse_rst","name":"warn"},{"containerName":"_parse_rst","name":"$node","line":1442,"kind":13},{"kind":12,"line":1442,"containerName":"_parse_rst","name":"add_tag_value"},{"line":1443,"kind":13,"containerName":"_parse_rst","name":"$node"},{"line":1443,"kind":12,"containerName":"_parse_rst","name":"add_tag_value"},{"containerName":"_parse_rst","name":"$branch2node","kind":13,"line":1445},{"kind":13,"line":1445,"name":"$branch","containerName":"_parse_rst"},{"line":1445,"kind":13,"name":"$right","containerName":"_parse_rst"},{"line":1447,"kind":13,"localvar":"my","name":"$site","definition":"my","containerName":"_parse_rst"},{"kind":13,"line":1447,"containerName":"_parse_rst","name":"$anc"},{"kind":13,"line":1447,"containerName":"_parse_rst","name":"$aprob"},{"kind":13,"line":1447,"name":"$derived","containerName":"_parse_rst"},{"containerName":"_parse_rst","name":"$dprob","kind":13,"line":1447},{"containerName":"_parse_rst","name":"$node","kind":13,"line":1448},{"containerName":"_parse_rst","name":"$self","kind":13,"line":1449},{"kind":12,"line":1449,"name":"warn","containerName":"_parse_rst"},{"localvar":"my","definition":"my","name":"%c","containerName":"_parse_rst","line":1452,"kind":13},{"line":1452,"kind":13,"containerName":"_parse_rst","name":"$site"},{"name":"$anc","containerName":"_parse_rst","line":1453,"kind":13},{"name":"$aprob","containerName":"_parse_rst","line":1454,"kind":13},{"containerName":"_parse_rst","name":"$derived","line":1455,"kind":13},{"name":"$c","containerName":"_parse_rst","line":1457,"kind":13},{"line":1457,"kind":13,"containerName":"_parse_rst","name":"$dprob"},{"kind":13,"line":1457,"name":"$dprob","containerName":"_parse_rst"},{"name":"$node","containerName":"_parse_rst","line":1458,"kind":13},{"kind":12,"line":1458,"name":"add_tag_value","containerName":"_parse_rst"},{"line":1458,"kind":13,"name":"%c","containerName":"_parse_rst"},{"containerName":"_parse_rst","definition":"my","name":"$line","localvar":"my","kind":13,"line":1463},{"name":"$rstio","containerName":"_parse_rst","kind":13,"line":1463},{"line":1463,"kind":12,"name":"_readline","containerName":"_parse_rst"},{"line":1464,"kind":13,"containerName":"_parse_rst","name":"$line"},{"containerName":"_parse_rst","name":"$line","line":1464,"kind":13},{"kind":13,"line":1465,"containerName":"_parse_rst","name":"@overall_site","definition":"my","localvar":"my"},{"name":"$line","containerName":"_parse_rst","kind":13,"line":1465},{"containerName":"_parse_rst","name":"$line","line":1468,"kind":13},{"name":"$rstio","containerName":"_parse_rst","line":1468,"kind":13},{"containerName":"_parse_rst","name":"_readline","line":1468,"kind":12},{"name":"$line","containerName":"_parse_rst","kind":13,"line":1470},{"name":"$line","containerName":"_parse_rst","line":1470,"kind":13},{"kind":13,"line":1471,"definition":"my","name":"@overall_seq","containerName":"_parse_rst","localvar":"my"},{"line":1471,"kind":13,"name":"$line","containerName":"_parse_rst"},{"line":1472,"kind":13,"name":"@overall_seq","containerName":"_parse_rst"},{"kind":13,"line":1472,"containerName":"_parse_rst","name":"@overall_site"},{"containerName":"_parse_rst","name":"@overall_seq","line":1473,"kind":13},{"name":"@seqs","containerName":"_parse_rst","kind":13,"line":1473},{"line":1474,"kind":13,"name":"$self","containerName":"_parse_rst"},{"kind":12,"line":1474,"containerName":"_parse_rst","name":"warn"},{"name":"$self","containerName":"_parse_rst","line":1475,"kind":13},{"containerName":"_parse_rst","name":"warn","line":1475,"kind":12},{"containerName":"_parse_rst","name":"@seqs","line":1477,"kind":13},{"kind":12,"line":1478,"name":"description","containerName":"_parse_rst"},{"kind":13,"line":1479,"containerName":"_parse_rst","name":"@overall_site"},{"containerName":"_parse_rst","name":"@overall_seq","kind":13,"line":1480},{"line":1483,"kind":13,"localvar":"my","containerName":"_parse_rst","definition":"my","name":"$seqcount"},{"containerName":"_parse_rst","name":"$rstio","kind":13,"line":1484},{"kind":12,"line":1484,"containerName":"_parse_rst","name":"_readline"},{"containerName":"_parse_rst","name":"$seqcount","line":1487,"kind":13},{"kind":13,"line":1487,"name":"$seqcount","containerName":"_parse_rst"},{"name":"@seqs","containerName":"_parse_rst","kind":13,"line":1487},{"line":1490,"kind":13,"name":"$seqcount","containerName":"_parse_rst"},{"line":1495,"kind":13,"localvar":"my","containerName":"_parse_rst","definition":"my","name":"$name"},{"kind":13,"line":1495,"name":"$num","containerName":"_parse_rst"},{"containerName":"_parse_rst","name":"$seqstr","line":1495,"kind":13},{"line":1496,"kind":13,"containerName":"_parse_rst","name":"$name"},{"line":1496,"kind":13,"name":"$num","containerName":"_parse_rst"},{"kind":13,"line":1497,"containerName":"_parse_rst","name":"$seqstr"},{"containerName":"_parse_rst","name":"@firstseq","line":1498,"kind":13},{"kind":13,"line":1499,"containerName":"_parse_rst","name":"@firstseq"},{"containerName":"_parse_rst","name":"$seqstr","kind":13,"line":1499},{"line":1500,"kind":13,"name":"@seqs","containerName":"_parse_rst"},{"line":1500,"kind":12,"containerName":"_parse_rst","name":"new"},{"name":"$name","containerName":"_parse_rst","line":1500,"kind":13},{"kind":13,"line":1501,"name":"$seqstr","containerName":"_parse_rst"},{"kind":13,"line":1503,"definition":"my","name":"$i","containerName":"_parse_rst","localvar":"my"},{"localvar":"my","definition":"my","name":"$v","containerName":"_parse_rst","line":1504,"kind":13},{"containerName":"_parse_rst","name":"$v","kind":13,"line":1505},{"line":1505,"kind":13,"containerName":"_parse_rst","name":"$seqstr"},{"line":1505,"kind":13,"containerName":"_parse_rst","name":"$i"},{"name":"$i","containerName":"_parse_rst","line":1505,"kind":13},{"containerName":"_parse_rst","name":"$seqstr","kind":13,"line":1507},{"containerName":"_parse_rst","name":"$v","kind":13,"line":1507},{"kind":13,"line":1507,"containerName":"_parse_rst","name":"$firstseq"},{"name":"$v","containerName":"_parse_rst","kind":13,"line":1507},{"containerName":"_parse_rst","name":"$i","line":1508,"kind":13},{"line":1508,"kind":13,"name":"$v","containerName":"_parse_rst"},{"kind":13,"line":1510,"containerName":"_parse_rst","name":"$self"},{"kind":12,"line":1510,"containerName":"_parse_rst","name":"debug"},{"kind":13,"line":1511,"name":"@seqs","containerName":"_parse_rst"},{"line":1512,"kind":12,"name":"new","containerName":"_parse_rst"},{"kind":13,"line":1512,"containerName":"_parse_rst","name":"$name"},{"kind":13,"line":1513,"name":"$seqstr","containerName":"_parse_rst"},{"containerName":"_parse_rst","name":"$self","line":1517,"kind":13},{"line":1517,"kind":13,"name":"@seqs","containerName":"_parse_rst"},{"containerName":"_parse_rst","name":"$self","kind":13,"line":1521},{"line":1521,"kind":13,"name":"@trees","containerName":"_parse_rst"}],"line":1353,"kind":12,"range":{"end":{"line":1523,"character":9999},"start":{"line":1353,"character":0}},"name":"_parse_rst"},{"kind":12,"line":1357,"name":"File","containerName":"Spec"},{"containerName":"Root::IO","name":"Bio","kind":12,"line":1359},{"line":1371,"kind":12,"name":"Bio","containerName":"TreeIO"},{"line":1500,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"containerName":"LocatableSeq","name":"Bio","line":1511,"kind":12}]}