{"version":5,"vars":[{"containerName":"","name":"base","line":86,"kind":2},{"name":"new","range":{"end":{"character":9999,"line":107},"start":{"character":0,"line":100}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Gumby.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Gumby\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Gumby - Parses output from gumby\n\n=head1 SYNOPSIS\n\n  #!/usr/bin/perl -Tw\n  use strict;\n\n  use Bio::Tools::Phylo::Gumby;\n\n  my $parser = Bio::Tools::Phylo::Gumby->new(-file => \"out.align\");\n  my @features = $parser->next_result();\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from 'gumby' by Shyam Prabhakar. You\ncan get details here: http://pga.lbl.gov/gumby/\n\nIt works on the .align files produced.\n\nThe result is a list of feature objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Phylo::Gumby;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Gumby->new();\n Function: Builds a new Bio::Tools::Phylo::Gumby object\n Returns : Bio::Tools::Phylo::Gumby\n Args    : -file (or -fh) should contain the contents of a gumby .align output\n           file","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":100,"children":[{"kind":13,"line":101,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"line":101,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","name":"$self","definition":"my","line":102,"kind":13},{"containerName":"new","name":"$class","line":102,"kind":13},{"line":102,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","line":104,"kind":13},{"containerName":"new","name":"_initialize_io","line":104,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":104},{"kind":13,"line":106,"name":"$self","containerName":"new"}]},{"name":"SUPER","containerName":"new","kind":12,"line":102},{"kind":12,"line":128,"children":[{"localvar":"my","containerName":"next_result","name":"$self","definition":"my","line":129,"kind":13},{"localvar":"my","name":"$line","definition":"my","containerName":"next_result","line":131,"kind":13},{"name":"$self","containerName":"next_result","line":131,"kind":13},{"containerName":"next_result","name":"_readline","kind":12,"line":131},{"containerName":"next_result","name":"$line","kind":13,"line":132},{"name":"$line","containerName":"next_result","line":133,"kind":13},{"containerName":"next_result","name":"$self","kind":13,"line":133},{"kind":12,"line":133,"containerName":"next_result","name":"_readline"},{"name":"$line","containerName":"next_result","kind":13,"line":135},{"line":136,"kind":13,"containerName":"next_result","name":"$self"},{"kind":13,"line":140,"definition":"my","name":"$score","containerName":"next_result","localvar":"my"},{"kind":13,"line":140,"name":"$pvalue","containerName":"next_result"},{"containerName":"next_result","name":"$line","kind":13,"line":140},{"kind":13,"line":142,"containerName":"next_result","definition":"my","name":"@feats","localvar":"my"},{"line":143,"kind":13,"containerName":"next_result","name":"$line"},{"kind":13,"line":143,"name":"$self","containerName":"next_result"},{"line":143,"kind":12,"name":"_readline","containerName":"next_result"},{"line":144,"kind":13,"name":"$line","containerName":"next_result"},{"name":"$line","containerName":"next_result","line":145,"kind":13},{"kind":13,"line":146,"containerName":"next_result","definition":"my","name":"$seq_id","localvar":"my"},{"line":146,"kind":13,"name":"$start","containerName":"next_result"},{"kind":13,"line":146,"containerName":"next_result","name":"$end"},{"kind":13,"line":146,"name":"$line","containerName":"next_result"},{"line":148,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$feature"},{"name":"new","containerName":"next_result","kind":12,"line":148},{"kind":13,"line":148,"containerName":"next_result","name":"$seq_id"},{"containerName":"next_result","name":"$start","line":149,"kind":13},{"containerName":"next_result","name":"$end","kind":13,"line":150},{"containerName":"next_result","name":"$score","line":151,"kind":13},{"localvar":"my","containerName":"next_result","name":"$sv","definition":"my","line":154,"kind":13},{"containerName":"next_result","name":"new","kind":12,"line":154},{"line":154,"kind":13,"containerName":"next_result","name":"$pvalue"},{"kind":13,"line":155,"name":"$feature","containerName":"next_result"},{"containerName":"next_result","name":"annotation","line":155,"kind":12},{"name":"add_Annotation","containerName":"next_result","line":155,"kind":12},{"containerName":"next_result","name":"$sv","kind":13,"line":155},{"containerName":"next_result","name":"$sv","kind":13,"line":156},{"containerName":"next_result","name":"new","kind":12,"line":156},{"name":"$self","containerName":"next_result","kind":13,"line":156},{"kind":13,"line":157,"containerName":"next_result","name":"$feature"},{"containerName":"next_result","name":"annotation","kind":12,"line":157},{"kind":12,"line":157,"containerName":"next_result","name":"add_Annotation"},{"containerName":"next_result","name":"$sv","line":157,"kind":13},{"kind":13,"line":158,"containerName":"next_result","name":"$sv"},{"kind":12,"line":158,"name":"new","containerName":"next_result"},{"kind":13,"line":159,"name":"$feature","containerName":"next_result"},{"name":"annotation","containerName":"next_result","kind":12,"line":159},{"containerName":"next_result","name":"add_Annotation","kind":12,"line":159},{"kind":13,"line":159,"name":"$sv","containerName":"next_result"},{"containerName":"next_result","name":"@feats","line":161,"kind":13},{"kind":13,"line":161,"name":"$feature","containerName":"next_result"},{"containerName":"next_result","name":"@feats","kind":13,"line":164}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Gumby.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Gumby\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Gumby - Parses output from gumby\n\n=head1 SYNOPSIS\n\n  #!/usr/bin/perl -Tw\n  use strict;\n\n  use Bio::Tools::Phylo::Gumby;\n\n  my $parser = Bio::Tools::Phylo::Gumby->new(-file => \"out.align\");\n  my @features = $parser->next_result();\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from 'gumby' by Shyam Prabhakar. You\ncan get details here: http://pga.lbl.gov/gumby/\n\nIt works on the .align files produced.\n\nThe result is a list of feature objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Phylo::Gumby;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Gumby->new();\n Function: Builds a new Bio::Tools::Phylo::Gumby object\n Returns : Bio::Tools::Phylo::Gumby\n Args    : -file (or -fh) should contain the contents of a gumby .align output\n           file\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->_initialize_io(@args);\n    \n    return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = $obj->next_result();\n Function: Returns the next set of results available from the input, or undef if\n           there are no more results.\n Returns : list of Bio::SeqFeature::Annotated (one per sequence). Features are\n           annotated with tags for pvalue and 'kind' (holding 'all', 'exon', or\n           'nonexon').\n\n           NB: Gumby ignores sequence coordinates in input alignments, treating\n           each sequence as if it started at position 1. If you're running this\n           manually (ie. not via the Bio::Tools::Run::Phylo::Gumby) you will\n           have to adjust the coordinates to match up with your input alignment\n           and sequences.\n Args    : none","parameters":[{"label":"$self"}]},"name":"next_result","range":{"end":{"line":165,"character":9999},"start":{"character":0,"line":128}}},{"name":"_kind","line":136,"kind":12},{"name":"Bio","containerName":"SeqFeature::Annotated","kind":12,"line":148},{"containerName":"Annotation::SimpleValue","name":"Bio","line":154,"kind":12},{"line":156,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"name":"_kind","kind":12,"line":156},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":158}]}