{"vars":[{"name":"base","containerName":"","line":93,"kind":2},{"name":"new","range":{"end":{"line":113,"character":9999},"start":{"line":106,"character":0}},"kind":12,"children":[{"line":107,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"kind":13,"line":107,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":108,"kind":13},{"name":"$class","containerName":"new","line":108,"kind":13},{"kind":13,"line":108,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":110},{"kind":12,"line":110,"containerName":"new","name":"_initialize_io"},{"kind":13,"line":110,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":112,"kind":13}],"line":106,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Gumby.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Phylo::Gerp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Gerp - Parses output from GERP\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Phylo::Gerp;\n\n  my $parser = Bio::Tools::Phylo::Gerp->new(-file => \"alignment.rates.elems\");\n\n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $rs_score = $feat->score;\n    my $p_value = ($feat->annotation->get_Annotations('p-value'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from 'GERP' (v2) by Eugene Davydov\n(originally Gregory M. Cooper et al.). You can get details here:\nhttp://mendel.stanford.edu/sidowlab/\n\nIt works on the .elems files produced by gerpelem.\n\nEach result is a Bio::SeqFeature::Annotated representing a single constrained\nelement.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Phylo::Gerp;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Gerp->new();\n Function: Builds a new Bio::Tools::Phylo::Gerp object\n Returns : Bio::Tools::Phylo::Gerp\n Args    : -file (or -fh) should contain the contents of a gerpelem .elems file","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)"},{"name":"SUPER","containerName":"new","kind":12,"line":108},{"definition":"sub","containerName":"main::","signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Gumby.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Phylo::Gerp\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Gerp - Parses output from GERP\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Phylo::Gerp;\n\n  my $parser = Bio::Tools::Phylo::Gerp->new(-file => \"alignment.rates.elems\");\n\n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $rs_score = $feat->score;\n    my $p_value = ($feat->annotation->get_Annotations('p-value'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from 'GERP' (v2) by Eugene Davydov\n(originally Gregory M. Cooper et al.). You can get details here:\nhttp://mendel.stanford.edu/sidowlab/\n\nIt works on the .elems files produced by gerpelem.\n\nEach result is a Bio::SeqFeature::Annotated representing a single constrained\nelement.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Phylo::Gerp;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Gerp->new();\n Function: Builds a new Bio::Tools::Phylo::Gerp object\n Returns : Bio::Tools::Phylo::Gerp\n Args    : -file (or -fh) should contain the contents of a gerpelem .elems file\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->_initialize_io(@args);\n    \n    return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = $obj->next_result();\n Function: Returns the next result available from the input, or undef if there\n           are no more results.\n Returns : Bio::SeqFeature::Annotated object. Features are annotated with a tag\n           for 'pvalue', and a 'predicted' tag. They have no sequence id unless\n           the input GERP file is non-standard, with the seq id as the 6th\n           column.\n\n           NB: feature coordinates are alignment columns of the alignment\n           used to create the result file.\n Args    : none"},"detail":"($self)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":133},{"localvar":"my","name":"$line","definition":"my","containerName":"next_result","line":135,"kind":13},{"kind":13,"line":135,"containerName":"next_result","name":"$self"},{"line":135,"kind":12,"name":"_readline","containerName":"next_result"},{"line":137,"kind":13,"containerName":"next_result","name":"$line"},{"kind":13,"line":138,"name":"$line","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":138,"kind":13},{"kind":12,"line":138,"containerName":"next_result","name":"_readline"},{"line":144,"kind":13,"localvar":"my","name":"$start","definition":"my","containerName":"next_result"},{"name":"$end","containerName":"next_result","kind":13,"line":144},{"kind":13,"line":144,"containerName":"next_result","name":"$rs_score"},{"kind":13,"line":144,"containerName":"next_result","name":"$p_value"},{"line":144,"kind":13,"containerName":"next_result","name":"$seq_id"},{"name":"$line","containerName":"next_result","kind":13,"line":144},{"containerName":"next_result","name":"$feat","definition":"my","localvar":"my","kind":13,"line":145},{"name":"new","containerName":"next_result","line":145,"kind":12},{"name":"$seq_id","containerName":"next_result","line":146,"kind":13},{"kind":13,"line":146,"name":"$seq_id","containerName":"next_result"},{"name":"$start","containerName":"next_result","line":147,"kind":13},{"line":148,"kind":13,"containerName":"next_result","name":"$end"},{"name":"$rs_score","containerName":"next_result","kind":13,"line":150},{"kind":13,"line":154,"name":"$sv","definition":"my","containerName":"next_result","localvar":"my"},{"name":"new","containerName":"next_result","line":154,"kind":12},{"line":155,"kind":13,"name":"$feat","containerName":"next_result"},{"name":"annotation","containerName":"next_result","line":155,"kind":12},{"name":"add_Annotation","containerName":"next_result","line":155,"kind":12},{"kind":13,"line":155,"containerName":"next_result","name":"$sv"},{"containerName":"next_result","name":"$sv","line":156,"kind":13},{"line":156,"kind":12,"name":"new","containerName":"next_result"},{"containerName":"next_result","name":"$p_value","line":156,"kind":13},{"kind":13,"line":157,"containerName":"next_result","name":"$feat"},{"containerName":"next_result","name":"annotation","kind":12,"line":157},{"line":157,"kind":12,"containerName":"next_result","name":"add_Annotation"},{"containerName":"next_result","name":"$sv","line":157,"kind":13},{"line":159,"kind":13,"name":"$feat","containerName":"next_result"}],"line":132,"name":"next_result","range":{"start":{"character":0,"line":132},"end":{"line":160,"character":9999}}},{"containerName":"SeqFeature::Annotated","name":"Bio","kind":12,"line":145},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":154},{"containerName":"Annotation::SimpleValue","name":"Bio","line":156,"kind":12}],"version":5}