{"version":5,"vars":[{"containerName":"","name":"base","line":136,"kind":2},{"name":"new","range":{"end":{"line":157,"character":9999},"start":{"character":0,"line":138}},"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":140,"kind":13},{"kind":13,"line":140,"name":"@args","containerName":"new"},{"kind":13,"line":142,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","kind":13,"line":142},{"kind":13,"line":142,"containerName":"new","name":"@args"},{"kind":13,"line":144,"containerName":"new","definition":"my","name":"$seqobj","localvar":"my"},{"line":144,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":144,"kind":12},{"kind":13,"line":144,"containerName":"new","name":"@args"},{"name":"$seqobj","containerName":"new","kind":13,"line":145},{"name":"@args","containerName":"new","kind":13,"line":145},{"containerName":"new","name":"$args","kind":13,"line":145},{"containerName":"new","name":"$seqobj","line":147,"kind":13},{"containerName":"new","name":"$args","kind":13,"line":147},{"containerName":"new","name":"$seqobj","kind":13,"line":149},{"line":149,"kind":12,"name":"isa","containerName":"new"},{"kind":13,"line":151,"containerName":"new","name":"$self"},{"kind":12,"line":151,"containerName":"new","name":"throw"},{"kind":13,"line":154,"name":"$self","containerName":"new"},{"line":154,"kind":13,"name":"$seqobj","containerName":"new"},{"kind":13,"line":156,"name":"$self","containerName":"new"}],"line":138},{"line":142,"kind":12,"name":"SUPER","containerName":"new"},{"range":{"start":{"line":171,"character":0},"end":{"character":9999,"line":188}},"name":"structural","detail":"()","signature":{"parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none","label":"structural()"},"containerName":"main::","definition":"sub","line":171,"children":[{"localvar":"my","containerName":"structural","name":"$self","definition":"my","line":173,"kind":13},{"containerName":"structural","name":"$seqstring","definition":"my","localvar":"my","kind":13,"line":174},{"containerName":"structural","name":"$self","line":174,"kind":13},{"kind":13,"line":178,"containerName":"structural","name":"$seqstring"},{"line":179,"kind":13,"name":"$seqstring","containerName":"structural"},{"containerName":"structural","name":"$seqstring","line":180,"kind":13},{"name":"$seqstring","containerName":"structural","line":181,"kind":13},{"line":182,"kind":13,"containerName":"structural","name":"$seqstring"},{"name":"$seqstring","containerName":"structural","line":183,"kind":13},{"line":185,"kind":13,"name":"$seqstring","containerName":"structural"}],"kind":12},{"name":"_pullseq","line":174,"kind":12},{"detail":"()","signature":{"label":"functional()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none"},"containerName":"main::","definition":"sub","line":202,"children":[{"containerName":"functional","name":"$self","definition":"my","localvar":"my","kind":13,"line":204},{"containerName":"functional","name":"$seqstring","definition":"my","localvar":"my","kind":13,"line":205},{"kind":13,"line":205,"containerName":"functional","name":"$self"},{"kind":13,"line":209,"name":"$seqstring","containerName":"functional"},{"name":"$seqstring","containerName":"functional","line":210,"kind":13},{"containerName":"functional","name":"$seqstring","kind":13,"line":211},{"containerName":"functional","name":"$seqstring","kind":13,"line":212},{"name":"$seqstring","containerName":"functional","kind":13,"line":213},{"line":214,"kind":13,"name":"$seqstring","containerName":"functional"},{"kind":13,"line":215,"name":"$seqstring","containerName":"functional"},{"line":216,"kind":13,"name":"$seqstring","containerName":"functional"},{"line":218,"kind":13,"name":"$seqstring","containerName":"functional"}],"kind":12,"range":{"end":{"line":221,"character":9999},"start":{"character":0,"line":202}},"name":"functional"},{"name":"_pullseq","kind":12,"line":205},{"range":{"end":{"character":9999,"line":250},"start":{"line":235,"character":0}},"name":"hydrophobic","line":235,"children":[{"name":"$self","definition":"my","containerName":"hydrophobic","localvar":"my","kind":13,"line":237},{"localvar":"my","containerName":"hydrophobic","definition":"my","name":"$seqstring","line":238,"kind":13},{"name":"$self","containerName":"hydrophobic","kind":13,"line":238},{"name":"$seqstring","containerName":"hydrophobic","line":242,"kind":13},{"containerName":"hydrophobic","name":"$seqstring","line":243,"kind":13},{"kind":13,"line":244,"name":"$seqstring","containerName":"hydrophobic"},{"kind":13,"line":245,"containerName":"hydrophobic","name":"$seqstring"},{"containerName":"hydrophobic","name":"$seqstring","kind":13,"line":247}],"kind":12,"detail":"()","signature":{"label":"hydrophobic()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none"},"containerName":"main::","definition":"sub"},{"line":238,"kind":12,"name":"_pullseq"},{"line":265,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"Dayhoff","line":267,"kind":13},{"localvar":"my","definition":"my","name":"$seqstring","containerName":"Dayhoff","line":268,"kind":13},{"name":"$self","containerName":"Dayhoff","kind":13,"line":268},{"kind":13,"line":272,"containerName":"Dayhoff","name":"$seqstring"},{"kind":13,"line":273,"containerName":"Dayhoff","name":"$seqstring"},{"line":274,"kind":13,"name":"$seqstring","containerName":"Dayhoff"},{"name":"$seqstring","containerName":"Dayhoff","line":275,"kind":13},{"containerName":"Dayhoff","name":"$seqstring","kind":13,"line":276},{"line":277,"kind":13,"containerName":"Dayhoff","name":"$seqstring"},{"name":"$seqstring","containerName":"Dayhoff","line":278,"kind":13},{"name":"$seqstring","containerName":"Dayhoff","line":279,"kind":13},{"containerName":"Dayhoff","name":"$seqstring","kind":13,"line":280},{"containerName":"Dayhoff","name":"$seqstring","kind":13,"line":281},{"kind":13,"line":282,"containerName":"Dayhoff","name":"$seqstring"},{"containerName":"Dayhoff","name":"$seqstring","kind":13,"line":283},{"kind":13,"line":285,"containerName":"Dayhoff","name":"$seqstring"}],"kind":12,"detail":"()","signature":{"parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none","label":"Dayhoff()"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":265},"end":{"line":288,"character":9999}},"name":"Dayhoff"},{"line":268,"kind":12,"name":"_pullseq"},{"containerName":"main::","definition":"sub","detail":"()","signature":{"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none","parameters":[],"label":"Sneath()"},"kind":12,"line":303,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"Sneath","line":305,"kind":13},{"line":306,"kind":13,"localvar":"my","name":"$seqstring","definition":"my","containerName":"Sneath"},{"kind":13,"line":306,"containerName":"Sneath","name":"$self"},{"line":310,"kind":13,"name":"$seqstring","containerName":"Sneath"},{"containerName":"Sneath","name":"$seqstring","line":311,"kind":13},{"containerName":"Sneath","name":"$seqstring","line":312,"kind":13},{"containerName":"Sneath","name":"$seqstring","kind":13,"line":313},{"kind":13,"line":314,"name":"$seqstring","containerName":"Sneath"},{"name":"$seqstring","containerName":"Sneath","line":315,"kind":13},{"containerName":"Sneath","name":"$seqstring","kind":13,"line":316},{"kind":13,"line":317,"containerName":"Sneath","name":"$seqstring"},{"containerName":"Sneath","name":"$seqstring","kind":13,"line":318},{"kind":13,"line":319,"name":"$seqstring","containerName":"Sneath"},{"line":320,"kind":13,"containerName":"Sneath","name":"$seqstring"},{"kind":13,"line":321,"name":"$seqstring","containerName":"Sneath"},{"name":"$seqstring","containerName":"Sneath","kind":13,"line":322},{"name":"$seqstring","containerName":"Sneath","line":323,"kind":13},{"kind":13,"line":325,"containerName":"Sneath","name":"$seqstring"}],"name":"Sneath","range":{"end":{"character":9999,"line":328},"start":{"line":303,"character":0}}},{"name":"_pullseq","line":306,"kind":12},{"name":"Stanfel","range":{"end":{"line":361,"character":9999},"start":{"character":0,"line":342}},"containerName":"main::","definition":"sub","detail":"()","signature":{"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Sneath()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ILV]/1/;\n\t$seqstring =~ tr/[AGP]/2/;\n\t$seqstring =~ tr/[MNQ]/3/;\n\t$seqstring =~ tr/[CST]/4/;\n\t$seqstring =~ tr/[DE]/5/;\n\t$seqstring =~ tr/[KR]/6/;\n\t$seqstring =~ tr/[FHWY]/7/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\t$seqstring =~ tr/7/H/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Stanfel\n\n Title   : Stanfel\n Usage   : $output = $oddcode_obj->Stanfel();\n Function: turns amino acid sequence into 4-letter Stanfel alphabet\n Example : a sequence ACDEFGH will become AACCDAE\n         : A (=ACGILMPSTV), C (=DENQ), D (=FWY), E (=HKR)\n Returns : Reference to the new sequence string\n Args    : none","parameters":[],"label":"Stanfel()"},"kind":12,"line":342,"children":[{"definition":"my","name":"$self","containerName":"Stanfel","localvar":"my","kind":13,"line":344},{"containerName":"Stanfel","name":"$seqstring","definition":"my","localvar":"my","kind":13,"line":345},{"line":345,"kind":13,"containerName":"Stanfel","name":"$self"},{"name":"$seqstring","containerName":"Stanfel","line":349,"kind":13},{"name":"$seqstring","containerName":"Stanfel","line":350,"kind":13},{"name":"$seqstring","containerName":"Stanfel","kind":13,"line":351},{"name":"$seqstring","containerName":"Stanfel","line":352,"kind":13},{"kind":13,"line":353,"containerName":"Stanfel","name":"$seqstring"},{"line":354,"kind":13,"containerName":"Stanfel","name":"$seqstring"},{"line":355,"kind":13,"name":"$seqstring","containerName":"Stanfel"},{"kind":13,"line":356,"containerName":"Stanfel","name":"$seqstring"},{"kind":13,"line":358,"name":"$seqstring","containerName":"Stanfel"}]},{"kind":12,"line":345,"name":"_pullseq"},{"containerName":"main::","definition":"sub","detail":"()","signature":{"label":"chemical()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Sneath()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ILV]/1/;\n\t$seqstring =~ tr/[AGP]/2/;\n\t$seqstring =~ tr/[MNQ]/3/;\n\t$seqstring =~ tr/[CST]/4/;\n\t$seqstring =~ tr/[DE]/5/;\n\t$seqstring =~ tr/[KR]/6/;\n\t$seqstring =~ tr/[FHWY]/7/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\t$seqstring =~ tr/7/H/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Stanfel\n\n Title   : Stanfel\n Usage   : $output = $oddcode_obj->Stanfel();\n Function: turns amino acid sequence into 4-letter Stanfel alphabet\n Example : a sequence ACDEFGH will become AACCDAE\n         : A (=ACGILMPSTV), C (=DENQ), D (=FWY), E (=HKR)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Stanfel()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGILMPSTV]/1/;\n\t$seqstring =~ tr/[DENQ]/2/;\n\t$seqstring =~ tr/[FWY]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 chemical\n\n Title   : chemical\n Usage   : $output = $oddcode_obj->chemical();\n Function: turns amino acid sequence into 8-letter chemical alphabet\n\t : A (acidic), L (aliphatic), M (amide), R (aromatic)\n\t : C (basic),  H (hydroxyl),  I (imino), S (sulphur)\n Example : a sequence ACDEFGH will become LSAARAC\n Returns : Reference to the new sequence string\n Args    : none"},"kind":12,"line":376,"children":[{"localvar":"my","containerName":"chemical","definition":"my","name":"$self","line":378,"kind":13},{"localvar":"my","containerName":"chemical","name":"$seqstring","definition":"my","line":379,"kind":13},{"name":"$self","containerName":"chemical","line":379,"kind":13},{"kind":13,"line":383,"name":"$seqstring","containerName":"chemical"},{"kind":13,"line":384,"containerName":"chemical","name":"$seqstring"},{"name":"$seqstring","containerName":"chemical","kind":13,"line":385},{"containerName":"chemical","name":"$seqstring","kind":13,"line":386},{"containerName":"chemical","name":"$seqstring","kind":13,"line":387},{"containerName":"chemical","name":"$seqstring","line":388,"kind":13},{"name":"$seqstring","containerName":"chemical","line":389,"kind":13},{"line":390,"kind":13,"containerName":"chemical","name":"$seqstring"},{"kind":13,"line":391,"containerName":"chemical","name":"$seqstring"},{"name":"$seqstring","containerName":"chemical","kind":13,"line":392},{"name":"$seqstring","containerName":"chemical","kind":13,"line":393},{"kind":13,"line":394,"name":"$seqstring","containerName":"chemical"},{"kind":13,"line":395,"name":"$seqstring","containerName":"chemical"},{"containerName":"chemical","name":"$seqstring","line":396,"kind":13},{"name":"$seqstring","containerName":"chemical","kind":13,"line":397},{"line":398,"kind":13,"name":"$seqstring","containerName":"chemical"},{"name":"$seqstring","containerName":"chemical","kind":13,"line":400}],"name":"chemical","range":{"start":{"line":376,"character":0},"end":{"character":9999,"line":403}}},{"name":"_pullseq","line":379,"kind":12},{"line":417,"children":[{"kind":13,"line":419,"name":"$self","definition":"my","containerName":"charge","localvar":"my"},{"kind":13,"line":420,"definition":"my","name":"$seqstring","containerName":"charge","localvar":"my"},{"containerName":"charge","name":"$self","line":420,"kind":13},{"kind":13,"line":424,"name":"$seqstring","containerName":"charge"},{"kind":13,"line":425,"name":"$seqstring","containerName":"charge"},{"containerName":"charge","name":"$seqstring","line":426,"kind":13},{"kind":13,"line":427,"containerName":"charge","name":"$seqstring"},{"name":"$seqstring","containerName":"charge","kind":13,"line":428},{"line":429,"kind":13,"name":"$seqstring","containerName":"charge"},{"kind":13,"line":431,"containerName":"charge","name":"$seqstring"}],"kind":12,"detail":"()","signature":{"parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Sneath()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ILV]/1/;\n\t$seqstring =~ tr/[AGP]/2/;\n\t$seqstring =~ tr/[MNQ]/3/;\n\t$seqstring =~ tr/[CST]/4/;\n\t$seqstring =~ tr/[DE]/5/;\n\t$seqstring =~ tr/[KR]/6/;\n\t$seqstring =~ tr/[FHWY]/7/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\t$seqstring =~ tr/7/H/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Stanfel\n\n Title   : Stanfel\n Usage   : $output = $oddcode_obj->Stanfel();\n Function: turns amino acid sequence into 4-letter Stanfel alphabet\n Example : a sequence ACDEFGH will become AACCDAE\n         : A (=ACGILMPSTV), C (=DENQ), D (=FWY), E (=HKR)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Stanfel()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGILMPSTV]/1/;\n\t$seqstring =~ tr/[DENQ]/2/;\n\t$seqstring =~ tr/[FWY]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 chemical\n\n Title   : chemical\n Usage   : $output = $oddcode_obj->chemical();\n Function: turns amino acid sequence into 8-letter chemical alphabet\n\t : A (acidic), L (aliphatic), M (amide), R (aromatic)\n\t : C (basic),  H (hydroxyl),  I (imino), S (sulphur)\n Example : a sequence ACDEFGH will become LSAARAC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub chemical()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[AGILV]/2/;\n\t$seqstring =~ tr/[NQ]/3/;\n\t$seqstring =~ tr/[FWY]/4/;\n\t$seqstring =~ tr/[RHK]/5/;\n\t$seqstring =~ tr/[ST]/6/;\n\t$seqstring =~ tr/P/7/;\n\t$seqstring =~ tr/[CM]/8/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/L/;\n\t$seqstring =~ tr/3/M/;\n\t$seqstring =~ tr/4/R/;\n\t$seqstring =~ tr/5/C/;\n\t$seqstring =~ tr/6/H/;\n\t$seqstring =~ tr/7/I/;\n\t$seqstring =~ tr/8/S/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 charge\n\n Title   : charge\n Usage   : $output = $oddcode_obj->charge();\n Function: turns amino acid sequence into 3-letter charge alphabet\n Example : a sequence ACDEFGH will become NNAANNC\n         : A (negative; NOT anode), C (positive; NOT cathode), N (neutral)\n Returns : Reference to the new sequence string\n Args    : none","label":"charge()"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":417},"end":{"character":9999,"line":434}},"name":"charge"},{"line":420,"kind":12,"name":"_pullseq"},{"name":"_pullseq","definition":"sub","containerName":"main::","range":{"end":{"line":460,"character":9999},"start":{"line":439,"character":0}},"kind":12,"children":[{"kind":13,"line":441,"name":"$self","definition":"my","containerName":"_pullseq","localvar":"my"},{"kind":13,"line":443,"containerName":"_pullseq","definition":"my","name":"$seqobj","localvar":"my"},{"name":"$self","containerName":"_pullseq","kind":13,"line":443},{"kind":13,"line":445,"containerName":"_pullseq","name":"$seqobj"},{"kind":12,"line":445,"containerName":"_pullseq","name":"isa"},{"containerName":"_pullseq","name":"$self","line":447,"kind":13},{"name":"throw","containerName":"_pullseq","kind":12,"line":447},{"line":449,"kind":13,"containerName":"_pullseq","name":"$self"},{"kind":12,"line":449,"name":"warn","containerName":"_pullseq"},{"line":450,"kind":13,"containerName":"_pullseq","name":"$seqobj"},{"name":"id","containerName":"_pullseq","line":450,"kind":12},{"name":"$seqobj","containerName":"_pullseq","kind":13,"line":451},{"containerName":"_pullseq","name":"alphabet","line":451,"kind":12},{"line":451,"kind":13,"containerName":"_pullseq","name":"$self"},{"line":451,"kind":12,"name":"verbose","containerName":"_pullseq"},{"definition":"my","name":"$seqstring","containerName":"_pullseq","localvar":"my","kind":13,"line":453},{"kind":13,"line":453,"containerName":"_pullseq","name":"$seqobj"},{"name":"seq","containerName":"_pullseq","line":453,"kind":12},{"name":"$seqstring","containerName":"_pullseq","line":455,"kind":13},{"containerName":"_pullseq","name":"$self","kind":13,"line":457},{"containerName":"_pullseq","name":"throw","kind":12,"line":457},{"kind":13,"line":459,"name":"$seqstring","containerName":"_pullseq"}],"line":439}]}