{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":90},{"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Match.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Match\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Match - Parses output from Transfac's match(TM)\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Match;\n\n  my $parser = Bio::Tools::Match->new(-file => \"match.out\");\n  \n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $core_score = $feat->score;\n    my $matrix_score = ($feat->annotation->get_Annotations('matrix_score'))[0]->value;\n    my $matrix_id = ($feat->annotation->get_Annotations('matrix_id'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from Transfac's match(TM) program. It\ndoesn't support the histogram output of match.\n\nEach result is a Bio::SeqFeature::Annotated representing a single matrix match.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Match;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Match->new();\n Function: Builds a new Bio::Tools::Match object\n Returns : Bio::Tools::Match\n Args    : -file (or -fh) should contain the contents of a standard match output"},"detail":"($class,@args)","kind":12,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":104,"kind":13},{"line":104,"kind":13,"name":"@args","containerName":"new"},{"line":105,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"containerName":"new","name":"$class","line":105,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":105},{"containerName":"new","name":"$self","line":107,"kind":13},{"line":107,"kind":12,"name":"_initialize_io","containerName":"new"},{"line":107,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":109}],"line":103,"name":"new","range":{"start":{"character":0,"line":103},"end":{"line":110,"character":9999}}},{"line":105,"kind":12,"name":"SUPER","containerName":"new"},{"name":"next_result","range":{"start":{"line":124,"character":0},"end":{"character":9999,"line":182}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Match.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Match\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Match - Parses output from Transfac's match(TM)\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Match;\n\n  my $parser = Bio::Tools::Match->new(-file => \"match.out\");\n  \n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $core_score = $feat->score;\n    my $matrix_score = ($feat->annotation->get_Annotations('matrix_score'))[0]->value;\n    my $matrix_id = ($feat->annotation->get_Annotations('matrix_id'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from Transfac's match(TM) program. It\ndoesn't support the histogram output of match.\n\nEach result is a Bio::SeqFeature::Annotated representing a single matrix match.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Match;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Match->new();\n Function: Builds a new Bio::Tools::Match object\n Returns : Bio::Tools::Match\n Args    : -file (or -fh) should contain the contents of a standard match output\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->_initialize_io(@args);\n    \n    return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = $obj->next_result();\n Function: Returns the next result available from the input, or undef if there\n           are no more results.\n Returns : Bio::SeqFeature::Annotated object. Features are annotated with tags\n           for 'matrix_score', 'matrix_id' and a 'predicted' tag.\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":124,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_result","line":125,"kind":13},{"localvar":"my","definition":"my","name":"$line","containerName":"next_result","line":127,"kind":13},{"name":"$self","containerName":"next_result","line":127,"kind":13},{"containerName":"next_result","name":"_readline","line":127,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":129},{"kind":13,"line":129,"name":"$line","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":130},{"line":133,"kind":13,"containerName":"next_result","name":"$line"},{"containerName":"next_result","name":"$line","kind":13,"line":134},{"line":134,"kind":13,"name":"$self","containerName":"next_result"},{"line":134,"kind":12,"name":"_readline","containerName":"next_result"},{"kind":13,"line":165,"definition":"my","name":"$matrix_id","containerName":"next_result","localvar":"my"},{"line":165,"kind":13,"name":"$start","containerName":"next_result"},{"containerName":"next_result","name":"$strand","kind":13,"line":165},{"containerName":"next_result","name":"$core_score","line":165,"kind":13},{"name":"$matrix_score","containerName":"next_result","kind":13,"line":165},{"line":165,"kind":13,"containerName":"next_result","name":"$seq"},{"containerName":"next_result","name":"$line","kind":13,"line":165},{"localvar":"my","containerName":"next_result","definition":"my","name":"$feat","line":166,"kind":13},{"line":166,"kind":12,"name":"new","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":167,"kind":13},{"line":168,"kind":13,"containerName":"next_result","name":"$start"},{"kind":13,"line":169,"containerName":"next_result","name":"$start"},{"line":169,"kind":13,"containerName":"next_result","name":"$seq"},{"name":"$core_score","containerName":"next_result","kind":13,"line":171},{"containerName":"next_result","definition":"my","name":"$sv","localvar":"my","kind":13,"line":174},{"containerName":"next_result","name":"new","kind":12,"line":174},{"line":175,"kind":13,"containerName":"next_result","name":"$feat"},{"kind":12,"line":175,"name":"annotation","containerName":"next_result"},{"name":"add_Annotation","containerName":"next_result","kind":12,"line":175},{"containerName":"next_result","name":"$sv","line":175,"kind":13},{"line":176,"kind":13,"containerName":"next_result","name":"$sv"},{"kind":12,"line":176,"name":"new","containerName":"next_result"},{"kind":13,"line":176,"containerName":"next_result","name":"$matrix_score"},{"kind":13,"line":177,"containerName":"next_result","name":"$feat"},{"line":177,"kind":12,"name":"annotation","containerName":"next_result"},{"kind":12,"line":177,"containerName":"next_result","name":"add_Annotation"},{"line":177,"kind":13,"name":"$sv","containerName":"next_result"},{"kind":13,"line":178,"name":"$sv","containerName":"next_result"},{"name":"new","containerName":"next_result","line":178,"kind":12},{"name":"$matrix_id","containerName":"next_result","line":178,"kind":13},{"containerName":"next_result","name":"$feat","kind":13,"line":179},{"line":179,"kind":12,"name":"annotation","containerName":"next_result"},{"containerName":"next_result","name":"add_Annotation","kind":12,"line":179},{"containerName":"next_result","name":"$sv","line":179,"kind":13},{"kind":13,"line":181,"containerName":"next_result","name":"$feat"}]},{"name":"found_seq_id","kind":12,"line":129},{"name":"found_seq_id","line":130,"kind":12},{"name":"Bio","containerName":"SeqFeature::Annotated","line":166,"kind":12},{"name":"found_seq_id","line":167,"kind":12},{"kind":12,"line":174,"name":"Bio","containerName":"Annotation::SimpleValue"},{"line":176,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"kind":12,"line":178,"containerName":"Annotation::SimpleValue","name":"Bio"}]}