{"version":5,"vars":[{"kind":2,"line":142,"name":"base","containerName":""},{"definition":"our","name":"$MotifTag","containerName":"main::","kind":13,"line":144},{"line":144,"kind":13,"containerName":null,"name":"$SrcTag"},{"name":"$DescTag","containerName":null,"line":144,"kind":13},{"containerName":"main::","name":"$MINSCORE","definition":"our","line":146,"kind":13},{"line":147,"kind":13,"definition":"our","name":"$DEFAULT_VERSION","containerName":"main::"},{"detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n yes, this is actually _initialize, but the args are passed to\n the constructor.\n see Bio::Tools::AnalysisResult for further details","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":171,"children":[{"localvar":"my","containerName":"_initialize","name":"$self","definition":"my","line":172,"kind":13},{"containerName":"_initialize","name":"@args","line":172,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":173},{"line":173,"kind":12,"containerName":"_initialize","name":"warn"},{"kind":13,"line":174,"name":"$self","containerName":"_initialize"},{"name":"@args","containerName":"_initialize","kind":13,"line":174},{"localvar":"my","containerName":"_initialize","name":"$motiftag","definition":"my","line":175,"kind":13},{"containerName":"_initialize","name":"$desctag","kind":13,"line":175},{"kind":13,"line":175,"containerName":"_initialize","name":"$srctag"},{"name":"$rfam","containerName":"_initialize","kind":13,"line":175},{"line":175,"kind":13,"containerName":"_initialize","name":"$cm"},{"kind":13,"line":175,"containerName":"_initialize","name":"$ms"},{"containerName":"_initialize","name":"$ver","kind":13,"line":175},{"name":"$self","containerName":"_initialize","kind":13,"line":176},{"containerName":"_initialize","name":"@args","kind":13,"line":183},{"containerName":"_initialize","name":"$self","line":184,"kind":13},{"name":"motif_tag","containerName":"_initialize","line":184,"kind":12},{"containerName":"_initialize","name":"$motiftag","line":184,"kind":13},{"kind":13,"line":184,"containerName":"_initialize","name":"$motiftag"},{"name":"$MotifTag","containerName":"_initialize","line":184,"kind":13},{"kind":13,"line":185,"containerName":"_initialize","name":"$self"},{"line":185,"kind":12,"name":"source_tag","containerName":"_initialize"},{"containerName":"_initialize","name":"$srctag","line":185,"kind":13},{"kind":13,"line":185,"name":"$srctag","containerName":"_initialize"},{"containerName":"_initialize","name":"$SrcTag","line":185,"kind":13},{"kind":13,"line":186,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"desc_tag","kind":12,"line":186},{"line":186,"kind":13,"name":"$desctag","containerName":"_initialize"},{"kind":13,"line":186,"containerName":"_initialize","name":"$desctag"},{"name":"$DescTag","containerName":"_initialize","line":186,"kind":13},{"kind":13,"line":187,"name":"$cm","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":187,"kind":13},{"line":187,"kind":12,"name":"covariance_model","containerName":"_initialize"},{"name":"$cm","containerName":"_initialize","line":187,"kind":13},{"containerName":"_initialize","name":"$rfam","kind":13,"line":188},{"kind":13,"line":188,"name":"$self","containerName":"_initialize"},{"kind":12,"line":188,"containerName":"_initialize","name":"rfam"},{"name":"$rfam","containerName":"_initialize","kind":13,"line":188},{"containerName":"_initialize","name":"$self","line":189,"kind":13},{"containerName":"_initialize","name":"program_version","kind":12,"line":189},{"kind":13,"line":189,"name":"$ver","containerName":"_initialize"},{"containerName":"_initialize","name":"$ver","line":189,"kind":13},{"kind":13,"line":189,"containerName":"_initialize","name":"$DEFAULT_VERSION"},{"line":190,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"minscore","kind":12,"line":190},{"name":"$ms","containerName":"_initialize","kind":13,"line":190},{"kind":13,"line":190,"name":"$ms","containerName":"_initialize"},{"kind":13,"line":190,"containerName":"_initialize","name":"$MINSCORE"}],"kind":12,"range":{"end":{"character":9999,"line":191},"start":{"character":0,"line":171}},"name":"_initialize"},{"line":174,"kind":12,"name":"SUPER","containerName":"_initialize"},{"kind":12,"line":176,"name":"SUPER","containerName":"_rearrange"},{"range":{"end":{"line":217,"character":9999},"start":{"line":212,"character":0}},"containerName":"main::","name":"motif_tag","definition":"sub","line":212,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"motif_tag","line":213,"kind":13},{"line":215,"kind":13,"containerName":"motif_tag","name":"$self"},{"containerName":"motif_tag","name":"$self","kind":13,"line":216}],"kind":12},{"definition":"sub","name":"source_tag","containerName":"main::","range":{"start":{"character":0,"line":231},"end":{"line":236,"character":9999}},"kind":12,"children":[{"line":232,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"source_tag"},{"containerName":"source_tag","name":"$self","line":234,"kind":13},{"name":"$self","containerName":"source_tag","line":235,"kind":13}],"line":231},{"range":{"start":{"line":253,"character":0},"end":{"line":258,"character":9999}},"name":"desc_tag","definition":"sub","containerName":"main::","children":[{"kind":13,"line":254,"name":"$self","definition":"my","containerName":"desc_tag","localvar":"my"},{"containerName":"desc_tag","name":"$self","kind":13,"line":256},{"name":"$self","containerName":"desc_tag","kind":13,"line":257}],"line":253,"kind":12},{"range":{"end":{"character":9999,"line":275},"start":{"line":270,"character":0}},"containerName":"main::","definition":"sub","name":"covariance_model","line":270,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"covariance_model","line":271,"kind":13},{"line":273,"kind":13,"name":"$self","containerName":"covariance_model"},{"containerName":"covariance_model","name":"$self","kind":13,"line":274}],"kind":12},{"kind":12,"line":287,"children":[{"containerName":"rfam","name":"$self","definition":"my","localvar":"my","kind":13,"line":288},{"containerName":"rfam","name":"$self","line":290,"kind":13},{"containerName":"rfam","name":"$self","kind":13,"line":291}],"containerName":"main::","name":"rfam","definition":"sub","range":{"end":{"line":292,"character":9999},"start":{"character":0,"line":287}}},{"children":[{"kind":13,"line":305,"containerName":"minscore","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"minscore","line":307,"kind":13},{"kind":13,"line":308,"containerName":"minscore","name":"$self"}],"line":304,"kind":12,"range":{"end":{"line":309,"character":9999},"start":{"line":304,"character":0}},"definition":"sub","name":"minscore","containerName":"main::"},{"range":{"start":{"character":0,"line":322},"end":{"character":9999,"line":327}},"definition":"sub","name":"program_version","containerName":"main::","children":[{"line":323,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"program_version"},{"line":325,"kind":13,"containerName":"program_version","name":"$self"},{"containerName":"program_version","name":"$self","kind":13,"line":326}],"line":322,"kind":12},{"range":{"end":{"character":9999,"line":345},"start":{"line":339,"character":0}},"name":"analysis_method","line":339,"children":[{"line":340,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","kind":13,"line":340},{"line":341,"kind":13,"name":"$method","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","line":341,"kind":13},{"line":342,"kind":13,"containerName":"analysis_method","name":"$self"},{"name":"throw","containerName":"analysis_method","kind":12,"line":342},{"kind":13,"line":342,"name":"$self","containerName":"analysis_method"},{"line":344,"kind":13,"name":"$self","containerName":"analysis_method"},{"line":344,"kind":13,"name":"$method","containerName":"analysis_method"}],"kind":12,"detail":"($self,$method)","signature":{"documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n\n# yes, this is actually _initialize, but the args are passed to\n# the constructor.\n# see Bio::Tools::AnalysisResult for further details\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::infernal instead');  \n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag,$rfam,$cm,$ms,$ver) =\n        $self->SUPER::_rearrange([qw(MOTIFTAG\n                                    DESCTAG\n                                    SRCTAG\n                                    RFAM\n                                    CM\n                                    MINSCORE\n                                    VERSION\n                                 )],@args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $cm        && $self->covariance_model($cm);\n  $rfam      && $self->rfam($rfam);\n  $self->program_version(defined $ver ? $ver : $DEFAULT_VERSION);\n  $self->minscore(defined $ms ? $ms : $MINSCORE);\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'Infernal' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'infernal' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the Infernal output, this should\n           be set every time an Infernal object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 covariance_model\n\n Title   : covariance_model\n Usage   : $obj->covariance_model($newval)\n Function: Get/Set the value used for the covariance model used in the analysis.\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub covariance_model{\n    my $self = shift;\n\n    return $self->{'_cmodel'} = shift if @_;\n    return $self->{'_cmodel'};\n}\n\n=head2 rfam\n\n Title   : rfam\n Usage   : $obj->rfam($newval)\n Function: Get/Set the Rfam accession number\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rfam {\n    my $self = shift;\n\n    return $self->{'_rfam'} = shift if @_;\n    return $self->{'_rfam'};\n}\n\n=head2 minscore\n\n Title   : minscore\n Usage   : $obj->minscore($newval)\n Function: Get/Set the minimum score threshold for generating SeqFeatures\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub minscore {\n    my $self = shift;\n\n    return $self->{'_minscore'} = shift if @_;\n    return $self->{'_minscore'};\n}\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $obj->program_version($newval)\n Function: Get/Set the Infernal program version\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n           Note: this is set to $DEFAULT_VERSION by, um, default\n\n\nsub program_version {\n    my $self = shift;\n\n    return $self->{'_program_version'} = shift if @_;\n    return $self->{'_program_version'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Infernal/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"containerName":"main::","definition":"sub"},{"line":344,"kind":12,"containerName":"analysis_method","name":"SUPER"},{"name":"next_feature","range":{"end":{"character":9999,"line":370},"start":{"line":364,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n\n# yes, this is actually _initialize, but the args are passed to\n# the constructor.\n# see Bio::Tools::AnalysisResult for further details\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::infernal instead');  \n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag,$rfam,$cm,$ms,$ver) =\n        $self->SUPER::_rearrange([qw(MOTIFTAG\n                                    DESCTAG\n                                    SRCTAG\n                                    RFAM\n                                    CM\n                                    MINSCORE\n                                    VERSION\n                                 )],@args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $cm        && $self->covariance_model($cm);\n  $rfam      && $self->rfam($rfam);\n  $self->program_version(defined $ver ? $ver : $DEFAULT_VERSION);\n  $self->minscore(defined $ms ? $ms : $MINSCORE);\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'Infernal' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'infernal' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the Infernal output, this should\n           be set every time an Infernal object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 covariance_model\n\n Title   : covariance_model\n Usage   : $obj->covariance_model($newval)\n Function: Get/Set the value used for the covariance model used in the analysis.\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub covariance_model{\n    my $self = shift;\n\n    return $self->{'_cmodel'} = shift if @_;\n    return $self->{'_cmodel'};\n}\n\n=head2 rfam\n\n Title   : rfam\n Usage   : $obj->rfam($newval)\n Function: Get/Set the Rfam accession number\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rfam {\n    my $self = shift;\n\n    return $self->{'_rfam'} = shift if @_;\n    return $self->{'_rfam'};\n}\n\n=head2 minscore\n\n Title   : minscore\n Usage   : $obj->minscore($newval)\n Function: Get/Set the minimum score threshold for generating SeqFeatures\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub minscore {\n    my $self = shift;\n\n    return $self->{'_minscore'} = shift if @_;\n    return $self->{'_minscore'};\n}\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $obj->program_version($newval)\n Function: Get/Set the Infernal program version\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n           Note: this is set to $DEFAULT_VERSION by, um, default\n\n\nsub program_version {\n    my $self = shift;\n\n    return $self->{'_program_version'} = shift if @_;\n    return $self->{'_program_version'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Infernal/i.\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method { \n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Infernal/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)","label":"next_feature($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"line":365,"kind":13,"localvar":"my","containerName":"next_feature","definition":"my","name":"$self"},{"containerName":"next_feature","name":"@args","kind":13,"line":365},{"line":369,"kind":13,"name":"$self","containerName":"next_feature"},{"line":369,"kind":12,"containerName":"next_feature","name":"next_prediction"},{"kind":13,"line":369,"containerName":"next_feature","name":"@args"}],"line":364},{"range":{"end":{"line":484,"character":9999},"start":{"character":0,"line":385}},"name":"next_prediction","signature":{"documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n\n# yes, this is actually _initialize, but the args are passed to\n# the constructor.\n# see Bio::Tools::AnalysisResult for further details\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::infernal instead');  \n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag,$rfam,$cm,$ms,$ver) =\n        $self->SUPER::_rearrange([qw(MOTIFTAG\n                                    DESCTAG\n                                    SRCTAG\n                                    RFAM\n                                    CM\n                                    MINSCORE\n                                    VERSION\n                                 )],@args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $cm        && $self->covariance_model($cm);\n  $rfam      && $self->rfam($rfam);\n  $self->program_version(defined $ver ? $ver : $DEFAULT_VERSION);\n  $self->minscore(defined $ms ? $ms : $MINSCORE);\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'Infernal' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'infernal' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the Infernal output, this should\n           be set every time an Infernal object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 covariance_model\n\n Title   : covariance_model\n Usage   : $obj->covariance_model($newval)\n Function: Get/Set the value used for the covariance model used in the analysis.\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub covariance_model{\n    my $self = shift;\n\n    return $self->{'_cmodel'} = shift if @_;\n    return $self->{'_cmodel'};\n}\n\n=head2 rfam\n\n Title   : rfam\n Usage   : $obj->rfam($newval)\n Function: Get/Set the Rfam accession number\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rfam {\n    my $self = shift;\n\n    return $self->{'_rfam'} = shift if @_;\n    return $self->{'_rfam'};\n}\n\n=head2 minscore\n\n Title   : minscore\n Usage   : $obj->minscore($newval)\n Function: Get/Set the minimum score threshold for generating SeqFeatures\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub minscore {\n    my $self = shift;\n\n    return $self->{'_minscore'} = shift if @_;\n    return $self->{'_minscore'};\n}\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $obj->program_version($newval)\n Function: Get/Set the Infernal program version\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n           Note: this is set to $DEFAULT_VERSION by, um, default\n\n\nsub program_version {\n    my $self = shift;\n\n    return $self->{'_program_version'} = shift if @_;\n    return $self->{'_program_version'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Infernal/i.\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method { \n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Infernal/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $obj->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Generic object\n Args    : None (at present)","parameters":[{"label":"$self"}],"label":"next_prediction($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_prediction","line":386,"kind":13},{"containerName":"next_prediction","name":"$start","definition":"my","localvar":"my","kind":13,"line":388},{"name":"$end","containerName":"next_prediction","line":388,"kind":13},{"line":388,"kind":13,"name":"$strand","containerName":"next_prediction"},{"name":"$score","containerName":"next_prediction","line":388,"kind":13},{"line":390,"kind":13,"localvar":"my","name":"%hsp_key","definition":"my","containerName":"next_prediction"},{"localvar":"my","containerName":"next_prediction","definition":"my","name":"$line","line":394,"kind":13},{"name":"$line","containerName":"next_prediction","kind":13,"line":396},{"containerName":"next_prediction","name":"$self","line":396,"kind":13},{"kind":12,"line":396,"name":"_readline","containerName":"next_prediction"},{"kind":13,"line":397,"containerName":"next_prediction","name":"$line"},{"name":"$line","containerName":"next_prediction","line":398,"kind":13},{"name":"$self","containerName":"next_prediction","line":399,"kind":13},{"name":"_current_hit","containerName":"next_prediction","line":399,"kind":12},{"containerName":"next_prediction","name":"$line","line":401,"kind":13},{"line":402,"kind":13,"containerName":"next_prediction","name":"$strand"},{"name":"$start","containerName":"next_prediction","kind":13,"line":403},{"containerName":"next_prediction","name":"$end","kind":13,"line":403},{"kind":13,"line":403,"name":"$score","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$start","line":404,"kind":13},{"containerName":"next_prediction","name":"$end","line":404,"kind":13},{"line":405,"kind":13,"containerName":"next_prediction","name":"$start"},{"containerName":"next_prediction","name":"$end","line":405,"kind":13},{"containerName":"next_prediction","name":"$end","line":405,"kind":13},{"containerName":"next_prediction","name":"$start","kind":13,"line":405},{"line":406,"kind":13,"name":"$strand","containerName":"next_prediction"},{"kind":13,"line":410,"containerName":"next_prediction","name":"$line"},{"name":"$self","containerName":"next_prediction","kind":13,"line":411},{"containerName":"next_prediction","name":"_pushback","kind":12,"line":411},{"containerName":"next_prediction","name":"$line","line":411,"kind":13},{"kind":13,"line":413,"name":"$offset","definition":"my","containerName":"next_prediction","localvar":"my"},{"kind":13,"line":414,"name":"$ct","definition":"my","containerName":"next_prediction","localvar":"my"},{"containerName":"next_prediction","name":"$strln","kind":13,"line":414},{"containerName":"next_prediction","name":"$hsp","definition":"my","localvar":"my","kind":13,"line":415},{"line":417,"kind":13,"name":"$line","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","kind":13,"line":417},{"name":"_readline","containerName":"next_prediction","kind":12,"line":417},{"name":"$line","containerName":"next_prediction","line":418,"kind":13},{"line":419,"kind":13,"containerName":"next_prediction","name":"$line"},{"kind":13,"line":421,"name":"$line","containerName":"next_prediction"},{"name":"$line","containerName":"next_prediction","kind":13,"line":421},{"kind":13,"line":422,"containerName":"next_prediction","name":"$self"},{"name":"_pushback","containerName":"next_prediction","kind":12,"line":422},{"line":422,"kind":13,"containerName":"next_prediction","name":"$line"},{"line":426,"kind":13,"localvar":"my","containerName":"next_prediction","definition":"my","name":"$iterator"},{"containerName":"next_prediction","name":"$ct","line":426,"kind":13},{"line":426,"kind":13,"name":"%4","containerName":"next_prediction"},{"name":"$strln","containerName":"next_prediction","line":428,"kind":13},{"line":428,"kind":13,"containerName":"next_prediction","name":"$line"},{"containerName":"next_prediction","name":"$iterator","line":428,"kind":13},{"containerName":"next_prediction","definition":"my","name":"$data","localvar":"my","kind":13,"line":435},{"kind":13,"line":435,"name":"$line","containerName":"next_prediction"},{"line":435,"kind":13,"containerName":"next_prediction","name":"$offset"},{"containerName":"next_prediction","name":"$strln","line":435,"kind":13},{"name":"$offset","containerName":"next_prediction","line":435,"kind":13},{"kind":13,"line":436,"name":"$hsp","containerName":"next_prediction"},{"name":"$hsp_key","containerName":"next_prediction","kind":13,"line":436},{"kind":13,"line":436,"name":"$iterator","containerName":"next_prediction"},{"kind":13,"line":436,"name":"$data","containerName":"next_prediction"},{"line":437,"kind":13,"name":"$ct","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","line":439,"kind":13},{"line":439,"kind":12,"name":"minscore","containerName":"next_prediction"},{"line":439,"kind":13,"containerName":"next_prediction","name":"$score"},{"name":"$name","definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"line":440},{"kind":13,"line":440,"name":"$program","containerName":"next_prediction"},{"name":"$rfam","containerName":"next_prediction","line":440,"kind":13},{"kind":13,"line":440,"name":"$cm","containerName":"next_prediction"},{"line":440,"kind":13,"containerName":"next_prediction","name":"$dt"},{"line":440,"kind":13,"containerName":"next_prediction","name":"$st"},{"name":"$mt","containerName":"next_prediction","line":440,"kind":13},{"line":441,"kind":13,"name":"$self","containerName":"next_prediction"},{"line":441,"kind":12,"containerName":"next_prediction","name":"_current_hit"},{"containerName":"next_prediction","name":"$self","line":441,"kind":13},{"line":441,"kind":12,"containerName":"next_prediction","name":"analysis_method"},{"containerName":"next_prediction","name":"$self","kind":13,"line":441},{"line":441,"kind":12,"name":"rfam","containerName":"next_prediction"},{"line":442,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":442,"kind":12,"name":"covariance_model","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","kind":13,"line":442},{"containerName":"next_prediction","name":"desc_tag","kind":12,"line":442},{"kind":13,"line":442,"name":"$self","containerName":"next_prediction"},{"kind":12,"line":442,"containerName":"next_prediction","name":"source_tag"},{"kind":13,"line":443,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"motif_tag","kind":12,"line":443},{"kind":13,"line":444,"name":"$ver","definition":"my","containerName":"next_prediction","localvar":"my"},{"line":444,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":444,"kind":12,"containerName":"next_prediction","name":"program_version"},{"name":"$qid","definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"line":445},{"containerName":"next_prediction","name":"$name","line":445,"kind":13},{"line":446,"kind":13,"name":"$name","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$qid","kind":13,"line":447},{"kind":13,"line":449,"containerName":"next_prediction","name":"$fp","definition":"my","localvar":"my"},{"name":"new","containerName":"next_prediction","kind":12,"line":449},{"localvar":"my","containerName":"next_prediction","definition":"my","name":"$strlen","line":450,"kind":13},{"line":450,"kind":13,"containerName":"next_prediction","name":"$hsp"},{"localvar":"my","definition":"my","name":"$qf","containerName":"next_prediction","line":451,"kind":13},{"name":"new","containerName":"next_prediction","line":451,"kind":12},{"name":"$mt","containerName":"next_prediction","kind":13,"line":451},{"name":"$cm","containerName":"next_prediction","kind":13,"line":453},{"line":454,"kind":13,"containerName":"next_prediction","name":"$score"},{"containerName":"next_prediction","name":"$strlen","kind":13,"line":456},{"containerName":"next_prediction","name":"$rfam","kind":13,"line":457},{"localvar":"my","containerName":"next_prediction","definition":"my","name":"$hf","line":460,"kind":13},{"containerName":"next_prediction","name":"new","line":460,"kind":12},{"name":"$mt","containerName":"next_prediction","line":460,"kind":13},{"kind":13,"line":462,"name":"$dt","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$score","kind":13,"line":463},{"line":464,"kind":13,"name":"$start","containerName":"next_prediction"},{"name":"$end","containerName":"next_prediction","kind":13,"line":465},{"kind":13,"line":466,"name":"$qid","containerName":"next_prediction"},{"kind":13,"line":468,"containerName":"next_prediction","name":"$strand"},{"name":"$fp","containerName":"next_prediction","line":469,"kind":13},{"kind":12,"line":469,"name":"feature1","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$qf","line":469,"kind":13},{"line":470,"kind":13,"name":"$fp","containerName":"next_prediction"},{"line":470,"kind":12,"name":"feature2","containerName":"next_prediction"},{"line":470,"kind":13,"containerName":"next_prediction","name":"$hf"},{"containerName":"next_prediction","name":"$fp","kind":13,"line":471},{"name":"add_tag_value","containerName":"next_prediction","kind":12,"line":471},{"name":"$hsp","containerName":"next_prediction","kind":13,"line":471},{"name":"$fp","containerName":"next_prediction","kind":13,"line":472},{"containerName":"next_prediction","name":"add_tag_value","kind":12,"line":472},{"name":"$hsp","containerName":"next_prediction","line":472,"kind":13},{"kind":13,"line":473,"containerName":"next_prediction","name":"$fp"},{"line":473,"kind":12,"name":"add_tag_value","containerName":"next_prediction"},{"name":"$hsp","containerName":"next_prediction","line":473,"kind":13},{"name":"$fp","containerName":"next_prediction","kind":13,"line":474},{"kind":12,"line":474,"containerName":"next_prediction","name":"add_tag_value"},{"containerName":"next_prediction","name":"$hsp","line":474,"kind":13},{"line":475,"kind":13,"containerName":"next_prediction","name":"$fp"},{"containerName":"next_prediction","name":"add_tag_value","line":475,"kind":12},{"kind":13,"line":475,"name":"$name","containerName":"next_prediction"},{"kind":13,"line":476,"containerName":"next_prediction","name":"$fp"},{"line":476,"kind":12,"name":"display_name","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$dt","line":476,"kind":13},{"containerName":"next_prediction","name":"$fp","kind":13,"line":477},{"line":483,"kind":13,"name":"$line","containerName":"next_prediction"}],"line":385,"kind":12},{"kind":12,"line":395,"name":"PARSER"},{"name":"PARSER","line":400,"kind":12},{"name":"HSP","line":416,"kind":12},{"line":423,"kind":12,"name":"HSP"},{"name":"Bio","containerName":"SeqFeature::FeaturePair","kind":12,"line":449},{"containerName":"SeqFeature::Generic","name":"Bio","line":451,"kind":12},{"kind":12,"line":460,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"PARSER","line":479,"kind":12},{"line":486,"children":[{"localvar":"my","containerName":"_current_hit","definition":"my","name":"$self","line":487,"kind":13},{"containerName":"_current_hit","name":"$self","line":488,"kind":13},{"containerName":"_current_hit","name":"$self","line":489,"kind":13}],"kind":12,"range":{"start":{"line":486,"character":0},"end":{"character":9999,"line":490}},"containerName":"main::","definition":"sub","name":"_current_hit"}]}