{"version":5,"vars":[{"kind":2,"line":105,"containerName":"","name":"base"},{"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":108,"kind":13},{"line":108,"kind":13,"containerName":"new","name":"@args"},{"line":110,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"containerName":"new","name":"$class","line":110,"kind":13},{"line":110,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":112},{"kind":13,"line":113,"name":"$self","containerName":"new"},{"localvar":"my","name":"$parsetype","definition":"my","containerName":"new","line":115,"kind":13},{"kind":13,"line":115,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":115,"kind":12},{"line":115,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":116},{"kind":12,"line":116,"containerName":"new","name":"_initialize_io"},{"line":116,"kind":13,"name":"@args","containerName":"new"},{"name":"$parsetype","containerName":"new","line":117,"kind":13},{"containerName":"new","name":"$self","line":118,"kind":13},{"kind":12,"line":118,"name":"throw","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":120},{"line":120,"kind":12,"name":"parsetype","containerName":"new"},{"containerName":"new","name":"$parsetype","line":120,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":121},{"name":"_fh","containerName":"new","line":121,"kind":12},{"kind":13,"line":122,"name":"$parsetype","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":123},{"line":123,"kind":12,"name":"_parse_hmmsearch","containerName":"new"},{"name":"$self","containerName":"new","line":123,"kind":13},{"name":"_fh","containerName":"new","line":123,"kind":12},{"containerName":"new","name":"$parsetype","kind":13,"line":124},{"name":"$self","containerName":"new","line":125,"kind":13},{"kind":12,"line":125,"name":"_parse_hmmpfam","containerName":"new"},{"line":125,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":125,"name":"_fh","containerName":"new"},{"line":127,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":127,"name":"throw","containerName":"new"},{"line":131,"kind":13,"name":"$self","containerName":"new"}],"line":107,"kind":12,"range":{"start":{"line":107,"character":0},"end":{"line":132,"character":9999}},"name":"new"},{"containerName":"new","name":"SUPER","line":110,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"next_feature($self)","documentation":"__END__\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Perl Module for HMMResults\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n#Copyright Genome Research Limited (1997).\n\n=head1 NAME\n\nBio::Tools::HMMER::Results - Object representing HMMER output results\n\n=head1 SYNOPSIS\n\n   # parse a hmmsearch file (can also parse a hmmpfam file)\n   $res = Bio::Tools::HMMER::Results->new( -file => 'output.hmm' ,\n                                          -type => 'hmmsearch');\n\n   # print out the results for each sequence\n   foreach $seq ( $res->each_Set ) {\n       print \"Sequence bit score is\",$seq->bits,\"\\n\";\n       foreach $domain ( $seq->each_Domain ) {\n           print \" Domain start \",$domain->start,\" end \",$domain->end,\n\t   \" score \",$domain->bits,\"\\n\";\n       }\n   }\n\n   # new result object on a sequence/domain cutoff of\n   # 25 bits sequence, 15 bits domain\n   $newresult = $res->filter_on_cutoff(25,15);\n\n   # alternative way of getting out all domains directly\n   foreach $domain ( $res->each_Domain ) {\n       print \"Domain on \",$domain->seq_id,\" with score \",\n       $domain->bits,\" evalue \",$domain->evalue,\"\\n\";\n   }\n\n=head1 DESCRIPTION\n\nThis object represents HMMER output, either from hmmsearch or\nhmmpfam. For hmmsearch, a series of HMMER::Set objects are made, one\nfor each sequence, which have the the bits score for the object. For\nhmmpfam searches, only one Set object is made.\n\n\nThese objects come from the original HMMResults modules used\ninternally in Pfam, written by Ewan Birney. Ewan then converted them to\nBioPerl objects in 1999. That conversion is meant to be backwardly\ncompatible, but may not be (caveat emptor).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::HMMER::Results;\n\nuse strict;\n\nuse Bio::Tools::HMMER::Domain;\nuse Bio::Tools::HMMER::Set;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::SeqAnalysisParserI);\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'domain'} = []; # array of HMMUnits\n  $self->{'seq'} = {};\n\n  my ($parsetype) = $self->_rearrange([qw(TYPE)],@args);\n  $self->_initialize_io(@args);\n  if( !defined $parsetype ) {\n      $self->throw(\"No parse type provided. should be hmmsearch or hmmpfam\");\n  }\n  $self->parsetype($parsetype);\n  if( defined $self->_fh() ) {\n      if( $parsetype eq 'hmmsearch' ) {\n\t  $self->_parse_hmmsearch($self->_fh());\n      } elsif ( $parsetype eq 'hmmpfam' ) {\n\t  $self->_parse_hmmpfam($self->_fh());\n      } else {\n\t  $self->throw(\"Did not recoginise type $parsetype\");\n      }\n  }\n\n  return $self; # success - we hope!\n}\n\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while( my $feat = $res->next_feature ) { # do something }\n Function: SeqAnalysisParserI implementing function\n Example :\n Returns : A Bio::SeqFeatureI compliant object, in this case,\n           each DomainUnit object, ie, flattening the Sequence\n           aspect of this.\n Args    : None","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":150,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","line":152,"kind":13},{"line":153,"kind":13,"containerName":"next_feature","name":"$self"}],"line":149,"name":"next_feature","range":{"start":{"line":149,"character":0},"end":{"line":154,"character":9999}}},{"name":"%self","containerName":null,"kind":13,"line":155},{"localvar":"my","name":"@array","definition":"my","containerName":null,"line":156,"kind":13},{"containerName":null,"name":"$seq","definition":"my","localvar":"my","kind":13,"line":157},{"kind":13,"line":157,"name":"$self","containerName":null},{"name":"each_Set","containerName":"main::","kind":12,"line":157},{"kind":13,"line":158,"definition":"my","name":"$unit","containerName":null,"localvar":"my"},{"line":158,"kind":13,"name":"$seq","containerName":null},{"line":158,"kind":12,"name":"each_Domain","containerName":"main::"},{"name":"@array","containerName":null,"line":159,"kind":13},{"kind":13,"line":159,"containerName":null,"name":"$unit"},{"containerName":null,"name":"$res","definition":"my","localvar":"my","kind":13,"line":162},{"name":"@array","containerName":null,"line":162,"kind":13},{"name":"%self","containerName":null,"line":163,"kind":13},{"line":163,"kind":13,"containerName":null,"name":"@array"},{"name":"$res","containerName":null,"kind":13,"line":164},{"containerName":null,"name":"$self","kind":13,"line":167},{"line":167,"kind":12,"containerName":"main::","name":"throw"},{"children":[{"name":"$self","definition":"my","containerName":"number","localvar":"my","kind":13,"line":180},{"containerName":"number","name":"@val","definition":"my","localvar":"my","kind":13,"line":181},{"name":"$ref","definition":"my","containerName":"number","localvar":"my","kind":13,"line":182},{"kind":13,"line":183,"name":"$ref","containerName":"number"},{"kind":13,"line":183,"name":"$self","containerName":"number"},{"line":186,"kind":13,"containerName":"number","name":"@val"},{"containerName":"number","name":"$self","kind":13,"line":186}],"line":179,"kind":12,"range":{"end":{"character":9999,"line":186},"start":{"line":179,"character":0}},"name":"number","definition":"sub","containerName":"main::"},{"name":"@val","containerName":null,"kind":13,"line":187},{"signature":{"label":"seqfile($self,$value)","documentation":"__END__\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Perl Module for HMMResults\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n#Copyright Genome Research Limited (1997).\n\n=head1 NAME\n\nBio::Tools::HMMER::Results - Object representing HMMER output results\n\n=head1 SYNOPSIS\n\n   # parse a hmmsearch file (can also parse a hmmpfam file)\n   $res = Bio::Tools::HMMER::Results->new( -file => 'output.hmm' ,\n                                          -type => 'hmmsearch');\n\n   # print out the results for each sequence\n   foreach $seq ( $res->each_Set ) {\n       print \"Sequence bit score is\",$seq->bits,\"\\n\";\n       foreach $domain ( $seq->each_Domain ) {\n           print \" Domain start \",$domain->start,\" end \",$domain->end,\n\t   \" score \",$domain->bits,\"\\n\";\n       }\n   }\n\n   # new result object on a sequence/domain cutoff of\n   # 25 bits sequence, 15 bits domain\n   $newresult = $res->filter_on_cutoff(25,15);\n\n   # alternative way of getting out all domains directly\n   foreach $domain ( $res->each_Domain ) {\n       print \"Domain on \",$domain->seq_id,\" with score \",\n       $domain->bits,\" evalue \",$domain->evalue,\"\\n\";\n   }\n\n=head1 DESCRIPTION\n\nThis object represents HMMER output, either from hmmsearch or\nhmmpfam. For hmmsearch, a series of HMMER::Set objects are made, one\nfor each sequence, which have the the bits score for the object. For\nhmmpfam searches, only one Set object is made.\n\n\nThese objects come from the original HMMResults modules used\ninternally in Pfam, written by Ewan Birney. Ewan then converted them to\nBioPerl objects in 1999. That conversion is meant to be backwardly\ncompatible, but may not be (caveat emptor).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::HMMER::Results;\n\nuse strict;\n\nuse Bio::Tools::HMMER::Domain;\nuse Bio::Tools::HMMER::Set;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::SeqAnalysisParserI);\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'domain'} = []; # array of HMMUnits\n  $self->{'seq'} = {};\n\n  my ($parsetype) = $self->_rearrange([qw(TYPE)],@args);\n  $self->_initialize_io(@args);\n  if( !defined $parsetype ) {\n      $self->throw(\"No parse type provided. should be hmmsearch or hmmpfam\");\n  }\n  $self->parsetype($parsetype);\n  if( defined $self->_fh() ) {\n      if( $parsetype eq 'hmmsearch' ) {\n\t  $self->_parse_hmmsearch($self->_fh());\n      } elsif ( $parsetype eq 'hmmpfam' ) {\n\t  $self->_parse_hmmpfam($self->_fh());\n      } else {\n\t  $self->throw(\"Did not recoginise type $parsetype\");\n      }\n  }\n\n  return $self; # success - we hope!\n}\n\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while( my $feat = $res->next_feature ) { # do something }\n Function: SeqAnalysisParserI implementing function\n Example :\n Returns : A Bio::SeqFeatureI compliant object, in this case,\n           each DomainUnit object, ie, flattening the Sequence\n           aspect of this.\n Args    : None\n\n\n\nsub next_feature{\n   my ($self) = @_;\n\n   if( $self->{'_started_next_feature'} == 1 ) {\n       return shift @{$self->{'_next_feature_array'}};\n   } else {\n       $self->{'_started_next_feature'} = 1;\n       my @array;\n       foreach my $seq ( $self->each_Set() ) {\n\t   foreach my $unit ( $seq->each_Domain() ) {\n\t       push(@array,$unit);\n\t   }\n       }\n       my $res = shift @array;\n       $self->{'_next_feature_array'} = \\@array;\n       return $res;\n   }\n\n   $self->throw(\"Should not reach here! Error!\");\n}\n\n\n=head2 number\n\n Title   : number\n Usage   : print \"There are \",$res->number,\" domains hit\\n\";\n Function: provides the number of domains in the HMMER report\n\n\nsub number {\n    my $self = shift;\n    my @val;\n    my $ref;\n    $ref = $self->{'domain'};\n\n\n    @val = @{$self->{'domain'}};\n    return scalar @val;\n}\n\n=head2 seqfile\n\n Title   : seqfile\n Usage   : $obj->seqfile($newval)\n Function:\n Example :\n Returns : value of seqfile\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":203,"name":"$self","definition":"my","containerName":"seqfile","localvar":"my"},{"kind":13,"line":203,"containerName":"seqfile","name":"$value"},{"line":204,"kind":13,"containerName":"seqfile","name":"$value"},{"name":"$self","containerName":"seqfile","kind":13,"line":205},{"name":"$value","containerName":"seqfile","kind":13,"line":205},{"containerName":"seqfile","name":"$self","line":207,"kind":13}],"line":202,"kind":12,"range":{"start":{"character":0,"line":202},"end":{"character":9999,"line":209}},"name":"seqfile"},{"signature":{"label":"hmmfile($self,$value)","documentation":"__END__\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Perl Module for HMMResults\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n#Copyright Genome Research Limited (1997).\n\n=head1 NAME\n\nBio::Tools::HMMER::Results - Object representing HMMER output results\n\n=head1 SYNOPSIS\n\n   # parse a hmmsearch file (can also parse a hmmpfam file)\n   $res = Bio::Tools::HMMER::Results->new( -file => 'output.hmm' ,\n                                          -type => 'hmmsearch');\n\n   # print out the results for each sequence\n   foreach $seq ( $res->each_Set ) {\n       print \"Sequence bit score is\",$seq->bits,\"\\n\";\n       foreach $domain ( $seq->each_Domain ) {\n           print \" Domain start \",$domain->start,\" end \",$domain->end,\n\t   \" score \",$domain->bits,\"\\n\";\n       }\n   }\n\n   # new result object on a sequence/domain cutoff of\n   # 25 bits sequence, 15 bits domain\n   $newresult = $res->filter_on_cutoff(25,15);\n\n   # alternative way of getting out all domains directly\n   foreach $domain ( $res->each_Domain ) {\n       print \"Domain on \",$domain->seq_id,\" with score \",\n       $domain->bits,\" evalue \",$domain->evalue,\"\\n\";\n   }\n\n=head1 DESCRIPTION\n\nThis object represents HMMER output, either from hmmsearch or\nhmmpfam. For hmmsearch, a series of HMMER::Set objects are made, one\nfor each sequence, which have the the bits score for the object. For\nhmmpfam searches, only one Set object is made.\n\n\nThese objects come from the original HMMResults modules used\ninternally in Pfam, written by Ewan Birney. Ewan then converted them to\nBioPerl objects in 1999. That conversion is meant to be backwardly\ncompatible, but may not be (caveat emptor).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::HMMER::Results;\n\nuse strict;\n\nuse Bio::Tools::HMMER::Domain;\nuse Bio::Tools::HMMER::Set;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::SeqAnalysisParserI);\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'domain'} = []; # array of HMMUnits\n  $self->{'seq'} = {};\n\n  my ($parsetype) = $self->_rearrange([qw(TYPE)],@args);\n  $self->_initialize_io(@args);\n  if( !defined $parsetype ) {\n      $self->throw(\"No parse type provided. should be hmmsearch or hmmpfam\");\n  }\n  $self->parsetype($parsetype);\n  if( defined $self->_fh() ) {\n      if( $parsetype eq 'hmmsearch' ) {\n\t  $self->_parse_hmmsearch($self->_fh());\n      } elsif ( $parsetype eq 'hmmpfam' ) {\n\t  $self->_parse_hmmpfam($self->_fh());\n      } else {\n\t  $self->throw(\"Did not recoginise type $parsetype\");\n      }\n  }\n\n  return $self; # success - we hope!\n}\n\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while( my $feat = $res->next_feature ) { # do something }\n Function: SeqAnalysisParserI implementing function\n Example :\n Returns : A Bio::SeqFeatureI compliant object, in this case,\n           each DomainUnit object, ie, flattening the Sequence\n           aspect of this.\n Args    : None\n\n\n\nsub next_feature{\n   my ($self) = @_;\n\n   if( $self->{'_started_next_feature'} == 1 ) {\n       return shift @{$self->{'_next_feature_array'}};\n   } else {\n       $self->{'_started_next_feature'} = 1;\n       my @array;\n       foreach my $seq ( $self->each_Set() ) {\n\t   foreach my $unit ( $seq->each_Domain() ) {\n\t       push(@array,$unit);\n\t   }\n       }\n       my $res = shift @array;\n       $self->{'_next_feature_array'} = \\@array;\n       return $res;\n   }\n\n   $self->throw(\"Should not reach here! Error!\");\n}\n\n\n=head2 number\n\n Title   : number\n Usage   : print \"There are \",$res->number,\" domains hit\\n\";\n Function: provides the number of domains in the HMMER report\n\n\nsub number {\n    my $self = shift;\n    my @val;\n    my $ref;\n    $ref = $self->{'domain'};\n\n\n    @val = @{$self->{'domain'}};\n    return scalar @val;\n}\n\n=head2 seqfile\n\n Title   : seqfile\n Usage   : $obj->seqfile($newval)\n Function:\n Example :\n Returns : value of seqfile\n Args    : newvalue (optional)\n\n\n\nsub seqfile{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'seqfile'} = $value;\n    }\n    return $self->{'seqfile'};\n\n}\n\n=head2 hmmfile\n\n Title   : hmmfile\n Usage   : $obj->hmmfile($newval)\n Function:\n Example :\n Returns : value of hmmfile\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"hmmfile","localvar":"my","kind":13,"line":224},{"containerName":"hmmfile","name":"$value","line":224,"kind":13},{"line":225,"kind":13,"containerName":"hmmfile","name":"$value"},{"containerName":"hmmfile","name":"$self","line":226,"kind":13},{"kind":13,"line":226,"containerName":"hmmfile","name":"$value"},{"kind":13,"line":228,"containerName":"hmmfile","name":"$self"}],"line":223,"kind":12,"range":{"end":{"line":230,"character":9999},"start":{"character":0,"line":223}},"name":"hmmfile"},{"kind":12,"children":[{"containerName":"add_Domain","name":"$self","definition":"my","localvar":"my","kind":13,"line":243},{"localvar":"my","name":"$unit","definition":"my","containerName":"add_Domain","line":244,"kind":13},{"kind":13,"line":245,"definition":"my","name":"$name","containerName":"add_Domain","localvar":"my"},{"name":"$name","containerName":"add_Domain","line":247,"kind":13},{"kind":13,"line":247,"name":"$unit","containerName":"add_Domain"},{"line":247,"kind":12,"containerName":"add_Domain","name":"seq_id"},{"kind":13,"line":249,"name":"$self","containerName":"add_Domain"},{"kind":13,"line":249,"containerName":"add_Domain","name":"$name"},{"name":"$self","containerName":"add_Domain","line":250,"kind":13},{"containerName":"add_Domain","name":"warn","kind":12,"line":250},{"kind":13,"line":252,"containerName":"add_Domain","name":"$self"},{"containerName":"add_Domain","name":"$name","line":252,"kind":13},{"name":"add_Domain","containerName":"add_Domain","line":252,"kind":12},{"kind":13,"line":252,"containerName":"add_Domain","name":"$unit"},{"containerName":"add_Domain","name":"$self","line":254,"kind":13}],"line":242,"definition":"sub","name":"add_Domain","containerName":"main::","range":{"end":{"line":254,"character":9999},"start":{"line":242,"character":0}}},{"kind":13,"line":254,"name":"$unit","containerName":null},{"containerName":"main::","definition":"sub","name":"each_Domain","range":{"end":{"line":273,"character":9999},"start":{"character":0,"line":269}},"kind":12,"line":269,"children":[{"localvar":"my","containerName":"each_Domain","name":"$self","definition":"my","line":270,"kind":13},{"line":271,"kind":13,"localvar":"my","containerName":"each_Domain","definition":"my","name":"@arr"},{"line":271,"kind":13,"name":"$u","containerName":"each_Domain"},{"name":"$u","containerName":"each_Domain","kind":13,"line":273},{"line":273,"kind":13,"containerName":"each_Domain","name":"$self"}]},{"kind":13,"line":274,"name":"@arr","containerName":null},{"name":"$u","containerName":null,"line":274,"kind":13},{"containerName":null,"name":"@arr","line":277,"kind":13},{"kind":12,"line":298,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"domain_bits_cutoff_from_evalue","line":299,"kind":13},{"line":300,"kind":13,"localvar":"my","definition":"my","name":"$eval","containerName":"domain_bits_cutoff_from_evalue"},{"line":301,"kind":13,"localvar":"my","containerName":"domain_bits_cutoff_from_evalue","name":"$dom","definition":"my"},{"line":301,"kind":13,"name":"$prev","containerName":"domain_bits_cutoff_from_evalue"},{"kind":13,"line":301,"name":"@doms","containerName":"domain_bits_cutoff_from_evalue"},{"containerName":"domain_bits_cutoff_from_evalue","name":"$cutoff","kind":13,"line":301},{"kind":13,"line":301,"containerName":"domain_bits_cutoff_from_evalue","name":"$sep"},{"line":301,"kind":13,"containerName":"domain_bits_cutoff_from_evalue","name":"$seen"},{"containerName":"domain_bits_cutoff_from_evalue","name":"@doms","line":303,"kind":13},{"kind":13,"line":303,"containerName":"domain_bits_cutoff_from_evalue","name":"$self"},{"kind":12,"line":303,"name":"each_Domain","containerName":"domain_bits_cutoff_from_evalue"},{"kind":13,"line":306,"containerName":"domain_bits_cutoff_from_evalue","name":"@doms"},{"containerName":"domain_bits_cutoff_from_evalue","name":"$b","line":307,"kind":13},{"name":"$a","containerName":"domain_bits_cutoff_from_evalue","kind":13,"line":307},{"line":308,"kind":12,"containerName":"domain_bits_cutoff_from_evalue","name":"bits"},{"name":"@doms","containerName":"domain_bits_cutoff_from_evalue","line":308,"kind":13},{"name":"$seen","containerName":"domain_bits_cutoff_from_evalue","kind":13,"line":309},{"name":"@doms","containerName":"domain_bits_cutoff_from_evalue","kind":13,"line":310},{"kind":12,"line":311,"containerName":"domain_bits_cutoff_from_evalue","name":"evalue"},{"kind":13,"line":311,"containerName":"domain_bits_cutoff_from_evalue","name":"$eval"},{"line":312,"kind":13,"name":"$seen","containerName":"domain_bits_cutoff_from_evalue"},{"name":"$dom","containerName":"domain_bits_cutoff_from_evalue","kind":13,"line":313},{"line":316,"kind":13,"name":"$prev","containerName":"domain_bits_cutoff_from_evalue"},{"name":"$prev","containerName":"domain_bits_cutoff_from_evalue","line":319,"kind":13},{"name":"$seen","containerName":"domain_bits_cutoff_from_evalue","kind":13,"line":319},{"containerName":"domain_bits_cutoff_from_evalue","name":"$self","kind":13,"line":320},{"line":320,"kind":12,"containerName":"domain_bits_cutoff_from_evalue","name":"throw"},{"line":324,"kind":13,"name":"$sep","containerName":"domain_bits_cutoff_from_evalue"},{"name":"$prev","containerName":"domain_bits_cutoff_from_evalue","line":324,"kind":13},{"line":324,"kind":12,"containerName":"domain_bits_cutoff_from_evalue","name":"bits"},{"line":324,"kind":13,"containerName":"domain_bits_cutoff_from_evalue","name":"$dom"},{"line":324,"kind":12,"containerName":"domain_bits_cutoff_from_evalue","name":"bits"},{"kind":13,"line":326,"name":"$sep","containerName":"domain_bits_cutoff_from_evalue"},{"containerName":"domain_bits_cutoff_from_evalue","name":"$prev","kind":13,"line":327},{"line":327,"kind":12,"name":"bits","containerName":"domain_bits_cutoff_from_evalue"},{"kind":13,"line":329,"name":"$dom","containerName":"domain_bits_cutoff_from_evalue"},{"name":"bits","containerName":"domain_bits_cutoff_from_evalue","kind":12,"line":329},{"line":329,"kind":13,"name":"$prev","containerName":"domain_bits_cutoff_from_evalue"},{"name":"bits","containerName":"domain_bits_cutoff_from_evalue","line":329,"kind":12},{"containerName":"domain_bits_cutoff_from_evalue","name":"$dom","line":333,"kind":13},{"line":333,"kind":12,"containerName":"domain_bits_cutoff_from_evalue","name":"bits"},{"containerName":"domain_bits_cutoff_from_evalue","name":"$sep","kind":13,"line":333}],"containerName":"main::","definition":"sub","name":"domain_bits_cutoff_from_evalue","range":{"start":{"character":0,"line":298},"end":{"line":335,"character":9999}}},{"range":{"start":{"line":338,"character":0},"end":{"line":347,"character":9999}},"name":"dictate_hmm_acc","definition":"sub","containerName":"main::","children":[{"containerName":"dictate_hmm_acc","name":"$self","definition":"my","localvar":"my","kind":13,"line":339},{"localvar":"my","containerName":"dictate_hmm_acc","name":"$acc","definition":"my","line":340,"kind":13},{"kind":13,"line":341,"containerName":"dictate_hmm_acc","name":"$unit","definition":"my","localvar":"my"},{"containerName":"dictate_hmm_acc","name":"$unit","line":344,"kind":13},{"kind":13,"line":344,"containerName":"dictate_hmm_acc","name":"$self"},{"line":344,"kind":12,"containerName":"dictate_hmm_acc","name":"eachHMMUnit"},{"name":"$unit","containerName":"dictate_hmm_acc","line":345,"kind":13},{"kind":12,"line":345,"name":"hmmacc","containerName":"dictate_hmm_acc"},{"containerName":"dictate_hmm_acc","name":"$acc","line":345,"kind":13}],"line":338,"kind":12},{"definition":"sub","name":"write_FT_output","containerName":"main::","range":{"start":{"character":0,"line":360},"end":{"line":378,"character":9999}},"kind":12,"children":[{"containerName":"write_FT_output","name":"$self","definition":"my","localvar":"my","kind":13,"line":361},{"line":362,"kind":13,"localvar":"my","name":"$file","definition":"my","containerName":"write_FT_output"},{"line":363,"kind":13,"localvar":"my","definition":"my","name":"$idt","containerName":"write_FT_output"},{"localvar":"my","name":"$seq","definition":"my","containerName":"write_FT_output","line":364,"kind":13},{"kind":13,"line":364,"containerName":"write_FT_output","name":"$unit"},{"name":"$idt","containerName":"write_FT_output","line":366,"kind":13},{"kind":13,"line":367,"name":"$idt","containerName":"write_FT_output"},{"kind":13,"line":370,"name":"$seq","containerName":"write_FT_output"},{"line":370,"kind":13,"name":"$self","containerName":"write_FT_output"},{"kind":12,"line":370,"name":"each_Set","containerName":"write_FT_output"},{"kind":13,"line":371,"containerName":"write_FT_output","name":"$file"},{"kind":13,"line":371,"name":"$seq","containerName":"write_FT_output"},{"name":"name","containerName":"write_FT_output","line":371,"kind":12},{"name":"$unit","containerName":"write_FT_output","line":372,"kind":13},{"name":"$seq","containerName":"write_FT_output","kind":13,"line":372},{"name":"each_Domain","containerName":"write_FT_output","kind":12,"line":372},{"name":"$file","containerName":"write_FT_output","kind":13,"line":373},{"name":"$idt","containerName":"write_FT_output","kind":13,"line":373},{"containerName":"write_FT_output","name":"$unit","kind":13,"line":374},{"line":374,"kind":12,"containerName":"write_FT_output","name":"start"},{"kind":13,"line":374,"name":"$unit","containerName":"write_FT_output"},{"line":374,"kind":12,"name":"end","containerName":"write_FT_output"},{"kind":13,"line":374,"containerName":"write_FT_output","name":"$unit"},{"line":374,"kind":12,"name":"hmmname","containerName":"write_FT_output"},{"kind":13,"line":376,"name":"$file","containerName":"write_FT_output"}],"line":360},{"range":{"end":{"character":9999,"line":413},"start":{"character":0,"line":392}},"definition":"sub","name":"filter_on_cutoff","containerName":"main::","children":[{"kind":13,"line":393,"definition":"my","name":"$self","containerName":"filter_on_cutoff","localvar":"my"},{"line":394,"kind":13,"localvar":"my","definition":"my","name":"$seqthr","containerName":"filter_on_cutoff"},{"localvar":"my","containerName":"filter_on_cutoff","definition":"my","name":"$domthr","line":395,"kind":13},{"kind":13,"line":396,"containerName":"filter_on_cutoff","name":"$new","definition":"my","localvar":"my"},{"containerName":"filter_on_cutoff","name":"$seq","line":396,"kind":13},{"kind":13,"line":396,"containerName":"filter_on_cutoff","name":"$unit"},{"line":396,"kind":13,"containerName":"filter_on_cutoff","name":"@array"},{"containerName":"filter_on_cutoff","name":"@narray","line":396,"kind":13},{"kind":13,"line":398,"containerName":"filter_on_cutoff","name":"$domthr"},{"line":399,"kind":13,"name":"$self","containerName":"filter_on_cutoff"},{"line":399,"kind":12,"name":"throw","containerName":"filter_on_cutoff"},{"containerName":"filter_on_cutoff","name":"$new","line":402,"kind":13},{"containerName":"filter_on_cutoff","name":"new","kind":12,"line":402},{"containerName":"filter_on_cutoff","name":"$self","kind":13,"line":402},{"line":402,"kind":12,"name":"parsetype","containerName":"filter_on_cutoff"},{"containerName":"filter_on_cutoff","name":"$seq","kind":13,"line":404},{"name":"$self","containerName":"filter_on_cutoff","line":404,"kind":13},{"kind":12,"line":404,"containerName":"filter_on_cutoff","name":"each_Set"},{"containerName":"filter_on_cutoff","name":"$seq","line":405,"kind":13},{"name":"bits","containerName":"filter_on_cutoff","kind":12,"line":405},{"line":405,"kind":13,"name":"$seqthr","containerName":"filter_on_cutoff"},{"kind":13,"line":406,"containerName":"filter_on_cutoff","name":"$new"},{"name":"add_Set","containerName":"filter_on_cutoff","kind":12,"line":406},{"name":"$seq","containerName":"filter_on_cutoff","kind":13,"line":406},{"containerName":"filter_on_cutoff","name":"$unit","kind":13,"line":407},{"line":407,"kind":13,"containerName":"filter_on_cutoff","name":"$seq"},{"containerName":"filter_on_cutoff","name":"each_Domain","line":407,"kind":12},{"kind":13,"line":408,"containerName":"filter_on_cutoff","name":"$unit"},{"kind":12,"line":408,"containerName":"filter_on_cutoff","name":"bits"},{"line":408,"kind":13,"containerName":"filter_on_cutoff","name":"$domthr"},{"kind":13,"line":409,"containerName":"filter_on_cutoff","name":"$new"},{"line":409,"kind":12,"name":"add_Domain","containerName":"filter_on_cutoff"},{"containerName":"filter_on_cutoff","name":"$unit","line":409,"kind":13},{"name":"$new","containerName":"filter_on_cutoff","kind":13,"line":412}],"line":392,"kind":12},{"line":402,"kind":12,"name":"Bio","containerName":"Tools::HMMER::Results"},{"children":[{"localvar":"my","containerName":"write_ascii_out","definition":"my","name":"$self","line":431,"kind":13},{"kind":13,"line":432,"name":"$fh","definition":"my","containerName":"write_ascii_out","localvar":"my"},{"definition":"my","name":"$unit","containerName":"write_ascii_out","localvar":"my","kind":13,"line":433},{"kind":13,"line":433,"name":"$seq","containerName":"write_ascii_out"},{"name":"$fh","containerName":"write_ascii_out","kind":13,"line":435},{"name":"$fh","containerName":"write_ascii_out","line":436,"kind":13},{"containerName":"write_ascii_out","name":"$seq","line":440,"kind":13},{"line":440,"kind":13,"name":"$self","containerName":"write_ascii_out"},{"name":"each_Set","containerName":"write_ascii_out","kind":12,"line":440},{"line":441,"kind":13,"containerName":"write_ascii_out","name":"$unit"},{"line":441,"kind":13,"containerName":"write_ascii_out","name":"$seq"},{"kind":12,"line":441,"containerName":"write_ascii_out","name":"each_Domain"},{"name":"$fh","containerName":"write_ascii_out","kind":13,"line":442},{"containerName":"write_ascii_out","name":"$unit","kind":13,"line":443},{"name":"seq_id","containerName":"write_ascii_out","kind":12,"line":443},{"containerName":"write_ascii_out","name":"$unit","line":443,"kind":13},{"kind":12,"line":443,"containerName":"write_ascii_out","name":"start"},{"containerName":"write_ascii_out","name":"$unit","line":443,"kind":13},{"containerName":"write_ascii_out","name":"end","kind":12,"line":443},{"kind":13,"line":444,"name":"$unit","containerName":"write_ascii_out"},{"containerName":"write_ascii_out","name":"hmmacc","line":444,"kind":12},{"containerName":"write_ascii_out","name":"$unit","line":444,"kind":13},{"name":"hstart","containerName":"write_ascii_out","kind":12,"line":444},{"containerName":"write_ascii_out","name":"$unit","kind":13,"line":444},{"name":"hend","containerName":"write_ascii_out","line":444,"kind":12},{"line":445,"kind":13,"name":"$unit","containerName":"write_ascii_out"},{"name":"bits","containerName":"write_ascii_out","kind":12,"line":445},{"containerName":"write_ascii_out","name":"$unit","kind":13,"line":445},{"line":445,"kind":12,"name":"evalue","containerName":"write_ascii_out"},{"containerName":"write_ascii_out","name":"$unit","kind":13,"line":445},{"name":"hmmname","containerName":"write_ascii_out","line":445,"kind":12}],"line":430,"kind":12,"range":{"end":{"line":449,"character":9999},"start":{"character":0,"line":430}},"definition":"sub","name":"write_ascii_out","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"write_GDF_bits","range":{"end":{"line":506,"character":9999},"start":{"character":0,"line":461}},"kind":12,"line":461,"children":[{"kind":13,"line":462,"containerName":"write_GDF_bits","name":"$self","definition":"my","localvar":"my"},{"line":463,"kind":13,"localvar":"my","name":"$seqt","definition":"my","containerName":"write_GDF_bits"},{"line":464,"kind":13,"localvar":"my","definition":"my","name":"$domt","containerName":"write_GDF_bits"},{"line":465,"kind":13,"localvar":"my","containerName":"write_GDF_bits","name":"$file","definition":"my"},{"containerName":"write_GDF_bits","name":"$seq","definition":"my","localvar":"my","kind":13,"line":466},{"kind":13,"line":467,"containerName":"write_GDF_bits","definition":"my","name":"$unit","localvar":"my"},{"containerName":"write_GDF_bits","definition":"my","name":"@array","localvar":"my","kind":13,"line":468},{"line":468,"kind":13,"name":"@narray","containerName":"write_GDF_bits"},{"name":"$file","containerName":"write_GDF_bits","kind":13,"line":470},{"name":"$self","containerName":"write_GDF_bits","kind":13,"line":471},{"name":"throw","containerName":"write_GDF_bits","kind":12,"line":471},{"kind":13,"line":475,"name":"$seq","containerName":"write_GDF_bits"},{"kind":13,"line":475,"name":"$self","containerName":"write_GDF_bits"},{"name":"each_Set","containerName":"write_GDF_bits","kind":12,"line":475},{"containerName":"write_GDF_bits","name":"$seq","line":477,"kind":13},{"containerName":"write_GDF_bits","name":"bits","line":477,"kind":12},{"line":477,"kind":13,"name":"$seqt","containerName":"write_GDF_bits"},{"kind":13,"line":481,"name":"$unit","containerName":"write_GDF_bits"},{"kind":13,"line":481,"name":"$seq","containerName":"write_GDF_bits"},{"name":"each_Domain","containerName":"write_GDF_bits","kind":12,"line":481},{"containerName":"write_GDF_bits","name":"$unit","line":482,"kind":13},{"containerName":"write_GDF_bits","name":"bits","kind":12,"line":482},{"containerName":"write_GDF_bits","name":"$domt","kind":13,"line":482},{"containerName":"write_GDF_bits","name":"@array","line":485,"kind":13},{"kind":13,"line":485,"containerName":"write_GDF_bits","name":"$unit"},{"name":"@narray","containerName":"write_GDF_bits","kind":13,"line":490},{"kind":13,"line":490,"containerName":"write_GDF_bits","definition":"my","name":"$aa","localvar":"my"},{"line":490,"kind":13,"name":"$bb","containerName":"write_GDF_bits"},{"line":490,"kind":13,"containerName":"write_GDF_bits","name":"$st_a"},{"containerName":"write_GDF_bits","name":"$st_b","kind":13,"line":490},{"kind":13,"line":491,"containerName":"write_GDF_bits","name":"$aa"},{"name":"$a","containerName":"write_GDF_bits","kind":13,"line":491},{"line":491,"kind":12,"containerName":"write_GDF_bits","name":"seq_id"},{"name":"$bb","containerName":"write_GDF_bits","kind":13,"line":492},{"containerName":"write_GDF_bits","name":"$b","line":492,"kind":13},{"line":492,"kind":12,"name":"seq_id","containerName":"write_GDF_bits"},{"containerName":"write_GDF_bits","name":"$aa","kind":13,"line":493},{"kind":13,"line":493,"name":"$bb","containerName":"write_GDF_bits"},{"line":494,"kind":13,"name":"$st_a","containerName":"write_GDF_bits"},{"line":494,"kind":13,"containerName":"write_GDF_bits","name":"$a"},{"name":"start","containerName":"write_GDF_bits","kind":12,"line":494},{"kind":13,"line":495,"name":"$st_b","containerName":"write_GDF_bits"},{"kind":13,"line":495,"containerName":"write_GDF_bits","name":"$b"},{"name":"start","containerName":"write_GDF_bits","line":495,"kind":12},{"line":496,"kind":13,"containerName":"write_GDF_bits","name":"$st_a"},{"kind":13,"line":496,"name":"$st_b","containerName":"write_GDF_bits"},{"line":499,"kind":13,"name":"$aa","containerName":"write_GDF_bits"},{"containerName":"write_GDF_bits","name":"$bb","kind":13,"line":499},{"kind":13,"line":500,"containerName":"write_GDF_bits","name":"@array"},{"name":"$unit","containerName":"write_GDF_bits","line":502,"kind":13},{"line":502,"kind":13,"name":"@narray","containerName":"write_GDF_bits"},{"containerName":"write_GDF_bits","name":"$file","kind":13,"line":503},{"kind":13,"line":503,"containerName":"write_GDF_bits","name":"$unit"},{"containerName":"write_GDF_bits","name":"get_nse","line":503,"kind":12},{"containerName":"write_GDF_bits","name":"$unit","line":503,"kind":13},{"kind":12,"line":503,"name":"start","containerName":"write_GDF_bits"},{"line":503,"kind":13,"name":"$unit","containerName":"write_GDF_bits"},{"kind":12,"line":503,"name":"end","containerName":"write_GDF_bits"},{"kind":13,"line":503,"name":"$unit","containerName":"write_GDF_bits"},{"containerName":"write_GDF_bits","name":"seq_id","line":503,"kind":12},{"containerName":"write_GDF_bits","name":"$unit","kind":13,"line":503},{"kind":12,"line":503,"containerName":"write_GDF_bits","name":"bits"},{"name":"$unit","containerName":"write_GDF_bits","kind":13,"line":503},{"line":503,"kind":12,"containerName":"write_GDF_bits","name":"evalue"}]},{"range":{"start":{"line":508,"character":0},"end":{"line":547,"character":9999}},"containerName":"main::","definition":"sub","name":"write_scores_bits","line":508,"children":[{"localvar":"my","containerName":"write_scores_bits","definition":"my","name":"$self","line":509,"kind":13},{"kind":13,"line":510,"containerName":"write_scores_bits","name":"$seqt","definition":"my","localvar":"my"},{"localvar":"my","containerName":"write_scores_bits","definition":"my","name":"$domt","line":511,"kind":13},{"localvar":"my","containerName":"write_scores_bits","name":"$file","definition":"my","line":512,"kind":13},{"localvar":"my","definition":"my","name":"$seq","containerName":"write_scores_bits","line":513,"kind":13},{"localvar":"my","name":"$unit","definition":"my","containerName":"write_scores_bits","line":514,"kind":13},{"localvar":"my","containerName":"write_scores_bits","definition":"my","name":"@array","line":515,"kind":13},{"containerName":"write_scores_bits","name":"@narray","kind":13,"line":515},{"line":517,"kind":13,"name":"$file","containerName":"write_scores_bits"},{"line":518,"kind":13,"containerName":"write_scores_bits","name":"$self"},{"name":"warn","containerName":"write_scores_bits","kind":12,"line":518},{"name":"$seq","containerName":"write_scores_bits","line":522,"kind":13},{"name":"$self","containerName":"write_scores_bits","line":522,"kind":13},{"name":"eachHMMSequence","containerName":"write_scores_bits","kind":12,"line":522},{"line":524,"kind":13,"containerName":"write_scores_bits","name":"$seq"},{"name":"bits","containerName":"write_scores_bits","kind":12,"line":524},{"line":524,"kind":13,"containerName":"write_scores_bits","name":"$seqt"},{"containerName":"write_scores_bits","name":"$unit","line":528,"kind":13},{"line":528,"kind":13,"name":"$seq","containerName":"write_scores_bits"},{"kind":12,"line":528,"name":"eachHMMUnit","containerName":"write_scores_bits"},{"kind":13,"line":529,"name":"$unit","containerName":"write_scores_bits"},{"containerName":"write_scores_bits","name":"bits","line":529,"kind":12},{"line":529,"kind":13,"name":"$domt","containerName":"write_scores_bits"},{"name":"@array","containerName":"write_scores_bits","kind":13,"line":532},{"containerName":"write_scores_bits","name":"$unit","kind":13,"line":532},{"name":"@narray","containerName":"write_scores_bits","kind":13,"line":537},{"name":"$aa","definition":"my","containerName":"write_scores_bits","localvar":"my","kind":13,"line":537},{"kind":13,"line":537,"containerName":"write_scores_bits","name":"$bb"},{"containerName":"write_scores_bits","name":"$st_a","kind":13,"line":537},{"kind":13,"line":537,"containerName":"write_scores_bits","name":"$st_b"},{"line":538,"kind":13,"containerName":"write_scores_bits","name":"$aa"},{"kind":13,"line":538,"containerName":"write_scores_bits","name":"$a"},{"containerName":"write_scores_bits","name":"bits","line":538,"kind":12},{"containerName":"write_scores_bits","name":"$bb","kind":13,"line":539},{"line":539,"kind":13,"name":"$b","containerName":"write_scores_bits"},{"kind":12,"line":539,"containerName":"write_scores_bits","name":"bits"},{"containerName":"write_scores_bits","name":"$aa","line":540,"kind":13},{"name":"$bb","containerName":"write_scores_bits","kind":13,"line":540},{"line":541,"kind":13,"containerName":"write_scores_bits","name":"@array"},{"containerName":"write_scores_bits","name":"$unit","line":543,"kind":13},{"name":"@narray","containerName":"write_scores_bits","kind":13,"line":543},{"kind":13,"line":544,"containerName":"write_scores_bits","name":"$file"},{"name":"$unit","containerName":"write_scores_bits","kind":13,"line":544},{"containerName":"write_scores_bits","name":"bits","line":544,"kind":12},{"containerName":"write_scores_bits","name":"$unit","kind":13,"line":544},{"kind":12,"line":544,"containerName":"write_scores_bits","name":"get_nse"}],"kind":12},{"containerName":"main::","definition":"sub","name":"write_GDF","range":{"end":{"character":9999,"line":563},"start":{"character":0,"line":549}},"kind":12,"line":549,"children":[{"kind":13,"line":550,"name":"$self","definition":"my","containerName":"write_GDF","localvar":"my"},{"localvar":"my","name":"$file","definition":"my","containerName":"write_GDF","line":551,"kind":13},{"localvar":"my","name":"$unit","definition":"my","containerName":"write_GDF","line":552,"kind":13},{"name":"$file","containerName":"write_GDF","line":554,"kind":13},{"name":"$file","containerName":"write_GDF","kind":13,"line":555},{"line":559,"kind":13,"containerName":"write_GDF","name":"$unit"},{"containerName":"write_GDF","name":"$self","kind":13,"line":559},{"kind":12,"line":559,"name":"eachHMMUnit","containerName":"write_GDF"},{"kind":13,"line":560,"name":"$file","containerName":"write_GDF"},{"name":"$unit","containerName":"write_GDF","line":560,"kind":13},{"name":"get_nse","containerName":"write_GDF","kind":12,"line":560},{"line":560,"kind":13,"containerName":"write_GDF","name":"$unit"},{"line":560,"kind":12,"containerName":"write_GDF","name":"start"},{"containerName":"write_GDF","name":"$unit","line":560,"kind":13},{"name":"end","containerName":"write_GDF","kind":12,"line":560},{"containerName":"write_GDF","name":"$unit","kind":13,"line":560},{"containerName":"write_GDF","name":"seq_id","line":560,"kind":12},{"line":560,"kind":13,"name":"$unit","containerName":"write_GDF"},{"kind":12,"line":560,"containerName":"write_GDF","name":"bits"},{"line":560,"kind":13,"containerName":"write_GDF","name":"$unit"},{"line":560,"kind":12,"name":"evalue","containerName":"write_GDF"}]},{"children":[{"localvar":"my","containerName":"highest_noise","definition":"my","name":"$self","line":566,"kind":13},{"line":567,"kind":13,"localvar":"my","name":"$seqt","definition":"my","containerName":"highest_noise"},{"localvar":"my","definition":"my","name":"$domt","containerName":"highest_noise","line":568,"kind":13},{"kind":13,"line":569,"containerName":"highest_noise","name":"$seq","definition":"my","localvar":"my"},{"kind":13,"line":569,"containerName":"highest_noise","name":"$unit"},{"line":569,"kind":13,"containerName":"highest_noise","name":"$hseq"},{"containerName":"highest_noise","name":"$hdom","kind":13,"line":569},{"line":569,"kind":13,"name":"$noiseseq","containerName":"highest_noise"},{"name":"$noisedom","containerName":"highest_noise","line":569,"kind":13},{"line":571,"kind":13,"name":"$hseq","containerName":"highest_noise"},{"line":571,"kind":13,"containerName":"highest_noise","name":"$hdom"},{"containerName":"highest_noise","name":"$seq","line":573,"kind":13},{"name":"$self","containerName":"highest_noise","kind":13,"line":573},{"line":573,"kind":12,"name":"eachHMMSequence","containerName":"highest_noise"},{"kind":13,"line":574,"name":"$seq","containerName":"highest_noise"},{"name":"bits","containerName":"highest_noise","line":574,"kind":12},{"kind":13,"line":574,"containerName":"highest_noise","name":"$seqt"},{"name":"$seq","containerName":"highest_noise","kind":13,"line":574},{"line":574,"kind":12,"name":"bits","containerName":"highest_noise"},{"kind":13,"line":574,"containerName":"highest_noise","name":"$hseq"},{"name":"$hseq","containerName":"highest_noise","line":575,"kind":13},{"name":"$seq","containerName":"highest_noise","kind":13,"line":575},{"name":"bits","containerName":"highest_noise","kind":12,"line":575},{"kind":13,"line":576,"name":"$noiseseq","containerName":"highest_noise"},{"containerName":"highest_noise","name":"$seq","kind":13,"line":576},{"name":"$unit","containerName":"highest_noise","line":578,"kind":13},{"line":578,"kind":13,"name":"$seq","containerName":"highest_noise"},{"kind":12,"line":578,"name":"eachHMMUnit","containerName":"highest_noise"},{"kind":13,"line":579,"name":"$seq","containerName":"highest_noise"},{"line":579,"kind":12,"containerName":"highest_noise","name":"bits"},{"line":579,"kind":13,"containerName":"highest_noise","name":"$seqt"},{"containerName":"highest_noise","name":"$seq","line":579,"kind":13},{"name":"bits","containerName":"highest_noise","line":579,"kind":12},{"line":579,"kind":13,"name":"$seqt","containerName":"highest_noise"},{"containerName":"highest_noise","name":"$unit","line":579,"kind":13},{"name":"bits","containerName":"highest_noise","line":579,"kind":12},{"name":"$domt","containerName":"highest_noise","line":579,"kind":13},{"containerName":"highest_noise","name":"$unit","line":579,"kind":13},{"name":"bits","containerName":"highest_noise","line":579,"kind":12},{"kind":13,"line":579,"name":"$hdom","containerName":"highest_noise"},{"containerName":"highest_noise","name":"$hdom","kind":13,"line":580},{"line":580,"kind":13,"containerName":"highest_noise","name":"$unit"},{"containerName":"highest_noise","name":"bits","kind":12,"line":580},{"name":"$noisedom","containerName":"highest_noise","kind":13,"line":581},{"containerName":"highest_noise","name":"$unit","kind":13,"line":581},{"name":"$noiseseq","containerName":"highest_noise","line":587,"kind":13},{"line":587,"kind":13,"containerName":"highest_noise","name":"$noisedom"}],"line":565,"kind":12,"range":{"start":{"character":0,"line":565},"end":{"character":9999,"line":589}},"name":"highest_noise","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":592},"end":{"line":626,"character":9999}},"containerName":"main::","definition":"sub","name":"lowest_true","line":592,"children":[{"line":593,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"lowest_true"},{"kind":13,"line":594,"name":"$seqt","definition":"my","containerName":"lowest_true","localvar":"my"},{"localvar":"my","containerName":"lowest_true","definition":"my","name":"$domt","line":595,"kind":13},{"definition":"my","name":"$seq","containerName":"lowest_true","localvar":"my","kind":13,"line":596},{"name":"$unit","containerName":"lowest_true","kind":13,"line":596},{"line":596,"kind":13,"name":"$lowseq","containerName":"lowest_true"},{"line":596,"kind":13,"containerName":"lowest_true","name":"$lowdom"},{"kind":13,"line":596,"containerName":"lowest_true","name":"$trueseq"},{"line":596,"kind":13,"name":"$truedom","containerName":"lowest_true"},{"kind":13,"line":598,"name":"$domt","containerName":"lowest_true"},{"name":"$self","containerName":"lowest_true","line":599,"kind":13},{"name":"warn","containerName":"lowest_true","kind":12,"line":599},{"name":"$lowseq","containerName":"lowest_true","kind":13,"line":603},{"kind":13,"line":603,"containerName":"lowest_true","name":"$lowdom"},{"line":605,"kind":13,"containerName":"lowest_true","name":"$seq"},{"line":605,"kind":13,"containerName":"lowest_true","name":"$self"},{"line":605,"kind":12,"containerName":"lowest_true","name":"eachHMMSequence"},{"line":607,"kind":13,"name":"$seq","containerName":"lowest_true"},{"containerName":"lowest_true","name":"bits","line":607,"kind":12},{"name":"$seqt","containerName":"lowest_true","line":607,"kind":13},{"name":"$seq","containerName":"lowest_true","kind":13,"line":607},{"line":607,"kind":12,"name":"bits","containerName":"lowest_true"},{"containerName":"lowest_true","name":"$lowseq","line":607,"kind":13},{"containerName":"lowest_true","name":"$lowseq","line":608,"kind":13},{"line":608,"kind":13,"containerName":"lowest_true","name":"$seq"},{"line":608,"kind":12,"name":"bits","containerName":"lowest_true"},{"kind":13,"line":609,"containerName":"lowest_true","name":"$trueseq"},{"name":"$seq","containerName":"lowest_true","line":609,"kind":13},{"containerName":"lowest_true","name":"$seq","kind":13,"line":611},{"kind":12,"line":611,"name":"bits","containerName":"lowest_true"},{"containerName":"lowest_true","name":"$seqt","line":611,"kind":13},{"name":"$unit","containerName":"lowest_true","line":615,"kind":13},{"kind":13,"line":615,"name":"$seq","containerName":"lowest_true"},{"containerName":"lowest_true","name":"eachHMMUnit","line":615,"kind":12},{"name":"$unit","containerName":"lowest_true","kind":13,"line":616},{"containerName":"lowest_true","name":"bits","kind":12,"line":616},{"name":"$domt","containerName":"lowest_true","kind":13,"line":616},{"containerName":"lowest_true","name":"$unit","line":616,"kind":13},{"name":"bits","containerName":"lowest_true","kind":12,"line":616},{"name":"$lowdom","containerName":"lowest_true","kind":13,"line":616},{"containerName":"lowest_true","name":"$lowdom","line":617,"kind":13},{"name":"$unit","containerName":"lowest_true","kind":13,"line":617},{"line":617,"kind":12,"containerName":"lowest_true","name":"bits"},{"kind":13,"line":618,"name":"$truedom","containerName":"lowest_true"},{"name":"$unit","containerName":"lowest_true","kind":13,"line":618},{"containerName":"lowest_true","name":"$trueseq","line":624,"kind":13},{"line":624,"kind":13,"containerName":"lowest_true","name":"$truedom"}],"kind":12},{"kind":12,"children":[{"line":642,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"add_Set"},{"kind":13,"line":643,"containerName":"add_Set","definition":"my","name":"$seq","localvar":"my"},{"line":644,"kind":13,"localvar":"my","containerName":"add_Set","name":"$name","definition":"my"},{"containerName":"add_Set","name":"$name","kind":13,"line":646},{"containerName":"add_Set","name":"$seq","kind":13,"line":646},{"kind":12,"line":646,"name":"name","containerName":"add_Set"},{"kind":13,"line":648,"name":"$self","containerName":"add_Set"},{"kind":13,"line":648,"containerName":"add_Set","name":"$name"},{"kind":13,"line":649,"containerName":"add_Set","name":"$self"},{"kind":12,"line":649,"containerName":"add_Set","name":"throw"},{"containerName":"add_Set","name":"$self","line":651,"kind":13},{"containerName":"add_Set","name":"$name","line":651,"kind":13},{"name":"$seq","containerName":"add_Set","kind":13,"line":651}],"line":641,"definition":"sub","name":"add_Set","containerName":"main::","range":{"end":{"character":9999,"line":652},"start":{"character":0,"line":641}}},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"each_Set","localvar":"my","kind":13,"line":667},{"line":668,"kind":13,"localvar":"my","containerName":"each_Set","name":"@array","definition":"my"},{"containerName":"each_Set","name":"$name","line":668,"kind":13},{"line":671,"kind":13,"containerName":"each_Set","name":"$name"},{"containerName":"each_Set","name":"$self","line":671,"kind":13}],"line":666,"definition":"sub","name":"each_Set","containerName":"main::","range":{"start":{"line":666,"character":0},"end":{"character":9999,"line":671}}},{"containerName":null,"name":"@array","line":672,"kind":13},{"line":672,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":672,"name":"$name","containerName":null},{"line":674,"kind":13,"name":"@array","containerName":null},{"kind":12,"line":689,"children":[{"localvar":"my","containerName":"get_Set","definition":"my","name":"$self","line":690,"kind":13},{"kind":13,"line":691,"containerName":"get_Set","definition":"my","name":"$name","localvar":"my"},{"containerName":"get_Set","name":"$self","kind":13,"line":693},{"containerName":"get_Set","name":"$name","kind":13,"line":693}],"containerName":"main::","definition":"sub","name":"get_Set","range":{"end":{"character":9999,"line":694},"start":{"line":689,"character":0}}},{"containerName":"main::","definition":"sub","name":"_parse_hmmpfam","range":{"start":{"line":708,"character":0},"end":{"line":827,"character":9999}},"kind":12,"line":708,"children":[{"definition":"my","name":"$self","containerName":"_parse_hmmpfam","localvar":"my","kind":13,"line":709},{"line":710,"kind":13,"localvar":"my","name":"$file","definition":"my","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","definition":"my","name":"$id","localvar":"my","kind":13,"line":712},{"name":"$sqfrom","containerName":"_parse_hmmpfam","line":712,"kind":13},{"name":"$sqto","containerName":"_parse_hmmpfam","line":712,"kind":13},{"kind":13,"line":712,"name":"$hmmf","containerName":"_parse_hmmpfam"},{"kind":13,"line":712,"containerName":"_parse_hmmpfam","name":"$hmmt"},{"name":"$sc","containerName":"_parse_hmmpfam","line":712,"kind":13},{"kind":13,"line":712,"containerName":"_parse_hmmpfam","name":"$ev"},{"kind":13,"line":713,"name":"$unit","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"$nd","line":713,"kind":13},{"kind":13,"line":713,"name":"$seq","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"$name","kind":13,"line":713},{"line":713,"kind":13,"containerName":"_parse_hmmpfam","name":"$seqname"},{"kind":13,"line":713,"containerName":"_parse_hmmpfam","name":"$from"},{"containerName":"_parse_hmmpfam","name":"$to","line":714,"kind":13},{"line":714,"kind":13,"containerName":"_parse_hmmpfam","name":"%hash"},{"containerName":"_parse_hmmpfam","name":"%acc","kind":13,"line":714},{"containerName":"_parse_hmmpfam","name":"$acc","kind":13,"line":714},{"localvar":"my","containerName":"_parse_hmmpfam","name":"$count","definition":"my","line":715,"kind":13},{"kind":13,"line":717,"name":"$file","containerName":"_parse_hmmpfam"},{"line":718,"kind":13,"name":"$self","containerName":"_parse_hmmpfam"},{"name":"hmmfile","containerName":"_parse_hmmpfam","line":718,"kind":12},{"containerName":"_parse_hmmpfam","name":"$self","line":719,"kind":13},{"containerName":"_parse_hmmpfam","name":"seqfile","kind":12,"line":719},{"containerName":"_parse_hmmpfam","name":"$seqname","kind":13,"line":722},{"kind":13,"line":724,"name":"$seq","containerName":"_parse_hmmpfam"},{"line":724,"kind":12,"containerName":"_parse_hmmpfam","name":"new"},{"line":726,"kind":13,"name":"$seq","containerName":"_parse_hmmpfam"},{"kind":12,"line":726,"containerName":"_parse_hmmpfam","name":"name"},{"kind":13,"line":726,"containerName":"_parse_hmmpfam","name":"$seqname"},{"kind":13,"line":727,"name":"$self","containerName":"_parse_hmmpfam"},{"name":"add_Set","containerName":"_parse_hmmpfam","kind":12,"line":727},{"line":727,"kind":13,"name":"$seq","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"%hash","kind":13,"line":728},{"containerName":"_parse_hmmpfam","name":"$file","line":730,"kind":13},{"kind":13,"line":732,"containerName":"_parse_hmmpfam","name":"$seq"},{"line":732,"kind":12,"name":"accession","containerName":"_parse_hmmpfam"},{"kind":13,"line":733,"name":"$seq","containerName":"_parse_hmmpfam"},{"kind":12,"line":733,"name":"desc","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"$id","kind":13,"line":739},{"containerName":"_parse_hmmpfam","name":"$acc","kind":13,"line":739},{"containerName":"_parse_hmmpfam","name":"$sc","kind":13,"line":739},{"kind":13,"line":739,"name":"$ev","containerName":"_parse_hmmpfam"},{"line":739,"kind":13,"name":"$nd","containerName":"_parse_hmmpfam"},{"kind":13,"line":740,"containerName":"_parse_hmmpfam","name":"$hash"},{"line":740,"kind":13,"name":"$id","containerName":"_parse_hmmpfam"},{"name":"$sc","containerName":"_parse_hmmpfam","line":740,"kind":13},{"containerName":"_parse_hmmpfam","name":"$acc","kind":13,"line":742},{"containerName":"_parse_hmmpfam","name":"$id","kind":13,"line":742},{"name":"$acc","containerName":"_parse_hmmpfam","kind":13,"line":742},{"line":745,"kind":13,"name":"$id","containerName":"_parse_hmmpfam"},{"kind":13,"line":745,"name":"$sc","containerName":"_parse_hmmpfam"},{"name":"$ev","containerName":"_parse_hmmpfam","kind":13,"line":745},{"name":"$nd","containerName":"_parse_hmmpfam","line":745,"kind":13},{"containerName":"_parse_hmmpfam","name":"$hash","kind":13,"line":748},{"kind":13,"line":748,"name":"$id","containerName":"_parse_hmmpfam"},{"line":748,"kind":13,"containerName":"_parse_hmmpfam","name":"$sc"},{"kind":13,"line":754,"containerName":"_parse_hmmpfam","name":"$file"},{"containerName":"_parse_hmmpfam","name":"$id","line":763,"kind":13},{"name":"$sqfrom","containerName":"_parse_hmmpfam","kind":13,"line":763},{"containerName":"_parse_hmmpfam","name":"$sqto","kind":13,"line":763},{"containerName":"_parse_hmmpfam","name":"$hmmf","line":763,"kind":13},{"containerName":"_parse_hmmpfam","name":"$hmmt","line":763,"kind":13},{"name":"$sc","containerName":"_parse_hmmpfam","kind":13,"line":763},{"name":"$ev","containerName":"_parse_hmmpfam","line":763,"kind":13},{"line":765,"kind":13,"containerName":"_parse_hmmpfam","name":"$unit"},{"line":765,"kind":12,"containerName":"_parse_hmmpfam","name":"new"},{"line":766,"kind":13,"name":"$unit","containerName":"_parse_hmmpfam"},{"kind":12,"line":766,"name":"seq_id","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"$seqname","line":766,"kind":13},{"line":767,"kind":13,"name":"$unit","containerName":"_parse_hmmpfam"},{"kind":12,"line":767,"name":"hmmname","containerName":"_parse_hmmpfam"},{"line":767,"kind":13,"containerName":"_parse_hmmpfam","name":"$id"},{"name":"$unit","containerName":"_parse_hmmpfam","line":768,"kind":13},{"kind":12,"line":768,"containerName":"_parse_hmmpfam","name":"start"},{"line":768,"kind":13,"containerName":"_parse_hmmpfam","name":"$sqfrom"},{"line":769,"kind":13,"containerName":"_parse_hmmpfam","name":"$unit"},{"name":"end","containerName":"_parse_hmmpfam","line":769,"kind":12},{"line":769,"kind":13,"name":"$sqto","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"$unit","kind":13,"line":770},{"kind":12,"line":770,"name":"hstart","containerName":"_parse_hmmpfam"},{"kind":13,"line":770,"containerName":"_parse_hmmpfam","name":"$hmmf"},{"line":771,"kind":13,"containerName":"_parse_hmmpfam","name":"$unit"},{"line":771,"kind":12,"containerName":"_parse_hmmpfam","name":"hend"},{"kind":13,"line":771,"containerName":"_parse_hmmpfam","name":"$hmmt"},{"line":772,"kind":13,"containerName":"_parse_hmmpfam","name":"$unit"},{"kind":12,"line":772,"name":"bits","containerName":"_parse_hmmpfam"},{"name":"$sc","containerName":"_parse_hmmpfam","line":772,"kind":13},{"containerName":"_parse_hmmpfam","name":"$unit","line":773,"kind":13},{"line":773,"kind":12,"containerName":"_parse_hmmpfam","name":"evalue"},{"line":773,"kind":13,"containerName":"_parse_hmmpfam","name":"$ev"},{"name":"$hash","containerName":"_parse_hmmpfam","line":775,"kind":13},{"name":"$id","containerName":"_parse_hmmpfam","line":775,"kind":13},{"containerName":"_parse_hmmpfam","name":"$self","kind":13,"line":776},{"line":776,"kind":12,"containerName":"_parse_hmmpfam","name":"throw"},{"name":"$unit","containerName":"_parse_hmmpfam","line":779,"kind":13},{"containerName":"_parse_hmmpfam","name":"seqbits","line":779,"kind":12},{"line":779,"kind":13,"name":"$hash","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"$id","line":779,"kind":13},{"name":"$acc","containerName":"_parse_hmmpfam","line":781,"kind":13},{"name":"$id","containerName":"_parse_hmmpfam","kind":13,"line":781},{"containerName":"_parse_hmmpfam","name":"$unit","line":782,"kind":13},{"line":782,"kind":12,"name":"hmmacc","containerName":"_parse_hmmpfam"},{"name":"$acc","containerName":"_parse_hmmpfam","kind":13,"line":782},{"containerName":"_parse_hmmpfam","name":"$id","kind":13,"line":782},{"containerName":"_parse_hmmpfam","name":"$self","line":786,"kind":13},{"containerName":"_parse_hmmpfam","name":"add_Domain","line":786,"kind":12},{"containerName":"_parse_hmmpfam","name":"$unit","line":786,"kind":13},{"line":791,"kind":13,"containerName":"_parse_hmmpfam","name":"$file"},{"kind":13,"line":802,"name":"$name","containerName":"_parse_hmmpfam"},{"name":"$from","containerName":"_parse_hmmpfam","line":803,"kind":13},{"line":804,"kind":13,"containerName":"_parse_hmmpfam","name":"$to"},{"line":808,"kind":13,"containerName":"_parse_hmmpfam","name":"$unit"},{"kind":13,"line":808,"containerName":"_parse_hmmpfam","name":"$self"},{"name":"get_unit_nse","containerName":"_parse_hmmpfam","line":808,"kind":12},{"name":"$seqname","containerName":"_parse_hmmpfam","kind":13,"line":808},{"name":"$name","containerName":"_parse_hmmpfam","line":808,"kind":13},{"containerName":"_parse_hmmpfam","name":"$from","kind":13,"line":808},{"containerName":"_parse_hmmpfam","name":"$to","kind":13,"line":808},{"containerName":"_parse_hmmpfam","name":"$unit","kind":13,"line":809},{"kind":13,"line":810,"name":"$self","containerName":"_parse_hmmpfam"},{"line":810,"kind":12,"containerName":"_parse_hmmpfam","name":"warn"},{"kind":13,"line":811,"name":"$file","containerName":"_parse_hmmpfam"},{"containerName":"_parse_hmmpfam","name":"$file","kind":13,"line":814},{"containerName":"_parse_hmmpfam","name":"$unit","kind":13,"line":817},{"name":"add_alignment_line","containerName":"_parse_hmmpfam","kind":12,"line":817},{"name":"$file","containerName":"_parse_hmmpfam","kind":13,"line":820}]},{"containerName":"Tools::HMMER::Set","name":"Bio","kind":12,"line":724},{"name":"Parsed","kind":12,"line":734},{"name":"domains","line":734,"kind":12},{"containerName":"Tools::HMMER::Domain","name":"Bio","kind":12,"line":765},{"definition":"sub","name":"get_unit_nse","containerName":"main::","range":{"start":{"line":831,"character":0},"end":{"line":853,"character":9999}},"kind":12,"children":[{"line":832,"kind":13,"localvar":"my","containerName":"get_unit_nse","name":"$self","definition":"my"},{"localvar":"my","containerName":"get_unit_nse","name":"$seqname","definition":"my","line":833,"kind":13},{"line":834,"kind":13,"localvar":"my","name":"$domname","definition":"my","containerName":"get_unit_nse"},{"kind":13,"line":835,"containerName":"get_unit_nse","definition":"my","name":"$start","localvar":"my"},{"localvar":"my","definition":"my","name":"$end","containerName":"get_unit_nse","line":836,"kind":13},{"line":838,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"get_unit_nse"},{"line":838,"kind":13,"containerName":"get_unit_nse","name":"$unit"},{"name":"$seq","containerName":"get_unit_nse","kind":13,"line":840},{"name":"$self","containerName":"get_unit_nse","line":840,"kind":13},{"kind":12,"line":840,"name":"get_Set","containerName":"get_unit_nse"},{"kind":13,"line":840,"name":"$seqname","containerName":"get_unit_nse"},{"kind":13,"line":842,"containerName":"get_unit_nse","name":"$seq"},{"line":843,"kind":13,"containerName":"get_unit_nse","name":"$self"},{"line":843,"kind":12,"name":"throw","containerName":"get_unit_nse"},{"containerName":"get_unit_nse","name":"$unit","line":846,"kind":13},{"containerName":"get_unit_nse","name":"$seq","kind":13,"line":846},{"name":"each_Domain","containerName":"get_unit_nse","line":846,"kind":12},{"containerName":"get_unit_nse","name":"$unit","line":847,"kind":13},{"line":847,"kind":12,"name":"hmmname","containerName":"get_unit_nse"},{"containerName":"get_unit_nse","name":"$domname","line":847,"kind":13},{"kind":13,"line":847,"containerName":"get_unit_nse","name":"$unit"},{"kind":12,"line":847,"name":"start","containerName":"get_unit_nse"},{"kind":13,"line":847,"containerName":"get_unit_nse","name":"$start"},{"containerName":"get_unit_nse","name":"$unit","line":847,"kind":13},{"line":847,"kind":12,"name":"end","containerName":"get_unit_nse"},{"name":"$end","containerName":"get_unit_nse","kind":13,"line":847},{"containerName":"get_unit_nse","name":"$unit","line":848,"kind":13}],"line":831},{"range":{"start":{"character":0,"line":867},"end":{"line":952,"character":9999}},"name":"_parse_hmmsearch","definition":"sub","containerName":"main::","children":[{"containerName":"_parse_hmmsearch","name":"$self","definition":"my","localvar":"my","kind":13,"line":868},{"localvar":"my","containerName":"_parse_hmmsearch","definition":"my","name":"$file","line":869,"kind":13},{"localvar":"my","containerName":"_parse_hmmsearch","definition":"my","name":"$id","line":870,"kind":13},{"containerName":"_parse_hmmsearch","name":"$sqfrom","line":870,"kind":13},{"name":"$sqto","containerName":"_parse_hmmsearch","kind":13,"line":870},{"name":"$sc","containerName":"_parse_hmmsearch","kind":13,"line":870},{"name":"$ev","containerName":"_parse_hmmsearch","line":870,"kind":13},{"name":"$unit","containerName":"_parse_hmmsearch","line":870,"kind":13},{"kind":13,"line":870,"containerName":"_parse_hmmsearch","name":"$nd"},{"name":"$seq","containerName":"_parse_hmmsearch","line":870,"kind":13},{"name":"$hmmf","containerName":"_parse_hmmsearch","kind":13,"line":870},{"line":870,"kind":13,"containerName":"_parse_hmmsearch","name":"$hmmt"},{"containerName":"_parse_hmmsearch","name":"$hmmfname","line":871,"kind":13},{"kind":13,"line":871,"containerName":"_parse_hmmsearch","name":"$hmmacc"},{"containerName":"_parse_hmmsearch","name":"$hmmid","line":871,"kind":13},{"kind":13,"line":871,"name":"%seqh","containerName":"_parse_hmmsearch"},{"kind":13,"line":872,"containerName":"_parse_hmmsearch","definition":"my","name":"$count","localvar":"my"},{"containerName":"_parse_hmmsearch","name":"$file","line":874,"kind":13},{"containerName":"_parse_hmmsearch","name":"$self","kind":13,"line":875},{"containerName":"_parse_hmmsearch","name":"hmmfile","kind":12,"line":875},{"line":875,"kind":13,"containerName":"_parse_hmmsearch","name":"$hmmfname"},{"containerName":"_parse_hmmsearch","name":"$hmmacc","line":876,"kind":13},{"kind":13,"line":877,"containerName":"_parse_hmmsearch","name":"$hmmid"},{"name":"$self","containerName":"_parse_hmmsearch","kind":13,"line":878},{"line":878,"kind":12,"containerName":"_parse_hmmsearch","name":"seqfile"},{"name":"$hmmfname","containerName":"_parse_hmmsearch","line":882,"kind":13},{"kind":13,"line":882,"containerName":"_parse_hmmsearch","name":"$hmmfname"},{"name":"$file","containerName":"_parse_hmmsearch","kind":13,"line":884},{"name":"$id","containerName":"_parse_hmmsearch","kind":13,"line":886},{"line":886,"kind":13,"containerName":"_parse_hmmsearch","name":"$sc"},{"name":"$ev","containerName":"_parse_hmmsearch","line":886,"kind":13},{"line":886,"kind":13,"containerName":"_parse_hmmsearch","name":"$nd"},{"name":"$seq","containerName":"_parse_hmmsearch","line":887,"kind":13},{"name":"new","containerName":"_parse_hmmsearch","line":887,"kind":12},{"kind":13,"line":888,"containerName":"_parse_hmmsearch","name":"$seq"},{"name":"name","containerName":"_parse_hmmsearch","line":888,"kind":12},{"name":"$id","containerName":"_parse_hmmsearch","line":888,"kind":13},{"kind":13,"line":889,"containerName":"_parse_hmmsearch","name":"$seq"},{"containerName":"_parse_hmmsearch","name":"bits","line":889,"kind":12},{"kind":13,"line":889,"containerName":"_parse_hmmsearch","name":"$sc"},{"kind":13,"line":890,"name":"$seqh","containerName":"_parse_hmmsearch"},{"line":890,"kind":13,"name":"$id","containerName":"_parse_hmmsearch"},{"name":"$sc","containerName":"_parse_hmmsearch","kind":13,"line":890},{"name":"$seq","containerName":"_parse_hmmsearch","line":891,"kind":13},{"containerName":"_parse_hmmsearch","name":"evalue","kind":12,"line":891},{"name":"$ev","containerName":"_parse_hmmsearch","line":891,"kind":13},{"name":"$self","containerName":"_parse_hmmsearch","kind":13,"line":892},{"containerName":"_parse_hmmsearch","name":"add_Set","line":892,"kind":12},{"kind":13,"line":892,"containerName":"_parse_hmmsearch","name":"$seq"},{"kind":13,"line":893,"name":"$seq","containerName":"_parse_hmmsearch"},{"containerName":"_parse_hmmsearch","name":"accession","line":893,"kind":12},{"containerName":"_parse_hmmsearch","name":"$hmmacc","line":893,"kind":13},{"containerName":"_parse_hmmsearch","name":"$file","kind":13,"line":897},{"kind":13,"line":899,"containerName":"_parse_hmmsearch","name":"$id"},{"kind":13,"line":899,"containerName":"_parse_hmmsearch","name":"$sqfrom"},{"containerName":"_parse_hmmsearch","name":"$sqto","line":899,"kind":13},{"kind":13,"line":899,"name":"$hmmf","containerName":"_parse_hmmsearch"},{"line":899,"kind":13,"containerName":"_parse_hmmsearch","name":"$hmmt"},{"line":899,"kind":13,"name":"$sc","containerName":"_parse_hmmsearch"},{"name":"$ev","containerName":"_parse_hmmsearch","line":899,"kind":13},{"containerName":"_parse_hmmsearch","name":"$unit","line":900,"kind":13},{"name":"new","containerName":"_parse_hmmsearch","line":900,"kind":12},{"containerName":"_parse_hmmsearch","name":"$unit","line":902,"kind":13},{"containerName":"_parse_hmmsearch","name":"seq_id","kind":12,"line":902},{"name":"$id","containerName":"_parse_hmmsearch","kind":13,"line":902},{"name":"$unit","containerName":"_parse_hmmsearch","kind":13,"line":903},{"name":"hmmname","containerName":"_parse_hmmsearch","kind":12,"line":903},{"line":903,"kind":13,"containerName":"_parse_hmmsearch","name":"$hmmfname"},{"kind":13,"line":904,"containerName":"_parse_hmmsearch","name":"$unit"},{"name":"start","containerName":"_parse_hmmsearch","line":904,"kind":12},{"line":904,"kind":13,"containerName":"_parse_hmmsearch","name":"$sqfrom"},{"line":905,"kind":13,"containerName":"_parse_hmmsearch","name":"$unit"},{"kind":12,"line":905,"containerName":"_parse_hmmsearch","name":"end"},{"line":905,"kind":13,"containerName":"_parse_hmmsearch","name":"$sqto"},{"name":"$unit","containerName":"_parse_hmmsearch","kind":13,"line":906},{"line":906,"kind":12,"containerName":"_parse_hmmsearch","name":"bits"},{"line":906,"kind":13,"containerName":"_parse_hmmsearch","name":"$sc"},{"kind":13,"line":907,"containerName":"_parse_hmmsearch","name":"$unit"},{"kind":12,"line":907,"name":"hstart","containerName":"_parse_hmmsearch"},{"containerName":"_parse_hmmsearch","name":"$hmmf","kind":13,"line":907},{"kind":13,"line":908,"name":"$unit","containerName":"_parse_hmmsearch"},{"containerName":"_parse_hmmsearch","name":"hend","line":908,"kind":12},{"name":"$hmmt","containerName":"_parse_hmmsearch","kind":13,"line":908},{"line":909,"kind":13,"containerName":"_parse_hmmsearch","name":"$unit"},{"line":909,"kind":12,"name":"evalue","containerName":"_parse_hmmsearch"},{"line":909,"kind":13,"name":"$ev","containerName":"_parse_hmmsearch"},{"containerName":"_parse_hmmsearch","name":"$unit","line":910,"kind":13},{"line":910,"kind":12,"name":"seqbits","containerName":"_parse_hmmsearch"},{"name":"$seqh","containerName":"_parse_hmmsearch","kind":13,"line":910},{"line":910,"kind":13,"name":"$id","containerName":"_parse_hmmsearch"},{"kind":13,"line":911,"containerName":"_parse_hmmsearch","name":"$self"},{"name":"add_Domain","containerName":"_parse_hmmsearch","kind":12,"line":911},{"line":911,"kind":13,"containerName":"_parse_hmmsearch","name":"$unit"},{"kind":13,"line":912,"containerName":"_parse_hmmsearch","name":"$count"},{"line":916,"kind":13,"name":"$file","containerName":"_parse_hmmsearch"},{"kind":13,"line":929,"containerName":"_parse_hmmsearch","name":"$name","definition":"my","localvar":"my"},{"localvar":"my","containerName":"_parse_hmmsearch","definition":"my","name":"$from","line":930,"kind":13},{"line":931,"kind":13,"localvar":"my","definition":"my","name":"$to","containerName":"_parse_hmmsearch"},{"kind":13,"line":934,"containerName":"_parse_hmmsearch","name":"$unit"},{"containerName":"_parse_hmmsearch","name":"$self","kind":13,"line":934},{"name":"get_unit_nse","containerName":"_parse_hmmsearch","kind":12,"line":934},{"kind":13,"line":934,"containerName":"_parse_hmmsearch","name":"$name"},{"containerName":"_parse_hmmsearch","name":"$hmmfname","kind":13,"line":934},{"containerName":"_parse_hmmsearch","name":"$from","kind":13,"line":934},{"line":934,"kind":13,"name":"$to","containerName":"_parse_hmmsearch"},{"line":936,"kind":13,"containerName":"_parse_hmmsearch","name":"$unit"},{"kind":13,"line":937,"name":"$self","containerName":"_parse_hmmsearch"},{"kind":12,"line":937,"containerName":"_parse_hmmsearch","name":"warn"},{"kind":13,"line":940,"name":"$file","containerName":"_parse_hmmsearch"},{"kind":13,"line":943,"name":"$unit","containerName":"_parse_hmmsearch"},{"kind":12,"line":943,"name":"add_alignment_line","containerName":"_parse_hmmsearch"},{"containerName":"_parse_hmmsearch","name":"$file","line":947,"kind":13},{"line":951,"kind":13,"containerName":"_parse_hmmsearch","name":"$count"}],"line":867,"kind":12},{"kind":12,"line":887,"containerName":"Tools::HMMER::Set","name":"Bio"},{"name":"Bio","containerName":"Tools::HMMER::Domain","kind":12,"line":900},{"kind":12,"line":924,"name":"Histogram"},{"kind":12,"line":924,"name":"of"},{"line":924,"kind":12,"name":"all"},{"kind":12,"line":924,"name":"scores"},{"range":{"end":{"character":9999,"line":971},"start":{"line":965,"character":0}},"name":"parsetype","signature":{"label":"parsetype($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"__END__\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Perl Module for HMMResults\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n#Copyright Genome Research Limited (1997).\n\n=head1 NAME\n\nBio::Tools::HMMER::Results - Object representing HMMER output results\n\n=head1 SYNOPSIS\n\n   # parse a hmmsearch file (can also parse a hmmpfam file)\n   $res = Bio::Tools::HMMER::Results->new( -file => 'output.hmm' ,\n                                          -type => 'hmmsearch');\n\n   # print out the results for each sequence\n   foreach $seq ( $res->each_Set ) {\n       print \"Sequence bit score is\",$seq->bits,\"\\n\";\n       foreach $domain ( $seq->each_Domain ) {\n           print \" Domain start \",$domain->start,\" end \",$domain->end,\n\t   \" score \",$domain->bits,\"\\n\";\n       }\n   }\n\n   # new result object on a sequence/domain cutoff of\n   # 25 bits sequence, 15 bits domain\n   $newresult = $res->filter_on_cutoff(25,15);\n\n   # alternative way of getting out all domains directly\n   foreach $domain ( $res->each_Domain ) {\n       print \"Domain on \",$domain->seq_id,\" with score \",\n       $domain->bits,\" evalue \",$domain->evalue,\"\\n\";\n   }\n\n=head1 DESCRIPTION\n\nThis object represents HMMER output, either from hmmsearch or\nhmmpfam. For hmmsearch, a series of HMMER::Set objects are made, one\nfor each sequence, which have the the bits score for the object. For\nhmmpfam searches, only one Set object is made.\n\n\nThese objects come from the original HMMResults modules used\ninternally in Pfam, written by Ewan Birney. Ewan then converted them to\nBioPerl objects in 1999. That conversion is meant to be backwardly\ncompatible, but may not be (caveat emptor).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::HMMER::Results;\n\nuse strict;\n\nuse Bio::Tools::HMMER::Domain;\nuse Bio::Tools::HMMER::Set;\nuse Symbol;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::SeqAnalysisParserI);\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  $self->{'domain'} = []; # array of HMMUnits\n  $self->{'seq'} = {};\n\n  my ($parsetype) = $self->_rearrange([qw(TYPE)],@args);\n  $self->_initialize_io(@args);\n  if( !defined $parsetype ) {\n      $self->throw(\"No parse type provided. should be hmmsearch or hmmpfam\");\n  }\n  $self->parsetype($parsetype);\n  if( defined $self->_fh() ) {\n      if( $parsetype eq 'hmmsearch' ) {\n\t  $self->_parse_hmmsearch($self->_fh());\n      } elsif ( $parsetype eq 'hmmpfam' ) {\n\t  $self->_parse_hmmpfam($self->_fh());\n      } else {\n\t  $self->throw(\"Did not recoginise type $parsetype\");\n      }\n  }\n\n  return $self; # success - we hope!\n}\n\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while( my $feat = $res->next_feature ) { # do something }\n Function: SeqAnalysisParserI implementing function\n Example :\n Returns : A Bio::SeqFeatureI compliant object, in this case,\n           each DomainUnit object, ie, flattening the Sequence\n           aspect of this.\n Args    : None\n\n\n\nsub next_feature{\n   my ($self) = @_;\n\n   if( $self->{'_started_next_feature'} == 1 ) {\n       return shift @{$self->{'_next_feature_array'}};\n   } else {\n       $self->{'_started_next_feature'} = 1;\n       my @array;\n       foreach my $seq ( $self->each_Set() ) {\n\t   foreach my $unit ( $seq->each_Domain() ) {\n\t       push(@array,$unit);\n\t   }\n       }\n       my $res = shift @array;\n       $self->{'_next_feature_array'} = \\@array;\n       return $res;\n   }\n\n   $self->throw(\"Should not reach here! Error!\");\n}\n\n\n=head2 number\n\n Title   : number\n Usage   : print \"There are \",$res->number,\" domains hit\\n\";\n Function: provides the number of domains in the HMMER report\n\n\nsub number {\n    my $self = shift;\n    my @val;\n    my $ref;\n    $ref = $self->{'domain'};\n\n\n    @val = @{$self->{'domain'}};\n    return scalar @val;\n}\n\n=head2 seqfile\n\n Title   : seqfile\n Usage   : $obj->seqfile($newval)\n Function:\n Example :\n Returns : value of seqfile\n Args    : newvalue (optional)\n\n\n\nsub seqfile{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'seqfile'} = $value;\n    }\n    return $self->{'seqfile'};\n\n}\n\n=head2 hmmfile\n\n Title   : hmmfile\n Usage   : $obj->hmmfile($newval)\n Function:\n Example :\n Returns : value of hmmfile\n Args    : newvalue (optional)\n\n\n\nsub hmmfile{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'hmmfile'} = $value;\n    }\n    return $self->{'hmmfile'};\n\n}\n\n=head2 add_Domain\n\n Title   : add_Domain\n Usage   : $res->add_Domain($unit)\n Function: adds a domain to the results array. Mainly used internally.\n Args    : A Bio::Tools::HMMER::Domain\n\n\n\nsub add_Domain {\n    my $self = shift;\n    my $unit = shift;\n    my $name;\n\n    $name = $unit->seq_id();\n\n    if( ! exists $self->{'seq'}->{$name} ) {\n\t$self->warn(\"Adding a domain of $name but with no HMMSequence. Will be kept in domain array but not added to a HMMSequence\");\n    } else {\n\t$self->{'seq'}->{$name}->add_Domain($unit);\n    }\n    push(@{$self->{'domain'}},$unit);\n}\n\n\n=head2 each_Domain\n\n Title   : each_Domain\n Usage   : foreach $domain ( $res->each_Domain() )\n Function: array of Domain units which are held in this report\n Returns : array\n Args    : none\n\n\n\nsub each_Domain {\n    my $self = shift;\n    my (@arr,$u);\n\n    foreach $u ( @{$self->{'domain'}} ) {\n\tpush(@arr,$u);\n    }\n\n    return @arr;\n}\n\n\n=head2 domain_bits_cutoff_from_evalue\n\n Title   : domain_bits_cutoff_from_evalue\n Usage   : $cutoff = domain_bits_cutoff_from_evalue(0.01);\n Function: return a bits cutoff from an evalue using the\n           scores here. Somewhat interesting logic:\n            Find the two bit score which straddle the evalue\n            if( 25 is between these two points) return 25\n            else return the midpoint.\n\n           This logic tries to ensure that with large signal to\n           noise separation one still has sensible 25 bit cutoff\n Returns :\n Args    :\n\n\nsub domain_bits_cutoff_from_evalue {\n    my $self = shift;\n    my $eval = shift;\n    my ($dom,$prev,@doms,$cutoff,$sep,$seen);\n\n    @doms = $self->each_Domain;\n\n\n    @doms = map { $_->[0] }\n            sort { $b->[1] <=> $a->[1] }\n            map { [ $_, $_->bits] } @doms;\n    $seen = 0;\n    foreach $_ ( @doms ) {\n\tif( $_->evalue > $eval ) {\n\t    $seen = 1;\n\t    $dom = $_;\n\t    last;\n\t}\n\t$prev = $_;\n    }\n\n    if( ! defined $prev || $seen == 0) {\n\t$self->throw(\"Evalue is either above or below the list...\");\n\treturn;\n    }\n\n    $sep = $prev->bits - $dom->bits ;\n\n    if( $sep < 1 ) {\n\treturn $prev->bits();\n    }\n    if( $dom->bits < 25 && $prev->bits > 25 ) {\n\treturn 25;\n    }\n\n    return int( $dom->bits + $sep/2 ) ;\n\n}\n\n\nsub dictate_hmm_acc {\n    my $self = shift;\n    my $acc = shift;\n    my ($unit);\n\n\n    foreach $unit ( $self->eachHMMUnit() ) {\n\t$unit->hmmacc($acc);\n    }\n}\n\n=head2 write_FT_output\n\n Title   : write_FT_output\n Usage   : $res->write_FT_output(\\*STDOUT,'DOMAIN')\n Function: writes feature table output ala swissprot\n Returns :\n Args    :\n\n\n\nsub write_FT_output {\n    my $self = shift;\n    my $file = shift;\n    my $idt  = shift;\n    my ($seq,$unit);\n\n    if( !defined $idt ) {\n\t$idt = \"DOMAIN\";\n    }\n\n    foreach $seq ( $self->each_Set() ) {\n\tprint $file sprintf(\"ID   %s\\n\",$seq->name());\n\tforeach $unit ( $seq->each_Domain() ) {\n\t    print $file sprintf(\"FT   %s   %d %d %s\\n\",$idt,\n\t\t\t\t$unit->start,$unit->end,$unit->hmmname);\n\t}\n\tprint $file \"//\\n\";\n    }\n}\n\n=head2 filter_on_cutoff\n\n Title   : filter_on_cutoff\n Usage   : $newresults = $results->filter_on_cutoff(25,15);\n Function: Produces a new HMMER::Results module which has\n           been trimmed at the cutoff.\n Returns : a Bio::Tools::HMMER::Results module\n Args    : sequence cutoff and domain cutoff. in bits score\n           if you want one cutoff, simply use same number both places\n\n\nsub filter_on_cutoff {\n    my $self = shift;\n    my $seqthr = shift;\n    my $domthr = shift;\n    my ($new,$seq,$unit,@array,@narray);\n\n    if( !defined $domthr ) {\n       $self->throw(\"hmmresults filter on cutoff needs two arguments\");\n    }\n\n    $new = Bio::Tools::HMMER::Results->new(-type => $self->parsetype);\n\n    foreach $seq ( $self->each_Set()) {\n\tnext if( $seq->bits() < $seqthr );\n\t$new->add_Set($seq);\n\tforeach $unit ( $seq->each_Domain() ) {\n\t    next if( $unit->bits() < $domthr );\n\t    $new->add_Domain($unit);\n\t}\n    }\n    $new;\n}\n\n=head2 write_ascii_out\n\n Title   : write_ascii_out\n Usage   : $res->write_ascii_out(\\*STDOUT)\n Function: writes as\n           seq seq_start seq_end model-acc model_start model_end model_name\n Returns :\n Args    :\n\n  FIXME: Now that we have no modelacc, this is probably a bad thing.\n\n\n# writes as seq sstart send modelacc hstart hend modelname\n\nsub write_ascii_out {\n    my $self = shift;\n    my $fh = shift;\n    my ($unit,$seq);\n\n    if( !defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n\n\n    foreach $seq ( $self->each_Set()) {\n\tforeach $unit ( $seq->each_Domain()) {\n\t    print $fh sprintf(\"%s %4d %4d %s %4d %4d %4.2f %4.2g %s\\n\",\n\t\t\t      $unit->seq_id(),$unit->start(),$unit->end(),\n\t\t\t      $unit->hmmacc,$unit->hstart,$unit->hend,\n\t\t\t      $unit->bits,$unit->evalue,$unit->hmmname);\n\t}\n    }\n\n}\n\n=head2 write_GDF_bits\n\n Title   : write_GDF_bits\n Usage   : $res->write_GDF_bits(25,15,\\*STDOUT)\n Function: writes GDF format with a sequence,domain threshold\n Returns :\n Args    :\n\n\nsub write_GDF_bits {\n    my $self = shift;\n    my $seqt = shift;\n    my $domt = shift;\n    my $file = shift;\n    my $seq;\n    my $unit;\n    my (@array,@narray);\n\n    if( !defined $file ) {\n\t$self->throw(\"Attempting to use write_GDF_bits without passing in correct arguments!\");\n\treturn;\n    }\n\n    foreach $seq ( $self->each_Set()) {\n\n\tif( $seq->bits() < $seqt ) {\n\t    next;\n\t}\n\n\tforeach $unit ( $seq->each_Domain() ) {\n\t    if( $unit->bits() < $domt ) {\n\t\tnext;\n\t    }\n\t    push(@array,$unit);\n\t}\n\n    }\n\n    @narray = sort { my ($aa,$bb,$st_a,$st_b);\n\t\t     $aa = $a->seq_id();\n\t\t     $bb = $b->seq_id();\n\t\t     if ( $aa eq $bb) {\n\t\t\t $st_a = $a->start();\n\t\t\t $st_b = $b->start();\n\t\t\t return $st_a <=> $st_b;\n\t\t\t }\n\t\t     else {\n\t\t\t return $aa cmp $bb;\n\t\t     } } @array;\n\n    foreach $unit ( @narray ) {\n\tprint $file sprintf(\"%-24s\\t%6d\\t%6d\\t%15s\\t%.1f\\t%g\\n\",$unit->get_nse(),$unit->start(),$unit->end(),$unit->seq_id(),$unit->bits(),$unit->evalue);\n    }\n\n}\n\nsub write_scores_bits {\n    my $self = shift;\n    my $seqt = shift;\n    my $domt = shift;\n    my $file = shift;\n    my $seq;\n    my $unit;\n    my (@array,@narray);\n\n    if( !defined $file ) {\n\t$self->warn(\"Attempting to use write_scores_bits without passing in correct arguments!\");\n\treturn;\n    }\n\n    foreach $seq ( $self->eachHMMSequence()) {\n\n\tif( $seq->bits() < $seqt ) {\n\t    next;\n\t}\n\n\tforeach $unit ( $seq->eachHMMUnit() ) {\n\t    if( $unit->bits() < $domt ) {\n\t\tnext;\n\t    }\n\t    push(@array,$unit);\n\t}\n\n    }\n\n    @narray = sort { my ($aa,$bb,$st_a,$st_b);\n\t\t     $aa = $a->bits();\n\t\t     $bb = $b->bits();\n\t\t     return $aa <=> $bb;\n\t\t     } @array;\n\n    foreach $unit ( @narray ) {\n\tprint $file sprintf(\"%4.2f %s\\n\",$unit->bits(),$unit->get_nse());\n    }\n\n}\n\nsub write_GDF {\n    my $self = shift;\n    my $file = shift;\n    my $unit;\n\n    if( !defined $file ) {\n\t$file = \\*STDOUT;\n    }\n\n\n    foreach $unit ( $self->eachHMMUnit() ) {\n\tprint $file sprintf(\"%-24s\\t%6d\\t%6d\\t%15s\\t%.1f\\t%g\\n\",$unit->get_nse(),$unit->start(),$unit->end(),$unit->seq_id(),$unit->bits(),$unit->evalue);\n    }\n\n}\n\nsub highest_noise {\n    my $self = shift;\n    my $seqt = shift;\n    my $domt = shift;\n    my ($seq,$unit,$hseq,$hdom,$noiseseq,$noisedom);\n\n    $hseq = $hdom = -100000;\n\n    foreach $seq ( $self->eachHMMSequence()) {\n\tif( $seq->bits() < $seqt && $seq->bits() > $hseq  ) {\n\t    $hseq = $seq->bits();\n\t    $noiseseq = $seq;\n\t}\n\tforeach $unit ( $seq->eachHMMUnit() ) {\n\t    if( (($seq->bits() < $seqt) || ($seq->bits() > $seqt && $unit->bits < $domt)) && $unit->bits() > $hdom ) {\n\t\t$hdom  = $unit->bits();\n\t\t$noisedom = $unit;\n\t    }\n\t}\n    }\n\n\n    return ($noiseseq,$noisedom);\n\n}\n\n\nsub lowest_true {\n    my $self = shift;\n    my $seqt = shift;\n    my $domt = shift;\n    my ($seq,$unit,$lowseq,$lowdom,$trueseq,$truedom);\n\n    if( ! defined $domt ) {\n\t$self->warn(\"lowest true needs at least a domain threshold cut-off\");\n\treturn (0,0);\n    }\n\n    $lowseq = $lowdom = 100000;\n\n    foreach $seq ( $self->eachHMMSequence()) {\n\n\tif( $seq->bits() >= $seqt && $seq->bits() < $lowseq  ) {\n\t    $lowseq = $seq->bits();\n\t    $trueseq = $seq;\n\t}\n\tif( $seq->bits() < $seqt ) {\n\t    next;\n\t}\n\n\tforeach $unit ( $seq->eachHMMUnit() ) {\n\t    if( $unit->bits() >= $domt && $unit->bits() < $lowdom ) {\n\t\t$lowdom  = $unit->bits();\n\t\t$truedom = $unit;\n\t    }\n\t}\n    }\n\n\n    return ($trueseq,$truedom);\n\n}\n\n\n\n=head2 add_Set\n\n Title   : add_Set\n Usage   : Mainly internal function\n Function:\n Returns :\n Args    :\n\n\n\nsub add_Set {\n    my $self = shift;\n    my $seq  = shift;\n    my $name;\n\n    $name = $seq->name();\n\n    if( exists $self->{'seq'}->{$name} ) {\n\t$self->throw(\"You alredy have $name in HMMResults!\");\n    }\n    $self->{'seq'}->{$name} = $seq;\n}\n\n\n=head2 each_Set\n\n Title   : each_Set\n Usage   :\n Function:\n Returns :\n Args    :\n\n\n\nsub each_Set {\n    my $self = shift;\n    my (@array,$name);\n\n\n    foreach $name ( keys %{$self->{'seq'}} ) {\n\tpush(@array,$self->{'seq'}->{$name});\n    }\n    return @array;\n}\n\n\n=head2 get_Set\n\n Title   : get_Set\n Usage   : $set = $res->get_Set('sequence-name');\n Function: returns the Set for a particular sequence\n Returns : a HMMER::Set object\n Args    : name of the sequence\n\n\n\nsub get_Set {\n    my $self = shift;\n    my $name = shift;\n\n    return $self->{'seq'}->{$name};\n}\n\n\n=head2 _parse_hmmpfam\n\n Title   : _parse_hmmpfam\n Usage   : $res->_parse_hmmpfam($filehandle)\n Function:\n Returns :\n Args    :\n\n\n\nsub _parse_hmmpfam {\n    my $self = shift;\n    my $file = shift;\n\n    my ($id,$sqfrom,$sqto,$hmmf,$hmmt,$sc,$ev,\n\t$unit,$nd,$seq,$name,$seqname,$from,\n\t$to,%hash,%acc,$acc);\n    my $count = 0;\n\n    while(<$file>) {\n        if( /^HMM file:\\s+(\\S+)/ ) { $self->hmmfile($1); next; }\n\telsif( /^Sequence file:\\s+(\\S+)/ ) { $self->seqfile($1); next }\n\telsif( /^Query(\\s+sequence)?:\\s+(\\S+)/ ) {\n\n\t    $seqname = $2;\n\n\t    $seq     = Bio::Tools::HMMER::Set->new();\n\n\t    $seq ->name($seqname);\n\t    $self->add_Set($seq);\n\t    %hash = ();\n\n\t    while(<$file>){\n\n\t\tif( /Accession:\\s+(\\S+)/ ) { $seq->accession($1); next }\n\t\telsif( s/^Description:\\s+// ) { chomp; $seq->desc($_); next }\n\t\t/^Parsed for domains/ && last;\n\n\t\t# This is to parse out the accession numbers in old Pfam format.\n\t\t# now not support due to changes in HMMER.\n\n\t\tif( (($id,$acc, $sc, $ev, $nd) = /^\\s*(\\S+)\\s+(\\S+).+?\\s(\\S+)\\s+(\\S+)\\s+(\\d+)\\s*$/)) {\n\t\t    $hash{$id} = $sc; # we need this for the sequence\n\t\t                      # core of the domains below!\n\t\t    $acc {$id} = $acc;\n\n\t\t    # this is the more common parsing routine\n\t\t} elsif ( (($id,$sc, $ev, $nd) =\n\t\t\t   /^\\s*(\\S+).+?\\s(\\S+)\\s+(\\S+)\\s+(\\d+)\\s*$/) ) {\n\n\t\t    $hash{$id} = $sc; # we need this for the\n\t\t                      # sequence score of hte domains below!\n\n\t\t}\n\t    }\n\n\t    while(<$file>) {\n\t\t/^Align/ && last;\n\t\tm{^//} && last;\n\t\t# this is meant to match\n\n\t\t#Sequence Domain  seq-f seq-t    hmm-f hmm-t      score  E-value\n\t\t#-------- ------- ----- -----    ----- -----      -----  -------\n\t\t#PF00621    1/1     198   372 ..     1   207 []   281.6    1e-80\n\n\t\tif( (($id, $sqfrom, $sqto, $hmmf,$hmmt,$sc, $ev) =\n\t\t     /(\\S+)\\s+\\S+\\s+(\\d+)\\s+(\\d+).+?(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\S+)\\s+(\\S+)\\s*$/)) {\n\t\t    $unit = Bio::Tools::HMMER::Domain->new();\n\t\t    $unit->seq_id  ($seqname);\n\t\t    $unit->hmmname  ($id);\n\t\t    $unit->start    ($sqfrom);\n\t\t    $unit->end      ($sqto);\n\t\t    $unit->hstart($hmmf);\n\t\t    $unit->hend  ($hmmt);\n\t\t    $unit->bits     ($sc);\n\t\t    $unit->evalue   ($ev);\n\n\t\t    if( !exists($hash{$id}) ) {\n\t\t\t$self->throw(\"HMMResults parsing error in hmmpfam for $id - can't find sequecne score\");\n\t\t    }\n\n\t\t    $unit->seqbits($hash{$id});\n\n\t\t    if( defined $acc{$id} ) {\n\t\t\t$unit->hmmacc($acc{$id});\n\t\t    }\n\n\t\t    # this should find it's own sequence!\n\t\t    $self->add_Domain($unit);\n\t\t}\n\t    }\n\t    if( m{^//} ) { next; }\n\n\t    $_ = <$file>;\n\t    # parses alignment lines. Icky as we have to break on the same line\n\t    # that we need to read to place the alignment lines with the unit.\n\n\t    while(1) {\n\t\t(!defined $_ || m{^//}) && last;\n\n\t\t# matches:\n\t\t# PF00621: domain 1 of 1, from 198 to 372\n\t\tif( /^\\s*(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/ ) {\n\n\t\t    $name = $1;\n\t\t    $from = $2;\n\t\t    $to   = $3;\n\n\t\t    # find the HMMUnit which this alignment is from\n\n\t\t    $unit = $self->get_unit_nse($seqname,$name,$from,$to);\n\t\t    if( !defined $unit ) {\n\t\t\t$self->warn(\"Could not find $name $from $to unit even though I am reading it in. ugh!\");\n\t\t\t$_ = <$file>;\n\t\t\tnext;\n\t\t    }\n\t\t    while(<$file>) {\n\t\t\tm{^//} && last;\n\t\t\t/^\\s*\\S+:.*from\\s+\\d+\\s+to\\s+\\d+/ && last;\n\t\t\t$unit->add_alignment_line($_);\n\t\t    }\n\t\t} else {\n\t\t    $_ = <$file>;\n\t\t}\n\t    }\n\n\t    # back to main 'Query:' loop\n\t}\n    }\n}\n\n# mainly internal function\n\nsub get_unit_nse {\n    my $self    = shift;\n    my $seqname = shift;\n    my $domname = shift;\n    my $start   = shift;\n    my $end     = shift;\n\n    my($seq,$unit);\n\n    $seq = $self->get_Set($seqname);\n\n    if( !defined $seq ) {\n\t$self->throw(\"Could not get sequence name $seqname - so can't get its unit\");\n    }\n\n    foreach $unit ( $seq->each_Domain() ) {\n\tif( $unit->hmmname() eq $domname && $unit->start() == $start &&  $unit->end() == $end ) {\n\t    return $unit;\n\t}\n    }\n\n    return;\n}\n\n\n=head2 _parse_hmmsearch\n\n Title   : _parse_hmmsearch\n Usage   : $res->_parse_hmmsearch($filehandle)\n Function:\n Returns :\n Args    :\n\n\n\nsub _parse_hmmsearch {\n    my $self = shift;\n    my $file = shift;\n    my ($id,$sqfrom,$sqto,$sc,$ev,$unit,$nd,$seq,$hmmf,$hmmt,\n\t$hmmfname,$hmmacc, $hmmid, %seqh);\n    my $count = 0;\n\n    while(<$file>) {\n        /^HMM file:\\s+(\\S+)/ and do { $self->hmmfile($1); $hmmfname = $1 };\n\t/^Accession:\\s+(\\S+)/ and do { $hmmacc = $1 };\n\t/^Query HMM:\\s+(\\S+)/ and do { $hmmid = $1 };\n\t/^Sequence database:\\s+(\\S+)/ and do { $self->seqfile($1) };\n        /^Scores for complete sequences/ && last;\n    }\n\n    $hmmfname = \"given\" if not $hmmfname;\n\n    while(<$file>) {\n\t/^Parsed for domains/ && last;\n\tif( (($id, $sc, $ev, $nd) = /(\\S+).+?\\s(\\S+)\\s+(\\S+)\\s+(\\d+)\\s*$/)) {\n\t    $seq = Bio::Tools::HMMER::Set->new();\n\t    $seq->name($id);\n\t    $seq->bits($sc);\n\t    $seqh{$id} = $sc;\n\t    $seq->evalue($ev);\n\t    $self->add_Set($seq);\n\t    $seq->accession($hmmacc);\n\t}\n    }\n\n    while(<$file>) {\n\t/^Alignments of top-scoring domains/ && last;\n\tif( (($id, $sqfrom, $sqto, $hmmf, $hmmt, $sc, $ev) = /(\\S+)\\s+\\S+\\s+(\\d+)\\s+(\\d+).+?(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\S+)\\s+(\\S+)\\s*$/)) {\n\t    $unit = Bio::Tools::HMMER::Domain->new();\n\n\t    $unit->seq_id($id);\n\t    $unit->hmmname($hmmfname);\n\t    $unit->start($sqfrom);\n\t    $unit->end($sqto);\n\t    $unit->bits($sc);\n\t    $unit->hstart($hmmf);\n\t    $unit->hend($hmmt);\n\t    $unit->evalue($ev);\n\t    $unit->seqbits($seqh{$id});\n\t    $self->add_Domain($unit);\n\t    $count++;\n\t}\n    }\n\n    $_ = <$file>;\n\n    ## Recognize and store domain alignments\n\n    while(1) {\n\tif( !defined $_ ) {\n\t    last;\n\t}\n        /^Histogram of all scores/ && last;\n\n        # matches:\n        # PF00621: domain 1 of 1, from 198 to 372\n        if( /^\\s*(\\S+):.*from\\s+(\\d+)\\s+to\\s+(\\d+)/ ) {\n            my $name = $1;\n            my $from = $2;\n            my $to   = $3;\n\n            # find the HMMUnit which this alignment is from\n            $unit = $self->get_unit_nse($name,$hmmfname,$from,$to);\n\n            if( !defined $unit ) {\n                $self->warn(\"Could not find $name $from $to unit even though I am reading it in. ugh!\");\n                next;\n            }\n            while(<$file>) {\n                /^Histogram of all scores/ && last;\n                /^\\s*\\S+:.*from\\s+\\d+\\s+to\\s+\\d+/ && last;\n                $unit->add_alignment_line($_);\n            }\n        }\n        else {\n            $_ = <$file>;\n        }\n    }\n\n    return $count;\n}\n\n=head2 parsetype\n\n Title   : parsetype\n Usage   : $obj->parsetype($newval)\n Function:\n Returns : value of parsetype\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"parsetype","line":966,"kind":13},{"kind":13,"line":966,"containerName":"parsetype","name":"$value"},{"kind":13,"line":967,"containerName":"parsetype","name":"$value"},{"kind":13,"line":968,"name":"$self","containerName":"parsetype"},{"kind":13,"line":968,"name":"$value","containerName":"parsetype"},{"containerName":"parsetype","name":"$self","line":970,"kind":13}],"line":965,"kind":12}]}