{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":103},{"line":117,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":118,"kind":13},{"line":118,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":120},{"name":"$class","containerName":"new","kind":13,"line":120},{"name":"@args","containerName":"new","kind":13,"line":120},{"containerName":"new","definition":"my","name":"$seqs","localvar":"my","kind":13,"line":121},{"name":"$dilate","containerName":"new","line":121,"kind":13},{"name":"$self","containerName":"new","line":121,"kind":13},{"containerName":"new","name":"_rearrange","line":121,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":122},{"line":123,"kind":13,"name":"$seqs","containerName":"new"},{"containerName":"new","name":"$self","line":124,"kind":13},{"line":124,"kind":12,"containerName":"new","name":"add_band"},{"line":124,"kind":13,"containerName":"new","name":"$seqs"},{"line":125,"kind":13,"name":"$seqs","containerName":"new"},{"line":126,"kind":13,"containerName":"new","name":"$seqs"},{"line":126,"kind":12,"name":"isa","containerName":"new"},{"kind":13,"line":127,"name":"$self","containerName":"new"},{"name":"add_band","containerName":"new","line":127,"kind":12},{"line":127,"kind":13,"containerName":"new","name":"$seqs"},{"line":129,"kind":13,"name":"$self","containerName":"new"},{"name":"dilate","containerName":"new","kind":12,"line":129},{"name":"$dilate","containerName":"new","kind":13,"line":129},{"kind":13,"line":131,"name":"$self","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":117},"end":{"line":132,"character":9999}},"name":"new"},{"kind":12,"line":120,"name":"SUPER","containerName":"new"},{"name":"add_band","range":{"start":{"line":145,"character":0},"end":{"character":9999,"line":163}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"add_band","localvar":"my","kind":13,"line":146},{"containerName":"add_band","name":"$args","line":146,"kind":13},{"definition":"my","name":"$arg","containerName":"add_band","localvar":"my","kind":13,"line":148},{"name":"$args","containerName":"add_band","kind":13,"line":148},{"localvar":"my","containerName":"add_band","definition":"my","name":"$seq","line":149,"kind":13},{"name":"$arg","containerName":"add_band","line":150,"kind":13},{"name":"$arg","containerName":"add_band","kind":13,"line":151},{"line":152,"kind":13,"name":"$seq","containerName":"add_band"},{"containerName":"add_band","name":"new","kind":12,"line":152},{"line":152,"kind":13,"containerName":"add_band","name":"$arg"},{"name":"$arg","containerName":"add_band","line":152,"kind":13},{"name":"$seq","containerName":"add_band","line":154,"kind":13},{"name":"new","containerName":"add_band","kind":12,"line":154},{"kind":13,"line":154,"name":"$arg","containerName":"add_band"},{"line":154,"kind":13,"name":"$arg","containerName":"add_band"},{"name":"$arg","containerName":"add_band","kind":13,"line":156},{"containerName":"add_band","name":"isa","kind":12,"line":156},{"containerName":"add_band","name":"$seq","kind":13,"line":157},{"name":"$arg","containerName":"add_band","line":157,"kind":13},{"containerName":"add_band","name":"$seq","kind":13,"line":160},{"kind":12,"line":160,"name":"validate_seq","containerName":"add_band"},{"kind":13,"line":160,"containerName":"add_band","name":"$seq"},{"line":160,"kind":12,"name":"throw","containerName":"add_band"},{"name":"$seq","containerName":"add_band","kind":13,"line":160},{"containerName":"add_band","name":"seq","line":160,"kind":12},{"containerName":"add_band","name":"$self","kind":13,"line":161},{"line":161,"kind":12,"containerName":"add_band","name":"_add_band"},{"containerName":"add_band","name":"$seq","kind":13,"line":161}],"line":145,"definition":"sub","containerName":"main::","signature":{"label":"add_band($self,$args)","documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($seqs,$dilate) = $self->_rearrange([qw(SEQ DILATE)],\n\t\t\t\t\t  @args);\n  if( ! ref($seqs)  ) {\n      $self->add_band([$seqs]);\n  } elsif( ref($seqs) =~ /array/i ||\n\t   $seqs->isa('Bio::PrimarySeqI') ) {\n      $self->add_band($seqs);\n  } \n  $self->dilate($dilate || 1);\n  \n  return $self;\n}\n\n\n=head2 add_band\n\n Title   : add_band\n Usage   : $gel->add_band($seq);\n Function: Calls _add_band with a (possibly created) Bio::Seq object.\n Returns : \n Args    : Bio::Seq, scalar sequence, or list of either/both.","parameters":[{"label":"$self"},{"label":"$args"}]},"detail":"($self,$args)"},{"kind":12,"line":152,"containerName":"PrimarySeq","name":"Bio"},{"kind":12,"line":154,"containerName":"PrimarySeq","name":"Bio"},{"range":{"start":{"character":0,"line":175},"end":{"character":9999,"line":179}},"name":"_add_band","children":[{"line":176,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_add_band"},{"containerName":"_add_band","name":"$arg","line":176,"kind":13},{"containerName":"_add_band","name":"$arg","line":177,"kind":13},{"name":"$self","containerName":"_add_band","kind":13,"line":178},{"containerName":"_add_band","name":"$arg","kind":13,"line":178}],"line":175,"kind":12,"signature":{"label":"_add_band($self,$arg)","documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($seqs,$dilate) = $self->_rearrange([qw(SEQ DILATE)],\n\t\t\t\t\t  @args);\n  if( ! ref($seqs)  ) {\n      $self->add_band([$seqs]);\n  } elsif( ref($seqs) =~ /array/i ||\n\t   $seqs->isa('Bio::PrimarySeqI') ) {\n      $self->add_band($seqs);\n  } \n  $self->dilate($dilate || 1);\n  \n  return $self;\n}\n\n\n=head2 add_band\n\n Title   : add_band\n Usage   : $gel->add_band($seq);\n Function: Calls _add_band with a (possibly created) Bio::Seq object.\n Returns : \n Args    : Bio::Seq, scalar sequence, or list of either/both.\n\n\nsub add_band {\n  my($self,$args) = @_;\n\n  foreach my $arg (@$args){\n      my $seq;\n      if( ! ref($arg) ) {\n\t  if( $arg =~ /^\\d+/ ) {\n\t      $seq= Bio::PrimarySeq->new(-seq=>\"N\"x$arg, -id => $arg);\n\t  } else {\n\t      $seq= Bio::PrimarySeq->new(-seq=>$arg,-id=>length($arg));\n\t  }\n      } elsif( $arg->isa('Bio::PrimarySeqI') ) {\n\t  $seq = $arg;\n      } \n\n    $seq->validate_seq or $seq->throw(\"invalid symbol in sequence\".$seq->seq().\"\\n\");\n    $self->_add_band($seq);\n  }\n}\n\n=head2 _add_band\n\n Title   : _add_band\n Usage   : $gel->_add_band($seq);\n Function: Adds a new band to the gel.\n Returns : \n Args    : Bio::Seq object","parameters":[{"label":"$self"},{"label":"$arg"}]},"detail":"($self,$arg)","definition":"sub","containerName":"main::"},{"line":192,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"dilate","line":193,"kind":13},{"containerName":"dilate","name":"$arg","line":193,"kind":13},{"kind":13,"line":194,"containerName":"dilate","name":"$self"},{"name":"$arg","containerName":"dilate","kind":13,"line":194},{"name":"$self","containerName":"dilate","line":195,"kind":13},{"line":195,"kind":12,"name":"throw","containerName":"dilate"},{"containerName":"dilate","name":"$arg","line":195,"kind":13},{"containerName":"dilate","name":"$arg","kind":13,"line":195},{"line":196,"kind":13,"name":"$self","containerName":"dilate"},{"line":196,"kind":13,"name":"$arg","containerName":"dilate"},{"name":"$self","containerName":"dilate","line":197,"kind":13}],"kind":12,"detail":"($self,$arg)","signature":{"label":"dilate($self,$arg)","parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($seqs,$dilate) = $self->_rearrange([qw(SEQ DILATE)],\n\t\t\t\t\t  @args);\n  if( ! ref($seqs)  ) {\n      $self->add_band([$seqs]);\n  } elsif( ref($seqs) =~ /array/i ||\n\t   $seqs->isa('Bio::PrimarySeqI') ) {\n      $self->add_band($seqs);\n  } \n  $self->dilate($dilate || 1);\n  \n  return $self;\n}\n\n\n=head2 add_band\n\n Title   : add_band\n Usage   : $gel->add_band($seq);\n Function: Calls _add_band with a (possibly created) Bio::Seq object.\n Returns : \n Args    : Bio::Seq, scalar sequence, or list of either/both.\n\n\nsub add_band {\n  my($self,$args) = @_;\n\n  foreach my $arg (@$args){\n      my $seq;\n      if( ! ref($arg) ) {\n\t  if( $arg =~ /^\\d+/ ) {\n\t      $seq= Bio::PrimarySeq->new(-seq=>\"N\"x$arg, -id => $arg);\n\t  } else {\n\t      $seq= Bio::PrimarySeq->new(-seq=>$arg,-id=>length($arg));\n\t  }\n      } elsif( $arg->isa('Bio::PrimarySeqI') ) {\n\t  $seq = $arg;\n      } \n\n    $seq->validate_seq or $seq->throw(\"invalid symbol in sequence\".$seq->seq().\"\\n\");\n    $self->_add_band($seq);\n  }\n}\n\n=head2 _add_band\n\n Title   : _add_band\n Usage   : $gel->_add_band($seq);\n Function: Adds a new band to the gel.\n Returns : \n Args    : Bio::Seq object\n\n\nsub _add_band {\n  my($self,$arg) = @_;  \n  if( defined $arg) {\n      push (@{$self->{'bands'}},$arg);\n  }\n}\n\n=head2 dilate\n\n Title   : dilate\n Usage   : $gel->dilate(1);\n Function: Sets/retrieves the dilation factor.\n Returns : dilation factor \n Args    : Float or none"},"containerName":"main::","definition":"sub","range":{"start":{"line":192,"character":0},"end":{"character":9999,"line":198}},"name":"dilate"},{"kind":12,"line":194,"name":"dilate"},{"line":196,"kind":12,"name":"dilate"},{"name":"dilate","line":197,"kind":12},{"range":{"start":{"character":0,"line":200},"end":{"line":206,"character":9999}},"name":"migrate","signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"","label":"migrate($self,$arg)"},"detail":"($self,$arg)","definition":"sub","containerName":"main::","children":[{"line":201,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"migrate"},{"line":201,"kind":13,"containerName":"migrate","name":"$arg"},{"containerName":"migrate","name":"$arg","kind":13,"line":202},{"containerName":"migrate","name":"$self","line":202,"kind":13},{"line":202,"kind":13,"name":"$arg","containerName":"migrate"},{"line":203,"kind":13,"name":"$arg","containerName":"migrate"},{"line":204,"kind":13,"name":"$arg","containerName":"migrate"}],"line":200,"kind":12},{"name":"log10","kind":12,"line":204},{"line":218,"children":[{"kind":13,"line":219,"containerName":"bands","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":220,"name":"$self","containerName":"bands"},{"name":"throw","containerName":"bands","line":220,"kind":12},{"kind":13,"line":222,"definition":"my","name":"%bands","containerName":"bands","localvar":"my"},{"containerName":"bands","name":"$band","definition":"my","localvar":"my","kind":13,"line":224},{"name":"$self","containerName":"bands","kind":13,"line":224}],"kind":12,"range":{"start":{"line":218,"character":0},"end":{"line":224,"character":9999}},"containerName":"main::","definition":"sub","name":"bands"},{"line":224,"kind":12,"name":"bands"},{"line":225,"kind":13,"localvar":"my","definition":"my","name":"$distance","containerName":null},{"line":225,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"dilate","line":225,"kind":12},{"name":"$band","containerName":null,"kind":13,"line":225},{"line":225,"kind":12,"name":"length","containerName":"main::"},{"line":226,"kind":13,"name":"%bands","containerName":null},{"kind":13,"line":226,"containerName":null,"name":"$band"},{"containerName":"main::","name":"id","kind":12,"line":226},{"line":226,"kind":13,"name":"$distance","containerName":null},{"line":229,"kind":13,"containerName":null,"name":"%bands"},{"range":{"end":{"line":246,"character":9999},"start":{"line":243,"character":0}},"definition":"sub","name":"log10","containerName":"main::","children":[{"containerName":"log10","name":"$n","definition":"my","localvar":"my","kind":13,"line":244},{"containerName":"log10","name":"$n","line":245,"kind":13}],"line":243,"kind":12}]}