{"version":5,"vars":[{"line":97,"kind":2,"containerName":"","name":"base"},{"kind":12,"line":111,"children":[{"localvar":"my","containerName":"_initialize_state","name":"$self","definition":"my","line":112,"kind":13},{"containerName":"_initialize_state","name":"@args","line":112,"kind":13},{"line":115,"kind":13,"localvar":"my","containerName":"_initialize_state","definition":"my","name":"$make"},{"kind":13,"line":115,"containerName":"_initialize_state","name":"$self"},{"containerName":"_initialize_state","name":"@args","line":115,"kind":13},{"localvar":"my","containerName":"_initialize_state","definition":"my","name":"$genome_is_first","line":117,"kind":13},{"line":117,"kind":13,"containerName":"_initialize_state","name":"$self"},{"line":117,"kind":12,"name":"_rearrange","containerName":"_initialize_state"},{"kind":13,"line":117,"containerName":"_initialize_state","name":"@args"},{"line":119,"kind":13,"name":"$self","containerName":"_initialize_state"},{"line":120,"kind":13,"name":"$self","containerName":"_initialize_state"},{"containerName":"_initialize_state","name":"$genome_is_first","kind":13,"line":120},{"kind":13,"line":120,"name":"$genome_is_first","containerName":"_initialize_state"},{"name":"$self","containerName":"_initialize_state","kind":13,"line":121},{"line":121,"kind":12,"containerName":"_initialize_state","name":"analysis_method"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Est2Genome.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Est2Genome\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Est2Genome - Parse est2genome output, makes simple Bio::SeqFeature::Generic objects\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Est2Genome;\n\n  my $featureiter = Bio::Tools::Est2Genome->new(-file => 'output.est2genome');\n\n  # This is going to be fixed to use the SeqAnalysisI next_feature\n  # Method eventually when we have the objects to put the data in\n  # properly\n  while( my $f = $featureiter->parse_next_gene ) {\n   # process Bio::SeqFeature::Generic objects here\n  }\n\n=head1 DESCRIPTION\n\nThis module is a parser for C<est2genome> [EMBOSS] alignments of est/cdna\nsequence to genomic DNA.  This is generally accepted as the best\nprogram for predicting splice sites based on est/dnas (as far as I know).\n\nThis module currently does not try pull out the ungapped alignments\n(Segment) but may in the future.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Est2Genome;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::Intron;\nuse Bio::SeqFeature::Gene::GeneStructure;\nuse Bio::SeqFeature::SimilarityPair;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Est2Genome->new();\n Function: Builds a new Bio::Tools::Est2Genome object\n Returns : an instance of Bio::Tools::Est2Genome\n Args    : -file => 'output.est2genome' or\n           -fh   => \\*EST2GENOMEOUTPUT\n           -genomefirst => 1  # genome was the first input (not standard)","label":"_initialize_state($self,@args)"},"name":"_initialize_state","range":{"start":{"line":111,"character":0},"end":{"character":9999,"line":122}}},{"name":"SUPER","containerName":"_initialize_state","line":115,"kind":12},{"detail":"($self,$method)","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: Est2Genome.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Est2Genome\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Est2Genome - Parse est2genome output, makes simple Bio::SeqFeature::Generic objects\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Est2Genome;\n\n  my $featureiter = Bio::Tools::Est2Genome->new(-file => 'output.est2genome');\n\n  # This is going to be fixed to use the SeqAnalysisI next_feature\n  # Method eventually when we have the objects to put the data in\n  # properly\n  while( my $f = $featureiter->parse_next_gene ) {\n   # process Bio::SeqFeature::Generic objects here\n  }\n\n=head1 DESCRIPTION\n\nThis module is a parser for C<est2genome> [EMBOSS] alignments of est/cdna\nsequence to genomic DNA.  This is generally accepted as the best\nprogram for predicting splice sites based on est/dnas (as far as I know).\n\nThis module currently does not try pull out the ungapped alignments\n(Segment) but may in the future.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Est2Genome;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::Intron;\nuse Bio::SeqFeature::Gene::GeneStructure;\nuse Bio::SeqFeature::SimilarityPair;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Est2Genome->new();\n Function: Builds a new Bio::Tools::Est2Genome object\n Returns : an instance of Bio::Tools::Est2Genome\n Args    : -file => 'output.est2genome' or\n           -fh   => \\*EST2GENOMEOUTPUT\n           -genomefirst => 1  # genome was the first input (not standard)\n\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    my ($genome_is_first) = $self->_rearrange([qw(GENOMEFIRST)], @args);\n\n    delete($self->{'_genome_is_first'});\n    $self->{'_genome_is_first'} = $genome_is_first if(defined($genome_is_first));\n    $self->analysis_method(\"est2genome\");\n}\n\n=head2 analysis_method\n\n Usage     : $sim4->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /est2genome/i.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"containerName":"main::","definition":"sub","line":135,"children":[{"localvar":"my","containerName":"analysis_method","definition":"my","name":"$self","line":137,"kind":13},{"line":137,"kind":13,"name":"$method","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","kind":13,"line":138},{"kind":13,"line":138,"containerName":"analysis_method","name":"$method"},{"name":"$self","containerName":"analysis_method","kind":13,"line":139},{"name":"throw","containerName":"analysis_method","kind":12,"line":139},{"containerName":"analysis_method","name":"$self","line":139,"kind":13},{"line":141,"kind":13,"name":"$self","containerName":"analysis_method"},{"line":141,"kind":13,"containerName":"analysis_method","name":"$method"}],"kind":12,"range":{"start":{"line":135,"character":0},"end":{"character":9999,"line":142}},"name":"analysis_method"},{"kind":12,"line":141,"containerName":"analysis_method","name":"SUPER"},{"definition":"sub","containerName":"main::","signature":{"label":"parse_next_gene($self,$return_gene)","documentation":"1;\n# $Id: Est2Genome.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Est2Genome\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Est2Genome - Parse est2genome output, makes simple Bio::SeqFeature::Generic objects\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Est2Genome;\n\n  my $featureiter = Bio::Tools::Est2Genome->new(-file => 'output.est2genome');\n\n  # This is going to be fixed to use the SeqAnalysisI next_feature\n  # Method eventually when we have the objects to put the data in\n  # properly\n  while( my $f = $featureiter->parse_next_gene ) {\n   # process Bio::SeqFeature::Generic objects here\n  }\n\n=head1 DESCRIPTION\n\nThis module is a parser for C<est2genome> [EMBOSS] alignments of est/cdna\nsequence to genomic DNA.  This is generally accepted as the best\nprogram for predicting splice sites based on est/dnas (as far as I know).\n\nThis module currently does not try pull out the ungapped alignments\n(Segment) but may in the future.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Est2Genome;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::Intron;\nuse Bio::SeqFeature::Gene::GeneStructure;\nuse Bio::SeqFeature::SimilarityPair;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Est2Genome->new();\n Function: Builds a new Bio::Tools::Est2Genome object\n Returns : an instance of Bio::Tools::Est2Genome\n Args    : -file => 'output.est2genome' or\n           -fh   => \\*EST2GENOMEOUTPUT\n           -genomefirst => 1  # genome was the first input (not standard)\n\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    my ($genome_is_first) = $self->_rearrange([qw(GENOMEFIRST)], @args);\n\n    delete($self->{'_genome_is_first'});\n    $self->{'_genome_is_first'} = $genome_is_first if(defined($genome_is_first));\n    $self->analysis_method(\"est2genome\");\n}\n\n=head2 analysis_method\n\n Usage     : $sim4->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /est2genome/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /est2genome/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_gene\n\n Title   : parse_next_gene\n Usage   : @gene = $est2genome_result->parse_next_gene;\n           foreach $exon (@exons) {\n               # do something\n           }\n\n Function: Parses the next alignments of the est2genome result file and\n           returns the found exons as an array of\n           Bio::SeqFeature::SimilarityPair objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n\n           The $exon->seq_id() attribute will be set to the identifier of the\n           respective sequence for both sequences.\n           The length is accessible via the seqlength()\n           attribute of $exon->query() and\n           $exon->est_hit().\n Returns : An array (or array reference) of Bio::SeqFeature::SimilarityPair and Bio::SeqFeature::Generic objects\n           or Bio::SeqFeature::Gene::GeneStructure\n Args    : flag(1/0) indicating to return Bio::SeqFeature::Gene::GeneStructure or Bio::SeqFeature::SimilarityPair\n           defaults to 0","parameters":[{"label":"$self"},{"label":"$return_gene"}]},"detail":"($self,$return_gene)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"parse_next_gene","line":171,"kind":13},{"kind":13,"line":171,"containerName":"parse_next_gene","name":"$return_gene"},{"kind":13,"line":172,"name":"$self","containerName":"parse_next_gene"},{"line":172,"kind":12,"containerName":"parse_next_gene","name":"_parse_gene_struct"},{"line":172,"kind":13,"name":"$return_gene","containerName":"parse_next_gene"},{"kind":13,"line":173,"definition":"my","name":"$seensegment","containerName":"parse_next_gene","localvar":"my"},{"localvar":"my","definition":"my","name":"@features","containerName":"parse_next_gene","line":174,"kind":13},{"line":175,"kind":13,"localvar":"my","containerName":"parse_next_gene","name":"$qstrand","definition":"my"},{"name":"$hstrand","containerName":"parse_next_gene","line":175,"kind":13},{"kind":13,"line":176,"containerName":"parse_next_gene","name":"$lasthseqname","definition":"my","localvar":"my"},{"name":"$self","containerName":"parse_next_gene","kind":13,"line":177},{"line":177,"kind":12,"containerName":"parse_next_gene","name":"_readline"},{"kind":13,"line":179,"containerName":"parse_next_gene","name":"$seensegment"},{"line":180,"kind":13,"name":"$self","containerName":"parse_next_gene"},{"line":180,"kind":12,"name":"_pushback","containerName":"parse_next_gene"},{"name":"@features","containerName":"parse_next_gene","line":181,"kind":13},{"kind":13,"line":181,"name":"@features","containerName":"parse_next_gene"},{"name":"$hstrand","containerName":"parse_next_gene","line":183,"kind":13},{"name":"$qstrand","containerName":"parse_next_gene","kind":13,"line":184},{"localvar":"my","name":"$name","definition":"my","containerName":"parse_next_gene","line":188,"kind":13},{"kind":13,"line":188,"containerName":"parse_next_gene","name":"$len"},{"containerName":"parse_next_gene","name":"$score","kind":13,"line":188},{"containerName":"parse_next_gene","name":"$qstart","line":188,"kind":13},{"name":"$qend","containerName":"parse_next_gene","line":188,"kind":13},{"name":"$qseqname","containerName":"parse_next_gene","kind":13,"line":188},{"containerName":"parse_next_gene","name":"$hstart","kind":13,"line":189},{"name":"$hend","containerName":"parse_next_gene","kind":13,"line":189},{"kind":13,"line":189,"name":"$hseqname","containerName":"parse_next_gene"},{"kind":13,"line":190,"name":"$lasthseqname","containerName":"parse_next_gene"},{"kind":13,"line":190,"containerName":"parse_next_gene","name":"$hseqname"},{"kind":13,"line":191,"containerName":"parse_next_gene","name":"$query","definition":"my","localvar":"my"},{"kind":12,"line":191,"containerName":"parse_next_gene","name":"new"},{"name":"$name","containerName":"parse_next_gene","line":191,"kind":13},{"line":192,"kind":13,"containerName":"parse_next_gene","name":"$self"},{"containerName":"parse_next_gene","name":"analysis_method","kind":12,"line":192},{"containerName":"parse_next_gene","name":"$qseqname","line":193,"kind":13},{"containerName":"parse_next_gene","name":"$qstart","kind":13,"line":194},{"kind":13,"line":195,"name":"$qend","containerName":"parse_next_gene"},{"containerName":"parse_next_gene","name":"$qstrand","kind":13,"line":196},{"line":197,"kind":13,"name":"$score","containerName":"parse_next_gene"},{"line":203,"kind":13,"localvar":"my","containerName":"parse_next_gene","name":"$hit","definition":"my"},{"line":203,"kind":12,"containerName":"parse_next_gene","name":"new"},{"containerName":"parse_next_gene","name":"$self","line":204,"kind":13},{"kind":12,"line":204,"containerName":"parse_next_gene","name":"analysis_method"},{"containerName":"parse_next_gene","name":"$hseqname","kind":13,"line":205},{"name":"$hstart","containerName":"parse_next_gene","kind":13,"line":206},{"containerName":"parse_next_gene","name":"$hend","kind":13,"line":207},{"name":"$hstrand","containerName":"parse_next_gene","line":208,"kind":13},{"name":"$score","containerName":"parse_next_gene","kind":13,"line":209},{"containerName":"parse_next_gene","name":"@features","kind":13,"line":216},{"name":"new","containerName":"parse_next_gene","kind":12,"line":217},{"kind":13,"line":217,"name":"$query","containerName":"parse_next_gene"},{"name":"$hit","containerName":"parse_next_gene","kind":13,"line":218},{"line":219,"kind":13,"containerName":"parse_next_gene","name":"$self"},{"line":219,"kind":12,"name":"analysis_method","containerName":"parse_next_gene"},{"containerName":"parse_next_gene","name":"$name","definition":"my","localvar":"my","kind":13,"line":221},{"containerName":"parse_next_gene","name":"$len","line":221,"kind":13},{"kind":13,"line":221,"name":"$score","containerName":"parse_next_gene"},{"kind":13,"line":221,"containerName":"parse_next_gene","name":"$qstart"},{"name":"$qend","containerName":"parse_next_gene","kind":13,"line":221},{"name":"$qseqname","containerName":"parse_next_gene","kind":13,"line":221},{"line":222,"kind":13,"containerName":"parse_next_gene","name":"@features"},{"containerName":"parse_next_gene","name":"new","line":222,"kind":12},{"kind":13,"line":223,"containerName":"parse_next_gene","name":"$self"},{"line":223,"kind":12,"containerName":"parse_next_gene","name":"analysis_method"},{"kind":13,"line":224,"name":"$qstart","containerName":"parse_next_gene"},{"name":"$qend","containerName":"parse_next_gene","line":225,"kind":13},{"containerName":"parse_next_gene","name":"$qstrand","line":226,"kind":13},{"name":"$score","containerName":"parse_next_gene","line":227,"kind":13},{"containerName":"parse_next_gene","name":"$qseqname","kind":13,"line":228},{"line":230,"kind":13,"containerName":"parse_next_gene","name":"$lasthseqname"},{"containerName":"parse_next_gene","name":"$seensegment","kind":13,"line":233},{"containerName":"parse_next_gene","name":"$self","line":236,"kind":13},{"name":"warn","containerName":"parse_next_gene","line":236,"kind":12},{"name":"@features","containerName":"parse_next_gene","line":239,"kind":13},{"line":240,"kind":13,"containerName":"parse_next_gene","name":"@features"},{"containerName":"parse_next_gene","name":"@features","kind":13,"line":240}],"line":170,"name":"parse_next_gene","range":{"end":{"character":9999,"line":241},"start":{"character":0,"line":170}}},{"containerName":"SeqFeature::Similarity","name":"Bio","kind":12,"line":191},{"containerName":"SeqFeature::Similarity","name":"Bio","line":203,"kind":12},{"containerName":"SeqFeature::SimilarityPair","name":"Bio","line":216,"kind":12},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":222},{"range":{"start":{"character":0,"line":243},"end":{"line":334,"character":9999}},"name":"_parse_gene_struct","detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse_gene_struct($self)"},"containerName":"main::","definition":"sub","line":243,"children":[{"definition":"my","name":"$self","containerName":"_parse_gene_struct","localvar":"my","kind":13,"line":244},{"definition":"my","name":"$seensegment","containerName":"_parse_gene_struct","localvar":"my","kind":13,"line":245},{"line":246,"kind":13,"localvar":"my","containerName":"_parse_gene_struct","name":"@features","definition":"my"},{"line":247,"kind":13,"localvar":"my","containerName":"_parse_gene_struct","name":"$qstrand","definition":"my"},{"containerName":"_parse_gene_struct","name":"$hstrand","kind":13,"line":247},{"localvar":"my","name":"$lasthseqname","definition":"my","containerName":"_parse_gene_struct","line":248,"kind":13},{"line":249,"kind":13,"localvar":"my","name":"$gene","definition":"my","containerName":"_parse_gene_struct"},{"name":"new","containerName":"_parse_gene_struct","line":249,"kind":12},{"line":249,"kind":13,"name":"$self","containerName":"_parse_gene_struct"},{"containerName":"_parse_gene_struct","name":"analysis_method","line":249,"kind":12},{"definition":"my","name":"$transcript","containerName":"_parse_gene_struct","localvar":"my","kind":13,"line":250},{"name":"new","containerName":"_parse_gene_struct","kind":12,"line":250},{"containerName":"_parse_gene_struct","name":"$self","line":250,"kind":13},{"containerName":"_parse_gene_struct","name":"analysis_method","kind":12,"line":250},{"kind":13,"line":251,"name":"@suppf","definition":"my","containerName":"_parse_gene_struct","localvar":"my"},{"name":"@exon","definition":"my","containerName":"_parse_gene_struct","localvar":"my","kind":13,"line":252},{"kind":13,"line":253,"name":"$self","containerName":"_parse_gene_struct"},{"line":253,"kind":12,"name":"_readline","containerName":"_parse_gene_struct"},{"kind":13,"line":255,"name":"$seensegment","containerName":"_parse_gene_struct"},{"line":256,"kind":13,"name":"$self","containerName":"_parse_gene_struct"},{"kind":12,"line":256,"containerName":"_parse_gene_struct","name":"_pushback"},{"kind":13,"line":257,"containerName":"_parse_gene_struct","name":"$gene"},{"line":259,"kind":13,"containerName":"_parse_gene_struct","name":"$hstrand"},{"kind":13,"line":260,"containerName":"_parse_gene_struct","name":"$qstrand"},{"localvar":"my","containerName":"_parse_gene_struct","definition":"my","name":"$name","line":263,"kind":13},{"line":263,"kind":13,"containerName":"_parse_gene_struct","name":"$len"},{"line":263,"kind":13,"containerName":"_parse_gene_struct","name":"$score"},{"containerName":"_parse_gene_struct","name":"$qstart","line":263,"kind":13},{"containerName":"_parse_gene_struct","name":"$qend","line":263,"kind":13},{"line":263,"kind":13,"name":"$qseqname","containerName":"_parse_gene_struct"},{"name":"$hstart","containerName":"_parse_gene_struct","kind":13,"line":263},{"line":263,"kind":13,"containerName":"_parse_gene_struct","name":"$hend"},{"kind":13,"line":263,"name":"$hseqname","containerName":"_parse_gene_struct"},{"name":"$lasthseqname","containerName":"_parse_gene_struct","line":264,"kind":13},{"line":264,"kind":13,"name":"$hseqname","containerName":"_parse_gene_struct"},{"kind":13,"line":265,"definition":"my","name":"$exon","containerName":"_parse_gene_struct","localvar":"my"},{"kind":12,"line":265,"containerName":"_parse_gene_struct","name":"new"},{"kind":13,"line":265,"name":"$name","containerName":"_parse_gene_struct"},{"name":"$self","containerName":"_parse_gene_struct","line":266,"kind":13},{"containerName":"_parse_gene_struct","name":"analysis_method","line":266,"kind":12},{"containerName":"_parse_gene_struct","name":"$qseqname","line":267,"kind":13},{"name":"$qstart","containerName":"_parse_gene_struct","line":268,"kind":13},{"line":269,"kind":13,"name":"$qend","containerName":"_parse_gene_struct"},{"kind":13,"line":270,"containerName":"_parse_gene_struct","name":"$qstrand"},{"line":271,"kind":13,"containerName":"_parse_gene_struct","name":"$score"},{"name":"$transcript","containerName":"_parse_gene_struct","line":277,"kind":13},{"containerName":"_parse_gene_struct","name":"seq_id","line":277,"kind":12},{"line":277,"kind":13,"name":"$qseqname","containerName":"_parse_gene_struct"},{"line":277,"kind":13,"name":"$transcript","containerName":"_parse_gene_struct"},{"containerName":"_parse_gene_struct","name":"seq_id","kind":12,"line":277},{"kind":13,"line":278,"containerName":"_parse_gene_struct","name":"$exon"},{"kind":12,"line":278,"containerName":"_parse_gene_struct","name":"add_tag_value"},{"kind":13,"line":279,"containerName":"_parse_gene_struct","name":"@exon"},{"containerName":"_parse_gene_struct","name":"$exon","line":279,"kind":13},{"kind":13,"line":285,"name":"$name","definition":"my","containerName":"_parse_gene_struct","localvar":"my"},{"line":285,"kind":13,"name":"$len","containerName":"_parse_gene_struct"},{"containerName":"_parse_gene_struct","name":"$score","line":285,"kind":13},{"name":"$qstart","containerName":"_parse_gene_struct","kind":13,"line":285},{"name":"$qend","containerName":"_parse_gene_struct","kind":13,"line":285},{"kind":13,"line":285,"containerName":"_parse_gene_struct","name":"$qseqname"},{"name":"$hstart","containerName":"_parse_gene_struct","kind":13,"line":285},{"name":"$hend","containerName":"_parse_gene_struct","kind":13,"line":285},{"line":285,"kind":13,"name":"$hseqname","containerName":"_parse_gene_struct"},{"kind":13,"line":286,"containerName":"_parse_gene_struct","definition":"my","name":"$query","localvar":"my"},{"line":286,"kind":12,"name":"new","containerName":"_parse_gene_struct"},{"line":286,"kind":13,"containerName":"_parse_gene_struct","name":"$name"},{"line":287,"kind":13,"name":"$self","containerName":"_parse_gene_struct"},{"name":"analysis_method","containerName":"_parse_gene_struct","line":287,"kind":12},{"kind":13,"line":288,"containerName":"_parse_gene_struct","name":"$qseqname"},{"kind":13,"line":289,"name":"$qstart","containerName":"_parse_gene_struct"},{"kind":13,"line":290,"containerName":"_parse_gene_struct","name":"$qend"},{"kind":13,"line":291,"containerName":"_parse_gene_struct","name":"$qstrand"},{"name":"$score","containerName":"_parse_gene_struct","line":292,"kind":13},{"kind":13,"line":298,"containerName":"_parse_gene_struct","name":"$hit","definition":"my","localvar":"my"},{"containerName":"_parse_gene_struct","name":"new","line":298,"kind":12},{"kind":13,"line":299,"name":"$self","containerName":"_parse_gene_struct"},{"line":299,"kind":12,"containerName":"_parse_gene_struct","name":"analysis_method"},{"line":300,"kind":13,"name":"$hseqname","containerName":"_parse_gene_struct"},{"name":"$hstart","containerName":"_parse_gene_struct","line":301,"kind":13},{"containerName":"_parse_gene_struct","name":"$hend","line":302,"kind":13},{"name":"$hstrand","containerName":"_parse_gene_struct","line":303,"kind":13},{"containerName":"_parse_gene_struct","name":"$score","line":304,"kind":13},{"line":310,"kind":13,"localvar":"my","containerName":"_parse_gene_struct","definition":"my","name":"$support"},{"name":"new","containerName":"_parse_gene_struct","kind":12,"line":310},{"kind":13,"line":310,"name":"$query","containerName":"_parse_gene_struct"},{"kind":13,"line":311,"name":"$hit","containerName":"_parse_gene_struct"},{"containerName":"_parse_gene_struct","name":"$self","line":312,"kind":13},{"containerName":"_parse_gene_struct","name":"analysis_method","kind":12,"line":312},{"name":"@suppf","containerName":"_parse_gene_struct","kind":13,"line":313},{"line":313,"kind":13,"containerName":"_parse_gene_struct","name":"$support"},{"name":"$self","containerName":"_parse_gene_struct","line":316,"kind":13},{"containerName":"_parse_gene_struct","name":"warn","kind":12,"line":316},{"line":320,"kind":13,"localvar":"my","definition":"my","name":"$e","containerName":"_parse_gene_struct"},{"containerName":"_parse_gene_struct","name":"@exon","line":320,"kind":13},{"localvar":"my","containerName":"_parse_gene_struct","name":"@add","definition":"my","line":321,"kind":13},{"name":"$sf","definition":"my","containerName":"_parse_gene_struct","localvar":"my","kind":13,"line":322},{"containerName":"_parse_gene_struct","name":"@suppf","line":322,"kind":13},{"kind":13,"line":323,"containerName":"_parse_gene_struct","name":"$sf"},{"containerName":"_parse_gene_struct","name":"overlaps","kind":12,"line":323},{"line":323,"kind":13,"containerName":"_parse_gene_struct","name":"$e"},{"line":324,"kind":13,"containerName":"_parse_gene_struct","name":"@add"},{"containerName":"_parse_gene_struct","name":"$sf","line":324,"kind":13},{"kind":13,"line":327,"containerName":"_parse_gene_struct","name":"$e"},{"containerName":"_parse_gene_struct","name":"add_tag_value","kind":12,"line":327},{"name":"@add","containerName":"_parse_gene_struct","kind":13,"line":327},{"kind":13,"line":328,"containerName":"_parse_gene_struct","name":"$transcript"},{"kind":12,"line":328,"containerName":"_parse_gene_struct","name":"add_exon"},{"name":"$e","containerName":"_parse_gene_struct","line":328,"kind":13},{"kind":13,"line":331,"containerName":"_parse_gene_struct","name":"$gene"},{"line":331,"kind":12,"name":"add_transcript","containerName":"_parse_gene_struct"},{"line":331,"kind":13,"containerName":"_parse_gene_struct","name":"$transcript"},{"containerName":"_parse_gene_struct","name":"$gene","line":332,"kind":13},{"containerName":"_parse_gene_struct","name":"seq_id","kind":12,"line":332},{"containerName":"_parse_gene_struct","name":"$transcript","line":332,"kind":13},{"containerName":"_parse_gene_struct","name":"seq_id","kind":12,"line":332},{"line":333,"kind":13,"name":"$gene","containerName":"_parse_gene_struct"}],"kind":12},{"line":249,"kind":12,"name":"Bio","containerName":"SeqFeature::Gene::GeneStructure"},{"name":"Bio","containerName":"SeqFeature::Gene::Transcript","kind":12,"line":250},{"name":"Bio","containerName":"SeqFeature::Gene::Exon","line":265,"kind":12},{"kind":12,"line":286,"name":"Bio","containerName":"SeqFeature::Similarity"},{"containerName":"SeqFeature::Similarity","name":"Bio","line":298,"kind":12},{"containerName":"SeqFeature::SimilarityPair","name":"Bio","kind":12,"line":310},{"kind":12,"line":319,"name":"exon"},{"children":[{"line":350,"kind":13,"localvar":"my","containerName":"next_feature","name":"$self","definition":"my"},{"containerName":"next_feature","name":"$self","kind":13,"line":351},{"kind":12,"line":351,"containerName":"next_feature","name":"throw"}],"line":349,"kind":12,"range":{"end":{"line":352,"character":9999},"start":{"line":349,"character":0}},"definition":"sub","name":"next_feature","containerName":"main::"}]}