{"version":5,"vars":[{"line":97,"kind":2,"containerName":"","name":"base"},{"name":"_initialize_state","range":{"start":{"character":0,"line":99},"end":{"line":108,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize_state($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":99,"children":[{"containerName":"_initialize_state","name":"$self","definition":"my","localvar":"my","kind":13,"line":100},{"containerName":"_initialize_state","name":"@args","line":100,"kind":13},{"kind":13,"line":103,"containerName":"_initialize_state","name":"$make","definition":"my","localvar":"my"},{"containerName":"_initialize_state","name":"$self","kind":13,"line":103},{"name":"@args","containerName":"_initialize_state","kind":13,"line":103},{"kind":13,"line":105,"containerName":"_initialize_state","name":"$self"},{"name":"analysis_method","containerName":"_initialize_state","kind":12,"line":105},{"name":"$self","containerName":"_initialize_state","kind":13,"line":106},{"name":"analysis_method","containerName":"_initialize_state","kind":12,"line":106}]},{"line":103,"kind":12,"containerName":"_initialize_state","name":"SUPER"},{"range":{"end":{"character":9999,"line":128},"start":{"character":0,"line":121}},"name":"analysis_method","children":[{"definition":"my","name":"$self","containerName":"analysis_method","localvar":"my","kind":13,"line":123},{"containerName":"analysis_method","name":"$method","kind":13,"line":123},{"line":124,"kind":13,"containerName":"analysis_method","name":"$method"},{"line":124,"kind":13,"name":"$method","containerName":"analysis_method"},{"line":125,"kind":13,"name":"$self","containerName":"analysis_method"},{"containerName":"analysis_method","name":"throw","line":125,"kind":12},{"name":"$self","containerName":"analysis_method","line":125,"kind":13},{"containerName":"analysis_method","name":"$self","line":127,"kind":13},{"line":127,"kind":13,"name":"$method","containerName":"analysis_method"}],"line":121,"kind":12,"signature":{"documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"detail":"($self,$method)","definition":"sub","containerName":"main::"},{"name":"SUPER","containerName":"analysis_method","kind":12,"line":127},{"name":"next_feature","range":{"start":{"character":0,"line":150},"end":{"line":156,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_feature($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"line":151,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_feature"},{"containerName":"next_feature","name":"@args","kind":13,"line":151},{"containerName":"next_feature","name":"$self","line":155,"kind":13},{"line":155,"kind":12,"name":"next_prediction","containerName":"next_feature"},{"kind":13,"line":155,"name":"@args","containerName":"next_feature"}],"line":150},{"name":"next_prediction","range":{"start":{"line":175,"character":0},"end":{"line":326,"character":9999}},"kind":12,"children":[{"line":176,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_prediction"},{"kind":13,"line":177,"containerName":"next_prediction","definition":"my","name":"$gene","localvar":"my"},{"name":"$seq","containerName":"next_prediction","kind":13,"line":177},{"kind":13,"line":177,"containerName":"next_prediction","name":"$cds"},{"containerName":"next_prediction","name":"$predobj","line":177,"kind":13},{"localvar":"my","name":"$numins","definition":"my","containerName":"next_prediction","line":178,"kind":13},{"name":"$seq","containerName":"next_prediction","line":182,"kind":13},{"line":182,"kind":13,"name":"$self","containerName":"next_prediction"},{"line":182,"kind":12,"name":"_fasta_stream","containerName":"next_prediction"},{"name":"next_seq","containerName":"next_prediction","kind":12,"line":182},{"line":183,"kind":13,"containerName":"next_prediction","name":"$seq"},{"containerName":"next_prediction","name":"$gene","line":185,"kind":13},{"kind":12,"line":185,"containerName":"next_prediction","name":"new"},{"containerName":"next_prediction","name":"$seq","line":188,"kind":13},{"kind":12,"line":188,"containerName":"next_prediction","name":"desc"},{"containerName":"next_prediction","name":"$self","line":189,"kind":13},{"name":"throw","containerName":"next_prediction","line":189,"kind":12},{"name":"$seq","containerName":"next_prediction","line":190,"kind":13},{"line":190,"kind":12,"name":"desc","containerName":"next_prediction"},{"kind":13,"line":191,"name":"$gene","containerName":"next_prediction"},{"line":191,"kind":12,"containerName":"next_prediction","name":"score"},{"name":"$seq","containerName":"next_prediction","line":192,"kind":13},{"containerName":"next_prediction","name":"desc","line":192,"kind":12},{"line":194,"kind":13,"name":"$seq","containerName":"next_prediction"},{"line":194,"kind":12,"containerName":"next_prediction","name":"desc"},{"kind":13,"line":195,"containerName":"next_prediction","name":"$desc","definition":"my","localvar":"my"},{"line":196,"kind":13,"name":"$desc","containerName":"next_prediction"},{"line":197,"kind":13,"name":"$seq","containerName":"next_prediction"},{"line":197,"kind":12,"name":"desc","containerName":"next_prediction"},{"line":197,"kind":13,"name":"$desc","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$gene","line":198,"kind":13},{"containerName":"next_prediction","name":"strand","line":198,"kind":12},{"kind":13,"line":200,"name":"$gene","containerName":"next_prediction"},{"kind":12,"line":200,"name":"strand","containerName":"next_prediction"},{"kind":13,"line":203,"containerName":"next_prediction","name":"$seq"},{"name":"desc","containerName":"next_prediction","line":203,"kind":12},{"name":"$seq","containerName":"next_prediction","kind":13,"line":205},{"line":205,"kind":12,"containerName":"next_prediction","name":"desc"},{"line":206,"kind":13,"name":"$predobj","containerName":"next_prediction"},{"kind":12,"line":206,"name":"new","containerName":"next_prediction"},{"line":209,"kind":13,"containerName":"next_prediction","name":"$predobj"},{"name":"strand","containerName":"next_prediction","kind":12,"line":209},{"kind":13,"line":209,"containerName":"next_prediction","name":"$gene"},{"containerName":"next_prediction","name":"strand","line":209,"kind":12},{"kind":13,"line":210,"name":"$predobj","containerName":"next_prediction"},{"line":210,"kind":12,"containerName":"next_prediction","name":"score"},{"containerName":"next_prediction","name":"$gene","line":210,"kind":13},{"containerName":"next_prediction","name":"score","kind":12,"line":210},{"kind":13,"line":211,"containerName":"next_prediction","name":"$predobj"},{"line":211,"kind":12,"containerName":"next_prediction","name":"primary_tag"},{"name":"$predobj","containerName":"next_prediction","line":212,"kind":13},{"name":"seq_id","containerName":"next_prediction","line":212,"kind":12},{"kind":13,"line":212,"containerName":"next_prediction","name":"$seq"},{"name":"display_id","containerName":"next_prediction","kind":12,"line":212},{"containerName":"next_prediction","name":"$gene","kind":13,"line":214},{"kind":12,"line":214,"containerName":"next_prediction","name":"add_exon"},{"containerName":"next_prediction","name":"$predobj","line":214,"kind":13},{"name":"$cds","containerName":"next_prediction","line":216,"kind":13},{"name":"$seq","containerName":"next_prediction","kind":13,"line":216},{"containerName":"next_prediction","name":"seq","line":216,"kind":12},{"containerName":"next_prediction","name":"$cds","kind":13,"line":217},{"kind":13,"line":218,"containerName":"next_prediction","name":"$cds"},{"name":"new","containerName":"next_prediction","kind":12,"line":218},{"kind":13,"line":218,"name":"$cds","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$seq","line":219,"kind":13},{"kind":12,"line":219,"name":"display_id","containerName":"next_prediction"},{"kind":13,"line":220,"containerName":"next_prediction","name":"$seq"},{"name":"desc","containerName":"next_prediction","line":220,"kind":12},{"kind":13,"line":222,"containerName":"next_prediction","name":"$gene"},{"containerName":"next_prediction","name":"predicted_cds","kind":12,"line":222},{"name":"$cds","containerName":"next_prediction","line":222,"kind":13},{"kind":13,"line":223,"containerName":"next_prediction","name":"$predobj"},{"line":223,"kind":12,"name":"predicted_cds","containerName":"next_prediction"},{"name":"$cds","containerName":"next_prediction","line":223,"kind":13},{"containerName":"next_prediction","name":"$gene","kind":13,"line":224},{"name":"strand","containerName":"next_prediction","line":224,"kind":12},{"containerName":"next_prediction","name":"$self","kind":13,"line":225},{"name":"warn","containerName":"next_prediction","kind":12,"line":225},{"containerName":"next_prediction","name":"$gene","line":237,"kind":13},{"line":237,"kind":12,"name":"strand","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$seq","line":238,"kind":13},{"name":"$seq","containerName":"next_prediction","line":238,"kind":13},{"name":"revcom","containerName":"next_prediction","line":238,"kind":12},{"line":240,"kind":13,"localvar":"my","definition":"my","name":"$seqstr","containerName":"next_prediction"},{"line":240,"kind":13,"containerName":"next_prediction","name":"$seq"},{"line":240,"kind":12,"containerName":"next_prediction","name":"seq"},{"name":"$seqstr","containerName":"next_prediction","kind":13,"line":241},{"line":243,"kind":13,"localvar":"my","containerName":"next_prediction","definition":"my","name":"$utr5"},{"localvar":"my","name":"$exonseq","definition":"my","containerName":"next_prediction","line":245,"kind":13},{"kind":13,"line":247,"name":"$exonseq","containerName":"next_prediction"},{"name":"$seqstr","containerName":"next_prediction","line":248,"kind":13},{"line":250,"kind":13,"name":"$seqstr","containerName":"next_prediction"},{"localvar":"my","definition":"my","name":"$start","containerName":"next_prediction","line":253,"kind":13},{"name":"$utr5","containerName":"next_prediction","line":253,"kind":13},{"line":254,"kind":13,"containerName":"next_prediction","name":"$predobj"},{"containerName":"next_prediction","name":"$start","kind":13,"line":255},{"line":255,"kind":13,"name":"$predobj","containerName":"next_prediction"},{"line":255,"kind":12,"name":"end","containerName":"next_prediction"},{"line":255,"kind":13,"containerName":"next_prediction","name":"$numins"},{"containerName":"next_prediction","name":"$cds","line":258,"kind":13},{"kind":13,"line":258,"name":"$exonseq","containerName":"next_prediction"},{"kind":13,"line":259,"containerName":"next_prediction","name":"$cds"},{"line":260,"kind":13,"localvar":"my","definition":"my","name":"$end","containerName":"next_prediction"},{"line":260,"kind":13,"containerName":"next_prediction","name":"$start"},{"name":"$cds","containerName":"next_prediction","kind":13,"line":260},{"name":"$predobj","containerName":"next_prediction","kind":13,"line":262},{"kind":12,"line":262,"containerName":"next_prediction","name":"new"},{"kind":13,"line":262,"containerName":"next_prediction","name":"$start"},{"containerName":"next_prediction","name":"$end","kind":13,"line":263},{"name":"$predobj","containerName":"next_prediction","kind":13,"line":264},{"containerName":"next_prediction","name":"source_tag","line":264,"kind":12},{"name":"$predobj","containerName":"next_prediction","kind":13,"line":265},{"containerName":"next_prediction","name":"primary_tag","kind":12,"line":265},{"kind":13,"line":266,"name":"$predobj","containerName":"next_prediction"},{"containerName":"next_prediction","name":"seq_id","line":266,"kind":12},{"name":"$seq","containerName":"next_prediction","kind":13,"line":266},{"containerName":"next_prediction","name":"display_id","kind":12,"line":266},{"containerName":"next_prediction","name":"$predobj","line":267,"kind":13},{"containerName":"next_prediction","name":"strand","kind":12,"line":267},{"line":267,"kind":13,"containerName":"next_prediction","name":"$gene"},{"kind":12,"line":267,"name":"strand","containerName":"next_prediction"},{"line":268,"kind":13,"name":"$predobj","containerName":"next_prediction"},{"name":"score","containerName":"next_prediction","line":268,"kind":12},{"containerName":"next_prediction","name":"$gene","line":268,"kind":13},{"kind":12,"line":268,"containerName":"next_prediction","name":"score"},{"containerName":"next_prediction","name":"$gene","line":270,"kind":13},{"kind":12,"line":270,"name":"add_exon","containerName":"next_prediction"},{"kind":13,"line":270,"name":"$predobj","containerName":"next_prediction"},{"name":"$cds","containerName":"next_prediction","line":272,"kind":13},{"name":"$exonseq","containerName":"next_prediction","line":272,"kind":13},{"line":273,"kind":13,"containerName":"next_prediction","name":"$cds"},{"name":"$cds","containerName":"next_prediction","kind":13,"line":274},{"containerName":"next_prediction","name":"new","kind":12,"line":274},{"name":"$cds","containerName":"next_prediction","line":274,"kind":13},{"name":"$seq","containerName":"next_prediction","line":275,"kind":13},{"line":275,"kind":12,"containerName":"next_prediction","name":"display_id"},{"containerName":"next_prediction","name":"$seq","kind":13,"line":276},{"containerName":"next_prediction","name":"desc","kind":12,"line":276},{"kind":13,"line":279,"name":"$gene","containerName":"next_prediction"},{"name":"predicted_cds","containerName":"next_prediction","kind":12,"line":279},{"kind":13,"line":279,"name":"$cds","containerName":"next_prediction"},{"kind":13,"line":279,"containerName":"next_prediction","name":"$gene"},{"kind":12,"line":279,"containerName":"next_prediction","name":"predicted_cds"},{"kind":13,"line":280,"containerName":"next_prediction","name":"$predobj"},{"name":"predicted_cds","containerName":"next_prediction","line":280,"kind":12},{"line":280,"kind":13,"containerName":"next_prediction","name":"$cds"},{"localvar":"my","containerName":"next_prediction","definition":"my","name":"$fea","line":283,"kind":13},{"name":"$exonseq","containerName":"next_prediction","kind":13,"line":284},{"line":285,"kind":13,"localvar":"my","name":"$indel","definition":"my","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$fea","kind":13,"line":288},{"line":289,"kind":13,"containerName":"next_prediction","name":"$start"},{"containerName":"next_prediction","name":"$fea","line":289,"kind":13},{"containerName":"next_prediction","name":"start","line":289,"kind":12},{"line":289,"kind":13,"containerName":"next_prediction","name":"$numins"},{"kind":13,"line":290,"name":"$start","containerName":"next_prediction"},{"line":290,"kind":13,"containerName":"next_prediction","name":"$fea"},{"name":"primary_tag","containerName":"next_prediction","kind":12,"line":290},{"line":292,"kind":13,"name":"$start","containerName":"next_prediction"},{"line":292,"kind":13,"name":"$predobj","containerName":"next_prediction"},{"name":"start","containerName":"next_prediction","kind":12,"line":292},{"kind":13,"line":292,"name":"$numins","containerName":"next_prediction"},{"line":295,"kind":13,"name":"$start","containerName":"next_prediction"},{"name":"$seq","containerName":"next_prediction","kind":13,"line":295},{"kind":12,"line":295,"name":"seq","containerName":"next_prediction"},{"kind":13,"line":295,"containerName":"next_prediction","name":"$indel"},{"name":"$start","containerName":"next_prediction","line":295,"kind":13},{"kind":13,"line":295,"containerName":"next_prediction","name":"$numins"},{"line":296,"kind":13,"name":"$fea","containerName":"next_prediction"},{"kind":12,"line":296,"name":"new","containerName":"next_prediction"},{"name":"$start","containerName":"next_prediction","kind":13,"line":296},{"containerName":"next_prediction","name":"$start","line":297,"kind":13},{"containerName":"next_prediction","name":"$fea","line":298,"kind":13},{"line":298,"kind":12,"containerName":"next_prediction","name":"source_tag"},{"containerName":"next_prediction","name":"$fea","line":299,"kind":13},{"kind":12,"line":299,"name":"seq_id","containerName":"next_prediction"},{"name":"$seq","containerName":"next_prediction","line":299,"kind":13},{"containerName":"next_prediction","name":"display_id","kind":12,"line":299},{"kind":13,"line":300,"name":"$fea","containerName":"next_prediction"},{"line":300,"kind":12,"containerName":"next_prediction","name":"strand"},{"line":300,"kind":13,"containerName":"next_prediction","name":"$predobj"},{"containerName":"next_prediction","name":"strand","line":300,"kind":12},{"line":301,"kind":13,"name":"$indel","containerName":"next_prediction"},{"kind":13,"line":306,"containerName":"next_prediction","name":"$fea"},{"line":306,"kind":12,"name":"primary_tag","containerName":"next_prediction"},{"kind":13,"line":311,"containerName":"next_prediction","name":"$numins"},{"name":"$fea","containerName":"next_prediction","kind":13,"line":317},{"name":"primary_tag","containerName":"next_prediction","kind":12,"line":317},{"line":318,"kind":13,"name":"$fea","containerName":"next_prediction"},{"containerName":"next_prediction","name":"add_tag_value","kind":12,"line":318},{"kind":13,"line":318,"containerName":"next_prediction","name":"$indel"},{"name":"$predobj","containerName":"next_prediction","line":320,"kind":13},{"line":320,"kind":12,"name":"add_sub_SeqFeature","containerName":"next_prediction"},{"name":"$fea","containerName":"next_prediction","line":320,"kind":13},{"name":"$gene","containerName":"next_prediction","kind":13,"line":325}],"line":175,"definition":"sub","containerName":"main::","signature":{"label":"next_prediction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $estscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           So far, this method DOES NOT work for reverse strand predictions,\n           even though the code looks like.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :"},"detail":"($self)"},{"name":"Bio","containerName":"Tools::Prediction::Gene","kind":12,"line":185},{"line":206,"kind":12,"containerName":"Tools::Prediction::Exon","name":"Bio"},{"line":218,"kind":12,"name":"Bio","containerName":"PrimarySeq"},{"kind":12,"line":253,"containerName":"length","name":"CORE"},{"line":260,"kind":12,"name":"CORE","containerName":"length"},{"name":"Bio","containerName":"Tools::Prediction::Exon","kind":12,"line":262},{"kind":12,"line":274,"name":"Bio","containerName":"PrimarySeq"},{"kind":12,"line":296,"containerName":"SeqFeature::Generic","name":"Bio"},{"definition":"sub","containerName":"main::","signature":{"label":"close($self,@args)","documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $estscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           So far, this method DOES NOT work for reverse strand predictions,\n           even though the code looks like.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my ($gene, $seq, $cds, $predobj);\n    my $numins = 0;\n\n    # predictions are in the format of FASTA sequences and can be parsed one\n    # at a time\n    $seq = $self->_fasta_stream()->next_seq();\n    return unless $seq;\n    # there is a new prediction\n    $gene = Bio::Tools::Prediction::Gene->new('-primary' => \"ORFprediction\",\n                                              '-source' => \"ESTScan\");\n    # score starts the description\n    $seq->desc() =~ /^([\\d.]+)\\s*(.*)/ or\n\t$self->throw(\"unexpected format of description: no score in \" .\n\t\t     $seq->desc());\n    $gene->score($1);\n    $seq->desc($2);\n    # strand may end the description\n    if($seq->desc() =~ /(.*)minus strand$/) {\n\tmy $desc = $1;\n\t$desc =~ s/;\\s+$//;\n\t$seq->desc($desc);\n\t$gene->strand(-1);\n    } else {\n\t$gene->strand(1);\n    }\n    # check for the format: default or 'all-in-one' (option -a)\n    if($seq->desc() =~ /^(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*(.*)/) {\n\t# default format\n\t$seq->desc($5);\n\t$predobj = Bio::Tools::Prediction::Exon->new('-source' => \"ESTScan\",\n\t\t\t\t\t\t     '-start' => $3,\n\t\t\t\t\t\t     '-end' => $4);\n\t$predobj->strand($gene->strand());\n\t$predobj->score($gene->score()); # FIXME or $1, or $2 ?\n\t$predobj->primary_tag(\"InternalExon\");\n\t$predobj->seq_id($seq->display_id());\n\t# add to gene structure object\n\t$gene->add_exon($predobj);\n\t# add predicted CDS\n\t$cds = $seq->seq();\n\t$cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t$cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t    '-display_id' => $seq->display_id(),\n\t\t\t\t    '-desc' => $seq->desc(),\n\t\t\t\t    '-alphabet' => \"dna\");\n\t$gene->predicted_cds($cds);\n\t$predobj->predicted_cds($cds);\n\tif($gene->strand() == -1) {\n\t    $self->warn(\"reverse strand ORF, but unable to reverse coordinates!\");\n\t}\n    } else {\n\t#\n\t# All-in-one format (hopefully). This encodes the following information\n\t# into the sequence:\n\t# 1) untranslated regions: stretches of lower-case letters\n\t# 2) translated regions: stretches of upper-case letters\n\t# 3) insertions in the translated regions: capital X\n\t# 4) deletions in the translated regions: a single lower-case letter\n\t#\n\t# if reverse strand ORF, save a lot of hassle by reversing the sequence\n\tif($gene->strand() == -1) {\n\t    $seq = $seq->revcom();\n\t}\n\tmy $seqstr = $seq->seq();\n\twhile($seqstr =~ /^([a-z]*)([A-Z].*)$/) {\n\t    # leading 5'UTR\n\t    my $utr5 = $1;\n\t    # exon + 3'UTR\n\t    my $exonseq = $2;\n\t    # strip 3'UTR and following exons\n\t    if($exonseq =~ s/([a-z]{2,}.*)$//) {\n\t\t$seqstr = $1;\n\t    } else {\n\t\t$seqstr = \"\";\n\t    }\n\t    # start: take care of yielding the absolute coordinate\n\t    my $start = CORE::length($utr5) + 1;\n\t    if($predobj) {\n\t\t$start += $predobj->end() + $numins;\n\t    }\n\t    # for the end coordinate, we need to subtract the insertions\n\t    $cds = $exonseq;\n\t    $cds =~ s/[X]//g;\n\t    my $end = $start + CORE::length($cds) - 1;\n\t    # construct next exon object\n\t    $predobj = Bio::Tools::Prediction::Exon->new('-start' => $start,\n\t\t\t\t\t\t\t '-end' => $end);\n\t    $predobj->source_tag(\"ESTScan\");\n\t    $predobj->primary_tag(\"InternalExon\");\n\t    $predobj->seq_id($seq->display_id());\n\t    $predobj->strand($gene->strand());\n\t    $predobj->score($gene->score());\n\t    # add the exon to the gene structure object\n\t    $gene->add_exon($predobj);\n\t    # add the predicted CDS\n\t    $cds = $exonseq;\n\t    $cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t    $cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t\t'-display_id' => $seq->display_id(),\n\t\t\t\t\t'-desc' => $seq->desc(),\n\t\t\t\t\t'-alphabet' => \"dna\");\n\t    # only store the first one in the overall prediction\n\t    $gene->predicted_cds($cds) unless $gene->predicted_cds();\n\t    $predobj->predicted_cds($cds);\n\t    # add the predicted insertions and deletions as subfeatures\n\t    # of the exon\n\t    my $fea = undef;\n\t    while($exonseq =~ /([a-zX])/g) {\n\t\tmy $indel = $1;\n\t\t# start and end: start looking at the position after the\n\t\t# previous feature\n\t\tif($fea) {\n\t\t    $start = $fea->start()+$numins;\n\t\t    $start -= 1 if($fea->primary_tag() eq 'insertion');\n\t\t} else {\n\t\t    $start = $predobj->start()+$numins-1;\n\t\t}\n\t\t#print \"# numins = $numins, indel = $indel, start = $start\\n\";\n\t\t$start = index($seq->seq(), $indel, $start) + 1 - $numins;\n\t\t$fea = Bio::SeqFeature::Generic->new('-start' => $start,\n\t\t\t\t\t\t     '-end' => $start);\n\t\t$fea->source_tag(\"ESTScan\");\n\t\t$fea->seq_id($seq->display_id());\n\t\t$fea->strand($predobj->strand());\n\t\tif($indel eq 'X') {\n\t\t    # an insertion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be inserted, i.e., the HMMER model\n\t\t    # inserted a base; however, the sequencing process deleted\n\t\t    # a base that was there).\n\t\t    $fea->primary_tag(\"insertion\");\n\t\t    # we need to count insertions because these are left out\n\t\t    # of any coordinates saved in the objects (which is correct\n\t\t    # because insertions change the original sequence, so\n\t\t    # coordinates wouldn't match)\n\t\t    $numins++;\n\t\t} else {\n\t\t    # a deletion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be deleted, i.e., the HMMER model\n\t\t    # deleted a base; however, the sequencing process inserted\n\t\t    # a base that wasn't there).\n\t\t    $fea->primary_tag(\"deletion\");\n\t\t    $fea->add_tag_value('base', $indel);\n\t\t}\n\t\t$predobj->add_sub_SeqFeature($fea);\n\t    }\n\t}\n    }\n    \n    return $gene;\n}\n\n=head2 close\n\n Title   : close\n Usage   : $result->close()\n Function: Closes the file handle associated with this result file.\n           Inherited method, overridden.\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"containerName":"close","name":"$self","definition":"my","localvar":"my","kind":13,"line":341},{"name":"@args","containerName":"close","line":341,"kind":13},{"kind":13,"line":343,"name":"$self","containerName":"close"},{"containerName":"close","name":"$self","kind":13,"line":344},{"name":"@args","containerName":"close","kind":13,"line":344}],"line":340,"name":"close","range":{"start":{"character":0,"line":340},"end":{"line":345,"character":9999}}},{"kind":12,"line":344,"containerName":"close","name":"SUPER"},{"detail":"($self,$stream)","signature":{"label":"_fasta_stream($self,$stream)","documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $estscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           So far, this method DOES NOT work for reverse strand predictions,\n           even though the code looks like.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my ($gene, $seq, $cds, $predobj);\n    my $numins = 0;\n\n    # predictions are in the format of FASTA sequences and can be parsed one\n    # at a time\n    $seq = $self->_fasta_stream()->next_seq();\n    return unless $seq;\n    # there is a new prediction\n    $gene = Bio::Tools::Prediction::Gene->new('-primary' => \"ORFprediction\",\n                                              '-source' => \"ESTScan\");\n    # score starts the description\n    $seq->desc() =~ /^([\\d.]+)\\s*(.*)/ or\n\t$self->throw(\"unexpected format of description: no score in \" .\n\t\t     $seq->desc());\n    $gene->score($1);\n    $seq->desc($2);\n    # strand may end the description\n    if($seq->desc() =~ /(.*)minus strand$/) {\n\tmy $desc = $1;\n\t$desc =~ s/;\\s+$//;\n\t$seq->desc($desc);\n\t$gene->strand(-1);\n    } else {\n\t$gene->strand(1);\n    }\n    # check for the format: default or 'all-in-one' (option -a)\n    if($seq->desc() =~ /^(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*(.*)/) {\n\t# default format\n\t$seq->desc($5);\n\t$predobj = Bio::Tools::Prediction::Exon->new('-source' => \"ESTScan\",\n\t\t\t\t\t\t     '-start' => $3,\n\t\t\t\t\t\t     '-end' => $4);\n\t$predobj->strand($gene->strand());\n\t$predobj->score($gene->score()); # FIXME or $1, or $2 ?\n\t$predobj->primary_tag(\"InternalExon\");\n\t$predobj->seq_id($seq->display_id());\n\t# add to gene structure object\n\t$gene->add_exon($predobj);\n\t# add predicted CDS\n\t$cds = $seq->seq();\n\t$cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t$cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t    '-display_id' => $seq->display_id(),\n\t\t\t\t    '-desc' => $seq->desc(),\n\t\t\t\t    '-alphabet' => \"dna\");\n\t$gene->predicted_cds($cds);\n\t$predobj->predicted_cds($cds);\n\tif($gene->strand() == -1) {\n\t    $self->warn(\"reverse strand ORF, but unable to reverse coordinates!\");\n\t}\n    } else {\n\t#\n\t# All-in-one format (hopefully). This encodes the following information\n\t# into the sequence:\n\t# 1) untranslated regions: stretches of lower-case letters\n\t# 2) translated regions: stretches of upper-case letters\n\t# 3) insertions in the translated regions: capital X\n\t# 4) deletions in the translated regions: a single lower-case letter\n\t#\n\t# if reverse strand ORF, save a lot of hassle by reversing the sequence\n\tif($gene->strand() == -1) {\n\t    $seq = $seq->revcom();\n\t}\n\tmy $seqstr = $seq->seq();\n\twhile($seqstr =~ /^([a-z]*)([A-Z].*)$/) {\n\t    # leading 5'UTR\n\t    my $utr5 = $1;\n\t    # exon + 3'UTR\n\t    my $exonseq = $2;\n\t    # strip 3'UTR and following exons\n\t    if($exonseq =~ s/([a-z]{2,}.*)$//) {\n\t\t$seqstr = $1;\n\t    } else {\n\t\t$seqstr = \"\";\n\t    }\n\t    # start: take care of yielding the absolute coordinate\n\t    my $start = CORE::length($utr5) + 1;\n\t    if($predobj) {\n\t\t$start += $predobj->end() + $numins;\n\t    }\n\t    # for the end coordinate, we need to subtract the insertions\n\t    $cds = $exonseq;\n\t    $cds =~ s/[X]//g;\n\t    my $end = $start + CORE::length($cds) - 1;\n\t    # construct next exon object\n\t    $predobj = Bio::Tools::Prediction::Exon->new('-start' => $start,\n\t\t\t\t\t\t\t '-end' => $end);\n\t    $predobj->source_tag(\"ESTScan\");\n\t    $predobj->primary_tag(\"InternalExon\");\n\t    $predobj->seq_id($seq->display_id());\n\t    $predobj->strand($gene->strand());\n\t    $predobj->score($gene->score());\n\t    # add the exon to the gene structure object\n\t    $gene->add_exon($predobj);\n\t    # add the predicted CDS\n\t    $cds = $exonseq;\n\t    $cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t    $cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t\t'-display_id' => $seq->display_id(),\n\t\t\t\t\t'-desc' => $seq->desc(),\n\t\t\t\t\t'-alphabet' => \"dna\");\n\t    # only store the first one in the overall prediction\n\t    $gene->predicted_cds($cds) unless $gene->predicted_cds();\n\t    $predobj->predicted_cds($cds);\n\t    # add the predicted insertions and deletions as subfeatures\n\t    # of the exon\n\t    my $fea = undef;\n\t    while($exonseq =~ /([a-zX])/g) {\n\t\tmy $indel = $1;\n\t\t# start and end: start looking at the position after the\n\t\t# previous feature\n\t\tif($fea) {\n\t\t    $start = $fea->start()+$numins;\n\t\t    $start -= 1 if($fea->primary_tag() eq 'insertion');\n\t\t} else {\n\t\t    $start = $predobj->start()+$numins-1;\n\t\t}\n\t\t#print \"# numins = $numins, indel = $indel, start = $start\\n\";\n\t\t$start = index($seq->seq(), $indel, $start) + 1 - $numins;\n\t\t$fea = Bio::SeqFeature::Generic->new('-start' => $start,\n\t\t\t\t\t\t     '-end' => $start);\n\t\t$fea->source_tag(\"ESTScan\");\n\t\t$fea->seq_id($seq->display_id());\n\t\t$fea->strand($predobj->strand());\n\t\tif($indel eq 'X') {\n\t\t    # an insertion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be inserted, i.e., the HMMER model\n\t\t    # inserted a base; however, the sequencing process deleted\n\t\t    # a base that was there).\n\t\t    $fea->primary_tag(\"insertion\");\n\t\t    # we need to count insertions because these are left out\n\t\t    # of any coordinates saved in the objects (which is correct\n\t\t    # because insertions change the original sequence, so\n\t\t    # coordinates wouldn't match)\n\t\t    $numins++;\n\t\t} else {\n\t\t    # a deletion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be deleted, i.e., the HMMER model\n\t\t    # deleted a base; however, the sequencing process inserted\n\t\t    # a base that wasn't there).\n\t\t    $fea->primary_tag(\"deletion\");\n\t\t    $fea->add_tag_value('base', $indel);\n\t\t}\n\t\t$predobj->add_sub_SeqFeature($fea);\n\t    }\n\t}\n    }\n    \n    return $gene;\n}\n\n=head2 close\n\n Title   : close\n Usage   : $result->close()\n Function: Closes the file handle associated with this result file.\n           Inherited method, overridden.\n Example :\n Returns :\n Args    :\n\n\nsub close {\n   my ($self, @args) = @_;\n\n   delete($self->{'_fastastream'});\n   $self->SUPER::close(@args);\n}\n\n=head2 _fasta_stream\n\n Title   : _fasta_stream\n Usage   : $result->_fasta_stream()\n Function: Gets/Sets the FASTA sequence IO stream for reading the contents of\n           the file associated with this MZEF result object.\n\n           If called for the first time, creates the stream from the filehandle\n           if necessary.\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$stream"}]},"containerName":"main::","definition":"sub","line":362,"children":[{"name":"$self","definition":"my","containerName":"_fasta_stream","localvar":"my","kind":13,"line":363},{"name":"$stream","containerName":"_fasta_stream","line":363,"kind":13},{"kind":13,"line":365,"name":"$stream","containerName":"_fasta_stream"},{"name":"$self","containerName":"_fasta_stream","kind":13,"line":365},{"name":"$stream","containerName":"_fasta_stream","line":366,"kind":13},{"name":"$stream","containerName":"_fasta_stream","line":367,"kind":13},{"name":"new","containerName":"_fasta_stream","line":367,"kind":12},{"line":367,"kind":13,"name":"$self","containerName":"_fasta_stream"},{"containerName":"_fasta_stream","name":"_fh","kind":12,"line":367},{"line":370,"kind":13,"name":"$self","containerName":"_fasta_stream"},{"containerName":"_fasta_stream","name":"$stream","line":370,"kind":13},{"line":372,"kind":13,"containerName":"_fasta_stream","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":362},"end":{"line":373,"character":9999}},"name":"_fasta_stream"},{"line":367,"kind":12,"containerName":"SeqIO","name":"Bio"}]}