{"version":5,"vars":[{"line":111,"kind":2,"containerName":"","name":"base"},{"containerName":"main::","name":"$MotifTag","definition":"our","kind":13,"line":113},{"kind":13,"line":113,"containerName":null,"name":"$SrcTag"},{"line":113,"kind":13,"name":"$DescTag","containerName":null},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')","label":"_initialize($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_initialize","name":"$self","definition":"my","line":129,"kind":13},{"line":129,"kind":13,"containerName":"_initialize","name":"@args"},{"line":130,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"warn","kind":12,"line":130},{"line":131,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"@args","containerName":"_initialize","kind":13,"line":131},{"definition":"my","name":"$motiftag","containerName":"_initialize","localvar":"my","kind":13,"line":132},{"containerName":"_initialize","name":"$desctag","line":132,"kind":13},{"kind":13,"line":132,"containerName":"_initialize","name":"$srctag"},{"name":"$self","containerName":"_initialize","line":132,"kind":13},{"containerName":"_initialize","name":"@args","kind":13,"line":136},{"containerName":"_initialize","name":"$self","kind":13,"line":137},{"name":"motif_tag","containerName":"_initialize","line":137,"kind":12},{"name":"$motiftag","containerName":"_initialize","line":137,"kind":13},{"name":"$motiftag","containerName":"_initialize","kind":13,"line":137},{"containerName":"_initialize","name":"$MotifTag","line":137,"kind":13},{"line":138,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"source_tag","containerName":"_initialize","line":138,"kind":12},{"line":138,"kind":13,"containerName":"_initialize","name":"$srctag"},{"containerName":"_initialize","name":"$srctag","line":138,"kind":13},{"name":"$SrcTag","containerName":"_initialize","line":138,"kind":13},{"line":139,"kind":13,"containerName":"_initialize","name":"$self"},{"line":139,"kind":12,"containerName":"_initialize","name":"desc_tag"},{"containerName":"_initialize","name":"$desctag","kind":13,"line":139},{"kind":13,"line":139,"name":"$desctag","containerName":"_initialize"},{"name":"$DescTag","containerName":"_initialize","kind":13,"line":139},{"containerName":"_initialize","name":"$self","line":142,"kind":13}],"line":128,"kind":12,"range":{"start":{"character":0,"line":128},"end":{"line":144,"character":9999}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","line":131,"kind":12},{"line":132,"kind":12,"name":"SUPER","containerName":"_rearrange"},{"line":165,"children":[{"name":"$self","definition":"my","containerName":"motif_tag","localvar":"my","kind":13,"line":166},{"line":168,"kind":13,"containerName":"motif_tag","name":"$self"},{"name":"$self","containerName":"motif_tag","kind":13,"line":169}],"kind":12,"range":{"start":{"character":0,"line":165},"end":{"character":9999,"line":170}},"containerName":"main::","name":"motif_tag","definition":"sub"},{"kind":12,"children":[{"localvar":"my","containerName":"source_tag","name":"$self","definition":"my","line":185,"kind":13},{"containerName":"source_tag","name":"$self","line":187,"kind":13},{"line":188,"kind":13,"containerName":"source_tag","name":"$self"}],"line":184,"name":"source_tag","definition":"sub","containerName":"main::","range":{"end":{"line":189,"character":9999},"start":{"character":0,"line":184}}},{"kind":12,"children":[{"line":207,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"desc_tag"},{"containerName":"desc_tag","name":"$self","kind":13,"line":209},{"kind":13,"line":210,"name":"$self","containerName":"desc_tag"}],"line":206,"definition":"sub","name":"desc_tag","containerName":"main::","range":{"end":{"line":211,"character":9999},"start":{"line":206,"character":0}}},{"signature":{"label":"analysis_method($self,$method)","documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')\n\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::erpin instead');    \n    $self->SUPER::_initialize(@args);\n    my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                    DESCTAG\n                                                                    SRCTAG\n                                   )],\n                                    @args);\n    $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n    $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n    $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n    foreach (qw(_tset _tset_desc _cutoff _db _db_desc\n               _db_ratios _eval_cutoff _seqid _secacc _seqdesc )) {\n        $self->{$_}='';\n    }\n}\n\n=head2 motif_tag\n\n Title   : motiftag\n Usage   : $obj->motiftag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'ERPIN' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'erpin' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the ERPIN output, this should\n           be set every time an ERPIN object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /ERPIN/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}]},"detail":"($self,$method)","definition":"sub","containerName":"main::","children":[{"containerName":"analysis_method","definition":"my","name":"$self","localvar":"my","kind":13,"line":226},{"kind":13,"line":226,"name":"$method","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","line":227,"kind":13},{"name":"$method","containerName":"analysis_method","line":227,"kind":13},{"kind":13,"line":228,"name":"$self","containerName":"analysis_method"},{"name":"throw","containerName":"analysis_method","kind":12,"line":228},{"containerName":"analysis_method","name":"$self","line":228,"kind":13},{"containerName":"analysis_method","name":"$self","line":230,"kind":13},{"containerName":"analysis_method","name":"$method","line":230,"kind":13}],"line":224,"kind":12,"range":{"start":{"character":0,"line":224},"end":{"character":9999,"line":231}},"name":"analysis_method"},{"kind":12,"line":230,"name":"SUPER","containerName":"analysis_method"},{"name":"next_feature","range":{"end":{"character":9999,"line":256},"start":{"line":250,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')\n\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::erpin instead');    \n    $self->SUPER::_initialize(@args);\n    my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                    DESCTAG\n                                                                    SRCTAG\n                                   )],\n                                    @args);\n    $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n    $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n    $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n    foreach (qw(_tset _tset_desc _cutoff _db _db_desc\n               _db_ratios _eval_cutoff _seqid _secacc _seqdesc )) {\n        $self->{$_}='';\n    }\n}\n\n=head2 motif_tag\n\n Title   : motiftag\n Usage   : $obj->motiftag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'ERPIN' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'erpin' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the ERPIN output, this should\n           be set every time an ERPIN object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /ERPIN/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /ERPIN/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ERPIN result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)","label":"next_feature($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"next_feature","definition":"my","name":"$self","line":251,"kind":13},{"name":"@args","containerName":"next_feature","kind":13,"line":251},{"containerName":"next_feature","name":"$self","line":255,"kind":13},{"line":255,"kind":12,"name":"next_prediction","containerName":"next_feature"},{"line":255,"kind":13,"name":"@args","containerName":"next_feature"}],"line":250},{"name":"next_prediction","range":{"start":{"line":271,"character":0},"end":{"character":9999,"line":348}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')\n\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::erpin instead');    \n    $self->SUPER::_initialize(@args);\n    my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                    DESCTAG\n                                                                    SRCTAG\n                                   )],\n                                    @args);\n    $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n    $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n    $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n    foreach (qw(_tset _tset_desc _cutoff _db _db_desc\n               _db_ratios _eval_cutoff _seqid _secacc _seqdesc )) {\n        $self->{$_}='';\n    }\n}\n\n=head2 motif_tag\n\n Title   : motiftag\n Usage   : $obj->motiftag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'ERPIN' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'erpin' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the ERPIN output, this should\n           be set every time an ERPIN object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /ERPIN/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /ERPIN/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ERPIN result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $obj->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ERPIN result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)","label":"next_prediction($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"next_prediction","name":"$self","definition":"my","localvar":"my","kind":13,"line":272},{"line":273,"kind":13,"localvar":"my","definition":"my","name":"$motiftag","containerName":"next_prediction"},{"name":"$srctag","containerName":"next_prediction","line":273,"kind":13},{"kind":13,"line":273,"name":"$desctag","containerName":"next_prediction"},{"kind":13,"line":273,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"motif_tag","kind":12,"line":273},{"line":274,"kind":13,"name":"$self","containerName":"next_prediction"},{"name":"source_tag","containerName":"next_prediction","kind":12,"line":274},{"line":275,"kind":13,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","name":"desc_tag","kind":12,"line":275},{"kind":13,"line":277,"containerName":"next_prediction","name":"$strand","definition":"my","localvar":"my"},{"kind":13,"line":277,"name":"$start","containerName":"next_prediction"},{"line":277,"kind":13,"name":"$end","containerName":"next_prediction"},{"line":277,"kind":13,"name":"$sequence","containerName":"next_prediction"},{"kind":13,"line":277,"name":"$logodds","containerName":"next_prediction"},{"name":"$score","containerName":"next_prediction","kind":13,"line":277},{"name":"$self","containerName":"next_prediction","line":278,"kind":13},{"line":278,"kind":12,"name":"_readline","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":284},{"name":"$self","containerName":"next_prediction","line":287,"kind":13},{"kind":13,"line":290,"containerName":"next_prediction","name":"$self"},{"kind":13,"line":293,"name":"$self","containerName":"next_prediction"},{"kind":13,"line":296,"name":"$self","containerName":"next_prediction"},{"definition":"my","name":"$atgc","containerName":"next_prediction","localvar":"my","kind":13,"line":299},{"name":"$self","containerName":"next_prediction","kind":13,"line":300},{"kind":13,"line":300,"containerName":"next_prediction","name":"$atgc"},{"kind":13,"line":303,"name":"$self","containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":307},{"line":308,"kind":13,"containerName":"next_prediction","name":"$self"},{"name":"$self","containerName":"next_prediction","line":310,"kind":13},{"kind":13,"line":311,"name":"$self","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$self","kind":13,"line":313},{"kind":13,"line":313,"containerName":"next_prediction","name":"$self"},{"kind":13,"line":314,"name":"$self","containerName":"next_prediction"},{"kind":13,"line":319,"containerName":"next_prediction","name":"$strand"},{"line":319,"kind":13,"name":"$start","containerName":"next_prediction"},{"kind":13,"line":319,"containerName":"next_prediction","name":"$end"},{"line":319,"kind":13,"containerName":"next_prediction","name":"$logodds"},{"line":319,"kind":13,"containerName":"next_prediction","name":"$score"},{"kind":13,"line":320,"name":"$score","containerName":"next_prediction"},{"line":321,"kind":13,"containerName":"next_prediction","name":"$sequence"},{"name":"$self","containerName":"next_prediction","kind":13,"line":321},{"containerName":"next_prediction","name":"_readline","kind":12,"line":321},{"kind":13,"line":322,"definition":"my","name":"$gene","containerName":"next_prediction","localvar":"my"},{"name":"new","containerName":"next_prediction","line":322,"kind":12},{"kind":13,"line":322,"containerName":"next_prediction","name":"$self"},{"containerName":"next_prediction","name":"$start","line":323,"kind":13},{"kind":13,"line":324,"containerName":"next_prediction","name":"$end"},{"line":325,"kind":13,"name":"$strand","containerName":"next_prediction"},{"containerName":"next_prediction","name":"$score","kind":13,"line":326},{"kind":13,"line":327,"name":"$motiftag","containerName":"next_prediction"},{"line":328,"kind":13,"containerName":"next_prediction","name":"$srctag"},{"containerName":"next_prediction","name":"$desctag","kind":13,"line":329},{"containerName":"next_prediction","name":"$self","line":331,"kind":13},{"line":332,"kind":13,"containerName":"next_prediction","name":"$self"},{"kind":13,"line":333,"containerName":"next_prediction","name":"$self"},{"name":"$self","containerName":"next_prediction","line":334,"kind":13},{"name":"$self","containerName":"next_prediction","kind":13,"line":335},{"line":336,"kind":13,"name":"$self","containerName":"next_prediction"},{"line":337,"kind":13,"containerName":"next_prediction","name":"$self"},{"kind":13,"line":338,"name":"$self","containerName":"next_prediction"},{"name":"$logodds","containerName":"next_prediction","kind":13,"line":339},{"containerName":"next_prediction","name":"$sequence","kind":13,"line":340},{"containerName":"next_prediction","name":"$gene","kind":13,"line":342}],"line":271},{"kind":12,"line":307,"name":"_seq_desc"},{"name":"_seq_desc","line":308,"kind":12},{"name":"_seqid","kind":12,"line":310},{"kind":12,"line":311,"name":"_seq_acc"},{"line":313,"kind":12,"name":"_seqid"},{"line":313,"kind":12,"name":"_seq_desc"},{"kind":12,"line":314,"name":"_seq_acc"},{"name":"Bio","containerName":"SeqFeature::Generic","line":322,"kind":12},{"line":322,"kind":12,"name":"_seqid"},{"kind":12,"line":331,"name":"_tset"},{"line":332,"kind":12,"name":"_tset_descr"},{"name":"_cutoff","kind":12,"line":333},{"line":334,"kind":12,"name":"_db"},{"name":"_db_desc","kind":12,"line":335},{"kind":12,"line":336,"name":"_db_ratios"},{"kind":12,"line":337,"name":"_seq_desc"},{"kind":12,"line":338,"name":"_seq_acc"}]}