{"vars":[{"line":137,"kind":2,"containerName":"","name":"vars"},{"kind":2,"line":142,"name":"Common","containerName":"strict::IO::String::Bio::SeqIO::HTTP::Request"},{"name":"base","containerName":"","line":145,"kind":2},{"kind":13,"line":146,"containerName":null,"name":"$FLOAT"},{"localvar":"my","containerName":null,"name":"$URL","definition":"my","line":148,"kind":13},{"containerName":null,"name":"%STATUS","definition":"my","localvar":"my","kind":13,"line":151},{"localvar":"my","name":"$MIN_LEN","definition":"my","containerName":null,"line":153,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$ANALYSIS_NAME","line":154,"kind":13},{"localvar":"my","containerName":null,"name":"%ANALYSIS_SPEC","definition":"my","line":156,"kind":13},{"line":165,"kind":13,"localvar":"my","name":"@INPUT_SPEC","definition":"my","containerName":null},{"line":174,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%RESULT_SPEC"},{"kind":12,"children":[{"localvar":"my","containerName":"result","name":"$self","definition":"my","line":222,"kind":13},{"line":222,"kind":13,"name":"$value","containerName":"result"},{"localvar":"my","containerName":"result","name":"@sig_pdctns","definition":"my","line":225,"kind":13},{"line":226,"kind":13,"localvar":"my","definition":"my","name":"@fts","containerName":"result"},{"line":228,"kind":13,"containerName":"result","name":"$value"},{"line":229,"kind":13,"localvar":"my","containerName":"result","name":"$result","definition":"my"},{"containerName":"result","name":"new","line":229,"kind":12},{"containerName":"result","name":"$self","kind":13,"line":229},{"line":230,"kind":13,"localvar":"my","name":"%results","definition":"my","containerName":"result"},{"kind":13,"line":231,"containerName":"result","name":"$line","definition":"my","localvar":"my"},{"containerName":"result","name":"$result","line":231,"kind":13},{"line":233,"kind":13,"containerName":"result","name":"$line"},{"containerName":"result","name":"$line","line":233,"kind":13},{"name":"$line","containerName":"result","kind":13,"line":234},{"name":"$results","containerName":"result","line":237,"kind":13},{"kind":13,"line":238,"name":"$line","containerName":"result"},{"name":"$results","containerName":"result","line":239,"kind":13},{"line":240,"kind":13,"containerName":"result","name":"$line"},{"line":241,"kind":13,"name":"$results","containerName":"result"},{"line":242,"kind":13,"containerName":"result","name":"$line"},{"name":"$results","containerName":"result","line":243,"kind":13},{"line":244,"kind":13,"name":"$line","containerName":"result"},{"kind":13,"line":245,"containerName":"result","name":"$results"},{"line":246,"kind":13,"name":"$line","containerName":"result"},{"kind":13,"line":247,"containerName":"result","name":"$results"},{"name":"$line","containerName":"result","line":248,"kind":13},{"name":"$results","containerName":"result","line":249,"kind":13},{"containerName":"result","name":"$value","line":253,"kind":13},{"kind":13,"line":254,"name":"@fts","containerName":"result"},{"kind":12,"line":255,"containerName":"result","name":"new"},{"line":257,"kind":13,"name":"$results","containerName":"result"},{"name":"$results","containerName":"result","line":258,"kind":13},{"kind":13,"line":258,"containerName":"result","name":"$self"},{"name":"seq","containerName":"result","kind":12,"line":258},{"kind":12,"line":258,"containerName":"result","name":"length"},{"containerName":"result","name":"$results","line":262,"kind":13},{"containerName":"result","name":"$results","line":263,"kind":13},{"name":"$results","containerName":"result","kind":13,"line":264},{"name":"$results","containerName":"result","line":265,"kind":13},{"containerName":"result","name":"$results","line":268,"kind":13},{"kind":13,"line":271,"containerName":"result","name":"@fts"},{"name":"%results","containerName":"result","kind":13,"line":275},{"name":"$self","containerName":"result","line":278,"kind":13}],"line":221,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Mitoprot.pm,\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Mitoprot\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Mitoprot - a wrapper around Mitoprot\nserver\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Mitoprot;\n\n  use Bio::PrimarySeq;\n  my $seq = Bio::PrimarySeq->new\n    (-seq=>'IKLCVHHJHJHJHJHJHJHNLAILAKAHLIELALAL',\n     -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $mitoprot = Bio::Tools::Analysis::Protein::Mitoprot->new\n     ( -seq => $seq\n     ); # sequence must be  >!5aa long and start with an M.\n\n  # run Mitoprot prediction on a DNA sequence\n  my $mitoprot->run();\n\n\n  die \"Could not get a result\" unless $mitoprot->status =~ /^COMPLETED/;\n\n  print $mitoprot->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $mitoprot->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat);\n\n }\n\n=head1 DESCRIPTION\n\nThis class is a wrapper around the Mitoprot web server which\ncalculates the probability of a sequence containing a mitochondrial\ntargetting peptide. See http://mips.gsf.de/cgi-bin/proj/medgen/mitofilter\nfor more details.\n\nThe results can be obtained in 3 formats:\n\n=over 3\n\n* 1\n\nThe raw text of the program output\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nAn reference to a hash of  scores :\n\n  my $data_ref = $analysis_object->result('parsed'); print \"predicted\n  export prob is $data_ref->{'export_prob'}\\n\"; #\n\nkey values of returned hash are input_length, basic_aas, acidic_aas,\nexport_prob, charge, cleavage_site.\n\n* 3\n\nA Bio::SeqFeature::Generic object\n\n  my $ft = $analysis_object->result(Bio::SeqFeatureI);\n  print \"export prob is \", ($ft->each_tag_value('export_prob'))[0]  ,\"\\n\";\n\n\nThis the second implentation of Bio::SimpleAnalysisI which hopefully\nwill make it easier to write wrappers on various services. This class\nuses a web resource and therefore inherits from Bio::WebAgent.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>,\nL<Bio::Tools::Analysis::SimpleAnalysisBase>,\nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk,\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::Mitoprot;\nuse vars qw($FLOAT);\nuse strict;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(GET);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n$FLOAT = '[+-]?\\d*\\.\\d*';\n\nmy $URL = 'http://ihg.gsf.de/cgi-bin/paolo/mitofilter?';\n\n\nmy %STATUS =  map { $_ => 1 } qw(CREATED COMPLETED TERMINATED_BY_ERROR);\n\nmy $MIN_LEN = 60;               #min len for protein analysis\nmy $ANALYSIS_NAME = \"Mitoprot\";\n\nmy $ANALYSIS_SPEC =\n    {\n     'name'        => 'Mitoprot',\n     'type'        => 'Protein',\n     'version'     => '1.0a4',\n     'supplier'    => 'Munich Information Center for ProteinSequences',\n     'description' => 'mitochondrial sig seq prediction',\n    };\n\nmy $INPUT_SPEC =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',          #value must be name of method used to set value\n     },\n    ];\n\nmy $RESULT_SPEC =\n    {\n     '' => 'raw text results',  # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'all' => 'hash of results',\n    };\n\n\n\n### unique to this module ##\n\n=head2 result\n\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : various\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"SigSeq\".  Feature tags are input_length , basic_aas,\nacidic_aas, export_prob, charge, cleavage_site, method.\n\n* 'parsed'\n\nhash references of parsed results { input_length =E<gt>, basic_aas=E<gt>,\nacidic_aas=E<gt>, export_prob=E<gt>, charge=E<gt>, cleavage_site=E<gt>}.","label":"result($self,$value)"},"detail":"($self,$value)","name":"result","range":{"end":{"line":279,"character":9999},"start":{"line":221,"character":0}}},{"kind":12,"line":229,"containerName":"String","name":"IO"},{"line":254,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"kind":12,"line":262,"name":"export_prob"},{"kind":12,"line":263,"name":"charge"},{"line":264,"kind":12,"name":"basic_aas"},{"name":"acid_aas","kind":12,"line":265},{"name":"region_name","line":266,"kind":12},{"kind":12,"line":267,"name":"method"},{"name":"cleavage_site","line":268,"kind":12},{"range":{"end":{"character":9999,"line":289},"start":{"character":0,"line":281}},"definition":"sub","name":"_init","containerName":"main::","children":[{"kind":13,"line":282,"containerName":"_init","definition":"my","name":"$self","localvar":"my"},{"containerName":"_init","name":"$self","kind":13,"line":283},{"line":283,"kind":12,"name":"url","containerName":"_init"},{"line":283,"kind":13,"containerName":"_init","name":"$URL"},{"name":"$self","containerName":"_init","line":284,"kind":13},{"name":"$ANALYSIS_SPEC","containerName":"_init","kind":13,"line":284},{"containerName":"_init","name":"$self","line":285,"kind":13},{"name":"$INPUT_SPEC","containerName":"_init","kind":13,"line":285},{"kind":13,"line":286,"containerName":"_init","name":"$self"},{"containerName":"_init","name":"$RESULT_SPEC","kind":13,"line":286},{"kind":13,"line":287,"name":"$self","containerName":"_init"},{"kind":13,"line":287,"name":"$ANALYSIS_SPEC","containerName":"_init"},{"kind":13,"line":288,"containerName":"_init","name":"$self"}],"line":281,"kind":12},{"detail":"($self,$args)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$args"}],"label":"_process_arguments($self,$args)"},"containerName":"main::","definition":"sub","line":291,"children":[{"kind":13,"line":294,"name":"$self","definition":"my","containerName":"_process_arguments","localvar":"my"},{"name":"$args","containerName":"_process_arguments","line":294,"kind":13},{"containerName":"_process_arguments","name":"$self","kind":13,"line":296},{"kind":13,"line":296,"containerName":"_process_arguments","name":"$args"},{"containerName":"_process_arguments","name":"$self","kind":13,"line":299},{"line":299,"kind":12,"containerName":"_process_arguments","name":"throw"},{"containerName":"_process_arguments","name":"$self","kind":13,"line":299},{"kind":12,"line":299,"containerName":"_process_arguments","name":"seq"},{"kind":12,"line":299,"containerName":"_process_arguments","name":"subseq"},{"kind":13,"line":300,"containerName":"_process_arguments","name":"$self"},{"containerName":"_process_arguments","name":"throw","line":300,"kind":12},{"kind":13,"line":300,"containerName":"_process_arguments","name":"$self"},{"line":300,"kind":12,"containerName":"_process_arguments","name":"seq"},{"name":"length","containerName":"_process_arguments","kind":12,"line":300}],"kind":12,"range":{"start":{"character":0,"line":291},"end":{"line":302,"character":9999}},"name":"_process_arguments"},{"containerName":"_process_arguments","name":"SUPER","line":296,"kind":12},{"containerName":"main::","name":"_run","definition":"sub","range":{"start":{"character":0,"line":306},"end":{"line":325,"character":9999}},"kind":12,"line":306,"children":[{"kind":13,"line":308,"containerName":"_run","definition":"my","name":"$self","localvar":"my"},{"line":309,"kind":13,"containerName":"_run","name":"$self"},{"containerName":"_run","name":"delay","kind":12,"line":309},{"containerName":"_run","name":"$self","kind":13,"line":310},{"line":310,"kind":12,"containerName":"_run","name":"sleep"},{"containerName":"_run","name":"$self","line":312,"kind":13},{"kind":12,"line":312,"name":"status","containerName":"_run"},{"containerName":"_run","definition":"my","name":"$url","localvar":"my","kind":13,"line":313},{"kind":13,"line":313,"name":"$self","containerName":"_run"},{"kind":12,"line":313,"name":"url","containerName":"_run"},{"name":"$self","containerName":"_run","line":313,"kind":13},{"containerName":"_run","name":"seq","line":313,"kind":12},{"line":313,"kind":12,"containerName":"_run","name":"seq"},{"line":314,"kind":13,"localvar":"my","containerName":"_run","definition":"my","name":"$request"},{"line":314,"kind":13,"containerName":"_run","name":"$url"},{"name":"$content","definition":"my","containerName":"_run","localvar":"my","kind":13,"line":315},{"name":"$self","containerName":"_run","line":315,"kind":13},{"containerName":"_run","name":"request","line":315,"kind":12},{"name":"$request","containerName":"_run","line":315,"kind":13},{"kind":13,"line":316,"containerName":"_run","name":"$text","definition":"my","localvar":"my"},{"kind":13,"line":316,"name":"$content","containerName":"_run"},{"line":316,"kind":12,"name":"content","containerName":"_run"},{"kind":13,"line":319,"containerName":"_run","name":"$text"},{"name":"$text","containerName":"_run","kind":13,"line":320},{"containerName":"_run","name":"$self","line":322,"kind":13},{"containerName":"_run","name":"status","line":322,"kind":12},{"name":"$text","containerName":"_run","line":322,"kind":13},{"kind":13,"line":322,"name":"$self","containerName":"_run"},{"containerName":"_run","name":"seq","line":322,"kind":12},{"containerName":"_run","name":"length","line":322,"kind":12},{"kind":13,"line":322,"name":"$MIN_LEN","containerName":"_run"},{"name":"$self","containerName":"_run","line":323,"kind":13},{"line":323,"kind":13,"containerName":"_run","name":"$text"}]},{"kind":12,"line":314,"name":"GET"}],"version":5}