{"vars":[{"name":"Common","containerName":"strict::Bio::Tools::Analysis::Protein::GOR4::IO::String::Bio::SeqIO::HTTP::Request","line":152,"kind":2},{"name":"base","containerName":"","kind":2,"line":157},{"containerName":"main::","name":"MIN_STRUC_LEN","definition":1,"kind":14,"line":159},{"kind":13,"line":160,"definition":"my","name":"$URL","containerName":null,"localvar":"my"},{"kind":13,"line":161,"containerName":null,"name":"$ANALYSIS_NAME","definition":"my","localvar":"my"},{"kind":13,"line":162,"definition":"my","name":"%ANALYSIS_SPEC","containerName":null,"localvar":"my"},{"kind":12,"line":162,"name":"name"},{"name":"type","kind":12,"line":162},{"localvar":"my","containerName":null,"name":"@INPUT_SPEC","definition":"my","line":163,"kind":13},{"name":"mandatory","line":164,"kind":12},{"kind":12,"line":165,"name":"type"},{"kind":13,"line":169,"containerName":null,"name":"%RESULT_SPEC","definition":"my","localvar":"my"},{"kind":12,"line":173,"name":"raw"},{"name":"meta","line":174,"kind":12},{"name":"result","range":{"start":{"line":221,"character":0},"end":{"character":9999,"line":260}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: GOR4.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::GOR4\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1  NAME\n\nBio::Tools::Analysis::Protein::GOR4 - a wrapper around GOR4 protein\nsecondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::GOR4;\n  #get a Bio::Seq or Bio::PrimarySeq\n  use Bio::PrimarySeq;\n  $seq = Bio::PrimarySeq->new\n    (-seq=>'IKLCVHHJHJHJHJHJHJHNLAILAKAHLIELALAL',\n     -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $gor4 = Bio::Tools::Analysis::Protein::GOR4->new (-seq=>$seq);\n  $gor4->run;\n  print $gor4->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of three different states (helix,\ncoil or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::GOR4->\n      new(-seq => $seq);\n\ncreates a new object\n\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output\n\nGiven an amino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method\n\n=over 4\n\n* 1\n\nThe raw text of the program output\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nAn reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices. See \nBio::Tools::Analysis::Domcut.pm for examples of how to add sequence\nfeatures.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence In this case, the sequence can be associated with a\nsingle array of GOR4 prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('all');\n  print \"helix scores from residues 10-20 are \",\n      $meta_sequence->named_submeta_text(\"GOR4_helix\",10,20), \"\\n\";\n\nMeta sequence names are : GOR4_helix, GOR4_sheet, GOR4_coil,\nGOR4_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>, \nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk,\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::GOR4;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\nuse constant MIN_STRUC_LEN => 3;\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_gor4.pl';\nmy $ANALYSIS_NAME = 'GOR4';\nmy $ANALYSIS_SPEC = {name => 'Gor4', type => 'Protein'};\nmy $INPUT_SPEC    = [\n                     {mandatory =>'true',\n                      type      => 'Bio::PrimarySeqI',\n                      'name'    => 'seq',\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     raw                => '[ {struc =>, helix=> ,sheet=>, coil=>}]',\n     meta                => 'Bio::Seq::Meta::Array object',\n    };\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : see keys of $RESULT_SPEC\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"2ary\".  Feature tags are \"type\" (which can be helix, sheet or\ncoil) \"method\" (GOR4).\n\n* 'parsed'\n\nArray of hash references of { helix =E<gt>, sheet =E<gt> , coil =E<gt> , struc=E<gt>}.\n\n* 'meta'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence names are GOR4_helix, GOR4_sheet,\nGOR4_coil, GOR4_struc.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"result($self,$value)"},"kind":12,"line":221,"children":[{"kind":13,"line":222,"containerName":"result","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":222,"name":"$value","containerName":"result"},{"kind":13,"line":224,"containerName":"result","definition":"my","name":"@scores","localvar":"my"},{"localvar":"my","definition":"my","name":"@fts","containerName":"result","line":225,"kind":13},{"kind":13,"line":227,"name":"$value","containerName":"result"},{"line":229,"kind":13,"containerName":"result","name":"$self"},{"kind":13,"line":230,"containerName":"result","definition":"my","name":"$result","localvar":"my"},{"name":"new","containerName":"result","kind":12,"line":230},{"name":"$self","containerName":"result","kind":13,"line":230},{"kind":13,"line":231,"definition":"my","name":"$line","containerName":"result","localvar":"my"},{"name":"$result","containerName":"result","kind":13,"line":231},{"containerName":"result","name":"$line","kind":13,"line":232},{"containerName":"result","name":"$line","line":233,"kind":13},{"kind":13,"line":234,"name":"@scores","containerName":"result"},{"containerName":"result","name":"$self","line":240,"kind":13},{"name":"@scores","containerName":"result","line":240,"kind":13},{"name":"$value","containerName":"result","kind":13,"line":242},{"containerName":"result","name":"$self","line":243,"kind":13},{"line":243,"kind":12,"name":"_get_2ary_coords","containerName":"result"},{"localvar":"my","containerName":"result","name":"$type","definition":"my","line":244,"kind":13},{"containerName":"result","name":"$self","kind":13,"line":244},{"containerName":"result","name":"$type","line":245,"kind":13},{"kind":13,"line":246,"definition":"my","name":"$loc","containerName":"result","localvar":"my"},{"kind":13,"line":246,"containerName":"result","name":"$self"},{"line":246,"kind":13,"name":"$type","containerName":"result"},{"line":247,"kind":13,"containerName":"result","name":"@fts"},{"kind":12,"line":248,"name":"new","containerName":"result"},{"containerName":"result","name":"$loc","line":248,"kind":13},{"name":"$loc","containerName":"result","kind":13,"line":249},{"line":253,"kind":13,"containerName":"result","name":"$type"},{"containerName":"result","name":"$self","kind":13,"line":254},{"name":"analysis_name","containerName":"result","line":254,"kind":12},{"containerName":"result","name":"$self","kind":13,"line":258},{"line":259,"kind":13,"name":"@fts","containerName":"result"}]},{"kind":12,"line":230,"containerName":"String","name":"IO"},{"name":"struc","line":234,"kind":12},{"kind":12,"line":235,"name":"helix"},{"name":"sheet","line":236,"kind":12},{"line":237,"kind":12,"name":"coil"},{"name":"Bio","containerName":"SeqFeature::Generic","line":247,"kind":12},{"kind":12,"line":253,"name":"type"},{"name":"method","kind":12,"line":254},{"line":262,"kind":13,"name":"%value","containerName":null},{"kind":13,"line":264,"name":"%type_scores","definition":"my","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"name":"$aa","definition":"my","line":265,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":265},{"name":"%type_scores","containerName":null,"kind":13,"line":266},{"containerName":null,"name":"%aa","line":266,"kind":13},{"line":267,"kind":13,"containerName":null,"name":"%type_scores"},{"kind":13,"line":267,"containerName":null,"name":"%aa"},{"line":268,"kind":13,"containerName":null,"name":"%type_scores"},{"kind":13,"line":268,"containerName":null,"name":"%aa"},{"line":269,"kind":13,"name":"%type_scores","containerName":null},{"containerName":null,"name":"%aa","line":269,"kind":13},{"line":273,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":273,"containerName":"main::","name":"seq"},{"name":"isa","containerName":"main::","kind":12,"line":273},{"kind":13,"line":274,"name":"$self","containerName":null},{"name":"seq","containerName":"main::","line":274,"kind":12},{"line":276,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"seq","line":276,"kind":12},{"line":276,"kind":12,"containerName":"main::","name":"isa"},{"containerName":null,"name":"$self","line":277,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":277},{"kind":13,"line":278,"containerName":null,"name":"$Bio"},{"name":"Seq","containerName":"Meta::Array::DEFAULT_NAME","line":278,"kind":12},{"line":281,"kind":13,"localvar":"my","definition":"my","name":"$struc_type","containerName":null},{"line":281,"kind":13,"name":"%type_scores","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$meta_name","line":282,"kind":13},{"localvar":"my","definition":"my","name":"@meta","containerName":null,"line":283,"kind":13},{"line":283,"kind":13,"name":"$struc_type","containerName":null},{"name":"%self","containerName":null,"line":283,"kind":13},{"kind":13,"line":284,"containerName":null,"name":"$meta_name"},{"line":284,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":284,"containerName":"main::","name":"seq"},{"name":"meta_names","containerName":"main::","kind":12,"line":284},{"containerName":null,"name":"$self","kind":13,"line":285},{"containerName":"main::","name":"warn","line":285,"kind":12},{"line":288,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":288,"containerName":"main::","name":"seq"},{"kind":12,"line":288,"containerName":"main::","name":"named_meta"},{"kind":13,"line":288,"containerName":null,"name":"$meta_name"},{"containerName":null,"name":"@meta","line":288,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":291},{"line":291,"kind":12,"name":"seq","containerName":"main::"},{"line":295,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":300,"name":"%self","containerName":null},{"name":"_get_2ary_coords","range":{"end":{"character":9999,"line":311},"start":{"line":303,"character":0}},"kind":12,"line":303,"children":[{"containerName":"_get_2ary_coords","name":"$self","definition":"my","localvar":"my","kind":13,"line":310},{"kind":13,"line":311,"name":"@prot","definition":"my","containerName":"_get_2ary_coords","localvar":"my"},{"containerName":"_get_2ary_coords","name":"$self","line":311,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_get_2ary_coords($self)"}},{"kind":13,"line":312,"name":"%Result","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":313,"containerName":null,"definition":"my","name":"$index","localvar":"my"},{"name":"$index","containerName":null,"kind":13,"line":313},{"name":"prot","line":313,"kind":12},{"name":"%index","containerName":null,"kind":13,"line":313},{"line":315,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":null},{"kind":13,"line":315,"containerName":null,"name":"@prot"},{"containerName":null,"name":"%index","line":315,"kind":13},{"containerName":null,"name":"$type","line":316,"kind":13},{"definition":"my","name":"$length","containerName":null,"localvar":"my","kind":13,"line":317},{"localvar":"my","containerName":null,"name":"$j","definition":"my","line":318,"kind":13},{"name":"$index","containerName":null,"line":318,"kind":13},{"line":318,"kind":13,"name":"$j","containerName":null},{"line":318,"kind":12,"name":"prot"},{"line":318,"kind":13,"containerName":null,"name":"%j"},{"line":319,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$test"},{"kind":13,"line":319,"name":"@prot","containerName":null},{"name":"$j","containerName":null,"line":319,"kind":13},{"line":320,"kind":13,"containerName":null,"name":"%test"},{"kind":13,"line":320,"name":"%type","containerName":null},{"containerName":null,"name":"$length","line":321,"kind":13},{"name":"$length","containerName":null,"line":322,"kind":13},{"line":322,"kind":12,"name":"MIN_STRUC_LEN"},{"containerName":null,"name":"$length","kind":13,"line":323},{"kind":12,"line":323,"name":"MIN_STRUC_LEN"},{"kind":13,"line":323,"name":"%type","containerName":null},{"line":324,"kind":13,"containerName":null,"name":"%Result"},{"containerName":null,"name":"%type","kind":13,"line":324},{"kind":12,"line":324,"name":"start"},{"name":"$index","containerName":null,"kind":13,"line":324},{"kind":12,"line":324,"name":"end"},{"containerName":null,"name":"$j","kind":13,"line":324},{"line":325,"kind":13,"containerName":null,"name":"$index"},{"containerName":null,"name":"%length","line":325,"kind":13},{"containerName":null,"name":"$index","line":328,"kind":13},{"line":328,"kind":13,"containerName":null,"name":"$length"},{"containerName":null,"name":"%self","line":333,"kind":13},{"containerName":null,"name":"%Result","kind":13,"line":333},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_init","localvar":"my","kind":13,"line":337},{"line":338,"kind":13,"name":"$self","containerName":"_init"},{"name":"url","containerName":"_init","kind":12,"line":338},{"kind":13,"line":338,"containerName":"_init","name":"$URL"},{"kind":13,"line":339,"containerName":"_init","name":"$self"},{"containerName":"_init","name":"$ANALYSIS_SPEC","line":339,"kind":13},{"name":"$self","containerName":"_init","kind":13,"line":340},{"containerName":"_init","name":"$INPUT_SPEC","line":340,"kind":13},{"line":341,"kind":13,"name":"$self","containerName":"_init"},{"kind":13,"line":341,"name":"$RESULT_SPEC","containerName":"_init"},{"name":"$self","containerName":"_init","kind":13,"line":342},{"name":"$ANALYSIS_NAME","containerName":"_init","kind":13,"line":342},{"kind":13,"line":343,"containerName":"_init","name":"$self"}],"line":336,"definition":"sub","name":"_init","containerName":"main::","range":{"start":{"character":0,"line":336},"end":{"line":344,"character":9999}}},{"kind":12,"children":[{"containerName":"_run","definition":"my","name":"$self","localvar":"my","kind":13,"line":348},{"line":349,"kind":13,"containerName":"_run","name":"$self"},{"containerName":"_run","name":"delay","kind":12,"line":349},{"containerName":"_run","name":"$self","kind":13,"line":351},{"kind":12,"line":351,"name":"sleep","containerName":"_run"},{"containerName":"_run","name":"$self","line":352,"kind":13},{"line":352,"kind":12,"containerName":"_run","name":"status"},{"kind":13,"line":353,"definition":"my","name":"$request","containerName":"_run","localvar":"my"},{"kind":13,"line":353,"containerName":"_run","name":"$self"},{"line":353,"kind":12,"name":"url","containerName":"_run"},{"containerName":"_run","name":"$self","kind":13,"line":356},{"line":356,"kind":12,"name":"seq","containerName":"_run"},{"line":356,"kind":12,"name":"seq","containerName":"_run"},{"containerName":"_run","definition":"my","name":"$content","localvar":"my","kind":13,"line":360},{"containerName":"_run","name":"$self","kind":13,"line":360},{"kind":12,"line":360,"containerName":"_run","name":"request"},{"line":360,"kind":13,"name":"$request","containerName":"_run"},{"line":361,"kind":13,"localvar":"my","containerName":"_run","definition":"my","name":"$text"},{"kind":13,"line":361,"containerName":"_run","name":"$content"},{"line":361,"kind":12,"containerName":"_run","name":"content"},{"kind":13,"line":362,"containerName":"_run","name":"$text"},{"definition":"my","name":"$next","containerName":"_run","localvar":"my","kind":13,"line":363},{"line":363,"kind":13,"containerName":"_run","name":"$text"},{"containerName":"_run","name":"$next","line":364,"kind":13},{"kind":13,"line":365,"name":"$out","definition":"my","containerName":"_run","localvar":"my"},{"containerName":"_run","name":"$next","line":365,"kind":13},{"definition":"my","name":"$req2","containerName":"_run","localvar":"my","kind":13,"line":366},{"containerName":"_run","name":"new","kind":12,"line":366},{"kind":13,"line":366,"name":"$out","containerName":"_run"},{"localvar":"my","containerName":"_run","name":"$resp2","definition":"my","line":367,"kind":13},{"line":367,"kind":13,"name":"$self","containerName":"_run"},{"containerName":"_run","name":"request","kind":12,"line":367},{"kind":13,"line":367,"name":"$req2","containerName":"_run"},{"kind":13,"line":368,"containerName":"_run","name":"$self"},{"line":368,"kind":12,"containerName":"_run","name":"status"},{"name":"$resp2","containerName":"_run","kind":13,"line":368},{"name":"$self","containerName":"_run","line":369,"kind":13},{"containerName":"_run","name":"$resp2","line":369,"kind":13},{"line":369,"kind":12,"containerName":"_run","name":"content"}],"line":347,"definition":"sub","name":"_run","containerName":"main::","range":{"end":{"line":370,"character":9999},"start":{"line":347,"character":0}}},{"name":"POST","kind":12,"line":353},{"name":"Content_Type","line":354,"kind":12},{"line":355,"kind":12,"name":"Content"},{"name":"title","kind":12,"line":355},{"line":356,"kind":12,"name":"notice"},{"name":"ali_width","kind":12,"line":357},{"containerName":"Request","name":"HTTP","kind":12,"line":366},{"name":"GET","line":366,"kind":12}],"version":5}