{"vars":[{"name":"base","containerName":"","kind":2,"line":91},{"name":"new","range":{"start":{"line":105,"character":0},"end":{"character":9999,"line":117}},"kind":12,"line":105,"children":[{"line":106,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"line":106,"kind":13,"name":"@args","containerName":"new"},{"line":108,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"kind":13,"line":108,"name":"$class","containerName":"new"},{"line":108,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":109},{"kind":13,"line":110,"containerName":"new","name":"$self"},{"name":"$symbols","definition":"my","containerName":"new","localvar":"my","kind":13,"line":111},{"containerName":"new","name":"$subalphas","kind":13,"line":111},{"containerName":"new","name":"$self","line":111,"kind":13},{"name":"_rearrange","containerName":"new","line":111,"kind":12},{"kind":13,"line":112,"containerName":"new","name":"@args"},{"line":114,"kind":13,"name":"$symbols","containerName":"new"},{"kind":13,"line":114,"containerName":"new","name":"$symbols"},{"containerName":"new","name":"$self","kind":13,"line":114},{"kind":12,"line":114,"name":"symbols","containerName":"new"},{"containerName":"new","name":"$symbols","line":114,"kind":13},{"kind":13,"line":115,"containerName":"new","name":"$subalphas"},{"name":"$subalphas","containerName":"new","line":115,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":115},{"kind":12,"line":115,"name":"alphabets","containerName":"new"},{"containerName":"new","name":"$subalphas","line":115,"kind":13},{"line":116,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets","parameters":[{"label":"$class"},{"label":"@args"}]}},{"containerName":"new","name":"SUPER","line":108,"kind":12},{"name":"symbols","range":{"end":{"character":9999,"line":146},"start":{"line":134,"character":0}},"kind":12,"line":134,"children":[{"localvar":"my","containerName":"symbols","name":"$self","definition":"my","line":135,"kind":13},{"containerName":"symbols","name":"@args","line":135,"kind":13},{"kind":13,"line":136,"name":"@args","containerName":"symbols"},{"kind":13,"line":137,"containerName":"symbols","name":"$self"},{"localvar":"my","definition":"my","name":"$symbol","containerName":"symbols","line":138,"kind":13},{"name":"@args","containerName":"symbols","kind":13,"line":138},{"containerName":"symbols","name":"$symbol","line":139,"kind":13},{"kind":13,"line":139,"name":"$symbol","containerName":"symbols"},{"kind":13,"line":140,"containerName":"symbols","name":"$symbol"},{"name":"isa","containerName":"symbols","kind":12,"line":140},{"name":"$self","containerName":"symbols","line":141,"kind":13},{"name":"warn","containerName":"symbols","kind":12,"line":141},{"line":143,"kind":13,"containerName":"symbols","name":"$self"},{"kind":13,"line":143,"containerName":"symbols","name":"$symbol"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"symbols($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->{'_symbols'} = [];\n    $self->{'_alphabets'} = [];\n    my ($symbols, $subalphas) = $self->_rearrange([qw(SYMBOLS SUBALPHAS)],\n\t\t\t\t\t\t  @args);\n\n    defined $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n    defined $subalphas && ref($subalphas) =~ /array/i && $self->alphabets(@$subalphas);\n    return $self;\n}\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optionalalphabets) Array of Bio::Symbol::SymbolI objects"}},{"kind":13,"line":147,"name":"%self","containerName":null},{"name":"alphabets","range":{"start":{"line":161,"character":0},"end":{"line":172,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->{'_symbols'} = [];\n    $self->{'_alphabets'} = [];\n    my ($symbols, $subalphas) = $self->_rearrange([qw(SYMBOLS SUBALPHAS)],\n\t\t\t\t\t\t  @args);\n\n    defined $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n    defined $subalphas && ref($subalphas) =~ /array/i && $self->alphabets(@$subalphas);\n    return $self;\n}\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optionalalphabets) Array of Bio::Symbol::SymbolI objects\n\n\nsub symbols {\n    my ($self,@args) = @_;\n    if( @args ) { \n\t$self->{'_symbols'} = [];\n\tforeach my $symbol ( @args ) {\n\t    if( ! defined $symbol || ! ref($symbol) || \n\t\t! $symbol->isa('Bio::Symbol::SymbolI') ) {\n\t\t$self->warn(\"Did not provide a proper Bio::Symbol::SymbolI to method 'symbols' (got $symbol)\");\n\t    } else { \n\t\tpush @{$self->{'_symbols'}}, $symbol;\n\t    }\n\t}\n    }\n    return @{$self->{'_symbols'}};\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of Bio::Symbol::AlphabetI objects\n Args    : (optional) Array of Bio::Symbol::AlphabetI objects","parameters":[{"label":"$self"},{"label":"@args"}],"label":"alphabets($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"containerName":"alphabets","name":"$self","definition":"my","localvar":"my","kind":13,"line":162},{"name":"@args","containerName":"alphabets","line":162,"kind":13},{"name":"@args","containerName":"alphabets","line":163,"kind":13},{"kind":13,"line":164,"name":"$self","containerName":"alphabets"},{"containerName":"alphabets","name":"$alpha","definition":"my","localvar":"my","kind":13,"line":165},{"line":165,"kind":13,"containerName":"alphabets","name":"@args"},{"containerName":"alphabets","name":"$alpha","kind":13,"line":166},{"line":166,"kind":12,"name":"isa","containerName":"alphabets"},{"containerName":"alphabets","name":"$self","kind":13,"line":167},{"name":"warn","containerName":"alphabets","kind":12,"line":167},{"kind":13,"line":169,"containerName":"alphabets","name":"$self"},{"containerName":"alphabets","name":"$alpha","line":169,"kind":13}],"line":161},{"name":"%self","containerName":null,"line":173,"kind":13},{"detail":"($self,$testsymbol)","signature":{"label":"contains($self,$testsymbol)","documentation":"1;\n# $Id: Alphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Alphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Alphabet - BSANE/BioCORBA compliant symbol list alphabet\n\n=head1 SYNOPSIS\n\n  {\n      my $alphabet = Bio::Symbols::Alphabet->new(-symbols => [ @s ],\n  \t\t\t\t\t\t-subalphabets => [ @alphas ] );\n\n      my @symbols = $alphabet->symbols;\n      my @subalphas = $alphabet->alphabets;\n      if( $alphabet->contains($symbol) ) {\n  \t  # do something\n      }\n  }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to\nform symbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Alphabet;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Symbol::AlphabetI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Alphabet->new();\n Function: Builds a new Bio::Symbol::Alphabet object \n Returns : Bio::Symbol::Alphabet\n Args    : -symbols  => Array ref of Bio::Symbol::SymbolI objects\n           -subalphas=> Array ref of Bio::Symbol::AlphabetI objects \n                        representing sub alphabets\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->{'_symbols'} = [];\n    $self->{'_alphabets'} = [];\n    my ($symbols, $subalphas) = $self->_rearrange([qw(SYMBOLS SUBALPHAS)],\n\t\t\t\t\t\t  @args);\n\n    defined $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n    defined $subalphas && ref($subalphas) =~ /array/i && $self->alphabets(@$subalphas);\n    return $self;\n}\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optionalalphabets) Array of Bio::Symbol::SymbolI objects\n\n\nsub symbols {\n    my ($self,@args) = @_;\n    if( @args ) { \n\t$self->{'_symbols'} = [];\n\tforeach my $symbol ( @args ) {\n\t    if( ! defined $symbol || ! ref($symbol) || \n\t\t! $symbol->isa('Bio::Symbol::SymbolI') ) {\n\t\t$self->warn(\"Did not provide a proper Bio::Symbol::SymbolI to method 'symbols' (got $symbol)\");\n\t    } else { \n\t\tpush @{$self->{'_symbols'}}, $symbol;\n\t    }\n\t}\n    }\n    return @{$self->{'_symbols'}};\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of Bio::Symbol::AlphabetI objects\n Args    : (optional) Array of Bio::Symbol::AlphabetI objects\n\n\nsub alphabets {\n    my ($self,@args) = @_;\n   if( @args ) { \n       $self->{'_alphabets'} = [];\n       foreach my $alpha ( @args ) {\n\t   if( ! $alpha->isa('Bio::Symbol::AlphabetI') ) {\n\t       $self->warn(\"Did not provide a proper Bio::Symbol::AlphabetI to method 'alphabets' (got $alpha)\");\n\t   } else { \n\t       push @{$self->{'_alphabets'}}, $alpha;\n\t   }\n       }\n   }\n    return @{$self->{'_alphabets'}};\n}\n\n=head2 contains\n\n Title   : contains\n Usage   : if($alphabet->contains($symbol)) { }\n Function: Tests of Symbol is contained in this alphabet\n Returns : Boolean\n Args    : Bio::Symbol::SymbolI","parameters":[{"label":"$self"},{"label":"$testsymbol"}]},"containerName":"main::","definition":"sub","line":186,"children":[{"name":"$self","definition":"my","containerName":"contains","localvar":"my","kind":13,"line":187},{"line":187,"kind":13,"containerName":"contains","name":"$testsymbol"},{"containerName":"contains","name":"$symbol","definition":"my","localvar":"my","kind":13,"line":188},{"name":"$self","containerName":"contains","line":188,"kind":13},{"containerName":"contains","name":"symbols","kind":12,"line":188},{"name":"$symbol","containerName":"contains","line":189,"kind":13},{"name":"equals","containerName":"contains","line":189,"kind":12},{"name":"$testsymbol","containerName":"contains","kind":13,"line":189}],"kind":12,"range":{"end":{"line":192,"character":9999},"start":{"line":186,"character":0}},"name":"contains"}],"version":5}