{"vars":[{"name":"base","containerName":"","kind":2,"line":156},{"containerName":"main::","name":"%lookUp","definition":"our","kind":13,"line":161},{"range":{"start":{"character":0,"line":229},"end":{"line":236,"character":9999}},"name":"new","children":[{"line":230,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"name":"@args","containerName":"new","line":230,"kind":13},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":231},{"name":"$class","containerName":"new","kind":13,"line":231},{"name":"@args","containerName":"new","line":231,"kind":13},{"kind":13,"line":232,"name":"$io","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"new","kind":12,"line":232},{"kind":13,"line":232,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":233,"kind":13},{"containerName":"new","name":"_parse","line":233,"kind":12},{"kind":13,"line":233,"name":"$io","containerName":"new"},{"line":233,"kind":12,"containerName":"new","name":"_fh"},{"containerName":"new","name":"$io","kind":13,"line":234},{"line":234,"kind":12,"containerName":"new","name":"close"},{"containerName":"new","name":"$self","kind":13,"line":235}],"line":229,"kind":12,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Header$\n#\n# bioperl module for Bio::Structure::SecStr::DSSP::Res.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ed Green <ed@compbio.berkeley.edu>\n#\n# Copyright Univ. of California\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::SecStr::DSSP::Res - Module for parsing/accessing dssp output\n\n=head1 SYNOPSIS\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-file'=>'filename.dssp');\n\n  # or\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-fh'=>\\*STDOUT);\n\n  # get DSSP defined Secondary Structure for residue 20\n  $sec_str = $dssp_obj->resSecStr( 20 );\n\n  # get dssp defined sec. structure summary for PDB residue  # 10 of chain A\n\n  $sec_str = $dssp_obj->resSecStrSum( '10:A' );\n\n=head1 DESCRIPTION\n\nDSSP::Res is a module for objectifying DSSP output.  Methods are then\navailable for extracting all the information within the output file\nand convenient subsets of it.\nThe principal purpose of DSSP is to determine secondary structural\nelements of a given structure.\n\n    ( Dictionary of protein secondary structure: pattern recognition\n      of hydrogen-bonded and geometrical features.\n      Biopolymers. 1983 Dec;22(12):2577-637. )\n\nThe DSSP program is available from:\n  http://www.cmbi.kun.nl/swift/dssp\n\nThis information is available on a per residue basis ( see resSecStr\nand resSecStrSum methods ) or on a per chain basis ( see secBounds\nmethod ).\n\nresSecStr() & secBounds() return one of the following:\n    'H' = alpha helix\n    'B' = residue in isolated beta-bridge\n    'E' = extended strand, participates in beta ladder\n    'G' = 3-helix (3/10 helix)\n    'I' = 5 helix (pi helix)\n    'T' = hydrogen bonded turn\n    'S' = bend\n    ''  = no assignment\n\nA more general classification is returned using the resSecStrSum()\nmethod.  The purpose of this is to have a method for DSSP and STRIDE\nderived output whose range is the same.\nIts output is one of the following:\n\n    'H' = helix         ( => 'H', 'G', or 'I' from above )\n    'B' = beta          ( => 'B' or 'E' from above )\n    'T' = turn          ( => 'T' or 'S' from above )\n    ' ' = no assignment ( => ' ' from above )\n\nThe methods are roughly divided into 3 sections:\n1.  Global features of this structure (PDB ID, total surface area,\n    etc.).  These methods do not require an argument.\n2.  Residue specific features ( amino acid, secondary structure,\n    solvent exposed surface area, etc. ).  These methods do require an\n    arguement.  The argument is supposed to uniquely identify a\n    residue described within the structure.  It can be of any of the\n    following forms:\n    ('#A:B') or ( #, 'A', 'B' )\n      || |\n      || - Chain ID (blank for single chain)\n      |--- Insertion code for this residue.  Blank for most residues.\n      |--- Numeric portion of residue ID.\n\n    (#)\n     |\n     --- Numeric portion of residue ID.  If there is only one chain and\n         it has no ID AND there is no residue with an insertion code at this\n         number, then this can uniquely specify a residue.\n\n    ('#:C') or ( #, 'C' )\n      | |\n      | -Chain ID\n      ---Numeric portion of residue ID.\n\n  If a residue is incompletely specified then the first residue that\n  fits the arguments is returned.  For example, if 19 is the argument\n  and there are three chains, A, B, and C with a residue whose number\n  is 19, then 19:A will be returned (assuming its listed first).\n\n  Since neither DSSP nor STRIDE correctly handle alt-loc codes, they\n  are not supported by these modules.\n\n3.  Value-added methods.  Return values are not verbatem strings\n    parsed from DSSP or STRIDE output.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ed Green\n\nEmail ed@compbio.berkeley.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each method.\nInternal methods are preceded with a _\n\n\npackage Bio::Structure::SecStr::DSSP::Res;\nuse strict;\nuse Bio::Root::IO;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n# Would be a class variable if Perl had them\n\n               #attribute        begin col        # columns\nour %lookUp = ( 'pdb_resnum'     => [  5,           5 ],\n\t\t'insertionco'    => [  10,          1 ],\n\t\t'pdb_chain'      => [  11,          1 ],\n\t\t\n\t\t'amino_acid'     => [  13,          1 ],\n\t\t'term_sig'       => [  14,          1 ],\n\t\t\n\t\t'ss_summary'     => [  16,          1 ],\n\t\t'3tph'           => [  18,          1 ],\n\t\t'4tph'           => [  19,          1 ],\n\t\t'5tph'           => [  20,          1 ],\n\t\t'geo_bend'       => [  21,          1 ],\n\t\t'chirality'      => [  22,          1 ],\n\t\t'beta_br1la'     => [  23,          1 ],\n\t\t'beta_br2la'     => [  24,          1 ],\n\n\t\t'bb_part1nu'     => [  25,          4 ],\n\t\t'bb_part2nu'     => [  29,          4 ],\n\t\t'betash_lab'     => [  33,          1 ],\n\t\t\n\t\t'solv_acces'     => [  34,          4 ],\n\t\t\n\t\t'hb1_nh_o_p'     => [  39,          6 ],\n\t\t'hb1_nh_o_e'     => [  46,          4 ],\n\t\t\n\t\t'hb1_o_hn_p'     => [  50,          6 ],\n\t\t'hb1_o_hn_e'     => [  57,          4 ],\n\t\t\n\t\t'hb2_nh_o_p'     => [  61,          6 ],\n\t\t'hb2_nh_o_e'     => [  68,          4 ],\n\t\t\n\t\t'hb2_o_hn_p'     => [  72,          6 ],\n\t\t'hb2_o_hn_e'     => [  79,          4 ],\n\t\t\n\t\t'tco'            => [  85,          6 ],\n\t\t\n\t\t'kappa'          => [  91,          6 ],\n\t\t\n\t\t'alpha'          => [  97,          6 ],\n\t\n\t\t'phi'            => [ 103,          6 ],\n\n\t\t'psi'            => [ 109,          6 ],\n\t\t\n\t\t'x_ca'           => [ 115,          7 ],\n\t\t\n\t\t'y_ca'           => [ 122,          7 ],\n\t\t\n\t\t'z_ca'           => [ 129,          7 ] );\n\n\n=head1 CONSTRUCTOR\n\n\n\n\n=head2 new\n\n Title         : new\n Usage         : makes new object of this class\n Function      : Constructor\n Example       : $dssp_obj = Bio::DSSP:Res->new( filename or FILEHANDLE )\n Returns       : object (ref)\n Args          : filename ( must be proper DSSP output file )","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::"},{"line":231,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"line":232,"containerName":"Root::IO","name":"Bio"},{"range":{"end":{"character":9999,"line":259},"start":{"character":0,"line":256}},"definition":"sub","name":"totSurfArea","containerName":"main::","children":[{"localvar":"my","containerName":"totSurfArea","name":"$self","definition":"my","line":257,"kind":13},{"containerName":"totSurfArea","name":"$self","kind":13,"line":258}],"line":256,"kind":12},{"range":{"start":{"line":274,"character":0},"end":{"line":296,"character":9999}},"containerName":"main::","name":"numResidues","definition":"sub","line":274,"children":[{"localvar":"my","containerName":"numResidues","name":"$self","definition":"my","line":275,"kind":13},{"localvar":"my","definition":"my","name":"$chain","containerName":"numResidues","line":276,"kind":13},{"containerName":"numResidues","name":"$chain","kind":13,"line":277},{"name":"$self","containerName":"numResidues","line":278,"kind":13},{"localvar":"my","definition":"my","name":"$num_res","containerName":"numResidues","line":281,"kind":13},{"name":"$cont_seg","containerName":"numResidues","kind":13,"line":282},{"localvar":"my","definition":"my","name":"$cont_seg_pnt","containerName":"numResidues","line":283,"kind":13},{"line":283,"kind":13,"name":"$self","containerName":"numResidues"},{"line":283,"kind":12,"name":"_contSegs","containerName":"numResidues"},{"kind":13,"line":284,"name":"$cont_seg","containerName":"numResidues"},{"name":"$cont_seg_pnt","containerName":"numResidues","line":284,"kind":13},{"name":"$chain","containerName":"numResidues","kind":13,"line":285},{"kind":13,"line":285,"name":"$cont_seg","containerName":"numResidues"},{"kind":13,"line":287,"containerName":"numResidues","name":"$num_res"},{"line":287,"kind":13,"name":"$self","containerName":"numResidues"},{"line":287,"kind":12,"containerName":"numResidues","name":"_toDsspKey"},{"kind":13,"line":287,"name":"$cont_seg","containerName":"numResidues"},{"line":288,"kind":13,"containerName":"numResidues","name":"$self"},{"kind":12,"line":288,"containerName":"numResidues","name":"_toDsspKey"},{"line":288,"kind":13,"name":"$cont_seg","containerName":"numResidues"},{"kind":13,"line":295,"name":"$num_res","containerName":"numResidues"}],"kind":12},{"definition":"sub","name":"pdbID","containerName":"main::","range":{"start":{"line":313,"character":0},"end":{"line":316,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"pdbID","name":"$self","definition":"my","line":314,"kind":13},{"line":315,"kind":13,"containerName":"pdbID","name":"$self"}],"line":313},{"range":{"start":{"character":0,"line":330},"end":{"character":9999,"line":333}},"containerName":"main::","name":"pdbAuthor","definition":"sub","line":330,"children":[{"containerName":"pdbAuthor","name":"$self","definition":"my","localvar":"my","kind":13,"line":331},{"line":332,"kind":13,"name":"$self","containerName":"pdbAuthor"}],"kind":12},{"range":{"start":{"character":0,"line":347},"end":{"character":9999,"line":350}},"definition":"sub","name":"pdbCompound","containerName":"main::","children":[{"line":348,"kind":13,"localvar":"my","containerName":"pdbCompound","name":"$self","definition":"my"},{"name":"$self","containerName":"pdbCompound","kind":13,"line":349}],"line":347,"kind":12},{"range":{"start":{"character":0,"line":364},"end":{"line":367,"character":9999}},"definition":"sub","name":"pdbDate","containerName":"main::","children":[{"line":365,"kind":13,"localvar":"my","containerName":"pdbDate","definition":"my","name":"$self"},{"line":366,"kind":13,"name":"$self","containerName":"pdbDate"}],"line":364,"kind":12},{"kind":12,"line":381,"children":[{"kind":13,"line":382,"name":"$self","definition":"my","containerName":"pdbHeader","localvar":"my"},{"line":383,"kind":13,"containerName":"pdbHeader","name":"$self"}],"containerName":"main::","definition":"sub","name":"pdbHeader","range":{"start":{"character":0,"line":381},"end":{"character":9999,"line":384}}},{"kind":12,"children":[{"line":399,"kind":13,"localvar":"my","containerName":"pdbSource","name":"$self","definition":"my"},{"containerName":"pdbSource","name":"$self","kind":13,"line":400}],"line":398,"definition":"sub","name":"pdbSource","containerName":"main::","range":{"end":{"line":401,"character":9999},"start":{"line":398,"character":0}}},{"children":[{"line":419,"kind":13,"localvar":"my","containerName":"resAA","name":"$self","definition":"my"},{"line":420,"kind":13,"localvar":"my","containerName":"resAA","definition":"my","name":"@args"},{"kind":13,"line":421,"name":"$dssp_key","definition":"my","containerName":"resAA","localvar":"my"},{"containerName":"resAA","name":"$self","line":421,"kind":13},{"name":"_toDsspKey","containerName":"resAA","line":421,"kind":12},{"containerName":"resAA","name":"@args","kind":13,"line":421},{"line":422,"kind":13,"name":"$self","containerName":"resAA"},{"kind":13,"line":422,"name":"$dssp_key","containerName":"resAA"}],"line":418,"kind":12,"range":{"start":{"line":418,"character":0},"end":{"character":9999,"line":423}},"definition":"sub","name":"resAA","containerName":"main::"},{"containerName":"main::","name":"resPhi","definition":"sub","range":{"end":{"character":9999,"line":442},"start":{"line":437,"character":0}},"kind":12,"line":437,"children":[{"containerName":"resPhi","definition":"my","name":"$self","localvar":"my","kind":13,"line":438},{"line":439,"kind":13,"localvar":"my","name":"@args","definition":"my","containerName":"resPhi"},{"line":440,"kind":13,"localvar":"my","definition":"my","name":"$dssp_key","containerName":"resPhi"},{"line":440,"kind":13,"containerName":"resPhi","name":"$self"},{"kind":12,"line":440,"containerName":"resPhi","name":"_toDsspKey"},{"line":440,"kind":13,"containerName":"resPhi","name":"@args"},{"containerName":"resPhi","name":"$self","kind":13,"line":441},{"kind":13,"line":441,"name":"$dssp_key","containerName":"resPhi"}]},{"range":{"end":{"line":461,"character":9999},"start":{"line":456,"character":0}},"definition":"sub","name":"resPsi","containerName":"main::","children":[{"line":457,"kind":13,"localvar":"my","containerName":"resPsi","definition":"my","name":"$self"},{"line":458,"kind":13,"localvar":"my","containerName":"resPsi","name":"@args","definition":"my"},{"kind":13,"line":459,"definition":"my","name":"$dssp_key","containerName":"resPsi","localvar":"my"},{"line":459,"kind":13,"name":"$self","containerName":"resPsi"},{"containerName":"resPsi","name":"_toDsspKey","line":459,"kind":12},{"name":"@args","containerName":"resPsi","kind":13,"line":459},{"name":"$self","containerName":"resPsi","kind":13,"line":460},{"line":460,"kind":13,"name":"$dssp_key","containerName":"resPsi"}],"line":456,"kind":12},{"range":{"end":{"character":9999,"line":481},"start":{"character":0,"line":476}},"name":"resSolvAcc","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"resSolvAcc","line":477,"kind":13},{"localvar":"my","name":"@args","definition":"my","containerName":"resSolvAcc","line":478,"kind":13},{"line":479,"kind":13,"localvar":"my","containerName":"resSolvAcc","name":"$dssp_key","definition":"my"},{"kind":13,"line":479,"containerName":"resSolvAcc","name":"$self"},{"containerName":"resSolvAcc","name":"_toDsspKey","kind":12,"line":479},{"name":"@args","containerName":"resSolvAcc","line":479,"kind":13},{"kind":13,"line":480,"containerName":"resSolvAcc","name":"$self"},{"kind":13,"line":480,"name":"$dssp_key","containerName":"resSolvAcc"}],"line":476,"kind":12},{"kind":12,"line":496,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"resSurfArea","line":497,"kind":13},{"definition":"my","name":"@args","containerName":"resSurfArea","localvar":"my","kind":13,"line":498},{"definition":"my","name":"$dssp_key","containerName":"resSurfArea","localvar":"my","kind":13,"line":499},{"containerName":"resSurfArea","name":"$self","kind":13,"line":499},{"containerName":"resSurfArea","name":"_toDsspKey","kind":12,"line":499},{"kind":13,"line":499,"containerName":"resSurfArea","name":"@args"},{"containerName":"resSurfArea","name":"$self","kind":13,"line":500},{"line":500,"kind":13,"name":"$dssp_key","containerName":"resSurfArea"}],"containerName":"main::","definition":"sub","name":"resSurfArea","range":{"start":{"character":0,"line":496},"end":{"line":501,"character":9999}}},{"definition":"sub","name":"resSecStr","containerName":"main::","range":{"end":{"line":525,"character":9999},"start":{"line":518,"character":0}},"kind":12,"children":[{"containerName":"resSecStr","name":"$self","definition":"my","localvar":"my","kind":13,"line":519},{"line":520,"kind":13,"localvar":"my","containerName":"resSecStr","definition":"my","name":"@args"},{"kind":13,"line":521,"name":"$dssp_key","definition":"my","containerName":"resSecStr","localvar":"my"},{"kind":13,"line":521,"containerName":"resSecStr","name":"$self"},{"name":"_toDsspKey","containerName":"resSecStr","line":521,"kind":12},{"line":521,"kind":13,"name":"@args","containerName":"resSecStr"},{"line":522,"kind":13,"localvar":"my","containerName":"resSecStr","definition":"my","name":"$ss_char"},{"containerName":"resSecStr","name":"$self","line":522,"kind":13},{"containerName":"resSecStr","name":"$dssp_key","line":522,"kind":13},{"name":"$ss_char","containerName":"resSecStr","kind":13,"line":523},{"name":"$ss_char","containerName":"resSecStr","line":523,"kind":13}],"line":518},{"range":{"start":{"line":546,"character":0},"end":{"character":9999,"line":563}},"containerName":"main::","definition":"sub","name":"resSecStrSum","line":546,"children":[{"name":"$self","definition":"my","containerName":"resSecStrSum","localvar":"my","kind":13,"line":547},{"containerName":"resSecStrSum","name":"@args","definition":"my","localvar":"my","kind":13,"line":548},{"kind":13,"line":549,"name":"$dssp_key","definition":"my","containerName":"resSecStrSum","localvar":"my"},{"name":"$self","containerName":"resSecStrSum","kind":13,"line":549},{"name":"_toDsspKey","containerName":"resSecStrSum","line":549,"kind":12},{"kind":13,"line":549,"name":"@args","containerName":"resSecStrSum"},{"kind":13,"line":550,"name":"$ss_char","definition":"my","containerName":"resSecStrSum","localvar":"my"},{"name":"$self","containerName":"resSecStrSum","kind":13,"line":550},{"line":550,"kind":13,"name":"$dssp_key","containerName":"resSecStrSum"},{"kind":13,"line":551,"containerName":"resSecStrSum","name":"$ss_char"},{"containerName":"resSecStrSum","name":"$ss_char","kind":13,"line":551},{"line":551,"kind":13,"containerName":"resSecStrSum","name":"$ss_char"},{"containerName":"resSecStrSum","name":"$ss_char","kind":13,"line":554},{"containerName":"resSecStrSum","name":"$ss_char","kind":13,"line":554},{"kind":13,"line":557,"name":"$ss_char","containerName":"resSecStrSum"},{"containerName":"resSecStrSum","name":"$ss_char","line":557,"kind":13}],"kind":12},{"line":593,"children":[{"kind":13,"line":594,"containerName":"hBonds","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":595,"name":"$self","containerName":"hBonds"}],"kind":12,"range":{"start":{"line":593,"character":0},"end":{"line":596,"character":9999}},"containerName":"main::","name":"hBonds","definition":"sub"},{"line":610,"children":[{"line":611,"kind":13,"localvar":"my","containerName":"numSSBr","name":"$self","definition":"my"},{"line":612,"kind":13,"name":"$self","containerName":"numSSBr"},{"line":613,"kind":13,"containerName":"numSSBr","name":"$self"},{"kind":13,"line":614,"name":"$self","containerName":"numSSBr"}],"kind":12,"range":{"start":{"character":0,"line":610},"end":{"line":615,"character":9999}},"containerName":"main::","definition":"sub","name":"numSSBr"},{"range":{"end":{"line":643,"character":9999},"start":{"character":0,"line":635}},"containerName":"main::","definition":"sub","name":"resHB_O_HN","line":635,"children":[{"localvar":"my","containerName":"resHB_O_HN","definition":"my","name":"$self","line":636,"kind":13},{"line":637,"kind":13,"localvar":"my","name":"@args","definition":"my","containerName":"resHB_O_HN"},{"containerName":"resHB_O_HN","name":"$dssp_key","definition":"my","localvar":"my","kind":13,"line":638},{"kind":13,"line":638,"containerName":"resHB_O_HN","name":"$self"},{"kind":12,"line":638,"containerName":"resHB_O_HN","name":"_toDsspKey"},{"name":"@args","containerName":"resHB_O_HN","line":638,"kind":13},{"kind":13,"line":639,"name":"$self","containerName":"resHB_O_HN"},{"line":639,"kind":13,"containerName":"resHB_O_HN","name":"$dssp_key"},{"name":"$self","containerName":"resHB_O_HN","line":640,"kind":13},{"name":"$dssp_key","containerName":"resHB_O_HN","kind":13,"line":640},{"containerName":"resHB_O_HN","name":"$self","kind":13,"line":641},{"name":"$dssp_key","containerName":"resHB_O_HN","line":641,"kind":13},{"containerName":"resHB_O_HN","name":"$self","line":642,"kind":13},{"name":"$dssp_key","containerName":"resHB_O_HN","line":642,"kind":13}],"kind":12},{"containerName":"main::","definition":"sub","name":"resHB_NH_O","range":{"start":{"line":664,"character":0},"end":{"line":672,"character":9999}},"kind":12,"line":664,"children":[{"line":665,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"resHB_NH_O"},{"kind":13,"line":666,"name":"@args","definition":"my","containerName":"resHB_NH_O","localvar":"my"},{"kind":13,"line":667,"containerName":"resHB_NH_O","name":"$dssp_key","definition":"my","localvar":"my"},{"containerName":"resHB_NH_O","name":"$self","kind":13,"line":667},{"name":"_toDsspKey","containerName":"resHB_NH_O","kind":12,"line":667},{"containerName":"resHB_NH_O","name":"@args","kind":13,"line":667},{"line":668,"kind":13,"containerName":"resHB_NH_O","name":"$self"},{"name":"$dssp_key","containerName":"resHB_NH_O","kind":13,"line":668},{"name":"$self","containerName":"resHB_NH_O","kind":13,"line":669},{"name":"$dssp_key","containerName":"resHB_NH_O","line":669,"kind":13},{"kind":13,"line":670,"containerName":"resHB_NH_O","name":"$self"},{"kind":13,"line":670,"containerName":"resHB_NH_O","name":"$dssp_key"},{"name":"$self","containerName":"resHB_NH_O","kind":13,"line":671},{"name":"$dssp_key","containerName":"resHB_NH_O","kind":13,"line":671}]},{"range":{"start":{"line":687,"character":0},"end":{"character":9999,"line":692}},"containerName":"main::","name":"resTco","definition":"sub","line":687,"children":[{"line":688,"kind":13,"localvar":"my","containerName":"resTco","definition":"my","name":"$self"},{"localvar":"my","definition":"my","name":"@args","containerName":"resTco","line":689,"kind":13},{"localvar":"my","containerName":"resTco","name":"$dssp_key","definition":"my","line":690,"kind":13},{"kind":13,"line":690,"containerName":"resTco","name":"$self"},{"containerName":"resTco","name":"_toDsspKey","kind":12,"line":690},{"line":690,"kind":13,"containerName":"resTco","name":"@args"},{"containerName":"resTco","name":"$self","kind":13,"line":691},{"containerName":"resTco","name":"$dssp_key","line":691,"kind":13}],"kind":12},{"containerName":"main::","definition":"sub","name":"resKappa","range":{"end":{"character":9999,"line":712},"start":{"line":707,"character":0}},"kind":12,"line":707,"children":[{"containerName":"resKappa","name":"$self","definition":"my","localvar":"my","kind":13,"line":708},{"containerName":"resKappa","definition":"my","name":"@args","localvar":"my","kind":13,"line":709},{"kind":13,"line":710,"definition":"my","name":"$dssp_key","containerName":"resKappa","localvar":"my"},{"kind":13,"line":710,"containerName":"resKappa","name":"$self"},{"line":710,"kind":12,"containerName":"resKappa","name":"_toDsspKey"},{"containerName":"resKappa","name":"@args","line":710,"kind":13},{"containerName":"resKappa","name":"$self","kind":13,"line":711},{"kind":13,"line":711,"name":"$dssp_key","containerName":"resKappa"}]},{"range":{"end":{"line":732,"character":9999},"start":{"character":0,"line":727}},"containerName":"main::","name":"resAlpha","definition":"sub","line":727,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"resAlpha","line":728,"kind":13},{"line":729,"kind":13,"localvar":"my","definition":"my","name":"@args","containerName":"resAlpha"},{"kind":13,"line":730,"containerName":"resAlpha","definition":"my","name":"$dssp_key","localvar":"my"},{"containerName":"resAlpha","name":"$self","line":730,"kind":13},{"containerName":"resAlpha","name":"_toDsspKey","line":730,"kind":12},{"name":"@args","containerName":"resAlpha","kind":13,"line":730},{"containerName":"resAlpha","name":"$self","line":731,"kind":13},{"name":"$dssp_key","containerName":"resAlpha","kind":13,"line":731}],"kind":12},{"range":{"end":{"character":9999,"line":796},"start":{"line":754,"character":0}},"containerName":"main::","name":"secBounds","definition":"sub","line":754,"children":[{"kind":13,"line":755,"definition":"my","name":"$self","containerName":"secBounds","localvar":"my"},{"localvar":"my","name":"$chain","definition":"my","containerName":"secBounds","line":756,"kind":13},{"localvar":"my","name":"%sec_bounds","definition":"my","containerName":"secBounds","line":757,"kind":13},{"line":759,"kind":13,"containerName":"secBounds","name":"$chain"},{"name":"$chain","containerName":"secBounds","kind":13,"line":759},{"line":759,"kind":13,"containerName":"secBounds","name":"$chain"},{"containerName":"secBounds","name":"$chain","line":759,"kind":13},{"line":762,"kind":13,"name":"$self","containerName":"secBounds"},{"containerName":"secBounds","name":"$self","kind":13,"line":764},{"kind":13,"line":764,"containerName":"secBounds","name":"$chain"},{"containerName":"secBounds","name":"$self","line":765,"kind":13},{"kind":12,"line":765,"name":"throw","containerName":"secBounds"},{"name":"$self","containerName":"secBounds","kind":13,"line":767},{"name":"$chain","containerName":"secBounds","kind":13,"line":767},{"containerName":"secBounds","definition":"my","name":"$cur_element","localvar":"my","kind":13,"line":770},{"containerName":"secBounds","name":"$i","kind":13,"line":770},{"line":770,"kind":13,"name":"$cur_chain","containerName":"secBounds"},{"name":"$beg","containerName":"secBounds","line":770,"kind":13},{"containerName":"secBounds","name":"$cur_element","kind":13,"line":773},{"kind":13,"line":773,"containerName":"secBounds","name":"$self"},{"name":"$beg","containerName":"secBounds","kind":13,"line":774},{"name":"$i","containerName":"secBounds","line":776,"kind":13},{"line":776,"kind":13,"name":"$i","containerName":"secBounds"},{"name":"$self","containerName":"secBounds","kind":13,"line":776},{"containerName":"secBounds","name":"_numResLines","line":776,"kind":12},{"kind":13,"line":776,"name":"$i","containerName":"secBounds"},{"containerName":"secBounds","name":"$self","line":777,"kind":13},{"kind":13,"line":777,"name":"$i","containerName":"secBounds"},{"name":"$sec_bounds","containerName":"secBounds","line":779,"kind":13},{"line":779,"kind":13,"name":"$self","containerName":"secBounds"},{"line":779,"kind":12,"name":"_pdbChain","containerName":"secBounds"},{"containerName":"secBounds","name":"$beg","kind":13,"line":779},{"kind":13,"line":780,"name":"$self","containerName":"secBounds"},{"line":780,"kind":12,"containerName":"secBounds","name":"_toPdbId"},{"line":780,"kind":13,"name":"$beg","containerName":"secBounds"},{"name":"$self","containerName":"secBounds","kind":13,"line":781},{"name":"_toPdbId","containerName":"secBounds","line":781,"kind":12},{"line":781,"kind":13,"name":"$i","containerName":"secBounds"},{"name":"$cur_element","containerName":"secBounds","kind":13,"line":782},{"line":783,"kind":13,"name":"$i","containerName":"secBounds"},{"line":784,"kind":13,"name":"$beg","containerName":"secBounds"},{"containerName":"secBounds","name":"$i","kind":13,"line":784},{"containerName":"secBounds","name":"$cur_element","line":785,"kind":13},{"containerName":"secBounds","name":"$self","kind":13,"line":785},{"line":785,"kind":13,"containerName":"secBounds","name":"$i"},{"line":788,"kind":13,"name":"$self","containerName":"secBounds"},{"kind":13,"line":788,"containerName":"secBounds","name":"$i"},{"kind":13,"line":788,"containerName":"secBounds","name":"$cur_element"},{"line":790,"kind":13,"name":"$sec_bounds","containerName":"secBounds"},{"name":"$self","containerName":"secBounds","line":790,"kind":13},{"line":790,"kind":12,"name":"_pdbChain","containerName":"secBounds"},{"line":790,"kind":13,"name":"$beg","containerName":"secBounds"},{"line":791,"kind":13,"containerName":"secBounds","name":"$self"},{"kind":12,"line":791,"containerName":"secBounds","name":"_toPdbId"},{"containerName":"secBounds","name":"$beg","kind":13,"line":791},{"line":792,"kind":13,"containerName":"secBounds","name":"$self"},{"line":792,"kind":12,"containerName":"secBounds","name":"_toPdbId"},{"kind":13,"line":792,"name":"$i","containerName":"secBounds"},{"line":793,"kind":13,"containerName":"secBounds","name":"$cur_element"},{"containerName":"secBounds","name":"$beg","line":794,"kind":13},{"kind":13,"line":794,"name":"$i","containerName":"secBounds"},{"containerName":"secBounds","name":"$cur_element","kind":13,"line":795},{"line":795,"kind":13,"containerName":"secBounds","name":"$self"},{"line":795,"kind":13,"containerName":"secBounds","name":"$i"}],"kind":12},{"name":"%self","containerName":null,"line":799,"kind":13},{"containerName":null,"name":"%i","kind":13,"line":799},{"line":799,"kind":13,"containerName":null,"name":"%cur_element"},{"containerName":null,"name":"%sec_bounds","line":800,"kind":13},{"containerName":null,"name":"$self","line":800,"kind":13},{"line":800,"kind":12,"containerName":"main::","name":"_pdbChain"},{"kind":13,"line":800,"containerName":null,"name":"@beg"},{"line":801,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_toPdbId","line":801,"kind":12},{"name":"$beg","containerName":null,"kind":13,"line":801},{"kind":13,"line":802,"name":"$self","containerName":null},{"name":"_toPdbId","containerName":"main::","kind":12,"line":802},{"line":802,"kind":13,"containerName":null,"name":"$i"},{"line":803,"kind":13,"name":"%cur_element","containerName":null},{"name":"%sec_bounds","containerName":null,"kind":13,"line":807},{"line":807,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_pdbChain","kind":12,"line":807},{"kind":13,"line":807,"name":"@beg","containerName":null},{"containerName":null,"name":"$self","line":808,"kind":13},{"name":"_toPdbId","containerName":"main::","line":808,"kind":12},{"kind":13,"line":808,"containerName":null,"name":"$beg"},{"line":809,"kind":13,"containerName":null,"name":"$self"},{"line":809,"kind":12,"name":"_toPdbId","containerName":"main::"},{"containerName":null,"name":"$i","line":809,"kind":13},{"kind":13,"line":810,"name":"$cur_element","containerName":null},{"kind":13,"line":811,"name":"%sec_bounds","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":811},{"containerName":"main::","name":"_pdbChain","line":811,"kind":12},{"name":"@i","containerName":null,"kind":13,"line":811},{"kind":13,"line":812,"containerName":null,"name":"$self"},{"name":"_toPdbId","containerName":"main::","kind":12,"line":812},{"line":812,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"$self","line":813,"kind":13},{"kind":12,"line":813,"containerName":"main::","name":"_toPdbId"},{"kind":13,"line":813,"containerName":null,"name":"$i"},{"line":814,"kind":13,"containerName":null,"name":"%self"},{"name":"%i","containerName":null,"kind":13,"line":814},{"line":817,"kind":13,"containerName":null,"name":"%self"},{"name":"%sec_bounds","containerName":null,"kind":13,"line":817},{"line":820,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":820,"containerName":null,"name":"%chain"},{"kind":13,"line":821,"name":"$self","containerName":null},{"line":821,"kind":12,"name":"throw","containerName":"main::"},{"containerName":null,"name":"%self","line":824,"kind":13},{"line":824,"kind":13,"containerName":null,"name":"$chain"},{"children":[{"definition":"my","name":"$self","containerName":"chains","localvar":"my","kind":13,"line":842},{"line":843,"kind":13,"localvar":"my","definition":"my","name":"$cont_segs","containerName":"chains"},{"name":"$self","containerName":"chains","line":843,"kind":13},{"kind":12,"line":843,"name":"_contSegs","containerName":"chains"},{"localvar":"my","name":"%chains","definition":"my","containerName":"chains","line":844,"kind":13},{"line":845,"kind":13,"localvar":"my","definition":"my","name":"$seg","containerName":"chains"},{"line":846,"kind":13,"name":"$seg","containerName":"chains"},{"line":846,"kind":13,"containerName":"chains","name":"$cont_segs"}],"line":841,"kind":12,"range":{"start":{"line":841,"character":0},"end":{"character":9999,"line":846}},"name":"chains","definition":"sub","containerName":"main::"},{"kind":13,"line":847,"containerName":null,"name":"%chains"},{"containerName":null,"name":"@seg","line":847,"kind":13},{"kind":13,"line":849,"name":"@chains","definition":"my","containerName":null,"localvar":"my"},{"line":849,"kind":13,"name":"%chains","containerName":null},{"line":850,"kind":13,"containerName":null,"name":"@chains"},{"range":{"start":{"line":872,"character":0},"end":{"line":895,"character":9999}},"definition":"sub","name":"residues","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"residues","line":873,"kind":13},{"containerName":"residues","definition":"my","name":"$chain","localvar":"my","kind":13,"line":874},{"kind":13,"line":875,"containerName":"residues","name":"@residues","definition":"my","localvar":"my"},{"kind":13,"line":876,"definition":"my","name":"$num_res","containerName":"residues","localvar":"my"},{"containerName":"residues","name":"$self","kind":13,"line":876},{"name":"_numResLines","containerName":"residues","line":876,"kind":12},{"kind":13,"line":877,"containerName":"residues","name":"$aa","definition":"my","localvar":"my"},{"name":"$i","definition":"my","containerName":"residues","localvar":"my","kind":13,"line":878},{"name":"$i","containerName":"residues","kind":13,"line":878},{"kind":13,"line":878,"name":"$num_res","containerName":"residues"},{"containerName":"residues","name":"$i","line":878,"kind":13},{"name":"$aa","containerName":"residues","line":882,"kind":13},{"line":882,"kind":13,"name":"$self","containerName":"residues"},{"line":882,"kind":13,"containerName":"residues","name":"$i"},{"kind":13,"line":883,"name":"$aa","containerName":"residues"},{"containerName":"residues","name":"$chain","kind":13,"line":884},{"name":"$chain","containerName":"residues","line":885,"kind":13},{"line":885,"kind":13,"containerName":"residues","name":"$self"},{"name":"$i","containerName":"residues","line":885,"kind":13},{"name":"@residues","containerName":"residues","kind":13,"line":886},{"line":887,"kind":13,"containerName":"residues","name":"$self"},{"kind":13,"line":887,"name":"$i","containerName":"residues"},{"kind":13,"line":888,"containerName":"residues","name":"$self"},{"line":888,"kind":13,"name":"$i","containerName":"residues"},{"name":"$self","containerName":"residues","kind":13,"line":890},{"line":890,"kind":13,"name":"$i","containerName":"residues"},{"name":"@residues","containerName":"residues","kind":13,"line":894}],"line":872,"kind":12},{"containerName":"main::","name":"getSeq","definition":"sub","range":{"start":{"character":0,"line":916},"end":{"line":943,"character":9999}},"kind":12,"line":916,"children":[{"kind":13,"line":917,"name":"$self","definition":"my","containerName":"getSeq","localvar":"my"},{"containerName":"getSeq","definition":"my","name":"$chain","localvar":"my","kind":13,"line":918},{"localvar":"my","containerName":"getSeq","definition":"my","name":"$pot_chain","line":920,"kind":13},{"kind":13,"line":921,"containerName":"getSeq","name":"$seq"},{"name":"$frag_num","containerName":"getSeq","kind":13,"line":922},{"containerName":"getSeq","name":"$frag","kind":13,"line":923},{"kind":13,"line":924,"name":"$curPdbNum","containerName":"getSeq"},{"name":"$lastPdbNum","containerName":"getSeq","line":925,"kind":13},{"name":"$gap_len","containerName":"getSeq","kind":13,"line":926},{"name":"$i","containerName":"getSeq","kind":13,"line":927},{"containerName":"getSeq","name":"$id","line":928,"kind":13},{"kind":13,"line":930,"containerName":"getSeq","definition":"my","name":"@frags","localvar":"my"},{"line":932,"kind":13,"name":"$chain","containerName":"getSeq"},{"containerName":"getSeq","name":"$chain","kind":13,"line":933},{"containerName":"getSeq","name":"$self","line":936,"kind":13},{"line":936,"kind":13,"containerName":"getSeq","name":"$chain"},{"line":937,"kind":13,"containerName":"getSeq","name":"$self"},{"kind":13,"line":937,"containerName":"getSeq","name":"$chain"},{"line":940,"kind":13,"localvar":"my","containerName":"getSeq","definition":"my","name":"$contSegs_pnt"},{"line":940,"kind":13,"name":"$self","containerName":"getSeq"},{"name":"_contSegs","containerName":"getSeq","kind":12,"line":940},{"name":"$pot_chain","containerName":"getSeq","kind":13,"line":943},{"name":"$contSegs_pnt","containerName":"getSeq","kind":13,"line":943}]},{"kind":13,"line":944,"name":"@pot_chain","containerName":null},{"kind":13,"line":944,"containerName":null,"name":"%chain"},{"line":945,"kind":13,"name":"@frags","containerName":null},{"name":"$pot_chain","containerName":null,"kind":13,"line":945},{"name":"@frags","containerName":null,"kind":13,"line":950},{"containerName":null,"name":"$chain","line":951,"kind":13},{"line":951,"kind":13,"containerName":null,"name":"@contSegs_pnt"},{"name":"$pot_chain","containerName":null,"kind":13,"line":952},{"kind":13,"line":952,"name":"%contSegs_pnt","containerName":null},{"name":"@pot_chain","containerName":null,"line":953,"kind":13},{"containerName":null,"name":"%chain","kind":13,"line":953},{"name":"@frags","containerName":null,"kind":13,"line":954},{"line":954,"kind":13,"name":"$pot_chain","containerName":null},{"containerName":null,"name":"$seq","kind":13,"line":960},{"line":961,"kind":13,"name":"$frag_num","containerName":null},{"containerName":null,"name":"$frag","kind":13,"line":962},{"line":962,"kind":13,"name":"@frags","containerName":null},{"line":963,"kind":13,"containerName":null,"name":"$frag_num"},{"containerName":null,"name":"%frag_num","line":964,"kind":13},{"containerName":null,"name":"$curPdbNum","line":965,"kind":13},{"kind":13,"line":965,"containerName":null,"name":"$self"},{"kind":12,"line":965,"containerName":"main::","name":"_pdbNum"},{"kind":13,"line":965,"containerName":null,"name":"@frag"},{"line":966,"kind":13,"containerName":null,"name":"$gap_len"},{"name":"$curPdbNum","containerName":null,"line":966,"kind":13},{"containerName":null,"name":"$lastPdbNum","line":966,"kind":13},{"line":967,"kind":13,"name":"%gap_len","containerName":null},{"containerName":null,"name":"$seq","line":968,"kind":13},{"containerName":null,"name":"%gap_len","kind":13,"line":968},{"kind":13,"line":971,"name":"$seq","containerName":null},{"line":974,"kind":13,"containerName":null,"name":"$i"},{"line":974,"kind":13,"name":"@frag","containerName":null},{"kind":13,"line":974,"containerName":null,"name":"$i"},{"containerName":null,"name":"@frag","line":974,"kind":13},{"name":"%i","containerName":null,"line":974,"kind":13},{"containerName":null,"name":"$seq","kind":13,"line":975},{"containerName":null,"name":"$self","kind":13,"line":975},{"kind":12,"line":975,"containerName":"main::","name":"_resAA"},{"line":975,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":977,"containerName":null,"name":"$lastPdbNum"},{"line":977,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":977,"containerName":"main::","name":"_pdbNum"},{"line":977,"kind":13,"containerName":null,"name":"$i"},{"line":982,"kind":13,"containerName":null,"name":"$id"},{"line":982,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"pdbID","kind":12,"line":982},{"line":983,"kind":13,"containerName":null,"name":"$id"},{"line":985,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":985,"containerName":null,"name":"$chain"},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":985},{"kind":12,"line":985,"containerName":"main::","name":"new"},{"name":"$seq","containerName":null,"kind":13,"line":985},{"kind":13,"line":986,"containerName":null,"name":"$id"},{"containerName":null,"name":"%self","kind":13,"line":989},{"name":"$chain","containerName":null,"kind":13,"line":989},{"kind":12,"children":[{"kind":13,"line":1010,"containerName":"_pdbChain","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1011,"definition":"my","name":"$dssp_key","containerName":"_pdbChain","localvar":"my"},{"kind":13,"line":1012,"containerName":"_pdbChain","name":"$self"},{"line":1012,"kind":13,"name":"$dssp_key","containerName":"_pdbChain"}],"line":1009,"name":"_pdbChain","definition":"sub","containerName":"main::","range":{"start":{"line":1009,"character":0},"end":{"character":9999,"line":1013}}},{"containerName":"main::","definition":"sub","name":"_resAA","range":{"end":{"character":9999,"line":1031},"start":{"line":1027,"character":0}},"kind":12,"line":1027,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_resAA","line":1028,"kind":13},{"kind":13,"line":1029,"name":"$dssp_key","definition":"my","containerName":"_resAA","localvar":"my"},{"kind":13,"line":1030,"containerName":"_resAA","name":"$self"},{"line":1030,"kind":13,"containerName":"_resAA","name":"$dssp_key"}]},{"kind":12,"children":[{"line":1050,"kind":13,"localvar":"my","containerName":"_pdbNum","name":"$self","definition":"my"},{"localvar":"my","containerName":"_pdbNum","name":"$dssp_key","definition":"my","line":1051,"kind":13},{"line":1052,"kind":13,"name":"$self","containerName":"_pdbNum"},{"containerName":"_pdbNum","name":"$dssp_key","kind":13,"line":1052}],"line":1049,"definition":"sub","name":"_pdbNum","containerName":"main::","range":{"end":{"line":1053,"character":9999},"start":{"line":1049,"character":0}}},{"children":[{"kind":13,"line":1068,"containerName":"_pdbInsCo","name":"$self","definition":"my","localvar":"my"},{"containerName":"_pdbInsCo","definition":"my","name":"$dssp_key","localvar":"my","kind":13,"line":1069},{"kind":13,"line":1070,"containerName":"_pdbInsCo","name":"$self"},{"kind":13,"line":1070,"containerName":"_pdbInsCo","name":"$dssp_key"}],"line":1067,"kind":12,"range":{"end":{"line":1071,"character":9999},"start":{"line":1067,"character":0}},"definition":"sub","name":"_pdbInsCo","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"_toPdbId","range":{"end":{"character":9999,"line":1093},"start":{"line":1085,"character":0}},"kind":12,"line":1085,"children":[{"localvar":"my","containerName":"_toPdbId","name":"$self","definition":"my","line":1086,"kind":13},{"line":1087,"kind":13,"localvar":"my","definition":"my","name":"$dssp_key","containerName":"_toPdbId"},{"localvar":"my","containerName":"_toPdbId","name":"$pdbId","definition":"my","line":1088,"kind":13},{"name":"$self","containerName":"_toPdbId","kind":13,"line":1088},{"line":1088,"kind":12,"name":"_pdbNum","containerName":"_toPdbId"},{"name":"$dssp_key","containerName":"_toPdbId","line":1088,"kind":13},{"containerName":"_toPdbId","name":"$self","line":1089,"kind":13},{"kind":12,"line":1089,"containerName":"_toPdbId","name":"_pdbInsCo"},{"line":1089,"kind":13,"containerName":"_toPdbId","name":"$dssp_key"},{"containerName":"_toPdbId","definition":"my","name":"$chain","localvar":"my","kind":13,"line":1090},{"name":"$self","containerName":"_toPdbId","kind":13,"line":1090},{"containerName":"_toPdbId","name":"_pdbChain","kind":12,"line":1090},{"name":"$dssp_key","containerName":"_toPdbId","kind":13,"line":1090},{"containerName":"_toPdbId","name":"$pdbId","line":1091,"kind":13},{"name":"$chain","containerName":"_toPdbId","line":1091,"kind":13},{"kind":13,"line":1092,"containerName":"_toPdbId","name":"$pdbId"}]},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"_contSegs","localvar":"my","kind":13,"line":1114},{"name":"$self","containerName":"_contSegs","line":1115,"kind":13},{"line":1116,"kind":13,"name":"$self","containerName":"_contSegs"},{"kind":13,"line":1120,"containerName":"_contSegs","name":"$cur_chain","definition":"my","localvar":"my"},{"line":1120,"kind":13,"containerName":"_contSegs","name":"$i"},{"name":"$beg","containerName":"_contSegs","kind":13,"line":1120},{"line":1121,"kind":13,"localvar":"my","definition":"my","name":"@contSegs","containerName":"_contSegs"},{"line":1123,"kind":13,"name":"$cur_chain","containerName":"_contSegs"},{"kind":13,"line":1123,"name":"$self","containerName":"_contSegs"},{"line":1123,"kind":12,"containerName":"_contSegs","name":"_pdbChain"},{"containerName":"_contSegs","name":"$beg","kind":13,"line":1124},{"name":"$i","containerName":"_contSegs","line":1126,"kind":13},{"name":"$i","containerName":"_contSegs","kind":13,"line":1126},{"line":1126,"kind":13,"name":"$self","containerName":"_contSegs"},{"containerName":"_contSegs","name":"_numResLines","line":1126,"kind":12},{"name":"$i","containerName":"_contSegs","kind":13,"line":1126},{"kind":13,"line":1127,"name":"$self","containerName":"_contSegs"},{"line":1127,"kind":13,"containerName":"_contSegs","name":"$i"},{"name":"@contSegs","containerName":"_contSegs","line":1128,"kind":13},{"kind":13,"line":1128,"containerName":"_contSegs","name":"$beg"},{"kind":13,"line":1128,"name":"$i","containerName":"_contSegs"},{"containerName":"_contSegs","name":"$cur_chain","kind":13,"line":1128},{"kind":13,"line":1129,"containerName":"_contSegs","name":"$beg"},{"kind":13,"line":1129,"name":"$i","containerName":"_contSegs"},{"containerName":"_contSegs","name":"$cur_chain","line":1130,"kind":13},{"line":1130,"kind":13,"containerName":"_contSegs","name":"$self"},{"name":"_pdbChain","containerName":"_contSegs","kind":12,"line":1130},{"line":1130,"kind":13,"name":"$i","containerName":"_contSegs"},{"line":1134,"kind":13,"name":"@contSegs","containerName":"_contSegs"},{"kind":13,"line":1134,"containerName":"_contSegs","name":"$beg"},{"kind":13,"line":1134,"containerName":"_contSegs","name":"$i"},{"containerName":"_contSegs","name":"$cur_chain","line":1134,"kind":13},{"containerName":"_contSegs","name":"$self","line":1136,"kind":13},{"name":"@contSegs","containerName":"_contSegs","kind":13,"line":1136},{"kind":13,"line":1137,"name":"$self","containerName":"_contSegs"}],"line":1113,"definition":"sub","name":"_contSegs","containerName":"main::","range":{"end":{"line":1139,"character":9999},"start":{"line":1113,"character":0}}},{"name":"_numResLines","definition":"sub","containerName":"main::","range":{"end":{"line":1159,"character":9999},"start":{"line":1157,"character":0}},"kind":12,"children":[{"containerName":"_numResLines","name":"$self","definition":"my","localvar":"my","kind":13,"line":1158},{"kind":13,"line":1159,"containerName":"_numResLines","name":"$self"}],"line":1157},{"kind":12,"line":1182,"children":[{"containerName":"_toDsspKey","definition":"my","name":"$self","localvar":"my","kind":13,"line":1186},{"line":1187,"kind":13,"localvar":"my","containerName":"_toDsspKey","name":"$arg_str","definition":"my"},{"line":1189,"kind":13,"localvar":"my","name":"$key_num","definition":"my","containerName":"_toDsspKey"},{"kind":13,"line":1189,"containerName":"_toDsspKey","name":"$chain_id"},{"name":"$ins_code","containerName":"_toDsspKey","kind":13,"line":1189},{"containerName":"_toDsspKey","name":"$key_num","line":1193,"kind":13},{"line":1195,"kind":13,"containerName":"_toDsspKey","name":"$ins_code"},{"kind":13,"line":1196,"containerName":"_toDsspKey","name":"$chain_id"},{"kind":13,"line":1199,"name":"$chain_id","containerName":"_toDsspKey"},{"line":1203,"kind":13,"containerName":"_toDsspKey","name":"$arg_str"},{"containerName":"_toDsspKey","name":"$arg_str","line":1204,"kind":13},{"line":1206,"kind":13,"containerName":"_toDsspKey","name":"$chain_id"},{"line":1206,"kind":13,"name":"$arg_str","containerName":"_toDsspKey"},{"containerName":"_toDsspKey","name":"$arg_str","kind":13,"line":1207},{"line":1209,"kind":13,"name":"$arg_str","containerName":"_toDsspKey"},{"containerName":"_toDsspKey","name":"$ins_code","kind":13,"line":1211},{"containerName":"_toDsspKey","name":"$arg_str","kind":13,"line":1211},{"containerName":"_toDsspKey","name":"$arg_str","kind":13,"line":1212},{"line":1215,"kind":13,"containerName":"_toDsspKey","name":"$key_num"},{"containerName":"_toDsspKey","name":"$arg_str","kind":13,"line":1215},{"containerName":"_toDsspKey","definition":"my","name":"$i","localvar":"my","kind":13,"line":1220},{"name":"$i","containerName":"_toDsspKey","kind":13,"line":1220},{"line":1220,"kind":13,"containerName":"_toDsspKey","name":"$self"},{"kind":12,"line":1220,"containerName":"_toDsspKey","name":"_numResLines"},{"line":1220,"kind":13,"containerName":"_toDsspKey","name":"$i"},{"containerName":"_toDsspKey","name":"$self","kind":13,"line":1221},{"name":"$i","containerName":"_toDsspKey","kind":13,"line":1221},{"containerName":"_toDsspKey","name":"$self","line":1222,"kind":13},{"kind":13,"line":1222,"name":"$i","containerName":"_toDsspKey"},{"kind":13,"line":1224,"containerName":"_toDsspKey","name":"$key_num"},{"containerName":"_toDsspKey","name":"$self","line":1224,"kind":13},{"name":"$i","containerName":"_toDsspKey","kind":13,"line":1224},{"kind":13,"line":1225,"name":"$chain_id","containerName":"_toDsspKey"},{"name":"$chain_id","containerName":"_toDsspKey","kind":13,"line":1226},{"line":1226,"kind":13,"name":"$self","containerName":"_toDsspKey"},{"line":1226,"kind":13,"containerName":"_toDsspKey","name":"$i"},{"line":1228,"kind":13,"containerName":"_toDsspKey","name":"$ins_code"},{"line":1229,"kind":13,"name":"$ins_code","containerName":"_toDsspKey"},{"line":1229,"kind":13,"containerName":"_toDsspKey","name":"$self"},{"containerName":"_toDsspKey","name":"$i","line":1229,"kind":13},{"name":"$i","containerName":"_toDsspKey","kind":13,"line":1231},{"containerName":"_toDsspKey","name":"$i","kind":13,"line":1235},{"name":"$i","containerName":"_toDsspKey","line":1240,"kind":13},{"kind":13,"line":1245,"name":"$self","containerName":"_toDsspKey"},{"name":"throw","containerName":"_toDsspKey","kind":12,"line":1245}],"containerName":"main::","definition":"sub","name":"_toDsspKey","range":{"start":{"character":0,"line":1182},"end":{"character":9999,"line":1246}}},{"range":{"end":{"line":1369,"character":9999},"start":{"character":0,"line":1260}},"name":"_parse","definition":"sub","containerName":"main::","children":[{"line":1261,"kind":13,"localvar":"my","containerName":"_parse","definition":"my","name":"$self"},{"containerName":"_parse","name":"$file","definition":"my","localvar":"my","kind":13,"line":1262},{"localvar":"my","containerName":"_parse","definition":"my","name":"$cur","line":1263,"kind":13},{"name":"$current_chain","definition":"my","containerName":"_parse","localvar":"my","kind":13,"line":1264},{"kind":13,"line":1265,"containerName":"_parse","definition":"my","name":"@elements","localvar":"my"},{"containerName":"_parse","name":"@hbond","kind":13,"line":1265},{"localvar":"my","name":"%head","definition":"my","containerName":"_parse","line":1266,"kind":13},{"kind":13,"line":1266,"containerName":"_parse","name":"%his"},{"name":"$element","definition":"my","containerName":"_parse","localvar":"my","kind":13,"line":1267},{"kind":13,"line":1268,"definition":"my","name":"$res_num","containerName":"_parse","localvar":"my"},{"line":1270,"kind":13,"name":"$cur","containerName":"_parse"},{"kind":13,"line":1270,"name":"$file","containerName":"_parse"},{"kind":13,"line":1271,"containerName":"_parse","name":"$cur"},{"line":1272,"kind":13,"containerName":"_parse","name":"$self"},{"kind":12,"line":1272,"name":"throw","containerName":"_parse"},{"containerName":"_parse","name":"$cur","kind":13,"line":1277},{"line":1277,"kind":13,"name":"$file","containerName":"_parse"},{"line":1278,"kind":13,"containerName":"_parse","name":"$element"},{"kind":13,"line":1278,"name":"$cur","containerName":"_parse"},{"containerName":"_parse","name":"$head","line":1279,"kind":13},{"name":"$element","containerName":"_parse","line":1279,"kind":13},{"name":"$cur","containerName":"_parse","line":1281,"kind":13},{"line":1281,"kind":13,"name":"$file","containerName":"_parse"},{"line":1283,"kind":13,"name":"$cur","containerName":"_parse"},{"kind":13,"line":1284,"name":"@elements","containerName":"_parse"},{"kind":13,"line":1284,"containerName":"_parse","name":"$cur"},{"name":"@elements","containerName":"_parse","kind":13,"line":1285},{"containerName":"_parse","name":"$head","kind":13,"line":1286},{"containerName":"_parse","name":"@elements","kind":13,"line":1286},{"containerName":"_parse","name":"$head","kind":13,"line":1287},{"line":1287,"kind":13,"name":"@elements","containerName":"_parse"},{"name":"@elements","containerName":"_parse","line":1290,"kind":13},{"kind":13,"line":1291,"name":"$element","containerName":"_parse"},{"line":1291,"kind":13,"containerName":"_parse","name":"@elements"},{"name":"@elements","containerName":"_parse","kind":13,"line":1292},{"name":"$element","containerName":"_parse","line":1293,"kind":13},{"containerName":"_parse","name":"$element","line":1293,"kind":13},{"name":"@elements","containerName":"_parse","line":1293,"kind":13},{"name":"$head","containerName":"_parse","kind":13,"line":1295},{"containerName":"_parse","name":"$element","line":1295,"kind":13},{"containerName":"_parse","name":"$cur","line":1297,"kind":13},{"containerName":"_parse","name":"$file","line":1297,"kind":13},{"name":"$cur","containerName":"_parse","kind":13,"line":1301},{"kind":13,"line":1302,"containerName":"_parse","name":"$element"},{"name":"$cur","containerName":"_parse","line":1302,"kind":13},{"line":1303,"kind":13,"containerName":"_parse","name":"$head"},{"containerName":"_parse","name":"$element","kind":13,"line":1303},{"line":1305,"kind":13,"containerName":"_parse","name":"$cur"},{"name":"$file","containerName":"_parse","kind":13,"line":1305},{"name":"$cur","containerName":"_parse","kind":13,"line":1309},{"line":1310,"kind":13,"name":"$element","containerName":"_parse"},{"name":"$cur","containerName":"_parse","line":1310,"kind":13},{"kind":13,"line":1311,"containerName":"_parse","name":"$head"},{"line":1311,"kind":13,"name":"$element","containerName":"_parse"},{"kind":13,"line":1313,"containerName":"_parse","name":"$cur"},{"containerName":"_parse","name":"$file","kind":13,"line":1313},{"line":1316,"kind":13,"name":"$cur","containerName":"_parse"},{"name":"$element","containerName":"_parse","line":1317,"kind":13},{"line":1317,"kind":13,"containerName":"_parse","name":"$cur"},{"line":1318,"kind":13,"name":"$head","containerName":"_parse"},{"name":"$element","containerName":"_parse","line":1318,"kind":13},{"kind":13,"line":1320,"containerName":"_parse","name":"$cur"},{"kind":13,"line":1320,"name":"$file","containerName":"_parse"},{"containerName":"_parse","name":"$cur","kind":13,"line":1324},{"line":1325,"kind":13,"name":"$element","containerName":"_parse"},{"name":"$cur","containerName":"_parse","kind":13,"line":1325},{"line":1326,"kind":13,"name":"$head","containerName":"_parse"},{"name":"$element","containerName":"_parse","line":1326,"kind":13},{"containerName":"_parse","name":"$cur","kind":13,"line":1328},{"containerName":"_parse","name":"$file","kind":13,"line":1328},{"name":"@elements","containerName":"_parse","line":1332,"kind":13},{"containerName":"_parse","name":"$cur","kind":13,"line":1332},{"name":"@elements","containerName":"_parse","kind":13,"line":1333},{"line":1334,"kind":13,"containerName":"_parse","name":"$head"},{"kind":13,"line":1334,"containerName":"_parse","name":"@elements"},{"line":1335,"kind":13,"containerName":"_parse","name":"$head"},{"name":"@elements","containerName":"_parse","line":1335,"kind":13},{"containerName":"_parse","name":"$head","kind":13,"line":1336},{"kind":13,"line":1336,"containerName":"_parse","name":"@elements"},{"kind":13,"line":1337,"name":"$head","containerName":"_parse"},{"containerName":"_parse","name":"@elements","line":1337,"kind":13},{"kind":13,"line":1338,"name":"$head","containerName":"_parse"},{"kind":13,"line":1338,"containerName":"_parse","name":"@elements"},{"containerName":"_parse","name":"$cur","line":1340,"kind":13},{"kind":13,"line":1340,"name":"$file","containerName":"_parse"},{"containerName":"_parse","name":"$element","line":1341,"kind":13},{"kind":13,"line":1341,"containerName":"_parse","name":"$cur"},{"line":1342,"kind":13,"name":"$head","containerName":"_parse"},{"containerName":"_parse","name":"$element","kind":13,"line":1342},{"containerName":"_parse","name":"$self","kind":13,"line":1343},{"containerName":"_parse","name":"%head","kind":13,"line":1343},{"line":1345,"kind":13,"localvar":"my","containerName":"_parse","definition":"my","name":"$i"},{"line":1345,"kind":13,"containerName":"_parse","name":"$i"},{"name":"$i","containerName":"_parse","line":1345,"kind":13},{"line":1346,"kind":13,"name":"$cur","containerName":"_parse"},{"kind":13,"line":1346,"containerName":"_parse","name":"$file"},{"name":"$element","containerName":"_parse","kind":13,"line":1347},{"line":1348,"kind":13,"name":"$cur","containerName":"_parse"},{"line":1349,"kind":13,"name":"@hbond","containerName":"_parse"},{"kind":13,"line":1349,"containerName":"_parse","name":"$element"},{"kind":13,"line":1352,"name":"$self","containerName":"_parse"},{"line":1352,"kind":13,"name":"@hbond","containerName":"_parse"},{"kind":13,"line":1354,"containerName":"_parse","definition":"my","name":"$histogram_finished","localvar":"my"},{"kind":13,"line":1355,"containerName":"_parse","name":"$histogram_finished"},{"line":1355,"kind":13,"containerName":"_parse","name":"$cur"},{"line":1355,"kind":13,"containerName":"_parse","name":"$file"},{"containerName":"_parse","name":"$cur","line":1356,"kind":13},{"line":1357,"kind":13,"containerName":"_parse","name":"$histogram_finished"},{"containerName":"_parse","name":"$cur","line":1361,"kind":13},{"kind":13,"line":1361,"name":"$file","containerName":"_parse"},{"containerName":"_parse","name":"$cur","line":1362,"kind":13},{"kind":13,"line":1365,"name":"$res_num","containerName":"_parse"},{"kind":13,"line":1365,"containerName":"_parse","name":"$cur"},{"containerName":"_parse","name":"$res_num","kind":13,"line":1366},{"line":1367,"kind":13,"name":"$self","containerName":"_parse"},{"kind":13,"line":1367,"containerName":"_parse","name":"$res_num"},{"kind":13,"line":1367,"containerName":"_parse","name":"$cur"}],"line":1260,"kind":12},{"name":"_parseResLine","line":1367,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"_parseResLine()","parameters":[],"documentation":"1;\n# $Header$\n#\n# bioperl module for Bio::Structure::SecStr::DSSP::Res.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ed Green <ed@compbio.berkeley.edu>\n#\n# Copyright Univ. of California\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::SecStr::DSSP::Res - Module for parsing/accessing dssp output\n\n=head1 SYNOPSIS\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-file'=>'filename.dssp');\n\n  # or\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-fh'=>\\*STDOUT);\n\n  # get DSSP defined Secondary Structure for residue 20\n  $sec_str = $dssp_obj->resSecStr( 20 );\n\n  # get dssp defined sec. structure summary for PDB residue  # 10 of chain A\n\n  $sec_str = $dssp_obj->resSecStrSum( '10:A' );\n\n=head1 DESCRIPTION\n\nDSSP::Res is a module for objectifying DSSP output.  Methods are then\navailable for extracting all the information within the output file\nand convenient subsets of it.\nThe principal purpose of DSSP is to determine secondary structural\nelements of a given structure.\n\n    ( Dictionary of protein secondary structure: pattern recognition\n      of hydrogen-bonded and geometrical features.\n      Biopolymers. 1983 Dec;22(12):2577-637. )\n\nThe DSSP program is available from:\n  http://www.cmbi.kun.nl/swift/dssp\n\nThis information is available on a per residue basis ( see resSecStr\nand resSecStrSum methods ) or on a per chain basis ( see secBounds\nmethod ).\n\nresSecStr() & secBounds() return one of the following:\n    'H' = alpha helix\n    'B' = residue in isolated beta-bridge\n    'E' = extended strand, participates in beta ladder\n    'G' = 3-helix (3/10 helix)\n    'I' = 5 helix (pi helix)\n    'T' = hydrogen bonded turn\n    'S' = bend\n    ''  = no assignment\n\nA more general classification is returned using the resSecStrSum()\nmethod.  The purpose of this is to have a method for DSSP and STRIDE\nderived output whose range is the same.\nIts output is one of the following:\n\n    'H' = helix         ( => 'H', 'G', or 'I' from above )\n    'B' = beta          ( => 'B' or 'E' from above )\n    'T' = turn          ( => 'T' or 'S' from above )\n    ' ' = no assignment ( => ' ' from above )\n\nThe methods are roughly divided into 3 sections:\n1.  Global features of this structure (PDB ID, total surface area,\n    etc.).  These methods do not require an argument.\n2.  Residue specific features ( amino acid, secondary structure,\n    solvent exposed surface area, etc. ).  These methods do require an\n    arguement.  The argument is supposed to uniquely identify a\n    residue described within the structure.  It can be of any of the\n    following forms:\n    ('#A:B') or ( #, 'A', 'B' )\n      || |\n      || - Chain ID (blank for single chain)\n      |--- Insertion code for this residue.  Blank for most residues.\n      |--- Numeric portion of residue ID.\n\n    (#)\n     |\n     --- Numeric portion of residue ID.  If there is only one chain and\n         it has no ID AND there is no residue with an insertion code at this\n         number, then this can uniquely specify a residue.\n\n    ('#:C') or ( #, 'C' )\n      | |\n      | -Chain ID\n      ---Numeric portion of residue ID.\n\n  If a residue is incompletely specified then the first residue that\n  fits the arguments is returned.  For example, if 19 is the argument\n  and there are three chains, A, B, and C with a residue whose number\n  is 19, then 19:A will be returned (assuming its listed first).\n\n  Since neither DSSP nor STRIDE correctly handle alt-loc codes, they\n  are not supported by these modules.\n\n3.  Value-added methods.  Return values are not verbatem strings\n    parsed from DSSP or STRIDE output.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ed Green\n\nEmail ed@compbio.berkeley.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each method.\nInternal methods are preceded with a _\n\n\npackage Bio::Structure::SecStr::DSSP::Res;\nuse strict;\nuse Bio::Root::IO;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n# Would be a class variable if Perl had them\n\n               #attribute        begin col        # columns\nour %lookUp = ( 'pdb_resnum'     => [  5,           5 ],\n\t\t'insertionco'    => [  10,          1 ],\n\t\t'pdb_chain'      => [  11,          1 ],\n\t\t\n\t\t'amino_acid'     => [  13,          1 ],\n\t\t'term_sig'       => [  14,          1 ],\n\t\t\n\t\t'ss_summary'     => [  16,          1 ],\n\t\t'3tph'           => [  18,          1 ],\n\t\t'4tph'           => [  19,          1 ],\n\t\t'5tph'           => [  20,          1 ],\n\t\t'geo_bend'       => [  21,          1 ],\n\t\t'chirality'      => [  22,          1 ],\n\t\t'beta_br1la'     => [  23,          1 ],\n\t\t'beta_br2la'     => [  24,          1 ],\n\n\t\t'bb_part1nu'     => [  25,          4 ],\n\t\t'bb_part2nu'     => [  29,          4 ],\n\t\t'betash_lab'     => [  33,          1 ],\n\t\t\n\t\t'solv_acces'     => [  34,          4 ],\n\t\t\n\t\t'hb1_nh_o_p'     => [  39,          6 ],\n\t\t'hb1_nh_o_e'     => [  46,          4 ],\n\t\t\n\t\t'hb1_o_hn_p'     => [  50,          6 ],\n\t\t'hb1_o_hn_e'     => [  57,          4 ],\n\t\t\n\t\t'hb2_nh_o_p'     => [  61,          6 ],\n\t\t'hb2_nh_o_e'     => [  68,          4 ],\n\t\t\n\t\t'hb2_o_hn_p'     => [  72,          6 ],\n\t\t'hb2_o_hn_e'     => [  79,          4 ],\n\t\t\n\t\t'tco'            => [  85,          6 ],\n\t\t\n\t\t'kappa'          => [  91,          6 ],\n\t\t\n\t\t'alpha'          => [  97,          6 ],\n\t\n\t\t'phi'            => [ 103,          6 ],\n\n\t\t'psi'            => [ 109,          6 ],\n\t\t\n\t\t'x_ca'           => [ 115,          7 ],\n\t\t\n\t\t'y_ca'           => [ 122,          7 ],\n\t\t\n\t\t'z_ca'           => [ 129,          7 ] );\n\n\n=head1 CONSTRUCTOR\n\n\n\n\n=head2 new\n\n Title         : new\n Usage         : makes new object of this class\n Function      : Constructor\n Example       : $dssp_obj = Bio::DSSP:Res->new( filename or FILEHANDLE )\n Returns       : object (ref)\n Args          : filename ( must be proper DSSP output file )\n\n\nsub new {\n    my ( $class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n    my $io = Bio::Root::IO->new( @args );\n    $self->_parse( $io->_fh() );\n    $io->close();\n    return $self;\n}\n\n=head1 ACCESSORS\n\n\n\n# GLOBAL FEATURES / INFO / STATS\n\n=head2 totSurfArea\n\n Title         : totSurfArea\n Usage         : returns total accessible surface area in square Ang.\n Function      :\n Example       : $surArea = $dssp_obj->totSurfArea();\n Returns       : scalar\n Args          : none\n\n\nsub totSurfArea {\n    my $self = shift;\n    return $self->{ 'Head' }->{ 'ProAccSurf' };\n}\n\n=head2 numResidues\n\n Title         : numResidues\n Usage         : returns the total number of residues in all chains or\n                 just the specified chain if a chain is specified\n Function      :\n Example       : $num_res = $dssp_obj->numResidues();\n Returns       : scalar int\n Args          : none\n\n\n\nsub numResidues {\n    my $self = shift;\n    my $chain = shift;\n    if ( !( $chain ) ) {\n\treturn $self->{'Head'}->{'TotNumRes'};\n    }\n    else {\n\tmy ( $num_res,\n\t     $cont_seg );\n\tmy $cont_seg_pnt = $self->_contSegs();\n\tforeach $cont_seg ( @{ $cont_seg_pnt } ) {\n\t    if ( $chain eq $cont_seg->[ 2 ] ) {\n\t\t# this segment is part of the chain we want\n\t\t$num_res += ( $self->_toDsspKey( $cont_seg->[ 1 ] )\n\t\t\t      - $self->_toDsspKey( $cont_seg->[ 0 ] )\n\t\t\t      + 1 ); # this works because we know the\n\t\t\t\t     # the region between the start\n\t\t\t\t     # and end of a dssp key is\n\t\t\t\t     # continuous\n\t    }\n\t}\n\treturn $num_res;\n    }\n}\n\n#  STRAIGHT FROM PDB ENTRY\n\n=head2 pdbID\n\n Title         : pdbID\n Usage         : returns pdb identifier ( 1FJM, e.g.)\n Function      :\n Example       : $pdb_id = $dssp_obj->pdbID();\n Returns       : scalar string\n Args          : none\n\n\n\nsub pdbID {\n    my $self = shift;\n    return $self->{'Head'}->{'PDB'};\n}\n\n=head2 pdbAuthor\n\n Title         : pdbAuthor\n Usage         : returns author field\n Function      :\n Example       : $auth = $dssp_obj->pdbAuthor()\n Returns       : scalar string\n Args          : none\n\n\n\nsub pdbAuthor {\n    my $self = shift;\n    return $self->{'Head'}->{'AUTHOR'};\n}\n\n=head2 pdbCompound\n\n Title         : pdbCompound\n Usage         : returns pdbCompound given in PDB file\n Function      :\n Example       : $cmpd = $dssp_obj->pdbCompound();\n Returns       : scalar string\n Args          : none\n\n\n\nsub pdbCompound {\n    my $self = shift;\n    return $self->{'Head'}->{'COMPND'};\n}\n\n=head2 pdbDate\n\n Title         : pdbDate\n Usage         : returns date given in PDB file\n Function      :\n Example       : $pdb_date = $dssp_obj->pdbDate();\n Returns       : scalar\n Args          : none\n\n\n\nsub pdbDate {\n    my $self = shift;\n    return $self->{'Head'}->{'DATE'};\n}\n\n=head2 pdbHeader\n\n Title         : pdbHeader\n Usage         : returns header info from PDB file\n Function      :\n Example       : $header = $dssp_obj->pdbHeader();\n Returns       : scalar\n Args          : none\n\n\n\nsub pdbHeader {\n    my $self = shift;\n    return $self->{'Head'}->{'HEADER'};\n}\n\n=head2 pdbSource\n\n Title         : pdbSource\n Usage         : returns pdbSource information from PDBSOURCE line\n Function      :\n Example       : $pdbSource = $dssp_obj->pdbSource();\n Returns       : scalar\n Args          : none\n\n\n\nsub pdbSource {\n    my $self = shift;\n    return $self->{'Head'}->{'SOURCE'};\n}\n\n\n# RESIDUE SPECIFIC ACCESSORS\n\n=head2 resAA\n\n Title         : resAA\n Usage         : fetches the 1 char amino acid code, given an id\n Function      :\n Example       : $aa = $dssp_obj->resAA( '20:A' ); # pdb id as arg\n Returns       : 1 character scalar string\n Args          : RESIDUE_ID\n\n\n\nsub resAA {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'amino_acid' };\n}\n\n=head2 resPhi\n\n Title         : resPhi\n Usage         : returns phi angle of a single residue\n Function      : accessor\n Example       : $phi = $dssp_obj->resPhi( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resPhi {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'phi' };\n}\n\n=head2 resPsi\n\n Title         : resPsi\n Usage         : returns psi angle of a single residue\n Function      : accessor\n Example       : $psi = $dssp_obj->resPsi( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resPsi {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'psi' };\n}\n\n=head2 resSolvAcc\n\n Title         : resSolvAcc\n Usage         : returns solvent exposed area of this residue in\n                 square Angstroms\n Function      :\n Example       : $solv_acc = $dssp_obj->resSolvAcc( RESIDUE_ID );\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resSolvAcc {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'solv_acces' };\n}\n\n=head2 resSurfArea\n\n Title         : resSurfArea\n Usage         : returns solvent exposed area of this residue in\n                 square Angstroms\n Function      :\n Example       : $solv_acc = $dssp_obj->resSurfArea( RESIDUE_ID );\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resSurfArea {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'solv_acces' };\n}\n\n=head2 resSecStr\n\n Title         : resSecStr\n Usage         : $ss = $dssp_obj->resSecStr( RESIDUE_ID );\n Function      : returns the DSSP secondary structural designation of this residue\n Example       :\n Returns       : a character ( 'B', 'E', 'G', 'H', 'I', 'S', 'T', or ' ' )\n Args          : RESIDUE_ID\n NOTE          : The range of this method differs from that of the\n    resSecStr method in the STRIDE SecStr parser.  That is because of the\n    slightly different format for STRIDE and DSSP output.  The resSecStrSum\n    method exists to map these different ranges onto an identical range.\n\n\nsub resSecStr {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    my $ss_char = $self->{ 'Res' }->[ $dssp_key ]->{ 'ss_summary' };\n    return $ss_char if $ss_char;\n    return ' ';\n}\n\n\n=head2 resSecStrSum\n\n Title         : resSecStrSum\n Usage         : $ss = $dssp_obj->resSecStrSum( $id );\n Function      : returns what secondary structure group this residue belongs\n                 to.  One of:  'H': helix ( H, G, or I )\n                               'B': beta  ( B or E )\n                               'T': turn  ( T or S )\n                               ' ': none  ( ' ' )\n                 This method is similar to resSecStr, but the information\n                 it returns is less specific.\n Example       :\n Returns       : a character ( 'H', 'B', 'T', or ' ' )\n Args          : dssp residue number of pdb residue identifier\n\n\n\nsub resSecStrSum {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    my $ss_char = $self->{ 'Res' }->[ $dssp_key ]->{ 'ss_summary' };\n    if ( $ss_char eq 'H' || $ss_char eq 'G' || $ss_char eq 'I' ) {\n\treturn 'H';\n    }\n    if ( $ss_char eq ' ' || !( $ss_char ) ) {\n\treturn ' ';\n    }\n    if ( $ss_char eq 'B' || $ss_char eq 'E' ) {\n\treturn 'B';\n    }\n    else {\n\treturn 'T';\n    }\n}\n\n# DSSP SPECIFIC\n\n=head2 hBonds\n\n Title         : hBonds\n Usage         : returns number of 14 different types of H Bonds\n Function      :\n Example       : $hb = $dssp_obj->hBonds\n Returns       : pointer to 14 element array of ints\n Args          : none\n NOTE          : The different type of H-Bonds reported are, in order:\n    TYPE O(I)-->H-N(J)\n    IN PARALLEL BRIDGES\n    IN ANTIPARALLEL BRIDGES\n    TYPE O(I)-->H-N(I-5)\n    TYPE O(I)-->H-N(I-4)\n    TYPE O(I)-->H-N(I-3)\n    TYPE O(I)-->H-N(I-2)\n    TYPE O(I)-->H-N(I-1)\n    TYPE O(I)-->H-N(I+0)\n    TYPE O(I)-->H-N(I+1)\n    TYPE O(I)-->H-N(I+2)\n    TYPE O(I)-->H-N(I+3)\n    TYPE O(I)-->H-N(I+4)\n    TYPE O(I)-->H-N(I+5)\n\n\nsub hBonds {\n    my $self = shift;\n    return $self->{ 'HBond'};\n}\n\n=head2 numSSBr\n\n Title         : numSSBr\n Usage         : returns info about number of SS-bridges\n Function      :\n Example       : @SS_br = $dssp_obj->numSSbr();\n Returns       : 3 element scalar int array\n Args          : none\n\n\n\nsub numSSBr {\n    my $self = shift;\n    return ( $self->{'Head'}->{'TotSSBr'},\n\t     $self->{'Head'}->{'TotIaSSBr'},\n\t     $self->{'Head'}->{'TotIeSSBr'} );\n}\n\n=head2 resHB_O_HN\n\n Title         : resHB_O_HN\n Usage         : returns pointer to a 4 element array\n                 consisting of: relative position of binding\n                 partner #1, energy of that bond (kcal/mol),\n                 relative positionof binding partner #2,\n                 energy of that bond (kcal/mol).  If the bond\n                 is not bifurcated, the second bond is reported\n                 as 0, 0.0\n Function      : accessor\n Example       : $oBonds_ptr = $dssp_obj->resHB_O_HN( RESIDUE_ID )\n Returns       : pointer to 4 element array\n Args          : RESIDUE_ID\n\n\n\nsub resHB_O_HN {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return ( $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_o_hn_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_o_hn_e' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_o_hn_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_o_hn_e' } );\n}\n\n\n=head2 resHB_NH_O\n\n Title         : resHB_NH_O\n Usage         : returns pointer to a 4 element array\n                 consisting of: relative position of binding\n                 partner #1, energy of that bond (kcal/mol),\n                 relative positionof binding partner #2,\n                 energy of that bond (kcal/mol).  If the bond\n                 is not bifurcated, the second bond is reported\n                 as 0, 0.0\n Function      : accessor\n Example       : $nhBonds_ptr = $dssp_obj->resHB_NH_O( RESIDUE_ID )\n Returns       : pointer to 4 element array\n Args          : RESIDUE_ID\n\n\n\nsub resHB_NH_O {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return ( $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_nh_o_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_nh_o_e' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_nh_o_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_nh_o_e' } );\n}\n\n\n=head2 resTco\n\n Title         : resTco\n Usage         : returns tco angle around this residue\n Function      : accessor\n Example       : resTco = $dssp_obj->resTco( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resTco {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'tco' };\n}\n\n\n=head2 resKappa\n\n Title         : resKappa\n Usage         : returns kappa angle around this residue\n Function      : accessor\n Example       : $kappa = $dssp_obj->resKappa( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID ( dssp or PDB )\n\n\n\nsub resKappa {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'kappa' };\n}\n\n\n=head2 resAlpha\n\n Title         : resAlpha\n Usage         : returns alpha angle around this residue\n Function      : accessor\n Example       : $alpha = $dssp_obj->resAlpha( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID ( dssp or PDB )\n\n\n\nsub resAlpha {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'alpha' };\n}\n\n# VALUE ADDED METHODS (NOT JUST PARSE/REPORT)\n\n=head2 secBounds\n\n Title         : secBounds\n Usage         : gets residue ids of boundary residues in each\n                 contiguous secondary structural element of specified\n                 chain\n Function      : returns pointer to array of 3 element arrays.  First\n                 two elements are the PDB IDs of the start and end points,\n                 respectively and inclusively.  The last element is the\n                 DSSP secondary structural assignment code,\n                 i.e. one of : ('B', 'E', 'G', 'H', 'I', 'S', 'T', or ' ')\n Example       : $ss_elements_pts = $dssp_obj->secBounds( 'A' );\n Returns       : pointer to array of arrays\n Args          : chain id ( 'A', for example ).  No arg => no chain id\n\n\n\nsub secBounds {\n    my $self = shift;\n    my $chain = shift;\n    my %sec_bounds;\n\n    $chain = '-' if ( !( $chain ) || $chain eq ' ' || $chain eq '-' );\n\n    # if we've memoized this chain, use that\n    if ( $self->{ 'SecBounds' } ) {\n\t# check to make sure chain is valid\n\tif ( !( $self->{ 'SecBounds' }->{ $chain } ) ) {\n\t    $self->throw( \"No such chain: $chain\\n\" );\n\t}\n\treturn $self->{ 'SecBounds' }->{ $chain };\n    }\n\n    my ( $cur_element, $i, $cur_chain, $beg, );\n\n    #initialize\n    $cur_element = $self->{ 'Res' }->[ 1 ]->{ 'ss_summary' };\n    $beg = 1;\n\n    for ( $i = 2; $i <= $self->_numResLines() - 1; $i++ ) {\n\tif ( $self->{ 'Res' }->[ $i ]->{ 'amino_acid' } eq '!' ) {\n\t    # element is terminated by a chain discontinuity\n\t    push( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t\t  [ $self->_toPdbId( $beg ),\n\t\t    $self->_toPdbId( $i - 1 ),\n\t\t    $cur_element ] );\n\t    $i++;\n\t    $beg = $i;\n\t    $cur_element = $self->{ 'Res' }->[ $i ]->{ 'ss_summary' };\n\t}\n\t\n\telsif ( $self->{ 'Res' }->[ $i ]->{ 'ss_summary' } ne $cur_element ) {\n\t    # element is terminated by beginning of a new element\n\t    push( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t\t  [ $self->_toPdbId( $beg ),\n\t\t    $self->_toPdbId( $i - 1 ),\n\t\t    $cur_element ] );\n\t    $beg = $i;\n\t    $cur_element = $self->{ 'Res' }->[ $i ]->{ 'ss_summary' };\n\t}\n    }\n    #last residue\n    if ( $self->{ 'Res' }->[ $i ]->{ 'ss_summary' } eq $cur_element ) {\n\tpush( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t      [ $self->_toPdbId( $beg ),\n\t\t$self->_toPdbId( $i ),\n\t\t$cur_element ] );\n    }\n\n    else {\n\tpush( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t      [ $self->_toPdbId( $beg ),\n\t\t$self->_toPdbId( $i - 1 ),\n\t\t$cur_element ] );\n\tpush( @{ $sec_bounds{ $self->_pdbChain( $i ) } },\n\t      [ $self->_toPdbId( $i ),\n\t\t$self->_toPdbId( $i ),\n\t\t$self->{ 'Res' }->[ $i ]->{ 'ss_summary' } ] );\n    }\n\n    $self->{ 'SecBounds' } = \\%sec_bounds;\n\n    # check to make sure chain is valid\n    if ( !( $self->{ 'SecBounds' }->{ $chain } ) ) {\n\t$self->throw( \"No such chain: $chain\\n\" );\n    }\n\n    return $self->{ 'SecBounds' }->{ $chain };\n}\n\n\n\n=head2 chains\n\n Title         : chains\n Usage         : returns pointer to array of chain I.D.s (characters)\n Function      :\n Example       : $chains_pnt = $dssp_obj->chains();\n Returns       : array of characters, one of which may be ' '\n Args          : none\n\n\n\nsub chains {\n    my $self = shift;\n    my $cont_segs = $self->_contSegs();\n    my %chains;\n    my $seg;\n    foreach $seg ( @{ $cont_segs } ) {\n\t$chains{ $seg->[ 2 ] } = 1;\n    }\n    my @chains = keys( %chains );\n    return \\@chains;\n}\n\n\n=head2 residues\n\n    Title : residues\n    Usage : returns array of residue identifiers for all residues in\n    the output file, or in a specific chain\n    Function :\n    Example : @residues_ids = $dssp_obj->residues()\n    Returns : array of residue identifiers\n    Args : if none => returns residue ids of all residues of all\n    chains (in order); if chain id is given, returns just the residue\n    ids of residues in that chain\n\n\n\n# Can't use the standard interface for getting the amino acid,\n# pdb_resnum, etc. in this method because we don't *know* the residue\n# indentifiers - we are building a list of them.\nsub residues {\n    my $self  = shift;\n    my $chain = shift;\n    my @residues;\n    my $num_res = $self->_numResLines();\n    my $aa;\n    for ( my $i = 1; $i <= $num_res; $i++ ) {\n\t# find what character was in the slot for tha amino acid code,\n\t# if it's a '!' we know this is not a *real* amino acid, it's\n\t# a chain discontinuity marker \n\t$aa = $self->{ 'Res' }->[ $i ]->{ 'amino_acid' };\n\tif ( $aa ne '!' ) {\n\t    if ( !$chain ||\n\t\t $chain eq $self->{ 'Res' }->[ $i ]->{ 'pdb_chain' } ) {\n\t\tpush( @residues, \n\t\t      $self->{ 'Res' }->[ $i ]->{ 'pdb_resnum' }.\n\t\t      $self->{ 'Res' }->[ $i ]->{ 'insertionco' }.\n\t\t      \":\".\n\t\t      $self->{ 'Res' }->[ $i ]->{ 'pdb_chain' } );\n\t    }\n\t}\n    }\n    return @residues;\n}\n\n\n=head2 getSeq\n\n Title         : getSeq\n Usage         : returns a Bio::PrimarySeq object which represents a good\n                 guess at the sequence of the given chain\n Function      : For most chains of most entries, the sequence returned by\n                 this method will be very good.  However, it is inherently\n                 unsafe to rely on DSSP to extract sequence information about\n                 a PDB entry.  More reliable information can be obtained from\n                 the PDB entry itself.\n Example       : $pso = $dssp_obj->getSeq( 'A' );\n Returns       : (pointer to) a PrimarySeq object\n Args          : Chain identifier.  If none given, ' ' is assumed.  If no ' '\n                 chain, the first chain is used.\n\n\n\nsub getSeq {\n    my $self  = shift;\n    my $chain = shift;\n\n    my ( $pot_chain,\n\t $seq,\n\t $frag_num,\n\t $frag,\n\t $curPdbNum,\n\t $lastPdbNum,\n\t $gap_len,\n\t $i,\n\t $id,\n\t );\n    my @frags;\n\n    if ( !( $chain ) ) {\n\t$chain = ' ';\n    }\n\n    if ( $self->{ 'Seq' }->{ $chain } ) {\n\treturn $self->{ 'Seq' }->{ $chain };\n    }\n\n    my $contSegs_pnt = $self->_contSegs();\n\n    # load up specified chain\n    foreach $pot_chain ( @{ $contSegs_pnt } ) {\n\tif ( $pot_chain->[ 2 ] eq $chain ) {\n\t    push( @frags, $pot_chain );\n\t}\n    }\n    \n    # if that didn't work, just get the first one\n    if ( !( @frags ) ) {\n\t$chain = $contSegs_pnt->[ 0 ]->[ 2 ];\n\tforeach $pot_chain ( @{ $contSegs_pnt } ) {\n\t    if ( $pot_chain->[ 2 ] eq $chain ) {\n\t\tpush( @frags, $pot_chain );\n\t    }\n\t}\n    }\n\n    # now build the sequence string\n    $seq = \"\";\n    $frag_num = 0;\n    foreach $frag ( @frags ) {\n\t$frag_num++;\n\tif ( $frag_num > 1 ) {  # we need to put in some gap seq\n\t    $curPdbNum = $self->_pdbNum( $frag->[ 0 ] );\n\t    $gap_len = $curPdbNum - $lastPdbNum - 1;\n\t    if ( $gap_len > 0 ) {\n\t\t$seq .= 'u' x $gap_len;\n\t    }\n\t    else {\n\t\t$seq .= 'u';\n\t    }\n\t}\n\tfor ( $i = $frag->[ 0 ]; $i <= $frag->[ 1 ]; $i++ ) {\n\t    $seq .= $self->_resAA( $i );\n\t}\n\t$lastPdbNum = $self->_pdbNum( $i - 1 );\n    }\n\n\n\n    $id = $self->pdbID();\n    $id .= \":$chain\";\n\n    $self->{ 'Seq' }->{ $chain } =  Bio::PrimarySeq->new ( -seq => $seq,\n\t\t\t\t\t\t\t   -id  => $id,\n\t\t\t\t\t\t\t   -moltype => 'protein'\n\t\t\t\t\t\t\t   );\n    return $self->{ 'Seq' }->{ $chain };\n}\n\n=head1 INTERNAL METHODS\n\n\n\n=head2 _pdbChain\n\n Title         : _pdbChain\n Usage         : returns the pdb chain id of given residue\n Function      :\n Example       : $chain_id = $dssp_obj->pdbChain( DSSP_KEY );\n Returns       : scalar\n Args          : DSSP_KEY ( dssp or pdb )\n\n\n\nsub _pdbChain {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'pdb_chain' };\n}\n\n=head2 _resAA\n\n Title         : _resAA\n Usage         : fetches the 1 char amino acid code, given a dssp id\n Function      :\n Example       : $aa = $dssp_obj->_resAA( dssp_id );\n Returns       : 1 character scalar string\n Args          : dssp_id\n\n\n\nsub _resAA {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'amino_acid' };\n}\n\n\n=head2 _pdbNum\n\n Title        : _pdbNum\n Usage        : fetches the numeric portion of the identifier for a given\n                residue as reported by the pdb entry.  Note, this DOES NOT\n                uniquely specify a residue.  There may be an insertion code\n                and/or chain identifier differences.\n Function     :\n Example      : $pdbNum = $self->_pdbNum( DSSP_ID );\n Returns      : a scalar\n Args         : DSSP_ID\n\n\n\nsub _pdbNum {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'pdb_resnum' };\n}\n\n=head2 _pdbInsCo\n\n Title        : _pdbInsCo\n Usage        : fetches the Insertion Code for this residue, if it has one.\n Function     :\n Example      : $pdbNum = $self->_pdbInsCo( DSSP_ID );\n Returns      : a scalar\n Args         : DSSP_ID\n\n\n\nsub _pdbInsCo {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'insertionco' };\n}\n\n=head2 _toPdbId\n\n Title        : _toPdbId\n Usage        : Takes a dssp key and builds the corresponding\n                PDB identifier string\n Function     :\n Example      : $pdbId = $self->_toPdbId( DSSP_ID );\n Returns      : scalar\n Args         : DSSP_ID\n\n\nsub _toPdbId {\n    my $self = shift;\n    my $dssp_key = shift;\n    my $pdbId = ( $self->_pdbNum( $dssp_key ).\n\t\t  $self->_pdbInsCo( $dssp_key ) );\n    my $chain = $self->_pdbChain( $dssp_key );\n    $pdbId = \"$pdbId:$chain\" if $chain;\n    return $pdbId;\n}\n\n=head2 _contSegs\n\n Title         : _contSegs\n Usage         : find the endpoints of continuous regions of this structure\n Function      : returns pointer to array of 3 element array.\n                 Elements are the dssp keys of the start and end points of each\n                 continuous element and its PDB chain id (may be blank).\n                 Note that it is common to have several\n                 continuous elements with the same chain id.  This occurs\n                 when an internal region is disordered and no structural\n                 information is available.\n Example       : $cont_seg_ptr = $dssp_obj->_contSegs();\n Returns       : pointer to array of arrays\n Args          : none\n\n\n\nsub _contSegs {\n    my $self = shift;\n    if ( $self->{ 'contSegs' } ) {\n\treturn $self->{ 'contSegs' };\n    }\n    else {\n\t# first time, so make contSegs\n\tmy ( $cur_chain, $i, $beg );\n\tmy @contSegs;\n\t#initialize\n\t$cur_chain = $self->_pdbChain( 1 );\n\t$beg = 1;\n\t#internal residues\n\tfor ( $i = 2; $i <= $self->_numResLines() - 1; $i++ ) {\n\t    if ( $self->{ 'Res' }->[ $i ]->{ 'amino_acid' } eq '!' ) {\n\t\tpush( @contSegs, [ $beg, $i - 1, $cur_chain ] );\n\t\t$beg = $i + 1;\n\t\t$cur_chain = $self->_pdbChain( $i + 1 );\n\t    }\n\t}\n\t# last residue must be the end of a chain\n\tpush( @contSegs, [ $beg, $i, $cur_chain ] );\n\n\t$self->{ 'contSegs' } = \\@contSegs;\n\treturn $self->{ 'contSegs' };\n    }\n}\n\n=head2 _numResLines\n\n Title         : _numResLines\n Usage         : returns the total number of residue lines in this\n                 dssp file.\n                 This number is DIFFERENT than the number of residues in\n                 the pdb file because dssp has chain termination and chain\n                 discontinuity 'residues'.\n Function      :\n Example       : $num_res = $dssp_obj->_numResLines();\n Returns       : scalar int\n Args          : none\n\n\n\nsub _numResLines {\n    my $self = shift;\n    return ( $#{$self->{ 'Res' }} );\n}\n\n=head2 _toDsspKey\n\n Title         : _toDsspKey\n Usage         : returns the unique dssp integer key given a pdb residue id.\n                 All accessor methods require (internally)\n                 the dssp key.   This method is very useful in converting\n                 pdb keys to dssp keys so the accessors can accept pdb keys\n                 as argument.  PDB Residue IDs are inherently\n                 problematic since they have multiple parts of\n                 overlapping function and ill-defined or observed\n                 convention in form.  Input can be in any of the formats\n                 described in the DESCRIPTION section above.\n Function      :\n Example       : $dssp_id = $dssp_obj->_pdbKeyToDsspKey( '10B:A' )\n Returns       : scalar int\n Args          : pdb residue identifier: num[insertion code]:[chain]\n\n\n\nsub _toDsspKey {\n    # Consider adding lookup table for 'common' name (like 20:A) for\n    # fast access.  Could be built during parse of input.\n\n    my $self = shift;\n    my $arg_str;\n\n    my ( $key_num, $chain_id, $ins_code );\n\n    # check to see how many args are given\n    if ( $#_ > 1 ) { # multiple args\n\t$key_num = shift;\n\tif ( $#_ > 1 ) { # still multiple args => ins. code, too\n\t    $ins_code = shift;\n\t    $chain_id = shift;\n\t}\n\telse { # just one more arg. => chain_id\n\t    $chain_id = shift;\n\t}\n    }\n    else { # only single arg.  Might be number or string\n\t$arg_str = shift;\n\tif ( $arg_str =~ /:/ ) {\n\t    # a chain is specified\n\t    ( $chain_id ) = ( $arg_str =~ /:(.)/);\n\t    $arg_str =~ s/:.//;\n\t}\n\tif ( $arg_str =~ /[A-Z]|[a-z]/ ) {\n\t    # an insertion code is specified\n\t    ( $ins_code ) = ( $arg_str =~ /([A-Z]|[a-z])/ );\n\t    $arg_str =~ s/[A-Z]|[a-z]//g;\n\t}\n\t#now, get the number bit-> everything still around\n\t$key_num = $arg_str;\n    }\n\n    # Now find the residue which fits this description.  Linear search is\n    # probably not the best way to do this, but oh well...\n    for ( my $i = 1; $i <= $self->_numResLines(); $i++ ) {\n\tunless ( ($self->{'Res'}->[$i]->{'term_sig'} eq '*') ||\n\t\t ($self->{'Res'}->[$i]->{'amino_acid'} eq '!') ) {\n\t    # chain break 'residue', doesn't match anything\n\t    if ( $key_num == $self->{'Res'}->[$i]->{'pdb_resnum'} ) {\n\t\tif ( $chain_id ) { # if a chain was specified\n\t\t    if ( $chain_id eq $self->{'Res'}->[$i]->{'pdb_chain'} ) {\n\t\t\t# and it's the right one\n\t\t\tif ( $ins_code ) { # if insertion code was specified\n\t\t\t    if ( $ins_code eq $self->{'Res'}->[$i]->{'insertionco'} ) {\n\t\t\t\t# and it's the right one\n\t\t\t\treturn $i;\n\t\t\t    }\n\t\t\t}\n\t\t\telse { # no isertion code specified, this is it\n\t\t\t    return $i;\n\t\t\t}\n\t\t    }\n\t\t}\n\t\telse { # no chain was specified\n\t\t    return $i;\n\t\t}\n\t    }\n\t}\n    }\n    $self->throw( \"PDB key not found.\" );\n}\n\n=head2 _parse\n\n Title         : _parse\n Usage         : parses dssp output\n Function      :\n Example       : used by the constructor\n Returns       :\n Args          : input source ( handled by Bio::Root:IO )\n\n\n\nsub _parse {\n    my $self = shift;\n    my $file = shift;\n    my $cur;\n    my $current_chain;\n    my ( @elements, @hbond );\n    my ( %head, %his, );\n    my $element;\n    my $res_num;\n\n    $cur = <$file>;\n    unless ( $cur =~ /^==== Secondary Structure Definition/ ) {\n\t$self->throw( \"Not dssp output\" );\n\treturn;\n    }\n\n    # REFERENCE line (always there)\n    $cur = <$file>;\n    ( $element ) = ( $cur =~ /^REFERENCE\\s+(.+?)\\s+\\./ );\n    $head{ 'REFERENCE' } = $element;\n\n    $cur = <$file>;\n    # Check for HEADER line (not always there)\n    if ( $cur =~ /^HEADER\\s/ ) {\n\t@elements = split( /\\s+/, $cur );\n\tpop( @elements ); # take off that annoying period\n\t$head{ 'PDB' } = pop( @elements );\n\t$head{ 'DATE' } = pop( @elements );\n\t# now, everything else is \"header\" except for the word\n\t# HEADER\n\tshift( @elements );\n\t$element = shift( @elements );\n\twhile ( @elements ) {\n\t    $element = $element.\" \".shift( @elements );\n\t}\n\t$head{ 'HEADER' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    # Check for COMPND line (not always there)\n    if ( $cur =~ /^COMPND\\s/ ) {\n\t($element) = ( $cur =~ /^COMPND\\s+(.+?)\\s+\\./ );\n\t$head{ 'COMPND' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    # Check for SOURCE or PDBSOURCE line (not always there)\n    if ( $cur =~ /^PDBSOURCE\\s/ ) {\n\t($element) = ( $cur =~ /^PDBSOURCE\\s+(.+?)\\s+\\./ );\n\t$head{ 'SOURCE' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    elsif ( $cur =~ /^SOURCE\\s/ ) {\n\t($element) = ( $cur =~ /^SOURCE\\s+(.+?)\\s+\\./ );\n\t$head{ 'SOURCE' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    # Check for AUTHOR line (not always there)\n    if ( $cur =~ /^AUTHOR/ ) {\n\t($element) = ( $cur =~ /^AUTHOR\\s+(.+?)\\s+/ );\n\t$head{ 'AUTHOR' } = $element;\n\n\t$cur = <$file>;\n    }\n\n    # A B C D E TOTAL NUMBER OF RESIDUES, NUMBER ... line\n    @elements = split( /\\s+/, $cur );\n    shift( @elements );\n    $head{ 'TotNumRes' } = shift( @elements );\n    $head{ 'NumChain' }  = shift( @elements );\n    $head{ 'TotSSBr' }   = shift( @elements );\n    $head{ 'TotIaSSBr' } = shift( @elements );\n    $head{ 'TotIeSSBr' } = shift( @elements );\n\n    $cur = <$file>;\n    ( $element ) = ( $cur =~ /\\s*(\\d+\\.\\d*)\\s+ACCESSIBLE SURFACE OF PROTEIN/ );\n    $head{ 'ProAccSurf' } = $element;\n    $self->{ 'Head' } = \\%head;\n\n    for ( my $i = 1; $i <= 14; $i++ ) {\n\t$cur = <$file>;\n\t( $element ) =\n\t    $cur =~ /\\s*(\\d+)\\s+\\d+\\.\\d+\\s+TOTAL NUMBER OF HYDROGEN/;\n\tpush( @hbond, $element );\n#\t$hbond{ $hBondType } = $element;\n    }\n    $self->{ 'HBond' } = \\@hbond;\n\n    my $histogram_finished = 0;\n    while ( !($histogram_finished) && chomp( $cur = <$file> ) ) {\n\tif ( $cur =~ /RESIDUE AA STRUCTURE/ ) {\n\t    $histogram_finished = 1;\n\t}\n    }\n\n    while ( $cur = <$file> ) {\n\tif ( $cur =~ m/^\\s*$/ ) {\n\t    next;\n\t}\n\t$res_num = substr( $cur, 0, 5 );\n\t$res_num =~ s/\\s//g;\n\t$self->{ 'Res' }->[ $res_num ] = &_parseResLine( $cur );\n    }\n}\n\n\n=head2 _parseResLine\n\n Title         : _parseResLine\n Usage         : parses a single residue line\n Function      :\n Example       : used internally\n Returns       :\n Args          : residue line ( string )"},"detail":"()","kind":12,"children":[{"name":"$cur","definition":"my","containerName":"_parseResLine","localvar":"my","kind":13,"line":1385},{"containerName":"_parseResLine","definition":"my","name":"$feat","localvar":"my","kind":13,"line":1386},{"kind":13,"line":1386,"containerName":"_parseResLine","name":"$value"},{"localvar":"my","containerName":"_parseResLine","name":"%elements","definition":"my","line":1387,"kind":13},{"kind":13,"line":1389,"containerName":"_parseResLine","name":"$feat"},{"line":1389,"kind":13,"name":"%lookUp","containerName":"_parseResLine"},{"line":1390,"kind":13,"containerName":"_parseResLine","name":"$value"},{"containerName":"_parseResLine","name":"$cur","kind":13,"line":1390},{"line":1390,"kind":13,"containerName":"_parseResLine","name":"$lookUp"},{"kind":13,"line":1390,"name":"$feat","containerName":"_parseResLine"},{"line":1391,"kind":13,"containerName":"_parseResLine","name":"$lookUp"},{"kind":13,"line":1391,"containerName":"_parseResLine","name":"$feat"},{"kind":13,"line":1392,"name":"$value","containerName":"_parseResLine"},{"containerName":"_parseResLine","name":"$elements","kind":13,"line":1393},{"containerName":"_parseResLine","name":"$feat","kind":13,"line":1393},{"containerName":"_parseResLine","name":"$value","line":1393,"kind":13},{"kind":13,"line":1397,"name":"$elements","containerName":"_parseResLine"},{"kind":13,"line":1397,"containerName":"_parseResLine","name":"$elements"},{"name":"$elements","containerName":"_parseResLine","kind":13,"line":1398},{"containerName":"_parseResLine","name":"%elements","line":1400,"kind":13}],"line":1384,"name":"_parseResLine","range":{"start":{"character":0,"line":1384},"end":{"line":1401,"character":9999}}}],"version":5}