{"version":5,"vars":[{"line":136,"kind":2,"containerName":"","name":"vars"},{"line":140,"kind":2,"name":"base","containerName":""},{"line":145,"kind":13,"name":"%ONECODE","containerName":null},{"name":"%THREECODE","containerName":null,"kind":13,"line":155},{"name":"seq3","range":{"start":{"character":0,"line":184},"end":{"line":205,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$stop"},{"label":"$sep"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''","label":"seq3($self,$seq,$stop,$sep)"},"detail":"($self,$seq,$stop,$sep)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"seq3","localvar":"my","kind":13,"line":185},{"containerName":"seq3","name":"$seq","line":185,"kind":13},{"kind":13,"line":185,"name":"$stop","containerName":"seq3"},{"name":"$sep","containerName":"seq3","kind":13,"line":185},{"containerName":"seq3","name":"$seq","line":187,"kind":13},{"kind":12,"line":187,"containerName":"seq3","name":"isa"},{"containerName":"seq3","name":"$self","kind":13,"line":188},{"kind":12,"line":188,"containerName":"seq3","name":"throw"},{"line":189,"kind":13,"containerName":"seq3","name":"$seq"},{"containerName":"seq3","name":"alphabet","line":189,"kind":12},{"line":190,"kind":13,"name":"$self","containerName":"seq3"},{"kind":12,"line":190,"name":"throw","containerName":"seq3"},{"containerName":"seq3","name":"$stop","kind":13,"line":192},{"line":193,"kind":13,"containerName":"seq3","name":"$stop"},{"line":193,"kind":13,"name":"$self","containerName":"seq3"},{"kind":12,"line":193,"containerName":"seq3","name":"throw"},{"kind":13,"line":194,"name":"$THREECODE","containerName":"seq3"},{"name":"$stop","containerName":"seq3","line":194,"kind":13},{"line":196,"kind":13,"name":"$sep","containerName":"seq3"},{"localvar":"my","containerName":"seq3","definition":"my","name":"$aa3s","line":198,"kind":13},{"definition":"my","name":"$aa","containerName":"seq3","localvar":"my","kind":13,"line":199},{"kind":13,"line":199,"name":"$seq","containerName":"seq3"},{"name":"seq","containerName":"seq3","line":199,"kind":12},{"line":200,"kind":13,"name":"$THREECODE","containerName":"seq3"},{"containerName":"seq3","name":"$aa","line":200,"kind":13},{"line":200,"kind":13,"name":"$aa3s","containerName":"seq3"},{"name":"$THREECODE","containerName":"seq3","kind":13,"line":200},{"name":"$aa","containerName":"seq3","line":200,"kind":13},{"line":200,"kind":13,"name":"$sep","containerName":"seq3"},{"line":201,"kind":13,"containerName":"seq3","name":"$aa3s"},{"kind":13,"line":201,"containerName":"seq3","name":"$sep"},{"name":"$sep","containerName":"seq3","line":203,"kind":13},{"line":203,"kind":13,"name":"$aa3s","containerName":"seq3"},{"containerName":"seq3","name":"$sep","line":203,"kind":13},{"containerName":"seq3","name":"$sep","kind":13,"line":203},{"containerName":"seq3","name":"$aa3s","kind":13,"line":204}],"line":184},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$string"},{"label":"$stop"},{"label":"$unknown"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'","label":"seq3in($self,$seq,$string,$stop,$unknown)"},"detail":"($self,$seq,$string,$stop,$unknown)","kind":12,"children":[{"kind":13,"line":227,"containerName":"seq3in","definition":"my","name":"$self","localvar":"my"},{"containerName":"seq3in","name":"$seq","line":227,"kind":13},{"containerName":"seq3in","name":"$string","kind":13,"line":227},{"line":227,"kind":13,"name":"$stop","containerName":"seq3in"},{"name":"$unknown","containerName":"seq3in","kind":13,"line":227},{"name":"$seq","containerName":"seq3in","line":229,"kind":13},{"line":229,"kind":12,"name":"isa","containerName":"seq3in"},{"name":"$self","containerName":"seq3in","kind":13,"line":230},{"containerName":"seq3in","name":"throw","kind":12,"line":230},{"name":"$seq","containerName":"seq3in","kind":13,"line":231},{"line":231,"kind":12,"name":"alphabet","containerName":"seq3in"},{"containerName":"seq3in","name":"$self","line":232,"kind":13},{"name":"throw","containerName":"seq3in","line":232,"kind":12},{"name":"$stop","containerName":"seq3in","kind":13,"line":234},{"line":235,"kind":13,"name":"$stop","containerName":"seq3in"},{"line":235,"kind":13,"name":"$self","containerName":"seq3in"},{"kind":12,"line":235,"containerName":"seq3in","name":"throw"},{"name":"$ONECODE","containerName":"seq3in","line":236,"kind":13},{"line":236,"kind":13,"name":"$stop","containerName":"seq3in"},{"name":"$unknown","containerName":"seq3in","line":238,"kind":13},{"containerName":"seq3in","name":"$unknown","line":239,"kind":13},{"containerName":"seq3in","name":"$self","kind":13,"line":239},{"name":"throw","containerName":"seq3in","line":239,"kind":12},{"kind":13,"line":240,"name":"$ONECODE","containerName":"seq3in"},{"kind":13,"line":240,"name":"$unknown","containerName":"seq3in"},{"line":243,"kind":13,"localvar":"my","containerName":"seq3in","definition":"my","name":"$aas"},{"line":243,"kind":13,"name":"$aa3","containerName":"seq3in"},{"kind":13,"line":244,"definition":"my","name":"$length","containerName":"seq3in","localvar":"my"},{"name":"$string","containerName":"seq3in","line":244,"kind":13},{"definition":"my","name":"$i","containerName":"seq3in","localvar":"my","kind":13,"line":245},{"kind":13,"line":245,"name":"$i","containerName":"seq3in"},{"containerName":"seq3in","name":"$length","line":245,"kind":13},{"kind":13,"line":245,"containerName":"seq3in","name":"$i"},{"line":246,"kind":13,"name":"$aa3","containerName":"seq3in"},{"containerName":"seq3in","name":"$string","line":246,"kind":13},{"name":"$i","containerName":"seq3in","line":246,"kind":13},{"containerName":"seq3in","name":"$aa3","line":247,"kind":13},{"containerName":"seq3in","name":"$aa3","line":247,"kind":13},{"containerName":"seq3in","name":"$ONECODE","line":248,"kind":13},{"containerName":"seq3in","name":"$aa3","line":248,"kind":13},{"line":248,"kind":13,"name":"$aas","containerName":"seq3in"},{"line":248,"kind":13,"containerName":"seq3in","name":"$ONECODE"},{"containerName":"seq3in","name":"$aa3","line":248,"kind":13},{"containerName":"seq3in","name":"$aas","line":249,"kind":13},{"line":249,"kind":13,"name":"$ONECODE","containerName":"seq3in"},{"line":251,"kind":13,"containerName":"seq3in","name":"$seq"},{"containerName":"seq3in","name":"seq","line":251,"kind":12},{"kind":13,"line":251,"containerName":"seq3in","name":"$aas"},{"name":"$seq","containerName":"seq3in","line":252,"kind":13}],"line":226,"name":"seq3in","range":{"start":{"line":226,"character":0},"end":{"line":253,"character":9999}}},{"signature":{"parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate","label":"translate_3frames($self,$seq,@args)"},"detail":"($self,$seq,@args)","definition":"sub","containerName":"main::","children":[{"line":268,"kind":13,"localvar":"my","containerName":"translate_3frames","definition":"my","name":"$self"},{"containerName":"translate_3frames","name":"$seq","line":268,"kind":13},{"containerName":"translate_3frames","name":"@args","line":268,"kind":13},{"kind":13,"line":270,"containerName":"translate_3frames","name":"$self"},{"line":270,"kind":12,"name":"throw","containerName":"translate_3frames"},{"kind":13,"line":270,"containerName":"translate_3frames","name":"$seq"},{"line":271,"kind":13,"containerName":"translate_3frames","name":"$seq"},{"line":271,"kind":12,"name":"can","containerName":"translate_3frames"},{"localvar":"my","name":"$stop","definition":"my","containerName":"translate_3frames","line":273,"kind":13},{"containerName":"translate_3frames","name":"$unknown","line":273,"kind":13},{"containerName":"translate_3frames","name":"$frame","line":273,"kind":13},{"name":"$tableid","containerName":"translate_3frames","line":273,"kind":13},{"line":273,"kind":13,"name":"$fullCDS","containerName":"translate_3frames"},{"containerName":"translate_3frames","name":"$throw","line":273,"kind":13},{"name":"@args","containerName":"translate_3frames","line":273,"kind":13},{"containerName":"translate_3frames","name":"@seqs","definition":"my","localvar":"my","kind":13,"line":274},{"localvar":"my","containerName":"translate_3frames","name":"$f","definition":"my","line":275,"kind":13},{"name":"$f","containerName":"translate_3frames","kind":13,"line":276},{"line":277,"kind":13,"localvar":"my","containerName":"translate_3frames","definition":"my","name":"$translation"},{"line":277,"kind":13,"containerName":"translate_3frames","name":"$seq"},{"name":"translate","containerName":"translate_3frames","line":277,"kind":12},{"kind":13,"line":277,"containerName":"translate_3frames","name":"$stop"},{"containerName":"translate_3frames","name":"$unknown","line":277,"kind":13},{"kind":13,"line":277,"name":"$f","containerName":"translate_3frames"},{"name":"$tableid","containerName":"translate_3frames","kind":13,"line":277},{"line":277,"kind":13,"name":"$fullCDS","containerName":"translate_3frames"},{"kind":13,"line":277,"name":"$throw","containerName":"translate_3frames"},{"name":"$translation","containerName":"translate_3frames","kind":13,"line":278},{"line":278,"kind":12,"name":"id","containerName":"translate_3frames"},{"containerName":"translate_3frames","name":"$seq","kind":13,"line":278},{"line":278,"kind":12,"name":"id","containerName":"translate_3frames"},{"kind":13,"line":278,"name":"$f","containerName":"translate_3frames"},{"kind":13,"line":279,"containerName":"translate_3frames","name":"@seqs"},{"containerName":"translate_3frames","name":"$translation","kind":13,"line":279},{"name":"$f","containerName":"translate_3frames","kind":13,"line":280},{"containerName":"translate_3frames","name":"@seqs","line":283,"kind":13}],"line":267,"kind":12,"range":{"start":{"line":267,"character":0},"end":{"line":284,"character":9999}},"name":"translate_3frames"},{"line":299,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"translate_6frames","line":300,"kind":13},{"containerName":"translate_6frames","name":"$seq","line":300,"kind":13},{"kind":13,"line":300,"containerName":"translate_6frames","name":"@args"},{"line":302,"kind":13,"localvar":"my","name":"@seqs","definition":"my","containerName":"translate_6frames"},{"kind":13,"line":302,"containerName":"translate_6frames","name":"$self"},{"line":302,"kind":12,"name":"translate_3frames","containerName":"translate_6frames"},{"name":"$seq","containerName":"translate_6frames","line":302,"kind":13},{"kind":13,"line":302,"name":"@args","containerName":"translate_6frames"},{"kind":13,"line":303,"containerName":"translate_6frames","name":"@seqs2","definition":"my","localvar":"my"},{"kind":13,"line":303,"containerName":"translate_6frames","name":"$self"},{"kind":12,"line":303,"containerName":"translate_6frames","name":"translate_3frames"},{"line":303,"kind":13,"containerName":"translate_6frames","name":"$seq"},{"name":"revcom","containerName":"translate_6frames","line":303,"kind":12},{"containerName":"translate_6frames","name":"@args","kind":13,"line":303},{"localvar":"my","containerName":"translate_6frames","definition":"my","name":"$seq2","line":304,"kind":13},{"containerName":"translate_6frames","name":"@seqs2","kind":13,"line":304},{"containerName":"translate_6frames","definition":"my","name":"$tmp","localvar":"my","kind":13,"line":305},{"kind":13,"line":305,"containerName":"translate_6frames","name":"$seq2"},{"containerName":"translate_6frames","name":"id","kind":12,"line":305},{"line":306,"kind":13,"name":"$tmp","containerName":"translate_6frames"},{"kind":13,"line":307,"containerName":"translate_6frames","name":"$seq2"},{"containerName":"translate_6frames","name":"id","kind":12,"line":307},{"line":307,"kind":13,"containerName":"translate_6frames","name":"$tmp"},{"containerName":"translate_6frames","name":"@seqs","kind":13,"line":309},{"line":309,"kind":13,"name":"@seqs2","containerName":"translate_6frames"}],"kind":12,"detail":"($self,$seq,@args)","signature":{"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@args"}],"label":"translate_6frames($self,$seq,@args)"},"containerName":"main::","definition":"sub","range":{"end":{"line":310,"character":9999},"start":{"line":299,"character":0}},"name":"translate_6frames"},{"range":{"start":{"character":0,"line":327},"end":{"character":9999,"line":357}},"name":"valid_aa","line":327,"children":[{"localvar":"my","containerName":"valid_aa","definition":"my","name":"$self","line":328,"kind":13},{"kind":13,"line":328,"containerName":"valid_aa","name":"$code"},{"kind":13,"line":330,"name":"$code","containerName":"valid_aa"},{"localvar":"my","name":"@codes","definition":"my","containerName":"valid_aa","line":331,"kind":13},{"localvar":"my","containerName":"valid_aa","name":"$c","definition":"my","line":332,"kind":13},{"containerName":"valid_aa","name":"%ONECODE","line":332,"kind":13},{"name":"@codes","containerName":"valid_aa","kind":13,"line":333},{"containerName":"valid_aa","name":"$c","kind":13,"line":333},{"name":"$c","containerName":"valid_aa","line":333,"kind":13},{"name":"@codes","containerName":"valid_aa","line":335,"kind":13},{"kind":13,"line":336,"name":"@codes","containerName":"valid_aa"},{"kind":13,"line":338,"name":"$code","containerName":"valid_aa"},{"line":339,"kind":13,"localvar":"my","containerName":"valid_aa","definition":"my","name":"@codes"},{"localvar":"my","definition":"my","name":"$c","containerName":"valid_aa","line":340,"kind":13},{"containerName":"valid_aa","name":"%ONECODE","line":340,"kind":13},{"name":"@codes","containerName":"valid_aa","kind":13,"line":341},{"containerName":"valid_aa","name":"$c","kind":13,"line":341},{"containerName":"valid_aa","name":"$c","line":341,"kind":13},{"containerName":"valid_aa","name":"@codes","line":343,"kind":13},{"line":344,"kind":13,"containerName":"valid_aa","name":"@codes"},{"name":"$code","containerName":"valid_aa","line":346,"kind":13},{"localvar":"my","name":"%codes","definition":"my","containerName":"valid_aa","line":347,"kind":13},{"line":347,"kind":13,"name":"%ONECODE","containerName":"valid_aa"},{"localvar":"my","containerName":"valid_aa","name":"$c","definition":"my","line":348,"kind":13},{"containerName":"valid_aa","name":"%ONECODE","line":348,"kind":13},{"line":349,"kind":13,"localvar":"my","containerName":"valid_aa","definition":"my","name":"$aa"},{"name":"$ONECODE","containerName":"valid_aa","kind":13,"line":349},{"line":349,"kind":13,"name":"$c","containerName":"valid_aa"},{"line":350,"kind":13,"containerName":"valid_aa","name":"$codes"},{"containerName":"valid_aa","name":"$aa","kind":13,"line":350},{"name":"$c","containerName":"valid_aa","kind":13,"line":350},{"line":352,"kind":13,"name":"%codes","containerName":"valid_aa"},{"name":"$self","containerName":"valid_aa","kind":13,"line":354},{"line":354,"kind":12,"name":"warn","containerName":"valid_aa"},{"name":"$self","containerName":"valid_aa","line":354,"kind":13}],"kind":12,"detail":"($self,$code)","signature":{"label":"valid_aa($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":398},"start":{"character":0,"line":379}},"name":"mutate","detail":"($self,$seq,@mutations)","signature":{"label":"mutate($self,$seq,@mutations)","documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@mutations"}]},"containerName":"main::","definition":"sub","line":379,"children":[{"line":380,"kind":13,"localvar":"my","containerName":"mutate","definition":"my","name":"$self"},{"line":380,"kind":13,"name":"$seq","containerName":"mutate"},{"containerName":"mutate","name":"@mutations","kind":13,"line":380},{"name":"$self","containerName":"mutate","line":382,"kind":13},{"kind":12,"line":382,"containerName":"mutate","name":"throw"},{"containerName":"mutate","name":"$seq","kind":13,"line":382},{"kind":13,"line":384,"containerName":"mutate","name":"$seq"},{"name":"isa","containerName":"mutate","line":384,"kind":12},{"containerName":"mutate","name":"$self","kind":13,"line":385},{"kind":12,"line":385,"name":"throw","containerName":"mutate"},{"name":"$mutations","containerName":"mutate","kind":13,"line":385},{"kind":13,"line":387,"name":"$mutations","containerName":"mutate"},{"kind":12,"line":387,"name":"isa","containerName":"mutate"},{"line":389,"kind":13,"localvar":"my","containerName":"mutate","definition":"my","name":"$mutation"},{"kind":13,"line":389,"containerName":"mutate","name":"@mutations"},{"containerName":"mutate","name":"$self","line":390,"kind":13},{"kind":12,"line":390,"containerName":"mutate","name":"throw"},{"kind":13,"line":391,"containerName":"mutate","name":"$mutation"},{"name":"pos","containerName":"mutate","line":391,"kind":12},{"kind":13,"line":391,"containerName":"mutate","name":"$seq"},{"name":"length","containerName":"mutate","line":391,"kind":12},{"localvar":"my","definition":"my","name":"$string","containerName":"mutate","line":393,"kind":13},{"containerName":"mutate","name":"$seq","kind":13,"line":393},{"kind":12,"line":393,"name":"seq","containerName":"mutate"},{"kind":13,"line":394,"name":"$string","containerName":"mutate"},{"line":394,"kind":13,"name":"$mutation","containerName":"mutate"},{"name":"pos","containerName":"mutate","line":394,"kind":12},{"kind":13,"line":394,"containerName":"mutate","name":"$mutation"},{"containerName":"mutate","name":"len","kind":12,"line":394},{"line":394,"kind":13,"name":"$mutation","containerName":"mutate"},{"kind":12,"line":394,"containerName":"mutate","name":"seq"},{"name":"$seq","containerName":"mutate","kind":13,"line":395},{"kind":12,"line":395,"name":"seq","containerName":"mutate"},{"name":"$string","containerName":"mutate","line":395,"kind":13}],"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$seq,@seqs)","signature":{"label":"cat($self,$seq,@seqs)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@seqs"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added."},"kind":12,"line":417,"children":[{"containerName":"cat","name":"$self","definition":"my","localvar":"my","kind":13,"line":418},{"kind":13,"line":418,"name":"$seq","containerName":"cat"},{"name":"@seqs","containerName":"cat","line":418,"kind":13},{"line":419,"kind":13,"containerName":"cat","name":"$self"},{"name":"throw","containerName":"cat","kind":12,"line":419},{"name":"$seq","containerName":"cat","kind":13,"line":419},{"containerName":"cat","name":"$seq","line":421,"kind":13},{"containerName":"cat","name":"isa","line":421,"kind":12},{"localvar":"my","containerName":"cat","definition":"my","name":"$catseq","line":424,"kind":13},{"kind":13,"line":424,"name":"@seqs","containerName":"cat"},{"line":425,"kind":13,"containerName":"cat","name":"$self"},{"containerName":"cat","name":"throw","kind":12,"line":425},{"kind":13,"line":425,"containerName":"cat","name":"$catseq"},{"line":427,"kind":13,"name":"$catseq","containerName":"cat"},{"containerName":"cat","name":"isa","kind":12,"line":427},{"containerName":"cat","name":"$self","line":429,"kind":13},{"kind":12,"line":429,"containerName":"cat","name":"throw"},{"containerName":"cat","name":"$seq","line":430,"kind":13},{"kind":12,"line":430,"containerName":"cat","name":"display_id"},{"line":430,"kind":13,"containerName":"cat","name":"$seq"},{"name":"alphabet","containerName":"cat","line":430,"kind":12},{"line":430,"kind":13,"name":"$catseq","containerName":"cat"},{"kind":12,"line":430,"containerName":"cat","name":"display_id"},{"kind":13,"line":431,"name":"$catseq","containerName":"cat"},{"containerName":"cat","name":"alphabet","kind":12,"line":431},{"line":432,"kind":13,"name":"$catseq","containerName":"cat"},{"line":432,"kind":12,"name":"alphabet","containerName":"cat"},{"line":432,"kind":13,"containerName":"cat","name":"$seq"},{"kind":12,"line":432,"name":"alphabet","containerName":"cat"},{"kind":13,"line":435,"definition":"my","name":"$length","containerName":"cat","localvar":"my"},{"name":"$seq","containerName":"cat","line":435,"kind":13},{"containerName":"cat","name":"length","line":435,"kind":12},{"line":436,"kind":13,"containerName":"cat","name":"$seq"},{"containerName":"cat","name":"seq","line":436,"kind":12},{"line":436,"kind":13,"containerName":"cat","name":"$seq"},{"line":436,"kind":12,"name":"seq","containerName":"cat"},{"containerName":"cat","name":"$catseq","line":436,"kind":13},{"kind":12,"line":436,"name":"seq","containerName":"cat"},{"line":439,"kind":13,"name":"$seq","containerName":"cat"},{"name":"isa","containerName":"cat","line":439,"kind":12},{"line":439,"kind":13,"containerName":"cat","name":"$catseq"},{"containerName":"cat","name":"isa","line":439,"kind":12},{"containerName":"cat","definition":"my","name":"$key","localvar":"my","kind":13,"line":440},{"kind":13,"line":440,"name":"$catseq","containerName":"cat"},{"kind":12,"line":440,"containerName":"cat","name":"annotation"},{"name":"get_all_annotation_keys","containerName":"cat","kind":12,"line":440},{"definition":"my","name":"$value","containerName":"cat","localvar":"my","kind":13,"line":442},{"kind":13,"line":442,"containerName":"cat","name":"$catseq"},{"line":442,"kind":12,"name":"annotation","containerName":"cat"},{"containerName":"cat","name":"get_Annotations","kind":12,"line":442},{"kind":13,"line":442,"containerName":"cat","name":"$key"},{"name":"$seq","containerName":"cat","kind":13,"line":443},{"kind":12,"line":443,"containerName":"cat","name":"annotation"},{"line":443,"kind":12,"containerName":"cat","name":"add_Annotation"},{"name":"$key","containerName":"cat","line":443,"kind":13},{"kind":13,"line":443,"name":"$value","containerName":"cat"},{"containerName":"cat","name":"$seq","kind":13,"line":449},{"name":"isa","containerName":"cat","line":449,"kind":12},{"line":449,"kind":13,"containerName":"cat","name":"$catseq"},{"line":449,"kind":12,"name":"isa","containerName":"cat"},{"kind":13,"line":450,"definition":"my","name":"$feat","containerName":"cat","localvar":"my"},{"containerName":"cat","name":"$catseq","kind":13,"line":450},{"kind":12,"line":450,"name":"get_SeqFeatures","containerName":"cat"},{"line":451,"kind":13,"name":"$seq","containerName":"cat"},{"kind":12,"line":451,"containerName":"cat","name":"add_SeqFeature"},{"name":"$self","containerName":"cat","line":451,"kind":13},{"kind":12,"line":451,"containerName":"cat","name":"_coord_adjust"},{"kind":13,"line":451,"containerName":"cat","name":"$feat"},{"name":"$length","containerName":"cat","line":451,"kind":13}],"name":"cat","range":{"end":{"line":457,"character":9999},"start":{"line":417,"character":0}}},{"name":"trunc_with_features","range":{"start":{"character":0,"line":473},"end":{"line":491,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$seq,$start,$end)","signature":{"label":"trunc_with_features($self,$seq,$start,$end)","documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$start"},{"label":"$end"}]},"kind":12,"line":473,"children":[{"line":475,"kind":13,"localvar":"my","containerName":"trunc_with_features","definition":"my","name":"$self"},{"containerName":"trunc_with_features","name":"$seq","kind":13,"line":475},{"kind":13,"line":475,"containerName":"trunc_with_features","name":"$start"},{"line":475,"kind":13,"containerName":"trunc_with_features","name":"$end"},{"kind":13,"line":476,"containerName":"trunc_with_features","name":"$self"},{"name":"throw","containerName":"trunc_with_features","kind":12,"line":476},{"containerName":"trunc_with_features","name":"$seq","line":476,"kind":13},{"name":"$seq","containerName":"trunc_with_features","kind":13,"line":478},{"name":"isa","containerName":"trunc_with_features","line":478,"kind":12},{"line":479,"kind":13,"localvar":"my","containerName":"trunc_with_features","name":"$trunc","definition":"my"},{"containerName":"trunc_with_features","name":"$seq","kind":13,"line":479},{"line":479,"kind":12,"name":"trunc","containerName":"trunc_with_features"},{"containerName":"trunc_with_features","name":"$start","line":479,"kind":13},{"line":479,"kind":13,"name":"$end","containerName":"trunc_with_features"},{"localvar":"my","name":"$truncrange","definition":"my","containerName":"trunc_with_features","line":480,"kind":13},{"containerName":"trunc_with_features","name":"new","line":480,"kind":12},{"name":"$start","containerName":"trunc_with_features","line":480,"kind":13},{"containerName":"trunc_with_features","name":"$end","line":480,"kind":13},{"line":482,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":"trunc_with_features"},{"containerName":"trunc_with_features","name":"$seq","kind":13,"line":482},{"containerName":"trunc_with_features","name":"annotation","line":482,"kind":12},{"name":"get_all_annotation_keys","containerName":"trunc_with_features","line":482,"kind":12},{"containerName":"trunc_with_features","name":"$value","definition":"my","localvar":"my","kind":13,"line":483},{"name":"$seq","containerName":"trunc_with_features","kind":13,"line":483},{"containerName":"trunc_with_features","name":"annotation","line":483,"kind":12},{"kind":12,"line":483,"containerName":"trunc_with_features","name":"get_Annotations"},{"containerName":"trunc_with_features","name":"$key","line":483,"kind":13},{"containerName":"trunc_with_features","name":"$trunc","line":484,"kind":13},{"kind":12,"line":484,"containerName":"trunc_with_features","name":"annotation"},{"containerName":"trunc_with_features","name":"add_Annotation","line":484,"kind":12},{"kind":13,"line":484,"name":"$key","containerName":"trunc_with_features"},{"line":484,"kind":13,"name":"$value","containerName":"trunc_with_features"},{"name":"$trunc","containerName":"trunc_with_features","line":489,"kind":13},{"name":"add_SeqFeature","containerName":"trunc_with_features","line":489,"kind":12},{"containerName":"trunc_with_features","name":"$self","line":489,"kind":13},{"kind":12,"line":489,"containerName":"trunc_with_features","name":"_coord_adjust"},{"kind":13,"line":489,"name":"$start","containerName":"trunc_with_features"},{"kind":13,"line":489,"containerName":"trunc_with_features","name":"$end"},{"containerName":"trunc_with_features","name":"$start","line":489,"kind":13},{"containerName":"trunc_with_features","name":"overlaps","line":489,"kind":12},{"name":"$truncrange","containerName":"trunc_with_features","line":489,"kind":13},{"containerName":"trunc_with_features","name":"$seq","kind":13,"line":489},{"line":489,"kind":12,"name":"get_SeqFeatures","containerName":"trunc_with_features"},{"kind":13,"line":490,"containerName":"trunc_with_features","name":"$trunc"}]},{"kind":2,"line":475,"name":"Range","containerName":"Bio"},{"kind":12,"line":480,"name":"Bio","containerName":"Range"},{"range":{"start":{"character":0,"line":512},"end":{"line":560,"character":9999}},"name":"_coord_adjust","children":[{"containerName":"_coord_adjust","definition":"my","name":"$self","localvar":"my","kind":13,"line":513},{"containerName":"_coord_adjust","name":"$feat","kind":13,"line":513},{"kind":13,"line":513,"name":"$add","containerName":"_coord_adjust"},{"kind":13,"line":513,"containerName":"_coord_adjust","name":"$length"},{"containerName":"_coord_adjust","name":"$self","kind":13,"line":514},{"kind":12,"line":514,"name":"throw","containerName":"_coord_adjust"},{"line":514,"kind":13,"name":"$feat","containerName":"_coord_adjust"},{"line":516,"kind":13,"containerName":"_coord_adjust","name":"$feat"},{"kind":12,"line":516,"name":"isa","containerName":"_coord_adjust"},{"kind":13,"line":517,"containerName":"_coord_adjust","definition":"my","name":"@adjsubfeat","localvar":"my"},{"line":518,"kind":13,"localvar":"my","containerName":"_coord_adjust","name":"$subfeat","definition":"my"},{"containerName":"_coord_adjust","name":"$feat","line":518,"kind":13},{"containerName":"_coord_adjust","name":"remove_SeqFeatures","line":518,"kind":12},{"kind":13,"line":519,"name":"@adjsubfeat","containerName":"_coord_adjust"},{"kind":13,"line":519,"name":"$self","containerName":"_coord_adjust"},{"kind":12,"line":519,"containerName":"_coord_adjust","name":"_coord_adjust"},{"name":"$subfeat","containerName":"_coord_adjust","line":519,"kind":13},{"line":519,"kind":13,"containerName":"_coord_adjust","name":"$add"},{"name":"$length","containerName":"_coord_adjust","line":519,"kind":13},{"kind":13,"line":521,"containerName":"_coord_adjust","definition":"my","name":"@loc","localvar":"my"},{"containerName":"_coord_adjust","name":"$feat","line":522,"kind":13},{"line":522,"kind":12,"containerName":"_coord_adjust","name":"location"},{"line":522,"kind":12,"name":"each_Location","containerName":"_coord_adjust"},{"kind":13,"line":523,"definition":"my","name":"@coords","containerName":"_coord_adjust","localvar":"my"},{"kind":12,"line":523,"containerName":"_coord_adjust","name":"start"},{"name":"end","containerName":"_coord_adjust","kind":12,"line":523},{"kind":13,"line":524,"name":"$strand","definition":"my","containerName":"_coord_adjust","localvar":"my"},{"kind":12,"line":524,"containerName":"_coord_adjust","name":"strand"},{"localvar":"my","containerName":"_coord_adjust","name":"$type","definition":"my","line":525,"kind":13},{"kind":12,"line":525,"containerName":"_coord_adjust","name":"location_type"},{"name":"@coords","containerName":"_coord_adjust","line":526,"kind":13},{"name":"$newstart","definition":"my","containerName":"_coord_adjust","localvar":"my","kind":13,"line":527},{"line":527,"kind":13,"name":"$newend","containerName":"_coord_adjust"},{"kind":13,"line":527,"containerName":"_coord_adjust","name":"@coords"},{"containerName":"_coord_adjust","name":"$type","line":528,"kind":13},{"kind":13,"line":529,"name":"@loc","containerName":"_coord_adjust"},{"kind":12,"line":529,"name":"new","containerName":"_coord_adjust"},{"kind":13,"line":529,"containerName":"_coord_adjust","name":"$newstart"},{"kind":13,"line":530,"containerName":"_coord_adjust","name":"$newend"},{"line":531,"kind":13,"containerName":"_coord_adjust","name":"$strand"},{"line":533,"kind":13,"name":"$type","containerName":"_coord_adjust"},{"kind":13,"line":535,"containerName":"_coord_adjust","name":"@loc"},{"name":"new","containerName":"_coord_adjust","kind":12,"line":535},{"line":535,"kind":13,"containerName":"_coord_adjust","name":"$newstart"},{"kind":13,"line":536,"name":"$newend","containerName":"_coord_adjust"},{"kind":13,"line":537,"name":"$strand","containerName":"_coord_adjust"},{"line":539,"kind":13,"containerName":"_coord_adjust","name":"$type"},{"kind":13,"line":542,"name":"$newfeat","definition":"my","containerName":"_coord_adjust","localvar":"my"},{"line":542,"kind":12,"containerName":"_coord_adjust","name":"new"},{"name":"$feat","containerName":"_coord_adjust","kind":13,"line":542},{"kind":12,"line":542,"containerName":"_coord_adjust","name":"primary_tag"},{"line":543,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":"_coord_adjust"},{"name":"$feat","containerName":"_coord_adjust","line":543,"kind":13},{"containerName":"_coord_adjust","name":"annotation","kind":12,"line":543},{"kind":12,"line":543,"name":"get_all_annotation_keys","containerName":"_coord_adjust"},{"kind":13,"line":544,"definition":"my","name":"$value","containerName":"_coord_adjust","localvar":"my"},{"name":"$feat","containerName":"_coord_adjust","kind":13,"line":544},{"name":"annotation","containerName":"_coord_adjust","kind":12,"line":544},{"line":544,"kind":12,"containerName":"_coord_adjust","name":"get_Annotations"},{"line":544,"kind":13,"containerName":"_coord_adjust","name":"$key"},{"name":"$newfeat","containerName":"_coord_adjust","line":545,"kind":13},{"line":545,"kind":12,"containerName":"_coord_adjust","name":"annotation"},{"line":545,"kind":12,"name":"add_Annotation","containerName":"_coord_adjust"},{"kind":13,"line":545,"name":"$key","containerName":"_coord_adjust"},{"name":"$value","containerName":"_coord_adjust","kind":13,"line":545},{"line":548,"kind":13,"localvar":"my","containerName":"_coord_adjust","definition":"my","name":"$key"},{"containerName":"_coord_adjust","name":"$feat","kind":13,"line":548},{"containerName":"_coord_adjust","name":"get_all_tags","kind":12,"line":548},{"line":549,"kind":13,"containerName":"_coord_adjust","name":"$newfeat"},{"name":"add_tag_value","containerName":"_coord_adjust","kind":12,"line":549},{"line":549,"kind":13,"name":"$key","containerName":"_coord_adjust"},{"name":"$feat","containerName":"_coord_adjust","line":549,"kind":13},{"containerName":"_coord_adjust","name":"get_tag_values","kind":12,"line":549},{"kind":13,"line":549,"containerName":"_coord_adjust","name":"$key"},{"line":551,"kind":13,"name":"@loc","containerName":"_coord_adjust"},{"name":"$newfeat","containerName":"_coord_adjust","line":552,"kind":13},{"name":"location","containerName":"_coord_adjust","line":552,"kind":12},{"containerName":"_coord_adjust","name":"$loc","kind":13,"line":552},{"localvar":"my","containerName":"_coord_adjust","definition":"my","name":"$loc","line":554,"kind":13},{"line":554,"kind":12,"name":"new","containerName":"_coord_adjust"},{"kind":13,"line":555,"containerName":"_coord_adjust","name":"$loc"},{"containerName":"_coord_adjust","name":"add_sub_Location","kind":12,"line":555},{"name":"@loc","containerName":"_coord_adjust","kind":13,"line":555},{"line":556,"kind":13,"name":"$newfeat","containerName":"_coord_adjust"},{"line":556,"kind":12,"name":"location","containerName":"_coord_adjust"},{"kind":13,"line":556,"name":"$loc","containerName":"_coord_adjust"},{"kind":13,"line":558,"name":"$newfeat","containerName":"_coord_adjust"},{"name":"add_SeqFeature","containerName":"_coord_adjust","kind":12,"line":558},{"name":"@adjsubfeat","containerName":"_coord_adjust","line":558,"kind":13},{"kind":13,"line":559,"containerName":"_coord_adjust","name":"$newfeat"}],"line":512,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$add"},{"label":"$length"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence","label":"_coord_adjust($self,$feat,$add,$length)"},"detail":"($self,$feat,$add,$length)","definition":"sub","containerName":"main::"},{"containerName":"Location::Fuzzy","name":"Bio","line":529,"kind":12},{"kind":12,"line":535,"containerName":"Location::Simple","name":"Bio"},{"containerName":"SeqFeature::Generic","name":"Bio","line":542,"kind":12},{"kind":12,"line":554,"containerName":"Location::Split","name":"Bio"},{"name":"revcom_with_features","range":{"start":{"line":575,"character":0},"end":{"line":592,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"revcom_with_features","definition":"my","name":"$self","line":576,"kind":13},{"kind":13,"line":576,"name":"$seq","containerName":"revcom_with_features"},{"containerName":"revcom_with_features","name":"$self","kind":13,"line":577},{"kind":12,"line":577,"name":"throw","containerName":"revcom_with_features"},{"name":"$seq","containerName":"revcom_with_features","kind":13,"line":577},{"line":579,"kind":13,"name":"$seq","containerName":"revcom_with_features"},{"line":579,"kind":12,"name":"isa","containerName":"revcom_with_features"},{"localvar":"my","definition":"my","name":"$revcom","containerName":"revcom_with_features","line":580,"kind":13},{"kind":13,"line":580,"name":"$seq","containerName":"revcom_with_features"},{"line":580,"kind":12,"containerName":"revcom_with_features","name":"revcom"},{"line":583,"kind":13,"localvar":"my","containerName":"revcom_with_features","definition":"my","name":"$key"},{"containerName":"revcom_with_features","name":"$seq","kind":13,"line":583},{"kind":12,"line":583,"containerName":"revcom_with_features","name":"annotation"},{"kind":12,"line":583,"name":"get_all_annotation_keys","containerName":"revcom_with_features"},{"kind":13,"line":584,"definition":"my","name":"$value","containerName":"revcom_with_features","localvar":"my"},{"containerName":"revcom_with_features","name":"$seq","kind":13,"line":584},{"containerName":"revcom_with_features","name":"annotation","line":584,"kind":12},{"line":584,"kind":12,"containerName":"revcom_with_features","name":"get_Annotations"},{"kind":13,"line":584,"containerName":"revcom_with_features","name":"$key"},{"containerName":"revcom_with_features","name":"$revcom","kind":13,"line":585},{"kind":12,"line":585,"containerName":"revcom_with_features","name":"annotation"},{"containerName":"revcom_with_features","name":"add_Annotation","kind":12,"line":585},{"kind":13,"line":585,"name":"$key","containerName":"revcom_with_features"},{"line":585,"kind":13,"containerName":"revcom_with_features","name":"$value"},{"name":"$revcom","containerName":"revcom_with_features","kind":13,"line":590},{"containerName":"revcom_with_features","name":"add_SeqFeature","line":590,"kind":12},{"containerName":"revcom_with_features","name":"$self","kind":13,"line":590},{"kind":12,"line":590,"name":"_feature_revcom","containerName":"revcom_with_features"},{"kind":13,"line":590,"name":"$seq","containerName":"revcom_with_features"},{"containerName":"revcom_with_features","name":"length","line":590,"kind":12},{"kind":13,"line":590,"name":"$seq","containerName":"revcom_with_features"},{"kind":12,"line":590,"name":"get_SeqFeatures","containerName":"revcom_with_features"},{"kind":13,"line":591,"containerName":"revcom_with_features","name":"$revcom"}],"line":575,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence\n\n\n\nsub _coord_adjust {\n    my ($self, $feat, $add, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_coord_adjust($subfeat, $add, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n        my @coords=($_->start, $_->end);\n        my $strand=$_->strand;\n\tmy $type=$_->location_type;\n        map s/(\\d+)/if ($add+$1<1) {'<1'} elsif (defined $length and $add+$1>$length) {\">$length\"} else {$add+$1}/ge, @coords;\n\tmy($newstart,$newend)=@coords;\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\n\n=head2 revcom_with_features\n\n Title   : revcom_with_features\n Usage   : $revcom=Bio::SeqUtils->revcom_with_features($seq);\n Function: Like Bio::Seq::revcom, but keeps features (adjusting coordinates\n           as appropriate.\n Returns : A new sequence object\n Args    : A sequence object","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"revcom_with_features($self,$seq)"},"detail":"($self,$seq)"},{"name":"_feature_revcom","range":{"start":{"line":609,"character":0},"end":{"line":663,"character":9999}},"kind":12,"children":[{"line":610,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_feature_revcom"},{"name":"$feat","containerName":"_feature_revcom","kind":13,"line":610},{"containerName":"_feature_revcom","name":"$length","line":610,"kind":13},{"containerName":"_feature_revcom","name":"$self","kind":13,"line":611},{"name":"throw","containerName":"_feature_revcom","line":611,"kind":12},{"name":"$feat","containerName":"_feature_revcom","kind":13,"line":611},{"containerName":"_feature_revcom","name":"$feat","line":613,"kind":13},{"containerName":"_feature_revcom","name":"isa","kind":12,"line":613},{"line":614,"kind":13,"localvar":"my","containerName":"_feature_revcom","name":"@adjsubfeat","definition":"my"},{"localvar":"my","containerName":"_feature_revcom","name":"$subfeat","definition":"my","line":615,"kind":13},{"containerName":"_feature_revcom","name":"$feat","line":615,"kind":13},{"containerName":"_feature_revcom","name":"remove_SeqFeatures","line":615,"kind":12},{"name":"@adjsubfeat","containerName":"_feature_revcom","kind":13,"line":616},{"containerName":"_feature_revcom","name":"$self","line":616,"kind":13},{"line":616,"kind":12,"name":"_feature_revcom","containerName":"_feature_revcom"},{"name":"$subfeat","containerName":"_feature_revcom","line":616,"kind":13},{"containerName":"_feature_revcom","name":"$length","line":616,"kind":13},{"line":618,"kind":13,"localvar":"my","containerName":"_feature_revcom","definition":"my","name":"@loc"},{"line":619,"kind":13,"containerName":"_feature_revcom","name":"$feat"},{"name":"location","containerName":"_feature_revcom","kind":12,"line":619},{"line":619,"kind":12,"name":"each_Location","containerName":"_feature_revcom"},{"line":620,"kind":13,"localvar":"my","containerName":"_feature_revcom","definition":"my","name":"$type"},{"name":"location_type","containerName":"_feature_revcom","kind":12,"line":620},{"kind":13,"line":621,"name":"$strand","definition":"my","containerName":"_feature_revcom","localvar":"my"},{"name":"strand","containerName":"_feature_revcom","line":622,"kind":12},{"kind":13,"line":622,"name":"$strand","containerName":"_feature_revcom"},{"line":623,"kind":12,"name":"strand","containerName":"_feature_revcom"},{"containerName":"_feature_revcom","name":"$strand","kind":13,"line":623},{"line":624,"kind":13,"name":"$strand","containerName":"_feature_revcom"},{"containerName":"_feature_revcom","name":"strand","kind":12,"line":624},{"localvar":"my","containerName":"_feature_revcom","definition":"my","name":"$newend","line":625,"kind":13},{"line":625,"kind":13,"containerName":"_feature_revcom","name":"$self"},{"line":625,"kind":12,"containerName":"_feature_revcom","name":"_coord_revcom"},{"containerName":"_feature_revcom","name":"start","line":625,"kind":12},{"line":626,"kind":12,"name":"start_pos_type","containerName":"_feature_revcom"},{"kind":13,"line":627,"name":"$length","containerName":"_feature_revcom"},{"line":628,"kind":13,"localvar":"my","containerName":"_feature_revcom","definition":"my","name":"$newstart"},{"name":"$self","containerName":"_feature_revcom","line":628,"kind":13},{"name":"_coord_revcom","containerName":"_feature_revcom","line":628,"kind":12},{"containerName":"_feature_revcom","name":"end","line":628,"kind":12},{"name":"end_pos_type","containerName":"_feature_revcom","line":629,"kind":12},{"line":630,"kind":13,"containerName":"_feature_revcom","name":"$length"},{"name":"$type","containerName":"_feature_revcom","kind":13,"line":631},{"line":632,"kind":13,"containerName":"_feature_revcom","name":"@loc"},{"kind":12,"line":632,"name":"new","containerName":"_feature_revcom"},{"containerName":"_feature_revcom","name":"$newstart","line":632,"kind":13},{"containerName":"_feature_revcom","name":"$newend","line":633,"kind":13},{"name":"$strand","containerName":"_feature_revcom","kind":13,"line":634},{"line":636,"kind":13,"containerName":"_feature_revcom","name":"$type"},{"name":"@loc","containerName":"_feature_revcom","kind":13,"line":638},{"kind":12,"line":638,"name":"new","containerName":"_feature_revcom"},{"containerName":"_feature_revcom","name":"$newstart","kind":13,"line":638},{"name":"$newend","containerName":"_feature_revcom","line":639,"kind":13},{"kind":13,"line":640,"containerName":"_feature_revcom","name":"$strand"},{"line":642,"kind":13,"name":"$type","containerName":"_feature_revcom"},{"definition":"my","name":"$newfeat","containerName":"_feature_revcom","localvar":"my","kind":13,"line":645},{"containerName":"_feature_revcom","name":"new","kind":12,"line":645},{"kind":13,"line":645,"containerName":"_feature_revcom","name":"$feat"},{"containerName":"_feature_revcom","name":"primary_tag","kind":12,"line":645},{"kind":13,"line":646,"name":"$key","definition":"my","containerName":"_feature_revcom","localvar":"my"},{"kind":13,"line":646,"containerName":"_feature_revcom","name":"$feat"},{"kind":12,"line":646,"containerName":"_feature_revcom","name":"annotation"},{"kind":12,"line":646,"name":"get_all_annotation_keys","containerName":"_feature_revcom"},{"localvar":"my","containerName":"_feature_revcom","name":"$value","definition":"my","line":647,"kind":13},{"name":"$feat","containerName":"_feature_revcom","kind":13,"line":647},{"line":647,"kind":12,"name":"annotation","containerName":"_feature_revcom"},{"name":"get_Annotations","containerName":"_feature_revcom","line":647,"kind":12},{"line":647,"kind":13,"containerName":"_feature_revcom","name":"$key"},{"containerName":"_feature_revcom","name":"$newfeat","kind":13,"line":648},{"kind":12,"line":648,"name":"annotation","containerName":"_feature_revcom"},{"name":"add_Annotation","containerName":"_feature_revcom","line":648,"kind":12},{"kind":13,"line":648,"containerName":"_feature_revcom","name":"$key"},{"containerName":"_feature_revcom","name":"$value","kind":13,"line":648},{"name":"$key","definition":"my","containerName":"_feature_revcom","localvar":"my","kind":13,"line":651},{"kind":13,"line":651,"containerName":"_feature_revcom","name":"$feat"},{"line":651,"kind":12,"name":"get_all_tags","containerName":"_feature_revcom"},{"name":"$newfeat","containerName":"_feature_revcom","kind":13,"line":652},{"line":652,"kind":12,"containerName":"_feature_revcom","name":"add_tag_value"},{"line":652,"kind":13,"containerName":"_feature_revcom","name":"$key"},{"containerName":"_feature_revcom","name":"$feat","kind":13,"line":652},{"kind":12,"line":652,"name":"get_tag_values","containerName":"_feature_revcom"},{"name":"$key","containerName":"_feature_revcom","line":652,"kind":13},{"line":654,"kind":13,"name":"@loc","containerName":"_feature_revcom"},{"containerName":"_feature_revcom","name":"$newfeat","line":655,"kind":13},{"containerName":"_feature_revcom","name":"location","line":655,"kind":12},{"kind":13,"line":655,"containerName":"_feature_revcom","name":"$loc"},{"kind":13,"line":657,"definition":"my","name":"$loc","containerName":"_feature_revcom","localvar":"my"},{"containerName":"_feature_revcom","name":"new","kind":12,"line":657},{"name":"$loc","containerName":"_feature_revcom","kind":13,"line":658},{"kind":12,"line":658,"name":"add_sub_Location","containerName":"_feature_revcom"},{"name":"@loc","containerName":"_feature_revcom","line":658,"kind":13},{"name":"$newfeat","containerName":"_feature_revcom","kind":13,"line":659},{"kind":12,"line":659,"name":"location","containerName":"_feature_revcom"},{"line":659,"kind":13,"name":"$loc","containerName":"_feature_revcom"},{"name":"$newfeat","containerName":"_feature_revcom","line":661,"kind":13},{"name":"add_SeqFeature","containerName":"_feature_revcom","line":661,"kind":12},{"line":661,"kind":13,"name":"@adjsubfeat","containerName":"_feature_revcom"},{"kind":13,"line":662,"name":"$newfeat","containerName":"_feature_revcom"}],"line":609,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$length"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence\n\n\n\nsub _coord_adjust {\n    my ($self, $feat, $add, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_coord_adjust($subfeat, $add, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n        my @coords=($_->start, $_->end);\n        my $strand=$_->strand;\n\tmy $type=$_->location_type;\n        map s/(\\d+)/if ($add+$1<1) {'<1'} elsif (defined $length and $add+$1>$length) {\">$length\"} else {$add+$1}/ge, @coords;\n\tmy($newstart,$newend)=@coords;\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\n\n=head2 revcom_with_features\n\n Title   : revcom_with_features\n Usage   : $revcom=Bio::SeqUtils->revcom_with_features($seq);\n Function: Like Bio::Seq::revcom, but keeps features (adjusting coordinates\n           as appropriate.\n Returns : A new sequence object\n Args    : A sequence object\n\n\n\nsub revcom_with_features{\n    my ($self,$seq) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $revcom=$seq->revcom;\n    \n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $revcom->annotation->add_Annotation($key, $value);\n\t}\n    } \n\n    #move features\n    $revcom->add_SeqFeature(map {$self->_feature_revcom($_, $seq->length)} $seq->get_SeqFeatures);\n    return $revcom;\n}\n\n=head2 _feature_revcom\n\n  Title   : _feature_revcom\n  Usage   : my $newfeat=Bio::SeqUtils->_feature_revcom($feature, $seq->length);\n  Function: Recursive subroutine to reverse complement a feature and\n            all its subfeatures. The length of the parent sequence must be\n            specified.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the length of the parent sequence","label":"_feature_revcom($self,$feat,$length)"},"detail":"($self,$feat,$length)"},{"kind":12,"line":632,"containerName":"Location::Fuzzy","name":"Bio"},{"kind":12,"line":638,"containerName":"Location::Simple","name":"Bio"},{"containerName":"SeqFeature::Generic","name":"Bio","line":645,"kind":12},{"line":657,"kind":12,"name":"Bio","containerName":"Location::Split"},{"name":"_coord_revcom","range":{"end":{"line":675,"character":9999},"start":{"line":665,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$coord,$type,$length)","signature":{"label":"_coord_revcom($self,$coord,$type,$length)","parameters":[{"label":"$self"},{"label":"$coord"},{"label":"$type"},{"label":"$length"}],"documentation":""},"kind":12,"line":665,"children":[{"containerName":"_coord_revcom","name":"$self","definition":"my","localvar":"my","kind":13,"line":666},{"line":666,"kind":13,"containerName":"_coord_revcom","name":"$coord"},{"name":"$type","containerName":"_coord_revcom","kind":13,"line":666},{"line":666,"kind":13,"name":"$length","containerName":"_coord_revcom"},{"kind":13,"line":667,"containerName":"_coord_revcom","name":"$type"},{"line":667,"kind":13,"containerName":"_coord_revcom","name":"$type"},{"name":"$coord","containerName":"_coord_revcom","kind":13,"line":668},{"line":670,"kind":13,"containerName":"_coord_revcom","name":"$coord"},{"containerName":"_coord_revcom","name":"$coord","line":671,"kind":13},{"containerName":"_coord_revcom","name":"$coord","line":671,"kind":13},{"line":671,"kind":13,"name":"$type","containerName":"_coord_revcom"},{"kind":13,"line":672,"name":"$coord","containerName":"_coord_revcom"},{"line":672,"kind":13,"containerName":"_coord_revcom","name":"$coord"},{"name":"$type","containerName":"_coord_revcom","kind":13,"line":672},{"kind":13,"line":674,"containerName":"_coord_revcom","name":"$coord"}]},{"children":[{"definition":"my","name":"$self","containerName":"evolve","localvar":"my","kind":13,"line":703},{"containerName":"evolve","name":"$seq","line":703,"kind":13},{"containerName":"evolve","name":"$sim","line":703,"kind":13},{"name":"$rate","containerName":"evolve","line":703,"kind":13},{"line":704,"kind":13,"name":"$rate","containerName":"evolve"},{"line":706,"kind":13,"name":"$self","containerName":"evolve"},{"containerName":"evolve","name":"throw","line":706,"kind":12},{"containerName":"evolve","name":"$seq","kind":13,"line":706},{"line":708,"kind":13,"name":"$seq","containerName":"evolve"},{"kind":12,"line":708,"name":"isa","containerName":"evolve"},{"name":"$self","containerName":"evolve","kind":13,"line":710},{"kind":12,"line":710,"containerName":"evolve","name":"throw"},{"kind":13,"line":711,"containerName":"evolve","name":"$sim"},{"name":"$sim","containerName":"evolve","kind":13,"line":711},{"line":713,"kind":13,"name":"$self","containerName":"evolve"},{"containerName":"evolve","name":"warn","kind":12,"line":713},{"containerName":"evolve","name":"$sim","kind":13,"line":715},{"line":717,"kind":13,"name":"$self","containerName":"evolve"},{"containerName":"evolve","name":"throw","kind":12,"line":717},{"containerName":"evolve","name":"$seq","line":718,"kind":13},{"kind":12,"line":718,"containerName":"evolve","name":"alphabet"},{"definition":"my","name":"%changes","containerName":"evolve","localvar":"my","kind":13,"line":722},{"line":723,"kind":13,"containerName":"evolve","name":"$changes"},{"kind":13,"line":724,"containerName":"evolve","name":"$changes"},{"name":"$changes","containerName":"evolve","kind":13,"line":725},{"name":"$changes","containerName":"evolve","kind":13,"line":726},{"containerName":"evolve","definition":"my","name":"$bin_size","localvar":"my","kind":13,"line":732},{"line":732,"kind":13,"name":"$rate","containerName":"evolve"},{"localvar":"my","containerName":"evolve","definition":"my","name":"$transition","line":733,"kind":13},{"name":"$bin_size","containerName":"evolve","kind":13,"line":733},{"name":"$first_transversion","definition":"my","containerName":"evolve","localvar":"my","kind":13,"line":734},{"name":"$transition","containerName":"evolve","kind":13,"line":734},{"kind":13,"line":734,"containerName":"evolve","name":"$bin_size"},{"line":737,"kind":13,"localvar":"my","definition":"my","name":"$string","containerName":"evolve"},{"name":"$seq","containerName":"evolve","line":737,"kind":13},{"name":"seq","containerName":"evolve","kind":12,"line":737},{"containerName":"evolve","name":"$string","line":738,"kind":13},{"containerName":"evolve","definition":"my","name":"$oristring","localvar":"my","kind":13,"line":740},{"containerName":"evolve","name":"$string","line":740,"kind":13},{"kind":13,"line":741,"containerName":"evolve","name":"$length","definition":"my","localvar":"my"},{"name":"$seq","containerName":"evolve","line":741,"kind":13},{"name":"length","containerName":"evolve","line":741,"kind":12},{"localvar":"my","containerName":"evolve","name":"$loc","definition":"my","line":745,"kind":13},{"line":745,"kind":13,"containerName":"evolve","name":"$length"},{"line":749,"kind":13,"localvar":"my","containerName":"evolve","definition":"my","name":"$oldnuc"},{"containerName":"evolve","name":"$string","line":749,"kind":13},{"line":749,"kind":13,"containerName":"evolve","name":"$loc"},{"localvar":"my","definition":"my","name":"$newnuc","containerName":"evolve","line":750,"kind":13},{"containerName":"evolve","name":"$choose","definition":"my","localvar":"my","kind":13,"line":753},{"kind":13,"line":754,"containerName":"evolve","name":"$choose"},{"line":754,"kind":13,"containerName":"evolve","name":"$transition"},{"line":755,"kind":13,"containerName":"evolve","name":"$newnuc"},{"containerName":"evolve","name":"$changes","line":755,"kind":13},{"name":"$oldnuc","containerName":"evolve","kind":13,"line":755},{"containerName":"evolve","name":"$choose","line":757,"kind":13},{"line":757,"kind":13,"name":"$first_transversion","containerName":"evolve"},{"line":758,"kind":13,"containerName":"evolve","name":"$newnuc"},{"line":758,"kind":13,"containerName":"evolve","name":"$changes"},{"line":758,"kind":13,"containerName":"evolve","name":"$oldnuc"},{"kind":13,"line":760,"containerName":"evolve","name":"$newnuc"},{"containerName":"evolve","name":"$changes","kind":13,"line":760},{"line":760,"kind":13,"name":"$oldnuc","containerName":"evolve"},{"containerName":"evolve","name":"$string","kind":13,"line":764},{"name":"$loc","containerName":"evolve","line":764,"kind":13},{"kind":13,"line":764,"containerName":"evolve","name":"$newnuc"},{"containerName":"evolve","name":"$self","kind":13,"line":766},{"line":766,"kind":12,"name":"debug","containerName":"evolve"},{"containerName":"evolve","name":"$self","kind":13,"line":769},{"containerName":"evolve","name":"_get_similarity","kind":12,"line":769},{"name":"$oristring","containerName":"evolve","kind":13,"line":769},{"name":"$string","containerName":"evolve","kind":13,"line":769},{"kind":13,"line":769,"containerName":"evolve","name":"$sim"},{"containerName":"evolve","name":"$seq","line":773,"kind":13},{"name":"id","containerName":"evolve","line":773,"kind":12},{"containerName":"evolve","name":"$seq","line":774,"kind":13},{"containerName":"evolve","name":"description","kind":12,"line":774},{"kind":13,"line":776,"containerName":"evolve","name":"$string"}],"line":702,"kind":12,"signature":{"label":"evolve($self,$seq,$sim,$rate)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$sim"},{"label":"$rate"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence\n\n\n\nsub _coord_adjust {\n    my ($self, $feat, $add, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_coord_adjust($subfeat, $add, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n        my @coords=($_->start, $_->end);\n        my $strand=$_->strand;\n\tmy $type=$_->location_type;\n        map s/(\\d+)/if ($add+$1<1) {'<1'} elsif (defined $length and $add+$1>$length) {\">$length\"} else {$add+$1}/ge, @coords;\n\tmy($newstart,$newend)=@coords;\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\n\n=head2 revcom_with_features\n\n Title   : revcom_with_features\n Usage   : $revcom=Bio::SeqUtils->revcom_with_features($seq);\n Function: Like Bio::Seq::revcom, but keeps features (adjusting coordinates\n           as appropriate.\n Returns : A new sequence object\n Args    : A sequence object\n\n\n\nsub revcom_with_features{\n    my ($self,$seq) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $revcom=$seq->revcom;\n    \n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $revcom->annotation->add_Annotation($key, $value);\n\t}\n    } \n\n    #move features\n    $revcom->add_SeqFeature(map {$self->_feature_revcom($_, $seq->length)} $seq->get_SeqFeatures);\n    return $revcom;\n}\n\n=head2 _feature_revcom\n\n  Title   : _feature_revcom\n  Usage   : my $newfeat=Bio::SeqUtils->_feature_revcom($feature, $seq->length);\n  Function: Recursive subroutine to reverse complement a feature and\n            all its subfeatures. The length of the parent sequence must be\n            specified.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the length of the parent sequence\n\n\n\nsub _feature_revcom {\n    my ($self, $feat, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_feature_revcom($subfeat, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n\tmy $type=$_->location_type;\n        my $strand;\n\tif ($_->strand==-1) {$strand=1}\n\telsif ($_->strand==1) {$strand=-1}\n\telse {$strand=$_->strand}\n\tmy $newend=$self->_coord_revcom($_->start,\n\t\t\t\t\t$_->start_pos_type,\n\t\t\t\t\t$length);\n\tmy $newstart=$self->_coord_revcom($_->end,\n\t\t\t\t\t  $_->end_pos_type,\n\t\t\t\t\t  $length);\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\nsub _coord_revcom {\n    my ($self, $coord, $type, $length)=@_;\n    if ($type eq 'BETWEEN' or $type eq 'WITHIN') {\n\t$coord=~s/(\\d+)(.*)(\\d+)/$length+1-$3.$2.$length+1-$1/ge;\n    } else {\n\t$coord=~s/(\\d+)/$length+1-$1/ge;\n\t$coord='>'.$coord if $type eq 'BEFORE';\n\t$coord='<'.$coord if $type eq 'AFTER';\n    }\n    return $coord;\n}\n\n=head2 evolve\n\n  Title   : evolve\n  Usage   : my $newseq = Bio::SeqUtils->\n                evolve($seq, $similarity, $transition_transversion_rate);\n  Function: Mutates the sequence by point mutations until the similarity of\n            the new sequence has decreased to the required level. \n            Transition/transversion rate is adjustable.\n  Returns : A new Bio::PrimarySeq object\n  Args    : sequence object\n            percentage similarity (e.g. 80)\n            tr/tv rate, optional, defaults to 1 (= 1:1)\n\nSet the verbosity of the Bio::SeqUtils object to positive integer to\nsee the mutations as they happen.\n\nThis method works only on nucleotide sequences. It prints a warning if\nyou set the target similarity to be less than 25%.\n\nTransition/transversion ratio is an observed attribute of an sequence\ncomparison. We are dealing here with the transition/transversion rate\nthat we set for our model of sequence evolution."},"detail":"($self,$seq,$sim,$rate)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":777},"start":{"character":0,"line":702}},"name":"evolve"},{"name":"new","line":773,"kind":12},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":773},{"containerName":"main::","definition":"sub","detail":"($self,$oriseq,$seq)","signature":{"parameters":[{"label":"$self"},{"label":"$oriseq"},{"label":"$seq"}],"documentation":"","label":"_get_similarity($self,$oriseq,$seq)"},"kind":12,"line":780,"children":[{"localvar":"my","containerName":"_get_similarity","definition":"my","name":"$self","line":781,"kind":13},{"line":781,"kind":13,"containerName":"_get_similarity","name":"$oriseq"},{"line":781,"kind":13,"name":"$seq","containerName":"_get_similarity"},{"line":783,"kind":13,"localvar":"my","containerName":"_get_similarity","name":"$len","definition":"my"},{"kind":13,"line":783,"containerName":"_get_similarity","name":"$oriseq"},{"containerName":"_get_similarity","definition":"my","name":"$c","localvar":"my","kind":13,"line":784},{"localvar":"my","containerName":"_get_similarity","name":"$i","definition":"my","line":786,"kind":13},{"name":"$i","containerName":"_get_similarity","kind":13,"line":786},{"name":"$len","containerName":"_get_similarity","line":786,"kind":13},{"kind":13,"line":786,"containerName":"_get_similarity","name":"$i"},{"kind":13,"line":787,"containerName":"_get_similarity","name":"$c"},{"line":787,"kind":13,"name":"$oriseq","containerName":"_get_similarity"},{"kind":13,"line":787,"name":"$i","containerName":"_get_similarity"},{"name":"$seq","containerName":"_get_similarity","kind":13,"line":787},{"containerName":"_get_similarity","name":"$i","kind":13,"line":787},{"name":"$c","containerName":"_get_similarity","kind":13,"line":789},{"name":"$len","containerName":"_get_similarity","kind":13,"line":789}],"name":"_get_similarity","range":{"start":{"line":780,"character":0},"end":{"line":790,"character":9999}}}]}