{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":85},{"kind":12,"line":101,"children":[{"line":102,"kind":13,"localvar":"my","containerName":"next_seq","definition":"my","name":"$self"},{"containerName":"next_seq","definition":"my","name":"$state","localvar":"my","kind":13,"line":104},{"kind":13,"line":105,"containerName":"next_seq","name":"@comment","definition":"my","localvar":"my"},{"kind":13,"line":106,"containerName":"next_seq","definition":"my","name":"@sequence","localvar":"my"},{"localvar":"my","containerName":"next_seq","definition":"my","name":"$line","line":108,"kind":13},{"containerName":"next_seq","name":"$self","line":108,"kind":13},{"name":"_readline","containerName":"next_seq","kind":12,"line":108},{"line":109,"kind":13,"containerName":"next_seq","name":"$state"},{"name":"$state","containerName":"next_seq","line":109,"kind":13},{"kind":13,"line":110,"name":"$line","containerName":"next_seq"},{"containerName":"next_seq","name":"$line","kind":13,"line":111},{"containerName":"next_seq","name":"$line","line":113,"kind":13},{"containerName":"next_seq","name":"$state","line":114,"kind":13},{"containerName":"next_seq","name":"$state","kind":13,"line":115},{"name":"$state","containerName":"next_seq","line":117,"kind":13},{"kind":13,"line":118,"name":"@comment","containerName":"next_seq"},{"kind":13,"line":118,"name":"$line","containerName":"next_seq"},{"containerName":"next_seq","name":"$state","kind":13,"line":120},{"kind":13,"line":121,"containerName":"next_seq","name":"@sequence"},{"kind":13,"line":122,"containerName":"next_seq","name":"$line"},{"line":124,"kind":13,"containerName":"next_seq","name":"$self"},{"line":124,"kind":12,"name":"throw","containerName":"next_seq"},{"line":129,"kind":13,"containerName":"next_seq","name":"$state"},{"containerName":"next_seq","name":"$state","kind":13,"line":132},{"containerName":"next_seq","name":"$self","kind":13,"line":133},{"name":"throw","containerName":"next_seq","kind":12,"line":133},{"line":136,"kind":13,"localvar":"my","containerName":"next_seq","definition":"my","name":"$sequence"},{"kind":13,"line":136,"containerName":"next_seq","name":"@sequence"},{"line":138,"kind":13,"containerName":"next_seq","name":"$sequence"},{"containerName":"next_seq","name":"$self","line":138,"kind":13},{"line":138,"kind":12,"name":"throw","containerName":"next_seq"},{"localvar":"my","containerName":"next_seq","name":"$seq","definition":"my","line":139,"kind":13},{"line":139,"kind":12,"containerName":"next_seq","name":"new"},{"kind":13,"line":139,"name":"$sequence","containerName":"next_seq"},{"containerName":"next_seq","name":"$comment","definition":"my","localvar":"my","kind":13,"line":141},{"kind":13,"line":141,"containerName":"next_seq","name":"@comment"},{"line":143,"kind":13,"localvar":"my","containerName":"next_seq","definition":"my","name":"$anno"},{"name":"new","containerName":"next_seq","kind":12,"line":143},{"containerName":"next_seq","name":"$anno","line":144,"kind":13},{"name":"add_Annotation","containerName":"next_seq","kind":12,"line":144},{"kind":12,"line":144,"containerName":"next_seq","name":"new"},{"line":144,"kind":13,"name":"$comment","containerName":"next_seq"},{"name":"$seq","containerName":"next_seq","kind":13,"line":145},{"line":145,"kind":12,"name":"annotation","containerName":"next_seq"},{"containerName":"next_seq","name":"$anno","line":145,"kind":13},{"kind":13,"line":147,"name":"$seq","containerName":"next_seq"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":""},"name":"next_seq","range":{"end":{"character":9999,"line":148},"start":{"line":101,"character":0}}},{"line":102,"kind":2,"containerName":"Bio::Seq::Bio::Annotation::Collection::Bio::Annotation","name":"Comment"},{"kind":12,"line":139,"containerName":"Seq","name":"Bio"},{"containerName":"Annotation::Collection","name":"Bio","line":143,"kind":12},{"kind":12,"line":144,"containerName":"Annotation::Comment","name":"Bio"},{"detail":"($self,@seq)","signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n#-----------------------------------------5~------------------------------------\n# PACKAGE : Bio::SeqIO::lasergene\n# AUTHOR  : Malcolm Cook <mec@stowers-institute.org>\n# CREATED : Feb 16 1999\n# REVISION: $Id: lasergene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# _History_\n#\n# This code is based on the Bio::SeqIO::raw module with\n# the necessary minor tweaks necessary to get it to read (only)\n# Lasergene formatted sequences\n#\n# Cleaned up by Torsten Seemann June 2006\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::lasergene - Lasergene sequence file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can product Bio::Seq::RichSeq objects from Lasergene sequence files.\n\nIT DOES NOT PARSE ANY ATTIBUTE VALUE PAIRS IN THE HEADER OF THE LASERGENE FORMATTED FILE.\n\nIT DOES NOT WRITE THESE FILES EITHER.\n\n=head1 REFERENCES\n\n  https://www.dnastar.com/products/lasergene.php\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHORS\n\n  Torsten Seemann - torsten.seemann AT infotech.monash.edu.au\n  Malcolm Cook  - mec AT stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::lasergene;\n\nuse strict;\n\nuse base qw(Bio::SeqIO);\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : none\n\n\nuse Bio::Seq;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\n\nsub next_seq {\n   my ($self) = @_;\n\n   my $state = 0;\n   my @comment;\n   my @sequence;\n\n   while (my $line = $self->_readline) {\n     $state = 1 if $state == 0;\n     chomp $line;\n     next if $line =~ m/^\\s*$/; # skip blank lines\n\n     if ($line eq '^^') {  # end of a comment or sequence\n       $state++;\n       last if $state > 2; # we have comment and sequence so exit\n     }\n     elsif ($state == 1) { # another piece of comment\n       push @comment, $line;\n     }\n     elsif ($state == 2) { # another piece of sequence\n       push @sequence, $line\n     }\n     else {\n       $self->throw(\"unreachable state reached, probable bug!\");\n     }\n   }\n\n   # return quietly if there was nothing in the file\n   return if $state == 0;\n\n   # ensure we read some comment and some sequence\n   if ($state < 2) {\n     $self->throw(\"unexpected end of file\");\n   }\n\n   my $sequence = join('', @sequence);\n#   print STDERR \"SEQ=[[$sequence]]\\n\";\n   $sequence or $self->throw(\"empty sequence in lasergene file\");\n   my $seq = Bio::Seq->new(-seq => $sequence);\n\n   my $comment = join('; ', @comment);\n#   print STDERR \"COM=[[$comment]]\\n\";\n   my $anno = Bio::Annotation::Collection->new;\n   $anno->add_Annotation('comment', Bio::Annotation::Comment->new(-text => $comment) );\n   $seq->annotation($anno);\n\n   return $seq;\n}\n\n=head2 write_seq (NOT IMPLEMENTED)\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of Bio::PrimarySeqI objects","label":"write_seq($self,@seq)"},"containerName":"main::","definition":"sub","line":160,"children":[{"containerName":"write_seq","definition":"my","name":"$self","localvar":"my","kind":13,"line":161},{"kind":13,"line":161,"name":"@seq","containerName":"write_seq"},{"containerName":"write_seq","name":"$self","kind":13,"line":162},{"kind":12,"line":162,"name":"throw","containerName":"write_seq"}],"kind":12,"range":{"start":{"line":160,"character":0},"end":{"line":163,"character":9999}},"name":"write_seq"}]}