{"version":5,"vars":[{"containerName":"","name":"base","line":83,"kind":2},{"name":"_initialize","range":{"start":{"line":85,"character":0},"end":{"line":93,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"_initialize","definition":"my","name":"$self","line":86,"kind":13},{"kind":13,"line":86,"containerName":"_initialize","name":"@args"},{"kind":13,"line":87,"containerName":"_initialize","name":"$self"},{"name":"@args","containerName":"_initialize","line":87,"kind":13},{"containerName":"_initialize","name":"$self","line":88,"kind":13},{"kind":12,"line":88,"name":"sequence_factory","containerName":"_initialize"},{"line":89,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":89,"name":"sequence_factory","containerName":"_initialize"},{"line":90,"kind":12,"name":"new","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":90},{"containerName":"_initialize","name":"verbose","line":90,"kind":12}],"line":85},{"name":"SUPER","containerName":"_initialize","line":87,"kind":12},{"kind":12,"line":89,"containerName":"Seq::SeqFactory","name":"Bio"},{"range":{"start":{"character":0,"line":105},"end":{"character":9999,"line":165}},"name":"next_seq","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_seq($self,@args)"},"containerName":"main::","definition":"sub","line":105,"children":[{"kind":13,"line":106,"containerName":"next_seq","name":"$self","definition":"my","localvar":"my"},{"containerName":"next_seq","name":"@args","line":106,"kind":13},{"localvar":"my","name":"$id","definition":"my","containerName":"next_seq","line":107,"kind":13},{"name":"$type","containerName":"next_seq","kind":13,"line":107},{"line":107,"kind":13,"name":"$desc","containerName":"next_seq"},{"kind":13,"line":107,"name":"$line","containerName":"next_seq"},{"name":"$chksum","containerName":"next_seq","kind":13,"line":107},{"containerName":"next_seq","name":"$sequence","line":107,"kind":13},{"line":107,"kind":13,"name":"$date","containerName":"next_seq"},{"line":107,"kind":13,"name":"$len","containerName":"next_seq"},{"name":"$self","containerName":"next_seq","kind":13,"line":109},{"containerName":"next_seq","name":"_readline","line":109,"kind":12},{"name":"$desc","containerName":"next_seq","line":112,"kind":13},{"line":114,"kind":13,"name":"$line","containerName":"next_seq"},{"line":115,"kind":13,"name":"$chksum","containerName":"next_seq"},{"line":116,"kind":13,"name":"$type","containerName":"next_seq"},{"name":"$id","containerName":"next_seq","kind":13,"line":118},{"name":"$len","containerName":"next_seq","kind":13,"line":120},{"containerName":"next_seq","name":"$date","line":120,"kind":13},{"containerName":"next_seq","name":"$desc","line":125,"kind":13},{"containerName":"next_seq","name":"$self","kind":13,"line":127},{"containerName":"next_seq","name":"_readline","kind":12,"line":127},{"containerName":"next_seq","name":"$self","kind":13,"line":132},{"containerName":"next_seq","name":"throw","kind":12,"line":132},{"kind":13,"line":138,"name":"$sequence","containerName":"next_seq"},{"name":"$chksum","containerName":"next_seq","kind":13,"line":142},{"name":"$sequence","containerName":"next_seq","line":143,"kind":13},{"name":"$chksum","containerName":"next_seq","line":143,"kind":13},{"kind":13,"line":144,"name":"$self","containerName":"next_seq"},{"kind":12,"line":144,"name":"throw","containerName":"next_seq"},{"containerName":"next_seq","name":"$id","line":150,"kind":13},{"name":"$id","containerName":"next_seq","kind":13,"line":150},{"name":"$type","containerName":"next_seq","line":154,"kind":13},{"name":"$type","containerName":"next_seq","line":155,"kind":13},{"kind":13,"line":155,"name":"$type","containerName":"next_seq"},{"kind":13,"line":156,"name":"$type","containerName":"next_seq"},{"kind":13,"line":156,"containerName":"next_seq","name":"$type"},{"line":159,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"sequence_factory","containerName":"next_seq","kind":12,"line":159},{"containerName":"next_seq","name":"create","line":159,"kind":12},{"containerName":"next_seq","name":"$sequence","line":159,"kind":13},{"line":160,"kind":13,"containerName":"next_seq","name":"$id"},{"kind":13,"line":161,"containerName":"next_seq","name":"$desc"},{"name":"$type","containerName":"next_seq","kind":13,"line":162},{"kind":13,"line":163,"name":"$date","containerName":"next_seq"}],"kind":12},{"kind":12,"line":143,"name":"_validate_checksum"},{"children":[{"localvar":"my","containerName":"write_seq","definition":"my","name":"$self","line":179,"kind":13},{"line":179,"kind":13,"name":"@seq","containerName":"write_seq"},{"localvar":"my","containerName":"write_seq","name":"$seq","definition":"my","line":180,"kind":13},{"name":"@seq","containerName":"write_seq","line":180,"kind":13},{"name":"$self","containerName":"write_seq","kind":13,"line":181},{"line":181,"kind":12,"containerName":"write_seq","name":"throw"},{"containerName":"write_seq","name":"$seq","kind":13,"line":182},{"name":"$seq","containerName":"write_seq","kind":13,"line":182},{"name":"$seq","containerName":"write_seq","kind":13,"line":182},{"containerName":"write_seq","name":"isa","kind":12,"line":182},{"name":"$self","containerName":"write_seq","line":184,"kind":13},{"line":184,"kind":12,"containerName":"write_seq","name":"warn"},{"kind":13,"line":184,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","name":"display_id","kind":12,"line":184},{"containerName":"write_seq","name":"$seq","line":185,"kind":13},{"kind":12,"line":185,"containerName":"write_seq","name":"display_id"},{"containerName":"write_seq","name":"$str","definition":"my","localvar":"my","kind":13,"line":187},{"line":187,"kind":13,"containerName":"write_seq","name":"$seq"},{"kind":12,"line":187,"containerName":"write_seq","name":"seq"},{"localvar":"my","name":"$comment","definition":"my","containerName":"write_seq","line":188,"kind":13},{"line":188,"kind":13,"containerName":"write_seq","name":"$seq"},{"name":"desc","containerName":"write_seq","line":188,"kind":12},{"definition":"my","name":"$id","containerName":"write_seq","localvar":"my","kind":13,"line":189},{"containerName":"write_seq","name":"$seq","kind":13,"line":189},{"kind":12,"line":189,"name":"id","containerName":"write_seq"},{"definition":"my","name":"$type","containerName":"write_seq","localvar":"my","kind":13,"line":190},{"containerName":"write_seq","name":"$seq","line":190,"kind":13},{"line":190,"kind":12,"containerName":"write_seq","name":"alphabet"},{"containerName":"write_seq","name":"$timestamp","definition":"my","localvar":"my","kind":13,"line":191},{"name":"$seq","containerName":"write_seq","line":193,"kind":13},{"containerName":"write_seq","name":"can","line":193,"kind":12},{"line":194,"kind":13,"name":"$timestamp","containerName":"write_seq"},{"line":194,"kind":13,"name":"$seq","containerName":"write_seq"},{"kind":12,"line":194,"name":"get_dates","containerName":"write_seq"},{"name":"$timestamp","containerName":"write_seq","line":196,"kind":13},{"kind":13,"line":198,"containerName":"write_seq","definition":"my","name":"$sum","localvar":"my"},{"kind":13,"line":198,"name":"$offset","containerName":"write_seq"},{"containerName":"write_seq","name":"$len","kind":13,"line":198},{"name":"$i","containerName":"write_seq","kind":13,"line":198},{"line":198,"kind":13,"name":"$j","containerName":"write_seq"},{"kind":13,"line":198,"containerName":"write_seq","name":"$cnt"},{"containerName":"write_seq","name":"@out","kind":13,"line":198},{"line":200,"kind":13,"containerName":"write_seq","name":"$len"},{"line":200,"kind":13,"name":"$str","containerName":"write_seq"},{"kind":13,"line":202,"containerName":"write_seq","name":"$offset"},{"containerName":"write_seq","name":"$sum","line":204,"kind":13},{"line":204,"kind":13,"name":"$self","containerName":"write_seq"},{"name":"GCG_checksum","containerName":"write_seq","kind":12,"line":204},{"name":"$seq","containerName":"write_seq","line":204,"kind":13},{"name":"@out","containerName":"write_seq","line":207,"kind":13},{"kind":13,"line":208,"containerName":"write_seq","name":"@out"},{"name":"$i","containerName":"write_seq","kind":13,"line":211},{"name":"$j","containerName":"write_seq","kind":13,"line":212},{"name":"$j","containerName":"write_seq","line":212,"kind":13},{"kind":13,"line":212,"containerName":"write_seq","name":"$len"},{"line":213,"kind":13,"name":"$j","containerName":"write_seq"},{"line":214,"kind":13,"containerName":"write_seq","name":"$out"},{"name":"$i","containerName":"write_seq","line":214,"kind":13},{"kind":13,"line":214,"containerName":"write_seq","name":"$j"},{"containerName":"write_seq","name":"$offset","line":214,"kind":13},{"name":"$out","containerName":"write_seq","line":216,"kind":13},{"line":216,"kind":13,"containerName":"write_seq","name":"$i"},{"kind":13,"line":216,"containerName":"write_seq","name":"$str"},{"kind":13,"line":216,"name":"$j","containerName":"write_seq"},{"name":"$j","containerName":"write_seq","kind":13,"line":217},{"name":"$j","containerName":"write_seq","line":218,"kind":13},{"containerName":"write_seq","name":"$len","kind":13,"line":218},{"containerName":"write_seq","name":"$j","kind":13,"line":218},{"containerName":"write_seq","name":"$out","line":219,"kind":13},{"name":"$i","containerName":"write_seq","line":219,"kind":13},{"kind":13,"line":220,"name":"$j","containerName":"write_seq"},{"kind":13,"line":221,"name":"$out","containerName":"write_seq"},{"containerName":"write_seq","name":"$i","line":221,"kind":13},{"name":"$j","containerName":"write_seq","line":225,"kind":13},{"kind":13,"line":226,"containerName":"write_seq","name":"$out"},{"line":226,"kind":13,"containerName":"write_seq","name":"$i"},{"name":"$out","containerName":"write_seq","kind":13,"line":228},{"line":228,"kind":13,"name":"$i","containerName":"write_seq"},{"containerName":"write_seq","name":"$self","line":229,"kind":13},{"kind":12,"line":229,"containerName":"write_seq","name":"_print"},{"name":"@out","containerName":"write_seq","kind":13,"line":229},{"kind":13,"line":232,"name":"$self","containerName":"write_seq"},{"name":"flush","containerName":"write_seq","line":232,"kind":12},{"line":232,"kind":13,"containerName":"write_seq","name":"$self"},{"containerName":"write_seq","name":"_flush_on_write","line":232,"kind":12},{"containerName":"write_seq","name":"$self","kind":13,"line":232},{"name":"_fh","containerName":"write_seq","line":232,"kind":12}],"line":178,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n   my ($self,@args)    = @_;\n   my($id,$type,$desc,$line,$chksum,$sequence,$date,$len);\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## Get the descriptive info (anything before the line with '..')\n       unless( /\\.\\.$/ ) { $desc.= $_; }\n       ## Pull ID, Checksum & Type from the line containing '..'\n       /\\.\\.$/ && do     { $line = $_; chomp;\n                           if(/Check\\:\\s(\\d+)\\s/) { $chksum = $1; }\n                           if(/Type:\\s(\\w)\\s/)    { $type   = $1; }\n                           if(/(\\S+)\\s+Length/)\n\t\t\t   { $id     = $1; }\n\t\t\t   if(/Length:\\s+(\\d+)\\s+(\\S.+\\S)\\s+Type/ )\n\t\t\t   { $len = $1; $date = $2;}\n                           last;\n                         }\n   }\n   return if ( !defined $_);\n   chomp($desc);  # remove last \"\\n\"\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## This is where we grab the sequence info.\n\n       if( /\\.\\.$/ ) {\n        $self->throw(\"Looks like start of another sequence. See documentation. \");\n       }\n\n       next if($_ eq \"\\n\");       ## skip whitespace lines in formatted seq\n       s/[\\d\\s\\t]//g;            ## remove anything that is not alphabet char: preserve anything that is not explicitly specified for removal (Stefan Kirov)\n       # $_ = uc($_);               ## uppercase sequence: NO. Keep the case. HL\n       $sequence .= $_;\n   }\n   ##If we parsed out a checksum, we might as well test it\n\n   if(defined $chksum) {\n       unless(_validate_checksum(uc($sequence),$chksum)) {\n\t   $self->throw(\"Checksum failure on parsed sequence.\");\n       }\n   }\n\n   ## Remove whitespace from identifier because the constructor\n   ## will throw a warning otherwise...\n   if(defined $id) { $id =~ s/\\s+//g;}\n\n   ## Turn our parsed \"Type: N\" or \"Type: P\" (if found) into the appropriate\n   ## keyword that the constructor expects...\n   if(defined $type) {\n       if($type eq \"N\") { $type = \"dna\";      }\n       if($type eq \"P\") { $type = \"prot\";    }\n   }\n\n   return $self->sequence_factory->create(-seq  => $sequence,\n\t\t\t\t\t  -id   => $id,\n\t\t\t\t\t  -desc => $desc,\n\t\t\t\t\t  -type => $type,\n\t\t\t\t\t  -dates => [ $date ]\n\t\t\t\t\t  );\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the formatted $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of Bio::PrimarySeqI object","label":"write_seq($self,@seq)"},"detail":"($self,@seq)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":234},"start":{"character":0,"line":178}},"name":"write_seq"},{"line":211,"kind":12,"name":"out"},{"range":{"end":{"character":9999,"line":267},"start":{"character":0,"line":249}},"name":"GCG_checksum","detail":"($self,$seqobj)","signature":{"label":"GCG_checksum($self,$seqobj)","documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n   my ($self,@args)    = @_;\n   my($id,$type,$desc,$line,$chksum,$sequence,$date,$len);\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## Get the descriptive info (anything before the line with '..')\n       unless( /\\.\\.$/ ) { $desc.= $_; }\n       ## Pull ID, Checksum & Type from the line containing '..'\n       /\\.\\.$/ && do     { $line = $_; chomp;\n                           if(/Check\\:\\s(\\d+)\\s/) { $chksum = $1; }\n                           if(/Type:\\s(\\w)\\s/)    { $type   = $1; }\n                           if(/(\\S+)\\s+Length/)\n\t\t\t   { $id     = $1; }\n\t\t\t   if(/Length:\\s+(\\d+)\\s+(\\S.+\\S)\\s+Type/ )\n\t\t\t   { $len = $1; $date = $2;}\n                           last;\n                         }\n   }\n   return if ( !defined $_);\n   chomp($desc);  # remove last \"\\n\"\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## This is where we grab the sequence info.\n\n       if( /\\.\\.$/ ) {\n        $self->throw(\"Looks like start of another sequence. See documentation. \");\n       }\n\n       next if($_ eq \"\\n\");       ## skip whitespace lines in formatted seq\n       s/[\\d\\s\\t]//g;            ## remove anything that is not alphabet char: preserve anything that is not explicitly specified for removal (Stefan Kirov)\n       # $_ = uc($_);               ## uppercase sequence: NO. Keep the case. HL\n       $sequence .= $_;\n   }\n   ##If we parsed out a checksum, we might as well test it\n\n   if(defined $chksum) {\n       unless(_validate_checksum(uc($sequence),$chksum)) {\n\t   $self->throw(\"Checksum failure on parsed sequence.\");\n       }\n   }\n\n   ## Remove whitespace from identifier because the constructor\n   ## will throw a warning otherwise...\n   if(defined $id) { $id =~ s/\\s+//g;}\n\n   ## Turn our parsed \"Type: N\" or \"Type: P\" (if found) into the appropriate\n   ## keyword that the constructor expects...\n   if(defined $type) {\n       if($type eq \"N\") { $type = \"dna\";      }\n       if($type eq \"P\") { $type = \"prot\";    }\n   }\n\n   return $self->sequence_factory->create(-seq  => $sequence,\n\t\t\t\t\t  -id   => $id,\n\t\t\t\t\t  -desc => $desc,\n\t\t\t\t\t  -type => $type,\n\t\t\t\t\t  -dates => [ $date ]\n\t\t\t\t\t  );\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the formatted $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of Bio::PrimarySeqI object\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n    for my $seq (@seq) {\n\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\")\n\t    unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n        $self->warn(\"No whitespace allowed in GCG ID [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n\tmy $str         = $seq->seq;\n\tmy $comment     = $seq->desc || '';\n\tmy $id          = $seq->id;\n\tmy $type        = ( $seq->alphabet() =~ /[dr]na/i ) ? 'N' : 'P';\n\tmy $timestamp;\n\n\tif( $seq->can('get_dates') ) {\n\t    ($timestamp) = $seq->get_dates;\n\t} else {\n\t    $timestamp = localtime(time);\n\t}\n\tmy($sum,$offset,$len,$i,$j,$cnt,@out);\n\n\t$len = length($str);\n\t## Set the offset if we have any non-standard numbering going on\n\t$offset=1;\n\t# checksum\n\t$sum = $self->GCG_checksum($seq);\n\n\t#Output the sequence header info\n\tpush(@out,\"$comment\\n\");\n\tpush(@out,\"$id  Length: $len  $timestamp  Type: $type  Check: $sum  ..\\n\\n\");\n\n\t#Format the sequence\n\t$i = $#out + 1;\n\tfor($j = 0 ; $j < $len ; ) {\n\t    if( $j % 50 == 0) {\n\t\t$out[$i] = sprintf(\"%8d  \",($j+$offset)); #numbering\n\t    }\n\t    $out[$i] .= sprintf(\"%s\",substr($str,$j,10));\n\t    $j += 10;\n\t    if( $j < $len && $j % 50 != 0 ) {\n\t\t$out[$i] .= \" \";\n\t    }elsif($j % 50 == 0 ) {\n\t\t$out[$i++] .= \"\\n\\n\";\n\t    }\n\t}\n\tlocal($^W) = 0;\n\tif($j % 50 != 0 ) {\n\t    $out[$i] .= \"\\n\";\n\t}\n\t$out[$i] .= \"\\n\";\n\treturn unless $self->_print(@out);\n    }\n\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 GCG_checksum\n\n Title     : GCG_checksum\n Usage     : $cksum = $gcgio->GCG_checksum($seq);\n Function  : returns a gcg checksum for the sequence specified\n\n             This method can also be called as a class method.\n Example   :\n Returns   : a GCG checksum string\n Argument  : a Bio::PrimarySeqI implementing object","parameters":[{"label":"$self"},{"label":"$seqobj"}]},"containerName":"main::","definition":"sub","line":249,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"GCG_checksum","line":250,"kind":13},{"containerName":"GCG_checksum","name":"$seqobj","line":250,"kind":13},{"line":251,"kind":13,"localvar":"my","name":"$index","definition":"my","containerName":"GCG_checksum"},{"kind":13,"line":252,"definition":"my","name":"$checksum","containerName":"GCG_checksum","localvar":"my"},{"kind":13,"line":253,"containerName":"GCG_checksum","name":"$char","definition":"my","localvar":"my"},{"kind":13,"line":255,"name":"$seq","definition":"my","containerName":"GCG_checksum","localvar":"my"},{"name":"$seqobj","containerName":"GCG_checksum","line":255,"kind":13},{"containerName":"GCG_checksum","name":"seq","line":255,"kind":12},{"name":"$seq","containerName":"GCG_checksum","kind":13,"line":256},{"kind":13,"line":258,"name":"$char","containerName":"GCG_checksum"},{"containerName":"GCG_checksum","name":"$seq","line":258,"kind":13},{"name":"$index","containerName":"GCG_checksum","kind":13,"line":259},{"name":"$checksum","containerName":"GCG_checksum","line":260,"kind":13},{"name":"$index","containerName":"GCG_checksum","kind":13,"line":260},{"name":"$char","containerName":"GCG_checksum","line":260,"kind":13},{"line":261,"kind":13,"name":"$index","containerName":"GCG_checksum"},{"containerName":"GCG_checksum","name":"$index","kind":13,"line":262},{"containerName":"GCG_checksum","name":"$checksum","kind":13,"line":266}],"kind":12},{"kind":12,"children":[{"localvar":"my","name":"$seq","definition":"my","containerName":"_validate_checksum","line":285,"kind":13},{"kind":13,"line":285,"name":"$parsed_sum","containerName":"_validate_checksum"},{"localvar":"my","definition":"my","name":"$i","containerName":"_validate_checksum","line":286,"kind":13},{"line":286,"kind":13,"containerName":"_validate_checksum","name":"$len"},{"name":"$computed_sum","containerName":"_validate_checksum","kind":13,"line":286},{"kind":13,"line":286,"name":"$cnt","containerName":"_validate_checksum"},{"name":"$len","containerName":"_validate_checksum","line":288,"kind":13},{"kind":13,"line":288,"name":"$seq","containerName":"_validate_checksum"},{"kind":13,"line":292,"name":"$i","containerName":"_validate_checksum"},{"kind":13,"line":292,"name":"$i","containerName":"_validate_checksum"},{"kind":13,"line":292,"containerName":"_validate_checksum","name":"$len"},{"containerName":"_validate_checksum","name":"$i","kind":13,"line":292},{"name":"$cnt","containerName":"_validate_checksum","kind":13,"line":293},{"containerName":"_validate_checksum","name":"$computed_sum","line":294,"kind":13},{"kind":13,"line":294,"name":"$cnt","containerName":"_validate_checksum"},{"line":294,"kind":13,"name":"$seq","containerName":"_validate_checksum"},{"line":294,"kind":13,"name":"$i","containerName":"_validate_checksum"},{"line":295,"kind":13,"name":"$cnt","containerName":"_validate_checksum"},{"containerName":"_validate_checksum","name":"$cnt","line":295,"kind":13},{"containerName":"_validate_checksum","name":"$computed_sum","kind":13,"line":297},{"kind":13,"line":301,"name":"$parsed_sum","containerName":"_validate_checksum"},{"kind":13,"line":301,"name":"$computed_sum","containerName":"_validate_checksum"}],"line":284,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n   my ($self,@args)    = @_;\n   my($id,$type,$desc,$line,$chksum,$sequence,$date,$len);\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## Get the descriptive info (anything before the line with '..')\n       unless( /\\.\\.$/ ) { $desc.= $_; }\n       ## Pull ID, Checksum & Type from the line containing '..'\n       /\\.\\.$/ && do     { $line = $_; chomp;\n                           if(/Check\\:\\s(\\d+)\\s/) { $chksum = $1; }\n                           if(/Type:\\s(\\w)\\s/)    { $type   = $1; }\n                           if(/(\\S+)\\s+Length/)\n\t\t\t   { $id     = $1; }\n\t\t\t   if(/Length:\\s+(\\d+)\\s+(\\S.+\\S)\\s+Type/ )\n\t\t\t   { $len = $1; $date = $2;}\n                           last;\n                         }\n   }\n   return if ( !defined $_);\n   chomp($desc);  # remove last \"\\n\"\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## This is where we grab the sequence info.\n\n       if( /\\.\\.$/ ) {\n        $self->throw(\"Looks like start of another sequence. See documentation. \");\n       }\n\n       next if($_ eq \"\\n\");       ## skip whitespace lines in formatted seq\n       s/[\\d\\s\\t]//g;            ## remove anything that is not alphabet char: preserve anything that is not explicitly specified for removal (Stefan Kirov)\n       # $_ = uc($_);               ## uppercase sequence: NO. Keep the case. HL\n       $sequence .= $_;\n   }\n   ##If we parsed out a checksum, we might as well test it\n\n   if(defined $chksum) {\n       unless(_validate_checksum(uc($sequence),$chksum)) {\n\t   $self->throw(\"Checksum failure on parsed sequence.\");\n       }\n   }\n\n   ## Remove whitespace from identifier because the constructor\n   ## will throw a warning otherwise...\n   if(defined $id) { $id =~ s/\\s+//g;}\n\n   ## Turn our parsed \"Type: N\" or \"Type: P\" (if found) into the appropriate\n   ## keyword that the constructor expects...\n   if(defined $type) {\n       if($type eq \"N\") { $type = \"dna\";      }\n       if($type eq \"P\") { $type = \"prot\";    }\n   }\n\n   return $self->sequence_factory->create(-seq  => $sequence,\n\t\t\t\t\t  -id   => $id,\n\t\t\t\t\t  -desc => $desc,\n\t\t\t\t\t  -type => $type,\n\t\t\t\t\t  -dates => [ $date ]\n\t\t\t\t\t  );\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the formatted $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of Bio::PrimarySeqI object\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n    for my $seq (@seq) {\n\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\")\n\t    unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n        $self->warn(\"No whitespace allowed in GCG ID [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n\tmy $str         = $seq->seq;\n\tmy $comment     = $seq->desc || '';\n\tmy $id          = $seq->id;\n\tmy $type        = ( $seq->alphabet() =~ /[dr]na/i ) ? 'N' : 'P';\n\tmy $timestamp;\n\n\tif( $seq->can('get_dates') ) {\n\t    ($timestamp) = $seq->get_dates;\n\t} else {\n\t    $timestamp = localtime(time);\n\t}\n\tmy($sum,$offset,$len,$i,$j,$cnt,@out);\n\n\t$len = length($str);\n\t## Set the offset if we have any non-standard numbering going on\n\t$offset=1;\n\t# checksum\n\t$sum = $self->GCG_checksum($seq);\n\n\t#Output the sequence header info\n\tpush(@out,\"$comment\\n\");\n\tpush(@out,\"$id  Length: $len  $timestamp  Type: $type  Check: $sum  ..\\n\\n\");\n\n\t#Format the sequence\n\t$i = $#out + 1;\n\tfor($j = 0 ; $j < $len ; ) {\n\t    if( $j % 50 == 0) {\n\t\t$out[$i] = sprintf(\"%8d  \",($j+$offset)); #numbering\n\t    }\n\t    $out[$i] .= sprintf(\"%s\",substr($str,$j,10));\n\t    $j += 10;\n\t    if( $j < $len && $j % 50 != 0 ) {\n\t\t$out[$i] .= \" \";\n\t    }elsif($j % 50 == 0 ) {\n\t\t$out[$i++] .= \"\\n\\n\";\n\t    }\n\t}\n\tlocal($^W) = 0;\n\tif($j % 50 != 0 ) {\n\t    $out[$i] .= \"\\n\";\n\t}\n\t$out[$i] .= \"\\n\";\n\treturn unless $self->_print(@out);\n    }\n\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 GCG_checksum\n\n Title     : GCG_checksum\n Usage     : $cksum = $gcgio->GCG_checksum($seq);\n Function  : returns a gcg checksum for the sequence specified\n\n             This method can also be called as a class method.\n Example   :\n Returns   : a GCG checksum string\n Argument  : a Bio::PrimarySeqI implementing object\n\n\nsub GCG_checksum {\n    my ($self,$seqobj) = @_;\n    my $index = 0;\n    my $checksum = 0;\n    my $char;\n\n    my $seq = $seqobj->seq();\n    $seq =~ tr/a-z/A-Z/;\n\n    foreach $char ( split(/[\\.\\-]*/, $seq)) {\n\t$index++;\n\t$checksum += ($index * (unpack(\"c\",$char) || 0) );\n\tif( $index ==  57 ) {\n\t    $index = 0;\n\t}\n    }\n\n    return ($checksum % 10000);\n}\n\n=head2 _validate_checksum\n\n Title   : _validate_checksum\n Usage   : n/a - internal method\n Function: if parsed gcg sequence contains a checksum field\n         : we compare it to a value computed here on the parsed\n         : sequence. A checksum mismatch would indicate some\n         : type of parsing failure occured.\n         :\n Returns : 1 for success, 0 for failure\n Args    : string containing parsed seq, value of parsed cheksum","parameters":[{"label":"$seq"},{"label":"$parsed_sum"}],"label":"_validate_checksum($seq,$parsed_sum)"},"detail":"($seq,$parsed_sum)","name":"_validate_checksum","range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":306}}}]}