{"vars":[{"name":"vars","containerName":"","kind":2,"line":78},{"name":"base","containerName":"","line":84,"kind":2},{"kind":13,"line":86,"containerName":null,"name":"@SEQ_ID_TYPES"},{"containerName":null,"name":"%DEFAULT_SEQ_ID_TYPE","kind":13,"line":87},{"containerName":null,"name":"$WIDTH","line":89,"kind":13},{"name":"_initialize","range":{"start":{"character":0,"line":91},"end":{"line":99,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"kind":12,"line":91,"children":[{"kind":13,"line":92,"containerName":"_initialize","definition":"my","name":"$self","localvar":"my"},{"line":92,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$self","containerName":"_initialize","kind":13,"line":93},{"name":"@args","containerName":"_initialize","line":93,"kind":13},{"kind":13,"line":94,"containerName":"_initialize","name":"$width","definition":"my","localvar":"my"},{"name":"$self","containerName":"_initialize","line":94,"kind":13},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":94},{"line":94,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$width","containerName":"_initialize","kind":13,"line":95},{"name":"$self","containerName":"_initialize","line":95,"kind":13},{"line":95,"kind":12,"name":"width","containerName":"_initialize"},{"name":"$width","containerName":"_initialize","kind":13,"line":95},{"kind":13,"line":96,"name":"$self","containerName":"_initialize"},{"kind":12,"line":96,"containerName":"_initialize","name":"sequence_factory"},{"containerName":"_initialize","name":"$self","line":97,"kind":13},{"kind":12,"line":97,"name":"sequence_factory","containerName":"_initialize"},{"kind":12,"line":97,"containerName":"_initialize","name":"new"}]},{"kind":12,"line":93,"containerName":"_initialize","name":"SUPER"},{"containerName":"Seq::SeqFastaSpeedFactory","name":"Bio","line":97,"kind":12},{"name":"next_seq","range":{"start":{"line":111,"character":0},"end":{"line":180,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE","label":"next_seq($self)"},"kind":12,"line":111,"children":[{"localvar":"my","containerName":"next_seq","definition":"my","name":"$self","line":112,"kind":13},{"localvar":"my","containerName":"next_seq","definition":"my","name":"$seq","line":113,"kind":13},{"name":"$alphabet","definition":"my","containerName":"next_seq","localvar":"my","kind":13,"line":114},{"localvar":"my","containerName":"next_seq","definition":"my","name":"$entry","line":116,"kind":13},{"containerName":"next_seq","name":"$self","line":116,"kind":13},{"containerName":"next_seq","name":"_readline","kind":12,"line":116},{"line":118,"kind":13,"containerName":"next_seq","name":"$entry"},{"kind":13,"line":119,"containerName":"next_seq","name":"$entry"},{"line":120,"kind":13,"containerName":"next_seq","name":"$entry"},{"containerName":"next_seq","name":"$self","kind":13,"line":120},{"kind":12,"line":120,"containerName":"next_seq","name":"_readline"},{"line":121,"kind":13,"containerName":"next_seq","name":"$entry"},{"name":"$self","containerName":"next_seq","kind":13,"line":126},{"line":126,"kind":12,"name":"throw","containerName":"next_seq"},{"kind":13,"line":127,"name":"$entry","containerName":"next_seq"},{"containerName":"next_seq","name":"$entry","kind":13,"line":129},{"containerName":"next_seq","name":"$top","definition":"my","localvar":"my","kind":13,"line":131},{"kind":13,"line":131,"containerName":"next_seq","name":"$sequence"},{"containerName":"next_seq","name":"$entry","kind":13,"line":131},{"name":"$sequence","containerName":"next_seq","kind":13,"line":132},{"line":132,"kind":13,"containerName":"next_seq","name":"$sequence"},{"containerName":"next_seq","definition":"my","name":"$id","localvar":"my","kind":13,"line":136},{"kind":13,"line":136,"containerName":"next_seq","name":"$fulldesc"},{"name":"$top","containerName":"next_seq","kind":13,"line":137},{"line":138,"kind":13,"name":"$id","containerName":"next_seq"},{"kind":13,"line":138,"name":"$fulldesc","containerName":"next_seq"},{"line":141,"kind":13,"name":"$id","containerName":"next_seq"},{"line":141,"kind":13,"name":"$id","containerName":"next_seq"},{"containerName":"next_seq","name":"$id","line":141,"kind":13},{"line":141,"kind":13,"name":"$fulldesc","containerName":"next_seq"},{"containerName":"next_seq","name":"$sequence","line":143,"kind":13},{"kind":13,"line":143,"containerName":"next_seq","name":"$sequence"},{"kind":13,"line":146,"containerName":"next_seq","name":"$alphabet"},{"line":146,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"alphabet","containerName":"next_seq","kind":12,"line":146},{"line":147,"kind":13,"name":"$sequence","containerName":"next_seq"},{"kind":13,"line":147,"name":"$sequence","containerName":"next_seq"},{"line":148,"kind":13,"name":"$alphabet","containerName":"next_seq"},{"kind":13,"line":150,"containerName":"next_seq","name":"$alphabet"},{"name":"$seq","containerName":"next_seq","kind":13,"line":159},{"line":159,"kind":13,"name":"$self","containerName":"next_seq"},{"name":"sequence_factory","containerName":"next_seq","kind":12,"line":159},{"name":"create","containerName":"next_seq","kind":12,"line":159},{"name":"$sequence","containerName":"next_seq","line":160,"kind":13},{"kind":13,"line":161,"name":"$id","containerName":"next_seq"},{"name":"$fulldesc","containerName":"next_seq","line":165,"kind":13},{"line":166,"kind":13,"name":"$alphabet","containerName":"next_seq"},{"kind":13,"line":178,"name":"$seq","containerName":"next_seq"}]},{"range":{"end":{"line":257,"character":9999},"start":{"line":192,"character":0}},"name":"write_seq","detail":"($self,@seq)","signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE\n\n\nsub next_seq {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n    return unless my $entry = $self->_readline;\n\n    chomp($entry);\n    if ($entry =~ m/\\A\\s*\\Z/s)  { # very first one\n\treturn unless $entry = $self->_readline;\n\tchomp($entry);\n    }\n    \n    # this just checks the initial input; beyond that, due to setting $/ above,\n    # the > is part of the record separator and is removed\n    $self->throw(\"The sequence does not appear to be FASTA format \".\n        \"(lacks a descriptor line '>')\") if $. == 1 && $entry !~ /^>/;\n    \n    $entry =~ s/^>//;\n    \n    my ($top,$sequence) = split(/\\n/,$entry,2);\n    defined $sequence && $sequence =~ s/>//g;\n#    my ($top,$sequence) = $entry =~ /^>?(.+?)\\n+([^>]*)/s\n#\tor $self->throw(\"Can't parse fasta entry\");\n\n    my ($id,$fulldesc);\n    if( $top =~ /^\\s*(\\S+)\\s*(.*)/ ) {\n\t($id,$fulldesc) = ($1,$2);\n    }\n    \n    if (defined $id && $id eq '') {$id=$fulldesc;} # FIX incase no space \n                                                   # between > and name \\AE\n    defined $sequence && $sequence =~ tr/ \\t\\n\\r//d;\t# Remove whitespace\n\n    # for empty sequences we need to know the mol.type\n    $alphabet = $self->alphabet();\n    if(defined $sequence && length($sequence) == 0) {\n\tif(! defined($alphabet)) {\n\t    # let's default to dna\n\t    $alphabet = \"dna\";\n\t}\n    } else {\n\t# we don't need it really, so disable\n\t# we want to keep this if SeqIO alphabet was set by user\n\t# not sure if this could break something\n\t#$alphabet = undef;\n    }\n\n    $seq = $self->sequence_factory->create(\n\t\t\t\t\t   -seq         => $sequence,\n\t\t\t\t\t   -id          => $id,\n\t\t\t\t\t   # Ewan's note - I don't think this healthy\n\t\t\t\t\t   # but obviously to taste.\n\t\t\t\t\t   #-primary_id  => $id,\n\t\t\t\t\t   -desc        => $fulldesc,\n\t\t\t\t\t   -alphabet    => $alphabet,\n\t\t\t\t\t   -direct      => 1,\n\t\t\t\t\t   );\n\n\n\n\n    # if there wasn't one before, set the guessed type\n    #unless ( defined $alphabet ) {\n\t# don't assume that all our seqs are the same as the first one found\n\t#$self->alphabet($seq->alphabet());\n    #}\n    return $seq;\n\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: Writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of 1 or more Bio::PrimarySeqI objects","label":"write_seq($self,@seq)"},"containerName":"main::","definition":"sub","line":192,"children":[{"kind":13,"line":193,"name":"$self","definition":"my","containerName":"write_seq","localvar":"my"},{"name":"@seq","containerName":"write_seq","line":193,"kind":13},{"kind":13,"line":194,"containerName":"write_seq","definition":"my","name":"$width","localvar":"my"},{"name":"$self","containerName":"write_seq","kind":13,"line":194},{"line":194,"kind":12,"name":"width","containerName":"write_seq"},{"line":195,"kind":13,"localvar":"my","containerName":"write_seq","definition":"my","name":"$seq"},{"name":"@seq","containerName":"write_seq","line":195,"kind":13},{"containerName":"write_seq","name":"$self","kind":13,"line":196},{"name":"throw","containerName":"write_seq","kind":12,"line":196},{"line":197,"kind":13,"name":"$seq","containerName":"write_seq"},{"kind":13,"line":197,"name":"$seq","containerName":"write_seq"},{"line":197,"kind":13,"name":"$seq","containerName":"write_seq"},{"name":"isa","containerName":"write_seq","line":197,"kind":12},{"kind":13,"line":199,"containerName":"write_seq","name":"$top","definition":"my","localvar":"my"},{"name":"$id_type","definition":"my","containerName":"write_seq","localvar":"my","kind":13,"line":202},{"line":202,"kind":13,"name":"$self","containerName":"write_seq"},{"name":"preferred_id_type","containerName":"write_seq","line":202,"kind":12},{"name":"$id_type","containerName":"write_seq","kind":13,"line":203},{"name":"$top","containerName":"write_seq","line":204,"kind":13},{"kind":13,"line":204,"containerName":"write_seq","name":"$seq"},{"line":204,"kind":12,"name":"accession_number","containerName":"write_seq"},{"line":205,"kind":13,"containerName":"write_seq","name":"$id_type"},{"line":206,"kind":13,"containerName":"write_seq","name":"$top"},{"kind":13,"line":206,"containerName":"write_seq","name":"$seq"},{"kind":12,"line":206,"name":"version","containerName":"write_seq"},{"containerName":"write_seq","name":"$id_type","line":208,"kind":13},{"name":"$self","containerName":"write_seq","line":209,"kind":13},{"kind":12,"line":209,"name":"warn","containerName":"write_seq"},{"line":209,"kind":13,"name":"$seq","containerName":"write_seq"},{"line":209,"kind":12,"containerName":"write_seq","name":"display_id"},{"kind":13,"line":210,"name":"$seq","containerName":"write_seq"},{"kind":12,"line":210,"name":"display_id","containerName":"write_seq"},{"line":210,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":210,"kind":12,"containerName":"write_seq","name":"display_id"},{"name":"$top","containerName":"write_seq","kind":13,"line":211},{"containerName":"write_seq","name":"$seq","kind":13,"line":211},{"name":"display_id","containerName":"write_seq","line":211,"kind":12},{"kind":13,"line":212,"containerName":"write_seq","name":"$top"},{"kind":13,"line":212,"containerName":"write_seq","name":"$top"},{"containerName":"write_seq","name":"$self","line":213,"kind":13},{"line":213,"kind":12,"containerName":"write_seq","name":"warn"},{"containerName":"write_seq","name":"$top","line":213,"kind":13},{"kind":13,"line":214,"containerName":"write_seq","name":"$top"},{"name":"$top","containerName":"write_seq","kind":13,"line":214},{"containerName":"write_seq","name":"$id_type","line":215,"kind":13},{"line":216,"kind":13,"name":"$top","containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","line":216,"kind":13},{"line":216,"kind":12,"name":"primary_id","containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","line":219,"kind":13},{"containerName":"write_seq","name":"can","kind":12,"line":219},{"containerName":"write_seq","definition":"my","name":"$desc","localvar":"my","kind":13,"line":219},{"name":"$seq","containerName":"write_seq","kind":13,"line":219},{"name":"desc","containerName":"write_seq","kind":12,"line":219},{"name":"$desc","containerName":"write_seq","kind":13,"line":220},{"kind":13,"line":221,"name":"$top","containerName":"write_seq"},{"kind":13,"line":224,"name":"$seq","containerName":"write_seq"},{"name":"isa","containerName":"write_seq","kind":12,"line":224},{"line":225,"kind":13,"name":"$self","containerName":"write_seq"},{"name":"_print","containerName":"write_seq","line":225,"kind":12},{"line":229,"kind":13,"localvar":"my","definition":"my","name":"$buff_max","containerName":"write_seq"},{"line":230,"kind":13,"localvar":"my","definition":"my","name":"$buff_size","containerName":"write_seq"},{"name":"$buff_max","containerName":"write_seq","line":230,"kind":13},{"containerName":"write_seq","name":"$width","kind":13,"line":230},{"containerName":"write_seq","name":"$width","line":230,"kind":13},{"kind":13,"line":231,"name":"$seq_length","definition":"my","containerName":"write_seq","localvar":"my"},{"line":231,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":231,"kind":12,"name":"length","containerName":"write_seq"},{"name":"$num_chunks","definition":"my","containerName":"write_seq","localvar":"my","kind":13,"line":232},{"name":"$seq_length","containerName":"write_seq","line":232,"kind":13},{"containerName":"write_seq","name":"$buff_size","line":232,"kind":13},{"line":233,"kind":13,"localvar":"my","name":"$c","definition":"my","containerName":"write_seq"},{"kind":13,"line":233,"containerName":"write_seq","name":"$c"},{"containerName":"write_seq","name":"$num_chunks","kind":13,"line":233},{"kind":13,"line":233,"name":"$c","containerName":"write_seq"},{"kind":13,"line":234,"containerName":"write_seq","definition":"my","name":"$buff_end","localvar":"my"},{"name":"$buff_size","containerName":"write_seq","kind":13,"line":234},{"containerName":"write_seq","name":"$c","kind":13,"line":234},{"kind":13,"line":235,"name":"$buff_end","containerName":"write_seq"},{"name":"$seq_length","containerName":"write_seq","kind":13,"line":235},{"line":235,"kind":13,"name":"$buff_end","containerName":"write_seq"},{"kind":13,"line":235,"name":"$seq_length","containerName":"write_seq"},{"kind":13,"line":236,"name":"$buff","definition":"my","containerName":"write_seq","localvar":"my"},{"line":236,"kind":13,"name":"$seq","containerName":"write_seq"},{"line":236,"kind":12,"name":"subseq","containerName":"write_seq"},{"kind":13,"line":236,"containerName":"write_seq","name":"$buff_size"},{"containerName":"write_seq","name":"$c","kind":13,"line":236},{"line":236,"kind":13,"containerName":"write_seq","name":"$buff_end"},{"name":"$buff","containerName":"write_seq","kind":13,"line":237},{"containerName":"write_seq","name":"$buff","line":238,"kind":13},{"containerName":"write_seq","name":"$self","line":239,"kind":13},{"kind":12,"line":239,"containerName":"write_seq","name":"_print"},{"name":"$buff","containerName":"write_seq","line":239,"kind":13},{"name":"$self","containerName":"write_seq","line":241,"kind":13},{"name":"_print","containerName":"write_seq","kind":12,"line":241},{"kind":13,"line":245,"containerName":"write_seq","definition":"my","name":"$str","localvar":"my"},{"kind":13,"line":245,"containerName":"write_seq","name":"$seq"},{"kind":12,"line":245,"name":"seq","containerName":"write_seq"},{"name":"$str","containerName":"write_seq","kind":13,"line":246},{"containerName":"write_seq","name":"$str","kind":13,"line":246},{"line":247,"kind":13,"name":"$str","containerName":"write_seq"},{"containerName":"write_seq","name":"$str","line":249,"kind":13},{"name":"$self","containerName":"write_seq","line":251,"kind":13},{"containerName":"write_seq","name":"_print","line":251,"kind":12},{"kind":13,"line":251,"name":"$top","containerName":"write_seq"},{"line":251,"kind":13,"containerName":"write_seq","name":"$str"},{"name":"$self","containerName":"write_seq","kind":13,"line":255},{"kind":12,"line":255,"containerName":"write_seq","name":"flush"},{"kind":13,"line":255,"name":"$self","containerName":"write_seq"},{"line":255,"kind":12,"containerName":"write_seq","name":"_flush_on_write"},{"containerName":"write_seq","name":"$self","line":255,"kind":13},{"name":"_fh","containerName":"write_seq","kind":12,"line":255}],"kind":12},{"name":"width","range":{"end":{"line":277,"character":9999},"start":{"character":0,"line":271}},"kind":12,"children":[{"containerName":"width","definition":"my","name":"$self","localvar":"my","kind":13,"line":272},{"kind":13,"line":272,"containerName":"width","name":"$value"},{"name":"$value","containerName":"width","line":273,"kind":13},{"name":"$self","containerName":"width","line":274,"kind":13},{"containerName":"width","name":"$value","line":274,"kind":13},{"kind":13,"line":276,"name":"$self","containerName":"width"},{"line":276,"kind":13,"containerName":"width","name":"$WIDTH"}],"line":271,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE\n\n\nsub next_seq {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n    return unless my $entry = $self->_readline;\n\n    chomp($entry);\n    if ($entry =~ m/\\A\\s*\\Z/s)  { # very first one\n\treturn unless $entry = $self->_readline;\n\tchomp($entry);\n    }\n    \n    # this just checks the initial input; beyond that, due to setting $/ above,\n    # the > is part of the record separator and is removed\n    $self->throw(\"The sequence does not appear to be FASTA format \".\n        \"(lacks a descriptor line '>')\") if $. == 1 && $entry !~ /^>/;\n    \n    $entry =~ s/^>//;\n    \n    my ($top,$sequence) = split(/\\n/,$entry,2);\n    defined $sequence && $sequence =~ s/>//g;\n#    my ($top,$sequence) = $entry =~ /^>?(.+?)\\n+([^>]*)/s\n#\tor $self->throw(\"Can't parse fasta entry\");\n\n    my ($id,$fulldesc);\n    if( $top =~ /^\\s*(\\S+)\\s*(.*)/ ) {\n\t($id,$fulldesc) = ($1,$2);\n    }\n    \n    if (defined $id && $id eq '') {$id=$fulldesc;} # FIX incase no space \n                                                   # between > and name \\AE\n    defined $sequence && $sequence =~ tr/ \\t\\n\\r//d;\t# Remove whitespace\n\n    # for empty sequences we need to know the mol.type\n    $alphabet = $self->alphabet();\n    if(defined $sequence && length($sequence) == 0) {\n\tif(! defined($alphabet)) {\n\t    # let's default to dna\n\t    $alphabet = \"dna\";\n\t}\n    } else {\n\t# we don't need it really, so disable\n\t# we want to keep this if SeqIO alphabet was set by user\n\t# not sure if this could break something\n\t#$alphabet = undef;\n    }\n\n    $seq = $self->sequence_factory->create(\n\t\t\t\t\t   -seq         => $sequence,\n\t\t\t\t\t   -id          => $id,\n\t\t\t\t\t   # Ewan's note - I don't think this healthy\n\t\t\t\t\t   # but obviously to taste.\n\t\t\t\t\t   #-primary_id  => $id,\n\t\t\t\t\t   -desc        => $fulldesc,\n\t\t\t\t\t   -alphabet    => $alphabet,\n\t\t\t\t\t   -direct      => 1,\n\t\t\t\t\t   );\n\n\n\n\n    # if there wasn't one before, set the guessed type\n    #unless ( defined $alphabet ) {\n\t# don't assume that all our seqs are the same as the first one found\n\t#$self->alphabet($seq->alphabet());\n    #}\n    return $seq;\n\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: Writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of 1 or more Bio::PrimarySeqI objects\n\n\nsub write_seq {\n   my ($self,@seq) = @_;\n   my $width = $self->width;\n   foreach my $seq (@seq) {\n\t\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\") \n\t\t  unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n\t\tmy $top;\n\n\t\t# Allow for different ids \n\t\tmy $id_type = $self->preferred_id_type;\n\t\tif( $id_type =~ /^acc/i ) {\n\t\t\t$top = $seq->accession_number();\n\t\t\tif( $id_type =~ /vers/i ) {\n\t\t\t\t$top .= \".\" . $seq->version();\n\t\t\t}\n\t\t} elsif($id_type =~ /^displ/i ) { \n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $seq->display_id. \"]\")\n\t\t\t  if defined $seq->display_id && $seq->display_id =~ /\\s/;\n\t\t\t$top = $seq->display_id();\n\t\t\t$top = '' unless defined $top;\n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $top. \"]\")\n\t\t\t  if defined $top && $top =~ /\\s/;\n\t\t} elsif($id_type =~ /^pri/i ) {\n\t\t\t$top = $seq->primary_id();\n\t\t}\n\n\t\tif ($seq->can('desc') and my $desc = $seq->desc()) {\n\t\t\t$desc =~ s/\\n//g;\n\t\t\t$top .= \" $desc\";\n\t\t}\n\t\t\n\t\tif( $seq->isa('Bio::Seq::LargeSeqI') ) {\n\t\t  $self->_print(\">$top\\n\");\n\t\t  # for large seqs, don't call seq(), it defeats the\n\t\t  # purpose of the largeseq functionality.  instead get\n\t\t  # chunks of the seq, $width at a time\n\t\t  my $buff_max = 2000;\n\t\t  my $buff_size = int($buff_max/$width)*$width; #< buffer is even multiple of widths\n\t\t  my $seq_length = $seq->length;\n\t\t  my $num_chunks = int($seq_length/$buff_size+1);\n\t\t  for( my $c = 0; $c < $num_chunks; $c++ ) {\n\t\t    my $buff_end = $buff_size*($c+1);\n\t\t    $buff_end = $seq_length if $buff_end > $seq_length;\n\t\t    my $buff = $seq->subseq($buff_size*$c+1,$buff_end);\n\t\t    if($buff) {\n\t\t      $buff =~ s/(.{1,$width})/$1\\n/g;\n\t\t      $self->_print($buff);\n\t\t    } else {\n\t\t      $self->_print(\"\\n\");\n\t\t    }\n\t\t  }\n\t\t} else {\n\t\t  my $str = $seq->seq;\n\t\t  if(defined $str && length($str) > 0) {\n\t\t    $str =~ s/(.{1,$width})/$1\\n/g;\n\t\t  } else {\n\t\t    $str = \"\\n\";\n\t\t  }\n\t\t  $self->_print (\">\",$top,\"\\n\",$str) or return;\n\t\t}\n   }\n\n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 width\n\n Title   : width\n Usage   : $obj->width($newval)\n Function: Get/Set the line width for FASTA output\n Returns : value of width\n Args    : newvalue (optional)","label":"width($self,$value)"},"detail":"($self,$value)"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"preferred_id_type","line":295,"kind":13},{"line":295,"kind":13,"name":"$type","containerName":"preferred_id_type"},{"kind":13,"line":296,"containerName":"preferred_id_type","name":"$type"},{"line":297,"kind":13,"containerName":"preferred_id_type","name":"$type"},{"name":"@SEQ_ID_TYPES","containerName":"preferred_id_type","kind":13,"line":297},{"containerName":"preferred_id_type","name":"$self","kind":13,"line":298},{"kind":12,"line":298,"name":"throw","containerName":"preferred_id_type"},{"containerName":"preferred_id_type","name":"$self","kind":13,"line":301},{"kind":13,"line":301,"containerName":"preferred_id_type","name":"$type"},{"kind":13,"line":304,"containerName":"preferred_id_type","name":"$self"},{"line":304,"kind":13,"name":"$DEFAULT_SEQ_ID_TYPE","containerName":"preferred_id_type"}],"line":294,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE\n\n\nsub next_seq {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n    return unless my $entry = $self->_readline;\n\n    chomp($entry);\n    if ($entry =~ m/\\A\\s*\\Z/s)  { # very first one\n\treturn unless $entry = $self->_readline;\n\tchomp($entry);\n    }\n    \n    # this just checks the initial input; beyond that, due to setting $/ above,\n    # the > is part of the record separator and is removed\n    $self->throw(\"The sequence does not appear to be FASTA format \".\n        \"(lacks a descriptor line '>')\") if $. == 1 && $entry !~ /^>/;\n    \n    $entry =~ s/^>//;\n    \n    my ($top,$sequence) = split(/\\n/,$entry,2);\n    defined $sequence && $sequence =~ s/>//g;\n#    my ($top,$sequence) = $entry =~ /^>?(.+?)\\n+([^>]*)/s\n#\tor $self->throw(\"Can't parse fasta entry\");\n\n    my ($id,$fulldesc);\n    if( $top =~ /^\\s*(\\S+)\\s*(.*)/ ) {\n\t($id,$fulldesc) = ($1,$2);\n    }\n    \n    if (defined $id && $id eq '') {$id=$fulldesc;} # FIX incase no space \n                                                   # between > and name \\AE\n    defined $sequence && $sequence =~ tr/ \\t\\n\\r//d;\t# Remove whitespace\n\n    # for empty sequences we need to know the mol.type\n    $alphabet = $self->alphabet();\n    if(defined $sequence && length($sequence) == 0) {\n\tif(! defined($alphabet)) {\n\t    # let's default to dna\n\t    $alphabet = \"dna\";\n\t}\n    } else {\n\t# we don't need it really, so disable\n\t# we want to keep this if SeqIO alphabet was set by user\n\t# not sure if this could break something\n\t#$alphabet = undef;\n    }\n\n    $seq = $self->sequence_factory->create(\n\t\t\t\t\t   -seq         => $sequence,\n\t\t\t\t\t   -id          => $id,\n\t\t\t\t\t   # Ewan's note - I don't think this healthy\n\t\t\t\t\t   # but obviously to taste.\n\t\t\t\t\t   #-primary_id  => $id,\n\t\t\t\t\t   -desc        => $fulldesc,\n\t\t\t\t\t   -alphabet    => $alphabet,\n\t\t\t\t\t   -direct      => 1,\n\t\t\t\t\t   );\n\n\n\n\n    # if there wasn't one before, set the guessed type\n    #unless ( defined $alphabet ) {\n\t# don't assume that all our seqs are the same as the first one found\n\t#$self->alphabet($seq->alphabet());\n    #}\n    return $seq;\n\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: Writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of 1 or more Bio::PrimarySeqI objects\n\n\nsub write_seq {\n   my ($self,@seq) = @_;\n   my $width = $self->width;\n   foreach my $seq (@seq) {\n\t\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\") \n\t\t  unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n\t\tmy $top;\n\n\t\t# Allow for different ids \n\t\tmy $id_type = $self->preferred_id_type;\n\t\tif( $id_type =~ /^acc/i ) {\n\t\t\t$top = $seq->accession_number();\n\t\t\tif( $id_type =~ /vers/i ) {\n\t\t\t\t$top .= \".\" . $seq->version();\n\t\t\t}\n\t\t} elsif($id_type =~ /^displ/i ) { \n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $seq->display_id. \"]\")\n\t\t\t  if defined $seq->display_id && $seq->display_id =~ /\\s/;\n\t\t\t$top = $seq->display_id();\n\t\t\t$top = '' unless defined $top;\n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $top. \"]\")\n\t\t\t  if defined $top && $top =~ /\\s/;\n\t\t} elsif($id_type =~ /^pri/i ) {\n\t\t\t$top = $seq->primary_id();\n\t\t}\n\n\t\tif ($seq->can('desc') and my $desc = $seq->desc()) {\n\t\t\t$desc =~ s/\\n//g;\n\t\t\t$top .= \" $desc\";\n\t\t}\n\t\t\n\t\tif( $seq->isa('Bio::Seq::LargeSeqI') ) {\n\t\t  $self->_print(\">$top\\n\");\n\t\t  # for large seqs, don't call seq(), it defeats the\n\t\t  # purpose of the largeseq functionality.  instead get\n\t\t  # chunks of the seq, $width at a time\n\t\t  my $buff_max = 2000;\n\t\t  my $buff_size = int($buff_max/$width)*$width; #< buffer is even multiple of widths\n\t\t  my $seq_length = $seq->length;\n\t\t  my $num_chunks = int($seq_length/$buff_size+1);\n\t\t  for( my $c = 0; $c < $num_chunks; $c++ ) {\n\t\t    my $buff_end = $buff_size*($c+1);\n\t\t    $buff_end = $seq_length if $buff_end > $seq_length;\n\t\t    my $buff = $seq->subseq($buff_size*$c+1,$buff_end);\n\t\t    if($buff) {\n\t\t      $buff =~ s/(.{1,$width})/$1\\n/g;\n\t\t      $self->_print($buff);\n\t\t    } else {\n\t\t      $self->_print(\"\\n\");\n\t\t    }\n\t\t  }\n\t\t} else {\n\t\t  my $str = $seq->seq;\n\t\t  if(defined $str && length($str) > 0) {\n\t\t    $str =~ s/(.{1,$width})/$1\\n/g;\n\t\t  } else {\n\t\t    $str = \"\\n\";\n\t\t  }\n\t\t  $self->_print (\">\",$top,\"\\n\",$str) or return;\n\t\t}\n   }\n\n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 width\n\n Title   : width\n Usage   : $obj->width($newval)\n Function: Get/Set the line width for FASTA output\n Returns : value of width\n Args    : newvalue (optional)\n\n\n\nsub width{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'width'} = $value;\n    }\n    return $self->{'width'} || $WIDTH;\n}\n\n=head2 preferred_id_type\n\n Title   : preferred_id_type\n Usage   : $obj->preferred_id_type('accession')\n Function: Get/Set the preferred type of identifier to use in the \">ID\" position\n           for FASTA output.\n Returns : string, one of values defined in @Bio::SeqIO::fasta::SEQ_ID_TYPES.\n           Default = $Bio::SeqIO::fasta::DEFAULT_SEQ_ID_TYPE ('display').\n Args    : string when setting. This must be one of values defined in \n           @Bio::SeqIO::fasta::SEQ_ID_TYPES. Allowable values:\n           accession, accession.version, display, primary\n Throws  : fatal exception if the supplied id type is not in @SEQ_ID_TYPES.","label":"preferred_id_type($self,$type)"},"detail":"($self,$type)","name":"preferred_id_type","range":{"end":{"character":9999,"line":305},"start":{"character":0,"line":294}}}],"version":5}