{"version":5,"vars":[{"line":70,"kind":2,"containerName":"","name":"vars"},{"name":"@ISA","containerName":null,"kind":13,"line":76},{"kind":2,"line":76,"name":"SeqFactory","containerName":"strict::Bio::SeqIO::Bio::Seq"},{"name":"BEGIN","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":78},"end":{"character":9999,"line":86}},"kind":12,"children":[{"containerName":"BEGIN","name":"$READ_AVAIL","kind":13,"line":81},{"containerName":"BEGIN","name":"@ISA","kind":13,"line":83},{"line":84,"kind":13,"containerName":"BEGIN","name":"$READ_AVAIL"}],"line":78},{"line":80,"kind":12,"containerName":"SeqIO::staden::read","name":"Bio"},{"name":"_initialize","range":{"start":{"character":0,"line":88},"end":{"line":99,"character":9999}},"kind":12,"children":[{"line":89,"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","definition":"my"},{"name":"@args","containerName":"_initialize","line":89,"kind":13},{"kind":13,"line":90,"containerName":"_initialize","name":"$self"},{"name":"@args","containerName":"_initialize","line":90,"kind":13},{"name":"$self","containerName":"_initialize","line":91,"kind":13},{"line":91,"kind":12,"name":"sequence_factory","containerName":"_initialize"},{"kind":13,"line":92,"containerName":"_initialize","name":"$self"},{"line":92,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"containerName":"_initialize","name":"new","line":92,"kind":12},{"containerName":"_initialize","name":"$self","line":92,"kind":13},{"kind":12,"line":92,"containerName":"_initialize","name":"verbose"},{"kind":13,"line":94,"name":"$READ_AVAIL","containerName":"_initialize"},{"kind":12,"line":95,"containerName":"_initialize","name":"throw"}],"line":88,"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)"},{"containerName":"_initialize","name":"SUPER","kind":12,"line":90},{"name":"Bio","containerName":"Seq::SeqFactory","line":92,"kind":12},{"kind":12,"line":95,"name":"Bio","containerName":"Root::Root"},{"children":[{"localvar":"my","containerName":"next_seq","definition":"my","name":"$self","line":113,"kind":13},{"containerName":"next_seq","name":"$seq","definition":"my","localvar":"my","kind":13,"line":115},{"line":115,"kind":13,"containerName":"next_seq","name":"$id"},{"kind":13,"line":115,"name":"$desc","containerName":"next_seq"},{"name":"$qual","containerName":"next_seq","kind":13,"line":115},{"kind":13,"line":115,"name":"$self","containerName":"next_seq"},{"line":115,"kind":12,"name":"read_trace","containerName":"next_seq"},{"name":"$self","containerName":"next_seq","kind":13,"line":115},{"kind":12,"line":115,"containerName":"next_seq","name":"_fh"},{"name":"$seq","containerName":"next_seq","line":118,"kind":13},{"kind":13,"line":118,"name":"$self","containerName":"next_seq"},{"name":"sequence_factory","containerName":"next_seq","line":118,"kind":12},{"kind":12,"line":118,"containerName":"next_seq","name":"create"},{"kind":13,"line":118,"name":"$seq","containerName":"next_seq"},{"containerName":"next_seq","name":"$id","kind":13,"line":119},{"kind":13,"line":120,"name":"$id","containerName":"next_seq"},{"line":121,"kind":13,"containerName":"next_seq","name":"$desc"},{"kind":13,"line":124,"containerName":"next_seq","name":"$qual"},{"kind":13,"line":125,"name":"$seq","containerName":"next_seq"}],"line":111,"kind":12,"signature":{"label":"next_seq($self)","documentation":"1;\n# $Id: alf.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::alf\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::alf - alf trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from alf trace\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::alf;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));      \n  }\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":111,"character":0},"end":{"line":126,"character":9999}},"name":"next_seq"},{"name":"write_seq","range":{"end":{"character":9999,"line":149},"start":{"line":139,"character":0}},"kind":12,"line":139,"children":[{"definition":"my","name":"$self","containerName":"write_seq","localvar":"my","kind":13,"line":140},{"kind":13,"line":140,"containerName":"write_seq","name":"@seq"},{"line":142,"kind":13,"localvar":"my","name":"$fh","definition":"my","containerName":"write_seq"},{"kind":13,"line":142,"containerName":"write_seq","name":"$self"},{"kind":12,"line":142,"containerName":"write_seq","name":"_fh"},{"kind":13,"line":143,"definition":"my","name":"$seq","containerName":"write_seq","localvar":"my"},{"containerName":"write_seq","name":"@seq","kind":13,"line":143},{"name":"$self","containerName":"write_seq","line":144,"kind":13},{"containerName":"write_seq","name":"write_trace","line":144,"kind":12},{"kind":13,"line":144,"containerName":"write_seq","name":"$fh"},{"kind":13,"line":144,"name":"$seq","containerName":"write_seq"},{"name":"$self","containerName":"write_seq","kind":13,"line":147},{"containerName":"write_seq","name":"flush","line":147,"kind":12},{"containerName":"write_seq","name":"$self","kind":13,"line":147},{"line":147,"kind":12,"name":"_flush_on_write","containerName":"write_seq"},{"containerName":"write_seq","name":"$self","kind":13,"line":147},{"kind":12,"line":147,"containerName":"write_seq","name":"_fh"}],"containerName":"main::","definition":"sub","detail":"($self,@seq)","signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: alf.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::alf\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::alf - alf trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from alf trace\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::alf;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));      \n  }\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    my ($seq, $id, $desc, $qual) = $self->read_trace($self->_fh, 'alf');\n\n    # create the seq object\n    $seq = $self->sequence_factory->create(-seq        => $seq,\n\t\t\t\t\t   -id         => $id,\n\t\t\t\t\t   -primary_id => $id,\n\t\t\t\t\t   -desc       => $desc,\n\t\t\t\t\t   -alphabet   => 'DNA',\n\t\t\t\t\t   -qual       => $qual\n\t\t\t\t\t   );\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object","label":"write_seq($self,@seq)"}}]}